/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnFilterSaveManager;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.dialog.ColumnFilterArchiveDialog;
import docking.widgets.table.constraint.dialog.ColumnFilterDialogModel;
import docking.widgets.table.constraint.dialog.ColumnFilterPanel;
import docking.widgets.table.constraint.dialog.DialogFilterRow;
import docking.widgets.table.constraint.dialog.FilterPanelLayout;
import docking.widgets.table.constraint.dialog.TableFilterDialogModelListener;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import ghidra.generic.function.Callback;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import org.apache.commons.lang3.StringUtils;
import resources.ResourceManager;

public class ColumnFilterDialog<R>
extends DialogComponentProvider
implements TableFilterDialogModelListener {
    private final ColumnFilterDialogModel<R> filterModel;
    private JPanel filterPanelContainer;
    private List<ColumnFilterPanel> filterPanels = new ArrayList<ColumnFilterPanel>();
    private Callback closeCallback;
    private GTableFilterPanel<R> gTableFilterPanel;
    private JPanel bottomPanel;
    private JTable table;
    private RowObjectFilterModel<R> tableModel;

    public ColumnFilterDialog(GTableFilterPanel<R> gTableFilterPanel, JTable table, RowObjectFilterModel<R> tableModel) {
        super("Table Column Filters", false);
        this.gTableFilterPanel = gTableFilterPanel;
        this.table = table;
        this.tableModel = tableModel;
        ColumnBasedTableFilter<R> columnTableFilter = gTableFilterPanel.getColumnTableFilter();
        this.filterModel = new ColumnFilterDialogModel<R>(tableModel, table.getColumnModel(), columnTableFilter);
        this.filterModel.addListener(this);
        this.setHelpLocation(new HelpLocation("Trees", "Column_Filters"));
        this.addWorkPanel(this.buildMainPanel());
        this.addApplyButton();
        this.applyButton.setText("Apply Filter");
        this.addDismissButton();
        this.addClearFilterButton();
        this.addToolbarActions();
        this.setPreferredSize(1000, 500);
        this.updateStatus();
    }

    private void addClearFilterButton() {
        JButton button = new JButton("Clear Filter");
        button.addActionListener(e -> this.clearFilter());
        button.setToolTipText("Clears any applied column filter and clears the dialog.");
        this.addButton(button);
    }

    String getTableName() {
        return this.tableModel.getName();
    }

    private void addToolbarActions() {
        DockingAction saveAction = new DockingAction("Save", "Filter"){

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                return !ColumnFilterDialog.this.filterModel.getFilterRows().isEmpty() && ColumnFilterDialog.this.filterModel.isValid();
            }

            @Override
            public void actionPerformed(ActionContext context) {
                ColumnFilterDialog.this.saveFilter();
            }
        };
        saveAction.setHelpLocation(new HelpLocation("Trees", "Save_Filter"));
        saveAction.setDescription("Save Filter");
        saveAction.setToolBarData(new ToolBarData(ResourceManager.loadImage((String)"images/disk.png")));
        this.addAction(saveAction);
        DockingAction loadAction = new DockingAction("Load", "Filter"){

            @Override
            public void actionPerformed(ActionContext context) {
                ColumnFilterDialog.this.loadFilter();
            }
        };
        loadAction.setDescription("Load Filter");
        loadAction.setHelpLocation(new HelpLocation("Trees", "Load_Filter"));
        loadAction.setToolBarData(new ToolBarData(ResourceManager.loadImage((String)"images/openSmallFolder.png")));
        this.addAction(loadAction);
    }

    private void saveFilter() {
        ColumnFilterSaveManager filterSaveManager = new ColumnFilterSaveManager(this.gTableFilterPanel, this.table, this.tableModel, this.filterModel.getDataSource());
        ColumnBasedTableFilter<R> filter = this.filterModel.getTableColumnFilter();
        String defaultName = new Date().toString();
        InputDialog dialog = new InputDialog("Save Filter", "Filter Name: ", defaultName, d -> {
            String name = d.getValue();
            if (StringUtils.isBlank((CharSequence)name)) {
                d.setStatusText("Please enter a name!");
                return false;
            }
            if (filterSaveManager.containsFilterWithName(name)) {
                d.setStatusText("Filter already exists with that name!");
                return false;
            }
            return true;
        });
        DockingWindowManager.showDialog(this.getComponent(), dialog);
        if (dialog.isCanceled()) {
            return;
        }
        String filterName = dialog.getValue().trim();
        filter = filter.copy();
        filter.setName(filterName);
        filterSaveManager.addFilter(filter);
        filterSaveManager.save();
        this.gTableFilterPanel.updateSavedFilters(filter, true);
        this.filterModel.setFilter(filter);
    }

    private void loadFilter() {
        ColumnFilterSaveManager<R> filterSaveManager = new ColumnFilterSaveManager<R>(this.gTableFilterPanel, this.table, this.tableModel, this.filterModel.getDataSource());
        List<ColumnBasedTableFilter<R>> savedFilters = filterSaveManager.getSavedFilters();
        if (savedFilters.isEmpty()) {
            Msg.showInfo((Object)this, (Component)this.getComponent(), (String)"No Saved Filters", (Object)"No saved filters exist for this table.");
            return;
        }
        ColumnFilterArchiveDialog<R> archiveDialog = new ColumnFilterArchiveDialog<R>(this, filterSaveManager, this.getTableName());
        DockingWindowManager.showDialog(this.getComponent(), archiveDialog);
        ColumnBasedTableFilter<R> selectedFilter = archiveDialog.getSelectedColumnFilter();
        if (selectedFilter != null) {
            this.filterModel.setFilter(selectedFilter);
        }
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildFilterPanelContainer(), "Center");
        return panel;
    }

    private JComponent buildFilterPanelContainer() {
        this.filterPanelContainer = new JPanel((LayoutManager)new VerticalLayout(4));
        this.filterPanelContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(this.filterPanelContainer);
        jScrollPane.setColumnHeaderView(this.buildHeaderPanel());
        this.loadFilterRows();
        return jScrollPane;
    }

    private JComponent getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new BorderLayout());
            JPanel innerPanel = new JPanel((LayoutManager)new VerticalLayout(3));
            JButton addAndConditionButton = new JButton("Add AND condition", ResourceManager.loadImage((String)"images/Plus.png"));
            addAndConditionButton.addActionListener(e -> this.addFilterCondition(LogicOperation.AND));
            addAndConditionButton.setEnabled(true);
            JButton addOrConditionButton = new JButton("Add  OR   condition", ResourceManager.loadImage((String)"images/Plus.png"));
            addOrConditionButton.setHorizontalAlignment(2);
            addOrConditionButton.addActionListener(e -> this.addFilterCondition(LogicOperation.OR));
            addOrConditionButton.setEnabled(true);
            innerPanel.add(addAndConditionButton);
            innerPanel.add(addOrConditionButton);
            this.bottomPanel.add((Component)innerPanel, "East");
        }
        return this.bottomPanel;
    }

    private void updateDialogTitle() {
        StringBuilder sb = new StringBuilder();
        if (this.tableModel.getName() != null) {
            sb.append(this.tableModel.getName()).append(" ");
        }
        sb.append("Column Filter");
        ColumnBasedTableFilter<R> filter = this.filterModel.getTableColumnFilter();
        if (filter != null && filter.getName() != null) {
            sb.append(": ").append(filter.getName());
        }
        this.setTitle(sb.toString());
    }

    @Override
    public void close() {
        if (this.canClose()) {
            super.close();
        }
    }

    private boolean canClose() {
        if (!this.filterModel.hasUnappliedChanges()) {
            return true;
        }
        if (this.dialogHasValidFilter()) {
            return this.promptToApplyFilter();
        }
        return this.promptToCloseAndLoseChanges();
    }

    private boolean promptToApplyFilter() {
        int choice = OptionDialog.showOptionDialog(null, "Unapplied Changes", "You have unapplied changes that will be lost!\nDo you want to apply them before you exit?", "Apply Changes", "Discard Changes", 3);
        if (choice == 1) {
            this.applyFilter();
        }
        return choice != 0;
    }

    private boolean promptToCloseAndLoseChanges() {
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, "Unapplied Changes", "Exit dialog and discard changes?", "Discard Changes");
        return choice != 0;
    }

    private boolean dialogHasValidFilter() {
        return this.filterModel.getTableColumnFilter() != null;
    }

    @Override
    protected void dialogClosed() {
        this.filterModel.dispose();
        if (this.closeCallback != null) {
            this.closeCallback.call();
        }
    }

    @Override
    protected void okCallback() {
        this.applyFilter();
        this.close();
    }

    @Override
    protected void applyCallback() {
        this.applyFilter();
    }

    private void clearFilter() {
        this.gTableFilterPanel.setColumnTableFilter(null);
        this.filterModel.clear();
        this.updateStatus();
    }

    private void applyFilter() {
        ColumnBasedTableFilter<R> tableColumnFilter = this.filterModel.getTableColumnFilter();
        this.filterModel.setCurrentlyAppliedFilter(tableColumnFilter);
        this.gTableFilterPanel.setColumnTableFilter(tableColumnFilter);
    }

    private void loadFilterRows() {
        this.filterPanelContainer.removeAll();
        this.filterPanels.clear();
        List<DialogFilterRow> filterRows = this.filterModel.getFilterRows();
        for (int i = 0; i < filterRows.size(); ++i) {
            DialogFilterRow filterRow = filterRows.get(i);
            ColumnFilterPanel panel = new ColumnFilterPanel(filterRow);
            if (i != 0) {
                this.filterPanelContainer.add(this.createLogicalOperationLabel(filterRow.getLogicOperation()));
            }
            this.filterPanelContainer.add(panel);
            this.filterPanels.add(panel);
        }
        this.filterPanelContainer.add(this.getBottomPanel());
        this.filterPanelContainer.getParent().validate();
    }

    private Component createLogicalOperationLabel(LogicOperation op) {
        JLabel jLabel = new JLabel("<" + op + ">", 0);
        jLabel.setForeground(Color.GRAY);
        return jLabel;
    }

    private JComponent buildHeaderPanel() {
        JPanel headerPanel = new JPanel(new FilterPanelLayout(200, 0));
        headerPanel.add(new JLabel("Table Column", 0));
        headerPanel.add(new JLabel("Filter", 0));
        headerPanel.add(new JLabel("Filter Value", 0));
        headerPanel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY.brighter().brighter()), BorderFactory.createEmptyBorder(4, 0, 4, 0)));
        return headerPanel;
    }

    private void addFilterCondition(LogicOperation logicalOperation) {
        this.filterModel.createFilterRow(logicalOperation);
        this.scrollFilterPanelToBottom();
    }

    private void scrollFilterPanelToBottom() {
        Container filterPanelParent = SwingUtilities.getUnwrappedParent(this.filterPanelContainer);
        if (filterPanelParent instanceof JViewport) {
            Rectangle filterPanelBounds = this.filterPanelContainer.getBounds();
            Rectangle bottomOfContainer = new Rectangle(filterPanelBounds.x, filterPanelBounds.height, filterPanelBounds.width, 1);
            ((JViewport)filterPanelParent).scrollRectToVisible(bottomOfContainer);
        }
    }

    void updateStatus() {
        this.setStatusText(this.getStatusMessage());
        boolean isValid = this.filterModel.isValid();
        this.setOkEnabled(isValid);
        this.setApplyEnabled(isValid);
        ActionContext context = new ActionContext();
        for (DockingActionIf action : this.getActions()) {
            action.setEnabled(action.isEnabledForContext(context));
        }
        this.updateDialogTitle();
    }

    public void filterChanged(ColumnBasedTableFilter<R> newFilter) {
        int result;
        if (Objects.equals(newFilter, this.filterModel.getTableColumnFilter())) {
            return;
        }
        this.getComponent().requestFocus();
        if (this.filterModel.hasUnappliedChanges() && (result = OptionDialog.showYesNoDialog(this.getComponent(), "Filter Changed", "The filter has been changed externally.\n Do you want to update this editor and lose your current changes?")) == 2) {
            return;
        }
        this.filterModel.setFilter(newFilter);
    }

    private String getStatusMessage() {
        if (this.filterModel.isEmpty()) {
            return "Please add a filter condition!";
        }
        if (!this.filterModel.isValid()) {
            return "One or more filter values are invalid!";
        }
        return "";
    }

    public void setCloseCallback(Callback callback) {
        this.closeCallback = callback;
    }

    @Override
    public void editorValueChanged(ColumnConstraintEditor<?> editor) {
        this.updateStatus();
    }

    @Override
    public void structureChanged() {
        this.loadFilterRows();
        this.updateStatus();
    }

    void filterRemoved(ColumnBasedTableFilter<R> filter) {
        this.gTableFilterPanel.updateSavedFilters(filter, false);
    }
}

