/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

abstract class CompositeDB
extends DataTypeDB
implements Composite {
    protected static final int UNALIGNED = -1;
    protected static final int ALIGNED_NO_PACKING = 0;
    protected static final int MACHINE_ALIGNED = -1;
    protected static final int DEFAULT_ALIGNED = 0;
    protected CompositeDBAdapter compositeAdapter;
    protected ComponentDBAdapter componentAdapter;

    CompositeDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, Record record) {
        super(dataMgr, cache, record);
        this.compositeAdapter = compositeAdapter;
        this.componentAdapter = componentAdapter;
        this.initialize();
    }

    protected abstract void initialize();

    @Override
    protected String doGetName() {
        return this.record.getString(0);
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent add(DataType dataType) {
        this.lock.acquire();
        try {
            DataTypeComponent addedComponent;
            this.checkDeleted();
            int length = dataType.getLength();
            if (dataType.getLength() < 1) {
                throw new IllegalArgumentException("Minimum data type length is 1 byte");
            }
            DataTypeComponent dataTypeComponent = addedComponent = this.add(dataType, length, null, null);
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected boolean refresh() {
        try {
            Record rec = this.compositeAdapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                this.initialize();
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public void setDescription(String desc) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setString(1, desc);
            try {
                this.compositeAdapter.updateRecord(this.record, true);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getDescription() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String s = this.record.getString(1);
            String string = s == null ? "" : s;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isDynamicallySized() {
        return this.isInternallyAligned();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length) {
        return this.add(dataType, length, null, null);
    }

    @Override
    public DataTypeComponent add(DataType dataType, String fieldName, String comment) {
        return this.add(dataType, dataType.getLength(), fieldName, comment);
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length) {
        return this.insert(ordinal, dataType, length, null, null);
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType) {
        return this.insert(ordinal, dataType, dataType.getLength(), null, null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    protected void componentChanged(DataTypeComponent component) {
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(3, categoryID);
        this.compositeAdapter.updateRecord(this.record, false);
    }

    @Override
    public boolean isPartOf(DataType dataTypeOfInterest) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = DataTypeUtilities.isSecondPartOfFirst(this, dataTypeOfInterest);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    protected void checkAncestry(DataType dataType) {
        if (this.equals(dataType)) {
            throw new IllegalArgumentException("Data type " + this.getDisplayName() + " can't contain itself.");
        }
        if (DataTypeUtilities.isSecondPartOfFirst(dataType, this)) {
            throw new IllegalArgumentException("Data type " + dataType.getDisplayName() + " has " + this.getDisplayName() + " within it.");
        }
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(0, name);
        this.compositeAdapter.updateRecord(this.record, true);
    }

    protected void validateDataType(DataType dataType) {
        Dynamic dynamicDataType;
        if (dataType instanceof FactoryDataType) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
        if (dataType instanceof Dynamic && !(dynamicDataType = (Dynamic)dataType).canSpecifyLength()) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(8);
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(9, lastChangeTime);
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(8, lastChangeTime);
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(7));
    }

    @Override
    void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(7, id.getValue());
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(6));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(6, id.getValue());
            this.compositeAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getPackingValue() {
        int dbValue = this.record.getIntValue(10);
        if (dbValue == -1 || dbValue == 0) {
            return 0;
        }
        return dbValue;
    }

    @Override
    public void setPackingValue(int packingValue) throws InvalidInputException {
        boolean changed = false;
        if (!this.isInternallyAligned()) {
            this.doSetInternallyAligned(true);
            changed = true;
        }
        if (packingValue != this.getPackingValue()) {
            this.doSetPackingValue(packingValue);
            changed = true;
        }
        if (changed) {
            this.adjustInternalAlignment(false);
            this.notifyAlignmentChanged();
        }
    }

    public void doSetPackingValue(int packingValue) throws InvalidInputException {
        if (packingValue < 0) {
            throw new InvalidInputException(packingValue + "is not a valid packing value.");
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (packingValue == this.getPackingValue()) {
                return;
            }
            int dbPackingValue = packingValue == 0 ? (this.isInternallyAligned() ? 0 : -1) : packingValue;
            this.record.setIntValue(10, dbPackingValue);
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isDefaultAligned() {
        int dbValue = this.record.getIntValue(11);
        return dbValue == 0;
    }

    @Override
    public boolean isMachineAligned() {
        int dbValue = this.record.getIntValue(11);
        return dbValue == -1;
    }

    @Override
    public int getMinimumAlignment() {
        int dbValue = this.record.getIntValue(11);
        if (dbValue == -1) {
            return this.getMachineAlignment();
        }
        if (dbValue == 0) {
            return this.getDefaultAlignment();
        }
        return dbValue;
    }

    private int getDefaultAlignment() {
        return 0;
    }

    private int getMachineAlignment() {
        return this.dataMgr.getDataOrganization().getMachineAlignment();
    }

    @Override
    public void setMinimumAlignment(int externalAlignment) throws InvalidInputException {
        boolean changed = false;
        if (!this.isInternallyAligned()) {
            this.doSetInternallyAligned(true);
            changed = true;
        }
        if (this.doSetMinimumAlignment(externalAlignment)) {
            changed = true;
        }
        if (changed) {
            this.adjustInternalAlignment(false);
            this.notifyAlignmentChanged();
        }
    }

    public boolean doSetMinimumAlignment(int externalAlignment) throws InvalidInputException {
        if (externalAlignment <= 0) {
            throw new InvalidInputException(externalAlignment + " is not a valid external alignment. It must be greater than 0.");
        }
        return this.modifyAlignment(externalAlignment);
    }

    @Override
    public void setToDefaultAlignment() {
        boolean changed = false;
        if (!this.isInternallyAligned()) {
            this.doSetInternallyAligned(true);
            changed = true;
        }
        if (this.doSetToDefaultAlignment()) {
            changed = true;
        }
        if (changed) {
            this.adjustInternalAlignment(false);
            this.notifyAlignmentChanged();
        }
    }

    public boolean doSetToDefaultAlignment() {
        return this.modifyAlignment(0);
    }

    @Override
    public void setToMachineAlignment() {
        boolean changed = false;
        if (!this.isInternallyAligned()) {
            this.doSetInternallyAligned(true);
            changed = true;
        }
        if (this.doSetToMachineAlignment()) {
            changed = true;
        }
        if (changed) {
            this.adjustInternalAlignment(false);
            this.notifyAlignmentChanged();
        }
    }

    public boolean doSetToMachineAlignment() {
        return this.modifyAlignment(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyAlignment(int dbExternalAlignment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.isMachineAligned()) {
                if (dbExternalAlignment == -1) {
                    boolean bl = false;
                    return bl;
                }
            } else if (dbExternalAlignment == this.getMinimumAlignment()) {
                boolean bl = false;
                return bl;
            }
            this.record.setIntValue(11, dbExternalAlignment);
            this.compositeAdapter.updateRecord(this.record, true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    protected void notifyAlignmentChanged() {
        DataType[] dts = this.dataMgr.getParentDataTypes(this.key);
        for (int i = 0; i < dts.length; ++i) {
            if (!(dts[i] instanceof Composite)) continue;
            Composite composite = (Composite)dts[i];
            composite.dataTypeAlignmentChanged(this);
        }
        this.dataMgr.dataTypeChanged(this);
    }

    protected DataOrganization getDataOrganization() {
        DataOrganization dataOrganization;
        if (this.dataMgr != null && (dataOrganization = this.dataMgr.getDataOrganization()) != null) {
            return dataOrganization;
        }
        return DataOrganizationImpl.getDefaultOrganization();
    }

    @Override
    public boolean isInternallyAligned() {
        int dbValue = this.record.getIntValue(10);
        return dbValue != -1;
    }

    @Override
    public void setInternallyAligned(boolean aligned) {
        if (aligned == this.isInternallyAligned()) {
            return;
        }
        this.doSetInternallyAligned(aligned);
        this.adjustInternalAlignment(true);
        this.notifyAlignmentChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetInternallyAligned(boolean aligned) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (aligned == this.isInternallyAligned()) {
                return;
            }
            int dbValue = aligned ? 0 : -1;
            this.record.setIntValue(10, dbValue);
            if (!aligned) {
                int dbExternalAlignment = 0;
                this.record.setIntValue(11, dbExternalAlignment);
            }
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    protected void setAlignment(Composite composite, boolean notify) {
        this.doSetInternallyAligned(composite.isInternallyAligned());
        try {
            this.doSetPackingValue(composite.getPackingValue());
        }
        catch (InvalidInputException e) {
            throw new AssertException("Got bad pack value from existing composite.", (Throwable)e);
        }
        if (composite.isDefaultAligned()) {
            this.doSetToDefaultAlignment();
        } else if (composite.isMachineAligned()) {
            this.doSetToMachineAlignment();
        } else {
            try {
                this.doSetMinimumAlignment(composite.getMinimumAlignment());
            }
            catch (InvalidInputException e) {
                throw new AssertException("Got bad minimum alignment from existing composite.", (Throwable)e);
            }
        }
        this.adjustInternalAlignment(notify);
    }

    protected abstract void adjustInternalAlignment(boolean var1);

    @Override
    public int getAlignment() {
        return this.getDataOrganization().getAlignment(this, this.getLength());
    }

    protected void dumpComponents(StringBuilder buffer, String pad) {
        for (DataTypeComponent dtc : this.getComponents()) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dataType.getDisplayName());
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(this.getPathName() + "\n");
        stringBuffer.append(this.getAlignmentSettingsString() + "\n");
        stringBuffer.append(this.getTypeName() + " " + this.getDisplayName() + " {\n");
        this.dumpComponents(stringBuffer, "   ");
        stringBuffer.append("}\n");
        stringBuffer.append("Size = " + this.getLength() + "   Actual Alignment = " + this.getAlignment() + "\n");
        return stringBuffer.toString();
    }

    private String getTypeName() {
        if (this instanceof Structure) {
            return "Structure";
        }
        if (this instanceof Union) {
            return "Union";
        }
        return "";
    }

    private String getAlignmentSettingsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isInternallyAligned()) {
            stringBuffer.append("Unaligned");
        } else if (this.isDefaultAligned()) {
            stringBuffer.append("Aligned");
        } else if (this.isMachineAligned()) {
            stringBuffer.append("Machine aligned");
        } else {
            long alignment = this.getMinimumAlignment();
            stringBuffer.append("align(" + alignment + ")");
        }
        stringBuffer.append(this.getPackingString());
        return stringBuffer.toString();
    }

    private String getPackingString() {
        if (!this.isInternallyAligned()) {
            return "";
        }
        long packingValue = this.getPackingValue();
        if (packingValue == 0L) {
            return "";
        }
        return " pack(" + packingValue + ")";
    }
}

