/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class TypedefDBAdapterV0
extends TypedefDBAdapter
implements RecordTranslator {
    static final int VERSION = 0;
    private static final int V0_TYPEDEF_DT_ID_COL = 0;
    private static final int V0_TYPEDEF_NAME_COL = 1;
    private static final int V0_TYPEDEF_CAT_COL = 2;
    private Table table;

    public TypedefDBAdapterV0(DBHandle handle) throws VersionException {
        this.table = handle.getTable("Typedefs");
        if (this.table == null) {
            throw new VersionException("Missing Table: Typedefs");
        }
        int version = this.table.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Typedefs but got " + this.table.getSchema().getVersion();
            if (version < 0) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Typedefs");
    }

    @Override
    public Record createRecord(long dataTypeID, String name, long categoryID, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #0 of Typedefs table.");
    }

    @Override
    public Record getRecord(long typedefID) throws IOException {
        return this.translateRecord(this.table.getRecord(typedefID));
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }

    @Override
    public void updateRecord(Record record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return this.table.deleteRecord(dataID);
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    long[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return new long[0];
    }

    public Record translateRecord(Record oldRec) {
        if (oldRec == null) {
            return null;
        }
        Record rec = TypedefDBAdapter.SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setString(1, oldRec.getString(1));
        rec.setLongValue(2, oldRec.getLongValue(2));
        rec.setLongValue(3, 0L);
        rec.setLongValue(4, UniversalIdGenerator.nextID().getValue());
        rec.setLongValue(5, 0L);
        rec.setLongValue(6, 0L);
        return rec;
    }

    @Override
    Record getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        return null;
    }
}

