/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.SystemUtilities;
import java.util.StringTokenizer;

public class SymbolStringable
extends Stringable {
    public static final String SHORT_NAME = "SYM";
    private String symbolName;
    private SourceType sourceType;

    public SymbolStringable() {
        this(null, null);
    }

    public SymbolStringable(String symbolName, SourceType symbolType) {
        super(SHORT_NAME);
        this.symbolName = symbolName;
        this.sourceType = symbolType;
    }

    @Override
    public String getDisplayString() {
        return this.symbolName != null ? this.symbolName : "";
    }

    @Override
    protected String doConvertToString(Program program) {
        return this.symbolName + "\t" + this.sourceType.name();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        StringTokenizer tokenizzy = new StringTokenizer(string, "\t");
        this.symbolName = tokenizzy.nextToken();
        String sourceName = tokenizzy.nextToken();
        this.sourceType = SourceType.valueOf((String)sourceName);
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
        result = 31 * result + (this.symbolName == null ? 0 : this.symbolName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolStringable other = (SymbolStringable)obj;
        return SystemUtilities.isEqual((Object)this.symbolName, (Object)other.symbolName) && this.sourceType == other.sourceType;
    }
}

