/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Field;
import db.NodeMgr;
import db.VarKeyNode;
import db.VarKeyRecordNode;
import db.buffers.DataBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class VarKeyInteriorNode
extends VarKeyNode {
    private static final int BASE = 6;
    private static final int KEY_OFFSET_SIZE = 4;
    private static final int ID_SIZE = 4;
    private static final int ENTRY_SIZE = 8;
    private static final int MIN_KEY_CAPACITY = 8;
    private static final int HALF_KEY_CAPACITY = 4;

    VarKeyInteriorNode(NodeMgr nodeMgr, DataBuffer buf) {
        super(nodeMgr, buf);
    }

    VarKeyInteriorNode(NodeMgr nodeMgr, Field key1, int id1, Field key2, int id2) throws IOException {
        super(nodeMgr, (byte)3, key1);
        this.insertEntry(0, key1, id1);
        this.insertEntry(1, key2, id2);
    }

    private VarKeyInteriorNode(NodeMgr nodeMgr, Field keyType) throws IOException {
        super(nodeMgr, (byte)3, keyType);
    }

    void logConsistencyError(String tableName, String msg, Throwable t) throws IOException {
        Msg.debug((Object)this, (Object)("Consistency Error (" + tableName + "): " + msg));
        Msg.debug((Object)this, (Object)("  parent.key[0]=" + this.getKey(0) + " bufferID=" + this.getBufferId()));
        if (t != null) {
            Msg.error((Object)this, (Object)("Consistency Error (" + tableName + ")"), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsistent(String tableName, TaskMonitor monitor) throws IOException, CancelledException {
        boolean consistent = true;
        Field lastMinKey = null;
        Field lastMaxKey = null;
        for (int i = 0; i < this.keyCount; ++i) {
            Field key = this.getKey(i);
            if (i != 0) {
                if (key.compareTo(lastMinKey) <= 0) {
                    consistent = false;
                    this.logConsistencyError(tableName, "child[" + i + "].minKey <= child[" + (i - 1) + "].minKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = " + key + " bufferID=" + this.getBufferId(i)));
                    Msg.debug((Object)this, (Object)("  child[" + (i - 1) + "].minKey = " + lastMinKey + " bufferID=" + this.getBufferId(i - 1)));
                } else if (key.compareTo(lastMaxKey) <= 0) {
                    consistent = false;
                    this.logConsistencyError(tableName, "child[" + i + "].minKey <= child[" + (i - 1) + "].maxKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = " + key + " bufferID=" + this.getBufferId(i)));
                    Msg.debug((Object)this, (Object)("  child[" + (i - 1) + "].maxKey = " + lastMaxKey + " bufferID=" + this.getBufferId(i - 1)));
                }
            }
            lastMinKey = key;
            VarKeyNode node = null;
            try {
                try {
                    node = this.nodeMgr.getVarKeyNode(this.getBufferId(i));
                    node.parent = this;
                }
                catch (IOException e) {
                    this.logConsistencyError(tableName, "failed to fetch child node: " + e.getMessage(), e);
                }
                catch (RuntimeException e) {
                    this.logConsistencyError(tableName, "failed to fetch child node: " + e.getMessage(), e);
                }
                if (node == null) {
                    consistent = false;
                    lastMaxKey = key;
                    continue;
                }
                lastMaxKey = node.getKey(node.getKeyCount() - 1);
                Field childKey0 = node.getKey(0);
                if (!key.equals(childKey0)) {
                    consistent = false;
                    this.logConsistencyError(tableName, "parent key entry mismatch with child[" + i + "].minKey", null);
                    Msg.debug((Object)this, (Object)("  child[" + i + "].minKey = " + childKey0 + " bufferID=" + this.getBufferId(i)));
                    Msg.debug((Object)this, (Object)("  parent key entry = " + key));
                }
                consistent &= node.isConsistent(tableName, monitor);
                monitor.checkCanceled();
                continue;
            }
            finally {
                if (node != null) {
                    this.nodeMgr.releaseReadOnlyNode(node.getBufferId());
                }
            }
        }
        monitor.checkCanceled();
        return consistent;
    }

    static int getMaxKeyLength(int bufferLength) {
        return (bufferLength - 6) / 8 - 8;
    }

    int getIdIndex(Field key) throws IOException {
        int min = 1;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            Field k = this.getKey(i);
            int rc = k.compareTo(key);
            if (rc == 0) {
                return i;
            }
            if (rc < 0) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return max;
    }

    private int getKeyIndex(Field key) throws IOException {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            Field k = this.getKey(i);
            int rc = k.compareTo(key);
            if (rc == 0) {
                return i;
            }
            if (rc < 0) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    private int getOffsetIndex(int offset) {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            int keyOff = this.getKeyOffset(i);
            if (keyOff == offset) {
                return i;
            }
            if (keyOff < offset) {
                max = i - 1;
                continue;
            }
            min = i + 1;
        }
        return min;
    }

    private int getKeyOffset(int index) {
        return this.buffer.getInt(6 + index * 8);
    }

    private void putKeyOffset(int index, int offset) {
        this.buffer.putInt(6 + index * 8, offset);
    }

    @Override
    Field getKey(int index) throws IOException {
        Field key = this.keyType.newField();
        key.read(this.buffer, this.buffer.getInt(6 + index * 8));
        return key;
    }

    private int getKeyLength(int index) throws IOException {
        return this.keyType.readLength(this.buffer, this.buffer.getInt(6 + index * 8));
    }

    private int getBufferId(int index) {
        return this.buffer.getInt(6 + index * 8 + 4);
    }

    private int getFreeSpace() {
        return (this.keyCount == 0 ? this.buffer.length() : this.getKeyOffset(this.keyCount - 1)) - this.keyCount * 8 - 6;
    }

    private void insertEntry(int index, Field key, int bufferId) throws IOException {
        int offset = this.moveKeys(index, -key.length());
        int start = 6 + index * 8;
        int end = 6 + this.keyCount * 8;
        this.buffer.move(start, start + 8, end - start);
        this.buffer.putInt(start, offset);
        this.buffer.putInt(start + 4, bufferId);
        key.write(this.buffer, offset);
        this.setKeyCount(this.keyCount + 1);
    }

    private void updateKey(int index, Field updateKey) throws IOException {
        int offset = this.moveKeys(index + 1, this.getKeyLength(index) - updateKey.length());
        updateKey.write(this.buffer, offset);
        this.putKeyOffset(index, offset);
    }

    private void deleteEntry(int index) throws IOException {
        if (this.keyCount < 3 || index >= this.keyCount) {
            throw new AssertException();
        }
        int moveIndex = index + 1;
        if (moveIndex < this.keyCount) {
            this.moveKeys(moveIndex, this.getKeyLength(index));
            int start = 6 + moveIndex * 8;
            int end = 6 + this.keyCount * 8;
            this.buffer.move(start, start - 8, end - start);
        }
        this.setKeyCount(this.keyCount - 1);
    }

    private int moveKeys(int index, int offset) {
        int lastIndex = this.keyCount - 1;
        if (index == this.keyCount) {
            if (index == 0) {
                return this.buffer.length() + offset;
            }
            return this.getKeyOffset(lastIndex) + offset;
        }
        int start = this.getKeyOffset(lastIndex);
        int end = index == 0 ? this.buffer.length() : this.getKeyOffset(index - 1);
        int len = end - start;
        this.buffer.move(start, start + offset, len);
        for (int i = index; i < this.keyCount; ++i) {
            this.putKeyOffset(i, this.getKeyOffset(i) + offset);
        }
        return end + offset;
    }

    void keyChanged(Field oldKey, Field newKey, VarKeyNode node) throws IOException {
        int index = this.getKeyIndex(oldKey);
        if (index < 0) {
            throw new AssertException();
        }
        int lenChange = newKey.length() - oldKey.length();
        if (lenChange > 0 && lenChange > this.getFreeSpace()) {
            this.split(index, oldKey, newKey, node);
        } else {
            this.updateKey(index, newKey);
            if (index == 0 && this.parent != null) {
                this.parent.keyChanged(oldKey, newKey, this);
            }
        }
    }

    private void split(int oldIndex, Field oldKey, Field newKey, VarKeyNode node) throws IOException {
        VarKeyInteriorNode newNode = new VarKeyInteriorNode(this.nodeMgr, this.keyType);
        int halfway = ((this.keyCount == 0 ? this.buffer.length() : this.getKeyOffset(this.keyCount - 1)) + this.buffer.length()) / 2;
        int splitIndex = this.getOffsetIndex(halfway);
        VarKeyInteriorNode.moveKeysRight(this, newNode, this.keyCount - splitIndex);
        if (splitIndex > oldIndex) {
            this.updateKey(oldIndex, newKey);
            if (oldIndex == 0 && this.parent != null) {
                this.parent.keyChanged(oldKey, newKey, this);
            }
        } else {
            newNode.updateKey(oldIndex - this.keyCount, newKey);
            node.parent = newNode;
        }
        if (this.parent != null) {
            this.parent.insert(newNode);
            if (newNode.parent != this.parent && this.parent.getKeyIndex(this.getKey(0)) < 0) {
                this.parent = newNode.parent;
            }
            return;
        }
        newNode.parent = this.parent = new VarKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), newNode.getKey(0), newNode.getBufferId());
    }

    VarKeyNode insert(VarKeyNode node) throws IOException {
        Field key = node.getKey(0);
        int id = node.getBufferId();
        if (key.length() + 8 > this.getFreeSpace()) {
            return this.split(key, id, node);
        }
        return this.insert(id, key, node);
    }

    VarKeyNode insert(int id, Field key, VarKeyNode node) throws IOException {
        int index = -(this.getKeyIndex(key) + 1);
        if (index < 0 || id == 0) {
            throw new AssertException();
        }
        this.insertEntry(index, key, id);
        node.parent = this;
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(this.getKey(1), key, this);
        }
        return this.getRoot();
    }

    private VarKeyNode split(Field newKey, int newId, VarKeyNode node) throws IOException {
        VarKeyInteriorNode newNode = new VarKeyInteriorNode(this.nodeMgr, this.keyType);
        int halfway = ((this.keyCount == 0 ? this.buffer.length() : this.getKeyOffset(this.keyCount - 1)) + this.buffer.length()) / 2;
        VarKeyInteriorNode.moveKeysRight(this, newNode, this.keyCount - this.getOffsetIndex(halfway));
        Field rightKey = newNode.getKey(0);
        if (newKey.compareTo(rightKey) < 0) {
            this.insert(newId, newKey, node);
        } else {
            newNode.insert(newId, newKey, node);
        }
        if (this.parent != null) {
            VarKeyNode rootNode = this.parent.insert(newNode);
            if (newNode.parent != this.parent && this.parent.getKeyIndex(this.getKey(0)) < 0) {
                this.parent = newNode.parent;
            }
            return rootNode;
        }
        newNode.parent = this.parent = new VarKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), rightKey, newNode.getBufferId());
        return this.parent;
    }

    @Override
    VarKeyRecordNode getLeafNode(Field key) throws IOException {
        VarKeyNode node = this.nodeMgr.getVarKeyNode(this.getBufferId(this.getIdIndex(key)));
        node.parent = this;
        return node.getLeafNode(key);
    }

    @Override
    VarKeyRecordNode getLeftmostLeafNode() throws IOException {
        VarKeyNode node = this.nodeMgr.getVarKeyNode(this.getBufferId(0));
        return node.getLeftmostLeafNode();
    }

    VarKeyNode deleteChild(Field key) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            throw new AssertException();
        }
        if (this.keyCount == 2) {
            if (this.parent != null) {
                throw new AssertException();
            }
            VarKeyNode rootNode = this.nodeMgr.getVarKeyNode(this.getBufferId(1 - index));
            rootNode.parent = null;
            this.nodeMgr.deleteNode(this);
            return rootNode;
        }
        this.deleteEntry(index);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(key, this.getKey(0), this);
        }
        return this.parent != null ? this.parent.balanceChild(this) : this;
    }

    private VarKeyNode balanceChild(VarKeyInteriorNode node) throws IOException {
        if (node.getFreeSpace() < 4 * (this.maxKeyLength + 8)) {
            return this.getRoot();
        }
        int index = this.getIdIndex(node.getKey(0));
        if (index == this.keyCount - 1) {
            return this.balanceChild((VarKeyInteriorNode)this.nodeMgr.getVarKeyNode(this.getBufferId(index - 1)), node);
        }
        return this.balanceChild(node, (VarKeyInteriorNode)this.nodeMgr.getVarKeyNode(this.getBufferId(index + 1)));
    }

    private VarKeyNode balanceChild(VarKeyInteriorNode leftNode, VarKeyInteriorNode rightNode) throws IOException {
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int len = this.buffer.length();
        int leftKeySpace = len - leftNode.getKeyOffset(leftKeyCount - 1);
        int rightKeySpace = len - rightNode.getKeyOffset(rightKeyCount - 1);
        Field rightKey = rightNode.getKey(0);
        if (rightKeySpace + rightKeyCount * 8 <= len - 6 - leftKeySpace - leftKeyCount * 8) {
            VarKeyInteriorNode.moveKeysLeft(leftNode, rightNode, rightKeyCount);
            this.nodeMgr.deleteNode(rightNode);
            return this.deleteChild(rightKey);
        }
        boolean balanced = false;
        int halfKeySpace = (leftKeySpace + rightKeySpace) / 2;
        if (halfKeySpace < leftKeySpace) {
            int index = leftNode.getOffsetIndex(len - halfKeySpace);
            balanced = VarKeyInteriorNode.moveKeysRight(leftNode, rightNode, leftKeyCount - index - 1);
        } else {
            int index = rightNode.getOffsetIndex(len - halfKeySpace);
            balanced = VarKeyInteriorNode.moveKeysLeft(leftNode, rightNode, rightKeyCount - index - 1);
        }
        if (balanced) {
            this.keyChanged(rightKey, rightNode.getKey(0), rightNode);
        }
        return this.getRoot();
    }

    private static boolean moveKeysRight(VarKeyInteriorNode leftNode, VarKeyInteriorNode rightNode, int count) {
        if (count <= 0) {
            return false;
        }
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int leftOffset = leftNode.getKeyOffset(leftKeyCount - 1);
        int len = leftNode.getKeyOffset(leftKeyCount - count - 1) - leftOffset;
        int rightOffset = rightNode.moveKeys(0, -len);
        int offsetCorrection = rightOffset - leftOffset;
        rightNode.buffer.copy(rightOffset, leftNode.buffer, leftOffset, len);
        leftOffset = 6 + (leftKeyCount - count) * 8;
        len = count * 8;
        rightNode.buffer.move(6, 6 + len, rightKeyCount * 8);
        rightNode.buffer.copy(6, leftNode.buffer, leftOffset, len);
        for (int i = 0; i < count; ++i) {
            rightNode.putKeyOffset(i, rightNode.getKeyOffset(i) + offsetCorrection);
        }
        leftNode.setKeyCount(leftKeyCount - count);
        rightNode.setKeyCount(rightKeyCount + count);
        return true;
    }

    private static boolean moveKeysLeft(VarKeyInteriorNode leftNode, VarKeyInteriorNode rightNode, int count) {
        if (count <= 0) {
            return false;
        }
        int leftKeyCount = leftNode.keyCount;
        int rightKeyCount = rightNode.keyCount;
        int rightOffset = rightNode.getKeyOffset(count - 1);
        int len = rightNode.buffer.length() - rightOffset;
        int leftOffset = leftNode.getKeyOffset(leftKeyCount - 1) - len;
        leftNode.buffer.copy(leftOffset, rightNode.buffer, rightOffset, len);
        int elen = count * 8;
        leftNode.buffer.copy(6 + leftKeyCount * 8, rightNode.buffer, 6, elen);
        int offsetCorrection = leftOffset - rightOffset;
        int newLeftKeyCount = leftKeyCount + count;
        for (int i = leftKeyCount; i < newLeftKeyCount; ++i) {
            leftNode.putKeyOffset(i, leftNode.getKeyOffset(i) + offsetCorrection);
        }
        leftNode.setKeyCount(leftKeyCount + count);
        if (count < rightKeyCount) {
            rightNode.moveKeys(count, len);
            rightNode.buffer.move(6 + elen, 6, (rightKeyCount -= count) * 8);
            rightNode.setKeyCount(rightKeyCount);
        }
        return true;
    }

    @Override
    public void delete() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            this.nodeMgr.getVarKeyNode(this.getBufferId(index)).delete();
        }
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        int[] ids = new int[this.keyCount];
        for (int i = 0; i < this.keyCount; ++i) {
            ids[i] = this.getBufferId(i);
        }
        return ids;
    }

    public boolean isLeftmostKey(Field key) throws IOException {
        if (this.getIdIndex(key) == 0) {
            if (this.parent != null) {
                return this.parent.isLeftmostKey(key);
            }
            return true;
        }
        return false;
    }

    public boolean isRightmostKey(Field key) throws IOException {
        if (this.getIdIndex(key) == this.keyCount - 1) {
            if (this.parent != null) {
                return this.parent.isRightmostKey(this.getKey(0));
            }
            return true;
        }
        return false;
    }
}

