/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BlockStreamHandle;
import db.buffers.BufferFile;
import db.buffers.BufferFileAdapter;
import db.buffers.BufferFileHandle;
import db.buffers.InputBlockStream;
import db.buffers.ManagedBufferFile;
import db.buffers.ManagedBufferFileHandle;
import java.io.IOException;
import java.rmi.Remote;

public class ManagedBufferFileAdapter
extends BufferFileAdapter
implements ManagedBufferFile {
    private ManagedBufferFileHandle managedBufferFileHandle;

    public ManagedBufferFileAdapter(ManagedBufferFileHandle remoteManagedBufferFile) {
        super(remoteManagedBufferFile);
        this.managedBufferFileHandle = remoteManagedBufferFile;
    }

    @Override
    public ManagedBufferFile getSaveFile() throws IOException {
        ManagedBufferFileHandle rbf = this.managedBufferFileHandle.getSaveFile();
        return rbf != null ? new ManagedBufferFileAdapter(rbf) : null;
    }

    @Override
    public void saveCompleted(boolean commit) throws IOException {
        this.managedBufferFileHandle.saveCompleted(commit);
    }

    @Override
    public boolean canSave() throws IOException {
        return this.managedBufferFileHandle.canSave();
    }

    @Override
    public void setVersionComment(String comment) throws IOException {
        this.managedBufferFileHandle.setVersionComment(comment);
    }

    @Override
    public BufferFile getNextChangeDataFile(boolean getFirst) throws IOException {
        BufferFileHandle rbf = this.managedBufferFileHandle.getNextChangeDataFile(getFirst);
        return rbf != null ? new BufferFileAdapter(rbf) : null;
    }

    @Override
    public BufferFile getSaveChangeDataFile() throws IOException {
        BufferFileHandle rbf = this.managedBufferFileHandle.getSaveChangeDataFile();
        return rbf != null ? new BufferFileAdapter(rbf) : null;
    }

    @Override
    public long getCheckinID() throws IOException {
        return this.managedBufferFileHandle.getCheckinID();
    }

    @Override
    public byte[] getForwardModMapData(int oldVersion) throws IOException {
        return this.managedBufferFileHandle.getForwardModMapData(oldVersion);
    }

    InputBlockStream getInputBlockStream(byte[] changeMapData) throws IOException {
        if (this.managedBufferFileHandle instanceof Remote) {
            BlockStreamHandle<InputBlockStream> inputBlockStreamHandle = this.managedBufferFileHandle.getInputBlockStreamHandle(changeMapData);
            return inputBlockStreamHandle.openBlockStream();
        }
        return this.managedBufferFileHandle.getInputBlockStream(changeMapData);
    }
}

