/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QItemListener;
import generic.concurrent.QResult;
import generic.concurrent.QRunnable;
import generic.concurrent.QRunnableAdapter;
import ghidra.util.graph.DependencyGraph;
import ghidra.util.task.TaskMonitor;
import java.util.Set;

public class ConcurrentGraphQ<I> {
    private ConcurrentQ<I, Object> queue;
    private DependencyGraph<I> graph;

    public ConcurrentGraphQ(QRunnable<I> runnable, DependencyGraph<I> graph, GThreadPool pool, TaskMonitor monitor) {
        this.graph = graph;
        this.queue = new ConcurrentQBuilder().setCollectResults(false).setThreadPool(pool).setMonitor(monitor).setListener(new MyItemListener()).build(new QRunnableAdapter<I>(runnable));
    }

    public void execute() throws InterruptedException, Exception {
        Set<I> values = this.graph.getUnvisitedIndependentValues();
        this.queue.add(values);
        this.queue.waitUntilDone();
    }

    public void dispose() {
        this.queue.dispose();
    }

    class MyItemListener
    implements QItemListener<I, Object> {
        MyItemListener() {
        }

        @Override
        public void itemProcessed(QResult<I, Object> result) {
            ConcurrentGraphQ.this.graph.remove(result.getItem());
            Set values = ConcurrentGraphQ.this.graph.getUnvisitedIndependentValues();
            ConcurrentGraphQ.this.queue.add(values);
        }
    }
}

