/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntKeyIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.NoValueException;

public class IntIntHashtable {
    private IntKeyIndexer indexer;
    private int[] values;
    private int capacity;

    public IntIntHashtable() {
        this(3);
    }

    public IntIntHashtable(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new IntKeyIndexer(capacity);
        this.values = new int[capacity];
    }

    public void put(int key, int value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public int get(int key) throws NoValueException {
        int index = this.indexer.get(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public int remove(int key) throws NoValueException {
        int index = this.indexer.remove(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(int key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public int[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        int[] oldValues = this.values;
        this.values = new int[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

