/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class LongArrayListIterator
implements ListIterator<Long> {
    int nextIndex;
    int lastReturnedIndex = -1;
    List<Long> list;

    public LongArrayListIterator(List<Long> list, int startIndex) {
        this.list = list;
        this.nextIndex = startIndex;
    }

    @Override
    public void add(Long o) {
        this.list.add(this.nextIndex, o);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.list.size();
    }

    @Override
    public boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    @Override
    public Long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastReturnedIndex = this.nextIndex;
        return this.list.get(this.nextIndex++);
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public Long previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastReturnedIndex = this.nextIndex - 1;
        return this.list.get(--this.nextIndex);
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void remove() {
        if (this.lastReturnedIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.remove(this.lastReturnedIndex);
        if (this.nextIndex > this.lastReturnedIndex) {
            --this.nextIndex;
        }
        this.lastReturnedIndex = -1;
    }

    @Override
    public void set(Long o) {
        if (this.lastReturnedIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.set(this.lastReturnedIndex, o);
    }
}

