/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntLongIndexedList;
import ghidra.util.datastruct.LongKeyIndexer;
import java.io.Serializable;

public class LongLongHashedList
implements Serializable {
    private LongKeyIndexer indexer;
    private IntLongIndexedList values;
    private int capacity;
    private static final int DEFAULT_CAPACITY = 16;

    public LongLongHashedList() {
        this(16);
    }

    public LongLongHashedList(int capacity) {
        this.capacity = capacity;
        this.indexer = new LongKeyIndexer(capacity);
        this.values = new IntLongIndexedList(capacity);
    }

    public long[] getKeys() {
        return this.indexer.getKeys();
    }

    public void add(long key, long value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.capacity = this.indexer.getCapacity();
            this.values.growNumLists(this.capacity);
        }
        this.values.add(index, value);
    }

    public void append(long key, long value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.capacity = this.indexer.getCapacity();
            this.values.growNumLists(this.capacity);
        }
        this.values.append(index, value);
    }

    public boolean contains(long key, long value) {
        int index = this.indexer.get(key);
        if (index < 0) {
            return false;
        }
        return this.values.contains(index, value);
    }

    public long[] get(long key) {
        int index = this.indexer.get(key);
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    public boolean remove(long key, long value) {
        int index = this.indexer.get(key);
        if (index < 0) {
            return false;
        }
        boolean ret = this.values.remove(index, value);
        if (this.values.getCount(index) == 0) {
            this.indexer.remove(key);
        }
        return ret;
    }

    public void removeAll(long key) {
        int index = this.indexer.get(key);
        if (index < 0) {
            return;
        }
        this.values.removeAll(index);
        this.indexer.remove(key);
    }

    public void clear() {
        this.indexer.clear();
        this.values.clear();
    }
}

