/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.ibootim;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class iBootImHeader
implements StructConverter {
    private byte[] signature;
    private int unknown;
    private int compressionType;
    private int format;
    private short width;
    private short height;
    private byte[] padding;

    public iBootImHeader(ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, true);
        this.signature = reader.readNextByteArray(8);
        this.unknown = reader.readNextInt();
        this.compressionType = reader.readNextInt();
        this.format = reader.readNextInt();
        this.width = reader.readNextShort();
        this.height = reader.readNextShort();
        this.padding = reader.readNextByteArray(40);
    }

    public String getSignature() {
        return new String(this.signature).trim();
    }

    public int getUnknown() {
        return this.unknown;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public int getFormat() {
        return this.format;
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(iBootImHeader.class), 0);
        struct.add(STRING, 8, "signature", null);
        struct.add(DWORD, "unknown", null);
        struct.add(DWORD, "compression", null);
        struct.add(DWORD, "format", null);
        struct.add(WORD, "width", null);
        struct.add(WORD, "height", null);
        ArrayDataType paddingDataType = new ArrayDataType(BYTE, 40, BYTE.getLength());
        struct.add((DataType)paddingDataType, "padding", null);
        return struct;
    }
}

