/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.sparseimage;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SparseHeader
implements StructConverter {
    private int magic;
    private short major_version;
    private short minor_version;
    private short file_hdr_sz;
    private short chunk_hdr_sz;
    private int blk_sz;
    private int total_blks;
    private int total_chunks;
    private int image_checksum;

    public SparseHeader(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public SparseHeader(BinaryReader reader) throws IOException {
        this.magic = reader.readNextInt();
        this.major_version = reader.readNextShort();
        this.minor_version = reader.readNextShort();
        this.file_hdr_sz = reader.readNextShort();
        this.chunk_hdr_sz = reader.readNextShort();
        this.blk_sz = reader.readNextInt();
        this.total_blks = reader.readNextInt();
        this.total_chunks = reader.readNextInt();
        this.image_checksum = reader.readNextInt();
    }

    public int getMagic() {
        return this.magic;
    }

    public short getMajor_version() {
        return this.major_version;
    }

    public short getMinor_version() {
        return this.minor_version;
    }

    public short getFile_hdr_sz() {
        return this.file_hdr_sz;
    }

    public short getChunk_hdr_sz() {
        return this.chunk_hdr_sz;
    }

    public int getBlk_sz() {
        return this.blk_sz;
    }

    public int getTotal_blks() {
        return this.total_blks;
    }

    public int getTotal_chunks() {
        return this.total_chunks;
    }

    public int getImage_checksum() {
        return this.image_checksum;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("sparse_header", 0);
        structure.add(DWORD, "magic", null);
        structure.add(WORD, "major_version", null);
        structure.add(WORD, "minor_version", null);
        structure.add(WORD, "file_hdr_sz", null);
        structure.add(WORD, "chunk_hdr_sz", null);
        structure.add(DWORD, "blk_sz", null);
        structure.add(DWORD, "total_blks", null);
        structure.add(DWORD, "total_chunks", null);
        structure.add(DWORD, "image_checksum", null);
        return structure;
    }
}

