/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.CreateStructureVariableAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.UndefinedFunction;

public class DecompilerStructureVariableAction
extends CreateStructureVariableAction {
    public DecompilerStructureVariableAction(String owner, PluginTool tool, DecompilerController controller) {
        super(owner, tool, controller);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        DataType dt = null;
        boolean isThisParam = false;
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        Function function = this.controller.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        HighVariable var = tokenAtCursor.getHighVariable();
        if (var != null && !(var instanceof HighConstant)) {
            dt = var.getDataType();
            isThisParam = DecompilerStructureVariableAction.testForAutoParameterThis(var, function);
        }
        if (dt == null) {
            return false;
        }
        this.adjustCreateStructureMenuText(dt, isThisParam);
        return true;
    }
}

