/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import java.math.BigInteger;

public class ContextRegisterInfo {
    String contextRegister;
    String value;
    BigInteger valueAsBigInteger;

    public ContextRegisterInfo() {
    }

    public ContextRegisterInfo(String contextRegister) {
        this.contextRegister = contextRegister;
    }

    public String getContextRegister() {
        return this.contextRegister;
    }

    public void setContextRegister(String contextRegister) {
        this.contextRegister = contextRegister;
    }

    public BigInteger getValueAsBigInteger() {
        return this.valueAsBigInteger;
    }

    public void setValue(BigInteger valueAsBigInteger) {
        this.valueAsBigInteger = valueAsBigInteger;
        this.value = valueAsBigInteger.toString();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.valueAsBigInteger = new BigInteger(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.contextRegister);
        sb.append(" ");
        sb.append(this.value);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextRegisterInfo other = (ContextRegisterInfo)obj;
        if (!this.contextRegister.equals(other.getContextRegister())) {
            return false;
        }
        if (this.value == null) {
            return other.getValue() == null;
        }
        if (other.getValue() == null) {
            return false;
        }
        return this.value.equals(other.getValue());
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.contextRegister.hashCode();
        hashCode = 31 * hashCode + this.value.hashCode();
        return hashCode;
    }
}

