/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class X86_64_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 62;
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 62) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.hasAddend() ? relocation.getAddend() : memory.getLong(relocationAddress);
        ElfSymbol sym = null;
        long symbolValue = 0L;
        long st_value = 0L;
        String symbolName = null;
        long symbolSize = 0L;
        if (symbolIndex != 0) {
            sym = elfRelocationContext.getSymbol(symbolIndex);
        }
        if (sym != null) {
            symbolValue = elfRelocationContext.getSymbolValue(sym);
            st_value = sym.getValue();
            symbolName = sym.getNameAsString();
            symbolSize = sym.getSize();
        }
        long offset = relocationAddress.getOffset();
        boolean appliedSymbol = true;
        switch (type) {
            case 5: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 1: {
                long value = symbolValue + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 2: {
                int ivalue = (int)((symbolValue += addend - offset) & 0xFFFFFFFFFFFFFFFFL);
                memory.setInt(relocationAddress, ivalue);
                break;
            }
            case 3: 
            case 4: {
                long value = symbolValue;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 6: 
            case 7: {
                long value = symbolValue + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 25: {
                long dotgot = elfRelocationContext.getGOTValue();
                long value = symbolValue + addend - dotgot;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 10: 
            case 11: {
                int ivalue = (int)((symbolValue += addend) & 0xFFFFFFFFFFFFFFFFL);
                memory.setInt(relocationAddress, ivalue);
                break;
            }
            case 32: {
                long value = symbolSize;
                memory.setInt(relocationAddress, (int)value);
                break;
            }
            case 33: {
                long value = symbolSize + addend;
                int ivalue = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                memory.setInt(relocationAddress, ivalue);
                break;
            }
            case 16: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_DTPMOD64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 17: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_DTPOFF64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 18: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_TPOFF64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 36: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_X86_64_TLSDESC", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not support", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            case 26: {
                appliedSymbol = false;
                long dotgot = elfRelocationContext.getGOTValue();
                long value = dotgot + addend - offset;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 8: 
            case 38: {
                appliedSymbol = false;
                long base = program.getImageBase().getAddressableWordOffset();
                long value = elf.isPreLinked() ? memory.getLong(relocationAddress) + elfRelocationContext.getImageBaseWordAdjustmentOffset() : base + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case 37: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_X86_64_IRELATIVE", (String)symbolName, (String)"indirect computed relocation not supported", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            default: {
                appliedSymbol = false;
                X86_64_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
        if (appliedSymbol && symbolIndex == 0) {
            X86_64_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)Long.toString(type), (String)"applied relocation with symbol-index of 0", (MessageLog)elfRelocationContext.getLog());
        }
    }
}

