"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dom_1 = require("../../../core/dom");
const p = require("../../../core/properties");
const edit_tool_1 = require("./edit_tool");
const icons_1 = require("../../../styles/icons");
class PointDrawToolView extends edit_tool_1.EditToolView {
    _tap(ev) {
        const append = ev.shiftKey;
        const renderers = this._select_event(ev, append, this.model.renderers);
        if (renderers.length || !this.model.add) {
            return;
        }
        const renderer = this.model.renderers[0];
        const point = this._map_drag(ev.sx, ev.sy, renderer);
        if (point == null)
            return;
        // Type once dataspecs are typed
        const glyph = renderer.glyph;
        const cds = renderer.data_source;
        const [xkey, ykey] = [glyph.x.field, glyph.y.field];
        const [x, y] = point;
        this._pop_glyphs(cds, this.model.num_objects);
        if (xkey)
            cds.get_array(xkey).push(x);
        if (ykey)
            cds.get_array(ykey).push(y);
        this._pad_empty_columns(cds, [xkey, ykey]);
        cds.change.emit();
        cds.data = cds.data;
        cds.properties.data.change.emit();
    }
    _keyup(ev) {
        if (!this.model.active || !this._mouse_in_frame)
            return;
        for (const renderer of this.model.renderers) {
            if (ev.keyCode === dom_1.Keys.Backspace) {
                this._delete_selected(renderer);
            }
            else if (ev.keyCode == dom_1.Keys.Esc) {
                renderer.data_source.selection_manager.clear();
            }
        }
    }
    _pan_start(ev) {
        if (!this.model.drag)
            return;
        this._select_event(ev, true, this.model.renderers);
        this._basepoint = [ev.sx, ev.sy];
    }
    _pan(ev) {
        if (!this.model.drag || this._basepoint == null)
            return;
        this._drag_points(ev, this.model.renderers);
    }
    _pan_end(ev) {
        if (!this.model.drag)
            return;
        this._pan(ev);
        for (const renderer of this.model.renderers)
            this._emit_cds_changes(renderer.data_source, false, true, true);
        this._basepoint = null;
    }
}
exports.PointDrawToolView = PointDrawToolView;
PointDrawToolView.__name__ = "PointDrawToolView";
class PointDrawTool extends edit_tool_1.EditTool {
    constructor(attrs) {
        super(attrs);
        this.tool_name = "Point Draw Tool";
        this.icon = icons_1.bk_tool_icon_point_draw;
        this.event_type = ["tap", "pan", "move"];
        this.default_order = 2;
    }
    static init_PointDrawTool() {
        this.prototype.default_view = PointDrawToolView;
        this.define({
            add: [p.Boolean, true],
            drag: [p.Boolean, true],
            num_objects: [p.Int, 0],
        });
    }
}
exports.PointDrawTool = PointDrawTool;
PointDrawTool.__name__ = "PointDrawTool";
PointDrawTool.init_PointDrawTool();
