/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.VariableResolver;

public abstract class Evaluator {
    static Pattern IN_SINGLE_QUOTES = Pattern.compile("^'(.*?)'$");
    public static final String DATE_FORMAT_EVALUATOR = "formatDate";
    public static final String URL_ENCODE_EVALUATOR = "encodeUrl";
    public static final String ESCAPE_SOLR_QUERY_CHARS = "escapeQueryChars";
    public static final String SQL_ESCAPE_EVALUATOR = "escapeSql";

    public abstract String evaluate(String var1, Context var2);

    protected List<Object> parseParams(String expression, VariableResolver vr) {
        ArrayList<Object> result = new ArrayList<Object>();
        expression = expression.trim();
        String[] ss = expression.split(",");
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = ss[i].trim();
            if (ss[i].startsWith("'")) {
                StringBuilder sb = new StringBuilder();
                while (true) {
                    sb.append(ss[i]);
                    if (ss[i].endsWith("'")) break;
                    if (++i >= ss.length) {
                        throw new DataImportHandlerException(500, "invalid string at " + ss[i - 1] + " in function params: " + expression);
                    }
                    sb.append(",");
                }
                String s = sb.substring(1, sb.length() - 1);
                s = s.replaceAll("\\\\'", "'");
                result.add(s);
                continue;
            }
            if (Character.isDigit(ss[i].charAt(0))) {
                try {
                    Double doub = Double.parseDouble(ss[i]);
                    result.add(doub);
                }
                catch (NumberFormatException e) {
                    if (vr.resolve(ss[i]) != null) continue;
                    DataImportHandlerException.wrapAndThrow(500, e, "Invalid number :" + ss[i] + "in parameters  " + expression);
                }
                continue;
            }
            result.add(this.getVariableWrapper(ss[i], vr));
        }
        return result;
    }

    protected VariableWrapper getVariableWrapper(String s, VariableResolver vr) {
        return new VariableWrapper(s, vr);
    }

    protected static class VariableWrapper {
        public final String varName;
        public final VariableResolver vr;

        public VariableWrapper(String s, VariableResolver vr) {
            this.varName = s;
            this.vr = vr;
        }

        public Object resolve() {
            return this.vr.resolve(this.varName);
        }

        public String toString() {
            Object o = this.vr.resolve(this.varName);
            return o == null ? null : o.toString();
        }
    }
}

