/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminHandlersProxy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_NODES = "nodes";

    public static boolean maybeProxyToNodes(SolrQueryRequest req, SolrQueryResponse rsp, CoreContainer container) throws IOException, SolrServerException, InterruptedException {
        HashSet<String> nodes;
        String nodeNames = req.getParams().get(PARAM_NODES);
        if (nodeNames == null || nodeNames.isEmpty()) {
            return false;
        }
        if (!container.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Parameter nodes only supported in Cloud mode");
        }
        String pathStr = req.getPath();
        Map paramsMap = req.getParams().toMap(new HashMap());
        paramsMap.remove(PARAM_NODES);
        MapSolrParams params = new MapSolrParams(paramsMap);
        HashSet<String> liveNodes = container.getZkController().zkStateReader.getClusterState().getLiveNodes();
        if (nodeNames.equals("all")) {
            nodes = liveNodes;
            log.debug("All live nodes requested");
        } else {
            nodes = new HashSet<String>(Arrays.asList(nodeNames.split(",")));
            for (String nodeName : nodes) {
                if (!nodeName.matches("^[^/:]+:\\d+_[\\w/]+$")) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Parameter nodes has wrong format");
                }
                if (liveNodes.contains(nodeName)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Requested node " + nodeName + " is not part of cluster");
            }
            log.debug("Nodes requested: {}", nodes);
        }
        log.debug("nodes parameter {} specified on {}\u00a0request", (Object)nodeNames, (Object)pathStr);
        HashMap<String, Pair<Future<NamedList<Object>>, SolrClient>> responses = new HashMap<String, Pair<Future<NamedList<Object>>, SolrClient>>();
        for (String string : nodes) {
            responses.put(string, AdminHandlersProxy.callRemoteNode(string, pathStr, (SolrParams)params, container.getZkController()));
        }
        for (Map.Entry entry : responses.entrySet()) {
            try {
                NamedList resp = (NamedList)((Future)((Pair)entry.getValue()).first()).get(10L, TimeUnit.SECONDS);
                ((SolrClient)((Pair)entry.getValue()).second()).close();
                rsp.add((String)entry.getKey(), resp);
            }
            catch (ExecutionException ee) {
                log.warn("Exception when fetching result from node {}", entry.getKey(), (Object)ee);
            }
            catch (TimeoutException te) {
                log.warn("Timeout when fetching result from node {}", entry.getKey(), (Object)te);
            }
        }
        log.info("Fetched response from {} nodes: {}", (Object)responses.keySet().size(), responses.keySet());
        return true;
    }

    public static Pair<Future<NamedList<Object>>, SolrClient> callRemoteNode(String nodeName, String endpoint, SolrParams params, ZkController zkController) throws IOException, SolrServerException {
        log.debug("Proxying {} request to node {}", (Object)endpoint, (Object)nodeName);
        URL baseUrl = new URL(zkController.zkStateReader.getBaseUrlForNodeName(nodeName));
        HttpSolrClient solr = new HttpSolrClient.Builder(baseUrl.toString()).build();
        GenericSolrRequest proxyReq = new GenericSolrRequest(SolrRequest.METHOD.GET, endpoint, params);
        HttpSolrClient.HttpUriRequestResponse proxyResp = solr.httpUriRequest((SolrRequest)proxyReq);
        return new Pair((Object)proxyResp.future, (Object)solr);
    }
}

