/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.IntFunction;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.AggUtil;
import org.apache.solr.search.facet.DoubleFuncSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;

class VarianceSlotAcc
extends DoubleFuncSlotAcc {
    int[] counts;
    double[] sum;

    public VarianceSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
        super(values, fcontext, numSlots);
        this.counts = new int[numSlots];
        this.sum = new double[numSlots];
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.counts, 0);
        Arrays.fill(this.sum, 0.0);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        super.resize(resizer);
        this.counts = resizer.resize(this.counts, 0);
        this.sum = resizer.resize(this.sum, 0.0);
    }

    private double variance(int slot) {
        return AggUtil.uncorrectedVariance(this.result[slot], this.sum[slot], this.counts[slot]);
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Double.compare(this.variance(slotA), this.variance(slotB));
    }

    @Override
    public Object getValue(int slot) {
        if (this.fcontext.isShard()) {
            ArrayList<Number> lst = new ArrayList<Number>(3);
            lst.add(this.counts[slot]);
            lst.add(this.result[slot]);
            lst.add(this.sum[slot]);
            return lst;
        }
        return this.variance(slot);
    }

    @Override
    public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        double val = this.values.doubleVal(doc);
        if (this.values.exists(doc)) {
            int n = slot;
            this.counts[n] = this.counts[n] + 1;
            int n2 = slot;
            this.result[n2] = this.result[n2] + val * val;
            int n3 = slot;
            this.sum[n3] = this.sum[n3] + val;
        }
    }
}

