/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.TestUtil;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDistributedSearchTestCase
extends SolrTestCaseJ4 {
    protected ExecutorService executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(4, Integer.MAX_VALUE, 15L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("BaseDistributedSearchTestCase"), false);
    public static Random r;
    private AtomicInteger nodeCnt = new AtomicInteger(0);
    protected boolean useExplicitNodeNames;
    private static final int DEFAULT_MAX_SHARD_COUNT = 3;
    private int shardCount = -1;
    private boolean isShardCountFixed = false;
    protected volatile JettySolrRunner controlJetty;
    protected final List<SolrClient> clients = Collections.synchronizedList(new ArrayList());
    protected final List<JettySolrRunner> jettys = Collections.synchronizedList(new ArrayList());
    protected volatile String context;
    protected volatile String[] deadServers;
    protected volatile String shards;
    protected volatile String[] shardsArr;
    protected volatile File testDir;
    protected volatile SolrClient controlClient;
    protected volatile int stress = TEST_NIGHTLY ? 2 : 0;
    protected volatile boolean verifyStress = true;
    protected volatile int nThreads = 3;
    public static final int ORDERED = 1;
    public static final int SKIP = 2;
    public static final int SKIPVAL = 4;
    public static final int UNORDERED = 8;
    public static int FUZZY;
    private static final double DOUBLE_RATIO_LIMIT = 1.0E-8;
    protected volatile int flags;
    protected Map<String, Integer> handle = new ConcurrentHashMap<String, Integer>();
    protected String id = "id";
    private static final Logger log;
    public static RandVal rint;
    public static RandVal rlong;
    public static RandVal rfloat;
    public static RandVal rdouble;
    public static RandVal rdate;
    public static String[] fieldNames;
    public static RandVal[] randVals;
    private boolean distribSetUpCalled = false;
    private volatile boolean distribTearDownCalled = false;
    @Rule
    public ShardsRepeatRule repeatRule = new ShardsRepeatRule();

    @BeforeClass
    public static void initialize() {
        BaseDistributedSearchTestCase.assumeFalse((String)"SOLR-4147: ibm 64bit has jvm bugs!", (Constants.JRE_IS_64BIT && Constants.JAVA_VENDOR.startsWith("IBM") ? 1 : 0) != 0);
        r = new Random(BaseDistributedSearchTestCase.random().nextLong());
    }

    @BeforeClass
    public static void initHostContext() {
        StringBuilder hostContext = new StringBuilder("/");
        if (BaseDistributedSearchTestCase.random().nextBoolean()) {
            hostContext.append(TestUtil.randomSimpleString((Random)BaseDistributedSearchTestCase.random(), (int)2));
            if (BaseDistributedSearchTestCase.random().nextBoolean()) {
                hostContext.append("_");
            }
            hostContext.append(TestUtil.randomSimpleString((Random)BaseDistributedSearchTestCase.random(), (int)3));
            if (!"/".equals(hostContext.toString())) {
                hostContext.append("/").append(TestUtil.randomSimpleString((Random)BaseDistributedSearchTestCase.random(), (int)2));
            }
        }
        String hc = hostContext.toString().replaceAll("\\/+", "/");
        log.info("Setting hostContext system property: " + hc);
        System.setProperty("hostContext", hc);
    }

    @AfterClass
    public static void clearHostContext() throws Exception {
        System.clearProperty("hostContext");
    }

    @BeforeClass
    public static void setSolrDisableShardsWhitelist() throws Exception {
        BaseDistributedSearchTestCase.systemSetPropertySolrDisableShardsWhitelist("true");
    }

    @AfterClass
    public static void clearSolrDisableShardsWhitelist() throws Exception {
        BaseDistributedSearchTestCase.systemClearPropertySolrDisableShardsWhitelist();
    }

    private static String getHostContextSuitableForServletContext() {
        String ctx = System.getProperty("hostContext", "/solr");
        if ("".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    protected BaseDistributedSearchTestCase() {
        this(BaseDistributedSearchTestCase.getHostContextSuitableForServletContext());
    }

    protected BaseDistributedSearchTestCase(String context) {
        this.context = context;
        this.deadServers = new String[]{"[::1]:4" + context, "[::1]:6" + context, "[::1]:8" + context};
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public void fixShardCount(int count) {
        this.isShardCountFixed = true;
        this.shardCount = count;
    }

    protected String[] getFieldNames() {
        return fieldNames;
    }

    protected RandVal[] getRandValues() {
        return randVals;
    }

    public String getSolrHome() {
        return SolrTestCaseJ4.TEST_HOME();
    }

    public void distribSetUp() throws Exception {
        this.distribSetUpCalled = true;
        SolrTestCaseJ4.resetExceptionIgnores();
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        this.testDir = BaseDistributedSearchTestCase.createTempDir().toFile();
    }

    public void distribTearDown() throws Exception {
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.executor);
        this.distribTearDownCalled = true;
    }

    protected JettySolrRunner createControlJetty() throws Exception {
        Path jettyHome = this.testDir.toPath().resolve("control");
        File jettyHomeFile = jettyHome.toFile();
        this.seedSolrHome(jettyHomeFile);
        this.seedCoreRootDirWithDefaultTestCore(jettyHome.resolve("cores"));
        JettySolrRunner jetty = this.createJetty(jettyHomeFile, null, null, BaseDistributedSearchTestCase.getSolrConfigFile(), BaseDistributedSearchTestCase.getSchemaFile());
        jetty.start();
        return jetty;
    }

    protected void createServers(int numShards) throws Exception {
        System.setProperty("configSetBaseDir", this.getSolrHome());
        this.controlJetty = this.createControlJetty();
        this.controlClient = this.createNewSolrClient(this.controlJetty.getLocalPort());
        this.shardsArr = new String[numShards];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            String shardname = "shard" + i;
            Path jettyHome = this.testDir.toPath().resolve(shardname);
            File jettyHomeFile = jettyHome.toFile();
            this.seedSolrHome(jettyHomeFile);
            this.seedCoreRootDirWithDefaultTestCore(jettyHome.resolve("cores"));
            JettySolrRunner j = this.createJetty(jettyHomeFile, null, null, BaseDistributedSearchTestCase.getSolrConfigFile(), BaseDistributedSearchTestCase.getSchemaFile());
            j.start();
            this.jettys.add(j);
            this.clients.add(this.createNewSolrClient(j.getLocalPort()));
            String shardStr = this.buildUrl(j.getLocalPort());
            shardStr = shardStr.endsWith("/") ? shardStr + "collection1" : shardStr + "/collection1";
            this.shardsArr[i] = shardStr;
            sb.append(shardStr);
        }
        this.shards = sb.toString();
    }

    protected void setDistributedParams(ModifiableSolrParams params) {
        params.set("shards", new String[]{this.getShardsString()});
    }

    protected String getShardsString() {
        if (this.deadServers == null) {
            return this.shards;
        }
        StringBuilder sb = new StringBuilder();
        for (String shard : this.shardsArr) {
            int nDeadServers;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if ((nDeadServers = r.nextInt(this.deadServers.length + 1)) > 0) {
                ArrayList<String> replicas = new ArrayList<String>(Arrays.asList(this.deadServers));
                Collections.shuffle(replicas, r);
                replicas.add(r.nextInt(nDeadServers + 1), shard);
                for (int i = 0; i < nDeadServers + 1; ++i) {
                    if (i != 0) {
                        sb.append('|');
                    }
                    sb.append((String)replicas.get(i));
                }
                continue;
            }
            sb.append(shard);
        }
        return sb.toString();
    }

    protected void destroyServers() throws Exception {
        ExecutorService customThreadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("closeThreadPool"));
        customThreadPool.submit(() -> Collections.singleton(this.controlClient).parallelStream().forEach(c -> IOUtils.closeQuietly((Closeable)c)));
        customThreadPool.submit(() -> {
            try {
                this.controlJetty.stop();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception e) {
                log.error("Error stopping Control Jetty", (Throwable)e);
            }
        });
        for (SolrClient client : this.clients) {
            customThreadPool.submit(() -> IOUtils.closeQuietly((Closeable)client));
        }
        for (JettySolrRunner jetty : this.jettys) {
            customThreadPool.submit(() -> {
                try {
                    jetty.stop();
                }
                catch (Exception e) {
                    log.error("Error stopping Jetty", (Throwable)e);
                }
            });
        }
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)customThreadPool);
        this.clients.clear();
        this.jettys.clear();
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir) throws Exception {
        return this.createJetty(solrHome, dataDir, null, null, null);
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardId) throws Exception {
        return this.createJetty(solrHome, dataDir, shardId, null, null);
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride) throws Exception {
        return this.createJetty(solrHome, dataDir, shardList, solrConfigOverride, schemaOverride, this.useExplicitNodeNames);
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride, boolean explicitCoreNodeName) throws Exception {
        Properties props = new Properties();
        if (solrConfigOverride != null) {
            props.setProperty("solrconfig", solrConfigOverride);
        }
        if (schemaOverride != null) {
            props.setProperty("schema", schemaOverride);
        }
        if (shardList != null) {
            props.setProperty("shards", shardList);
        }
        if (dataDir != null) {
            props.setProperty("solr.data.dir", dataDir);
        }
        if (explicitCoreNodeName) {
            props.setProperty("coreNodeName", Integer.toString(this.nodeCnt.incrementAndGet()));
        }
        props.setProperty("coreRootDirectory", solrHome.toPath().resolve("cores").toAbsolutePath().toString());
        JettySolrRunner jetty = new JettySolrRunner(solrHome.getAbsolutePath(), props, JettyConfig.builder().stopAtShutdown(true).setContext(this.context).withFilters(this.getExtraRequestFilters()).withServlets(this.getExtraServlets()).withSSLConfig(sslConfig.buildServerSSLConfig()).build());
        return jetty;
    }

    public SortedMap<ServletHolder, String> getExtraServlets() {
        return null;
    }

    public SortedMap<Class<? extends Filter>, String> getExtraRequestFilters() {
        return null;
    }

    protected SolrClient createNewSolrClient(int port) {
        try {
            String baseUrl = this.buildUrl(port);
            if (baseUrl.endsWith("/")) {
                return BaseDistributedSearchTestCase.getHttpSolrClient(baseUrl + "collection1");
            }
            return BaseDistributedSearchTestCase.getHttpSolrClient(baseUrl + "/" + "collection1");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String buildUrl(int port) {
        return BaseDistributedSearchTestCase.buildUrl(port, this.context);
    }

    protected static void addFields(SolrInputDocument doc, Object ... fields) {
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
    }

    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        BaseDistributedSearchTestCase.addFields(doc, fields);
        BaseDistributedSearchTestCase.addFields(doc, "rnd_b", true);
        this.addRandFields(doc);
        this.indexDoc(doc);
    }

    protected SolrInputDocument addRandFields(SolrInputDocument sdoc) {
        BaseDistributedSearchTestCase.addFields(sdoc, BaseDistributedSearchTestCase.getRandFields(this.getFieldNames(), this.getRandValues()));
        return sdoc;
    }

    protected void index(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        BaseDistributedSearchTestCase.addFields(doc, fields);
        this.indexDoc(doc);
    }

    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.controlClient.add(doc);
        if (this.shardCount == 0) {
            return;
        }
        int which = (doc.getField(this.id).toString().hashCode() & Integer.MAX_VALUE) % this.clients.size();
        SolrClient client = this.clients.get(which);
        client.add(doc);
    }

    protected UpdateResponse indexDoc(SolrClient client, SolrParams params, SolrInputDocument ... sdocs) throws IOException, SolrServerException {
        UpdateResponse controlRsp = this.add(this.controlClient, params, sdocs);
        UpdateResponse specificRsp = this.add(client, params, sdocs);
        this.compareSolrResponses((SolrResponse)specificRsp, (SolrResponse)controlRsp);
        return specificRsp;
    }

    protected UpdateResponse add(SolrClient client, SolrParams params, SolrInputDocument ... sdocs) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (SolrInputDocument sdoc : sdocs) {
            ureq.add(sdoc);
        }
        return (UpdateResponse)ureq.process(client);
    }

    protected UpdateResponse del(SolrClient client, SolrParams params, Object ... ids) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (Object id : ids) {
            ureq.deleteById(id.toString());
        }
        return (UpdateResponse)ureq.process(client);
    }

    protected UpdateResponse delQ(SolrClient client, SolrParams params, String ... queries) throws IOException, SolrServerException {
        UpdateRequest ureq = new UpdateRequest();
        ureq.setParams(new ModifiableSolrParams(params));
        for (String q : queries) {
            ureq.deleteByQuery(q);
        }
        return (UpdateResponse)ureq.process(client);
    }

    protected void index_specific(int serverNumber, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        this.controlClient.add(doc);
        SolrClient client = this.clients.get(serverNumber);
        client.add(doc);
    }

    protected void del(String q) throws Exception {
        this.controlClient.deleteByQuery(q);
        for (SolrClient client : this.clients) {
            client.deleteByQuery(q);
        }
    }

    protected void commit() throws Exception {
        this.controlClient.commit();
        for (SolrClient client : this.clients) {
            client.commit();
        }
    }

    protected QueryResponse queryServer(ModifiableSolrParams params) throws SolrServerException, IOException {
        int which = r.nextInt(this.clients.size());
        SolrClient client = this.clients.get(which);
        QueryResponse rsp = client.query((SolrParams)params);
        return rsp;
    }

    protected QueryResponse query(Object ... q) throws Exception {
        return this.query(true, q);
    }

    protected QueryResponse query(SolrParams params) throws Exception {
        return this.query(true, params);
    }

    protected QueryResponse query(boolean setDistribParams, Object[] q) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (int i = 0; i < q.length; i += 2) {
            params.add(q[i].toString(), new String[]{q[i + 1].toString()});
        }
        return this.query(setDistribParams, (SolrParams)params);
    }

    protected QueryResponse query(boolean setDistribParams, SolrParams p) throws Exception {
        final ModifiableSolrParams params = new ModifiableSolrParams(p);
        params.set("distrib", new String[]{"false"});
        final QueryResponse controlRsp = this.controlClient.query((SolrParams)params);
        this.validateControlData(controlRsp);
        if (this.shardCount == 0) {
            return controlRsp;
        }
        params.remove("distrib");
        if (setDistribParams) {
            this.setDistributedParams(params);
        }
        QueryResponse rsp = this.queryServer(params);
        this.compareResponses(rsp, controlRsp);
        if (this.stress > 0) {
            log.info("starting stress...");
            Thread[] threads = new Thread[this.nThreads];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        for (int j = 0; j < BaseDistributedSearchTestCase.this.stress; ++j) {
                            int which = r.nextInt(BaseDistributedSearchTestCase.this.clients.size());
                            SolrClient client = BaseDistributedSearchTestCase.this.clients.get(which);
                            try {
                                QueryResponse rsp = client.query((SolrParams)new ModifiableSolrParams((SolrParams)params));
                                if (!BaseDistributedSearchTestCase.this.verifyStress) continue;
                                BaseDistributedSearchTestCase.this.compareResponses(rsp, controlRsp);
                                continue;
                            }
                            catch (IOException | SolrServerException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                };
                threads[i].start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
        }
        return rsp;
    }

    public QueryResponse queryAndCompare(SolrParams params, SolrClient ... clients) throws SolrServerException, IOException {
        return this.queryAndCompare(params, Arrays.asList(clients));
    }

    public QueryResponse queryAndCompare(SolrParams params, Iterable<SolrClient> clients) throws SolrServerException, IOException {
        QueryResponse first = null;
        for (SolrClient client : clients) {
            QueryResponse rsp = client.query((SolrParams)new ModifiableSolrParams(params));
            if (first == null) {
                first = rsp;
                continue;
            }
            this.compareResponses(first, rsp);
        }
        return first;
    }

    public static boolean eq(String a, String b) {
        return a == b || a != null && a.equals(b);
    }

    public static int flags(Map<String, Integer> handle, Object key) {
        if (key == null) {
            return 0;
        }
        if (handle == null) {
            return 0;
        }
        Integer f = handle.get(key);
        return f == null ? 0 : f;
    }

    public static String compare(NamedList a, NamedList b, int flags, Map<String, Integer> handle) {
        boolean ordered;
        boolean bl = ordered = (flags & 8) == 0;
        if (!ordered) {
            HashMap<String, Object> mapA = new HashMap<String, Object>(a.size());
            for (int i = 0; i < a.size(); ++i) {
                Object object = mapA.put(a.getName(i), a.getVal(i));
            }
            HashMap<String, Object> mapB = new HashMap<String, Object>(b.size());
            for (int i = 0; i < b.size(); ++i) {
                Object object = mapB.put(b.getName(i), b.getVal(i));
            }
            return BaseDistributedSearchTestCase.compare(mapA, mapB, flags, handle);
        }
        int posa = 0;
        int posb = 0;
        int aSkipped = 0;
        int bSkipped = 0;
        while (posa < a.size() || posb < b.size()) {
            String cmp;
            String namea = null;
            String nameb = null;
            Object vala = null;
            Object valb = null;
            int flagsa = 0;
            int flagsb = 0;
            while (posa < a.size()) {
                namea = a.getName(posa);
                vala = a.getVal(posa);
                ++posa;
                flagsa = BaseDistributedSearchTestCase.flags(handle, namea);
                if ((flagsa & 2) == 0) break;
                namea = null;
                vala = null;
                ++aSkipped;
            }
            while (posb < b.size()) {
                nameb = b.getName(posb);
                valb = b.getVal(posb);
                ++posb;
                flagsb = BaseDistributedSearchTestCase.flags(handle, nameb);
                if ((flagsb & 2) != 0) {
                    nameb = null;
                    valb = null;
                    ++bSkipped;
                    continue;
                }
                if (BaseDistributedSearchTestCase.eq(namea, nameb)) break;
                return "." + namea + "!=" + nameb + " (unordered or missing)";
            }
            if ((flagsa & 4) != 0 || (cmp = BaseDistributedSearchTestCase.compare(vala, valb, flagsa, handle)) == null) continue;
            return "." + namea + cmp;
        }
        if (a.size() - aSkipped != b.size() - bSkipped) {
            return ".size()==" + a.size() + "," + b.size() + " skipped=" + aSkipped + "," + bSkipped;
        }
        return null;
    }

    public static String compare1(Map a, Map b, int flags, Map<String, Integer> handle) {
        for (Object keya : a.keySet()) {
            Object valb;
            String cmp;
            Object vala = a.get(keya);
            int flagsa = BaseDistributedSearchTestCase.flags(handle, keya);
            if ((flagsa & 2) != 0) continue;
            if (!b.containsKey(keya)) {
                return "[" + keya + "]==null";
            }
            if ((flagsa & 4) != 0 || (cmp = BaseDistributedSearchTestCase.compare(vala, valb = b.get(keya), flagsa, handle)) == null) continue;
            return "[" + keya + "]" + cmp;
        }
        return null;
    }

    public static String compare(Map a, Map b, int flags, Map<String, Integer> handle) {
        String cmp = BaseDistributedSearchTestCase.compare1(a, b, flags, handle);
        if (cmp != null) {
            return cmp;
        }
        return BaseDistributedSearchTestCase.compare1(b, a, flags, handle);
    }

    public static String compare(SolrDocument a, SolrDocument b, int flags, Map<String, Integer> handle) {
        return BaseDistributedSearchTestCase.compare(a.getFieldValuesMap(), b.getFieldValuesMap(), flags, handle);
    }

    public static String compare(SolrDocumentList a, SolrDocumentList b, int flags, Map<String, Integer> handle) {
        String cmp;
        boolean ordered = (flags & 8) == 0;
        int f = BaseDistributedSearchTestCase.flags(handle, "maxScore");
        if (f == 0) {
            cmp = BaseDistributedSearchTestCase.compare(a.getMaxScore(), b.getMaxScore(), 0, handle);
            if (cmp != null) {
                return ".maxScore" + cmp;
            }
        } else if ((f & 2) == 0) {
            assert ((f & 4) != 0);
            if (b.getMaxScore() != null && a.getMaxScore() == null) {
                return ".maxScore missing";
            }
        }
        if ((cmp = BaseDistributedSearchTestCase.compare(a.getNumFound(), b.getNumFound(), 0, handle)) != null) {
            return ".numFound" + cmp;
        }
        cmp = BaseDistributedSearchTestCase.compare(a.getStart(), b.getStart(), 0, handle);
        if (cmp != null) {
            return ".start" + cmp;
        }
        cmp = BaseDistributedSearchTestCase.compare(a.size(), b.size(), 0, handle);
        if (cmp != null) {
            return ".size()" + cmp;
        }
        if (ordered) {
            for (int i = 0; i < a.size(); ++i) {
                cmp = BaseDistributedSearchTestCase.compare((SolrDocument)a.get(i), (SolrDocument)b.get(i), 0, handle);
                if (cmp == null) continue;
                return "[" + i + "]" + cmp;
            }
            return null;
        }
        for (int i = 0; i < a.size(); ++i) {
            SolrDocument doc = (SolrDocument)a.get(i);
            Object key = doc.getFirstValue("id");
            SolrDocument docb = null;
            if (key == null) {
                docb = (SolrDocument)b.get(i);
            } else {
                for (int j = 0; j < b.size() && !key.equals((docb = (SolrDocument)b.get(j)).getFirstValue("id")); ++j) {
                }
            }
            cmp = BaseDistributedSearchTestCase.compare(doc, docb, 0, handle);
            if (cmp == null) continue;
            return "[id=" + key + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object[] a, Object[] b, int flags, Map<String, Integer> handle) {
        if (a.length != b.length) {
            return ".length:" + a.length + "!=" + b.length;
        }
        for (int i = 0; i < a.length; ++i) {
            String cmp = BaseDistributedSearchTestCase.compare(a[i], b[i], flags, handle);
            if (cmp == null) continue;
            return "[" + i + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object a, Object b, int flags, Map<String, Integer> handle) {
        if (a == b) {
            return null;
        }
        if (a == null || b == null) {
            return ":" + a + "!=" + b;
        }
        if (a instanceof NamedList && b instanceof NamedList) {
            return BaseDistributedSearchTestCase.compare((NamedList)a, (NamedList)b, flags, handle);
        }
        if (a instanceof SolrDocumentList && b instanceof SolrDocumentList) {
            return BaseDistributedSearchTestCase.compare((SolrDocumentList)a, (SolrDocumentList)b, flags, handle);
        }
        if (a instanceof SolrDocument && b instanceof SolrDocument) {
            return BaseDistributedSearchTestCase.compare((SolrDocument)a, (SolrDocument)b, flags, handle);
        }
        if (a instanceof Map && b instanceof Map) {
            return BaseDistributedSearchTestCase.compare((Map)a, (Map)b, flags, handle);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return BaseDistributedSearchTestCase.compare((Object[])a, (Object[])b, flags, handle);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            if (!Arrays.equals((byte[])a, (byte[])b)) {
                return ":" + a + "!=" + b;
            }
            return null;
        }
        if (a instanceof List && b instanceof List) {
            return BaseDistributedSearchTestCase.compare(((List)a).toArray(), ((List)b).toArray(), flags, handle);
        }
        if ((a instanceof Integer || a instanceof Long) && (b instanceof Integer || b instanceof Long)) {
            if (((Number)a).longValue() == ((Number)b).longValue()) {
                return null;
            }
            return ":" + a + "!=" + b;
        }
        if ((flags & FUZZY) != 0 && a instanceof Double && b instanceof Double) {
            double bbb;
            double aaa = (Double)a;
            if (aaa == (bbb = ((Double)b).doubleValue()) || ((Double)a).isNaN() && ((Double)b).isNaN()) {
                return null;
            }
            if (aaa == 0.0 || bbb == 0.0) {
                return ":" + a + "!=" + b;
            }
            double diff = Math.abs(aaa - bbb);
            double ratio = Math.max(Math.abs(diff / aaa), Math.abs(diff / bbb));
            if (ratio > 1.0E-8) {
                return ":" + a + "!=" + b;
            }
            return null;
        }
        if (!a.equals(b)) {
            return ":" + a + "!=" + b;
        }
        return null;
    }

    protected void compareSolrResponses(SolrResponse a, SolrResponse b) {
        this.handle.put("QTime", 4);
        this.handle.put("rf", 4);
        String cmp = BaseDistributedSearchTestCase.compare(a.getResponse(), b.getResponse(), this.flags, this.handle);
        if (cmp != null) {
            log.error("Mismatched responses:\n" + a + "\n" + b);
            Assert.fail((String)cmp);
        }
    }

    protected void compareResponses(QueryResponse a, QueryResponse b) {
        if (System.getProperty("remove.version.field") != null) {
            if (a.getResults() != null) {
                for (SolrDocument doc : a.getResults()) {
                    doc.removeFields("_version_");
                }
            }
            if (b.getResults() != null) {
                for (SolrDocument doc : b.getResults()) {
                    doc.removeFields("_version_");
                }
            }
        }
        if (a.getHeader() != null) {
            a.getHeader().remove("warnings");
        }
        if (b.getHeader() != null) {
            b.getHeader().remove("warnings");
        }
        this.compareSolrResponses((SolrResponse)a, (SolrResponse)b);
    }

    public static Object[] getRandFields(String[] fields, RandVal[] randVals) {
        Object[] o = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            o[i * 2] = fields[i];
            o[i * 2 + 1] = randVals[i].uval();
        }
        return o;
    }

    public void validateControlData(QueryResponse control) throws Exception {
    }

    protected String getSolrXml() {
        return null;
    }

    protected void seedSolrHome(File jettyHome) throws IOException {
        FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)jettyHome);
        String solrxml = this.getSolrXml();
        if (solrxml != null) {
            FileUtils.copyFile((File)new File(this.getSolrHome(), solrxml), (File)new File(jettyHome, "solr.xml"));
        }
    }

    private void seedCoreRootDirWithDefaultTestCore(Path coreRootDirectory) throws IOException {
        Path coreDir = coreRootDirectory.resolve("collection1");
        if (Files.notExists(coreDir.resolve("core.properties"), new LinkOption[0])) {
            this.writeCoreProperties(coreDir, "collection1");
        }
    }

    protected void setupJettySolrHome(File jettyHome) throws IOException {
        this.seedSolrHome(jettyHome);
        Files.createDirectories(jettyHome.toPath().resolve("cores").resolve("collection1"), new FileAttribute[0]);
    }

    static {
        FUZZY = 16;
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        rint = new RandVal(){

            @Override
            public Object val() {
                return r.nextInt();
            }
        };
        rlong = new RandVal(){

            @Override
            public Object val() {
                return r.nextLong();
            }
        };
        rfloat = new RandVal(){

            @Override
            public Object val() {
                return Float.valueOf(r.nextFloat());
            }
        };
        rdouble = new RandVal(){

            @Override
            public Object val() {
                return r.nextDouble();
            }
        };
        rdate = new RandDate();
        fieldNames = new String[]{"n_ti1", "n_f1", "n_tf1", "n_d1", "n_td1", "n_l1", "n_tl1", "n_dt1", "n_tdt1"};
        randVals = new RandVal[]{rint, rfloat, rfloat, rdouble, rdouble, rlong, rlong, rdate, rdate};
    }

    public static class RandDate
    extends RandVal {
        @Override
        public Object val() {
            long v = r.nextLong();
            Date d = new Date(v);
            return d.toInstant().toString();
        }
    }

    public static abstract class RandVal {
        public static Set uniqueValues = new HashSet();

        public abstract Object val();

        public Object uval() {
            Object v;
            while (!uniqueValues.add(v = this.val())) {
            }
            return v;
        }
    }

    public class ShardsRepeatRule
    implements TestRule {
        public Statement apply(Statement statement, Description description) {
            ShardsFixed fixed = (ShardsFixed)description.getAnnotation(ShardsFixed.class);
            ShardsRepeat repeat = (ShardsRepeat)description.getAnnotation(ShardsRepeat.class);
            if (fixed != null && repeat != null) {
                throw new RuntimeException("ShardsFixed and ShardsRepeat annotations can't coexist");
            }
            if (fixed != null) {
                return new ShardsFixedStatement(fixed.num(), statement);
            }
            if (repeat != null) {
                return new ShardsRepeatStatement(repeat.min(), repeat.max(), statement);
            }
            return BaseDistributedSearchTestCase.this.isShardCountFixed ? new ShardsFixedStatement(BaseDistributedSearchTestCase.this.shardCount, statement) : new ShardsRepeatStatement(1, 3, statement);
        }

        private class ShardsRepeatStatement
        extends ShardsStatement {
            private final int min;
            private final int max;
            private final Statement statement;

            private ShardsRepeatStatement(int min, int max, Statement statement) {
                this.min = min;
                this.max = max;
                this.statement = statement;
            }

            @Override
            public void callStatement() throws Throwable {
                BaseDistributedSearchTestCase.this.shardCount = this.min;
                while (BaseDistributedSearchTestCase.this.shardCount <= this.max) {
                    RandVal.uniqueValues = new HashSet();
                    BaseDistributedSearchTestCase.this.createServers(BaseDistributedSearchTestCase.this.shardCount);
                    try {
                        this.statement.evaluate();
                    }
                    finally {
                        BaseDistributedSearchTestCase.this.destroyServers();
                    }
                    BaseDistributedSearchTestCase.this.shardCount++;
                }
            }
        }

        private class ShardsFixedStatement
        extends ShardsStatement {
            private final int numShards;
            private final Statement statement;

            private ShardsFixedStatement(int numShards, Statement statement) {
                this.numShards = numShards;
                this.statement = statement;
            }

            @Override
            public void callStatement() throws Throwable {
                RandVal.uniqueValues = new HashSet();
                BaseDistributedSearchTestCase.this.fixShardCount(this.numShards);
                try {
                    BaseDistributedSearchTestCase.this.createServers(this.numShards);
                    this.statement.evaluate();
                }
                finally {
                    BaseDistributedSearchTestCase.this.destroyServers();
                }
            }
        }

        private abstract class ShardsStatement
        extends Statement {
            private ShardsStatement() {
            }

            protected abstract void callStatement() throws Throwable;

            public void evaluate() throws Throwable {
                BaseDistributedSearchTestCase.this.distribSetUp();
                if (!BaseDistributedSearchTestCase.this.distribSetUpCalled) {
                    Assert.fail((String)"One of the overrides of distribSetUp does not propagate the call.");
                }
                try {
                    this.callStatement();
                }
                finally {
                    BaseDistributedSearchTestCase.this.distribTearDown();
                    if (!BaseDistributedSearchTestCase.this.distribTearDownCalled) {
                        Assert.fail((String)"One of the overrides of distribTearDown does not propagate the call.");
                    }
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ShardsFixed {
        public int num();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ShardsRepeat {
        public int min() default 1;

        public int max() default 3;
    }
}

