/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.StaticService;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultRestRegistry
extends ServiceSupport
implements StaticService,
RestRegistry,
CamelContextAware {
    private CamelContext camelContext;
    private final Map<Consumer, RestRegistry.RestService> registry = new LinkedHashMap<Consumer, RestRegistry.RestService>();
    private transient Producer apiProducer;

    @Override
    public void addRestService(Consumer consumer, String url, String baseUrl, String basePath, String uriTemplate, String method, String consumes, String produces, String inType, String outType, String routeId, String description) {
        RestServiceEntry entry = new RestServiceEntry(consumer, url, baseUrl, basePath, uriTemplate, method, consumes, produces, inType, outType, routeId, description);
        this.registry.put(consumer, entry);
    }

    @Override
    public void removeRestService(Consumer consumer) {
        this.registry.remove(consumer);
    }

    @Override
    public List<RestRegistry.RestService> listAllRestServices() {
        return new ArrayList<RestRegistry.RestService>(this.registry.values());
    }

    @Override
    public int size() {
        return this.registry.size();
    }

    @Override
    public String apiDocAsJson() {
        if (this.apiProducer == null) {
            RestEndpoint rest;
            String componentName;
            Endpoint restApiEndpoint = null;
            Endpoint restEndpoint = null;
            for (Map.Entry<String, Endpoint> entry : this.camelContext.getEndpointMap().entrySet()) {
                String uri = entry.getKey();
                if (uri.startsWith("rest-api:")) {
                    restApiEndpoint = entry.getValue();
                    break;
                }
                if (restEndpoint != null || !uri.startsWith("rest:")) continue;
                restEndpoint = entry.getValue();
            }
            if (restApiEndpoint == null && restEndpoint != null && (componentName = (rest = (RestEndpoint)restEndpoint).getComponentName()) != null) {
                RestConfiguration config = this.camelContext.getRestConfiguration(componentName, true);
                String apiComponent = config.getApiComponent() != null ? config.getApiComponent() : "swagger";
                String path = config.getApiContextPath() != null ? config.getApiContextPath() : "api-doc";
                restApiEndpoint = this.camelContext.getEndpoint(String.format("rest-api:%s/%s?componentName=%s&apiComponentName=%s&contextIdPattern=#name#", path, this.camelContext.getName(), componentName, apiComponent));
            }
            if (restApiEndpoint != null) {
                try {
                    this.apiProducer = restApiEndpoint.createProducer();
                    this.camelContext.addService(this.apiProducer, true);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        if (this.apiProducer != null) {
            try {
                Exchange dummy = this.apiProducer.getEndpoint().createExchange();
                this.apiProducer.process(dummy);
                String json = dummy.hasOut() ? dummy.getOut().getBody(String.class) : dummy.getIn().getBody(String.class);
                return json;
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext", this);
        this.camelContext.addLifecycleStrategy(new RemoveRestServiceLifecycleStrategy());
    }

    @Override
    protected void doStop() throws Exception {
        this.registry.clear();
    }

    private final class RemoveRestServiceLifecycleStrategy
    extends LifecycleStrategySupport {
        private RemoveRestServiceLifecycleStrategy() {
        }

        @Override
        public void onServiceRemove(CamelContext context, Service service, Route route) {
            super.onServiceRemove(context, service, route);
            if (service instanceof Consumer) {
                DefaultRestRegistry.this.removeRestService((Consumer)service);
            }
        }
    }

    private final class RestServiceEntry
    implements RestRegistry.RestService {
        private final Consumer consumer;
        private final String url;
        private final String baseUrl;
        private final String basePath;
        private final String uriTemplate;
        private final String method;
        private final String consumes;
        private final String produces;
        private final String inType;
        private final String outType;
        private final String routeId;
        private final String description;

        private RestServiceEntry(Consumer consumer, String url, String baseUrl, String basePath, String uriTemplate, String method, String consumes, String produces, String inType, String outType, String routeId, String description) {
            this.consumer = consumer;
            this.url = url;
            this.baseUrl = baseUrl;
            this.basePath = basePath;
            this.uriTemplate = uriTemplate;
            this.method = method;
            this.consumes = consumes;
            this.produces = produces;
            this.inType = inType;
            this.outType = outType;
            this.routeId = routeId;
            this.description = description;
        }

        @Override
        public Consumer getConsumer() {
            return this.consumer;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public String getBasePath() {
            return this.basePath;
        }

        @Override
        public String getUriTemplate() {
            return this.uriTemplate;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public String getConsumes() {
            return this.consumes;
        }

        @Override
        public String getProduces() {
            return this.produces;
        }

        @Override
        public String getInType() {
            return this.inType;
        }

        @Override
        public String getOutType() {
            return this.outType;
        }

        @Override
        public String getState() {
            ServiceStatus status2 = null;
            if (this.consumer instanceof StatefulService) {
                status2 = ((StatefulService)((Object)this.consumer)).getStatus();
            }
            if (status2 == null) {
                status2 = ServiceStatus.Stopped;
            }
            return status2.name();
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

