/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;

@Metadata(label="dataformat,transformation", title="Protobuf")
@XmlRootElement(name="protobuf")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProtobufDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String instanceClass;
    @XmlTransient
    private Object defaultInstance;

    public ProtobufDataFormat() {
        super("protobuf");
    }

    public ProtobufDataFormat(String instanceClass) {
        this();
        this.setInstanceClass(instanceClass);
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(String instanceClass) {
        this.instanceClass = instanceClass;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public void setDefaultInstance(Object defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.instanceClass != null) {
            this.setProperty(camelContext, dataFormat, "instanceClass", this.instanceClass);
        }
        if (this.defaultInstance != null) {
            this.setProperty(camelContext, dataFormat, "defaultInstance", this.defaultInstance);
        }
    }
}

