/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class LinkedResource {
    private final Optional<String> id;
    private final String uri;
    private final String path;
    private final Set<Property> rel;
    private final Optional<String> refines;
    private final Optional<String> mimetype;

    public Optional<String> getId() {
        return this.id;
    }

    public String getURI() {
        return this.uri;
    }

    public String getPath() {
        return this.path;
    }

    public Set<Property> getRel() {
        return this.rel;
    }

    public Optional<String> getRefines() {
        return this.refines;
    }

    public Optional<String> getMimeType() {
        return this.mimetype;
    }

    private LinkedResource(Optional<String> id, String uri, String resource, Set<Property> rel, Optional<String> refines, Optional<String> mimetype) {
        this.id = Preconditions.checkNotNull(id);
        this.uri = Preconditions.checkNotNull(uri);
        this.path = Preconditions.checkNotNull(resource);
        this.rel = Preconditions.checkNotNull(rel);
        this.refines = Preconditions.checkNotNull(refines);
        this.mimetype = Preconditions.checkNotNull(mimetype);
    }

    public static final class Builder {
        private final String uri;
        private String id = null;
        private Set<Property> rel = null;
        private String refines = null;
        private String mimetype = null;

        public Builder(String uri) {
            this.uri = Preconditions.checkNotNull(uri).trim();
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder rel(Set<Property> rel) {
            this.rel = rel;
            return this;
        }

        public Builder refines(String refines) {
            this.refines = refines;
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        public LinkedResource build() {
            return new LinkedResource(this.optional(this.id), this.uri, this.uri.replaceFirst("#.*$", ""), this.rel == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.rel), this.optional(this.refines), this.optional(this.mimetype));
        }

        private Optional<String> optional(String string) {
            return Optional.fromNullable(Strings.emptyToNull(Strings.nullToEmpty(this.id).trim()));
        }
    }
}

