import{ExtensionButton,ExtensionPanel,ExtensionSidebarPane}from'./ExtensionPanel.js';import{ExtensionTraceProvider,TracingSession}from'./ExtensionTraceProvider.js';export class ExtensionServer extends Common.Object{constructor(){super();this._clientObjects={};this._handlers={};this._subscribers={};this._subscriptionStartHandlers={};this._subscriptionStopHandlers={};this._extraHeaders={};this._requests={};this._lastRequestId=0;this._registeredExtensions={};this._status=new ExtensionStatus();this._sidebarPanes=[];this._traceProviders=[];this._traceSessions=new Map();const commands=Extensions.extensionAPI.Commands;this._registerHandler(commands.AddRequestHeaders,this._onAddRequestHeaders.bind(this));this._registerHandler(commands.AddTraceProvider,this._onAddTraceProvider.bind(this));this._registerHandler(commands.ApplyStyleSheet,this._onApplyStyleSheet.bind(this));this._registerHandler(commands.CompleteTraceSession,this._onCompleteTraceSession.bind(this));this._registerHandler(commands.CreatePanel,this._onCreatePanel.bind(this));this._registerHandler(commands.CreateSidebarPane,this._onCreateSidebarPane.bind(this));this._registerHandler(commands.CreateToolbarButton,this._onCreateToolbarButton.bind(this));this._registerHandler(commands.EvaluateOnInspectedPage,this._onEvaluateOnInspectedPage.bind(this));this._registerHandler(commands.ForwardKeyboardEvent,this._onForwardKeyboardEvent.bind(this));this._registerHandler(commands.GetHAR,this._onGetHAR.bind(this));this._registerHandler(commands.GetPageResources,this._onGetPageResources.bind(this));this._registerHandler(commands.GetRequestContent,this._onGetRequestContent.bind(this));this._registerHandler(commands.GetResourceContent,this._onGetResourceContent.bind(this));this._registerHandler(commands.Reload,this._onReload.bind(this));this._registerHandler(commands.SetOpenResourceHandler,this._onSetOpenResourceHandler.bind(this));this._registerHandler(commands.SetResourceContent,this._onSetResourceContent.bind(this));this._registerHandler(commands.SetSidebarHeight,this._onSetSidebarHeight.bind(this));this._registerHandler(commands.SetSidebarContent,this._onSetSidebarContent.bind(this));this._registerHandler(commands.SetSidebarPage,this._onSetSidebarPage.bind(this));this._registerHandler(commands.ShowPanel,this._onShowPanel.bind(this));this._registerHandler(commands.Subscribe,this._onSubscribe.bind(this));this._registerHandler(commands.OpenResource,this._onOpenResource.bind(this));this._registerHandler(commands.Unsubscribe,this._onUnsubscribe.bind(this));this._registerHandler(commands.UpdateButton,this._onUpdateButton.bind(this));window.addEventListener('message',this._onWindowMessage.bind(this),false);const existingTabId=window.DevToolsAPI&&window.DevToolsAPI.getInspectedTabId&&window.DevToolsAPI.getInspectedTabId();if(existingTabId){this._setInspectedTabId({data:existingTabId});}
Host.InspectorFrontendHost.events.addEventListener(Host.InspectorFrontendHostAPI.Events.SetInspectedTabId,this._setInspectedTabId,this);this._initExtensions();}
initializeExtensions(){Host.InspectorFrontendHost.setAddExtensionCallback(this._addExtension.bind(this));}
hasExtensions(){return!!Object.keys(this._registeredExtensions).length;}
notifySearchAction(panelId,action,searchString){this._postNotification(Extensions.extensionAPI.Events.PanelSearch+panelId,action,searchString);}
notifyViewShown(identifier,frameIndex){this._postNotification(Extensions.extensionAPI.Events.ViewShown+identifier,frameIndex);}
notifyViewHidden(identifier){this._postNotification(Extensions.extensionAPI.Events.ViewHidden+identifier);}
notifyButtonClicked(identifier){this._postNotification(Extensions.extensionAPI.Events.ButtonClicked+identifier);}
_inspectedURLChanged(event){if(event.data!==self.SDK.targetManager.mainTarget()){return;}
this._requests={};const url=event.data.inspectedURL();this._postNotification(Extensions.extensionAPI.Events.InspectedURLChanged,url);}
startTraceRecording(providerId,sessionId,session){this._traceSessions.set(sessionId,session);this._postNotification('trace-recording-started-'+providerId,sessionId);}
stopTraceRecording(providerId){this._postNotification('trace-recording-stopped-'+providerId);}
hasSubscribers(type){return!!this._subscribers[type];}
_postNotification(type,vararg){const subscribers=this._subscribers[type];if(!subscribers){return;}
const message={command:'notify-'+type,arguments:Array.prototype.slice.call(arguments,1)};for(let i=0;i<subscribers.length;++i){subscribers[i].postMessage(message);}}
_onSubscribe(message,port){const subscribers=this._subscribers[message.type];if(subscribers){subscribers.push(port);}else{this._subscribers[message.type]=[port];if(this._subscriptionStartHandlers[message.type]){this._subscriptionStartHandlers[message.type]();}}}
_onUnsubscribe(message,port){const subscribers=this._subscribers[message.type];if(!subscribers){return;}
subscribers.remove(port);if(!subscribers.length){delete this._subscribers[message.type];if(this._subscriptionStopHandlers[message.type]){this._subscriptionStopHandlers[message.type]();}}}
_onAddRequestHeaders(message){const id=message.extensionId;if(typeof id!=='string'){return this._status.E_BADARGTYPE('extensionId',typeof id,'string');}
let extensionHeaders=this._extraHeaders[id];if(!extensionHeaders){extensionHeaders={};this._extraHeaders[id]=extensionHeaders;}
for(const name in message.headers){extensionHeaders[name]=message.headers[name];}
const allHeaders=({});for(const extension in this._extraHeaders){const headers=this._extraHeaders[extension];for(const name in headers){if(typeof headers[name]==='string'){allHeaders[name]=headers[name];}}}
self.SDK.multitargetNetworkManager.setExtraHTTPHeaders(allHeaders);}
_onApplyStyleSheet(message){if(!Root.Runtime.experiments.isEnabled('applyCustomStylesheet')){return;}
const styleSheet=createElement('style');styleSheet.textContent=message.styleSheet;document.head.appendChild(styleSheet);self.UI.themeSupport.addCustomStylesheet(message.styleSheet);for(let node=document.body;node;node=node.traverseNextNode(document.body)){if(node instanceof ShadowRoot){self.UI.themeSupport.injectCustomStyleSheets(node);}}}
_onCreatePanel(message,port){const id=message.id;if(id in this._clientObjects||self.UI.inspectorView.hasPanel(id)){return this._status.E_EXISTS(id);}
const page=this._expandResourcePath(port._extensionOrigin,message.page);let persistentId=port._extensionOrigin+message.title;persistentId=persistentId.replace(/\s/g,'');const panelView=new ExtensionServerPanelView(persistentId,message.title,new ExtensionPanel(this,persistentId,id,page));this._clientObjects[id]=panelView;self.UI.inspectorView.addPanel(panelView);return this._status.OK();}
_onShowPanel(message){let panelViewId=message.id;const panelView=this._clientObjects[message.id];if(panelView&&panelView instanceof ExtensionServerPanelView){panelViewId=panelView.viewId();}
self.UI.inspectorView.showPanel(panelViewId);}
_onCreateToolbarButton(message,port){const panelView=this._clientObjects[message.panel];if(!panelView||!(panelView instanceof ExtensionServerPanelView)){return this._status.E_NOTFOUND(message.panel);}
const button=new ExtensionButton(this,message.id,this._expandResourcePath(port._extensionOrigin,message.icon),message.tooltip,message.disabled);this._clientObjects[message.id]=button;panelView.widget().then(appendButton);function appendButton(panel){(panel).addToolbarItem(button.toolbarButton());}
return this._status.OK();}
_onUpdateButton(message,port){const button=this._clientObjects[message.id];if(!button||!(button instanceof ExtensionButton)){return this._status.E_NOTFOUND(message.id);}
button.update(this._expandResourcePath(port._extensionOrigin,message.icon),message.tooltip,message.disabled);return this._status.OK();}
_onCompleteTraceSession(message){const session=this._traceSessions.get(message.id);if(!session){return this._status.E_NOTFOUND(message.id);}
this._traceSessions.delete(message.id);session.complete(message.url,message.timeOffset);}
_onCreateSidebarPane(message){if(message.panel!=='elements'&&message.panel!=='sources'){return this._status.E_NOTFOUND(message.panel);}
const id=message.id;const sidebar=new ExtensionSidebarPane(this,message.panel,message.title,id);this._sidebarPanes.push(sidebar);this._clientObjects[id]=sidebar;this.dispatchEventToListeners(Events.SidebarPaneAdded,sidebar);return this._status.OK();}
sidebarPanes(){return this._sidebarPanes;}
_onSetSidebarHeight(message){const sidebar=this._clientObjects[message.id];if(!sidebar){return this._status.E_NOTFOUND(message.id);}
sidebar.setHeight(message.height);return this._status.OK();}
_onSetSidebarContent(message,port){const sidebar=this._clientObjects[message.id];if(!sidebar){return this._status.E_NOTFOUND(message.id);}
function callback(error){const result=error?this._status.E_FAILED(error):this._status.OK();this._dispatchCallback(message.requestId,port,result);}
if(message.evaluateOnPage){return sidebar.setExpression(message.expression,message.rootTitle,message.evaluateOptions,port._extensionOrigin,callback.bind(this));}
sidebar.setObject(message.expression,message.rootTitle,callback.bind(this));}
_onSetSidebarPage(message,port){const sidebar=this._clientObjects[message.id];if(!sidebar){return this._status.E_NOTFOUND(message.id);}
sidebar.setPage(this._expandResourcePath(port._extensionOrigin,message.page));}
_onOpenResource(message){const uiSourceCode=self.Workspace.workspace.uiSourceCodeForURL(message.url);if(uiSourceCode){Common.Revealer.reveal(uiSourceCode.uiLocation(message.lineNumber,0));return this._status.OK();}
const resource=Bindings.resourceForURL(message.url);if(resource){Common.Revealer.reveal(resource);return this._status.OK();}
const request=self.SDK.networkLog.requestForURL(message.url);if(request){Common.Revealer.reveal(request);return this._status.OK();}
return this._status.E_NOTFOUND(message.url);}
_onSetOpenResourceHandler(message,port){const name=this._registeredExtensions[port._extensionOrigin].name||('Extension '+port._extensionOrigin);if(message.handlerPresent){Components.Linkifier.registerLinkHandler(name,this._handleOpenURL.bind(this,port));}else{Components.Linkifier.unregisterLinkHandler(name);}}
_handleOpenURL(port,contentProvider,lineNumber){port.postMessage({command:'open-resource',resource:this._makeResource(contentProvider),lineNumber:lineNumber+1});}
_onReload(message){const options=(message.options||{});self.SDK.multitargetNetworkManager.setUserAgentOverride(typeof options.userAgent==='string'?options.userAgent:'');let injectedScript;if(options.injectedScript){injectedScript='(function(){'+options.injectedScript+'})()';}
SDK.ResourceTreeModel.reloadAllPages(!!options.ignoreCache,injectedScript);return this._status.OK();}
_onEvaluateOnInspectedPage(message,port){function callback(error,object,wasThrown){let result;if(error||!object){result=this._status.E_PROTOCOLERROR(error.toString());}else if(wasThrown){result={isException:true,value:object.description};}else{result={value:object.value};}
this._dispatchCallback(message.requestId,port,result);}
return this.evaluate(message.expression,true,true,message.evaluateOptions,port._extensionOrigin,callback.bind(this));}
async _onGetHAR(){const requests=self.SDK.networkLog.requests();const harLog=await SDK.HARLog.build(requests);for(let i=0;i<harLog.entries.length;++i){harLog.entries[i]._requestId=this._requestId(requests[i]);}
return harLog;}
_makeResource(contentProvider){return{url:contentProvider.contentURL(),type:contentProvider.contentType().name()};}
_onGetPageResources(){const resources=new Map();function pushResourceData(contentProvider){if(!resources.has(contentProvider.contentURL())){resources.set(contentProvider.contentURL(),this._makeResource(contentProvider));}}
let uiSourceCodes=self.Workspace.workspace.uiSourceCodesForProjectType(Workspace.projectTypes.Network);uiSourceCodes=uiSourceCodes.concat(self.Workspace.workspace.uiSourceCodesForProjectType(Workspace.projectTypes.ContentScripts));uiSourceCodes.forEach(pushResourceData.bind(this));for(const resourceTreeModel of self.SDK.targetManager.models(SDK.ResourceTreeModel)){resourceTreeModel.forAllResources(pushResourceData.bind(this));}
return resources.valuesArray();}
async _getResourceContent(contentProvider,message,port){const{content}=await contentProvider.requestContent();const encoded=await contentProvider.contentEncoded();this._dispatchCallback(message.requestId,port,{encoding:encoded?'base64':'',content:content});}
_onGetRequestContent(message,port){const request=this._requestById(message.id);if(!request){return this._status.E_NOTFOUND(message.id);}
this._getResourceContent(request,message,port);}
_onGetResourceContent(message,port){const url=(message.url);const contentProvider=self.Workspace.workspace.uiSourceCodeForURL(url)||Bindings.resourceForURL(url);if(!contentProvider){return this._status.E_NOTFOUND(url);}
this._getResourceContent(contentProvider,message,port);}
_onSetResourceContent(message,port){function callbackWrapper(error){const response=error?this._status.E_FAILED(error):this._status.OK();this._dispatchCallback(message.requestId,port,response);}
const url=(message.url);const uiSourceCode=self.Workspace.workspace.uiSourceCodeForURL(url);if(!uiSourceCode||!uiSourceCode.contentType().isDocumentOrScriptOrStyleSheet()){const resource=SDK.ResourceTreeModel.resourceForURL(url);if(!resource){return this._status.E_NOTFOUND(url);}
return this._status.E_NOTSUPPORTED('Resource is not editable');}
uiSourceCode.setWorkingCopy(message.content);if(message.commit){uiSourceCode.commitWorkingCopy();}
callbackWrapper.call(this,null);}
_requestId(request){if(!request._extensionRequestId){request._extensionRequestId=++this._lastRequestId;this._requests[request._extensionRequestId]=request;}
return request._extensionRequestId;}
_requestById(id){return this._requests[id];}
_onAddTraceProvider(message,port){const provider=new ExtensionTraceProvider(port._extensionOrigin,message.id,message.categoryName,message.categoryTooltip);this._clientObjects[message.id]=provider;this._traceProviders.push(provider);this.dispatchEventToListeners(Events.TraceProviderAdded,provider);}
traceProviders(){return this._traceProviders;}
_onForwardKeyboardEvent(message){message.entries.forEach(handleEventEntry);function handleEventEntry(entry){const event=new window.KeyboardEvent(entry.eventType,{key:entry.key,code:entry.code,keyCode:entry.keyCode,location:entry.location,ctrlKey:entry.ctrlKey,altKey:entry.altKey,shiftKey:entry.shiftKey,metaKey:entry.metaKey});event.__keyCode=keyCodeForEntry(entry);document.dispatchEvent(event);}
function keyCodeForEntry(entry){let keyCode=entry.keyCode;if(!keyCode){if(entry.key==='Escape'){keyCode=27;}}
return keyCode||0;}}
_dispatchCallback(requestId,port,result){if(requestId){port.postMessage({command:'callback',requestId:requestId,result:result});}}
_initExtensions(){this._registerAutosubscriptionHandler(Extensions.extensionAPI.Events.ResourceAdded,self.Workspace.workspace,Workspace.Workspace.Events.UISourceCodeAdded,this._notifyResourceAdded);this._registerAutosubscriptionTargetManagerHandler(Extensions.extensionAPI.Events.NetworkRequestFinished,SDK.NetworkManager,SDK.NetworkManager.Events.RequestFinished,this._notifyRequestFinished);function onElementsSubscriptionStarted(){self.UI.context.addFlavorChangeListener(SDK.DOMNode,this._notifyElementsSelectionChanged,this);}
function onElementsSubscriptionStopped(){self.UI.context.removeFlavorChangeListener(SDK.DOMNode,this._notifyElementsSelectionChanged,this);}
this._registerSubscriptionHandler(Extensions.extensionAPI.Events.PanelObjectSelected+'elements',onElementsSubscriptionStarted.bind(this),onElementsSubscriptionStopped.bind(this));this._registerResourceContentCommittedHandler(this._notifyUISourceCodeContentCommitted);self.SDK.targetManager.addEventListener(SDK.TargetManager.Events.InspectedURLChanged,this._inspectedURLChanged,this);}
_notifyResourceAdded(event){const uiSourceCode=(event.data);this._postNotification(Extensions.extensionAPI.Events.ResourceAdded,this._makeResource(uiSourceCode));}
_notifyUISourceCodeContentCommitted(event){const uiSourceCode=(event.data.uiSourceCode);const content=(event.data.content);this._postNotification(Extensions.extensionAPI.Events.ResourceContentCommitted,this._makeResource(uiSourceCode),content);}
async _notifyRequestFinished(event){const request=(event.data);const entry=await SDK.HARLog.Entry.build(request);this._postNotification(Extensions.extensionAPI.Events.NetworkRequestFinished,this._requestId(request),entry);}
_notifyElementsSelectionChanged(){this._postNotification(Extensions.extensionAPI.Events.PanelObjectSelected+'elements');}
sourceSelectionChanged(url,range){this._postNotification(Extensions.extensionAPI.Events.PanelObjectSelected+'sources',{startLine:range.startLine,startColumn:range.startColumn,endLine:range.endLine,endColumn:range.endColumn,url:url,});}
_setInspectedTabId(event){this._inspectedTabId=(event.data);}
_addExtension(extensionInfo){const urlOriginRegExp=new RegExp('([^:]+:\/\/[^/]*)\/');const startPage=extensionInfo.startPage;const name=extensionInfo.name;try{const originMatch=urlOriginRegExp.exec(startPage);if(!originMatch){console.error('Skipping extension with invalid URL: '+startPage);return false;}
const extensionOrigin=originMatch[1];if(!this._registeredExtensions[extensionOrigin]){const injectedAPI=self.buildExtensionAPIInjectedScript(extensionInfo,this._inspectedTabId,self.UI.themeSupport.themeName(),self.UI.shortcutRegistry.globalShortcutKeys(),self.Extensions.extensionServer['_extensionAPITestHook']);Host.InspectorFrontendHost.setInjectedScriptForOrigin(extensionOrigin,injectedAPI);this._registeredExtensions[extensionOrigin]={name:name};}
const iframe=createElement('iframe');iframe.src=startPage;iframe.style.display='none';document.body.appendChild(iframe);}catch(e){console.error('Failed to initialize extension '+startPage+':'+e);return false;}
return true;}
_registerExtension(origin,port){if(!this._registeredExtensions.hasOwnProperty(origin)){if(origin!==window.location.origin)
{console.error('Ignoring unauthorized client request from '+origin);}
return;}
port._extensionOrigin=origin;port.addEventListener('message',this._onmessage.bind(this),false);port.start();}
_onWindowMessage(event){if(event.data==='registerExtension'){this._registerExtension(event.origin,event.ports[0]);}}
async _onmessage(event){const message=event.data;let result;if(message.command in this._handlers){result=await this._handlers[message.command](message,event.target);}else{result=this._status.E_NOTSUPPORTED(message.command);}
if(result&&message.requestId){this._dispatchCallback(message.requestId,event.target,result);}}
_registerHandler(command,callback){console.assert(command);this._handlers[command]=callback;}
_registerSubscriptionHandler(eventTopic,onSubscribeFirst,onUnsubscribeLast){this._subscriptionStartHandlers[eventTopic]=onSubscribeFirst;this._subscriptionStopHandlers[eventTopic]=onUnsubscribeLast;}
_registerAutosubscriptionHandler(eventTopic,eventTarget,frontendEventType,handler){this._registerSubscriptionHandler(eventTopic,eventTarget.addEventListener.bind(eventTarget,frontendEventType,handler,this),eventTarget.removeEventListener.bind(eventTarget,frontendEventType,handler,this));}
_registerAutosubscriptionTargetManagerHandler(eventTopic,modelClass,frontendEventType,handler){this._registerSubscriptionHandler(eventTopic,self.SDK.targetManager.addModelListener.bind(self.SDK.targetManager,modelClass,frontendEventType,handler,this),self.SDK.targetManager.removeModelListener.bind(self.SDK.targetManager,modelClass,frontendEventType,handler,this));}
_registerResourceContentCommittedHandler(handler){function addFirstEventListener(){self.Workspace.workspace.addEventListener(Workspace.Workspace.Events.WorkingCopyCommittedByUser,handler,this);self.Workspace.workspace.setHasResourceContentTrackingExtensions(true);}
function removeLastEventListener(){self.Workspace.workspace.setHasResourceContentTrackingExtensions(false);self.Workspace.workspace.removeEventListener(Workspace.Workspace.Events.WorkingCopyCommittedByUser,handler,this);}
this._registerSubscriptionHandler(Extensions.extensionAPI.Events.ResourceContentCommitted,addFirstEventListener.bind(this),removeLastEventListener.bind(this));}
_expandResourcePath(extensionPath,resourcePath){if(!resourcePath){return;}
return extensionPath+this._normalizePath(resourcePath);}
_normalizePath(path){const source=path.split('/');const result=[];for(let i=0;i<source.length;++i){if(source[i]==='.'){continue;}
if(source[i]===''){continue;}
if(source[i]==='..'){result.pop();}else{result.push(source[i]);}}
return'/'+result.join('/');}
evaluate(expression,exposeCommandLineAPI,returnByValue,options,securityOrigin,callback){let context;function resolveURLToFrame(url){let found;function hasMatchingURL(frame){found=(frame.url===url)?frame:null;return found;}
SDK.ResourceTreeModel.frames().some(hasMatchingURL);return found;}
options=options||{};let frame;if(options.frameURL){frame=resolveURLToFrame(options.frameURL);}else{const target=self.SDK.targetManager.mainTarget();const resourceTreeModel=target&&target.model(SDK.ResourceTreeModel);frame=resourceTreeModel&&resourceTreeModel.mainFrame;}
if(!frame){if(options.frameURL){console.warn('evaluate: there is no frame with URL '+options.frameURL);}else{console.warn('evaluate: the main frame is not yet available');}
return this._status.E_NOTFOUND(options.frameURL||'<top>');}
let contextSecurityOrigin;if(options.useContentScriptContext){contextSecurityOrigin=securityOrigin;}else if(options.scriptExecutionContext){contextSecurityOrigin=options.scriptExecutionContext;}
const runtimeModel=frame.resourceTreeModel().target().model(SDK.RuntimeModel);const executionContexts=runtimeModel?runtimeModel.executionContexts():[];if(contextSecurityOrigin){for(let i=0;i<executionContexts.length;++i){const executionContext=executionContexts[i];if(executionContext.frameId===frame.id&&executionContext.origin===contextSecurityOrigin&&!executionContext.isDefault){context=executionContext;}}
if(!context){console.warn('The JavaScript context '+contextSecurityOrigin+' was not found in the frame '+frame.url);return this._status.E_NOTFOUND(contextSecurityOrigin);}}else{for(let i=0;i<executionContexts.length;++i){const executionContext=executionContexts[i];if(executionContext.frameId===frame.id&&executionContext.isDefault){context=executionContext;}}
if(!context){return this._status.E_FAILED(frame.url+' has no execution context');}}
context.evaluate({expression:expression,objectGroup:'extension',includeCommandLineAPI:exposeCommandLineAPI,silent:true,returnByValue:returnByValue,generatePreview:false},false,false).then(onEvaluate);function onEvaluate(result){if(result.error){callback(result.error,null,false);return;}
callback(null,result.object||null,!!result.exceptionDetails);}}}
export const Events={SidebarPaneAdded:Symbol('SidebarPaneAdded'),TraceProviderAdded:Symbol('TraceProviderAdded')};class ExtensionServerPanelView extends UI.SimpleView{constructor(name,title,panel){super(title);this._name=name;this._panel=panel;}
viewId(){return this._name;}
widget(){return(Promise.resolve(this._panel));}}
export class ExtensionStatus{constructor(){function makeStatus(code,description){const details=Array.prototype.slice.call(arguments,2);const status={code:code,description:description,details:details};if(code!=='OK'){status.isError=true;console.error('Extension server error: '+String.vsprintf(description,details));}
return status;}
this.OK=makeStatus.bind(null,'OK','OK');this.E_EXISTS=makeStatus.bind(null,'E_EXISTS','Object already exists: %s');this.E_BADARG=makeStatus.bind(null,'E_BADARG','Invalid argument %s: %s');this.E_BADARGTYPE=makeStatus.bind(null,'E_BADARGTYPE','Invalid type for argument %s: got %s, expected %s');this.E_NOTFOUND=makeStatus.bind(null,'E_NOTFOUND','Object not found: %s');this.E_NOTSUPPORTED=makeStatus.bind(null,'E_NOTSUPPORTED','Object does not support requested operation: %s');this.E_PROTOCOLERROR=makeStatus.bind(null,'E_PROTOCOLERROR','Inspector protocol error: %s');this.E_FAILED=makeStatus.bind(null,'E_FAILED','Operation failed: %s');}}