"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var specs_1 = require("../utils/specs");
var scales_1 = require("../../../utils/scales/scales");
var spec_factory_1 = require("../../../state/spec_factory");
var chart_types_1 = require("../../../chart_types");
var defaultProps = {
    chartType: chart_types_1.ChartTypes.XYAxis,
    specType: specs_1.SpecTypes.Series,
    seriesType: specs_1.SeriesTypes.Bar,
    groupId: specs_1.DEFAULT_GLOBAL_ID,
    xScaleType: scales_1.ScaleType.Linear,
    yScaleType: scales_1.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    yScaleToDataExtent: false,
    hideInLegend: false,
    enableHistogramMode: true,
};
exports.HistogramBarSeries = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(defaultProps));
//# sourceMappingURL=histogram_bar_series.js.map