"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var index_1 = require("../../../index");
var get_computed_scales_1 = require("./get_computed_scales");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var is_brush_available_1 = require("./is_brush_available");
var getLastDragSelector = function (state) { return state.interactions.pointer.lastDrag; };
function hasDragged(prevProps, nextProps) {
    if (nextProps === null) {
        return false;
    }
    if (!nextProps.settings || !nextProps.settings.onBrushEnd) {
        return false;
    }
    var prevLastDrag = prevProps !== null ? prevProps.lastDrag : null;
    var nextLastDrag = nextProps !== null ? nextProps.lastDrag : null;
    if (prevLastDrag === null && nextLastDrag !== null) {
        return true;
    }
    if (prevLastDrag !== null && nextLastDrag !== null && prevLastDrag.end.time !== nextLastDrag.end.time) {
        return true;
    }
    return false;
}
/**
 * Will call the onBrushEnd listener every time the following preconditions are met:
 * - the onBrushEnd listener is available
 * - we dragged the mouse pointer
 */
function createOnBrushEndCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === index_1.ChartTypes.XYAxis) {
            if (!is_brush_available_1.isBrushAvailableSelector(state)) {
                selector = null;
                prevProps = null;
                return;
            }
            selector = re_reselect_1.default([
                getLastDragSelector,
                get_settings_specs_1.getSettingsSpecSelector,
                get_computed_scales_1.getComputedScalesSelector,
                compute_chart_dimensions_1.computeChartDimensionsSelector,
                is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
            ], function (lastDrag, settings, computedScales, _a, histogramMode) {
                var chartDimensions = _a.chartDimensions;
                var nextProps = {
                    lastDrag: lastDrag,
                    settings: settings,
                };
                if (lastDrag !== null && hasDragged(prevProps, nextProps)) {
                    if (settings && settings.onBrushEnd) {
                        var minValue = Math.min(lastDrag.start.position.x, lastDrag.end.position.x);
                        var maxValue = Math.max(lastDrag.start.position.x, lastDrag.end.position.x);
                        if (maxValue === minValue) {
                            // if 0 size brush, avoid computing the value
                            return;
                        }
                        var xScale = computedScales.xScale;
                        var offset = histogramMode ? 0 : -(xScale.bandwidth + xScale.bandwidthPadding) / 2;
                        var min = xScale.invert(minValue - chartDimensions.left + offset);
                        var max = xScale.invert(maxValue - chartDimensions.left + offset);
                        settings.onBrushEnd(min, max);
                    }
                }
                prevProps = nextProps;
            })({
                keySelector: function (state) { return state.chartId; },
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnBrushEndCaller = createOnBrushEndCaller;
//# sourceMappingURL=on_brush_end_caller.js.map