"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var y_domain_1 = require("../domains/y_domain");
var nonstacked_series_utils_1 = require("./nonstacked_series_utils");
var specs_1 = require("./specs");
var stacked_series_utils_1 = require("./stacked_series_utils");
var scales_1 = require("../../../utils/scales/scales");
function getSeriesIndex(series, target) {
    if (!series) {
        return -1;
    }
    return series.findIndex(function (_a) {
        var key = _a.key;
        return target.key === key;
    });
}
exports.getSeriesIndex = getSeriesIndex;
/**
 * Split a dataset into multiple series depending on the accessors.
 * Each series is then associated with a key thats belong to its configuration.
 *
 */
function splitSeries(_a) {
    var specId = _a.id, data = _a.data, xAccessor = _a.xAccessor, yAccessors = _a.yAccessors, y0Accessors = _a.y0Accessors, _b = _a.splitSeriesAccessors, splitSeriesAccessors = _b === void 0 ? [] : _b;
    var isMultipleY = yAccessors && yAccessors.length > 1;
    var series = new Map();
    var colorsValues = new Set();
    var xValues = new Set();
    data.forEach(function (datum) {
        var splitAccessors = getSplitAccessors(datum, splitSeriesAccessors);
        if (isMultipleY) {
            yAccessors.forEach(function (accessor, index) {
                var cleanedDatum = cleanDatum(datum, xAccessor, accessor, y0Accessors && y0Accessors[index]);
                if (cleanedDatum.x !== null && cleanedDatum.x !== undefined) {
                    xValues.add(cleanedDatum.x);
                    var seriesKey = updateSeriesMap(series, splitAccessors, accessor, cleanedDatum, specId);
                    colorsValues.add(seriesKey);
                }
            });
        }
        else {
            var cleanedDatum = cleanDatum(datum, xAccessor, yAccessors[0], y0Accessors && y0Accessors[0]);
            if (cleanedDatum.x !== null && cleanedDatum.x !== undefined) {
                xValues.add(cleanedDatum.x);
                var seriesKey = updateSeriesMap(series, splitAccessors, yAccessors[0], cleanedDatum, specId);
                colorsValues.add(seriesKey);
            }
        }
    });
    return {
        rawDataSeries: __spread(series.values()),
        colorsValues: colorsValues,
        xValues: xValues,
    };
}
exports.splitSeries = splitSeries;
/**
 * Gets global series key to id any series as a string
 */
function getSeriesKey(_a) {
    var specId = _a.specId, yAccessor = _a.yAccessor, splitAccessors = _a.splitAccessors;
    var joinedAccessors = __spread(splitAccessors.entries()).sort(function (_a, _b) {
        var _c = __read(_a, 1), a = _c[0];
        var _d = __read(_b, 1), b = _d[0];
        return (a > b ? 1 : -1);
    })
        .map(function (_a) {
        var _b = __read(_a, 2), key = _b[0], value = _b[1];
        return key + "-" + value;
    })
        .join('|');
    return "spec{" + specId + "}yAccessor{" + yAccessor + "}splitAccessors{" + joinedAccessors + "}";
}
exports.getSeriesKey = getSeriesKey;
/**
 * Mutate the passed map adding or updating the DataSeries stored
 * along with the series key
 */
function updateSeriesMap(seriesMap, splitAccessors, accessor, datum, specId) {
    var seriesKeys = __spread(splitAccessors.values(), [accessor]);
    var seriesKey = getSeriesKey({
        specId: specId,
        yAccessor: accessor,
        splitAccessors: splitAccessors,
    });
    var series = seriesMap.get(seriesKey);
    if (series) {
        series.data.push(datum);
    }
    else {
        seriesMap.set(seriesKey, {
            specId: specId,
            yAccessor: accessor,
            splitAccessors: splitAccessors,
            data: [datum],
            key: seriesKey,
            seriesKeys: seriesKeys,
        });
    }
    return seriesKey;
}
/**
 * Get the array of values that forms a series key
 */
function getSplitAccessors(datum, accessors) {
    if (accessors === void 0) { accessors = []; }
    var splitAccessors = new Map();
    accessors.forEach(function (accessor) {
        var value = datum[accessor];
        if (value !== undefined || value !== null) {
            splitAccessors.set(accessor, value);
        }
    });
    return splitAccessors;
}
/**
 * Reformat the datum having only the required x and y property.
 */
function cleanDatum(datum, xAccessor, yAccessor, y0Accessor) {
    var x = datum[xAccessor];
    var y1 = castToNumber(datum[yAccessor]);
    var cleanedDatum = { x: x, y1: y1, datum: datum, y0: null };
    if (y0Accessor) {
        cleanedDatum.y0 = castToNumber(datum[y0Accessor]);
    }
    return cleanedDatum;
}
exports.cleanDatum = cleanDatum;
function castToNumber(value) {
    if (value === null || value === undefined) {
        return null;
    }
    var num = Number(value);
    return isNaN(num) ? null : num;
}
function getFormattedDataseries(specs, dataSeries, xValues, xScaleType, seriesSpecs) {
    var specsByGroupIds = y_domain_1.splitSpecsByGroupId(specs);
    var specsByGroupIdsEntries = __spread(specsByGroupIds.entries());
    var stackedFormattedDataSeries = [];
    var nonStackedFormattedDataSeries = [];
    specsByGroupIdsEntries.forEach(function (_a) {
        var _b = __read(_a, 2), groupId = _b[0], groupSpecs = _b[1];
        var isPercentageStack = groupSpecs.isPercentageStack;
        // format stacked data series
        var stackedDataSeries = getRawDataSeries(groupSpecs.stacked, dataSeries);
        var stackedDataSeriesValues = stacked_series_utils_1.formatStackedDataSeriesValues(stackedDataSeries.rawDataSeries, false, isPercentageStack, xValues, xScaleType);
        stackedFormattedDataSeries.push({
            groupId: groupId,
            counts: stackedDataSeries.counts,
            dataSeries: stackedDataSeriesValues,
        });
        // format non stacked data series
        var nonStackedDataSeries = getRawDataSeries(groupSpecs.nonStacked, dataSeries);
        nonStackedFormattedDataSeries.push({
            groupId: groupId,
            counts: nonStackedDataSeries.counts,
            dataSeries: nonstacked_series_utils_1.formatNonStackedDataSeriesValues(nonStackedDataSeries.rawDataSeries, false, seriesSpecs, xScaleType),
        });
    });
    return {
        stacked: stackedFormattedDataSeries.filter(function (ds) { return ds.dataSeries.length > 0; }),
        nonStacked: nonStackedFormattedDataSeries.filter(function (ds) { return ds.dataSeries.length > 0; }),
    };
}
exports.getFormattedDataseries = getFormattedDataseries;
function getRawDataSeries(seriesSpecs, dataSeries) {
    var rawDataSeries = [];
    var counts = {
        barSeries: 0,
        lineSeries: 0,
        areaSeries: 0,
    };
    var seriesSpecsCount = seriesSpecs.length;
    var i = 0;
    for (; i < seriesSpecsCount; i++) {
        var spec = seriesSpecs[i];
        var id = spec.id, seriesType = spec.seriesType;
        var ds = dataSeries.get(id);
        switch (seriesType) {
            case specs_1.SeriesTypes.Bar:
                counts.barSeries += ds ? ds.length : 0;
                break;
            case specs_1.SeriesTypes.Line:
                counts.lineSeries += ds ? ds.length : 0;
                break;
            case specs_1.SeriesTypes.Area:
                counts.areaSeries += ds ? ds.length : 0;
                break;
        }
        if (ds) {
            rawDataSeries.push.apply(rawDataSeries, __spread(ds));
        }
    }
    return {
        rawDataSeries: rawDataSeries,
        counts: counts,
    };
}
/**
 *
 * @param seriesSpecs the map for all the series spec
 * @param deselectedDataSeries the array of deselected/hidden data series
 */
function getSplittedSeries(seriesSpecs, deselectedDataSeries) {
    var e_1, _a;
    if (deselectedDataSeries === void 0) { deselectedDataSeries = []; }
    var splittedSeries = new Map();
    var seriesCollection = new Map();
    var xValues = new Set();
    var isOrdinalScale = false;
    var _loop_1 = function (spec) {
        var e_2, _a;
        var dataSeries = splitSeries(spec);
        var currentRawDataSeries = dataSeries.rawDataSeries;
        if (spec.xScaleType === scales_1.ScaleType.Ordinal) {
            isOrdinalScale = true;
        }
        if (deselectedDataSeries.length > 0) {
            currentRawDataSeries = dataSeries.rawDataSeries.filter(function (_a) {
                var key = _a.key;
                return !deselectedDataSeries.some(function (_a) {
                    var deselectedKey = _a.key;
                    return key === deselectedKey;
                });
            });
        }
        splittedSeries.set(spec.id, currentRawDataSeries);
        var banded = spec.y0Accessors && spec.y0Accessors.length > 0;
        dataSeries.rawDataSeries.forEach(function (series) {
            seriesCollection.set(series.key, {
                banded: banded,
                specSortIndex: spec.sortIndex,
                seriesIdentifier: series,
            });
        });
        try {
            for (var _b = (e_2 = void 0, __values(dataSeries.xValues)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var xValue = _c.value;
                xValues.add(xValue);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    try {
        for (var seriesSpecs_1 = __values(seriesSpecs), seriesSpecs_1_1 = seriesSpecs_1.next(); !seriesSpecs_1_1.done; seriesSpecs_1_1 = seriesSpecs_1.next()) {
            var spec = seriesSpecs_1_1.value;
            _loop_1(spec);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (seriesSpecs_1_1 && !seriesSpecs_1_1.done && (_a = seriesSpecs_1.return)) _a.call(seriesSpecs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return {
        splittedSeries: splittedSeries,
        seriesCollection: seriesCollection,
        // keep the user order for ordinal scales
        xValues: isOrdinalScale ? xValues : new Set(__spread(xValues).sort()),
    };
}
exports.getSplittedSeries = getSplittedSeries;
/**
 * Get custom  series sub-name
 */
var getCustomSubSeriesName = (function () {
    var cache = new Map();
    return function (customSubSeriesLabel, isTooltip) { return function (args) {
        var _a = __read(args, 2), accessorKey = _a[0], accessorLabel = _a[1];
        var key = [args, isTooltip].join('~~~');
        if (cache.has(key)) {
            return cache.get(key);
        }
        else {
            var label = customSubSeriesLabel(accessorLabel, accessorKey, isTooltip) || accessorLabel;
            cache.set(key, label);
            return label;
        }
    }; };
})();
var getSeriesLabelKeys = function (spec, seriesIdentifier, isTooltip) {
    var isMultipleY = spec.yAccessors.length > 1;
    if (spec.customSubSeriesLabel) {
        var yAccessor = seriesIdentifier.yAccessor, splitAccessors = seriesIdentifier.splitAccessors;
        var fullKeyPairs = __spread(splitAccessors.entries(), [[null, yAccessor]]);
        var labelKeys = fullKeyPairs.map(getCustomSubSeriesName(spec.customSubSeriesLabel, isTooltip));
        return isMultipleY ? labelKeys : labelKeys.slice(0, -1);
    }
    var seriesKeys = seriesIdentifier.seriesKeys;
    return isMultipleY ? seriesKeys : seriesKeys.slice(0, -1);
};
/**
 * Get series label based on `SeriesIdentifier`
 */
function getSeriesLabel(seriesIdentifier, hasSingleSeries, isTooltip, spec) {
    if (spec && spec.customSeriesLabel) {
        var customLabel = spec.customSeriesLabel(seriesIdentifier, isTooltip);
        if (customLabel !== null) {
            return customLabel;
        }
    }
    var label = '';
    var labelKeys = spec ? getSeriesLabelKeys(spec, seriesIdentifier, isTooltip) : seriesIdentifier.seriesKeys;
    // there is one series, the is only one yAccessor, the first part is not null
    if (hasSingleSeries || labelKeys.length === 0 || labelKeys[0] == null) {
        if (!spec) {
            return '';
        }
        if (spec.splitSeriesAccessors && labelKeys.length > 0 && labelKeys[0] != null) {
            label = labelKeys.join(' - ');
        }
        else {
            label = spec.name || "" + spec.id;
        }
    }
    else {
        label = labelKeys.join(' - ');
    }
    return label;
}
exports.getSeriesLabel = getSeriesLabel;
function getSortIndex(_a, total) {
    var specSortIndex = _a.specSortIndex;
    return specSortIndex != null ? specSortIndex : total;
}
function getSortedDataSeriesColorsValuesMap(seriesCollection) {
    var seriesColorsArray = __spread(seriesCollection);
    seriesColorsArray.sort(function (_a, _b) {
        var _c = __read(_a, 2), specA = _c[1];
        var _d = __read(_b, 2), specB = _d[1];
        return getSortIndex(specA, seriesCollection.size) - getSortIndex(specB, seriesCollection.size);
    });
    return new Map(__spread(seriesColorsArray));
}
exports.getSortedDataSeriesColorsValuesMap = getSortedDataSeriesColorsValuesMap;
function getSeriesColors(seriesCollection, chartColors, customColors) {
    var seriesColorMap = new Map();
    var counter = 0;
    seriesCollection.forEach(function (_, seriesKey) {
        var customSeriesColor = customColors.get(seriesKey);
        var color = customSeriesColor || chartColors.vizColors[counter % chartColors.vizColors.length];
        seriesColorMap.set(seriesKey, color);
        counter++;
    });
    return seriesColorMap;
}
exports.getSeriesColors = getSeriesColors;
//# sourceMappingURL=series.js.map