"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportManager = void 0;

var _util = require("./util");

var _metrics = require("./metrics");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var REPORT_VERSION = 1;

var ReportManager =
/*#__PURE__*/
function () {
  function ReportManager(report) {
    _classCallCheck(this, ReportManager);

    _defineProperty(this, "report", void 0);

    this.report = report || ReportManager.createReport();
  }

  _createClass(ReportManager, [{
    key: "clearReport",
    value: function clearReport() {
      this.report = ReportManager.createReport();
    }
  }, {
    key: "isReportEmpty",
    value: function isReportEmpty() {
      var _this$report = this.report,
          uiStatsMetrics = _this$report.uiStatsMetrics,
          userAgent = _this$report.userAgent;
      var noUiStats = !uiStatsMetrics || Object.keys(uiStatsMetrics).length === 0;
      var noUserAgent = !userAgent || Object.keys(userAgent).length === 0;
      return noUiStats && noUserAgent;
    }
  }, {
    key: "incrementStats",
    value: function incrementStats(count, stats) {
      var _ref = stats || {},
          _ref$min = _ref.min,
          min = _ref$min === void 0 ? 0 : _ref$min,
          _ref$max = _ref.max,
          max = _ref$max === void 0 ? 0 : _ref$max,
          _ref$sum = _ref.sum,
          sum = _ref$sum === void 0 ? 0 : _ref$sum;

      var newMin = Math.min(min, count);
      var newMax = Math.max(max, count);
      var newAvg = newMin + newMax / 2;
      var newSum = sum + count;
      return {
        min: newMin,
        max: newMax,
        avg: newAvg,
        sum: newSum
      };
    }
  }, {
    key: "assignReports",
    value: function assignReports(newMetrics) {
      var _this = this;

      (0, _util.wrapArray)(newMetrics).forEach(function (newMetric) {
        return _this.assignReport(_this.report, newMetric);
      });
      return {
        report: this.report
      };
    }
  }, {
    key: "assignReport",
    value: function assignReport(report, metric) {
      var key = ReportManager.createMetricKey(metric);

      switch (metric.type) {
        case _metrics.METRIC_TYPE.USER_AGENT:
          {
            var appName = metric.appName,
                type = metric.type,
                userAgent = metric.userAgent;

            if (userAgent) {
              report.userAgent = _defineProperty({}, key, {
                key: key,
                appName: appName,
                type: type,
                userAgent: metric.userAgent
              });
            }

            return;
          }

        case _metrics.METRIC_TYPE.CLICK:
        case _metrics.METRIC_TYPE.LOADED:
        case _metrics.METRIC_TYPE.COUNT:
          {
            var _appName = metric.appName,
                _type = metric.type,
                eventName = metric.eventName,
                count = metric.count;
            report.uiStatsMetrics = report.uiStatsMetrics || {};
            var existingStats = (report.uiStatsMetrics[key] || {}).stats;
            report.uiStatsMetrics[key] = {
              key: key,
              appName: _appName,
              eventName: eventName,
              type: _type,
              stats: this.incrementStats(count, existingStats)
            };
            return;
          }

        default:
          throw new _util.UnreachableCaseError(metric);
      }
    }
  }], [{
    key: "createReport",
    value: function createReport() {
      return {
        reportVersion: REPORT_VERSION
      };
    }
  }, {
    key: "createMetricKey",
    value: function createMetricKey(metric) {
      switch (metric.type) {
        case _metrics.METRIC_TYPE.USER_AGENT:
          {
            var appName = metric.appName,
                type = metric.type;
            return "".concat(appName, "-").concat(type);
          }

        case _metrics.METRIC_TYPE.CLICK:
        case _metrics.METRIC_TYPE.LOADED:
        case _metrics.METRIC_TYPE.COUNT:
          {
            var _appName2 = metric.appName,
                eventName = metric.eventName,
                _type2 = metric.type;
            return "".concat(_appName2, "-").concat(_type2, "-").concat(eventName);
          }

        default:
          throw new _util.UnreachableCaseError(metric);
      }
    }
  }]);

  return ReportManager;
}();

exports.ReportManager = ReportManager;

_defineProperty(ReportManager, "REPORT_VERSION", REPORT_VERSION);