/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import net.jradius.server.JRadiusServer;
import net.jradius.server.config.Configuration;
import org.apache.commons.configuration.ConfigurationException;

public final class Main {
    public static void main(String[] args) {
        if (args.length != 1) {
            Main.showUsage();
            System.exit(1);
        }
        String configFilePath = args[0];
        try {
            File file = new File(configFilePath);
            Configuration.initialize(file);
            JRadiusServer server = new JRadiusServer();
            server.start();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: The configuration file '" + configFilePath + "' does not exist.");
        }
        catch (ConfigurationException e1) {
            System.err.println("Error: The configuration file could not be read, because the file contains an error: " + e1.getMessage());
            Main.showStackTrace((Exception)((Object)e1));
        }
        catch (SecurityException e2) {
            System.err.println("Error: The configuration file could not be read, because a security error occurred: " + e2.getMessage());
            Main.showStackTrace(e2);
        }
        catch (IllegalArgumentException e3) {
            System.err.println("Error: The configuration file could not be read, because an illegal argument error occurred: " + e3.getMessage());
            Main.showStackTrace(e3);
        }
        catch (ClassNotFoundException e4) {
            System.err.println("Error: The configuration file could not be read, because a class specified in the configuration file could not be found: " + e4.getMessage());
            Main.showStackTrace(e4);
        }
        catch (NoSuchMethodException e5) {
            System.err.println("Error: The configuration file could not be read, because a method does not exist in a class specified in the configuration file: " + e5.getMessage());
            Main.showStackTrace(e5);
        }
        catch (InstantiationException e6) {
            System.err.println("Error: The configuration file could not be read, because an object specified in the configuration file could not be instantiated: " + e6.getMessage());
            Main.showStackTrace(e6);
        }
        catch (IllegalAccessException e7) {
            System.err.println("Error: The configuration file could not be read, because an illegal access error occurred: " + e7.getMessage());
            Main.showStackTrace(e7);
        }
        catch (InvocationTargetException e8) {
            System.err.println("Error: The configuration file could not be read, because an invocation target exception was thrown: " + e8.getMessage());
            Main.showStackTrace(e8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void showStackTrace(Exception e) {
        System.err.println("--- stack trace: ------------------------------");
        e.printStackTrace(System.err);
        System.err.println("--- end of stack trace. -----------------------");
    }

    private static void showUsage() {
        System.err.println("Usage: jradius <configfile>");
        System.err.println("    where <configfile> is the filename of the configuration file.");
    }
}

