/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.util.List;
import net.jradius.exception.RadiusException;
import net.jradius.exception.RadiusSecurityException;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusRequest;
import net.jradius.server.Processor;
import net.jradius.server.event.HandlerLogEvent;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;

public abstract class RadiusProcessor
extends Processor {
    protected abstract void logReturnCode(int var1, JRCommand var2);

    protected int handleRadiusException(JRadiusRequest request, RadiusException e) {
        JRadiusSession session = request.getSession();
        String error = e.getMessage();
        RadiusLog.warn(error);
        if (session != null) {
            try {
                session.getLogEntry(request).addMessage(error);
            }
            catch (RadiusException re) {
                RadiusLog.problem(request, session, re, re.getMessage());
            }
        }
        return e instanceof RadiusSecurityException ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int runPacketHandlers(JRadiusRequest request) {
        List<JRCommand> handlers = this.getRequestHandlers();
        int result = 7;
        boolean exceptionThrown = false;
        if (handlers == null) {
            return result;
        }
        JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager(request.getSender());
        JRadiusSession session = null;
        if (sessionManager != null) {
            session = request.getSession();
            if (session == null) {
                try {
                    session = sessionManager.getSession(request);
                }
                catch (RadiusException e) {
                    String error = e.getMessage();
                    String mesg = "Rejecting request";
                    try {
                        mesg = mesg + ": " + request.getRequestPacket().toString();
                    }
                    catch (RadiusException radiusException) {
                        // empty catch block
                    }
                    RadiusLog.warn(mesg + ": " + error);
                    RadiusLog.problem(request, null, e, mesg);
                    return 0;
                }
            }
            if (session == null) {
                RadiusLog.error("Unable to create session");
                return 0;
            }
            request.setSession(session);
            sessionManager.lock(session);
        }
        try {
            for (JRCommand handler : handlers) {
                boolean stop = false;
                try {
                    if (!handler.doesHandle(request)) continue;
                    stop = handler.execute(request);
                    result = request.getReturnValue();
                    this.logReturnCode(result, handler);
                    if (!stop) continue;
                }
                catch (RadiusException e) {
                    exceptionThrown = true;
                    result = this.handleRadiusException(request, e);
                    this.logReturnCode(result, handler);
                }
                catch (Throwable e) {
                    exceptionThrown = true;
                    String error = e.getMessage();
                    RadiusLog.error("Handler " + handler.getName() + " threw throwable: " + error);
                    result = 1;
                    this.logReturnCode(result, handler);
                    e.printStackTrace();
                }
                break;
            }
            if (session != null && !exceptionThrown) {
                try {
                    session.onPostProcessing(request);
                }
                catch (RadiusException e) {
                    result = this.handleRadiusException(request, e);
                }
                catch (Throwable e) {
                    RadiusLog.error("Error occured during handling postprocess.", e);
                    result = 1;
                }
            }
            if (result == 0 && request.isAccountingRequest()) {
                RadiusLog.debug("Ack'ing AccountingRequest that was rejected");
                result = 2;
            }
            if (session != null && session.isLogging()) {
                HandlerLogEvent log = new HandlerLogEvent(request, request.getSessionKey(), result);
                this.getEventDispatcher().post(log);
            }
        }
        finally {
            if (session != null) {
                sessionManager.unlock(session, true);
            }
        }
        return result;
    }
}

