/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script;

import java.io.IOException;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.access.Snmp;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.script.CliScript;
import onl.netfishers.netshot.device.script.helper.JsCliHelper;
import onl.netfishers.netshot.device.script.helper.JsCliScriptOptions;
import onl.netfishers.netshot.device.script.helper.JsDeviceHelper;
import onl.netfishers.netshot.device.script.helper.JsSnmpHelper;
import onl.netfishers.netshot.work.TaskLogger;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsCliScript
extends CliScript {
    private static Logger logger = LoggerFactory.getLogger(JsCliScript.class);
    private String code;

    public JsCliScript(String code, boolean cliLogging) {
        super(cliLogging);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    protected void run(Session session, Device device, Cli cli, Snmp snmp, DeviceDriver.DriverProtocol protocol, DeviceCredentialSet account) throws Device.InvalidCredentialsException, IOException, ScriptException, Device.MissingDeviceDriverException {
        JsCliHelper jsCliHelper = null;
        JsSnmpHelper jsSnmpHelper = null;
        switch (protocol) {
            case SNMP: {
                jsSnmpHelper = new JsSnmpHelper(snmp, (DeviceSnmpCommunity)account, this.getJsLogger());
                break;
            }
            case TELNET: 
            case SSH: {
                jsCliHelper = new JsCliHelper(cli, (DeviceCliAccount)account, this.getJsLogger(), this.getCliLogger());
            }
        }
        TaskLogger taskLogger = this.getJsLogger();
        DeviceDriver driver = device.getDeviceDriver();
        try {
            ScriptEngine engine = driver.getEngine();
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            scriptContext.setBindings(engine.getContext().getBindings(100), 100);
            engine.eval(this.code, (ScriptContext)scriptContext);
            JsCliScriptOptions options = new JsCliScriptOptions(jsCliHelper, jsSnmpHelper);
            options.setDevice(new JsDeviceHelper(device, null, taskLogger, false));
            ((Invocable)((Object)engine)).invokeFunction("_connect", "run", protocol.value(), options, taskLogger);
        }
        catch (ScriptException e) {
            logger.error("Error while running script using driver {}.", (Object)driver.getName(), (Object)e);
            taskLogger.error(String.format("Error while running script  using driver %s: '%s'.", driver.getName(), e.getMessage()));
            if (e.getMessage().contains("Authentication failed")) {
                throw new Device.InvalidCredentialsException("Authentication failed");
            }
            throw e;
        }
        catch (NoSuchMethodException e) {
            logger.error("No such method while using driver {}.", (Object)driver.getName(), (Object)e);
            taskLogger.error(String.format("No such method while using driver %s to execute script: '%s'.", driver.getName(), e.getMessage()));
            throw new ScriptException(e);
        }
    }
}

