/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * distance(vec2(-0.1, -1.2), vec2(-0.1, -1.2)) => 0.0
 * distance(vec2(-0.1, -1.2), vec2(-0.42, 0.48)) => 1.7102047
 * distance(vec2(-0.42, 0.48), vec2(-0.1, -1.2)) => 1.7102047
 * distance(vec2(-0.42, 0.48), vec2(-0.42, 0.48)) => 0.0
 */
#version 150

void main()
{
  float[0.0 <= distance(vec2(-0.1, -1.2), vec2(-0.1, -1.2)) && distance(vec2(-0.1, -1.2), vec2(-0.1, -1.2)) <= 0.0 ? 1 : -1] array0;
  float[1.71018767357 <= distance(vec2(-0.1, -1.2), vec2(-0.42, 0.48)) && distance(vec2(-0.1, -1.2), vec2(-0.42, 0.48)) <= 1.71022176743 ? 1 : -1] array1;
  float[1.71018767357 <= distance(vec2(-0.42, 0.48), vec2(-0.1, -1.2)) && distance(vec2(-0.42, 0.48), vec2(-0.1, -1.2)) <= 1.71022176743 ? 1 : -1] array2;
  float[0.0 <= distance(vec2(-0.42, 0.48), vec2(-0.42, 0.48)) && distance(vec2(-0.42, 0.48), vec2(-0.42, 0.48)) <= 0.0 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
