# -*- coding: UTF-8 -*-


"""
Data literal storing emoji names and unicode codes
"""


__all__ = ['EMOJI_UNICODE', 'UNICODE_EMOJI', 'EMOJI_ALIAS_UNICODE', 'UNICODE_EMOJI_ALIAS']


EMOJI_UNICODE = {
    u':1st_place_medal:': u'\U0001F947',
    u':2nd_place_medal:': u'\U0001F948',
    u':3rd_place_medal:': u'\U0001F949',
    u':AB_button_(blood_type):': u'\U0001F18E',
    u':ATM_sign:': u'\U0001F3E7',
    u':A_button_(blood_type):': u'\U0001F170',
    u':Afghanistan:': u'\U0001F1E6\U0001F1EB',
    u':Albania:': u'\U0001F1E6\U0001F1F1',
    u':Algeria:': u'\U0001F1E9\U0001F1FF',
    u':American_Samoa:': u'\U0001F1E6\U0001F1F8',
    u':Andorra:': u'\U0001F1E6\U0001F1E9',
    u':Angola:': u'\U0001F1E6\U0001F1F4',
    u':Anguilla:': u'\U0001F1E6\U0001F1EE',
    u':Antarctica:': u'\U0001F1E6\U0001F1F6',
    u':Antigua_&_Barbuda:': u'\U0001F1E6\U0001F1EC',
    u':Aquarius:': u'\U00002652',
    u':Argentina:': u'\U0001F1E6\U0001F1F7',
    u':Aries:': u'\U00002648',
    u':Armenia:': u'\U0001F1E6\U0001F1F2',
    u':Aruba:': u'\U0001F1E6\U0001F1FC',
    u':Ascension_Island:': u'\U0001F1E6\U0001F1E8',
    u':Australia:': u'\U0001F1E6\U0001F1FA',
    u':Austria:': u'\U0001F1E6\U0001F1F9',
    u':Azerbaijan:': u'\U0001F1E6\U0001F1FF',
    u':BACK_arrow:': u'\U0001F519',
    u':B_button_(blood_type):': u'\U0001F171',
    u':Bahamas:': u'\U0001F1E7\U0001F1F8',
    u':Bahrain:': u'\U0001F1E7\U0001F1ED',
    u':Bangladesh:': u'\U0001F1E7\U0001F1E9',
    u':Barbados:': u'\U0001F1E7\U0001F1E7',
    u':Belarus:': u'\U0001F1E7\U0001F1FE',
    u':Belgium:': u'\U0001F1E7\U0001F1EA',
    u':Belize:': u'\U0001F1E7\U0001F1FF',
    u':Benin:': u'\U0001F1E7\U0001F1EF',
    u':Bermuda:': u'\U0001F1E7\U0001F1F2',
    u':Bhutan:': u'\U0001F1E7\U0001F1F9',
    u':Bolivia:': u'\U0001F1E7\U0001F1F4',
    u':Bosnia_&_Herzegovina:': u'\U0001F1E7\U0001F1E6',
    u':Botswana:': u'\U0001F1E7\U0001F1FC',
    u':Bouvet_Island:': u'\U0001F1E7\U0001F1FB',
    u':Brazil:': u'\U0001F1E7\U0001F1F7',
    u':British_Indian_Ocean_Territory:': u'\U0001F1EE\U0001F1F4',
    u':British_Virgin_Islands:': u'\U0001F1FB\U0001F1EC',
    u':Brunei:': u'\U0001F1E7\U0001F1F3',
    u':Bulgaria:': u'\U0001F1E7\U0001F1EC',
    u':Burkina_Faso:': u'\U0001F1E7\U0001F1EB',
    u':Burundi:': u'\U0001F1E7\U0001F1EE',
    u':CL_button:': u'\U0001F191',
    u':COOL_button:': u'\U0001F192',
    u':Cambodia:': u'\U0001F1F0\U0001F1ED',
    u':Cameroon:': u'\U0001F1E8\U0001F1F2',
    u':Canada:': u'\U0001F1E8\U0001F1E6',
    u':Canary_Islands:': u'\U0001F1EE\U0001F1E8',
    u':Cancer:': u'\U0000264B',
    u':Cape_Verde:': u'\U0001F1E8\U0001F1FB',
    u':Capricorn:': u'\U00002651',
    u':Caribbean_Netherlands:': u'\U0001F1E7\U0001F1F6',
    u':Cayman_Islands:': u'\U0001F1F0\U0001F1FE',
    u':Central_African_Republic:': u'\U0001F1E8\U0001F1EB',
    u':Ceuta_&_Melilla:': u'\U0001F1EA\U0001F1E6',
    u':Chad:': u'\U0001F1F9\U0001F1E9',
    u':Chile:': u'\U0001F1E8\U0001F1F1',
    u':China:': u'\U0001F1E8\U0001F1F3',
    u':Christmas_Island:': u'\U0001F1E8\U0001F1FD',
    u':Christmas_tree:': u'\U0001F384',
    u':Clipperton_Island:': u'\U0001F1E8\U0001F1F5',
    u':Cocos_(Keeling)_Islands:': u'\U0001F1E8\U0001F1E8',
    u':Colombia:': u'\U0001F1E8\U0001F1F4',
    u':Comoros:': u'\U0001F1F0\U0001F1F2',
    u':Congo_-_Brazzaville:': u'\U0001F1E8\U0001F1EC',
    u':Congo_-_Kinshasa:': u'\U0001F1E8\U0001F1E9',
    u':Cook_Islands:': u'\U0001F1E8\U0001F1F0',
    u':Costa_Rica:': u'\U0001F1E8\U0001F1F7',
    u':Croatia:': u'\U0001F1ED\U0001F1F7',
    u':Cuba:': u'\U0001F1E8\U0001F1FA',
    u':Curaçao:': u'\U0001F1E8\U0001F1FC',
    u':Cyprus:': u'\U0001F1E8\U0001F1FE',
    u':Czechia:': u'\U0001F1E8\U0001F1FF',
    u':Côte_d’Ivoire:': u'\U0001F1E8\U0001F1EE',
    u':Denmark:': u'\U0001F1E9\U0001F1F0',
    u':Diego_Garcia:': u'\U0001F1E9\U0001F1EC',
    u':Djibouti:': u'\U0001F1E9\U0001F1EF',
    u':Dominica:': u'\U0001F1E9\U0001F1F2',
    u':Dominican_Republic:': u'\U0001F1E9\U0001F1F4',
    u':END_arrow:': u'\U0001F51A',
    u':Ecuador:': u'\U0001F1EA\U0001F1E8',
    u':Egypt:': u'\U0001F1EA\U0001F1EC',
    u':El_Salvador:': u'\U0001F1F8\U0001F1FB',
    u':England:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
    u':Equatorial_Guinea:': u'\U0001F1EC\U0001F1F6',
    u':Eritrea:': u'\U0001F1EA\U0001F1F7',
    u':Estonia:': u'\U0001F1EA\U0001F1EA',
    u':Ethiopia:': u'\U0001F1EA\U0001F1F9',
    u':European_Union:': u'\U0001F1EA\U0001F1FA',
    u':FREE_button:': u'\U0001F193',
    u':Falkland_Islands:': u'\U0001F1EB\U0001F1F0',
    u':Faroe_Islands:': u'\U0001F1EB\U0001F1F4',
    u':Fiji:': u'\U0001F1EB\U0001F1EF',
    u':Finland:': u'\U0001F1EB\U0001F1EE',
    u':France:': u'\U0001F1EB\U0001F1F7',
    u':French_Guiana:': u'\U0001F1EC\U0001F1EB',
    u':French_Polynesia:': u'\U0001F1F5\U0001F1EB',
    u':French_Southern_Territories:': u'\U0001F1F9\U0001F1EB',
    u':Gabon:': u'\U0001F1EC\U0001F1E6',
    u':Gambia:': u'\U0001F1EC\U0001F1F2',
    u':Gemini:': u'\U0000264A',
    u':Georgia:': u'\U0001F1EC\U0001F1EA',
    u':Germany:': u'\U0001F1E9\U0001F1EA',
    u':Ghana:': u'\U0001F1EC\U0001F1ED',
    u':Gibraltar:': u'\U0001F1EC\U0001F1EE',
    u':Greece:': u'\U0001F1EC\U0001F1F7',
    u':Greenland:': u'\U0001F1EC\U0001F1F1',
    u':Grenada:': u'\U0001F1EC\U0001F1E9',
    u':Guadeloupe:': u'\U0001F1EC\U0001F1F5',
    u':Guam:': u'\U0001F1EC\U0001F1FA',
    u':Guatemala:': u'\U0001F1EC\U0001F1F9',
    u':Guernsey:': u'\U0001F1EC\U0001F1EC',
    u':Guinea:': u'\U0001F1EC\U0001F1F3',
    u':Guinea-Bissau:': u'\U0001F1EC\U0001F1FC',
    u':Guyana:': u'\U0001F1EC\U0001F1FE',
    u':Haiti:': u'\U0001F1ED\U0001F1F9',
    u':Heard_&_McDonald_Islands:': u'\U0001F1ED\U0001F1F2',
    u':Honduras:': u'\U0001F1ED\U0001F1F3',
    u':Hong_Kong_SAR_China:': u'\U0001F1ED\U0001F1F0',
    u':Hungary:': u'\U0001F1ED\U0001F1FA',
    u':ID_button:': u'\U0001F194',
    u':Iceland:': u'\U0001F1EE\U0001F1F8',
    u':India:': u'\U0001F1EE\U0001F1F3',
    u':Indonesia:': u'\U0001F1EE\U0001F1E9',
    u':Iran:': u'\U0001F1EE\U0001F1F7',
    u':Iraq:': u'\U0001F1EE\U0001F1F6',
    u':Ireland:': u'\U0001F1EE\U0001F1EA',
    u':Isle_of_Man:': u'\U0001F1EE\U0001F1F2',
    u':Israel:': u'\U0001F1EE\U0001F1F1',
    u':Italy:': u'\U0001F1EE\U0001F1F9',
    u':Jamaica:': u'\U0001F1EF\U0001F1F2',
    u':Japan:': u'\U0001F1EF\U0001F1F5',
    u':Japanese_acceptable_button:': u'\U0001F251',
    u':Japanese_application_button:': u'\U0001F238',
    u':Japanese_bargain_button:': u'\U0001F250',
    u':Japanese_castle:': u'\U0001F3EF',
    u':Japanese_congratulations_button:': u'\U00003297',
    u':Japanese_discount_button:': u'\U0001F239',
    u':Japanese_dolls:': u'\U0001F38E',
    u':Japanese_free_of_charge_button:': u'\U0001F21A',
    u':Japanese_here_button:': u'\U0001F201',
    u':Japanese_monthly_amount_button:': u'\U0001F237',
    u':Japanese_no_vacancy_button:': u'\U0001F235',
    u':Japanese_not_free_of_charge_button:': u'\U0001F236',
    u':Japanese_open_for_business_button:': u'\U0001F23A',
    u':Japanese_passing_grade_button:': u'\U0001F234',
    u':Japanese_post_office:': u'\U0001F3E3',
    u':Japanese_prohibited_button:': u'\U0001F232',
    u':Japanese_reserved_button:': u'\U0001F22F',
    u':Japanese_secret_button:': u'\U00003299',
    u':Japanese_service_charge_button:': u'\U0001F202',
    u':Japanese_symbol_for_beginner:': u'\U0001F530',
    u':Japanese_vacancy_button:': u'\U0001F233',
    u':Jersey:': u'\U0001F1EF\U0001F1EA',
    u':Jordan:': u'\U0001F1EF\U0001F1F4',
    u':Kazakhstan:': u'\U0001F1F0\U0001F1FF',
    u':Kenya:': u'\U0001F1F0\U0001F1EA',
    u':Kiribati:': u'\U0001F1F0\U0001F1EE',
    u':Kosovo:': u'\U0001F1FD\U0001F1F0',
    u':Kuwait:': u'\U0001F1F0\U0001F1FC',
    u':Kyrgyzstan:': u'\U0001F1F0\U0001F1EC',
    u':Laos:': u'\U0001F1F1\U0001F1E6',
    u':Latvia:': u'\U0001F1F1\U0001F1FB',
    u':Lebanon:': u'\U0001F1F1\U0001F1E7',
    u':Leo:': u'\U0000264C',
    u':Lesotho:': u'\U0001F1F1\U0001F1F8',
    u':Liberia:': u'\U0001F1F1\U0001F1F7',
    u':Libra:': u'\U0000264E',
    u':Libya:': u'\U0001F1F1\U0001F1FE',
    u':Liechtenstein:': u'\U0001F1F1\U0001F1EE',
    u':Lithuania:': u'\U0001F1F1\U0001F1F9',
    u':Luxembourg:': u'\U0001F1F1\U0001F1FA',
    u':Macau_SAR_China:': u'\U0001F1F2\U0001F1F4',
    u':Macedonia:': u'\U0001F1F2\U0001F1F0',
    u':Madagascar:': u'\U0001F1F2\U0001F1EC',
    u':Malawi:': u'\U0001F1F2\U0001F1FC',
    u':Malaysia:': u'\U0001F1F2\U0001F1FE',
    u':Maldives:': u'\U0001F1F2\U0001F1FB',
    u':Mali:': u'\U0001F1F2\U0001F1F1',
    u':Malta:': u'\U0001F1F2\U0001F1F9',
    u':Marshall_Islands:': u'\U0001F1F2\U0001F1ED',
    u':Martinique:': u'\U0001F1F2\U0001F1F6',
    u':Mauritania:': u'\U0001F1F2\U0001F1F7',
    u':Mauritius:': u'\U0001F1F2\U0001F1FA',
    u':Mayotte:': u'\U0001F1FE\U0001F1F9',
    u':Mexico:': u'\U0001F1F2\U0001F1FD',
    u':Micronesia:': u'\U0001F1EB\U0001F1F2',
    u':Moldova:': u'\U0001F1F2\U0001F1E9',
    u':Monaco:': u'\U0001F1F2\U0001F1E8',
    u':Mongolia:': u'\U0001F1F2\U0001F1F3',
    u':Montenegro:': u'\U0001F1F2\U0001F1EA',
    u':Montserrat:': u'\U0001F1F2\U0001F1F8',
    u':Morocco:': u'\U0001F1F2\U0001F1E6',
    u':Mozambique:': u'\U0001F1F2\U0001F1FF',
    u':Mrs._Claus:': u'\U0001F936',
    u':Mrs._Claus_dark_skin_tone:': u'\U0001F936\U0001F3FF',
    u':Mrs._Claus_light_skin_tone:': u'\U0001F936\U0001F3FB',
    u':Mrs._Claus_medium-dark_skin_tone:': u'\U0001F936\U0001F3FE',
    u':Mrs._Claus_medium-light_skin_tone:': u'\U0001F936\U0001F3FC',
    u':Mrs._Claus_medium_skin_tone:': u'\U0001F936\U0001F3FD',
    u':Myanmar_(Burma):': u'\U0001F1F2\U0001F1F2',
    u':NEW_button:': u'\U0001F195',
    u':NG_button:': u'\U0001F196',
    u':Namibia:': u'\U0001F1F3\U0001F1E6',
    u':Nauru:': u'\U0001F1F3\U0001F1F7',
    u':Nepal:': u'\U0001F1F3\U0001F1F5',
    u':Netherlands:': u'\U0001F1F3\U0001F1F1',
    u':New_Caledonia:': u'\U0001F1F3\U0001F1E8',
    u':New_Zealand:': u'\U0001F1F3\U0001F1FF',
    u':Nicaragua:': u'\U0001F1F3\U0001F1EE',
    u':Niger:': u'\U0001F1F3\U0001F1EA',
    u':Nigeria:': u'\U0001F1F3\U0001F1EC',
    u':Niue:': u'\U0001F1F3\U0001F1FA',
    u':Norfolk_Island:': u'\U0001F1F3\U0001F1EB',
    u':North_Korea:': u'\U0001F1F0\U0001F1F5',
    u':Northern_Mariana_Islands:': u'\U0001F1F2\U0001F1F5',
    u':Norway:': u'\U0001F1F3\U0001F1F4',
    u':OK_button:': u'\U0001F197',
    u':OK_hand:': u'\U0001F44C',
    u':OK_hand_dark_skin_tone:': u'\U0001F44C\U0001F3FF',
    u':OK_hand_light_skin_tone:': u'\U0001F44C\U0001F3FB',
    u':OK_hand_medium-dark_skin_tone:': u'\U0001F44C\U0001F3FE',
    u':OK_hand_medium-light_skin_tone:': u'\U0001F44C\U0001F3FC',
    u':OK_hand_medium_skin_tone:': u'\U0001F44C\U0001F3FD',
    u':ON!_arrow:': u'\U0001F51B',
    u':O_button_(blood_type):': u'\U0001F17E',
    u':Oman:': u'\U0001F1F4\U0001F1F2',
    u':Ophiuchus:': u'\U000026CE',
    u':P_button:': u'\U0001F17F',
    u':Pakistan:': u'\U0001F1F5\U0001F1F0',
    u':Palau:': u'\U0001F1F5\U0001F1FC',
    u':Palestinian_Territories:': u'\U0001F1F5\U0001F1F8',
    u':Panama:': u'\U0001F1F5\U0001F1E6',
    u':Papua_New_Guinea:': u'\U0001F1F5\U0001F1EC',
    u':Paraguay:': u'\U0001F1F5\U0001F1FE',
    u':Peru:': u'\U0001F1F5\U0001F1EA',
    u':Philippines:': u'\U0001F1F5\U0001F1ED',
    u':Pisces:': u'\U00002653',
    u':Pitcairn_Islands:': u'\U0001F1F5\U0001F1F3',
    u':Poland:': u'\U0001F1F5\U0001F1F1',
    u':Portugal:': u'\U0001F1F5\U0001F1F9',
    u':Puerto_Rico:': u'\U0001F1F5\U0001F1F7',
    u':Qatar:': u'\U0001F1F6\U0001F1E6',
    u':Romania:': u'\U0001F1F7\U0001F1F4',
    u':Russia:': u'\U0001F1F7\U0001F1FA',
    u':Rwanda:': u'\U0001F1F7\U0001F1FC',
    u':Réunion:': u'\U0001F1F7\U0001F1EA',
    u':SOON_arrow:': u'\U0001F51C',
    u':SOS_button:': u'\U0001F198',
    u':Sagittarius:': u'\U00002650',
    u':Samoa:': u'\U0001F1FC\U0001F1F8',
    u':San_Marino:': u'\U0001F1F8\U0001F1F2',
    u':Santa_Claus:': u'\U0001F385',
    u':Santa_Claus_dark_skin_tone:': u'\U0001F385\U0001F3FF',
    u':Santa_Claus_light_skin_tone:': u'\U0001F385\U0001F3FB',
    u':Santa_Claus_medium-dark_skin_tone:': u'\U0001F385\U0001F3FE',
    u':Santa_Claus_medium-light_skin_tone:': u'\U0001F385\U0001F3FC',
    u':Santa_Claus_medium_skin_tone:': u'\U0001F385\U0001F3FD',
    u':Saudi_Arabia:': u'\U0001F1F8\U0001F1E6',
    u':Scorpio:': u'\U0000264F',
    u':Scotland:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
    u':Senegal:': u'\U0001F1F8\U0001F1F3',
    u':Serbia:': u'\U0001F1F7\U0001F1F8',
    u':Seychelles:': u'\U0001F1F8\U0001F1E8',
    u':Sierra_Leone:': u'\U0001F1F8\U0001F1F1',
    u':Singapore:': u'\U0001F1F8\U0001F1EC',
    u':Sint_Maarten:': u'\U0001F1F8\U0001F1FD',
    u':Slovakia:': u'\U0001F1F8\U0001F1F0',
    u':Slovenia:': u'\U0001F1F8\U0001F1EE',
    u':Solomon_Islands:': u'\U0001F1F8\U0001F1E7',
    u':Somalia:': u'\U0001F1F8\U0001F1F4',
    u':South_Africa:': u'\U0001F1FF\U0001F1E6',
    u':South_Georgia_&_South_Sandwich_Islands:': u'\U0001F1EC\U0001F1F8',
    u':South_Korea:': u'\U0001F1F0\U0001F1F7',
    u':South_Sudan:': u'\U0001F1F8\U0001F1F8',
    u':Spain:': u'\U0001F1EA\U0001F1F8',
    u':Sri_Lanka:': u'\U0001F1F1\U0001F1F0',
    u':St._Barthélemy:': u'\U0001F1E7\U0001F1F1',
    u':St._Helena:': u'\U0001F1F8\U0001F1ED',
    u':St._Kitts_&_Nevis:': u'\U0001F1F0\U0001F1F3',
    u':St._Lucia:': u'\U0001F1F1\U0001F1E8',
    u':St._Martin:': u'\U0001F1F2\U0001F1EB',
    u':St._Pierre_&_Miquelon:': u'\U0001F1F5\U0001F1F2',
    u':St._Vincent_&_Grenadines:': u'\U0001F1FB\U0001F1E8',
    u':Statue_of_Liberty:': u'\U0001F5FD',
    u':Sudan:': u'\U0001F1F8\U0001F1E9',
    u':Suriname:': u'\U0001F1F8\U0001F1F7',
    u':Svalbard_&_Jan_Mayen:': u'\U0001F1F8\U0001F1EF',
    u':Swaziland:': u'\U0001F1F8\U0001F1FF',
    u':Sweden:': u'\U0001F1F8\U0001F1EA',
    u':Switzerland:': u'\U0001F1E8\U0001F1ED',
    u':Syria:': u'\U0001F1F8\U0001F1FE',
    u':São_Tomé_&_Príncipe:': u'\U0001F1F8\U0001F1F9',
    u':T-Rex:': u'\U0001F996',
    u':TOP_arrow:': u'\U0001F51D',
    u':Taiwan:': u'\U0001F1F9\U0001F1FC',
    u':Tajikistan:': u'\U0001F1F9\U0001F1EF',
    u':Tanzania:': u'\U0001F1F9\U0001F1FF',
    u':Taurus:': u'\U00002649',
    u':Thailand:': u'\U0001F1F9\U0001F1ED',
    u':Timor-Leste:': u'\U0001F1F9\U0001F1F1',
    u':Togo:': u'\U0001F1F9\U0001F1EC',
    u':Tokelau:': u'\U0001F1F9\U0001F1F0',
    u':Tokyo_tower:': u'\U0001F5FC',
    u':Tonga:': u'\U0001F1F9\U0001F1F4',
    u':Trinidad_&_Tobago:': u'\U0001F1F9\U0001F1F9',
    u':Tristan_da_Cunha:': u'\U0001F1F9\U0001F1E6',
    u':Tunisia:': u'\U0001F1F9\U0001F1F3',
    u':Turkey:': u'\U0001F1F9\U0001F1F7',
    u':Turkmenistan:': u'\U0001F1F9\U0001F1F2',
    u':Turks_&_Caicos_Islands:': u'\U0001F1F9\U0001F1E8',
    u':Tuvalu:': u'\U0001F1F9\U0001F1FB',
    u':U.S._Outlying_Islands:': u'\U0001F1FA\U0001F1F2',
    u':U.S._Virgin_Islands:': u'\U0001F1FB\U0001F1EE',
    u':UP!_button:': u'\U0001F199',
    u':Uganda:': u'\U0001F1FA\U0001F1EC',
    u':Ukraine:': u'\U0001F1FA\U0001F1E6',
    u':United_Arab_Emirates:': u'\U0001F1E6\U0001F1EA',
    u':United_Kingdom:': u'\U0001F1EC\U0001F1E7',
    u':United_Nations:': u'\U0001F1FA\U0001F1F3',
    u':United_States:': u'\U0001F1FA\U0001F1F8',
    u':Uruguay:': u'\U0001F1FA\U0001F1FE',
    u':Uzbekistan:': u'\U0001F1FA\U0001F1FF',
    u':VS_button:': u'\U0001F19A',
    u':Vanuatu:': u'\U0001F1FB\U0001F1FA',
    u':Vatican_City:': u'\U0001F1FB\U0001F1E6',
    u':Venezuela:': u'\U0001F1FB\U0001F1EA',
    u':Vietnam:': u'\U0001F1FB\U0001F1F3',
    u':Virgo:': u'\U0000264D',
    u':Wales:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F',
    u':Wallis_&_Futuna:': u'\U0001F1FC\U0001F1EB',
    u':Western_Sahara:': u'\U0001F1EA\U0001F1ED',
    u':Yemen:': u'\U0001F1FE\U0001F1EA',
    u':Zambia:': u'\U0001F1FF\U0001F1F2',
    u':Zimbabwe:': u'\U0001F1FF\U0001F1FC',
    u':abacus:': u'\U0001F9EE',
    u':adhesive_bandage:': u'\U0001FA79',
    u':admission_tickets:': u'\U0001F39F',
    u':adult:': u'\U0001F9D1',
    u':adult_dark_skin_tone:': u'\U0001F9D1\U0001F3FF',
    u':adult_light_skin_tone:': u'\U0001F9D1\U0001F3FB',
    u':adult_medium-dark_skin_tone:': u'\U0001F9D1\U0001F3FE',
    u':adult_medium-light_skin_tone:': u'\U0001F9D1\U0001F3FC',
    u':adult_medium_skin_tone:': u'\U0001F9D1\U0001F3FD',
    u':aerial_tramway:': u'\U0001F6A1',
    u':airplane:': u'\U00002708',
    u':airplane_arrival:': u'\U0001F6EC',
    u':airplane_departure:': u'\U0001F6EB',
    u':alarm_clock:': u'\U000023F0',
    u':alembic:': u'\U00002697',
    u':alien:': u'\U0001F47D',
    u':alien_monster:': u'\U0001F47E',
    u':ambulance:': u'\U0001F691',
    u':american_football:': u'\U0001F3C8',
    u':amphora:': u'\U0001F3FA',
    u':anchor:': u'\U00002693',
    u':anger_symbol:': u'\U0001F4A2',
    u':angry_face:': u'\U0001F620',
    u':angry_face_with_horns:': u'\U0001F47F',
    u':anguished_face:': u'\U0001F627',
    u':ant:': u'\U0001F41C',
    u':antenna_bars:': u'\U0001F4F6',
    u':anxious_face_with_sweat:': u'\U0001F630',
    u':articulated_lorry:': u'\U0001F69B',
    u':artist_palette:': u'\U0001F3A8',
    u':astonished_face:': u'\U0001F632',
    u':atom_symbol:': u'\U0000269B',
    u':auto_rickshaw:': u'\U0001F6FA',
    u':automobile:': u'\U0001F697',
    u':avocado:': u'\U0001F951',
    u':axe:': u'\U0001FA93',
    u':baby:': u'\U0001F476',
    u':baby_angel:': u'\U0001F47C',
    u':baby_angel_dark_skin_tone:': u'\U0001F47C\U0001F3FF',
    u':baby_angel_light_skin_tone:': u'\U0001F47C\U0001F3FB',
    u':baby_angel_medium-dark_skin_tone:': u'\U0001F47C\U0001F3FE',
    u':baby_angel_medium-light_skin_tone:': u'\U0001F47C\U0001F3FC',
    u':baby_angel_medium_skin_tone:': u'\U0001F47C\U0001F3FD',
    u':baby_bottle:': u'\U0001F37C',
    u':baby_chick:': u'\U0001F424',
    u':baby_dark_skin_tone:': u'\U0001F476\U0001F3FF',
    u':baby_light_skin_tone:': u'\U0001F476\U0001F3FB',
    u':baby_medium-dark_skin_tone:': u'\U0001F476\U0001F3FE',
    u':baby_medium-light_skin_tone:': u'\U0001F476\U0001F3FC',
    u':baby_medium_skin_tone:': u'\U0001F476\U0001F3FD',
    u':baby_symbol:': u'\U0001F6BC',
    u':backhand_index_pointing_down:': u'\U0001F447',
    u':backhand_index_pointing_down_dark_skin_tone:': u'\U0001F447\U0001F3FF',
    u':backhand_index_pointing_down_light_skin_tone:': u'\U0001F447\U0001F3FB',
    u':backhand_index_pointing_down_medium-dark_skin_tone:': u'\U0001F447\U0001F3FE',
    u':backhand_index_pointing_down_medium-light_skin_tone:': u'\U0001F447\U0001F3FC',
    u':backhand_index_pointing_down_medium_skin_tone:': u'\U0001F447\U0001F3FD',
    u':backhand_index_pointing_left:': u'\U0001F448',
    u':backhand_index_pointing_left_dark_skin_tone:': u'\U0001F448\U0001F3FF',
    u':backhand_index_pointing_left_light_skin_tone:': u'\U0001F448\U0001F3FB',
    u':backhand_index_pointing_left_medium-dark_skin_tone:': u'\U0001F448\U0001F3FE',
    u':backhand_index_pointing_left_medium-light_skin_tone:': u'\U0001F448\U0001F3FC',
    u':backhand_index_pointing_left_medium_skin_tone:': u'\U0001F448\U0001F3FD',
    u':backhand_index_pointing_right:': u'\U0001F449',
    u':backhand_index_pointing_right_dark_skin_tone:': u'\U0001F449\U0001F3FF',
    u':backhand_index_pointing_right_light_skin_tone:': u'\U0001F449\U0001F3FB',
    u':backhand_index_pointing_right_medium-dark_skin_tone:': u'\U0001F449\U0001F3FE',
    u':backhand_index_pointing_right_medium-light_skin_tone:': u'\U0001F449\U0001F3FC',
    u':backhand_index_pointing_right_medium_skin_tone:': u'\U0001F449\U0001F3FD',
    u':backhand_index_pointing_up:': u'\U0001F446',
    u':backhand_index_pointing_up_dark_skin_tone:': u'\U0001F446\U0001F3FF',
    u':backhand_index_pointing_up_light_skin_tone:': u'\U0001F446\U0001F3FB',
    u':backhand_index_pointing_up_medium-dark_skin_tone:': u'\U0001F446\U0001F3FE',
    u':backhand_index_pointing_up_medium-light_skin_tone:': u'\U0001F446\U0001F3FC',
    u':backhand_index_pointing_up_medium_skin_tone:': u'\U0001F446\U0001F3FD',
    u':bacon:': u'\U0001F953',
    u':badger:': u'\U0001F9A1',
    u':badminton:': u'\U0001F3F8',
    u':bagel:': u'\U0001F96F',
    u':baggage_claim:': u'\U0001F6C4',
    u':baguette_bread:': u'\U0001F956',
    u':balance_scale:': u'\U00002696',
    u':bald:': u'\U0001F9B2',
    u':bald_man:': u'\U0001F468\U0000200D\U0001F9B2',
    u':bald_woman:': u'\U0001F469\U0000200D\U0001F9B2',
    u':ballet_shoes:': u'\U0001FA70',
    u':balloon:': u'\U0001F388',
    u':ballot_box_with_ballot:': u'\U0001F5F3',
    u':ballot_box_with_check:': u'\U00002611',
    u':banana:': u'\U0001F34C',
    u':banjo:': u'\U0001FA95',
    u':bank:': u'\U0001F3E6',
    u':bar_chart:': u'\U0001F4CA',
    u':barber_pole:': u'\U0001F488',
    u':baseball:': u'\U000026BE',
    u':basket:': u'\U0001F9FA',
    u':basketball:': u'\U0001F3C0',
    u':bat:': u'\U0001F987',
    u':bathtub:': u'\U0001F6C1',
    u':battery:': u'\U0001F50B',
    u':beach_with_umbrella:': u'\U0001F3D6',
    u':beaming_face_with_smiling_eyes:': u'\U0001F601',
    u':bear_face:': u'\U0001F43B',
    u':bearded_person:': u'\U0001F9D4',
    u':bearded_person_dark_skin_tone:': u'\U0001F9D4\U0001F3FF',
    u':bearded_person_light_skin_tone:': u'\U0001F9D4\U0001F3FB',
    u':bearded_person_medium-dark_skin_tone:': u'\U0001F9D4\U0001F3FE',
    u':bearded_person_medium-light_skin_tone:': u'\U0001F9D4\U0001F3FC',
    u':bearded_person_medium_skin_tone:': u'\U0001F9D4\U0001F3FD',
    u':beating_heart:': u'\U0001F493',
    u':bed:': u'\U0001F6CF',
    u':beer_mug:': u'\U0001F37A',
    u':bell:': u'\U0001F514',
    u':bell_with_slash:': u'\U0001F515',
    u':bellhop_bell:': u'\U0001F6CE',
    u':bento_box:': u'\U0001F371',
    u':beverage_box:': u'\U0001F9C3',
    u':bicycle:': u'\U0001F6B2',
    u':bikini:': u'\U0001F459',
    u':billed_cap:': u'\U0001F9E2',
    u':biohazard:': u'\U00002623',
    u':bird:': u'\U0001F426',
    u':birthday_cake:': u'\U0001F382',
    u':black_circle:': u'\U000026AB',
    u':black_flag:': u'\U0001F3F4',
    u':black_heart:': u'\U0001F5A4',
    u':black_large_square:': u'\U00002B1B',
    u':black_medium-small_square:': u'\U000025FE',
    u':black_medium_square:': u'\U000025FC',
    u':black_nib:': u'\U00002712',
    u':black_small_square:': u'\U000025AA',
    u':black_square_button:': u'\U0001F532',
    u':blond-haired_man:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_dark_skin_tone:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_light_skin_tone:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_medium-dark_skin_tone:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_medium-light_skin_tone:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_medium_skin_tone:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_person:': u'\U0001F471',
    u':blond-haired_person_dark_skin_tone:': u'\U0001F471\U0001F3FF',
    u':blond-haired_person_light_skin_tone:': u'\U0001F471\U0001F3FB',
    u':blond-haired_person_medium-dark_skin_tone:': u'\U0001F471\U0001F3FE',
    u':blond-haired_person_medium-light_skin_tone:': u'\U0001F471\U0001F3FC',
    u':blond-haired_person_medium_skin_tone:': u'\U0001F471\U0001F3FD',
    u':blond-haired_woman:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_dark_skin_tone:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_light_skin_tone:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_medium-dark_skin_tone:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_medium-light_skin_tone:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_medium_skin_tone:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':blossom:': u'\U0001F33C',
    u':blowfish:': u'\U0001F421',
    u':blue_book:': u'\U0001F4D8',
    u':blue_circle:': u'\U0001F535',
    u':blue_heart:': u'\U0001F499',
    u':blue_square:': u'\U0001F7E6',
    u':boar:': u'\U0001F417',
    u':bomb:': u'\U0001F4A3',
    u':bone:': u'\U0001F9B4',
    u':bookmark:': u'\U0001F516',
    u':bookmark_tabs:': u'\U0001F4D1',
    u':books:': u'\U0001F4DA',
    u':bottle_with_popping_cork:': u'\U0001F37E',
    u':bouquet:': u'\U0001F490',
    u':bow_and_arrow:': u'\U0001F3F9',
    u':bowl_with_spoon:': u'\U0001F963',
    u':bowling:': u'\U0001F3B3',
    u':boxing_glove:': u'\U0001F94A',
    u':boy:': u'\U0001F466',
    u':boy_dark_skin_tone:': u'\U0001F466\U0001F3FF',
    u':boy_light_skin_tone:': u'\U0001F466\U0001F3FB',
    u':boy_medium-dark_skin_tone:': u'\U0001F466\U0001F3FE',
    u':boy_medium-light_skin_tone:': u'\U0001F466\U0001F3FC',
    u':boy_medium_skin_tone:': u'\U0001F466\U0001F3FD',
    u':brain:': u'\U0001F9E0',
    u':bread:': u'\U0001F35E',
    u':breast-feeding:': u'\U0001F931',
    u':breast-feeding_dark_skin_tone:': u'\U0001F931\U0001F3FF',
    u':breast-feeding_light_skin_tone:': u'\U0001F931\U0001F3FB',
    u':breast-feeding_medium-dark_skin_tone:': u'\U0001F931\U0001F3FE',
    u':breast-feeding_medium-light_skin_tone:': u'\U0001F931\U0001F3FC',
    u':breast-feeding_medium_skin_tone:': u'\U0001F931\U0001F3FD',
    u':brick:': u'\U0001F9F1',
    u':bride_with_veil:': u'\U0001F470',
    u':bride_with_veil_dark_skin_tone:': u'\U0001F470\U0001F3FF',
    u':bride_with_veil_light_skin_tone:': u'\U0001F470\U0001F3FB',
    u':bride_with_veil_medium-dark_skin_tone:': u'\U0001F470\U0001F3FE',
    u':bride_with_veil_medium-light_skin_tone:': u'\U0001F470\U0001F3FC',
    u':bride_with_veil_medium_skin_tone:': u'\U0001F470\U0001F3FD',
    u':bridge_at_night:': u'\U0001F309',
    u':briefcase:': u'\U0001F4BC',
    u':briefs:': u'\U0001FA72',
    u':bright_button:': u'\U0001F506',
    u':broccoli:': u'\U0001F966',
    u':broken_heart:': u'\U0001F494',
    u':broom:': u'\U0001F9F9',
    u':brown_circle:': u'\U0001F7E4',
    u':brown_heart:': u'\U0001F90E',
    u':brown_square:': u'\U0001F7EB',
    u':bug:': u'\U0001F41B',
    u':building_construction:': u'\U0001F3D7',
    u':bullet_train:': u'\U0001F685',
    u':burrito:': u'\U0001F32F',
    u':bus:': u'\U0001F68C',
    u':bus_stop:': u'\U0001F68F',
    u':bust_in_silhouette:': u'\U0001F464',
    u':busts_in_silhouette:': u'\U0001F465',
    u':butter:': u'\U0001F9C8',
    u':butterfly:': u'\U0001F98B',
    u':cactus:': u'\U0001F335',
    u':calendar:': u'\U0001F4C5',
    u':call_me_hand:': u'\U0001F919',
    u':call_me_hand_dark_skin_tone:': u'\U0001F919\U0001F3FF',
    u':call_me_hand_light_skin_tone:': u'\U0001F919\U0001F3FB',
    u':call_me_hand_medium-dark_skin_tone:': u'\U0001F919\U0001F3FE',
    u':call_me_hand_medium-light_skin_tone:': u'\U0001F919\U0001F3FC',
    u':call_me_hand_medium_skin_tone:': u'\U0001F919\U0001F3FD',
    u':camel:': u'\U0001F42A',
    u':camera:': u'\U0001F4F7',
    u':camera_with_flash:': u'\U0001F4F8',
    u':camping:': u'\U0001F3D5',
    u':candle:': u'\U0001F56F',
    u':candy:': u'\U0001F36C',
    u':canned_food:': u'\U0001F96B',
    u':canoe:': u'\U0001F6F6',
    u':card_file_box:': u'\U0001F5C3',
    u':card_index:': u'\U0001F4C7',
    u':card_index_dividers:': u'\U0001F5C2',
    u':carousel_horse:': u'\U0001F3A0',
    u':carp_streamer:': u'\U0001F38F',
    u':carrot:': u'\U0001F955',
    u':castle:': u'\U0001F3F0',
    u':cat:': u'\U0001F408',
    u':cat_face:': u'\U0001F431',
    u':cat_face_with_tears_of_joy:': u'\U0001F639',
    u':cat_face_with_wry_smile:': u'\U0001F63C',
    u':chains:': u'\U000026D3',
    u':chair:': u'\U0001FA91',
    u':chart_decreasing:': u'\U0001F4C9',
    u':chart_increasing:': u'\U0001F4C8',
    u':chart_increasing_with_yen:': u'\U0001F4B9',
    u':cheese_wedge:': u'\U0001F9C0',
    u':chequered_flag:': u'\U0001F3C1',
    u':cherries:': u'\U0001F352',
    u':cherry_blossom:': u'\U0001F338',
    u':chess_pawn:': u'\U0000265F',
    u':chestnut:': u'\U0001F330',
    u':chicken:': u'\U0001F414',
    u':child:': u'\U0001F9D2',
    u':child_dark_skin_tone:': u'\U0001F9D2\U0001F3FF',
    u':child_light_skin_tone:': u'\U0001F9D2\U0001F3FB',
    u':child_medium-dark_skin_tone:': u'\U0001F9D2\U0001F3FE',
    u':child_medium-light_skin_tone:': u'\U0001F9D2\U0001F3FC',
    u':child_medium_skin_tone:': u'\U0001F9D2\U0001F3FD',
    u':children_crossing:': u'\U0001F6B8',
    u':chipmunk:': u'\U0001F43F',
    u':chocolate_bar:': u'\U0001F36B',
    u':chopsticks:': u'\U0001F962',
    u':church:': u'\U000026EA',
    u':cigarette:': u'\U0001F6AC',
    u':cinema:': u'\U0001F3A6',
    u':circled_M:': u'\U000024C2',
    u':circus_tent:': u'\U0001F3AA',
    u':cityscape:': u'\U0001F3D9',
    u':cityscape_at_dusk:': u'\U0001F306',
    u':clamp:': u'\U0001F5DC',
    u':clapper_board:': u'\U0001F3AC',
    u':clapping_hands:': u'\U0001F44F',
    u':clapping_hands_dark_skin_tone:': u'\U0001F44F\U0001F3FF',
    u':clapping_hands_light_skin_tone:': u'\U0001F44F\U0001F3FB',
    u':clapping_hands_medium-dark_skin_tone:': u'\U0001F44F\U0001F3FE',
    u':clapping_hands_medium-light_skin_tone:': u'\U0001F44F\U0001F3FC',
    u':clapping_hands_medium_skin_tone:': u'\U0001F44F\U0001F3FD',
    u':classical_building:': u'\U0001F3DB',
    u':clinking_beer_mugs:': u'\U0001F37B',
    u':clinking_glasses:': u'\U0001F942',
    u':clipboard:': u'\U0001F4CB',
    u':clockwise_vertical_arrows:': u'\U0001F503',
    u':closed_book:': u'\U0001F4D5',
    u':closed_mailbox_with_lowered_flag:': u'\U0001F4EA',
    u':closed_mailbox_with_raised_flag:': u'\U0001F4EB',
    u':closed_umbrella:': u'\U0001F302',
    u':cloud:': u'\U00002601',
    u':cloud_with_lightning:': u'\U0001F329',
    u':cloud_with_lightning_and_rain:': u'\U000026C8',
    u':cloud_with_rain:': u'\U0001F327',
    u':cloud_with_snow:': u'\U0001F328',
    u':clown_face:': u'\U0001F921',
    u':club_suit:': u'\U00002663',
    u':clutch_bag:': u'\U0001F45D',
    u':coat:': u'\U0001F9E5',
    u':cocktail_glass:': u'\U0001F378',
    u':coconut:': u'\U0001F965',
    u':coffin:': u'\U000026B0',
    u':cold_face:': u'\U0001F976',
    u':collision:': u'\U0001F4A5',
    u':comet:': u'\U00002604',
    u':compass:': u'\U0001F9ED',
    u':computer_disk:': u'\U0001F4BD',
    u':computer_mouse:': u'\U0001F5B1',
    u':confetti_ball:': u'\U0001F38A',
    u':confounded_face:': u'\U0001F616',
    u':confused_face:': u'\U0001F615',
    u':construction:': u'\U0001F6A7',
    u':construction_worker:': u'\U0001F477',
    u':construction_worker_dark_skin_tone:': u'\U0001F477\U0001F3FF',
    u':construction_worker_light_skin_tone:': u'\U0001F477\U0001F3FB',
    u':construction_worker_medium-dark_skin_tone:': u'\U0001F477\U0001F3FE',
    u':construction_worker_medium-light_skin_tone:': u'\U0001F477\U0001F3FC',
    u':construction_worker_medium_skin_tone:': u'\U0001F477\U0001F3FD',
    u':control_knobs:': u'\U0001F39B',
    u':convenience_store:': u'\U0001F3EA',
    u':cooked_rice:': u'\U0001F35A',
    u':cookie:': u'\U0001F36A',
    u':cooking:': u'\U0001F373',
    u':copyright:': u'\U000000A9',
    u':couch_and_lamp:': u'\U0001F6CB',
    u':counterclockwise_arrows_button:': u'\U0001F504',
    u':couple_with_heart:': u'\U0001F491',
    u':couple_with_heart_man_man:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':couple_with_heart_woman_man:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':couple_with_heart_woman_woman:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
    u':cow:': u'\U0001F404',
    u':cow_face:': u'\U0001F42E',
    u':cowboy_hat_face:': u'\U0001F920',
    u':crab:': u'\U0001F980',
    u':crayon:': u'\U0001F58D',
    u':credit_card:': u'\U0001F4B3',
    u':crescent_moon:': u'\U0001F319',
    u':cricket:': u'\U0001F997',
    u':cricket_game:': u'\U0001F3CF',
    u':crocodile:': u'\U0001F40A',
    u':croissant:': u'\U0001F950',
    u':cross_mark:': u'\U0000274C',
    u':cross_mark_button:': u'\U0000274E',
    u':crossed_fingers:': u'\U0001F91E',
    u':crossed_fingers_dark_skin_tone:': u'\U0001F91E\U0001F3FF',
    u':crossed_fingers_light_skin_tone:': u'\U0001F91E\U0001F3FB',
    u':crossed_fingers_medium-dark_skin_tone:': u'\U0001F91E\U0001F3FE',
    u':crossed_fingers_medium-light_skin_tone:': u'\U0001F91E\U0001F3FC',
    u':crossed_fingers_medium_skin_tone:': u'\U0001F91E\U0001F3FD',
    u':crossed_flags:': u'\U0001F38C',
    u':crossed_swords:': u'\U00002694',
    u':crown:': u'\U0001F451',
    u':crying_cat_face:': u'\U0001F63F',
    u':crying_face:': u'\U0001F622',
    u':crystal_ball:': u'\U0001F52E',
    u':cucumber:': u'\U0001F952',
    u':cupcake:': u'\U0001F9C1',
    u':cup_with_straw:': u'\U0001F964',
    u':curling_stone:': u'\U0001F94C',
    u':curly_hair:': u'\U0001F9B1',
    u':curly-haired_man:': u'\U0001F468\U0000200D\U0001F9B1',
    u':curly-haired_woman:': u'\U0001F469\U0000200D\U0001F9B1',
    u':curly_loop:': u'\U000027B0',
    u':currency_exchange:': u'\U0001F4B1',
    u':curry_rice:': u'\U0001F35B',
    u':custard:': u'\U0001F36E',
    u':customs:': u'\U0001F6C3',
    u':cut_of_meat:': u'\U0001F969',
    u':cyclone:': u'\U0001F300',
    u':dagger:': u'\U0001F5E1',
    u':dango:': u'\U0001F361',
    u':dashing_away:': u'\U0001F4A8',
    u':deaf_person:': u'\U0001F9CF',
    u':deciduous_tree:': u'\U0001F333',
    u':deer:': u'\U0001F98C',
    u':delivery_truck:': u'\U0001F69A',
    u':department_store:': u'\U0001F3EC',
    u':derelict_house:': u'\U0001F3DA',
    u':desert:': u'\U0001F3DC',
    u':desert_island:': u'\U0001F3DD',
    u':desktop_computer:': u'\U0001F5A5',
    u':detective:': u'\U0001F575',
    u':detective_dark_skin_tone:': u'\U0001F575\U0001F3FF',
    u':detective_light_skin_tone:': u'\U0001F575\U0001F3FB',
    u':detective_medium-dark_skin_tone:': u'\U0001F575\U0001F3FE',
    u':detective_medium-light_skin_tone:': u'\U0001F575\U0001F3FC',
    u':detective_medium_skin_tone:': u'\U0001F575\U0001F3FD',
    u':diamond_suit:': u'\U00002666',
    u':diamond_with_a_dot:': u'\U0001F4A0',
    u':dim_button:': u'\U0001F505',
    u':direct_hit:': u'\U0001F3AF',
    u':disappointed_face:': u'\U0001F61E',
    u':diving_mask:': u'\U0001F93F',
    u':diya_lamp:': u'\U0001FA94',
    u':dizzy:': u'\U0001F4AB',
    u':dizzy_face:': u'\U0001F635',
    u':dna:': u'\U0001F9EC',
    u':dog:': u'\U0001F415',
    u':dog_face:': u'\U0001F436',
    u':dollar_banknote:': u'\U0001F4B5',
    u':dolphin:': u'\U0001F42C',
    u':door:': u'\U0001F6AA',
    u':dotted_six-pointed_star:': u'\U0001F52F',
    u':double_curly_loop:': u'\U000027BF',
    u':double_exclamation_mark:': u'\U0000203C',
    u':doughnut:': u'\U0001F369',
    u':dove:': u'\U0001F54A',
    u':down-left_arrow:': u'\U00002199',
    u':down-right_arrow:': u'\U00002198',
    u':down_arrow:': u'\U00002B07',
    u':downcast_face_with_sweat:': u'\U0001F613',
    u':downwards_button:': u'\U0001F53D',
    u':dragon:': u'\U0001F409',
    u':dragon_face:': u'\U0001F432',
    u':dress:': u'\U0001F457',
    u':drooling_face:': u'\U0001F924',
    u':drop_of_blood:': u'\U0001FA78',
    u':droplet:': u'\U0001F4A7',
    u':drum:': u'\U0001F941',
    u':duck:': u'\U0001F986',
    u':dumpling:': u'\U0001F95F',
    u':dvd:': u'\U0001F4C0',
    u':e-mail:': u'\U0001F4E7',
    u':eagle:': u'\U0001F985',
    u':ear:': u'\U0001F442',
    u':ear_dark_skin_tone:': u'\U0001F442\U0001F3FF',
    u':ear_light_skin_tone:': u'\U0001F442\U0001F3FB',
    u':ear_medium-dark_skin_tone:': u'\U0001F442\U0001F3FE',
    u':ear_medium-light_skin_tone:': u'\U0001F442\U0001F3FC',
    u':ear_medium_skin_tone:': u'\U0001F442\U0001F3FD',
    u':ear_of_corn:': u'\U0001F33D',
    u':ear_with_hearing_aid:': u'\U0001F9BB',
    u':egg:': u'\U0001F95A',
    u':eggplant:': u'\U0001F346',
    u':eight-pointed_star:': u'\U00002734',
    u':eight-spoked_asterisk:': u'\U00002733',
    u':eight-thirty:': u'\U0001F563',
    u':eight_o’clock:': u'\U0001F557',
    u':eject_button:': u'\U000023CF',
    u':electric_plug:': u'\U0001F50C',
    u':elephant:': u'\U0001F418',
    u':eleven-thirty:': u'\U0001F566',
    u':eleven_o’clock:': u'\U0001F55A',
    u':elf:': u'\U0001F9DD',
    u':elf_dark_skin_tone:': u'\U0001F9DD\U0001F3FF',
    u':elf_light_skin_tone:': u'\U0001F9DD\U0001F3FB',
    u':elf_medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE',
    u':elf_medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC',
    u':elf_medium_skin_tone:': u'\U0001F9DD\U0001F3FD',
    u':envelope:': u'\U00002709',
    u':envelope_with_arrow:': u'\U0001F4E9',
    u':euro_banknote:': u'\U0001F4B6',
    u':evergreen_tree:': u'\U0001F332',
    u':ewe:': u'\U0001F411',
    u':exclamation_mark:': u'\U00002757',
    u':exclamation_question_mark:': u'\U00002049',
    u':exploding_head:': u'\U0001F92F',
    u':expressionless_face:': u'\U0001F611',
    u':eye:': u'\U0001F441',
    u':eye_in_speech_bubble:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
    u':eyes:': u'\U0001F440',
    u':face_blowing_a_kiss:': u'\U0001F618',
    u':face_savoring_food:': u'\U0001F60B',
    u':face_screaming_in_fear:': u'\U0001F631',
    u':face_vomiting:': u'\U0001F92E',
    u':face_with_hand_over_mouth:': u'\U0001F92D',
    u':face_with_head-bandage:': u'\U0001F915',
    u':face_with_medical_mask:': u'\U0001F637',
    u':face_with_monocle:': u'\U0001F9D0',
    u':face_with_open_mouth:': u'\U0001F62E',
    u':face_with_raised_eyebrow:': u'\U0001F928',
    u':face_with_rolling_eyes:': u'\U0001F644',
    u':face_with_steam_from_nose:': u'\U0001F624',
    u':face_with_symbols_on_mouth:': u'\U0001F92C',
    u':face_with_tears_of_joy:': u'\U0001F602',
    u':face_with_thermometer:': u'\U0001F912',
    u':face_with_tongue:': u'\U0001F61B',
    u':face_without_mouth:': u'\U0001F636',
    u':factory:': u'\U0001F3ED',
    u':fairy:': u'\U0001F9DA',
    u':fairy_dark_skin_tone:': u'\U0001F9DA\U0001F3FF',
    u':fairy_light_skin_tone:': u'\U0001F9DA\U0001F3FB',
    u':fairy_medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE',
    u':fairy_medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC',
    u':fairy_medium_skin_tone:': u'\U0001F9DA\U0001F3FD',
    u':falafel:': u'\U0001F9C6',
    u':fallen_leaf:': u'\U0001F342',
    u':family:': u'\U0001F46A',
    u':family_man_boy:': u'\U0001F468\U0000200D\U0001F466',
    u':family_man_boy_boy:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_man_girl:': u'\U0001F468\U0000200D\U0001F467',
    u':family_man_girl_boy:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_man_girl_girl:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_man_man_boy:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
    u':family_man_man_boy_boy:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_man_man_girl:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
    u':family_man_man_girl_boy:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_man_man_girl_girl:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_man_woman_boy:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
    u':family_man_woman_boy_boy:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_man_woman_girl:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
    u':family_man_woman_girl_boy:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_man_woman_girl_girl:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_woman_boy:': u'\U0001F469\U0000200D\U0001F466',
    u':family_woman_boy_boy:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_woman_girl:': u'\U0001F469\U0000200D\U0001F467',
    u':family_woman_girl_boy:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_woman_girl_girl:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_woman_woman_boy:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
    u':family_woman_woman_boy_boy:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_woman_woman_girl:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
    u':family_woman_woman_girl_boy:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_woman_woman_girl_girl:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':fast-forward_button:': u'\U000023E9',
    u':fast_down_button:': u'\U000023EC',
    u':fast_reverse_button:': u'\U000023EA',
    u':fast_up_button:': u'\U000023EB',
    u':fax_machine:': u'\U0001F4E0',
    u':fearful_face:': u'\U0001F628',
    u':female_sign:': u'\U00002640',
    u':ferris_wheel:': u'\U0001F3A1',
    u':ferry:': u'\U000026F4',
    u':field_hockey:': u'\U0001F3D1',
    u':file_cabinet:': u'\U0001F5C4',
    u':file_folder:': u'\U0001F4C1',
    u':film_frames:': u'\U0001F39E',
    u':film_projector:': u'\U0001F4FD',
    u':fire:': u'\U0001F525',
    u':fire_extinguisher:': u'\U0001F9EF',
    u':firecracker:': u'\U0001F9E8',
    u':fire_engine:': u'\U0001F692',
    u':fireworks:': u'\U0001F386',
    u':first_quarter_moon:': u'\U0001F313',
    u':first_quarter_moon_face:': u'\U0001F31B',
    u':fish:': u'\U0001F41F',
    u':fish_cake_with_swirl:': u'\U0001F365',
    u':fishing_pole:': u'\U0001F3A3',
    u':five-thirty:': u'\U0001F560',
    u':five_o’clock:': u'\U0001F554',
    u':flag_in_hole:': u'\U000026F3',
    u':flamingo:': u'\U0001F9A9',
    u':flashlight:': u'\U0001F526',
    u':flat_shoe:': u'\U0001F97F',
    u':fleur-de-lis:': u'\U0000269C',
    u':flexed_biceps:': u'\U0001F4AA',
    u':flexed_biceps_dark_skin_tone:': u'\U0001F4AA\U0001F3FF',
    u':flexed_biceps_light_skin_tone:': u'\U0001F4AA\U0001F3FB',
    u':flexed_biceps_medium-dark_skin_tone:': u'\U0001F4AA\U0001F3FE',
    u':flexed_biceps_medium-light_skin_tone:': u'\U0001F4AA\U0001F3FC',
    u':flexed_biceps_medium_skin_tone:': u'\U0001F4AA\U0001F3FD',
    u':floppy_disk:': u'\U0001F4BE',
    u':flower_playing_cards:': u'\U0001F3B4',
    u':flushed_face:': u'\U0001F633',
    u':flying_disc:': u'\U0001F94F',
    u':flying_saucer:': u'\U0001F6F8',
    u':fog:': u'\U0001F32B',
    u':foggy:': u'\U0001F301',
    u':folded_hands:': u'\U0001F64F',
    u':folded_hands_dark_skin_tone:': u'\U0001F64F\U0001F3FF',
    u':folded_hands_light_skin_tone:': u'\U0001F64F\U0001F3FB',
    u':folded_hands_medium-dark_skin_tone:': u'\U0001F64F\U0001F3FE',
    u':folded_hands_medium-light_skin_tone:': u'\U0001F64F\U0001F3FC',
    u':folded_hands_medium_skin_tone:': u'\U0001F64F\U0001F3FD',
    u':foot:': u'\U0001F9B6',
    u':footprints:': u'\U0001F463',
    u':fork_and_knife:': u'\U0001F374',
    u':fork_and_knife_with_plate:': u'\U0001F37D',
    u':fortune_cookie:': u'\U0001F960',
    u':fountain:': u'\U000026F2',
    u':fountain_pen:': u'\U0001F58B',
    u':four-thirty:': u'\U0001F55F',
    u':four_leaf_clover:': u'\U0001F340',
    u':four_o’clock:': u'\U0001F553',
    u':fox_face:': u'\U0001F98A',
    u':framed_picture:': u'\U0001F5BC',
    u':french_fries:': u'\U0001F35F',
    u':fried_shrimp:': u'\U0001F364',
    u':frog_face:': u'\U0001F438',
    u':front-facing_baby_chick:': u'\U0001F425',
    u':frowning_face:': u'\U00002639',
    u':frowning_face_with_open_mouth:': u'\U0001F626',
    u':fuel_pump:': u'\U000026FD',
    u':full_moon:': u'\U0001F315',
    u':full_moon_face:': u'\U0001F31D',
    u':funeral_urn:': u'\U000026B1',
    u':game_die:': u'\U0001F3B2',
    u':garlic:': u'\U0001F9C4',
    u':gear:': u'\U00002699',
    u':gem_stone:': u'\U0001F48E',
    u':genie:': u'\U0001F9DE',
    u':ghost:': u'\U0001F47B',
    u':giraffe:': u'\U0001F992',
    u':girl:': u'\U0001F467',
    u':girl_dark_skin_tone:': u'\U0001F467\U0001F3FF',
    u':girl_light_skin_tone:': u'\U0001F467\U0001F3FB',
    u':girl_medium-dark_skin_tone:': u'\U0001F467\U0001F3FE',
    u':girl_medium-light_skin_tone:': u'\U0001F467\U0001F3FC',
    u':girl_medium_skin_tone:': u'\U0001F467\U0001F3FD',
    u':glass_of_milk:': u'\U0001F95B',
    u':glasses:': u'\U0001F453',
    u':globe_showing_Americas:': u'\U0001F30E',
    u':globe_showing_Asia-Australia:': u'\U0001F30F',
    u':globe_showing_Europe-Africa:': u'\U0001F30D',
    u':globe_with_meridians:': u'\U0001F310',
    u':gloves:': u'\U0001F9E4',
    u':glowing_star:': u'\U0001F31F',
    u':goal_net:': u'\U0001F945',
    u':goat:': u'\U0001F410',
    u':goblin:': u'\U0001F47A',
    u':goggles:': u'\U0001F97D',
    u':gorilla:': u'\U0001F98D',
    u':graduation_cap:': u'\U0001F393',
    u':grapes:': u'\U0001F347',
    u':green_apple:': u'\U0001F34F',
    u':green_book:': u'\U0001F4D7',
    u':green_circle:': u'\U0001F7E2',
    u':green_heart:': u'\U0001F49A',
    u':green_salad:': u'\U0001F957',
    u':green_square:': u'\U0001F7E9',
    u':grimacing_face:': u'\U0001F62C',
    u':grinning_cat_face:': u'\U0001F63A',
    u':grinning_cat_face_with_smiling_eyes:': u'\U0001F638',
    u':grinning_face:': u'\U0001F600',
    u':grinning_face_with_big_eyes:': u'\U0001F603',
    u':grinning_face_with_smiling_eyes:': u'\U0001F604',
    u':grinning_face_with_sweat:': u'\U0001F605',
    u':grinning_squinting_face:': u'\U0001F606',
    u':growing_heart:': u'\U0001F497',
    u':guard:': u'\U0001F482',
    u':guard_dark_skin_tone:': u'\U0001F482\U0001F3FF',
    u':guard_light_skin_tone:': u'\U0001F482\U0001F3FB',
    u':guard_medium-dark_skin_tone:': u'\U0001F482\U0001F3FE',
    u':guard_medium-light_skin_tone:': u'\U0001F482\U0001F3FC',
    u':guard_medium_skin_tone:': u'\U0001F482\U0001F3FD',
    u':guide_dog:': u'\U0001F9AE',
    u':guitar:': u'\U0001F3B8',
    u':hamburger:': u'\U0001F354',
    u':hammer:': u'\U0001F528',
    u':hammer_and_pick:': u'\U00002692',
    u':hammer_and_wrench:': u'\U0001F6E0',
    u':hamster_face:': u'\U0001F439',
    u':hand_with_fingers_splayed:': u'\U0001F590',
    u':hand_with_fingers_splayed_dark_skin_tone:': u'\U0001F590\U0001F3FF',
    u':hand_with_fingers_splayed_light_skin_tone:': u'\U0001F590\U0001F3FB',
    u':hand_with_fingers_splayed_medium-dark_skin_tone:': u'\U0001F590\U0001F3FE',
    u':hand_with_fingers_splayed_medium-light_skin_tone:': u'\U0001F590\U0001F3FC',
    u':hand_with_fingers_splayed_medium_skin_tone:': u'\U0001F590\U0001F3FD',
    u':handbag:': u'\U0001F45C',
    u':handshake:': u'\U0001F91D',
    u':hatching_chick:': u'\U0001F423',
    u':headphone:': u'\U0001F3A7',
    u':hear-no-evil_monkey:': u'\U0001F649',
    u':heart_decoration:': u'\U0001F49F',
    u':heart_suit:': u'\U00002665',
    u':heart_with_arrow:': u'\U0001F498',
    u':heart_with_ribbon:': u'\U0001F49D',
    u':heavy_check_mark:': u'\U00002714',
    u':heavy_division_sign:': u'\U00002797',
    u':heavy_dollar_sign:': u'\U0001F4B2',
    u':heavy_heart_exclamation:': u'\U00002763',
    u':heavy_large_circle:': u'\U00002B55',
    u':heavy_minus_sign:': u'\U00002796',
    u':heavy_multiplication_x:': u'\U00002716',
    u':heavy_plus_sign:': u'\U00002795',
    u':hedgehog:': u'\U0001F994',
    u':helicopter:': u'\U0001F681',
    u':herb:': u'\U0001F33F',
    u':hibiscus:': u'\U0001F33A',
    u':high-heeled_shoe:': u'\U0001F460',
    u':high-speed_train:': u'\U0001F684',
    u':high_voltage:': u'\U000026A1',
    u':hiking_boot:': u'\U0001F97E',
    u':hindu_temple:': u'\U0001F6D5',
    u':hippopotamus:': u'\U0001F99B',
    u':hole:': u'\U0001F573',
    u':honey_pot:': u'\U0001F36F',
    u':honeybee:': u'\U0001F41D',
    u':horizontal_traffic_light:': u'\U0001F6A5',
    u':horse:': u'\U0001F40E',
    u':horse_face:': u'\U0001F434',
    u':horse_racing:': u'\U0001F3C7',
    u':horse_racing_dark_skin_tone:': u'\U0001F3C7\U0001F3FF',
    u':horse_racing_light_skin_tone:': u'\U0001F3C7\U0001F3FB',
    u':horse_racing_medium-dark_skin_tone:': u'\U0001F3C7\U0001F3FE',
    u':horse_racing_medium-light_skin_tone:': u'\U0001F3C7\U0001F3FC',
    u':horse_racing_medium_skin_tone:': u'\U0001F3C7\U0001F3FD',
    u':hospital:': u'\U0001F3E5',
    u':hot_beverage:': u'\U00002615',
    u':hot_dog:': u'\U0001F32D',
    u':hot_face:': u'\U0001F975',
    u':hot_pepper:': u'\U0001F336',
    u':hot_springs:': u'\U00002668',
    u':hotel:': u'\U0001F3E8',
    u':hourglass_done:': u'\U0000231B',
    u':hourglass_not_done:': u'\U000023F3',
    u':house:': u'\U0001F3E0',
    u':house_with_garden:': u'\U0001F3E1',
    u':houses:': u'\U0001F3D8',
    u':hugging_face:': u'\U0001F917',
    u':hundred_points:': u'\U0001F4AF',
    u':hushed_face:': u'\U0001F62F',
    u':ice:': u'\U0001F9CA',
    u':ice_cream:': u'\U0001F368',
    u':ice_hockey:': u'\U0001F3D2',
    u':ice_skate:': u'\U000026F8',
    u':inbox_tray:': u'\U0001F4E5',
    u':incoming_envelope:': u'\U0001F4E8',
    u':index_pointing_up:': u'\U0000261D',
    u':index_pointing_up_dark_skin_tone:': u'\U0000261D\U0001F3FF',
    u':index_pointing_up_light_skin_tone:': u'\U0000261D\U0001F3FB',
    u':index_pointing_up_medium-dark_skin_tone:': u'\U0000261D\U0001F3FE',
    u':index_pointing_up_medium-light_skin_tone:': u'\U0000261D\U0001F3FC',
    u':index_pointing_up_medium_skin_tone:': u'\U0000261D\U0001F3FD',
    u':infinity:': u'\U0000267E',
    u':information:': u'\U00002139',
    u':input_latin_letters:': u'\U0001F524',
    u':input_latin_lowercase:': u'\U0001F521',
    u':input_latin_uppercase:': u'\U0001F520',
    u':input_numbers:': u'\U0001F522',
    u':input_symbols:': u'\U0001F523',
    u':jack-o-lantern:': u'\U0001F383',
    u':jeans:': u'\U0001F456',
    u':jigsaw:': u'\U0001F9E9',
    u':joker:': u'\U0001F0CF',
    u':joystick:': u'\U0001F579',
    u':kaaba:': u'\U0001F54B',
    u':kangaroo:': u'\U0001F998',
    u':key:': u'\U0001F511',
    u':keyboard:': u'\U00002328',
    u':keycap_#:': u'\U00000023\U0000FE0F\U000020E3',
    u':keycap_*:': u'\U0000002A\U0000FE0F\U000020E3',
    u':keycap_0:': u'\U00000030\U0000FE0F\U000020E3',
    u':keycap_1:': u'\U00000031\U0000FE0F\U000020E3',
    u':keycap_10:': u'\U0001F51F',
    u':keycap_2:': u'\U00000032\U0000FE0F\U000020E3',
    u':keycap_3:': u'\U00000033\U0000FE0F\U000020E3',
    u':keycap_4:': u'\U00000034\U0000FE0F\U000020E3',
    u':keycap_5:': u'\U00000035\U0000FE0F\U000020E3',
    u':keycap_6:': u'\U00000036\U0000FE0F\U000020E3',
    u':keycap_7:': u'\U00000037\U0000FE0F\U000020E3',
    u':keycap_8:': u'\U00000038\U0000FE0F\U000020E3',
    u':keycap_9:': u'\U00000039\U0000FE0F\U000020E3',
    u':kick_scooter:': u'\U0001F6F4',
    u':kimono:': u'\U0001F458',
    u':kiss:': u'\U0001F48F',
    u':kiss_man_man:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':kiss_mark:': u'\U0001F48B',
    u':kiss_woman_man:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':kiss_woman_woman:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
    u':kissing_cat_face:': u'\U0001F63D',
    u':kissing_face:': u'\U0001F617',
    u':kissing_face_with_closed_eyes:': u'\U0001F61A',
    u':kissing_face_with_smiling_eyes:': u'\U0001F619',
    u':kitchen_knife:': u'\U0001F52A',
    u':kite:': u'\U0001FA81',
    u':kiwi_fruit:': u'\U0001F95D',
    u':koala:': u'\U0001F428',
    u':lab_coat:': u'\U0001F97C',
    u':label:': u'\U0001F3F7',
    u':lacrosse:': u'\U0001F94D',
    u':lady_beetle:': u'\U0001F41E',
    u':laptop_computer:': u'\U0001F4BB',
    u':large_blue_diamond:': u'\U0001F537',
    u':large_orange_diamond:': u'\U0001F536',
    u':last_quarter_moon:': u'\U0001F317',
    u':last_quarter_moon_face:': u'\U0001F31C',
    u':last_track_button:': u'\U000023EE',
    u':latin_cross:': u'\U0000271D',
    u':leaf_fluttering_in_wind:': u'\U0001F343',
    u':leafy_green:': u'\U0001F96C',
    u':ledger:': u'\U0001F4D2',
    u':left-facing_fist:': u'\U0001F91B',
    u':left-facing_fist_dark_skin_tone:': u'\U0001F91B\U0001F3FF',
    u':left-facing_fist_light_skin_tone:': u'\U0001F91B\U0001F3FB',
    u':left-facing_fist_medium-dark_skin_tone:': u'\U0001F91B\U0001F3FE',
    u':left-facing_fist_medium-light_skin_tone:': u'\U0001F91B\U0001F3FC',
    u':left-facing_fist_medium_skin_tone:': u'\U0001F91B\U0001F3FD',
    u':left-right_arrow:': u'\U00002194',
    u':left_arrow:': u'\U00002B05',
    u':left_arrow_curving_right:': u'\U000021AA',
    u':left_luggage:': u'\U0001F6C5',
    u':left_speech_bubble:': u'\U0001F5E8',
    u':leg:': u'\U0001F9B5',
    u':lemon:': u'\U0001F34B',
    u':leopard:': u'\U0001F406',
    u':level_slider:': u'\U0001F39A',
    u':light_bulb:': u'\U0001F4A1',
    u':light_rail:': u'\U0001F688',
    u':link:': u'\U0001F517',
    u':linked_paperclips:': u'\U0001F587',
    u':lion_face:': u'\U0001F981',
    u':lipstick:': u'\U0001F484',
    u':litter_in_bin_sign:': u'\U0001F6AE',
    u':lizard:': u'\U0001F98E',
    u':llama:': u'\U0001F999',
    u':lobster:': u'\U0001F99E',
    u':locked:': u'\U0001F512',
    u':locked_with_key:': u'\U0001F510',
    u':locked_with_pen:': u'\U0001F50F',
    u':locomotive:': u'\U0001F682',
    u':lollipop:': u'\U0001F36D',
    u':lotion_bottle:': u'\U0001F9F4',
    u':loudly_crying_face:': u'\U0001F62D',
    u':loudspeaker:': u'\U0001F4E2',
    u':love-you_gesture:': u'\U0001F91F',
    u':love-you_gesture_dark_skin_tone:': u'\U0001F91F\U0001F3FF',
    u':love-you_gesture_light_skin_tone:': u'\U0001F91F\U0001F3FB',
    u':love-you_gesture_medium-dark_skin_tone:': u'\U0001F91F\U0001F3FE',
    u':love-you_gesture_medium-light_skin_tone:': u'\U0001F91F\U0001F3FC',
    u':love-you_gesture_medium_skin_tone:': u'\U0001F91F\U0001F3FD',
    u':love_hotel:': u'\U0001F3E9',
    u':love_letter:': u'\U0001F48C',
    u':luggage:': u'\U0001F9F3',
    u':lying_face:': u'\U0001F925',
    u':mage:': u'\U0001F9D9',
    u':mage_dark_skin_tone:': u'\U0001F9D9\U0001F3FF',
    u':mage_light_skin_tone:': u'\U0001F9D9\U0001F3FB',
    u':mage_medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE',
    u':mage_medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC',
    u':mage_medium_skin_tone:': u'\U0001F9D9\U0001F3FD',
    u':magnet:': u'\U0001F9F2',
    u':magnifying_glass_tilted_left:': u'\U0001F50D',
    u':magnifying_glass_tilted_right:': u'\U0001F50E',
    u':mahjong_red_dragon:': u'\U0001F004',
    u':male_sign:': u'\U00002642',
    u':man:': u'\U0001F468',
    u':man_and_woman_holding_hands:': u'\U0001F46B',
    u':man_artist:': u'\U0001F468\U0000200D\U0001F3A8',
    u':man_artist_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
    u':man_artist_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
    u':man_artist_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
    u':man_artist_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
    u':man_artist_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
    u':man_astronaut:': u'\U0001F468\U0000200D\U0001F680',
    u':man_astronaut_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
    u':man_astronaut_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
    u':man_astronaut_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
    u':man_astronaut_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
    u':man_astronaut_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
    u':man_biking:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
    u':man_biking_dark_skin_tone:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_biking_light_skin_tone:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_biking_medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_biking_medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_biking_medium_skin_tone:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_dark_skin_tone:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_light_skin_tone:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_medium-dark_skin_tone:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_medium-light_skin_tone:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_medium_skin_tone:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_bowing:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_dark_skin_tone:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_light_skin_tone:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_medium-dark_skin_tone:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_medium-light_skin_tone:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_medium_skin_tone:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_dark_skin_tone:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_light_skin_tone:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_medium-dark_skin_tone:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_medium-light_skin_tone:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_medium_skin_tone:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_climbing:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_dark_skin_tone:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_light_skin_tone:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_medium_skin_tone:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_dark_skin_tone:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_light_skin_tone:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_medium-dark_skin_tone:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_medium-light_skin_tone:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_medium_skin_tone:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_cook:': u'\U0001F468\U0000200D\U0001F373',
    u':man_cook_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
    u':man_cook_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
    u':man_cook_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
    u':man_cook_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
    u':man_cook_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
    u':man_dancing:': u'\U0001F57A',
    u':man_dancing_dark_skin_tone:': u'\U0001F57A\U0001F3FF',
    u':man_dancing_light_skin_tone:': u'\U0001F57A\U0001F3FB',
    u':man_dancing_medium-dark_skin_tone:': u'\U0001F57A\U0001F3FE',
    u':man_dancing_medium-light_skin_tone:': u'\U0001F57A\U0001F3FC',
    u':man_dancing_medium_skin_tone:': u'\U0001F57A\U0001F3FD',
    u':man_dark_skin_tone:': u'\U0001F468\U0001F3FF',
    u':man_detective:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_detective_dark_skin_tone:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_detective_light_skin_tone:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_detective_medium-dark_skin_tone:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_detective_medium-light_skin_tone:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_detective_medium_skin_tone:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_elf:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
    u':man_elf_dark_skin_tone:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_elf_light_skin_tone:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_elf_medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_elf_medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_elf_medium_skin_tone:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_dark_skin_tone:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_light_skin_tone:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_medium-dark_skin_tone:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_medium-light_skin_tone:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_medium_skin_tone:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_factory_worker:': u'\U0001F468\U0000200D\U0001F3ED',
    u':man_factory_worker_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
    u':man_factory_worker_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
    u':man_factory_worker_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
    u':man_factory_worker_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
    u':man_factory_worker_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
    u':man_fairy:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_dark_skin_tone:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_light_skin_tone:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_medium_skin_tone:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_farmer:': u'\U0001F468\U0000200D\U0001F33E',
    u':man_farmer_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
    u':man_farmer_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
    u':man_farmer_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
    u':man_farmer_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
    u':man_farmer_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
    u':man_firefighter:': u'\U0001F468\U0000200D\U0001F692',
    u':man_firefighter_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
    u':man_firefighter_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
    u':man_firefighter_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
    u':man_firefighter_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
    u':man_firefighter_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
    u':man_frowning:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_dark_skin_tone:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_light_skin_tone:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_medium-light_skin_tone:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_medium_skin_tone:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_genie:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_dark_skin_tone:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_light_skin_tone:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_medium-dark_skin_tone:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_medium-light_skin_tone:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_medium_skin_tone:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_dark_skin_tone:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_light_skin_tone:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_medium-dark_skin_tone:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_medium-light_skin_tone:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_medium_skin_tone:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_dark_skin_tone:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_light_skin_tone:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_medium-dark_skin_tone:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_medium-light_skin_tone:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_medium_skin_tone:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_dark_skin_tone:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_light_skin_tone:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_medium-dark_skin_tone:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_medium-light_skin_tone:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_medium_skin_tone:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_golfing:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_dark_skin_tone:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_light_skin_tone:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_medium_skin_tone:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_guard:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
    u':man_guard_dark_skin_tone:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_guard_light_skin_tone:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_guard_medium-dark_skin_tone:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_guard_medium-light_skin_tone:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_guard_medium_skin_tone:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_health_worker:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':man_in_lotus_position:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_dark_skin_tone:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_light_skin_tone:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_medium_skin_tone:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_in_manual_wheelchair:': u'\U0001F468\U0000200D\U0001F9BD',
    u':man_in_motorized_wheelchair:': u'\U0001F468\U0000200D\U0001F9BC',
    u':man_in_steamy_room:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_dark_skin_tone:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_light_skin_tone:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_medium_skin_tone:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_in_suit_levitating:': u'\U0001F574',
    u':man_in_suit_levitating_dark_skin_tone:': u'\U0001F574\U0001F3FF',
    u':man_in_suit_levitating_light_skin_tone:': u'\U0001F574\U0001F3FB',
    u':man_in_suit_levitating_medium-dark_skin_tone:': u'\U0001F574\U0001F3FE',
    u':man_in_suit_levitating_medium-light_skin_tone:': u'\U0001F574\U0001F3FC',
    u':man_in_suit_levitating_medium_skin_tone:': u'\U0001F574\U0001F3FD',
    u':man_in_tuxedo:': u'\U0001F935',
    u':man_in_tuxedo_dark_skin_tone:': u'\U0001F935\U0001F3FF',
    u':man_in_tuxedo_light_skin_tone:': u'\U0001F935\U0001F3FB',
    u':man_in_tuxedo_medium-dark_skin_tone:': u'\U0001F935\U0001F3FE',
    u':man_in_tuxedo_medium-light_skin_tone:': u'\U0001F935\U0001F3FC',
    u':man_in_tuxedo_medium_skin_tone:': u'\U0001F935\U0001F3FD',
    u':man_judge:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
    u':man_judge_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':man_judge_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':man_judge_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':man_judge_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':man_judge_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':man_juggling:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_dark_skin_tone:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_light_skin_tone:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_medium-dark_skin_tone:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_medium-light_skin_tone:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_medium_skin_tone:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_dark_skin_tone:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_light_skin_tone:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_medium_skin_tone:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_light_skin_tone:': u'\U0001F468\U0001F3FB',
    u':man_mage:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
    u':man_mage_dark_skin_tone:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_mage_light_skin_tone:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_mage_medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_mage_medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_mage_medium_skin_tone:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_mechanic:': u'\U0001F468\U0000200D\U0001F527',
    u':man_mechanic_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
    u':man_mechanic_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
    u':man_mechanic_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
    u':man_mechanic_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
    u':man_mechanic_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
    u':man_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE',
    u':man_medium-light_skin_tone:': u'\U0001F468\U0001F3FC',
    u':man_medium_skin_tone:': u'\U0001F468\U0001F3FD',
    u':man_mountain_biking:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_dark_skin_tone:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_light_skin_tone:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_medium_skin_tone:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_office_worker:': u'\U0001F468\U0000200D\U0001F4BC',
    u':man_office_worker_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
    u':man_office_worker_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
    u':man_office_worker_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
    u':man_office_worker_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
    u':man_office_worker_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
    u':man_pilot:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':man_playing_handball:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_dark_skin_tone:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_light_skin_tone:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_medium-light_skin_tone:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_medium_skin_tone:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_dark_skin_tone:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_light_skin_tone:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_medium-light_skin_tone:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_medium_skin_tone:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_dark_skin_tone:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_light_skin_tone:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_medium-light_skin_tone:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_medium_skin_tone:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_pouting:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_dark_skin_tone:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_light_skin_tone:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_medium-light_skin_tone:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_medium_skin_tone:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_dark_skin_tone:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_light_skin_tone:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_medium-light_skin_tone:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_medium_skin_tone:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_dark_skin_tone:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_light_skin_tone:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_medium_skin_tone:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_running:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
    u':man_running_dark_skin_tone:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_running_light_skin_tone:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_running_medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_running_medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_running_medium_skin_tone:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_scientist:': u'\U0001F468\U0000200D\U0001F52C',
    u':man_scientist_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
    u':man_scientist_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
    u':man_scientist_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
    u':man_scientist_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
    u':man_scientist_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
    u':man_shrugging:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_dark_skin_tone:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_light_skin_tone:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_medium-dark_skin_tone:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_medium-light_skin_tone:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_medium_skin_tone:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_singer:': u'\U0001F468\U0000200D\U0001F3A4',
    u':man_singer_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
    u':man_singer_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
    u':man_singer_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
    u':man_singer_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
    u':man_singer_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
    u':man_student:': u'\U0001F468\U0000200D\U0001F393',
    u':man_student_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
    u':man_student_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
    u':man_student_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
    u':man_student_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
    u':man_student_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
    u':man_surfing:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_dark_skin_tone:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_light_skin_tone:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_medium_skin_tone:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_swimming:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_dark_skin_tone:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_light_skin_tone:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_medium_skin_tone:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_teacher:': u'\U0001F468\U0000200D\U0001F3EB',
    u':man_teacher_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
    u':man_teacher_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
    u':man_teacher_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
    u':man_teacher_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
    u':man_teacher_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
    u':man_technologist:': u'\U0001F468\U0000200D\U0001F4BB',
    u':man_technologist_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
    u':man_technologist_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
    u':man_technologist_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
    u':man_technologist_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
    u':man_technologist_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
    u':man_tipping_hand:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_dark_skin_tone:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_light_skin_tone:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_medium-dark_skin_tone:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_medium-light_skin_tone:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_medium_skin_tone:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_vampire:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_dark_skin_tone:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_light_skin_tone:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_medium_skin_tone:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_walking:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
    u':man_walking_dark_skin_tone:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_walking_light_skin_tone:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_walking_medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_walking_medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_walking_medium_skin_tone:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_dark_skin_tone:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_light_skin_tone:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_medium-dark_skin_tone:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_medium-light_skin_tone:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_medium_skin_tone:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_with_probing_cane:': u'\U0001F468\U0000200D\U0001F9AF',
    u':man_with_Chinese_cap:': u'\U0001F472',
    u':man_with_Chinese_cap_dark_skin_tone:': u'\U0001F472\U0001F3FF',
    u':man_with_Chinese_cap_light_skin_tone:': u'\U0001F472\U0001F3FB',
    u':man_with_Chinese_cap_medium-dark_skin_tone:': u'\U0001F472\U0001F3FE',
    u':man_with_Chinese_cap_medium-light_skin_tone:': u'\U0001F472\U0001F3FC',
    u':man_with_Chinese_cap_medium_skin_tone:': u'\U0001F472\U0001F3FD',
    u':man_zombie:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
    u':mango:': u'\U0001F96D',
    u':mantelpiece_clock:': u'\U0001F570',
    u':manual_wheelchair:': u'\U0001F9BD',
    u':man’s_shoe:': u'\U0001F45E',
    u':map_of_Japan:': u'\U0001F5FE',
    u':maple_leaf:': u'\U0001F341',
    u':martial_arts_uniform:': u'\U0001F94B',
    u':mate:': u'\U0001F9C9',
    u':meat_on_bone:': u'\U0001F356',
    u':mechanical_arm:': u'\U0001F9BE',
    u':mechanical_leg:': u'\U0001F9BF',
    u':medical_symbol:': u'\U00002695',
    u':megaphone:': u'\U0001F4E3',
    u':melon:': u'\U0001F348',
    u':memo:': u'\U0001F4DD',
    u':men_with_bunny_ears:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
    u':men_wrestling:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
    u':menorah:': u'\U0001F54E',
    u':men’s_room:': u'\U0001F6B9',
    u':mermaid:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
    u':mermaid_dark_skin_tone:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mermaid_light_skin_tone:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mermaid_medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mermaid_medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mermaid_medium_skin_tone:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':merman:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
    u':merman_dark_skin_tone:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':merman_light_skin_tone:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':merman_medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':merman_medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':merman_medium_skin_tone:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':merperson:': u'\U0001F9DC',
    u':merperson_dark_skin_tone:': u'\U0001F9DC\U0001F3FF',
    u':merperson_light_skin_tone:': u'\U0001F9DC\U0001F3FB',
    u':merperson_medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE',
    u':merperson_medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC',
    u':merperson_medium_skin_tone:': u'\U0001F9DC\U0001F3FD',
    u':metro:': u'\U0001F687',
    u':microbe:': u'\U0001F9A0',
    u':microphone:': u'\U0001F3A4',
    u':microscope:': u'\U0001F52C',
    u':middle_finger:': u'\U0001F595',
    u':middle_finger_dark_skin_tone:': u'\U0001F595\U0001F3FF',
    u':middle_finger_light_skin_tone:': u'\U0001F595\U0001F3FB',
    u':middle_finger_medium-dark_skin_tone:': u'\U0001F595\U0001F3FE',
    u':middle_finger_medium-light_skin_tone:': u'\U0001F595\U0001F3FC',
    u':middle_finger_medium_skin_tone:': u'\U0001F595\U0001F3FD',
    u':military_medal:': u'\U0001F396',
    u':milky_way:': u'\U0001F30C',
    u':minibus:': u'\U0001F690',
    u':moai:': u'\U0001F5FF',
    u':mobile_phone:': u'\U0001F4F1',
    u':mobile_phone_off:': u'\U0001F4F4',
    u':mobile_phone_with_arrow:': u'\U0001F4F2',
    u':money-mouth_face:': u'\U0001F911',
    u':money_bag:': u'\U0001F4B0',
    u':money_with_wings:': u'\U0001F4B8',
    u':monkey:': u'\U0001F412',
    u':monkey_face:': u'\U0001F435',
    u':monorail:': u'\U0001F69D',
    u':moon_cake:': u'\U0001F96E',
    u':moon_viewing_ceremony:': u'\U0001F391',
    u':mosque:': u'\U0001F54C',
    u':mosquito:': u'\U0001F99F',
    u':motor_boat:': u'\U0001F6E5',
    u':motor_scooter:': u'\U0001F6F5',
    u':motorcycle:': u'\U0001F3CD',
    u':motorized_wheelchair:': u'\U0001F9BC',
    u':motorway:': u'\U0001F6E3',
    u':mount_fuji:': u'\U0001F5FB',
    u':mountain:': u'\U000026F0',
    u':mountain_cableway:': u'\U0001F6A0',
    u':mountain_railway:': u'\U0001F69E',
    u':mouse:': u'\U0001F401',
    u':mouse_face:': u'\U0001F42D',
    u':mouth:': u'\U0001F444',
    u':movie_camera:': u'\U0001F3A5',
    u':mushroom:': u'\U0001F344',
    u':musical_keyboard:': u'\U0001F3B9',
    u':musical_note:': u'\U0001F3B5',
    u':musical_notes:': u'\U0001F3B6',
    u':musical_score:': u'\U0001F3BC',
    u':muted_speaker:': u'\U0001F507',
    u':nail_polish:': u'\U0001F485',
    u':nail_polish_dark_skin_tone:': u'\U0001F485\U0001F3FF',
    u':nail_polish_light_skin_tone:': u'\U0001F485\U0001F3FB',
    u':nail_polish_medium-dark_skin_tone:': u'\U0001F485\U0001F3FE',
    u':nail_polish_medium-light_skin_tone:': u'\U0001F485\U0001F3FC',
    u':nail_polish_medium_skin_tone:': u'\U0001F485\U0001F3FD',
    u':name_badge:': u'\U0001F4DB',
    u':national_park:': u'\U0001F3DE',
    u':nauseated_face:': u'\U0001F922',
    u':nazar_amulet:': u'\U0001F9FF',
    u':necktie:': u'\U0001F454',
    u':nerd_face:': u'\U0001F913',
    u':neutral_face:': u'\U0001F610',
    u':new_moon:': u'\U0001F311',
    u':new_moon_face:': u'\U0001F31A',
    u':newspaper:': u'\U0001F4F0',
    u':next_track_button:': u'\U000023ED',
    u':night_with_stars:': u'\U0001F303',
    u':nine-thirty:': u'\U0001F564',
    u':nine_o’clock:': u'\U0001F558',
    u':no_bicycles:': u'\U0001F6B3',
    u':no_entry:': u'\U000026D4',
    u':no_littering:': u'\U0001F6AF',
    u':no_mobile_phones:': u'\U0001F4F5',
    u':no_one_under_eighteen:': u'\U0001F51E',
    u':no_pedestrians:': u'\U0001F6B7',
    u':no_smoking:': u'\U0001F6AD',
    u':non-potable_water:': u'\U0001F6B1',
    u':nose:': u'\U0001F443',
    u':nose_dark_skin_tone:': u'\U0001F443\U0001F3FF',
    u':nose_light_skin_tone:': u'\U0001F443\U0001F3FB',
    u':nose_medium-dark_skin_tone:': u'\U0001F443\U0001F3FE',
    u':nose_medium-light_skin_tone:': u'\U0001F443\U0001F3FC',
    u':nose_medium_skin_tone:': u'\U0001F443\U0001F3FD',
    u':notebook:': u'\U0001F4D3',
    u':notebook_with_decorative_cover:': u'\U0001F4D4',
    u':nut_and_bolt:': u'\U0001F529',
    u':octopus:': u'\U0001F419',
    u':oden:': u'\U0001F362',
    u':office_building:': u'\U0001F3E2',
    u':ogre:': u'\U0001F479',
    u':oil_drum:': u'\U0001F6E2',
    u':old_key:': u'\U0001F5DD',
    u':old_man:': u'\U0001F474',
    u':old_man_dark_skin_tone:': u'\U0001F474\U0001F3FF',
    u':old_man_light_skin_tone:': u'\U0001F474\U0001F3FB',
    u':old_man_medium-dark_skin_tone:': u'\U0001F474\U0001F3FE',
    u':old_man_medium-light_skin_tone:': u'\U0001F474\U0001F3FC',
    u':old_man_medium_skin_tone:': u'\U0001F474\U0001F3FD',
    u':old_woman:': u'\U0001F475',
    u':old_woman_dark_skin_tone:': u'\U0001F475\U0001F3FF',
    u':old_woman_light_skin_tone:': u'\U0001F475\U0001F3FB',
    u':old_woman_medium-dark_skin_tone:': u'\U0001F475\U0001F3FE',
    u':old_woman_medium-light_skin_tone:': u'\U0001F475\U0001F3FC',
    u':old_woman_medium_skin_tone:': u'\U0001F475\U0001F3FD',
    u':older_adult:': u'\U0001F9D3',
    u':older_adult_dark_skin_tone:': u'\U0001F9D3\U0001F3FF',
    u':older_adult_light_skin_tone:': u'\U0001F9D3\U0001F3FB',
    u':older_adult_medium-dark_skin_tone:': u'\U0001F9D3\U0001F3FE',
    u':older_adult_medium-light_skin_tone:': u'\U0001F9D3\U0001F3FC',
    u':older_adult_medium_skin_tone:': u'\U0001F9D3\U0001F3FD',
    u':om:': u'\U0001F549',
    u':oncoming_automobile:': u'\U0001F698',
    u':oncoming_bus:': u'\U0001F68D',
    u':oncoming_fist:': u'\U0001F44A',
    u':oncoming_fist_dark_skin_tone:': u'\U0001F44A\U0001F3FF',
    u':oncoming_fist_light_skin_tone:': u'\U0001F44A\U0001F3FB',
    u':oncoming_fist_medium-dark_skin_tone:': u'\U0001F44A\U0001F3FE',
    u':oncoming_fist_medium-light_skin_tone:': u'\U0001F44A\U0001F3FC',
    u':oncoming_fist_medium_skin_tone:': u'\U0001F44A\U0001F3FD',
    u':oncoming_police_car:': u'\U0001F694',
    u':oncoming_taxi:': u'\U0001F696',
    u':one-piece_swimsuit:': u'\U0001FA71',
    u':one-thirty:': u'\U0001F55C',
    u':one_o’clock:': u'\U0001F550',
    u':onion:': u'\U0001F9C5',
    u':open_book:': u'\U0001F4D6',
    u':open_file_folder:': u'\U0001F4C2',
    u':open_hands:': u'\U0001F450',
    u':open_hands_dark_skin_tone:': u'\U0001F450\U0001F3FF',
    u':open_hands_light_skin_tone:': u'\U0001F450\U0001F3FB',
    u':open_hands_medium-dark_skin_tone:': u'\U0001F450\U0001F3FE',
    u':open_hands_medium-light_skin_tone:': u'\U0001F450\U0001F3FC',
    u':open_hands_medium_skin_tone:': u'\U0001F450\U0001F3FD',
    u':open_mailbox_with_lowered_flag:': u'\U0001F4ED',
    u':open_mailbox_with_raised_flag:': u'\U0001F4EC',
    u':optical_disk:': u'\U0001F4BF',
    u':orange_book:': u'\U0001F4D9',
    u':orange_circle:': u'\U0001F7E0',
    u':orange_heart:': u'\U0001F9E1',
    u':orange_square:': u'\U0001F7E7',
    u':orangutan:': u'\U0001F9A7',
    u':orthodox_cross:': u'\U00002626',
    u':otter:': u'\U0001F9A6',
    u':outbox_tray:': u'\U0001F4E4',
    u':owl:': u'\U0001F989',
    u':ox:': u'\U0001F402',
    u':oyster:': u'\U0001F9AA',
    u':package:': u'\U0001F4E6',
    u':page_facing_up:': u'\U0001F4C4',
    u':page_with_curl:': u'\U0001F4C3',
    u':pager:': u'\U0001F4DF',
    u':paintbrush:': u'\U0001F58C',
    u':palm_tree:': u'\U0001F334',
    u':palms_up_together:': u'\U0001F932',
    u':palms_up_together_dark_skin_tone:': u'\U0001F932\U0001F3FF',
    u':palms_up_together_light_skin_tone:': u'\U0001F932\U0001F3FB',
    u':palms_up_together_medium-dark_skin_tone:': u'\U0001F932\U0001F3FE',
    u':palms_up_together_medium-light_skin_tone:': u'\U0001F932\U0001F3FC',
    u':palms_up_together_medium_skin_tone:': u'\U0001F932\U0001F3FD',
    u':pancakes:': u'\U0001F95E',
    u':panda_face:': u'\U0001F43C',
    u':paperclip:': u'\U0001F4CE',
    u':parrot:': u'\U0001F99C',
    u':part_alternation_mark:': u'\U0000303D',
    u':party_popper:': u'\U0001F389',
    u':partying_face:': u'\U0001F973',
    u':passenger_ship:': u'\U0001F6F3',
    u':passport_control:': u'\U0001F6C2',
    u':pause_button:': u'\U000023F8',
    u':paw_prints:': u'\U0001F43E',
    u':peace_symbol:': u'\U0000262E',
    u':peach:': u'\U0001F351',
    u':peacock:': u'\U0001F99A',
    u':peanuts:': u'\U0001F95C',
    u':pear:': u'\U0001F350',
    u':pen:': u'\U0001F58A',
    u':pencil:': u'\U0000270F',
    u':penguin:': u'\U0001F427',
    u':pensive_face:': u'\U0001F614',
    u':people_holding_hands:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
    u':people_with_bunny_ears:': u'\U0001F46F',
    u':people_wrestling:': u'\U0001F93C',
    u':performing_arts:': u'\U0001F3AD',
    u':persevering_face:': u'\U0001F623',
    u':person_biking:': u'\U0001F6B4',
    u':person_biking_dark_skin_tone:': u'\U0001F6B4\U0001F3FF',
    u':person_biking_light_skin_tone:': u'\U0001F6B4\U0001F3FB',
    u':person_biking_medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE',
    u':person_biking_medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC',
    u':person_biking_medium_skin_tone:': u'\U0001F6B4\U0001F3FD',
    u':person_bouncing_ball:': u'\U000026F9',
    u':person_bouncing_ball_dark_skin_tone:': u'\U000026F9\U0001F3FF',
    u':person_bouncing_ball_light_skin_tone:': u'\U000026F9\U0001F3FB',
    u':person_bouncing_ball_medium-dark_skin_tone:': u'\U000026F9\U0001F3FE',
    u':person_bouncing_ball_medium-light_skin_tone:': u'\U000026F9\U0001F3FC',
    u':person_bouncing_ball_medium_skin_tone:': u'\U000026F9\U0001F3FD',
    u':person_bowing:': u'\U0001F647',
    u':person_bowing_dark_skin_tone:': u'\U0001F647\U0001F3FF',
    u':person_bowing_light_skin_tone:': u'\U0001F647\U0001F3FB',
    u':person_bowing_medium-dark_skin_tone:': u'\U0001F647\U0001F3FE',
    u':person_bowing_medium-light_skin_tone:': u'\U0001F647\U0001F3FC',
    u':person_bowing_medium_skin_tone:': u'\U0001F647\U0001F3FD',
    u':person_cartwheeling:': u'\U0001F938',
    u':person_cartwheeling_dark_skin_tone:': u'\U0001F938\U0001F3FF',
    u':person_cartwheeling_light_skin_tone:': u'\U0001F938\U0001F3FB',
    u':person_cartwheeling_medium-dark_skin_tone:': u'\U0001F938\U0001F3FE',
    u':person_cartwheeling_medium-light_skin_tone:': u'\U0001F938\U0001F3FC',
    u':person_cartwheeling_medium_skin_tone:': u'\U0001F938\U0001F3FD',
    u':person_climbing:': u'\U0001F9D7',
    u':person_climbing_dark_skin_tone:': u'\U0001F9D7\U0001F3FF',
    u':person_climbing_light_skin_tone:': u'\U0001F9D7\U0001F3FB',
    u':person_climbing_medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE',
    u':person_climbing_medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC',
    u':person_climbing_medium_skin_tone:': u'\U0001F9D7\U0001F3FD',
    u':person_facepalming:': u'\U0001F926',
    u':person_facepalming_dark_skin_tone:': u'\U0001F926\U0001F3FF',
    u':person_facepalming_light_skin_tone:': u'\U0001F926\U0001F3FB',
    u':person_facepalming_medium-dark_skin_tone:': u'\U0001F926\U0001F3FE',
    u':person_facepalming_medium-light_skin_tone:': u'\U0001F926\U0001F3FC',
    u':person_facepalming_medium_skin_tone:': u'\U0001F926\U0001F3FD',
    u':person_fencing:': u'\U0001F93A',
    u':person_frowning:': u'\U0001F64D',
    u':person_frowning_dark_skin_tone:': u'\U0001F64D\U0001F3FF',
    u':person_frowning_light_skin_tone:': u'\U0001F64D\U0001F3FB',
    u':person_frowning_medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE',
    u':person_frowning_medium-light_skin_tone:': u'\U0001F64D\U0001F3FC',
    u':person_frowning_medium_skin_tone:': u'\U0001F64D\U0001F3FD',
    u':person_gesturing_NO:': u'\U0001F645',
    u':person_gesturing_NO_dark_skin_tone:': u'\U0001F645\U0001F3FF',
    u':person_gesturing_NO_light_skin_tone:': u'\U0001F645\U0001F3FB',
    u':person_gesturing_NO_medium-dark_skin_tone:': u'\U0001F645\U0001F3FE',
    u':person_gesturing_NO_medium-light_skin_tone:': u'\U0001F645\U0001F3FC',
    u':person_gesturing_NO_medium_skin_tone:': u'\U0001F645\U0001F3FD',
    u':person_gesturing_OK:': u'\U0001F646',
    u':person_gesturing_OK_dark_skin_tone:': u'\U0001F646\U0001F3FF',
    u':person_gesturing_OK_light_skin_tone:': u'\U0001F646\U0001F3FB',
    u':person_gesturing_OK_medium-dark_skin_tone:': u'\U0001F646\U0001F3FE',
    u':person_gesturing_OK_medium-light_skin_tone:': u'\U0001F646\U0001F3FC',
    u':person_gesturing_OK_medium_skin_tone:': u'\U0001F646\U0001F3FD',
    u':person_getting_haircut:': u'\U0001F487',
    u':person_getting_haircut_dark_skin_tone:': u'\U0001F487\U0001F3FF',
    u':person_getting_haircut_light_skin_tone:': u'\U0001F487\U0001F3FB',
    u':person_getting_haircut_medium-dark_skin_tone:': u'\U0001F487\U0001F3FE',
    u':person_getting_haircut_medium-light_skin_tone:': u'\U0001F487\U0001F3FC',
    u':person_getting_haircut_medium_skin_tone:': u'\U0001F487\U0001F3FD',
    u':person_getting_massage:': u'\U0001F486',
    u':person_getting_massage_dark_skin_tone:': u'\U0001F486\U0001F3FF',
    u':person_getting_massage_light_skin_tone:': u'\U0001F486\U0001F3FB',
    u':person_getting_massage_medium-dark_skin_tone:': u'\U0001F486\U0001F3FE',
    u':person_getting_massage_medium-light_skin_tone:': u'\U0001F486\U0001F3FC',
    u':person_getting_massage_medium_skin_tone:': u'\U0001F486\U0001F3FD',
    u':person_golfing:': u'\U0001F3CC',
    u':person_golfing_dark_skin_tone:': u'\U0001F3CC\U0001F3FF',
    u':person_golfing_light_skin_tone:': u'\U0001F3CC\U0001F3FB',
    u':person_golfing_medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE',
    u':person_golfing_medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC',
    u':person_golfing_medium_skin_tone:': u'\U0001F3CC\U0001F3FD',
    u':person_in_bed:': u'\U0001F6CC',
    u':person_in_bed_dark_skin_tone:': u'\U0001F6CC\U0001F3FF',
    u':person_in_bed_light_skin_tone:': u'\U0001F6CC\U0001F3FB',
    u':person_in_bed_medium-dark_skin_tone:': u'\U0001F6CC\U0001F3FE',
    u':person_in_bed_medium-light_skin_tone:': u'\U0001F6CC\U0001F3FC',
    u':person_in_bed_medium_skin_tone:': u'\U0001F6CC\U0001F3FD',
    u':person_in_lotus_position:': u'\U0001F9D8',
    u':person_in_lotus_position_dark_skin_tone:': u'\U0001F9D8\U0001F3FF',
    u':person_in_lotus_position_light_skin_tone:': u'\U0001F9D8\U0001F3FB',
    u':person_in_lotus_position_medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE',
    u':person_in_lotus_position_medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC',
    u':person_in_lotus_position_medium_skin_tone:': u'\U0001F9D8\U0001F3FD',
    u':person_in_steamy_room:': u'\U0001F9D6',
    u':person_in_steamy_room_dark_skin_tone:': u'\U0001F9D6\U0001F3FF',
    u':person_in_steamy_room_light_skin_tone:': u'\U0001F9D6\U0001F3FB',
    u':person_in_steamy_room_medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE',
    u':person_in_steamy_room_medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC',
    u':person_in_steamy_room_medium_skin_tone:': u'\U0001F9D6\U0001F3FD',
    u':person_juggling:': u'\U0001F939',
    u':person_juggling_dark_skin_tone:': u'\U0001F939\U0001F3FF',
    u':person_juggling_light_skin_tone:': u'\U0001F939\U0001F3FB',
    u':person_juggling_medium-dark_skin_tone:': u'\U0001F939\U0001F3FE',
    u':person_juggling_medium-light_skin_tone:': u'\U0001F939\U0001F3FC',
    u':person_juggling_medium_skin_tone:': u'\U0001F939\U0001F3FD',
    u':person_kneeling:': u'\U0001F9CE',
    u':person_lifting_weights:': u'\U0001F3CB',
    u':person_lifting_weights_dark_skin_tone:': u'\U0001F3CB\U0001F3FF',
    u':person_lifting_weights_light_skin_tone:': u'\U0001F3CB\U0001F3FB',
    u':person_lifting_weights_medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE',
    u':person_lifting_weights_medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC',
    u':person_lifting_weights_medium_skin_tone:': u'\U0001F3CB\U0001F3FD',
    u':person_mountain_biking:': u'\U0001F6B5',
    u':person_mountain_biking_dark_skin_tone:': u'\U0001F6B5\U0001F3FF',
    u':person_mountain_biking_light_skin_tone:': u'\U0001F6B5\U0001F3FB',
    u':person_mountain_biking_medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE',
    u':person_mountain_biking_medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC',
    u':person_mountain_biking_medium_skin_tone:': u'\U0001F6B5\U0001F3FD',
    u':person_playing_handball:': u'\U0001F93E',
    u':person_playing_handball_dark_skin_tone:': u'\U0001F93E\U0001F3FF',
    u':person_playing_handball_light_skin_tone:': u'\U0001F93E\U0001F3FB',
    u':person_playing_handball_medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE',
    u':person_playing_handball_medium-light_skin_tone:': u'\U0001F93E\U0001F3FC',
    u':person_playing_handball_medium_skin_tone:': u'\U0001F93E\U0001F3FD',
    u':person_playing_water_polo:': u'\U0001F93D',
    u':person_playing_water_polo_dark_skin_tone:': u'\U0001F93D\U0001F3FF',
    u':person_playing_water_polo_light_skin_tone:': u'\U0001F93D\U0001F3FB',
    u':person_playing_water_polo_medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE',
    u':person_playing_water_polo_medium-light_skin_tone:': u'\U0001F93D\U0001F3FC',
    u':person_playing_water_polo_medium_skin_tone:': u'\U0001F93D\U0001F3FD',
    u':person_pouting:': u'\U0001F64E',
    u':person_pouting_dark_skin_tone:': u'\U0001F64E\U0001F3FF',
    u':person_pouting_light_skin_tone:': u'\U0001F64E\U0001F3FB',
    u':person_pouting_medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE',
    u':person_pouting_medium-light_skin_tone:': u'\U0001F64E\U0001F3FC',
    u':person_pouting_medium_skin_tone:': u'\U0001F64E\U0001F3FD',
    u':person_raising_hand:': u'\U0001F64B',
    u':person_raising_hand_dark_skin_tone:': u'\U0001F64B\U0001F3FF',
    u':person_raising_hand_light_skin_tone:': u'\U0001F64B\U0001F3FB',
    u':person_raising_hand_medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE',
    u':person_raising_hand_medium-light_skin_tone:': u'\U0001F64B\U0001F3FC',
    u':person_raising_hand_medium_skin_tone:': u'\U0001F64B\U0001F3FD',
    u':person_rowing_boat:': u'\U0001F6A3',
    u':person_rowing_boat_dark_skin_tone:': u'\U0001F6A3\U0001F3FF',
    u':person_rowing_boat_light_skin_tone:': u'\U0001F6A3\U0001F3FB',
    u':person_rowing_boat_medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE',
    u':person_rowing_boat_medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC',
    u':person_rowing_boat_medium_skin_tone:': u'\U0001F6A3\U0001F3FD',
    u':person_running:': u'\U0001F3C3',
    u':person_running_dark_skin_tone:': u'\U0001F3C3\U0001F3FF',
    u':person_running_light_skin_tone:': u'\U0001F3C3\U0001F3FB',
    u':person_running_medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE',
    u':person_running_medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC',
    u':person_running_medium_skin_tone:': u'\U0001F3C3\U0001F3FD',
    u':person_shrugging:': u'\U0001F937',
    u':person_shrugging_dark_skin_tone:': u'\U0001F937\U0001F3FF',
    u':person_shrugging_light_skin_tone:': u'\U0001F937\U0001F3FB',
    u':person_shrugging_medium-dark_skin_tone:': u'\U0001F937\U0001F3FE',
    u':person_shrugging_medium-light_skin_tone:': u'\U0001F937\U0001F3FC',
    u':person_shrugging_medium_skin_tone:': u'\U0001F937\U0001F3FD',
    u':person_standing:': u'\U0001F9CD',
    u':person_surfing:': u'\U0001F3C4',
    u':person_surfing_dark_skin_tone:': u'\U0001F3C4\U0001F3FF',
    u':person_surfing_light_skin_tone:': u'\U0001F3C4\U0001F3FB',
    u':person_surfing_medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE',
    u':person_surfing_medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC',
    u':person_surfing_medium_skin_tone:': u'\U0001F3C4\U0001F3FD',
    u':person_swimming:': u'\U0001F3CA',
    u':person_swimming_dark_skin_tone:': u'\U0001F3CA\U0001F3FF',
    u':person_swimming_light_skin_tone:': u'\U0001F3CA\U0001F3FB',
    u':person_swimming_medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE',
    u':person_swimming_medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC',
    u':person_swimming_medium_skin_tone:': u'\U0001F3CA\U0001F3FD',
    u':person_taking_bath:': u'\U0001F6C0',
    u':person_taking_bath_dark_skin_tone:': u'\U0001F6C0\U0001F3FF',
    u':person_taking_bath_light_skin_tone:': u'\U0001F6C0\U0001F3FB',
    u':person_taking_bath_medium-dark_skin_tone:': u'\U0001F6C0\U0001F3FE',
    u':person_taking_bath_medium-light_skin_tone:': u'\U0001F6C0\U0001F3FC',
    u':person_taking_bath_medium_skin_tone:': u'\U0001F6C0\U0001F3FD',
    u':person_tipping_hand:': u'\U0001F481',
    u':person_tipping_hand_dark_skin_tone:': u'\U0001F481\U0001F3FF',
    u':person_tipping_hand_light_skin_tone:': u'\U0001F481\U0001F3FB',
    u':person_tipping_hand_medium-dark_skin_tone:': u'\U0001F481\U0001F3FE',
    u':person_tipping_hand_medium-light_skin_tone:': u'\U0001F481\U0001F3FC',
    u':person_tipping_hand_medium_skin_tone:': u'\U0001F481\U0001F3FD',
    u':person_walking:': u'\U0001F6B6',
    u':person_walking_dark_skin_tone:': u'\U0001F6B6\U0001F3FF',
    u':person_walking_light_skin_tone:': u'\U0001F6B6\U0001F3FB',
    u':person_walking_medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE',
    u':person_walking_medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC',
    u':person_walking_medium_skin_tone:': u'\U0001F6B6\U0001F3FD',
    u':person_wearing_turban:': u'\U0001F473',
    u':person_wearing_turban_dark_skin_tone:': u'\U0001F473\U0001F3FF',
    u':person_wearing_turban_light_skin_tone:': u'\U0001F473\U0001F3FB',
    u':person_wearing_turban_medium-dark_skin_tone:': u'\U0001F473\U0001F3FE',
    u':person_wearing_turban_medium-light_skin_tone:': u'\U0001F473\U0001F3FC',
    u':person_wearing_turban_medium_skin_tone:': u'\U0001F473\U0001F3FD',
    u':petri_dish:': u'\U0001F9EB',
    u':pick:': u'\U000026CF',
    u':pie:': u'\U0001F967',
    u':pig:': u'\U0001F416',
    u':pig_face:': u'\U0001F437',
    u':pig_nose:': u'\U0001F43D',
    u':pile_of_poo:': u'\U0001F4A9',
    u':pill:': u'\U0001F48A',
    u':pinching_hand:': u'\U0001F90F',
    u':pine_decoration:': u'\U0001F38D',
    u':pineapple:': u'\U0001F34D',
    u':ping_pong:': u'\U0001F3D3',
    u':pirate_flag:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
    u':pistol:': u'\U0001F52B',
    u':pizza:': u'\U0001F355',
    u':place_of_worship:': u'\U0001F6D0',
    u':play_button:': u'\U000025B6',
    u':play_or_pause_button:': u'\U000023EF',
    u':pleading_face:': u'\U0001F97A',
    u':police_car:': u'\U0001F693',
    u':police_car_light:': u'\U0001F6A8',
    u':police_officer:': u'\U0001F46E',
    u':police_officer_dark_skin_tone:': u'\U0001F46E\U0001F3FF',
    u':police_officer_light_skin_tone:': u'\U0001F46E\U0001F3FB',
    u':police_officer_medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE',
    u':police_officer_medium-light_skin_tone:': u'\U0001F46E\U0001F3FC',
    u':police_officer_medium_skin_tone:': u'\U0001F46E\U0001F3FD',
    u':poodle:': u'\U0001F429',
    u':pool_8_ball:': u'\U0001F3B1',
    u':popcorn:': u'\U0001F37F',
    u':post_office:': u'\U0001F3E4',
    u':postal_horn:': u'\U0001F4EF',
    u':postbox:': u'\U0001F4EE',
    u':pot_of_food:': u'\U0001F372',
    u':potable_water:': u'\U0001F6B0',
    u':potato:': u'\U0001F954',
    u':poultry_leg:': u'\U0001F357',
    u':pound_banknote:': u'\U0001F4B7',
    u':pouting_cat_face:': u'\U0001F63E',
    u':pouting_face:': u'\U0001F621',
    u':prayer_beads:': u'\U0001F4FF',
    u':pregnant_woman:': u'\U0001F930',
    u':pregnant_woman_dark_skin_tone:': u'\U0001F930\U0001F3FF',
    u':pregnant_woman_light_skin_tone:': u'\U0001F930\U0001F3FB',
    u':pregnant_woman_medium-dark_skin_tone:': u'\U0001F930\U0001F3FE',
    u':pregnant_woman_medium-light_skin_tone:': u'\U0001F930\U0001F3FC',
    u':pregnant_woman_medium_skin_tone:': u'\U0001F930\U0001F3FD',
    u':pretzel:': u'\U0001F968',
    u':probing_cane:': u'\U0001F9AF',
    u':prince:': u'\U0001F934',
    u':prince_dark_skin_tone:': u'\U0001F934\U0001F3FF',
    u':prince_light_skin_tone:': u'\U0001F934\U0001F3FB',
    u':prince_medium-dark_skin_tone:': u'\U0001F934\U0001F3FE',
    u':prince_medium-light_skin_tone:': u'\U0001F934\U0001F3FC',
    u':prince_medium_skin_tone:': u'\U0001F934\U0001F3FD',
    u':princess:': u'\U0001F478',
    u':princess_dark_skin_tone:': u'\U0001F478\U0001F3FF',
    u':princess_light_skin_tone:': u'\U0001F478\U0001F3FB',
    u':princess_medium-dark_skin_tone:': u'\U0001F478\U0001F3FE',
    u':princess_medium-light_skin_tone:': u'\U0001F478\U0001F3FC',
    u':princess_medium_skin_tone:': u'\U0001F478\U0001F3FD',
    u':printer:': u'\U0001F5A8',
    u':prohibited:': u'\U0001F6AB',
    u':purple_circle:': u'\U0001F7E3',
    u':purple_heart:': u'\U0001F49C',
    u':purple_square:': u'\U0001F7EA',
    u':purse:': u'\U0001F45B',
    u':pushpin:': u'\U0001F4CC',
    u':question_mark:': u'\U00002753',
    u':rabbit:': u'\U0001F407',
    u':rabbit_face:': u'\U0001F430',
    u':raccoon:': u'\U0001F99D',
    u':racing_car:': u'\U0001F3CE',
    u':radio:': u'\U0001F4FB',
    u':radio_button:': u'\U0001F518',
    u':radioactive:': u'\U00002622',
    u':railway_car:': u'\U0001F683',
    u':railway_track:': u'\U0001F6E4',
    u':rainbow:': u'\U0001F308',
    u':rainbow_flag:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
    u':raised_back_of_hand:': u'\U0001F91A',
    u':raised_back_of_hand_dark_skin_tone:': u'\U0001F91A\U0001F3FF',
    u':raised_back_of_hand_light_skin_tone:': u'\U0001F91A\U0001F3FB',
    u':raised_back_of_hand_medium-dark_skin_tone:': u'\U0001F91A\U0001F3FE',
    u':raised_back_of_hand_medium-light_skin_tone:': u'\U0001F91A\U0001F3FC',
    u':raised_back_of_hand_medium_skin_tone:': u'\U0001F91A\U0001F3FD',
    u':raised_fist:': u'\U0000270A',
    u':raised_fist_dark_skin_tone:': u'\U0000270A\U0001F3FF',
    u':raised_fist_light_skin_tone:': u'\U0000270A\U0001F3FB',
    u':raised_fist_medium-dark_skin_tone:': u'\U0000270A\U0001F3FE',
    u':raised_fist_medium-light_skin_tone:': u'\U0000270A\U0001F3FC',
    u':raised_fist_medium_skin_tone:': u'\U0000270A\U0001F3FD',
    u':raised_hand:': u'\U0000270B',
    u':raised_hand_dark_skin_tone:': u'\U0000270B\U0001F3FF',
    u':raised_hand_light_skin_tone:': u'\U0000270B\U0001F3FB',
    u':raised_hand_medium-dark_skin_tone:': u'\U0000270B\U0001F3FE',
    u':raised_hand_medium-light_skin_tone:': u'\U0000270B\U0001F3FC',
    u':raised_hand_medium_skin_tone:': u'\U0000270B\U0001F3FD',
    u':raising_hands:': u'\U0001F64C',
    u':raising_hands_dark_skin_tone:': u'\U0001F64C\U0001F3FF',
    u':raising_hands_light_skin_tone:': u'\U0001F64C\U0001F3FB',
    u':raising_hands_medium-dark_skin_tone:': u'\U0001F64C\U0001F3FE',
    u':raising_hands_medium-light_skin_tone:': u'\U0001F64C\U0001F3FC',
    u':raising_hands_medium_skin_tone:': u'\U0001F64C\U0001F3FD',
    u':ram:': u'\U0001F40F',
    u':rat:': u'\U0001F400',
    u':razor:': u'\U0001FA92',
    u':ringed_planet:': u'\U0001FA90',
    u':receipt:': u'\U0001F9FE',
    u':record_button:': u'\U000023FA',
    u':recycling_symbol:': u'\U0000267B',
    u':red_apple:': u'\U0001F34E',
    u':red_circle:': u'\U0001F534',
    u':red_envelope:': u'\U0001F9E7',
    u':red_hair:': u'\U0001F9B0',
    u':red-haired_man:': u'\U0001F468\U0000200D\U0001F9B0',
    u':red-haired_woman:': u'\U0001F469\U0000200D\U0001F9B0',
    u':red_heart:': u'\U00002764',
    u':red_paper_lantern:': u'\U0001F3EE',
    u':red_square:': u'\U0001F7E5',
    u':red_triangle_pointed_down:': u'\U0001F53B',
    u':red_triangle_pointed_up:': u'\U0001F53A',
    u':registered:': u'\U000000AE',
    u':relieved_face:': u'\U0001F60C',
    u':reminder_ribbon:': u'\U0001F397',
    u':repeat_button:': u'\U0001F501',
    u':repeat_single_button:': u'\U0001F502',
    u':rescue_worker’s_helmet:': u'\U000026D1',
    u':restroom:': u'\U0001F6BB',
    u':reverse_button:': u'\U000025C0',
    u':revolving_hearts:': u'\U0001F49E',
    u':rhinoceros:': u'\U0001F98F',
    u':ribbon:': u'\U0001F380',
    u':rice_ball:': u'\U0001F359',
    u':rice_cracker:': u'\U0001F358',
    u':right-facing_fist:': u'\U0001F91C',
    u':right-facing_fist_dark_skin_tone:': u'\U0001F91C\U0001F3FF',
    u':right-facing_fist_light_skin_tone:': u'\U0001F91C\U0001F3FB',
    u':right-facing_fist_medium-dark_skin_tone:': u'\U0001F91C\U0001F3FE',
    u':right-facing_fist_medium-light_skin_tone:': u'\U0001F91C\U0001F3FC',
    u':right-facing_fist_medium_skin_tone:': u'\U0001F91C\U0001F3FD',
    u':right_anger_bubble:': u'\U0001F5EF',
    u':right_arrow:': u'\U000027A1',
    u':right_arrow_curving_down:': u'\U00002935',
    u':right_arrow_curving_left:': u'\U000021A9',
    u':right_arrow_curving_up:': u'\U00002934',
    u':ring:': u'\U0001F48D',
    u':roasted_sweet_potato:': u'\U0001F360',
    u':robot_face:': u'\U0001F916',
    u':rocket:': u'\U0001F680',
    u':roll_of_paper:': u'\U0001F9FB',
    u':rolled-up_newspaper:': u'\U0001F5DE',
    u':roller_coaster:': u'\U0001F3A2',
    u':rolling_on_the_floor_laughing:': u'\U0001F923',
    u':rooster:': u'\U0001F413',
    u':rose:': u'\U0001F339',
    u':rosette:': u'\U0001F3F5',
    u':round_pushpin:': u'\U0001F4CD',
    u':rugby_football:': u'\U0001F3C9',
    u':running_shirt:': u'\U0001F3BD',
    u':running_shoe:': u'\U0001F45F',
    u':sad_but_relieved_face:': u'\U0001F625',
    u':safety_pin:': u'\U0001F9F7',
    u':safety_vest:': u'\U0001F9BA',
    u':salt:': u'\U0001F9C2',
    u':sailboat:': u'\U000026F5',
    u':sake:': u'\U0001F376',
    u':sandwich:': u'\U0001F96A',
    u':sari:': u'\U0001F97B',
    u':satellite:': u'\U0001F6F0',
    u':satellite_antenna:': u'\U0001F4E1',
    u':sauropod:': u'\U0001F995',
    u':saxophone:': u'\U0001F3B7',
    u':scarf:': u'\U0001F9E3',
    u':school:': u'\U0001F3EB',
    u':school_backpack:': u'\U0001F392',
    u':scissors:': u'\U00002702',
    u':scorpion:': u'\U0001F982',
    u':scroll:': u'\U0001F4DC',
    u':seat:': u'\U0001F4BA',
    u':see-no-evil_monkey:': u'\U0001F648',
    u':seedling:': u'\U0001F331',
    u':selfie:': u'\U0001F933',
    u':selfie_dark_skin_tone:': u'\U0001F933\U0001F3FF',
    u':selfie_light_skin_tone:': u'\U0001F933\U0001F3FB',
    u':selfie_medium-dark_skin_tone:': u'\U0001F933\U0001F3FE',
    u':selfie_medium-light_skin_tone:': u'\U0001F933\U0001F3FC',
    u':selfie_medium_skin_tone:': u'\U0001F933\U0001F3FD',
    u':service_dog:': u'\U0001F415\U0000200D\U0001F9BA',
    u':seven-thirty:': u'\U0001F562',
    u':seven_o’clock:': u'\U0001F556',
    u':shallow_pan_of_food:': u'\U0001F958',
    u':shamrock:': u'\U00002618',
    u':shark:': u'\U0001F988',
    u':shaved_ice:': u'\U0001F367',
    u':sheaf_of_rice:': u'\U0001F33E',
    u':shield:': u'\U0001F6E1',
    u':shinto_shrine:': u'\U000026E9',
    u':ship:': u'\U0001F6A2',
    u':shooting_star:': u'\U0001F320',
    u':shopping_bags:': u'\U0001F6CD',
    u':shopping_cart:': u'\U0001F6D2',
    u':shortcake:': u'\U0001F370',
    u':shorts:': u'\U0001FA73',
    u':shower:': u'\U0001F6BF',
    u':shrimp:': u'\U0001F990',
    u':shuffle_tracks_button:': u'\U0001F500',
    u':shushing_face:': u'\U0001F92B',
    u':sign_of_the_horns:': u'\U0001F918',
    u':sign_of_the_horns_dark_skin_tone:': u'\U0001F918\U0001F3FF',
    u':sign_of_the_horns_light_skin_tone:': u'\U0001F918\U0001F3FB',
    u':sign_of_the_horns_medium-dark_skin_tone:': u'\U0001F918\U0001F3FE',
    u':sign_of_the_horns_medium-light_skin_tone:': u'\U0001F918\U0001F3FC',
    u':sign_of_the_horns_medium_skin_tone:': u'\U0001F918\U0001F3FD',
    u':six-thirty:': u'\U0001F561',
    u':six_o’clock:': u'\U0001F555',
    u':skateboard:': u'\U0001F6F9',
    u':skier:': u'\U000026F7',
    u':skis:': u'\U0001F3BF',
    u':skull:': u'\U0001F480',
    u':skull_and_crossbones:': u'\U00002620',
    u':skunk:': u'\U0001F9A8',
    u':sled:': u'\U0001F6F7',
    u':sleeping_face:': u'\U0001F634',
    u':sleepy_face:': u'\U0001F62A',
    u':slightly_frowning_face:': u'\U0001F641',
    u':slightly_smiling_face:': u'\U0001F642',
    u':slot_machine:': u'\U0001F3B0',
    u':sloth:': u'\U0001F9A5',
    u':small_airplane:': u'\U0001F6E9',
    u':small_blue_diamond:': u'\U0001F539',
    u':small_orange_diamond:': u'\U0001F538',
    u':smiling_cat_face_with_heart-eyes:': u'\U0001F63B',
    u':smiling_face:': u'\U0000263A',
    u':smiling_face_with_halo:': u'\U0001F607',
    u':smiling_face_with_3_hearts:': u'\U0001F970',
    u':smiling_face_with_heart-eyes:': u'\U0001F60D',
    u':smiling_face_with_horns:': u'\U0001F608',
    u':smiling_face_with_smiling_eyes:': u'\U0001F60A',
    u':smiling_face_with_sunglasses:': u'\U0001F60E',
    u':smirking_face:': u'\U0001F60F',
    u':snail:': u'\U0001F40C',
    u':snake:': u'\U0001F40D',
    u':sneezing_face:': u'\U0001F927',
    u':snow-capped_mountain:': u'\U0001F3D4',
    u':snowboarder:': u'\U0001F3C2',
    u':snowboarder_dark_skin_tone:': u'\U0001F3C2\U0001F3FF',
    u':snowboarder_light_skin_tone:': u'\U0001F3C2\U0001F3FB',
    u':snowboarder_medium-dark_skin_tone:': u'\U0001F3C2\U0001F3FE',
    u':snowboarder_medium-light_skin_tone:': u'\U0001F3C2\U0001F3FC',
    u':snowboarder_medium_skin_tone:': u'\U0001F3C2\U0001F3FD',
    u':snowflake:': u'\U00002744',
    u':snowman:': u'\U00002603',
    u':snowman_without_snow:': u'\U000026C4',
    u':soap:': u'\U0001F9FC',
    u':soccer_ball:': u'\U000026BD',
    u':socks:': u'\U0001F9E6',
    u':softball:': u'\U0001F94E',
    u':soft_ice_cream:': u'\U0001F366',
    u':spade_suit:': u'\U00002660',
    u':spaghetti:': u'\U0001F35D',
    u':sparkle:': u'\U00002747',
    u':sparkler:': u'\U0001F387',
    u':sparkles:': u'\U00002728',
    u':sparkling_heart:': u'\U0001F496',
    u':speak-no-evil_monkey:': u'\U0001F64A',
    u':speaker_high_volume:': u'\U0001F50A',
    u':speaker_low_volume:': u'\U0001F508',
    u':speaker_medium_volume:': u'\U0001F509',
    u':speaking_head:': u'\U0001F5E3',
    u':speech_balloon:': u'\U0001F4AC',
    u':speedboat:': u'\U0001F6A4',
    u':spider:': u'\U0001F577',
    u':spider_web:': u'\U0001F578',
    u':spiral_calendar:': u'\U0001F5D3',
    u':spiral_notepad:': u'\U0001F5D2',
    u':spiral_shell:': u'\U0001F41A',
    u':spoon:': u'\U0001F944',
    u':sponge:': u'\U0001F9FD',
    u':sport_utility_vehicle:': u'\U0001F699',
    u':sports_medal:': u'\U0001F3C5',
    u':spouting_whale:': u'\U0001F433',
    u':squid:': u'\U0001F991',
    u':squinting_face_with_tongue:': u'\U0001F61D',
    u':stadium:': u'\U0001F3DF',
    u':star-struck:': u'\U0001F929',
    u':star_and_crescent:': u'\U0000262A',
    u':star_of_David:': u'\U00002721',
    u':station:': u'\U0001F689',
    u':steaming_bowl:': u'\U0001F35C',
    u':stethoscope:': u'\U0001FA7A',
    u':stop_button:': u'\U000023F9',
    u':stop_sign:': u'\U0001F6D1',
    u':stopwatch:': u'\U000023F1',
    u':straight_ruler:': u'\U0001F4CF',
    u':strawberry:': u'\U0001F353',
    u':studio_microphone:': u'\U0001F399',
    u':stuffed_flatbread:': u'\U0001F959',
    u':sun:': u'\U00002600',
    u':sun_behind_cloud:': u'\U000026C5',
    u':sun_behind_large_cloud:': u'\U0001F325',
    u':sun_behind_rain_cloud:': u'\U0001F326',
    u':sun_behind_small_cloud:': u'\U0001F324',
    u':sun_with_face:': u'\U0001F31E',
    u':sunflower:': u'\U0001F33B',
    u':sunglasses:': u'\U0001F576',
    u':sunrise:': u'\U0001F305',
    u':sunrise_over_mountains:': u'\U0001F304',
    u':sunset:': u'\U0001F307',
    u':superhero:': u'\U0001F9B8',
    u':supervillain:': u'\U0001F9B9',
    u':sushi:': u'\U0001F363',
    u':suspension_railway:': u'\U0001F69F',
    u':swan:': u'\U0001F9A2',
    u':sweat_droplets:': u'\U0001F4A6',
    u':synagogue:': u'\U0001F54D',
    u':syringe:': u'\U0001F489',
    u':t-shirt:': u'\U0001F455',
    u':taco:': u'\U0001F32E',
    u':takeout_box:': u'\U0001F961',
    u':tanabata_tree:': u'\U0001F38B',
    u':tangerine:': u'\U0001F34A',
    u':taxi:': u'\U0001F695',
    u':teacup_without_handle:': u'\U0001F375',
    u':tear-off_calendar:': u'\U0001F4C6',
    u':teddy_bear:': u'\U0001F9F8',
    u':telephone:': u'\U0000260E',
    u':telephone_receiver:': u'\U0001F4DE',
    u':telescope:': u'\U0001F52D',
    u':television:': u'\U0001F4FA',
    u':ten-thirty:': u'\U0001F565',
    u':ten_o’clock:': u'\U0001F559',
    u':tennis:': u'\U0001F3BE',
    u':tent:': u'\U000026FA',
    u':test_tube:': u'\U0001F9EA',
    u':thermometer:': u'\U0001F321',
    u':thinking_face:': u'\U0001F914',
    u':thought_balloon:': u'\U0001F4AD',
    u':thread:': u'\U0001F9F5',
    u':three-thirty:': u'\U0001F55E',
    u':three_o’clock:': u'\U0001F552',
    u':thumbs_down:': u'\U0001F44E',
    u':thumbs_down_dark_skin_tone:': u'\U0001F44E\U0001F3FF',
    u':thumbs_down_light_skin_tone:': u'\U0001F44E\U0001F3FB',
    u':thumbs_down_medium-dark_skin_tone:': u'\U0001F44E\U0001F3FE',
    u':thumbs_down_medium-light_skin_tone:': u'\U0001F44E\U0001F3FC',
    u':thumbs_down_medium_skin_tone:': u'\U0001F44E\U0001F3FD',
    u':thumbs_up:': u'\U0001F44D',
    u':thumbs_up_dark_skin_tone:': u'\U0001F44D\U0001F3FF',
    u':thumbs_up_light_skin_tone:': u'\U0001F44D\U0001F3FB',
    u':thumbs_up_medium-dark_skin_tone:': u'\U0001F44D\U0001F3FE',
    u':thumbs_up_medium-light_skin_tone:': u'\U0001F44D\U0001F3FC',
    u':thumbs_up_medium_skin_tone:': u'\U0001F44D\U0001F3FD',
    u':ticket:': u'\U0001F3AB',
    u':tiger:': u'\U0001F405',
    u':tiger_face:': u'\U0001F42F',
    u':timer_clock:': u'\U000023F2',
    u':tired_face:': u'\U0001F62B',
    u':toolbox:': u'\U0001F9F0',
    u':toilet:': u'\U0001F6BD',
    u':tomato:': u'\U0001F345',
    u':tongue:': u'\U0001F445',
    u':tooth:': u'\U0001F9B7',
    u':top_hat:': u'\U0001F3A9',
    u':tornado:': u'\U0001F32A',
    u':trackball:': u'\U0001F5B2',
    u':tractor:': u'\U0001F69C',
    u':trade_mark:': u'\U00002122',
    u':train:': u'\U0001F686',
    u':tram:': u'\U0001F68A',
    u':tram_car:': u'\U0001F68B',
    u':triangular_flag:': u'\U0001F6A9',
    u':triangular_ruler:': u'\U0001F4D0',
    u':trident_emblem:': u'\U0001F531',
    u':trolleybus:': u'\U0001F68E',
    u':trophy:': u'\U0001F3C6',
    u':tropical_drink:': u'\U0001F379',
    u':tropical_fish:': u'\U0001F420',
    u':trumpet:': u'\U0001F3BA',
    u':tulip:': u'\U0001F337',
    u':tumbler_glass:': u'\U0001F943',
    u':turkey:': u'\U0001F983',
    u':turtle:': u'\U0001F422',
    u':twelve-thirty:': u'\U0001F567',
    u':twelve_o’clock:': u'\U0001F55B',
    u':two-hump_camel:': u'\U0001F42B',
    u':two-thirty:': u'\U0001F55D',
    u':two_hearts:': u'\U0001F495',
    u':two_men_holding_hands:': u'\U0001F46C',
    u':two_o’clock:': u'\U0001F551',
    u':two_women_holding_hands:': u'\U0001F46D',
    u':umbrella:': u'\U00002602',
    u':umbrella_on_ground:': u'\U000026F1',
    u':umbrella_with_rain_drops:': u'\U00002614',
    u':unamused_face:': u'\U0001F612',
    u':unicorn_face:': u'\U0001F984',
    u':unlocked:': u'\U0001F513',
    u':up-down_arrow:': u'\U00002195',
    u':up-left_arrow:': u'\U00002196',
    u':up-right_arrow:': u'\U00002197',
    u':up_arrow:': u'\U00002B06',
    u':upside-down_face:': u'\U0001F643',
    u':upwards_button:': u'\U0001F53C',
    u':vampire:': u'\U0001F9DB',
    u':vampire_dark_skin_tone:': u'\U0001F9DB\U0001F3FF',
    u':vampire_light_skin_tone:': u'\U0001F9DB\U0001F3FB',
    u':vampire_medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE',
    u':vampire_medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC',
    u':vampire_medium_skin_tone:': u'\U0001F9DB\U0001F3FD',
    u':vertical_traffic_light:': u'\U0001F6A6',
    u':vibration_mode:': u'\U0001F4F3',
    u':victory_hand:': u'\U0000270C',
    u':victory_hand_dark_skin_tone:': u'\U0000270C\U0001F3FF',
    u':victory_hand_light_skin_tone:': u'\U0000270C\U0001F3FB',
    u':victory_hand_medium-dark_skin_tone:': u'\U0000270C\U0001F3FE',
    u':victory_hand_medium-light_skin_tone:': u'\U0000270C\U0001F3FC',
    u':victory_hand_medium_skin_tone:': u'\U0000270C\U0001F3FD',
    u':video_camera:': u'\U0001F4F9',
    u':video_game:': u'\U0001F3AE',
    u':videocassette:': u'\U0001F4FC',
    u':violin:': u'\U0001F3BB',
    u':volcano:': u'\U0001F30B',
    u':volleyball:': u'\U0001F3D0',
    u':vulcan_salute:': u'\U0001F596',
    u':vulcan_salute_dark_skin_tone:': u'\U0001F596\U0001F3FF',
    u':vulcan_salute_light_skin_tone:': u'\U0001F596\U0001F3FB',
    u':vulcan_salute_medium-dark_skin_tone:': u'\U0001F596\U0001F3FE',
    u':vulcan_salute_medium-light_skin_tone:': u'\U0001F596\U0001F3FC',
    u':vulcan_salute_medium_skin_tone:': u'\U0001F596\U0001F3FD',
    u':waffle:': u'\U0001F9C7',
    u':waning_crescent_moon:': u'\U0001F318',
    u':waning_gibbous_moon:': u'\U0001F316',
    u':warning:': u'\U000026A0',
    u':wastebasket:': u'\U0001F5D1',
    u':watch:': u'\U0000231A',
    u':water_buffalo:': u'\U0001F403',
    u':water_closet:': u'\U0001F6BE',
    u':water_wave:': u'\U0001F30A',
    u':watermelon:': u'\U0001F349',
    u':waving_hand:': u'\U0001F44B',
    u':waving_hand_dark_skin_tone:': u'\U0001F44B\U0001F3FF',
    u':waving_hand_light_skin_tone:': u'\U0001F44B\U0001F3FB',
    u':waving_hand_medium-dark_skin_tone:': u'\U0001F44B\U0001F3FE',
    u':waving_hand_medium-light_skin_tone:': u'\U0001F44B\U0001F3FC',
    u':waving_hand_medium_skin_tone:': u'\U0001F44B\U0001F3FD',
    u':wavy_dash:': u'\U00003030',
    u':waxing_crescent_moon:': u'\U0001F312',
    u':waxing_gibbous_moon:': u'\U0001F314',
    u':weary_cat_face:': u'\U0001F640',
    u':weary_face:': u'\U0001F629',
    u':wedding:': u'\U0001F492',
    u':whale:': u'\U0001F40B',
    u':wheel_of_dharma:': u'\U00002638',
    u':wheelchair_symbol:': u'\U0000267F',
    u':white_circle:': u'\U000026AA',
    u':white_exclamation_mark:': u'\U00002755',
    u':white_flag:': u'\U0001F3F3',
    u':white_flower:': u'\U0001F4AE',
    u':white_hair:': u'\U0001F9B3',
    u':white-haired_man:': u'\U0001F468\U0000200D\U0001F9B3',
    u':white-haired_woman:': u'\U0001F469\U0000200D\U0001F9B3',
    u':white_heart:': u'\U0001F90D',
    u':white_heavy_check_mark:': u'\U00002705',
    u':white_large_square:': u'\U00002B1C',
    u':white_medium-small_square:': u'\U000025FD',
    u':white_medium_square:': u'\U000025FB',
    u':white_medium_star:': u'\U00002B50',
    u':white_question_mark:': u'\U00002754',
    u':white_small_square:': u'\U000025AB',
    u':white_square_button:': u'\U0001F533',
    u':wilted_flower:': u'\U0001F940',
    u':wind_chime:': u'\U0001F390',
    u':wind_face:': u'\U0001F32C',
    u':wine_glass:': u'\U0001F377',
    u':winking_face:': u'\U0001F609',
    u':winking_face_with_tongue:': u'\U0001F61C',
    u':wolf_face:': u'\U0001F43A',
    u':woman:': u'\U0001F469',
    u':woman_artist:': u'\U0001F469\U0000200D\U0001F3A8',
    u':woman_artist_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
    u':woman_artist_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
    u':woman_artist_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
    u':woman_artist_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
    u':woman_artist_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
    u':woman_astronaut:': u'\U0001F469\U0000200D\U0001F680',
    u':woman_astronaut_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
    u':woman_astronaut_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
    u':woman_astronaut_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
    u':woman_astronaut_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
    u':woman_astronaut_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
    u':woman_biking:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_dark_skin_tone:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_light_skin_tone:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_medium_skin_tone:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_dark_skin_tone:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_light_skin_tone:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_medium-dark_skin_tone:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_medium-light_skin_tone:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_medium_skin_tone:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_dark_skin_tone:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_light_skin_tone:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_medium-dark_skin_tone:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_medium-light_skin_tone:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_medium_skin_tone:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_dark_skin_tone:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_light_skin_tone:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_medium-dark_skin_tone:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_medium-light_skin_tone:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_medium_skin_tone:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_dark_skin_tone:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_light_skin_tone:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_medium_skin_tone:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_dark_skin_tone:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_light_skin_tone:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_medium-dark_skin_tone:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_medium-light_skin_tone:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_medium_skin_tone:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_cook:': u'\U0001F469\U0000200D\U0001F373',
    u':woman_cook_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
    u':woman_cook_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
    u':woman_cook_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
    u':woman_cook_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
    u':woman_cook_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
    u':woman_dancing:': u'\U0001F483',
    u':woman_dancing_dark_skin_tone:': u'\U0001F483\U0001F3FF',
    u':woman_dancing_light_skin_tone:': u'\U0001F483\U0001F3FB',
    u':woman_dancing_medium-dark_skin_tone:': u'\U0001F483\U0001F3FE',
    u':woman_dancing_medium-light_skin_tone:': u'\U0001F483\U0001F3FC',
    u':woman_dancing_medium_skin_tone:': u'\U0001F483\U0001F3FD',
    u':woman_dark_skin_tone:': u'\U0001F469\U0001F3FF',
    u':woman_detective:': u'\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_dark_skin_tone:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_light_skin_tone:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_medium-dark_skin_tone:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_medium-light_skin_tone:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_medium_skin_tone:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_elf:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_dark_skin_tone:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_light_skin_tone:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_medium_skin_tone:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_dark_skin_tone:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_light_skin_tone:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_medium-dark_skin_tone:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_medium-light_skin_tone:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_medium_skin_tone:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_factory_worker:': u'\U0001F469\U0000200D\U0001F3ED',
    u':woman_factory_worker_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
    u':woman_factory_worker_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
    u':woman_factory_worker_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
    u':woman_factory_worker_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
    u':woman_factory_worker_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
    u':woman_fairy:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_dark_skin_tone:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_light_skin_tone:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_medium_skin_tone:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_farmer:': u'\U0001F469\U0000200D\U0001F33E',
    u':woman_farmer_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
    u':woman_farmer_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
    u':woman_farmer_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
    u':woman_farmer_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
    u':woman_farmer_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
    u':woman_firefighter:': u'\U0001F469\U0000200D\U0001F692',
    u':woman_firefighter_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
    u':woman_firefighter_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
    u':woman_firefighter_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
    u':woman_firefighter_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
    u':woman_firefighter_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
    u':woman_frowning:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_dark_skin_tone:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_light_skin_tone:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_medium-light_skin_tone:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_medium_skin_tone:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_genie:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_dark_skin_tone:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_light_skin_tone:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_medium-dark_skin_tone:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_medium-light_skin_tone:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_medium_skin_tone:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_dark_skin_tone:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_light_skin_tone:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_medium-dark_skin_tone:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_medium-light_skin_tone:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_medium_skin_tone:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_dark_skin_tone:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_light_skin_tone:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_medium-dark_skin_tone:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_medium-light_skin_tone:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_medium_skin_tone:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_dark_skin_tone:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_light_skin_tone:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_medium-dark_skin_tone:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_medium-light_skin_tone:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_medium_skin_tone:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_dark_skin_tone:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_light_skin_tone:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_medium_skin_tone:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_guard:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_dark_skin_tone:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_light_skin_tone:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_medium-dark_skin_tone:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_medium-light_skin_tone:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_medium_skin_tone:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_health_worker:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':woman_in_lotus_position:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_dark_skin_tone:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_light_skin_tone:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_medium_skin_tone:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_in_manual_wheelchair:': u'\U0001F469\U0000200D\U0001F9BD',
    u':woman_in_motorized_wheelchair:': u'\U0001F469\U0000200D\U0001F9BC',
    u':woman_in_steamy_room:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_dark_skin_tone:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_light_skin_tone:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_medium_skin_tone:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_judge:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':woman_juggling:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_dark_skin_tone:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_light_skin_tone:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_medium-dark_skin_tone:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_medium-light_skin_tone:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_medium_skin_tone:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_dark_skin_tone:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_light_skin_tone:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_medium_skin_tone:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_light_skin_tone:': u'\U0001F469\U0001F3FB',
    u':woman_mage:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_dark_skin_tone:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_light_skin_tone:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_medium_skin_tone:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_mechanic:': u'\U0001F469\U0000200D\U0001F527',
    u':woman_mechanic_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
    u':woman_mechanic_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
    u':woman_mechanic_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
    u':woman_mechanic_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
    u':woman_mechanic_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
    u':woman_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE',
    u':woman_medium-light_skin_tone:': u'\U0001F469\U0001F3FC',
    u':woman_medium_skin_tone:': u'\U0001F469\U0001F3FD',
    u':woman_mountain_biking:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_dark_skin_tone:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_light_skin_tone:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_medium_skin_tone:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_office_worker:': u'\U0001F469\U0000200D\U0001F4BC',
    u':woman_office_worker_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
    u':woman_office_worker_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
    u':woman_office_worker_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
    u':woman_office_worker_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
    u':woman_office_worker_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
    u':woman_pilot:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':woman_playing_handball:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_dark_skin_tone:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_light_skin_tone:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_medium-light_skin_tone:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_medium_skin_tone:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_dark_skin_tone:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_light_skin_tone:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_medium-light_skin_tone:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_medium_skin_tone:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_dark_skin_tone:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_light_skin_tone:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_medium-light_skin_tone:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_medium_skin_tone:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_dark_skin_tone:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_light_skin_tone:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_medium-light_skin_tone:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_medium_skin_tone:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_dark_skin_tone:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_light_skin_tone:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_medium-light_skin_tone:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_medium_skin_tone:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_dark_skin_tone:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_light_skin_tone:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_medium_skin_tone:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_running:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
    u':woman_running_dark_skin_tone:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_running_light_skin_tone:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_running_medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_running_medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_running_medium_skin_tone:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_scientist:': u'\U0001F469\U0000200D\U0001F52C',
    u':woman_scientist_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
    u':woman_scientist_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
    u':woman_scientist_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
    u':woman_scientist_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
    u':woman_scientist_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
    u':woman_shrugging:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_dark_skin_tone:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_light_skin_tone:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_medium-dark_skin_tone:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_medium-light_skin_tone:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_medium_skin_tone:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_singer:': u'\U0001F469\U0000200D\U0001F3A4',
    u':woman_singer_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
    u':woman_singer_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
    u':woman_singer_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
    u':woman_singer_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
    u':woman_singer_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
    u':woman_student:': u'\U0001F469\U0000200D\U0001F393',
    u':woman_student_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
    u':woman_student_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
    u':woman_student_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
    u':woman_student_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
    u':woman_student_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
    u':woman_surfing:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_dark_skin_tone:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_light_skin_tone:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_medium_skin_tone:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_dark_skin_tone:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_light_skin_tone:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_medium_skin_tone:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_teacher:': u'\U0001F469\U0000200D\U0001F3EB',
    u':woman_teacher_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
    u':woman_teacher_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
    u':woman_teacher_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
    u':woman_teacher_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
    u':woman_teacher_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
    u':woman_technologist:': u'\U0001F469\U0000200D\U0001F4BB',
    u':woman_technologist_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
    u':woman_technologist_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
    u':woman_technologist_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
    u':woman_technologist_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
    u':woman_technologist_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
    u':woman_tipping_hand:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_dark_skin_tone:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_light_skin_tone:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_medium-dark_skin_tone:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_medium-light_skin_tone:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_medium_skin_tone:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_dark_skin_tone:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_light_skin_tone:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_medium_skin_tone:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_walking:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_dark_skin_tone:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_light_skin_tone:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_medium_skin_tone:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_dark_skin_tone:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_light_skin_tone:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_medium-dark_skin_tone:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_medium-light_skin_tone:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_medium_skin_tone:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_with_headscarf:': u'\U0001F9D5',
    u':woman_with_headscarf_dark_skin_tone:': u'\U0001F9D5\U0001F3FF',
    u':woman_with_headscarf_light_skin_tone:': u'\U0001F9D5\U0001F3FB',
    u':woman_with_headscarf_medium-dark_skin_tone:': u'\U0001F9D5\U0001F3FE',
    u':woman_with_headscarf_medium-light_skin_tone:': u'\U0001F9D5\U0001F3FC',
    u':woman_with_headscarf_medium_skin_tone:': u'\U0001F9D5\U0001F3FD',
    u':woman_with_probing_cane:': u'\U0001F469\U0000200D\U0001F9AF',
    u':woman_zombie:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
    u':woman’s_boot:': u'\U0001F462',
    u':woman’s_clothes:': u'\U0001F45A',
    u':woman’s_hat:': u'\U0001F452',
    u':woman’s_sandal:': u'\U0001F461',
    u':women_with_bunny_ears:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
    u':women_wrestling:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
    u':women’s_room:': u'\U0001F6BA',
    u':woozy_face:': u'\U0001F974',
    u':world_map:': u'\U0001F5FA',
    u':worried_face:': u'\U0001F61F',
    u':wrapped_gift:': u'\U0001F381',
    u':wrench:': u'\U0001F527',
    u':writing_hand:': u'\U0000270D',
    u':writing_hand_dark_skin_tone:': u'\U0000270D\U0001F3FF',
    u':writing_hand_light_skin_tone:': u'\U0000270D\U0001F3FB',
    u':writing_hand_medium-dark_skin_tone:': u'\U0000270D\U0001F3FE',
    u':writing_hand_medium-light_skin_tone:': u'\U0000270D\U0001F3FC',
    u':writing_hand_medium_skin_tone:': u'\U0000270D\U0001F3FD',
    u':yarn:': u'\U0001F9F6',
    u':yawning_face:': u'\U0001F971',
    u':yellow_circle:': u'\U0001F7E1',
    u':yellow_heart:': u'\U0001F49B',
    u':yellow_square:': u'\U0001F7E8',
    u':yen_banknote:': u'\U0001F4B4',
    u':yo-yo:': u'\U0001FA80',
    u':yin_yang:': u'\U0000262F',
    u':zany_face:': u'\U0001F92A',
    u':zebra:': u'\U0001F993',
    u':zipper-mouth_face:': u'\U0001F910',
    u':zombie:': u'\U0001F9DF',
    u':zzz:': u'\U0001F4A4',
    u':Åland_Islands:': u'\U0001F1E6\U0001F1FD',
    u':keycap_asterisk:': u'\U0000002A\U000020E3',
    u':keycap_digit_eight:': u'\U00000038\U000020E3',
    u':keycap_digit_five:': u'\U00000035\U000020E3',
    u':keycap_digit_four:': u'\U00000034\U000020E3',
    u':keycap_digit_nine:': u'\U00000039\U000020E3',
    u':keycap_digit_one:': u'\U00000031\U000020E3',
    u':keycap_digit_seven:': u'\U00000037\U000020E3',
    u':keycap_digit_six:': u'\U00000036\U000020E3',
    u':keycap_digit_three:': u'\U00000033\U000020E3',
    u':keycap_digit_two:': u'\U00000032\U000020E3',
    u':keycap_digit_zero:': u'\U00000030\U000020E3',
    u':keycap_number_sign:': u'\U00000023\U000020E3',
    u':light_skin_tone:': u'\U0001F3FB',
    u':medium_light_skin_tone:': u'\U0001F3FC',
    u':medium_skin_tone:': u'\U0001F3FD',
    u':medium_dark_skin_tone:': u'\U0001F3FE',
    u':dark_skin_tone:': u'\U0001F3FF',
    u':regional_indicator_symbol_letter_a:': u'\U0001F1E6',
    u':regional_indicator_symbol_letter_b:': u'\U0001F1E7',
    u':regional_indicator_symbol_letter_c:': u'\U0001F1E8',
    u':regional_indicator_symbol_letter_d:': u'\U0001F1E9',
    u':regional_indicator_symbol_letter_e:': u'\U0001F1EA',
    u':regional_indicator_symbol_letter_f:': u'\U0001F1EB',
    u':regional_indicator_symbol_letter_g:': u'\U0001F1EC',
    u':regional_indicator_symbol_letter_h:': u'\U0001F1ED',
    u':regional_indicator_symbol_letter_i:': u'\U0001F1EE',
    u':regional_indicator_symbol_letter_j:': u'\U0001F1EF',
    u':regional_indicator_symbol_letter_k:': u'\U0001F1F0',
    u':regional_indicator_symbol_letter_l:': u'\U0001F1F1',
    u':regional_indicator_symbol_letter_m:': u'\U0001F1F2',
    u':regional_indicator_symbol_letter_n:': u'\U0001F1F3',
    u':regional_indicator_symbol_letter_o:': u'\U0001F1F4',
    u':regional_indicator_symbol_letter_p:': u'\U0001F1F5',
    u':regional_indicator_symbol_letter_q:': u'\U0001F1F6',
    u':regional_indicator_symbol_letter_r:': u'\U0001F1F7',
    u':regional_indicator_symbol_letter_s:': u'\U0001F1F8',
    u':regional_indicator_symbol_letter_t:': u'\U0001F1F9',
    u':regional_indicator_symbol_letter_u:': u'\U0001F1FA',
    u':regional_indicator_symbol_letter_v:': u'\U0001F1FB',
    u':regional_indicator_symbol_letter_w:': u'\U0001F1FC',
    u':regional_indicator_symbol_letter_x:': u'\U0001F1FD',
    u':regional_indicator_symbol_letter_y:': u'\U0001F1FE',
    u':regional_indicator_symbol_letter_z:': u'\U0001F1FF',
}

EMOJI_ALIAS_UNICODE = dict(EMOJI_UNICODE.items(), **{
    u':admission_tickets:': u'\U0001F39F',
    u':aerial_tramway:': u'\U0001F6A1',
    u':airplane:': u'\U00002708',
    u':airplane_arriving:': u'\U0001F6EC',
    u':airplane_departure:': u'\U0001F6EB',
    u':alarm_clock:': u'\U000023F0',
    u':alembic:': u'\U00002697',
    u':space_invader:': u'\U0001F47E',
    u':ambulance:': u'\U0001F691',
    u':football:': u'\U0001F3C8',
    u':amphora:': u'\U0001F3FA',
    u':anchor:': u'\U00002693',
    u':anger:': u'\U0001F4A2',
    u':angry:': u'\U0001F620',
    u':anguished:': u'\U0001F627',
    u':ant:': u'\U0001F41C',
    u':signal_strength:': u'\U0001F4F6',
    u':arrows_counterclockwise:': u'\U0001F504',
    u':aquarius:': u'\U00002652',
    u':aries:': u'\U00002648',
    u':arrow_heading_down:': u'\U00002935',
    u':arrow_heading_up:': u'\U00002934',
    u':articulated_lorry:': u'\U0001F69B',
    u':art:': u'\U0001F3A8',
    u':astonished:': u'\U0001F632',
    u':athletic_shoe:': u'\U0001F45F',
    u':atom_symbol:': u'\U0000269B',
    u':eggplant:': u'\U0001F346',
    u':atm:': u'\U0001F3E7',
    u':car:': u'\U0001F697',
    u':red_car:': u'\U0001F697',
    u':baby:': u'\U0001F476',
    u':angel:': u'\U0001F47C',
    u':baby_bottle:': u'\U0001F37C',
    u':baby_chick:': u'\U0001F424',
    u':baby_symbol:': u'\U0001F6BC',
    u':back:': u'\U0001F519',
    u':camel:': u'\U0001F42B',
    u':badminton_racquet_and_shuttlecock:': u'\U0001F3F8',
    u':baggage_claim:': u'\U0001F6C4',
    u':balloon:': u'\U0001F388',
    u':ballot_box_with_ballot:': u'\U0001F5F3',
    u':ballot_box_with_check:': u'\U00002611',
    u':banana:': u'\U0001F34C',
    u':bank:': u'\U0001F3E6',
    u':dollar:': u'\U0001F4B5',
    u':euro:': u'\U0001F4B6',
    u':pound:': u'\U0001F4B7',
    u':yen:': u'\U0001F4B4',
    u':bar_chart:': u'\U0001F4CA',
    u':barber:': u'\U0001F488',
    u':baseball:': u'\U000026BE',
    u':basketball:': u'\U0001F3C0',
    u':bath:': u'\U0001F6C0',
    u':bathtub:': u'\U0001F6C1',
    u':battery:': u'\U0001F50B',
    u':beach_with_umbrella:': u'\U0001F3D6',
    u':bear:': u'\U0001F43B',
    u':heartbeat:': u'\U0001F493',
    u':bed:': u'\U0001F6CF',
    u':beer:': u'\U0001F37A',
    u':bell:': u'\U0001F514',
    u':no_bell:': u'\U0001F515',
    u':bellhop_bell:': u'\U0001F6CE',
    u':bento:': u'\U0001F371',
    u':bike:': u'\U0001F6B2',
    u':bicyclist:': u'\U0001F6B4',
    u':bikini:': u'\U0001F459',
    u':8ball:': u'\U0001F3B1',
    u':biohazard_sign:': u'\U00002623',
    u':bird:': u'\U0001F426',
    u':birthday:': u'\U0001F382',
    u':black_circle_for_record:': u'\U000023FA',
    u':clubs:': u'\U00002663',
    u':diamonds:': u'\U00002666',
    u':arrow_double_down:': u'\U000023EC',
    u':hearts:': u'\U00002665',
    u':black_large_square:': u'\U00002B1B',
    u':rewind:': u'\U000023EA',
    u':black_left__pointing_double_triangle_with_vertical_bar:': u'\U000023EE',
    u':arrow_backward:': u'\U000025C0',
    u':black_medium_small_square:': u'\U000025FE',
    u':black_medium_square:': u'\U000025FC',
    u':black_nib:': u'\U00002712',
    u':question:': u'\U00002753',
    u':fast_forward:': u'\U000023E9',
    u':black_right__pointing_double_triangle_with_vertical_bar:': u'\U000023ED',
    u':arrow_forward:': u'\U000025B6',
    u':black_right__pointing_triangle_with_double_vertical_bar:': u'\U000023EF',
    u':arrow_right:': u'\U000027A1',
    u':scissors:': u'\U00002702',
    u':black_small_square:': u'\U000025AA',
    u':spades:': u'\U00002660',
    u':black_square_button:': u'\U0001F532',
    u':black_square_for_stop:': u'\U000023F9',
    u':sunny:': u'\U00002600',
    u':phone:': u'\U0000260E',
    u':telephone:': u'\U0000260E',
    u':recycle:': u'\U0000267B',
    u':arrow_double_up:': u'\U000023EB',
    u':blossom:': u'\U0001F33C',
    u':blowfish:': u'\U0001F421',
    u':blue_book:': u'\U0001F4D8',
    u':blue_heart:': u'\U0001F499',
    u':boar:': u'\U0001F417',
    u':bomb:': u'\U0001F4A3',
    u':bookmark:': u'\U0001F516',
    u':bookmark_tabs:': u'\U0001F4D1',
    u':books:': u'\U0001F4DA',
    u':bottle_with_popping_cork:': u'\U0001F37E',
    u':bouquet:': u'\U0001F490',
    u':bow_and_arrow:': u'\U0001F3F9',
    u':bowling:': u'\U0001F3B3',
    u':boy:': u'\U0001F466',
    u':bread:': u'\U0001F35E',
    u':bride_with_veil:': u'\U0001F470',
    u':bridge_at_night:': u'\U0001F309',
    u':briefcase:': u'\U0001F4BC',
    u':broken_heart:': u'\U0001F494',
    u':bug:': u'\U0001F41B',
    u':building_construction:': u'\U0001F3D7',
    u':burrito:': u'\U0001F32F',
    u':bus:': u'\U0001F68C',
    u':busstop:': u'\U0001F68F',
    u':bust_in_silhouette:': u'\U0001F464',
    u':busts_in_silhouette:': u'\U0001F465',
    u':cactus:': u'\U0001F335',
    u':date:': u'\U0001F4C5',
    u':camera:': u'\U0001F4F7',
    u':camera_with_flash:': u'\U0001F4F8',
    u':camping:': u'\U0001F3D5',
    u':cancer:': u'\U0000264B',
    u':candle:': u'\U0001F56F',
    u':candy:': u'\U0001F36C',
    u':capricorn:': u'\U00002651',
    u':card_file_box:': u'\U0001F5C3',
    u':card_index:': u'\U0001F4C7',
    u':card_index_dividers:': u'\U0001F5C2',
    u':carousel_horse:': u'\U0001F3A0',
    u':flags:': u'\U0001F38F',
    u':cat2:': u'\U0001F408',
    u':cat:': u'\U0001F431',
    u':joy_cat:': u'\U0001F639',
    u':smirk_cat:': u'\U0001F63C',
    u':chains:': u'\U000026D3',
    u':chart_with_downwards_trend:': u'\U0001F4C9',
    u':chart_with_upwards_trend:': u'\U0001F4C8',
    u':chart:': u'\U0001F4B9',
    u':mega:': u'\U0001F4E3',
    u':cheese_wedge:': u'\U0001F9C0',
    u':checkered_flag:': u'\U0001F3C1',
    u':cherries:': u'\U0001F352',
    u':cherry_blossom:': u'\U0001F338',
    u':chestnut:': u'\U0001F330',
    u':chicken:': u'\U0001F414',
    u':children_crossing:': u'\U0001F6B8',
    u':chipmunk:': u'\U0001F43F',
    u':chocolate_bar:': u'\U0001F36B',
    u':christmas_tree:': u'\U0001F384',
    u':church:': u'\U000026EA',
    u':cinema:': u'\U0001F3A6',
    u':accept:': u'\U0001F251',
    u':ideograph_advantage:': u'\U0001F250',
    u':congratulations:': u'\U00003297',
    u':secret:': u'\U00003299',
    u':m:': u'\U000024C2',
    u':circus_tent:': u'\U0001F3AA',
    u':cityscape:': u'\U0001F3D9',
    u':city_sunset:': u'\U0001F306',
    u':clapper:': u'\U0001F3AC',
    u':clap:': u'\U0001F44F',
    u':classical_building:': u'\U0001F3DB',
    u':beers:': u'\U0001F37B',
    u':clipboard:': u'\U0001F4CB',
    u':clock830:': u'\U0001F563',
    u':clock8:': u'\U0001F557',
    u':clock1130:': u'\U0001F566',
    u':clock11:': u'\U0001F55A',
    u':clock530:': u'\U0001F560',
    u':clock5:': u'\U0001F554',
    u':clock430:': u'\U0001F55F',
    u':clock4:': u'\U0001F553',
    u':clock930:': u'\U0001F564',
    u':clock9:': u'\U0001F558',
    u':clock130:': u'\U0001F55C',
    u':clock1:': u'\U0001F550',
    u':clock730:': u'\U0001F562',
    u':clock7:': u'\U0001F556',
    u':clock630:': u'\U0001F561',
    u':clock6:': u'\U0001F555',
    u':clock1030:': u'\U0001F565',
    u':clock10:': u'\U0001F559',
    u':clock330:': u'\U0001F55E',
    u':clock3:': u'\U0001F552',
    u':clock1230:': u'\U0001F567',
    u':clock12:': u'\U0001F55B',
    u':clock230:': u'\U0001F55D',
    u':clock2:': u'\U0001F551',
    u':arrows_clockwise:': u'\U0001F503',
    u':repeat:': u'\U0001F501',
    u':repeat_one:': u'\U0001F502',
    u':closed_book:': u'\U0001F4D5',
    u':closed_lock_with_key:': u'\U0001F510',
    u':mailbox_closed:': u'\U0001F4EA',
    u':mailbox:': u'\U0001F4EB',
    u':closed_umbrella:': u'\U0001F302',
    u':cloud:': u'\U00002601',
    u':cloud_with_lightning:': u'\U0001F329',
    u':cloud_with_rain:': u'\U0001F327',
    u':cloud_with_snow:': u'\U0001F328',
    u':cloud_with_tornado:': u'\U0001F32A',
    u':cocktail:': u'\U0001F378',
    u':coffin:': u'\U000026B0',
    u':boom:': u'\U0001F4A5',
    u':collision:': u'\U0001F4A5',
    u':comet:': u'\U00002604',
    u':compression:': u'\U0001F5DC',
    u':confetti_ball:': u'\U0001F38A',
    u':confounded:': u'\U0001F616',
    u':confused:': u'\U0001F615',
    u':construction:': u'\U0001F6A7',
    u':construction_worker:': u'\U0001F477',
    u':control_knobs:': u'\U0001F39B',
    u':convenience_store:': u'\U0001F3EA',
    u':rice:': u'\U0001F35A',
    u':cookie:': u'\U0001F36A',
    u':egg:': u'\U0001F373',
    u':copyright:': u'\U000000A9',
    u':couch_and_lamp:': u'\U0001F6CB',
    u':couple_with_heart:': u'\U0001F491',
    u':cow2:': u'\U0001F404',
    u':cow:': u'\U0001F42E',
    u':crab:': u'\U0001F980',
    u':credit_card:': u'\U0001F4B3',
    u':crescent_moon:': u'\U0001F319',
    u':cricket_bat_and_ball:': u'\U0001F3CF',
    u':crocodile:': u'\U0001F40A',
    u':x:': u'\U0000274C',
    u':crossed_flags:': u'\U0001F38C',
    u':crossed_swords:': u'\U00002694',
    u':crown:': u'\U0001F451',
    u':crying_cat_face:': u'\U0001F63F',
    u':cry:': u'\U0001F622',
    u':crystal_ball:': u'\U0001F52E',
    u':curly_loop:': u'\U000027B0',
    u':currency_exchange:': u'\U0001F4B1',
    u':curry:': u'\U0001F35B',
    u':custard:': u'\U0001F36E',
    u':customs:': u'\U0001F6C3',
    u':cyclone:': u'\U0001F300',
    u':dagger_knife:': u'\U0001F5E1',
    u':dancer:': u'\U0001F483',
    u':dango:': u'\U0001F361',
    u':dark_sunglasses:': u'\U0001F576',
    u':dash:': u'\U0001F4A8',
    u':deciduous_tree:': u'\U0001F333',
    u':truck:': u'\U0001F69A',
    u':department_store:': u'\U0001F3EC',
    u':derelict_house_building:': u'\U0001F3DA',
    u':desert:': u'\U0001F3DC',
    u':desert_island:': u'\U0001F3DD',
    u':desktop_computer:': u'\U0001F5A5',
    u':diamond_shape_with_a_dot_inside:': u'\U0001F4A0',
    u':dart:': u'\U0001F3AF',
    u':disappointed_relieved:': u'\U0001F625',
    u':disappointed:': u'\U0001F61E',
    u':dizzy_face:': u'\U0001F635',
    u':dizzy:': u'\U0001F4AB',
    u':do_not_litter:': u'\U0001F6AF',
    u':dog2:': u'\U0001F415',
    u':dog:': u'\U0001F436',
    u':dolphin:': u'\U0001F42C',
    u':flipper:': u'\U0001F42C',
    u':door:': u'\U0001F6AA',
    u':loop:': u'\U000027BF',
    u':bangbang:': u'\U0000203C',
    u':double_vertical_bar:': u'\U000023F8',
    u':doughnut:': u'\U0001F369',
    u':dove_of_peace:': u'\U0001F54A',
    u':small_red_triangle_down:': u'\U0001F53B',
    u':arrow_down_small:': u'\U0001F53D',
    u':arrow_down:': u'\U00002B07',
    u':dragon:': u'\U0001F409',
    u':dragon_face:': u'\U0001F432',
    u':dress:': u'\U0001F457',
    u':dromedary_camel:': u'\U0001F42A',
    u':droplet:': u'\U0001F4A7',
    u':dvd:': u'\U0001F4C0',
    u':e__mail:': u'\U0001F4E7',
    u':ear:': u'\U0001F442',
    u':corn:': u'\U0001F33D',
    u':ear_of_rice:': u'\U0001F33E',
    u':earth_americas:': u'\U0001F30E',
    u':earth_asia:': u'\U0001F30F',
    u':earth_africa:': u'\U0001F30D',
    u':eight_pointed_black_star:': u'\U00002734',
    u':eight_spoked_asterisk:': u'\U00002733',
    u':eject_symbol:': u'\U000023CF',
    u':bulb:': u'\U0001F4A1',
    u':electric_plug:': u'\U0001F50C',
    u':flashlight:': u'\U0001F526',
    u':elephant:': u'\U0001F418',
    u':emoji_modifier_fitzpatrick_type__1__2:': u'\U0001F3FB',
    u':emoji_modifier_fitzpatrick_type__3:': u'\U0001F3FC',
    u':emoji_modifier_fitzpatrick_type__4:': u'\U0001F3FD',
    u':emoji_modifier_fitzpatrick_type__5:': u'\U0001F3FE',
    u':emoji_modifier_fitzpatrick_type__6:': u'\U0001F3FF',
    u':end:': u'\U0001F51A',
    u':email:': u'\U00002709',
    u':envelope:': u'\U00002709',
    u':envelope_with_arrow:': u'\U0001F4E9',
    u':european_castle:': u'\U0001F3F0',
    u':european_post_office:': u'\U0001F3E4',
    u':evergreen_tree:': u'\U0001F332',
    u':interrobang:': u'\U00002049',
    u':expressionless:': u'\U0001F611',
    u':alien:': u'\U0001F47D',
    u':eye:': u'\U0001F441',
    u':eyeglasses:': u'\U0001F453',
    u':eyes:': u'\U0001F440',
    u':massage:': u'\U0001F486',
    u':yum:': u'\U0001F60B',
    u':scream:': u'\U0001F631',
    u':kissing_heart:': u'\U0001F618',
    u':sweat:': u'\U0001F613',
    u':face_with_head__bandage:': u'\U0001F915',
    u':triumph:': u'\U0001F624',
    u':mask:': u'\U0001F637',
    u':no_good:': u'\U0001F645',
    u':ok_woman:': u'\U0001F646',
    u':open_mouth:': u'\U0001F62E',
    u':cold_sweat:': u'\U0001F630',
    u':face_with_rolling_eyes:': u'\U0001F644',
    u':stuck_out_tongue:': u'\U0001F61B',
    u':stuck_out_tongue_closed_eyes:': u'\U0001F61D',
    u':stuck_out_tongue_winking_eye:': u'\U0001F61C',
    u':joy:': u'\U0001F602',
    u':face_with_thermometer:': u'\U0001F912',
    u':no_mouth:': u'\U0001F636',
    u':factory:': u'\U0001F3ED',
    u':fallen_leaf:': u'\U0001F342',
    u':family:': u'\U0001F46A',
    u':santa:': u'\U0001F385',
    u':fax:': u'\U0001F4E0',
    u':fearful:': u'\U0001F628',
    u':ferris_wheel:': u'\U0001F3A1',
    u':ferry:': u'\U000026F4',
    u':field_hockey_stick_and_ball:': u'\U0001F3D1',
    u':file_cabinet:': u'\U0001F5C4',
    u':file_folder:': u'\U0001F4C1',
    u':film_frames:': u'\U0001F39E',
    u':film_projector:': u'\U0001F4FD',
    u':fire:': u'\U0001F525',
    u':fire_engine:': u'\U0001F692',
    u':sparkler:': u'\U0001F387',
    u':fireworks:': u'\U0001F386',
    u':first_quarter_moon:': u'\U0001F313',
    u':first_quarter_moon_with_face:': u'\U0001F31B',
    u':fish:': u'\U0001F41F',
    u':fish_cake:': u'\U0001F365',
    u':fishing_pole_and_fish:': u'\U0001F3A3',
    u':facepunch:': u'\U0001F44A',
    u':punch:': u'\U0001F44A',
    u':flag_for_Afghanistan:': u'\U0001F1E6\U0001F1EB',
    u':flag_for_Albania:': u'\U0001F1E6\U0001F1F1',
    u':flag_for_Algeria:': u'\U0001F1E9\U0001F1FF',
    u':flag_for_American_Samoa:': u'\U0001F1E6\U0001F1F8',
    u':flag_for_Andorra:': u'\U0001F1E6\U0001F1E9',
    u':flag_for_Angola:': u'\U0001F1E6\U0001F1F4',
    u':flag_for_Anguilla:': u'\U0001F1E6\U0001F1EE',
    u':flag_for_Antarctica:': u'\U0001F1E6\U0001F1F6',
    u':flag_for_Antigua_&_Barbuda:': u'\U0001F1E6\U0001F1EC',
    u':flag_for_Argentina:': u'\U0001F1E6\U0001F1F7',
    u':flag_for_Armenia:': u'\U0001F1E6\U0001F1F2',
    u':flag_for_Aruba:': u'\U0001F1E6\U0001F1FC',
    u':flag_for_Ascension_Island:': u'\U0001F1E6\U0001F1E8',
    u':flag_for_Australia:': u'\U0001F1E6\U0001F1FA',
    u':flag_for_Austria:': u'\U0001F1E6\U0001F1F9',
    u':flag_for_Azerbaijan:': u'\U0001F1E6\U0001F1FF',
    u':flag_for_Bahamas:': u'\U0001F1E7\U0001F1F8',
    u':flag_for_Bahrain:': u'\U0001F1E7\U0001F1ED',
    u':flag_for_Bangladesh:': u'\U0001F1E7\U0001F1E9',
    u':flag_for_Barbados:': u'\U0001F1E7\U0001F1E7',
    u':flag_for_Belarus:': u'\U0001F1E7\U0001F1FE',
    u':flag_for_Belgium:': u'\U0001F1E7\U0001F1EA',
    u':flag_for_Belize:': u'\U0001F1E7\U0001F1FF',
    u':flag_for_Benin:': u'\U0001F1E7\U0001F1EF',
    u':flag_for_Bermuda:': u'\U0001F1E7\U0001F1F2',
    u':flag_for_Bhutan:': u'\U0001F1E7\U0001F1F9',
    u':flag_for_Bolivia:': u'\U0001F1E7\U0001F1F4',
    u':flag_for_Bosnia_&_Herzegovina:': u'\U0001F1E7\U0001F1E6',
    u':flag_for_Botswana:': u'\U0001F1E7\U0001F1FC',
    u':flag_for_Bouvet_Island:': u'\U0001F1E7\U0001F1FB',
    u':flag_for_Brazil:': u'\U0001F1E7\U0001F1F7',
    u':flag_for_British_Indian_Ocean_Territory:': u'\U0001F1EE\U0001F1F4',
    u':flag_for_British_Virgin_Islands:': u'\U0001F1FB\U0001F1EC',
    u':flag_for_Brunei:': u'\U0001F1E7\U0001F1F3',
    u':flag_for_Bulgaria:': u'\U0001F1E7\U0001F1EC',
    u':flag_for_Burkina_Faso:': u'\U0001F1E7\U0001F1EB',
    u':flag_for_Burundi:': u'\U0001F1E7\U0001F1EE',
    u':flag_for_Cambodia:': u'\U0001F1F0\U0001F1ED',
    u':flag_for_Cameroon:': u'\U0001F1E8\U0001F1F2',
    u':flag_for_Canada:': u'\U0001F1E8\U0001F1E6',
    u':flag_for_Canary_Islands:': u'\U0001F1EE\U0001F1E8',
    u':flag_for_Cape_Verde:': u'\U0001F1E8\U0001F1FB',
    u':flag_for_Caribbean_Netherlands:': u'\U0001F1E7\U0001F1F6',
    u':flag_for_Cayman_Islands:': u'\U0001F1F0\U0001F1FE',
    u':flag_for_Central_African_Republic:': u'\U0001F1E8\U0001F1EB',
    u':flag_for_Ceuta_&_Melilla:': u'\U0001F1EA\U0001F1E6',
    u':flag_for_Chad:': u'\U0001F1F9\U0001F1E9',
    u':flag_for_Chile:': u'\U0001F1E8\U0001F1F1',
    u':flag_for_China:': u'\U0001F1E8\U0001F1F3',
    u':flag_for_Christmas_Island:': u'\U0001F1E8\U0001F1FD',
    u':flag_for_Clipperton_Island:': u'\U0001F1E8\U0001F1F5',
    u':flag_for_Cocos__Islands:': u'\U0001F1E8\U0001F1E8',
    u':flag_for_Colombia:': u'\U0001F1E8\U0001F1F4',
    u':flag_for_Comoros:': u'\U0001F1F0\U0001F1F2',
    u':flag_for_Congo____Brazzaville:': u'\U0001F1E8\U0001F1EC',
    u':flag_for_Congo____Kinshasa:': u'\U0001F1E8\U0001F1E9',
    u':flag_for_Cook_Islands:': u'\U0001F1E8\U0001F1F0',
    u':flag_for_Costa_Rica:': u'\U0001F1E8\U0001F1F7',
    u':flag_for_Croatia:': u'\U0001F1ED\U0001F1F7',
    u':flag_for_Cuba:': u'\U0001F1E8\U0001F1FA',
    u':flag_for_Curaçao:': u'\U0001F1E8\U0001F1FC',
    u':flag_for_Cyprus:': u'\U0001F1E8\U0001F1FE',
    u':flag_for_Czech_Republic:': u'\U0001F1E8\U0001F1FF',
    u':flag_for_Côte_d’Ivoire:': u'\U0001F1E8\U0001F1EE',
    u':flag_for_Denmark:': u'\U0001F1E9\U0001F1F0',
    u':flag_for_Diego_Garcia:': u'\U0001F1E9\U0001F1EC',
    u':flag_for_Djibouti:': u'\U0001F1E9\U0001F1EF',
    u':flag_for_Dominica:': u'\U0001F1E9\U0001F1F2',
    u':flag_for_Dominican_Republic:': u'\U0001F1E9\U0001F1F4',
    u':flag_for_Ecuador:': u'\U0001F1EA\U0001F1E8',
    u':flag_for_Egypt:': u'\U0001F1EA\U0001F1EC',
    u':flag_for_El_Salvador:': u'\U0001F1F8\U0001F1FB',
    u':flag_for_Equatorial_Guinea:': u'\U0001F1EC\U0001F1F6',
    u':flag_for_Eritrea:': u'\U0001F1EA\U0001F1F7',
    u':flag_for_Estonia:': u'\U0001F1EA\U0001F1EA',
    u':flag_for_Ethiopia:': u'\U0001F1EA\U0001F1F9',
    u':flag_for_European_Union:': u'\U0001F1EA\U0001F1FA',
    u':flag_for_Falkland_Islands:': u'\U0001F1EB\U0001F1F0',
    u':flag_for_Faroe_Islands:': u'\U0001F1EB\U0001F1F4',
    u':flag_for_Fiji:': u'\U0001F1EB\U0001F1EF',
    u':flag_for_Finland:': u'\U0001F1EB\U0001F1EE',
    u':flag_for_France:': u'\U0001F1EB\U0001F1F7',
    u':flag_for_French_Guiana:': u'\U0001F1EC\U0001F1EB',
    u':flag_for_French_Polynesia:': u'\U0001F1F5\U0001F1EB',
    u':flag_for_French_Southern_Territories:': u'\U0001F1F9\U0001F1EB',
    u':flag_for_Gabon:': u'\U0001F1EC\U0001F1E6',
    u':flag_for_Gambia:': u'\U0001F1EC\U0001F1F2',
    u':flag_for_Georgia:': u'\U0001F1EC\U0001F1EA',
    u':flag_for_Germany:': u'\U0001F1E9\U0001F1EA',
    u':flag_for_Ghana:': u'\U0001F1EC\U0001F1ED',
    u':flag_for_Gibraltar:': u'\U0001F1EC\U0001F1EE',
    u':flag_for_Greece:': u'\U0001F1EC\U0001F1F7',
    u':flag_for_Greenland:': u'\U0001F1EC\U0001F1F1',
    u':flag_for_Grenada:': u'\U0001F1EC\U0001F1E9',
    u':flag_for_Guadeloupe:': u'\U0001F1EC\U0001F1F5',
    u':flag_for_Guam:': u'\U0001F1EC\U0001F1FA',
    u':flag_for_Guatemala:': u'\U0001F1EC\U0001F1F9',
    u':flag_for_Guernsey:': u'\U0001F1EC\U0001F1EC',
    u':flag_for_Guinea:': u'\U0001F1EC\U0001F1F3',
    u':flag_for_Guinea__Bissau:': u'\U0001F1EC\U0001F1FC',
    u':flag_for_Guyana:': u'\U0001F1EC\U0001F1FE',
    u':flag_for_Haiti:': u'\U0001F1ED\U0001F1F9',
    u':flag_for_Heard_&_McDonald_Islands:': u'\U0001F1ED\U0001F1F2',
    u':flag_for_Honduras:': u'\U0001F1ED\U0001F1F3',
    u':flag_for_Hong_Kong:': u'\U0001F1ED\U0001F1F0',
    u':flag_for_Hungary:': u'\U0001F1ED\U0001F1FA',
    u':flag_for_Iceland:': u'\U0001F1EE\U0001F1F8',
    u':flag_for_India:': u'\U0001F1EE\U0001F1F3',
    u':flag_for_Indonesia:': u'\U0001F1EE\U0001F1E9',
    u':flag_for_Iran:': u'\U0001F1EE\U0001F1F7',
    u':flag_for_Iraq:': u'\U0001F1EE\U0001F1F6',
    u':flag_for_Ireland:': u'\U0001F1EE\U0001F1EA',
    u':flag_for_Isle_of_Man:': u'\U0001F1EE\U0001F1F2',
    u':flag_for_Israel:': u'\U0001F1EE\U0001F1F1',
    u':flag_for_Italy:': u'\U0001F1EE\U0001F1F9',
    u':flag_for_Jamaica:': u'\U0001F1EF\U0001F1F2',
    u':flag_for_Japan:': u'\U0001F1EF\U0001F1F5',
    u':flag_for_Jersey:': u'\U0001F1EF\U0001F1EA',
    u':flag_for_Jordan:': u'\U0001F1EF\U0001F1F4',
    u':flag_for_Kazakhstan:': u'\U0001F1F0\U0001F1FF',
    u':flag_for_Kenya:': u'\U0001F1F0\U0001F1EA',
    u':flag_for_Kiribati:': u'\U0001F1F0\U0001F1EE',
    u':flag_for_Kosovo:': u'\U0001F1FD\U0001F1F0',
    u':flag_for_Kuwait:': u'\U0001F1F0\U0001F1FC',
    u':flag_for_Kyrgyzstan:': u'\U0001F1F0\U0001F1EC',
    u':flag_for_Laos:': u'\U0001F1F1\U0001F1E6',
    u':flag_for_Latvia:': u'\U0001F1F1\U0001F1FB',
    u':flag_for_Lebanon:': u'\U0001F1F1\U0001F1E7',
    u':flag_for_Lesotho:': u'\U0001F1F1\U0001F1F8',
    u':flag_for_Liberia:': u'\U0001F1F1\U0001F1F7',
    u':flag_for_Libya:': u'\U0001F1F1\U0001F1FE',
    u':flag_for_Liechtenstein:': u'\U0001F1F1\U0001F1EE',
    u':flag_for_Lithuania:': u'\U0001F1F1\U0001F1F9',
    u':flag_for_Luxembourg:': u'\U0001F1F1\U0001F1FA',
    u':flag_for_Macau:': u'\U0001F1F2\U0001F1F4',
    u':flag_for_Macedonia:': u'\U0001F1F2\U0001F1F0',
    u':flag_for_Madagascar:': u'\U0001F1F2\U0001F1EC',
    u':flag_for_Malawi:': u'\U0001F1F2\U0001F1FC',
    u':flag_for_Malaysia:': u'\U0001F1F2\U0001F1FE',
    u':flag_for_Maldives:': u'\U0001F1F2\U0001F1FB',
    u':flag_for_Mali:': u'\U0001F1F2\U0001F1F1',
    u':flag_for_Malta:': u'\U0001F1F2\U0001F1F9',
    u':flag_for_Marshall_Islands:': u'\U0001F1F2\U0001F1ED',
    u':flag_for_Martinique:': u'\U0001F1F2\U0001F1F6',
    u':flag_for_Mauritania:': u'\U0001F1F2\U0001F1F7',
    u':flag_for_Mauritius:': u'\U0001F1F2\U0001F1FA',
    u':flag_for_Mayotte:': u'\U0001F1FE\U0001F1F9',
    u':flag_for_Mexico:': u'\U0001F1F2\U0001F1FD',
    u':flag_for_Micronesia:': u'\U0001F1EB\U0001F1F2',
    u':flag_for_Moldova:': u'\U0001F1F2\U0001F1E9',
    u':flag_for_Monaco:': u'\U0001F1F2\U0001F1E8',
    u':flag_for_Mongolia:': u'\U0001F1F2\U0001F1F3',
    u':flag_for_Montenegro:': u'\U0001F1F2\U0001F1EA',
    u':flag_for_Montserrat:': u'\U0001F1F2\U0001F1F8',
    u':flag_for_Morocco:': u'\U0001F1F2\U0001F1E6',
    u':flag_for_Mozambique:': u'\U0001F1F2\U0001F1FF',
    u':flag_for_Myanmar:': u'\U0001F1F2\U0001F1F2',
    u':flag_for_Namibia:': u'\U0001F1F3\U0001F1E6',
    u':flag_for_Nauru:': u'\U0001F1F3\U0001F1F7',
    u':flag_for_Nepal:': u'\U0001F1F3\U0001F1F5',
    u':flag_for_Netherlands:': u'\U0001F1F3\U0001F1F1',
    u':flag_for_New_Caledonia:': u'\U0001F1F3\U0001F1E8',
    u':flag_for_New_Zealand:': u'\U0001F1F3\U0001F1FF',
    u':flag_for_Nicaragua:': u'\U0001F1F3\U0001F1EE',
    u':flag_for_Niger:': u'\U0001F1F3\U0001F1EA',
    u':flag_for_Nigeria:': u'\U0001F1F3\U0001F1EC',
    u':flag_for_Niue:': u'\U0001F1F3\U0001F1FA',
    u':flag_for_Norfolk_Island:': u'\U0001F1F3\U0001F1EB',
    u':flag_for_North_Korea:': u'\U0001F1F0\U0001F1F5',
    u':flag_for_Northern_Mariana_Islands:': u'\U0001F1F2\U0001F1F5',
    u':flag_for_Norway:': u'\U0001F1F3\U0001F1F4',
    u':flag_for_Oman:': u'\U0001F1F4\U0001F1F2',
    u':flag_for_Pakistan:': u'\U0001F1F5\U0001F1F0',
    u':flag_for_Palau:': u'\U0001F1F5\U0001F1FC',
    u':flag_for_Palestinian_Territories:': u'\U0001F1F5\U0001F1F8',
    u':flag_for_Panama:': u'\U0001F1F5\U0001F1E6',
    u':flag_for_Papua_New_Guinea:': u'\U0001F1F5\U0001F1EC',
    u':flag_for_Paraguay:': u'\U0001F1F5\U0001F1FE',
    u':flag_for_Peru:': u'\U0001F1F5\U0001F1EA',
    u':flag_for_Philippines:': u'\U0001F1F5\U0001F1ED',
    u':flag_for_Pitcairn_Islands:': u'\U0001F1F5\U0001F1F3',
    u':flag_for_Poland:': u'\U0001F1F5\U0001F1F1',
    u':flag_for_Portugal:': u'\U0001F1F5\U0001F1F9',
    u':flag_for_Puerto_Rico:': u'\U0001F1F5\U0001F1F7',
    u':flag_for_Qatar:': u'\U0001F1F6\U0001F1E6',
    u':flag_for_Romania:': u'\U0001F1F7\U0001F1F4',
    u':flag_for_Russia:': u'\U0001F1F7\U0001F1FA',
    u':flag_for_Rwanda:': u'\U0001F1F7\U0001F1FC',
    u':flag_for_Réunion:': u'\U0001F1F7\U0001F1EA',
    u':flag_for_Samoa:': u'\U0001F1FC\U0001F1F8',
    u':flag_for_San_Marino:': u'\U0001F1F8\U0001F1F2',
    u':flag_for_Saudi_Arabia:': u'\U0001F1F8\U0001F1E6',
    u':flag_for_Senegal:': u'\U0001F1F8\U0001F1F3',
    u':flag_for_Serbia:': u'\U0001F1F7\U0001F1F8',
    u':flag_for_Seychelles:': u'\U0001F1F8\U0001F1E8',
    u':flag_for_Sierra_Leone:': u'\U0001F1F8\U0001F1F1',
    u':flag_for_Singapore:': u'\U0001F1F8\U0001F1EC',
    u':flag_for_Sint_Maarten:': u'\U0001F1F8\U0001F1FD',
    u':flag_for_Slovakia:': u'\U0001F1F8\U0001F1F0',
    u':flag_for_Slovenia:': u'\U0001F1F8\U0001F1EE',
    u':flag_for_Solomon_Islands:': u'\U0001F1F8\U0001F1E7',
    u':flag_for_Somalia:': u'\U0001F1F8\U0001F1F4',
    u':flag_for_South_Africa:': u'\U0001F1FF\U0001F1E6',
    u':flag_for_South_Georgia_&_South_Sandwich_Islands:': u'\U0001F1EC\U0001F1F8',
    u':flag_for_South_Korea:': u'\U0001F1F0\U0001F1F7',
    u':flag_for_South_Sudan:': u'\U0001F1F8\U0001F1F8',
    u':flag_for_Spain:': u'\U0001F1EA\U0001F1F8',
    u':flag_for_Sri_Lanka:': u'\U0001F1F1\U0001F1F0',
    u':flag_for_St._Barthélemy:': u'\U0001F1E7\U0001F1F1',
    u':flag_for_St._Helena:': u'\U0001F1F8\U0001F1ED',
    u':flag_for_St._Kitts_&_Nevis:': u'\U0001F1F0\U0001F1F3',
    u':flag_for_St._Lucia:': u'\U0001F1F1\U0001F1E8',
    u':flag_for_St._Martin:': u'\U0001F1F2\U0001F1EB',
    u':flag_for_St._Pierre_&_Miquelon:': u'\U0001F1F5\U0001F1F2',
    u':flag_for_St._Vincent_&_Grenadines:': u'\U0001F1FB\U0001F1E8',
    u':flag_for_Sudan:': u'\U0001F1F8\U0001F1E9',
    u':flag_for_Suriname:': u'\U0001F1F8\U0001F1F7',
    u':flag_for_Svalbard_&_Jan_Mayen:': u'\U0001F1F8\U0001F1EF',
    u':flag_for_Swaziland:': u'\U0001F1F8\U0001F1FF',
    u':flag_for_Sweden:': u'\U0001F1F8\U0001F1EA',
    u':flag_for_Switzerland:': u'\U0001F1E8\U0001F1ED',
    u':flag_for_Syria:': u'\U0001F1F8\U0001F1FE',
    u':flag_for_São_Tomé_&_Príncipe:': u'\U0001F1F8\U0001F1F9',
    u':flag_for_Taiwan:': u'\U0001F1F9\U0001F1FC',
    u':flag_for_Tajikistan:': u'\U0001F1F9\U0001F1EF',
    u':flag_for_Tanzania:': u'\U0001F1F9\U0001F1FF',
    u':flag_for_Thailand:': u'\U0001F1F9\U0001F1ED',
    u':flag_for_Timor__Leste:': u'\U0001F1F9\U0001F1F1',
    u':flag_for_Togo:': u'\U0001F1F9\U0001F1EC',
    u':flag_for_Tokelau:': u'\U0001F1F9\U0001F1F0',
    u':flag_for_Tonga:': u'\U0001F1F9\U0001F1F4',
    u':flag_for_Trinidad_&_Tobago:': u'\U0001F1F9\U0001F1F9',
    u':flag_for_Tristan_da_Cunha:': u'\U0001F1F9\U0001F1E6',
    u':flag_for_Tunisia:': u'\U0001F1F9\U0001F1F3',
    u':flag_for_Turkey:': u'\U0001F1F9\U0001F1F7',
    u':flag_for_Turkmenistan:': u'\U0001F1F9\U0001F1F2',
    u':flag_for_Turks_&_Caicos_Islands:': u'\U0001F1F9\U0001F1E8',
    u':flag_for_Tuvalu:': u'\U0001F1F9\U0001F1FB',
    u':flag_for_U.S._Outlying_Islands:': u'\U0001F1FA\U0001F1F2',
    u':flag_for_U.S._Virgin_Islands:': u'\U0001F1FB\U0001F1EE',
    u':flag_for_Uganda:': u'\U0001F1FA\U0001F1EC',
    u':flag_for_Ukraine:': u'\U0001F1FA\U0001F1E6',
    u':flag_for_United_Arab_Emirates:': u'\U0001F1E6\U0001F1EA',
    u':flag_for_United_Kingdom:': u'\U0001F1EC\U0001F1E7',
    u':flag_for_United_States:': u'\U0001F1FA\U0001F1F8',
    u':flag_for_Uruguay:': u'\U0001F1FA\U0001F1FE',
    u':flag_for_Uzbekistan:': u'\U0001F1FA\U0001F1FF',
    u':flag_for_Vanuatu:': u'\U0001F1FB\U0001F1FA',
    u':flag_for_Vatican_City:': u'\U0001F1FB\U0001F1E6',
    u':flag_for_Venezuela:': u'\U0001F1FB\U0001F1EA',
    u':flag_for_Vietnam:': u'\U0001F1FB\U0001F1F3',
    u':flag_for_Wallis_&_Futuna:': u'\U0001F1FC\U0001F1EB',
    u':flag_for_Western_Sahara:': u'\U0001F1EA\U0001F1ED',
    u':flag_for_Yemen:': u'\U0001F1FE\U0001F1EA',
    u':flag_for_Zambia:': u'\U0001F1FF\U0001F1F2',
    u':flag_for_Zimbabwe:': u'\U0001F1FF\U0001F1FC',
    u':flag_for_Åland_Islands:': u'\U0001F1E6\U0001F1FD',
    u':golf:': u'\U000026F3',
    u':fleur__de__lis:': u'\U0000269C',
    u':muscle:': u'\U0001F4AA',
    u':floppy_disk:': u'\U0001F4BE',
    u':flower_playing_cards:': u'\U0001F3B4',
    u':flushed:': u'\U0001F633',
    u':fog:': u'\U0001F32B',
    u':foggy:': u'\U0001F301',
    u':footprints:': u'\U0001F463',
    u':fork_and_knife:': u'\U0001F374',
    u':fork_and_knife_with_plate:': u'\U0001F37D',
    u':fountain:': u'\U000026F2',
    u':four_leaf_clover:': u'\U0001F340',
    u':frame_with_picture:': u'\U0001F5BC',
    u':fries:': u'\U0001F35F',
    u':fried_shrimp:': u'\U0001F364',
    u':frog:': u'\U0001F438',
    u':hatched_chick:': u'\U0001F425',
    u':frowning:': u'\U0001F626',
    u':fuelpump:': u'\U000026FD',
    u':full_moon:': u'\U0001F315',
    u':full_moon_with_face:': u'\U0001F31D',
    u':funeral_urn:': u'\U000026B1',
    u':game_die:': u'\U0001F3B2',
    u':gear:': u'\U00002699',
    u':gem:': u'\U0001F48E',
    u':gemini:': u'\U0000264A',
    u':ghost:': u'\U0001F47B',
    u':girl:': u'\U0001F467',
    u':globe_with_meridians:': u'\U0001F310',
    u':star2:': u'\U0001F31F',
    u':goat:': u'\U0001F410',
    u':golfer:': u'\U0001F3CC',
    u':mortar_board:': u'\U0001F393',
    u':grapes:': u'\U0001F347',
    u':green_apple:': u'\U0001F34F',
    u':green_book:': u'\U0001F4D7',
    u':green_heart:': u'\U0001F49A',
    u':grimacing:': u'\U0001F62C',
    u':smile_cat:': u'\U0001F638',
    u':grinning:': u'\U0001F600',
    u':grin:': u'\U0001F601',
    u':heartpulse:': u'\U0001F497',
    u':guardsman:': u'\U0001F482',
    u':guitar:': u'\U0001F3B8',
    u':haircut:': u'\U0001F487',
    u':hamburger:': u'\U0001F354',
    u':hammer:': u'\U0001F528',
    u':hammer_and_pick:': u'\U00002692',
    u':hammer_and_wrench:': u'\U0001F6E0',
    u':hamster:': u'\U0001F439',
    u':handbag:': u'\U0001F45C',
    u':raising_hand:': u'\U0001F64B',
    u':hatching_chick:': u'\U0001F423',
    u':headphones:': u'\U0001F3A7',
    u':hear_no_evil:': u'\U0001F649',
    u':heart_decoration:': u'\U0001F49F',
    u':cupid:': u'\U0001F498',
    u':gift_heart:': u'\U0001F49D',
    u':heart:': u'\U00002764',
    u':heavy_check_mark:': u'\U00002714',
    u':heavy_division_sign:': u'\U00002797',
    u':heavy_dollar_sign:': u'\U0001F4B2',
    u':exclamation:': u'\U00002757',
    u':heavy_exclamation_mark:': u'\U00002757',
    u':heavy_heart_exclamation_mark_ornament:': u'\U00002763',
    u':o:': u'\U00002B55',
    u':heavy_minus_sign:': u'\U00002796',
    u':heavy_multiplication_x:': u'\U00002716',
    u':heavy_plus_sign:': u'\U00002795',
    u':helicopter:': u'\U0001F681',
    u':helm_symbol:': u'\U00002388',
    u':helmet_with_white_cross:': u'\U000026D1',
    u':herb:': u'\U0001F33F',
    u':hibiscus:': u'\U0001F33A',
    u':high_heel:': u'\U0001F460',
    u':bullettrain_side:': u'\U0001F684',
    u':bullettrain_front:': u'\U0001F685',
    u':high_brightness:': u'\U0001F506',
    u':zap:': u'\U000026A1',
    u':hocho:': u'\U0001F52A',
    u':knife:': u'\U0001F52A',
    u':hole:': u'\U0001F573',
    u':honey_pot:': u'\U0001F36F',
    u':bee:': u'\U0001F41D',
    u':traffic_light:': u'\U0001F6A5',
    u':racehorse:': u'\U0001F40E',
    u':horse:': u'\U0001F434',
    u':horse_racing:': u'\U0001F3C7',
    u':hospital:': u'\U0001F3E5',
    u':coffee:': u'\U00002615',
    u':hot_dog:': u'\U0001F32D',
    u':hot_pepper:': u'\U0001F336',
    u':hotsprings:': u'\U00002668',
    u':hotel:': u'\U0001F3E8',
    u':hourglass:': u'\U0000231B',
    u':hourglass_flowing_sand:': u'\U000023F3',
    u':house:': u'\U0001F3E0',
    u':house_buildings:': u'\U0001F3D8',
    u':house_with_garden:': u'\U0001F3E1',
    u':hugging_face:': u'\U0001F917',
    u':100:': u'\U0001F4AF',
    u':hushed:': u'\U0001F62F',
    u':ice_cream:': u'\U0001F368',
    u':ice_hockey_stick_and_puck:': u'\U0001F3D2',
    u':ice_skate:': u'\U000026F8',
    u':imp:': u'\U0001F47F',
    u':inbox_tray:': u'\U0001F4E5',
    u':incoming_envelope:': u'\U0001F4E8',
    u':information_desk_person:': u'\U0001F481',
    u':information_source:': u'\U00002139',
    u':capital_abcd:': u'\U0001F520',
    u':abc:': u'\U0001F524',
    u':abcd:': u'\U0001F521',
    u':1234:': u'\U0001F522',
    u':symbols:': u'\U0001F523',
    u':izakaya_lantern:': u'\U0001F3EE',
    u':lantern:': u'\U0001F3EE',
    u':jack_o_lantern:': u'\U0001F383',
    u':japanese_castle:': u'\U0001F3EF',
    u':dolls:': u'\U0001F38E',
    u':japanese_goblin:': u'\U0001F47A',
    u':japanese_ogre:': u'\U0001F479',
    u':post_office:': u'\U0001F3E3',
    u':beginner:': u'\U0001F530',
    u':jeans:': u'\U0001F456',
    u':joystick:': u'\U0001F579',
    u':kaaba:': u'\U0001F54B',
    u':key:': u'\U0001F511',
    u':keyboard:': u'\U00002328',
    u':zero:': u'\U00000030\U0000FE0F\U000020E3',
    u':one:': u'\U00000031\U0000FE0F\U000020E3',
    u':ten:': u'\U0001F51F',
    u':two:': u'\U00000032\U0000FE0F\U000020E3',
    u':three:': u'\U00000033\U0000FE0F\U000020E3',
    u':four:': u'\U00000034\U0000FE0F\U000020E3',
    u':five:': u'\U00000035\U0000FE0F\U000020E3',
    u':six:': u'\U00000036\U0000FE0F\U000020E3',
    u':seven:': u'\U00000037\U0000FE0F\U000020E3',
    u':eight:': u'\U00000038\U0000FE0F\U000020E3',
    u':nine:': u'\U00000039\U0000FE0F\U000020E3',
    u':kimono:': u'\U0001F458',
    u':couplekiss:': u'\U0001F48F',
    u':kiss:': u'\U0001F48B',
    u':kissing_cat:': u'\U0001F63D',
    u':kissing:': u'\U0001F617',
    u':kissing_closed_eyes:': u'\U0001F61A',
    u':kissing_smiling_eyes:': u'\U0001F619',
    u':koala:': u'\U0001F428',
    u':label:': u'\U0001F3F7',
    u':beetle:': u'\U0001F41E',
    u':large_blue_circle:': u'\U0001F535',
    u':large_blue_diamond:': u'\U0001F537',
    u':large_orange_diamond:': u'\U0001F536',
    u':red_circle:': u'\U0001F534',
    u':last_quarter_moon:': u'\U0001F317',
    u':last_quarter_moon_with_face:': u'\U0001F31C',
    u':latin_cross:': u'\U0000271D',
    u':leaves:': u'\U0001F343',
    u':ledger:': u'\U0001F4D2',
    u':mag:': u'\U0001F50D',
    u':left_luggage:': u'\U0001F6C5',
    u':left_right_arrow:': u'\U00002194',
    u':leftwards_arrow_with_hook:': u'\U000021A9',
    u':arrow_left:': u'\U00002B05',
    u':lemon:': u'\U0001F34B',
    u':leo:': u'\U0000264C',
    u':leopard:': u'\U0001F406',
    u':level_slider:': u'\U0001F39A',
    u':libra:': u'\U0000264E',
    u':light_rail:': u'\U0001F688',
    u':link:': u'\U0001F517',
    u':linked_paperclips:': u'\U0001F587',
    u':lion_face:': u'\U0001F981',
    u':lipstick:': u'\U0001F484',
    u':lock:': u'\U0001F512',
    u':lock_with_ink_pen:': u'\U0001F50F',
    u':lollipop:': u'\U0001F36D',
    u':sob:': u'\U0001F62D',
    u':love_hotel:': u'\U0001F3E9',
    u':love_letter:': u'\U0001F48C',
    u':low_brightness:': u'\U0001F505',
    u':lower_left_ballpoint_pen:': u'\U0001F58A',
    u':lower_left_crayon:': u'\U0001F58D',
    u':lower_left_fountain_pen:': u'\U0001F58B',
    u':lower_left_paintbrush:': u'\U0001F58C',
    u':mahjong:': u'\U0001F004',
    u':man:': u'\U0001F468',
    u':couple:': u'\U0001F46B',
    u':man_in_business_suit_levitating:': u'\U0001F574',
    u':man_with_gua_pi_mao:': u'\U0001F472',
    u':man_with_turban:': u'\U0001F473',
    u':mans_shoe:': u'\U0001F45E',
    u':shoe:': u'\U0001F45E',
    u':mantelpiece_clock:': u'\U0001F570',
    u':maple_leaf:': u'\U0001F341',
    u':meat_on_bone:': u'\U0001F356',
    u':black_circle:': u'\U000026AB',
    u':white_circle:': u'\U000026AA',
    u':melon:': u'\U0001F348',
    u':memo:': u'\U0001F4DD',
    u':pencil:': u'\U0001F4DD',
    u':menorah_with_nine_branches:': u'\U0001F54E',
    u':mens:': u'\U0001F6B9',
    u':metro:': u'\U0001F687',
    u':microphone:': u'\U0001F3A4',
    u':microscope:': u'\U0001F52C',
    u':military_medal:': u'\U0001F396',
    u':milky_way:': u'\U0001F30C',
    u':minibus:': u'\U0001F690',
    u':minidisc:': u'\U0001F4BD',
    u':iphone:': u'\U0001F4F1',
    u':mobile_phone_off:': u'\U0001F4F4',
    u':calling:': u'\U0001F4F2',
    u':money__mouth_face:': u'\U0001F911',
    u':moneybag:': u'\U0001F4B0',
    u':money_with_wings:': u'\U0001F4B8',
    u':monkey:': u'\U0001F412',
    u':monkey_face:': u'\U0001F435',
    u':monorail:': u'\U0001F69D',
    u':rice_scene:': u'\U0001F391',
    u':mosque:': u'\U0001F54C',
    u':motor_boat:': u'\U0001F6E5',
    u':motorway:': u'\U0001F6E3',
    u':mount_fuji:': u'\U0001F5FB',
    u':mountain:': u'\U000026F0',
    u':mountain_bicyclist:': u'\U0001F6B5',
    u':mountain_cableway:': u'\U0001F6A0',
    u':mountain_railway:': u'\U0001F69E',
    u':mouse2:': u'\U0001F401',
    u':mouse:': u'\U0001F42D',
    u':lips:': u'\U0001F444',
    u':movie_camera:': u'\U0001F3A5',
    u':moyai:': u'\U0001F5FF',
    u':notes:': u'\U0001F3B6',
    u':mushroom:': u'\U0001F344',
    u':musical_keyboard:': u'\U0001F3B9',
    u':musical_note:': u'\U0001F3B5',
    u':musical_score:': u'\U0001F3BC',
    u':nail_care:': u'\U0001F485',
    u':name_badge:': u'\U0001F4DB',
    u':national_park:': u'\U0001F3DE',
    u':necktie:': u'\U0001F454',
    u':ab:': u'\U0001F18E',
    u':negative_squared_cross_mark:': u'\U0000274E',
    u':a:': u'\U0001F170',
    u':b:': u'\U0001F171',
    u':o2:': u'\U0001F17E',
    u':parking:': u'\U0001F17F',
    u':nerd_face:': u'\U0001F913',
    u':neutral_face:': u'\U0001F610',
    u':new_moon:': u'\U0001F311',
    u':honeybee:': u'\U0001F41D',
    u':new_moon_with_face:': u'\U0001F31A',
    u':newspaper:': u'\U0001F4F0',
    u':night_with_stars:': u'\U0001F303',
    u':no_bicycles:': u'\U0001F6B3',
    u':no_entry:': u'\U000026D4',
    u':no_entry_sign:': u'\U0001F6AB',
    u':no_mobile_phones:': u'\U0001F4F5',
    u':underage:': u'\U0001F51E',
    u':no_pedestrians:': u'\U0001F6B7',
    u':no_smoking:': u'\U0001F6AD',
    u':non__potable_water:': u'\U0001F6B1',
    u':arrow_upper_right:': u'\U00002197',
    u':arrow_upper_left:': u'\U00002196',
    u':nose:': u'\U0001F443',
    u':notebook:': u'\U0001F4D3',
    u':notebook_with_decorative_cover:': u'\U0001F4D4',
    u':nut_and_bolt:': u'\U0001F529',
    u':octopus:': u'\U0001F419',
    u':oden:': u'\U0001F362',
    u':office:': u'\U0001F3E2',
    u':oil_drum:': u'\U0001F6E2',
    u':ok_hand:': u'\U0001F44C',
    u':old_key:': u'\U0001F5DD',
    u':older_man:': u'\U0001F474',
    u':older_woman:': u'\U0001F475',
    u':om_symbol:': u'\U0001F549',
    u':on:': u'\U0001F51B',
    u':oncoming_automobile:': u'\U0001F698',
    u':oncoming_bus:': u'\U0001F68D',
    u':oncoming_police_car:': u'\U0001F694',
    u':oncoming_taxi:': u'\U0001F696',
    u':book:': u'\U0001F4D6',
    u':open_book:': u'\U0001F4D6',
    u':open_file_folder:': u'\U0001F4C2',
    u':open_hands:': u'\U0001F450',
    u':unlock:': u'\U0001F513',
    u':mailbox_with_no_mail:': u'\U0001F4ED',
    u':mailbox_with_mail:': u'\U0001F4EC',
    u':ophiuchus:': u'\U000026CE',
    u':cd:': u'\U0001F4BF',
    u':orange_book:': u'\U0001F4D9',
    u':orthodox_cross:': u'\U00002626',
    u':outbox_tray:': u'\U0001F4E4',
    u':ox:': u'\U0001F402',
    u':package:': u'\U0001F4E6',
    u':page_facing_up:': u'\U0001F4C4',
    u':page_with_curl:': u'\U0001F4C3',
    u':pager:': u'\U0001F4DF',
    u':palm_tree:': u'\U0001F334',
    u':panda_face:': u'\U0001F43C',
    u':paperclip:': u'\U0001F4CE',
    u':part_alternation_mark:': u'\U0000303D',
    u':tada:': u'\U0001F389',
    u':passenger_ship:': u'\U0001F6F3',
    u':passport_control:': u'\U0001F6C2',
    u':feet:': u'\U0001F43E',
    u':paw_prints:': u'\U0001F43E',
    u':peace_symbol:': u'\U0000262E',
    u':peach:': u'\U0001F351',
    u':pear:': u'\U0001F350',
    u':walking:': u'\U0001F6B6',
    u':pencil2:': u'\U0000270F',
    u':penguin:': u'\U0001F427',
    u':pensive:': u'\U0001F614',
    u':performing_arts:': u'\U0001F3AD',
    u':persevere:': u'\U0001F623',
    u':bow:': u'\U0001F647',
    u':person_frowning:': u'\U0001F64D',
    u':raised_hands:': u'\U0001F64C',
    u':person_with_ball:': u'\U000026F9',
    u':person_with_blond_hair:': u'\U0001F471',
    u':pray:': u'\U0001F64F',
    u':person_with_pouting_face:': u'\U0001F64E',
    u':computer:': u'\U0001F4BB',
    u':pick:': u'\U000026CF',
    u':pig2:': u'\U0001F416',
    u':pig:': u'\U0001F437',
    u':pig_nose:': u'\U0001F43D',
    u':hankey:': u'\U0001F4A9',
    u':poop:': u'\U0001F4A9',
    u':shit:': u'\U0001F4A9',
    u':pill:': u'\U0001F48A',
    u':bamboo:': u'\U0001F38D',
    u':pineapple:': u'\U0001F34D',
    u':pisces:': u'\U00002653',
    u':gun:': u'\U0001F52B',
    u':place_of_worship:': u'\U0001F6D0',
    u':black_joker:': u'\U0001F0CF',
    u':police_car:': u'\U0001F693',
    u':rotating_light:': u'\U0001F6A8',
    u':cop:': u'\U0001F46E',
    u':poodle:': u'\U0001F429',
    u':popcorn:': u'\U0001F37F',
    u':postal_horn:': u'\U0001F4EF',
    u':postbox:': u'\U0001F4EE',
    u':stew:': u'\U0001F372',
    u':potable_water:': u'\U0001F6B0',
    u':pouch:': u'\U0001F45D',
    u':poultry_leg:': u'\U0001F357',
    u':pouting_cat:': u'\U0001F63E',
    u':rage:': u'\U0001F621',
    u':prayer_beads:': u'\U0001F4FF',
    u':princess:': u'\U0001F478',
    u':printer:': u'\U0001F5A8',
    u':loudspeaker:': u'\U0001F4E2',
    u':purple_heart:': u'\U0001F49C',
    u':purse:': u'\U0001F45B',
    u':pushpin:': u'\U0001F4CC',
    u':put_litter_in_its_place:': u'\U0001F6AE',
    u':rabbit2:': u'\U0001F407',
    u':rabbit:': u'\U0001F430',
    u':racing_car:': u'\U0001F3CE',
    u':racing_motorcycle:': u'\U0001F3CD',
    u':radio:': u'\U0001F4FB',
    u':radio_button:': u'\U0001F518',
    u':radioactive_sign:': u'\U00002622',
    u':railway_car:': u'\U0001F683',
    u':railway_track:': u'\U0001F6E4',
    u':rainbow:': u'\U0001F308',
    u':fist:': u'\U0000270A',
    u':hand:': u'\U0000270B',
    u':raised_hand:': u'\U0000270B',
    u':raised_hand_with_fingers_splayed:': u'\U0001F590',
    u':raised_hand_with_part_between_middle_and_ring_fingers:': u'\U0001F596',
    u':ram:': u'\U0001F40F',
    u':rat:': u'\U0001F400',
    u':blue_car:': u'\U0001F699',
    u':apple:': u'\U0001F34E',
    u':registered:': u'\U000000AE',
    u':relieved:': u'\U0001F60C',
    u':reminder_ribbon:': u'\U0001F397',
    u':restroom:': u'\U0001F6BB',
    u':reversed_hand_with_middle_finger_extended:': u'\U0001F595',
    u':revolving_hearts:': u'\U0001F49E',
    u':ribbon:': u'\U0001F380',
    u':rice_ball:': u'\U0001F359',
    u':rice_cracker:': u'\U0001F358',
    u':mag_right:': u'\U0001F50E',
    u':right_anger_bubble:': u'\U0001F5EF',
    u':arrow_right_hook:': u'\U000021AA',
    u':ring:': u'\U0001F48D',
    u':sweet_potato:': u'\U0001F360',
    u':robot_face:': u'\U0001F916',
    u':robot:': u'\U0001F916',
    u':rocket:': u'\U0001F680',
    u':rolled__up_newspaper:': u'\U0001F5DE',
    u':roller_coaster:': u'\U0001F3A2',
    u':rooster:': u'\U0001F413',
    u':rose:': u'\U0001F339',
    u':rosette:': u'\U0001F3F5',
    u':round_pushpin:': u'\U0001F4CD',
    u':rowboat:': u'\U0001F6A3',
    u':rugby_football:': u'\U0001F3C9',
    u':runner:': u'\U0001F3C3',
    u':running:': u'\U0001F3C3',
    u':running_shirt_with_sash:': u'\U0001F3BD',
    u':sagittarius:': u'\U00002650',
    u':boat:': u'\U000026F5',
    u':sailboat:': u'\U000026F5',
    u':sake:': u'\U0001F376',
    u':satellite:': u'\U0001F4E1',
    u':saxophone:': u'\U0001F3B7',
    u':scales:': u'\U00002696',
    u':school:': u'\U0001F3EB',
    u':school_satchel:': u'\U0001F392',
    u':scorpion:': u'\U0001F982',
    u':scorpius:': u'\U0000264F',
    u':scroll:': u'\U0001F4DC',
    u':seat:': u'\U0001F4BA',
    u':see_no_evil:': u'\U0001F648',
    u':seedling:': u'\U0001F331',
    u':shamrock:': u'\U00002618',
    u':shaved_ice:': u'\U0001F367',
    u':sheep:': u'\U0001F411',
    u':shield:': u'\U0001F6E1',
    u':shinto_shrine:': u'\U000026E9',
    u':ship:': u'\U0001F6A2',
    u':stars:': u'\U0001F320',
    u':shopping_bags:': u'\U0001F6CD',
    u':cake:': u'\U0001F370',
    u':shower:': u'\U0001F6BF',
    u':sign_of_the_horns:': u'\U0001F918',
    u':japan:': u'\U0001F5FE',
    u':six_pointed_star:': u'\U0001F52F',
    u':ski:': u'\U0001F3BF',
    u':skier:': u'\U000026F7',
    u':skull:': u'\U0001F480',
    u':skull_and_crossbones:': u'\U00002620',
    u':sleeping_accommodation:': u'\U0001F6CC',
    u':sleeping:': u'\U0001F634',
    u':zzz:': u'\U0001F4A4',
    u':sleepy:': u'\U0001F62A',
    u':sleuth_or_spy:': u'\U0001F575',
    u':pizza:': u'\U0001F355',
    u':slightly_frowning_face:': u'\U0001F641',
    u':slightly_smiling_face:': u'\U0001F642',
    u':slot_machine:': u'\U0001F3B0',
    u':small_airplane:': u'\U0001F6E9',
    u':small_blue_diamond:': u'\U0001F539',
    u':small_orange_diamond:': u'\U0001F538',
    u':heart_eyes_cat:': u'\U0001F63B',
    u':smiley_cat:': u'\U0001F63A',
    u':innocent:': u'\U0001F607',
    u':heart_eyes:': u'\U0001F60D',
    u':smiling_imp:': u'\U0001F608',
    u':smiley:': u'\U0001F603',
    u':sweat_smile:': u'\U0001F605',
    u':smile:': u'\U0001F604',
    u':laughing:': u'\U0001F606',
    u':satisfied:': u'\U0001F606',
    u':blush:': u'\U0001F60A',
    u':sunglasses:': u'\U0001F60E',
    u':smirk:': u'\U0001F60F',
    u':smoking:': u'\U0001F6AC',
    u':snail:': u'\U0001F40C',
    u':snake:': u'\U0001F40D',
    u':snow_capped_mountain:': u'\U0001F3D4',
    u':snowboarder:': u'\U0001F3C2',
    u':snowflake:': u'\U00002744',
    u':snowman:': u'\U00002603',
    u':soccer:': u'\U000026BD',
    u':icecream:': u'\U0001F366',
    u':soon:': u'\U0001F51C',
    u':arrow_lower_right:': u'\U00002198',
    u':arrow_lower_left:': u'\U00002199',
    u':spaghetti:': u'\U0001F35D',
    u':sparkle:': u'\U00002747',
    u':sparkles:': u'\U00002728',
    u':sparkling_heart:': u'\U0001F496',
    u':speak_no_evil:': u'\U0001F64A',
    u':speaker:': u'\U0001F508',
    u':mute:': u'\U0001F507',
    u':sound:': u'\U0001F509',
    u':loud_sound:': u'\U0001F50A',
    u':speaking_head_in_silhouette:': u'\U0001F5E3',
    u':speech_balloon:': u'\U0001F4AC',
    u':speedboat:': u'\U0001F6A4',
    u':spider:': u'\U0001F577',
    u':spider_web:': u'\U0001F578',
    u':spiral_calendar_pad:': u'\U0001F5D3',
    u':spiral_note_pad:': u'\U0001F5D2',
    u':shell:': u'\U0001F41A',
    u':sweat_drops:': u'\U0001F4A6',
    u':sports_medal:': u'\U0001F3C5',
    u':whale:': u'\U0001F433',
    u':u5272:': u'\U0001F239',
    u':u5408:': u'\U0001F234',
    u':u55b6:': u'\U0001F23A',
    u':u6307:': u'\U0001F22F',
    u':u6708:': u'\U0001F237',
    u':u6709:': u'\U0001F236',
    u':u6e80:': u'\U0001F235',
    u':u7121:': u'\U0001F21A',
    u':u7533:': u'\U0001F238',
    u':u7981:': u'\U0001F232',
    u':u7a7a:': u'\U0001F233',
    u':cl:': u'\U0001F191',
    u':cool:': u'\U0001F192',
    u':free:': u'\U0001F193',
    u':id:': u'\U0001F194',
    u':koko:': u'\U0001F201',
    u':sa:': u'\U0001F202',
    u':new:': u'\U0001F195',
    u':ng:': u'\U0001F196',
    u':ok:': u'\U0001F197',
    u':sos:': u'\U0001F198',
    u':up:': u'\U0001F199',
    u':vs:': u'\U0001F19A',
    u':stadium:': u'\U0001F3DF',
    u':star_and_crescent:': u'\U0000262A',
    u':star_of_david:': u'\U00002721',
    u':station:': u'\U0001F689',
    u':statue_of_liberty:': u'\U0001F5FD',
    u':steam_locomotive:': u'\U0001F682',
    u':ramen:': u'\U0001F35C',
    u':stopwatch:': u'\U000023F1',
    u':straight_ruler:': u'\U0001F4CF',
    u':strawberry:': u'\U0001F353',
    u':studio_microphone:': u'\U0001F399',
    u':partly_sunny:': u'\U000026C5',
    u':sun_with_face:': u'\U0001F31E',
    u':sunflower:': u'\U0001F33B',
    u':sunrise:': u'\U0001F305',
    u':sunrise_over_mountains:': u'\U0001F304',
    u':city_sunrise:': u'\U0001F307',
    u':surfer:': u'\U0001F3C4',
    u':sushi:': u'\U0001F363',
    u':suspension_railway:': u'\U0001F69F',
    u':swimmer:': u'\U0001F3CA',
    u':synagogue:': u'\U0001F54D',
    u':syringe:': u'\U0001F489',
    u':shirt:': u'\U0001F455',
    u':tshirt:': u'\U0001F455',
    u':table_tennis_paddle_and_ball:': u'\U0001F3D3',
    u':taco:': u'\U0001F32E',
    u':tanabata_tree:': u'\U0001F38B',
    u':tangerine:': u'\U0001F34A',
    u':taurus:': u'\U00002649',
    u':taxi:': u'\U0001F695',
    u':tea:': u'\U0001F375',
    u':calendar:': u'\U0001F4C6',
    u':telephone_receiver:': u'\U0001F4DE',
    u':telescope:': u'\U0001F52D',
    u':tv:': u'\U0001F4FA',
    u':tennis:': u'\U0001F3BE',
    u':tent:': u'\U000026FA',
    u':thermometer:': u'\U0001F321',
    u':thinking_face:': u'\U0001F914',
    u':thought_balloon:': u'\U0001F4AD',
    u':three_button_mouse:': u'\U0001F5B1',
    u':+1:': u'\U0001F44D',
    u':thumbsup:': u'\U0001F44D',
    u':__1:': u'\U0001F44E',
    u':-1:': u'\U0001F44E',
    u':thumbsdown:': u'\U0001F44E',
    u':thunder_cloud_and_rain:': u'\U000026C8',
    u':ticket:': u'\U0001F3AB',
    u':tiger2:': u'\U0001F405',
    u':tiger:': u'\U0001F42F',
    u':timer_clock:': u'\U000023F2',
    u':tired_face:': u'\U0001F62B',
    u':toilet:': u'\U0001F6BD',
    u':tokyo_tower:': u'\U0001F5FC',
    u':tomato:': u'\U0001F345',
    u':tongue:': u'\U0001F445',
    u':tophat:': u'\U0001F3A9',
    u':top:': u'\U0001F51D',
    u':trackball:': u'\U0001F5B2',
    u':tractor:': u'\U0001F69C',
    u':tm:': u'\U00002122',
    u':train2:': u'\U0001F686',
    u':tram:': u'\U0001F68A',
    u':train:': u'\U0001F68B',
    u':triangular_flag_on_post:': u'\U0001F6A9',
    u':triangular_ruler:': u'\U0001F4D0',
    u':trident:': u'\U0001F531',
    u':trolleybus:': u'\U0001F68E',
    u':trophy:': u'\U0001F3C6',
    u':tropical_drink:': u'\U0001F379',
    u':tropical_fish:': u'\U0001F420',
    u':trumpet:': u'\U0001F3BA',
    u':tulip:': u'\U0001F337',
    u':turkey:': u'\U0001F983',
    u':turtle:': u'\U0001F422',
    u':twisted_rightwards_arrows:': u'\U0001F500',
    u':two_hearts:': u'\U0001F495',
    u':two_men_holding_hands:': u'\U0001F46C',
    u':two_women_holding_hands:': u'\U0001F46D',
    u':umbrella:': u'\U00002602',
    u':umbrella_on_ground:': u'\U000026F1',
    u':unamused:': u'\U0001F612',
    u':unicorn_face:': u'\U0001F984',
    u':small_red_triangle:': u'\U0001F53A',
    u':arrow_up_small:': u'\U0001F53C',
    u':arrow_up_down:': u'\U00002195',
    u':upside__down_face:': u'\U0001F643',
    u':arrow_up:': u'\U00002B06',
    u':vertical_traffic_light:': u'\U0001F6A6',
    u':vibration_mode:': u'\U0001F4F3',
    u':v:': u'\U0000270C',
    u':video_camera:': u'\U0001F4F9',
    u':video_game:': u'\U0001F3AE',
    u':vhs:': u'\U0001F4FC',
    u':violin:': u'\U0001F3BB',
    u':virgo:': u'\U0000264D',
    u':volcano:': u'\U0001F30B',
    u':volleyball:': u'\U0001F3D0',
    u':waning_crescent_moon:': u'\U0001F318',
    u':waning_gibbous_moon:': u'\U0001F316',
    u':warning:': u'\U000026A0',
    u':wastebasket:': u'\U0001F5D1',
    u':watch:': u'\U0000231A',
    u':water_buffalo:': u'\U0001F403',
    u':wc:': u'\U0001F6BE',
    u':ocean:': u'\U0001F30A',
    u':watermelon:': u'\U0001F349',
    u':waving_black_flag:': u'\U0001F3F4',
    u':wave:': u'\U0001F44B',
    u':waving_white_flag:': u'\U0001F3F3',
    u':wavy_dash:': u'\U00003030',
    u':waxing_crescent_moon:': u'\U0001F312',
    u':moon:': u'\U0001F314',
    u':waxing_gibbous_moon:': u'\U0001F314',
    u':scream_cat:': u'\U0001F640',
    u':weary:': u'\U0001F629',
    u':wedding:': u'\U0001F492',
    u':weight_lifter:': u'\U0001F3CB',
    u':whale2:': u'\U0001F40B',
    u':wheel_of_dharma:': u'\U00002638',
    u':wheelchair:': u'\U0000267F',
    u':point_down:': u'\U0001F447',
    u':grey_exclamation:': u'\U00002755',
    u':white_flower:': u'\U0001F4AE',
    u':white_frowning_face:': u'\U00002639',
    u':white_check_mark:': u'\U00002705',
    u':white_large_square:': u'\U00002B1C',
    u':point_left:': u'\U0001F448',
    u':white_medium_small_square:': u'\U000025FD',
    u':white_medium_square:': u'\U000025FB',
    u':star:': u'\U00002B50',
    u':grey_question:': u'\U00002754',
    u':point_right:': u'\U0001F449',
    u':white_small_square:': u'\U000025AB',
    u':relaxed:': u'\U0000263A',
    u':white_square_button:': u'\U0001F533',
    u':white_sun_behind_cloud:': u'\U0001F325',
    u':white_sun_behind_cloud_with_rain:': u'\U0001F326',
    u':white_sun_with_small_cloud:': u'\U0001F324',
    u':point_up_2:': u'\U0001F446',
    u':point_up:': u'\U0000261D',
    u':wind_blowing_face:': u'\U0001F32C',
    u':wind_chime:': u'\U0001F390',
    u':wine_glass:': u'\U0001F377',
    u':wink:': u'\U0001F609',
    u':wolf:': u'\U0001F43A',
    u':woman:': u'\U0001F469',
    u':dancers:': u'\U0001F46F',
    u':boot:': u'\U0001F462',
    u':womans_clothes:': u'\U0001F45A',
    u':womans_hat:': u'\U0001F452',
    u':sandal:': u'\U0001F461',
    u':womens:': u'\U0001F6BA',
    u':world_map:': u'\U0001F5FA',
    u':worried:': u'\U0001F61F',
    u':gift:': u'\U0001F381',
    u':wrench:': u'\U0001F527',
    u':writing_hand:': u'\U0000270D',
    u':yellow_heart:': u'\U0001F49B',
    u':yin_yang:': u'\U0000262F',
    u':zipper__mouth_face:': u'\U0001F910',
    u':regional_indicator_a:': u'\U0001F1E6',
    u':regional_indicator_b:': u'\U0001F1E7',
    u':regional_indicator_c:': u'\U0001F1E8',
    u':regional_indicator_d:': u'\U0001F1E9',
    u':regional_indicator_e:': u'\U0001F1EA',
    u':regional_indicator_f:': u'\U0001F1EB',
    u':regional_indicator_g:': u'\U0001F1EC',
    u':regional_indicator_h:': u'\U0001F1ED',
    u':regional_indicator_i:': u'\U0001F1EE',
    u':regional_indicator_j:': u'\U0001F1EF',
    u':regional_indicator_k:': u'\U0001F1F0',
    u':regional_indicator_l:': u'\U0001F1F1',
    u':regional_indicator_m:': u'\U0001F1F2',
    u':regional_indicator_n:': u'\U0001F1F3',
    u':regional_indicator_o:': u'\U0001F1F4',
    u':regional_indicator_p:': u'\U0001F1F5',
    u':regional_indicator_q:': u'\U0001F1F6',
    u':regional_indicator_r:': u'\U0001F1F7',
    u':regional_indicator_s:': u'\U0001F1F8',
    u':regional_indicator_t:': u'\U0001F1F9',
    u':regional_indicator_u:': u'\U0001F1FA',
    u':regional_indicator_v:': u'\U0001F1FB',
    u':regional_indicator_w:': u'\U0001F1FC',
    u':regional_indicator_x:': u'\U0001F1FD',
    u':regional_indicator_y:': u'\U0001F1FE',
    u':regional_indicator_z:': u'\U0001F1FF',
})


UNICODE_EMOJI = {v: k for k, v in EMOJI_UNICODE.items()}
UNICODE_EMOJI_ALIAS = {v: k for k, v in EMOJI_ALIAS_UNICODE.items()}
