/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.database.DataManager;
import org.traccar.database.SimpleObjectManager;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Permission;

public abstract class ExtendedObjectManager<T extends BaseModel>
extends SimpleObjectManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedObjectManager.class);
    private final Map<Long, Set<Long>> deviceItems = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> deviceItemsWithGroups = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, Set<Long>> groupItems = new ConcurrentHashMap<Long, Set<Long>>();

    protected ExtendedObjectManager(DataManager dataManager, Class<T> baseClass) {
        super(dataManager, baseClass);
        this.refreshExtendedPermissions();
    }

    public final Set<Long> getGroupItems(long groupId) {
        if (!this.groupItems.containsKey(groupId)) {
            this.groupItems.put(groupId, new HashSet());
        }
        return this.groupItems.get(groupId);
    }

    public final Set<Long> getDeviceItems(long deviceId) {
        if (!this.deviceItems.containsKey(deviceId)) {
            this.deviceItems.put(deviceId, new HashSet());
        }
        return this.deviceItems.get(deviceId);
    }

    public Set<Long> getAllDeviceItems(long deviceId) {
        if (!this.deviceItemsWithGroups.containsKey(deviceId)) {
            this.deviceItemsWithGroups.put(deviceId, new HashSet());
        }
        return this.deviceItemsWithGroups.get(deviceId);
    }

    @Override
    public void removeItem(long itemId) throws SQLException {
        super.removeItem(itemId);
        this.refreshExtendedPermissions();
    }

    public void refreshExtendedPermissions() {
        if (this.getDataManager() != null) {
            try {
                Collection<Permission> databaseGroupPermissions = this.getDataManager().getPermissions(Group.class, this.getBaseClass());
                this.groupItems.clear();
                for (Permission groupPermission : databaseGroupPermissions) {
                    this.getGroupItems(groupPermission.getOwnerId()).add(groupPermission.getPropertyId());
                }
                Collection<Permission> databaseDevicePermissions = this.getDataManager().getPermissions(Device.class, this.getBaseClass());
                this.deviceItems.clear();
                this.deviceItemsWithGroups.clear();
                for (Permission devicePermission : databaseDevicePermissions) {
                    this.getDeviceItems(devicePermission.getOwnerId()).add(devicePermission.getPropertyId());
                    this.getAllDeviceItems(devicePermission.getOwnerId()).add(devicePermission.getPropertyId());
                }
                for (Device device : Context.getDeviceManager().getAllDevices()) {
                    long groupId = device.getGroupId();
                    while (groupId != 0L) {
                        this.getAllDeviceItems(device.getId()).addAll(this.getGroupItems(groupId));
                        Group group = (Group)Context.getGroupsManager().getById(groupId);
                        if (group != null) {
                            groupId = group.getGroupId();
                            continue;
                        }
                        groupId = 0L;
                    }
                }
            }
            catch (ClassNotFoundException | SQLException error) {
                LOGGER.warn("Refresh permissions error", (Throwable)error);
            }
        }
    }
}

