/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.model.Position;

public class OutsafeProtocolDecoder
extends BaseHttpProtocolDecoder {
    public OutsafeProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, json.getString("device"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date());
        position.setValid(true);
        position.setLatitude(json.getJsonNumber("latitude").doubleValue());
        position.setLongitude(json.getJsonNumber("longitude").doubleValue());
        position.setAltitude(json.getJsonNumber("altitude").doubleValue());
        position.setCourse(json.getJsonNumber("heading").intValue());
        position.set("rssi", json.getJsonNumber("rssi").intValue());
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

