/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import liquibase.command.CommandResult;
import liquibase.command.core.DiffCommand;
import liquibase.command.core.SnapshotCommand;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.util.StringUtils;

public class DiffToChangeLogCommand
extends DiffCommand {
    private String changeLogFile;
    private PrintStream outputStream;
    private DiffOutputControl diffOutputControl;

    @Override
    public String getName() {
        return "diffChangeLog";
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public DiffToChangeLogCommand setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
        return this;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public DiffToChangeLogCommand setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public DiffOutputControl getDiffOutputControl() {
        return this.diffOutputControl;
    }

    public DiffToChangeLogCommand setDiffOutputControl(DiffOutputControl diffOutputControl) {
        this.diffOutputControl = diffOutputControl;
        return this;
    }

    @Override
    protected CommandResult run() throws Exception {
        SnapshotCommand.logUnsupportedDatabase(this.getReferenceDatabase(), this.getClass());
        DiffResult diffResult = this.createDiffResult();
        PrintStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            outputStream = System.out;
        }
        if (StringUtils.trimToNull(this.changeLogFile) == null) {
            this.createDiffToChangeLogObject(diffResult).print(outputStream);
        } else {
            this.createDiffToChangeLogObject(diffResult).print(this.changeLogFile);
        }
        return new CommandResult("OK");
    }

    protected DiffToChangeLog createDiffToChangeLogObject(DiffResult diffResult) {
        return new DiffToChangeLog(diffResult, this.diffOutputControl);
    }
}

