/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordContext;
import org.parosproxy.paros.db.TableContext;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableContext
extends SqlAbstractTable
implements TableContext {
    private static final String TABLE_NAME = DbSQL.getSQL("context.table_name");
    private static final String DATAID = DbSQL.getSQL("context.field.dataid");
    private static final String CONTEXTID = DbSQL.getSQL("context.field.contextid");
    private static final String TYPE = DbSQL.getSQL("context.field.type");
    private static final String DATA = DbSQL.getSQL("context.field.data");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("context.ps.createtable"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized RecordContext read(long dataId) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized RecordContext insert(int contextId, int type, String url) throws DatabaseException {
        SqlPreparedStatementWrapper psInsert = null;
        try {
            long id;
            psInsert = DbSQL.getSingleton().getPreparedStatement("context.ps.insert");
            psInsert.getPs().setInt(1, contextId);
            psInsert.getPs().setInt(2, type);
            psInsert.getPs().setString(3, url);
            psInsert.getPs().executeUpdate();
            try (ResultSet rs = psInsert.getLastInsertedId();){
                rs.next();
                id = rs.getLong(1);
            }
            RecordContext recordContext = this.read(id);
            return recordContext;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsert);
        }
    }

    @Override
    public synchronized void delete(int contextId, int type, String data) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteData = null;
        try {
            psDeleteData = DbSQL.getSingleton().getPreparedStatement("context.ps.delete");
            psDeleteData.getPs().setInt(1, contextId);
            psDeleteData.getPs().setInt(2, type);
            psDeleteData.getPs().setString(3, data);
            psDeleteData.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteData);
        }
    }

    @Override
    public synchronized void deleteAllDataForContextAndType(int contextId, int type) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteAllDataForContextAndType = null;
        try {
            psDeleteAllDataForContextAndType = DbSQL.getSingleton().getPreparedStatement("context.ps.deletealldataforcontexttype");
            psDeleteAllDataForContextAndType.getPs().setInt(1, contextId);
            psDeleteAllDataForContextAndType.getPs().setInt(2, type);
            psDeleteAllDataForContextAndType.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteAllDataForContextAndType);
        }
    }

    @Override
    public synchronized void deleteAllDataForContext(int contextId) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteAllDataForContext = null;
        try {
            psDeleteAllDataForContext = DbSQL.getSingleton().getPreparedStatement("context.ps.deletealldataforcontext");
            psDeleteAllDataForContext.getPs().setInt(1, contextId);
            psDeleteAllDataForContext.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteAllDataForContext);
        }
    }

    @Override
    public List<RecordContext> getAllData() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllData = null;
        try {
            psGetAllData = DbSQL.getSingleton().getPreparedStatement("context.ps.alldata");
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            try (ResultSet rs = psGetAllData.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            ArrayList<RecordContext> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllData);
        }
    }

    @Override
    public List<RecordContext> getDataForContext(int contextId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllDataForContext = null;
        try {
            psGetAllDataForContext = DbSQL.getSingleton().getPreparedStatement("context.ps.alldataforcontext");
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            psGetAllDataForContext.getPs().setInt(1, contextId);
            try (ResultSet rs = psGetAllDataForContext.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            ArrayList<RecordContext> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllDataForContext);
        }
    }

    @Override
    public List<RecordContext> getDataForContextAndType(int contextId, int type) throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllDataForContextAndType = null;
        try {
            psGetAllDataForContextAndType = DbSQL.getSingleton().getPreparedStatement("context.ps.alldataforcontexttype");
            ArrayList<RecordContext> result = new ArrayList<RecordContext>();
            psGetAllDataForContextAndType.getPs().setInt(1, contextId);
            psGetAllDataForContextAndType.getPs().setInt(2, type);
            try (ResultSet rs = psGetAllDataForContextAndType.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA)));
                }
            }
            ArrayList<RecordContext> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllDataForContextAndType);
        }
    }

    private RecordContext build(ResultSet rs) throws DatabaseException {
        try {
            RecordContext rt = null;
            if (rs.next()) {
                rt = new RecordContext(rs.getLong(DATAID), rs.getInt(CONTEXTID), rs.getInt(TYPE), rs.getString(DATA));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setData(int contextId, int type, List<String> dataList) throws DatabaseException {
        this.deleteAllDataForContextAndType(contextId, type);
        for (String data : dataList) {
            this.insert(contextId, type, data);
        }
    }
}

