/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScript;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptsPassiveScanner
extends PluginPassiveScanner {
    private static final Logger logger = Logger.getLogger(ScriptsPassiveScanner.class);
    private ExtensionScript extension = null;
    private PassiveScanThread parent = null;
    private int currentHRefId;
    private int currentHistoryType;

    @Override
    public String getName() {
        return Constant.messages.getString("pscan.scripts.passivescanner.title");
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class);
        }
        return this.extension;
    }

    @Override
    public int getPluginId() {
        return 50001;
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        if (this.getExtension() != null) {
            this.currentHRefId = id;
            List<ScriptWrapper> scripts = this.extension.getScripts("passive");
            for (ScriptWrapper script : scripts) {
                try {
                    if (!script.isEnabled()) continue;
                    PassiveScript s = this.extension.getInterface(script, PassiveScript.class);
                    if (s != null) {
                        if (!this.appliesToCurrentHistoryType(script, s)) continue;
                        s.scan(this, msg, source);
                        continue;
                    }
                    this.extension.handleFailedScriptInterface(script, Constant.messages.getString("pscan.scripts.interface.passive.error", script.getName()));
                }
                catch (Exception e) {
                    this.extension.handleScriptException(script, e);
                }
            }
        }
    }

    private boolean appliesToCurrentHistoryType(ScriptWrapper wrapper, PassiveScript ps) {
        try {
            return ps.appliesToHistoryType(this.currentHistoryType);
        }
        catch (UndeclaredThrowableException e) {
            if (e.getCause() instanceof NoSuchMethodException && "appliesToHistoryType".equals(e.getCause().getMessage())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Script [Name=" + wrapper.getName() + ", Engine=" + wrapper.getEngineName() + "]  does not implement the optional method appliesToHistoryType: "), (Throwable)e);
                }
                return super.appliesToHistoryType(this.currentHistoryType);
            }
            throw e;
        }
    }

    @Override
    public PluginPassiveScanner.AlertBuilder newAlert() {
        return super.newAlert();
    }

    @Deprecated
    public void raiseAlert(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, int cweId, int wascId, HttpMessage msg) {
        this.raiseAlert(risk, confidence, name, description, uri, param, attack, otherInfo, solution, evidence, null, cweId, wascId, msg);
    }

    @Deprecated
    public void raiseAlert(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, String reference, int cweId, int wascId, HttpMessage msg) {
        this.newAlert().setRisk(risk).setConfidence(confidence).setName(name).setDescription(description).setParam(param).setOtherInfo(otherInfo).setSolution(solution).setReference(reference).setEvidence(evidence).setCweId(cweId).setWascId(wascId).setMessage(msg).raise();
    }

    public void addTag(String tag) {
        this.parent.addTag(this.currentHRefId, tag);
    }

    @Override
    public void setParent(PassiveScanThread parent) {
        this.parent = parent;
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        this.currentHistoryType = historyType;
        return true;
    }
}

