(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define gerbil/tools/gxtags#main
    (lambda _args5012_
      (letrec* ((_gopt5014_
                 (std/getopt#getopt
                  (std/getopt#flag__%__0
                   '#f
                   '"append to existing tag file"
                   'append
                   '"-a")
                  (std/getopt#option__%__0
                   '#f
                   '"explicit name of file for tag table"
                   absent-value
                   '"TAGS"
                   'output
                   '"-o")
                  (std/getopt#flag__%__%
                   '#f
                   '"display help"
                   'help
                   '"-h"
                   '"--help")
                  (std/getopt#rest-arguments__%
                   '#f
                   '"source file or directory"
                   absent-value
                   'input)))
                (_help5015_
                 (lambda (_what5031_)
                   (std/getopt#getopt-display-help__0 _what5031_ '"gxtags"))))
        (with-exception-catcher
         (lambda (_g50165018_)
           (if ((lambda (_$obj5021_)
                  (##structure-instance-of?
                   _$obj5021_
                   'std/getopt#getopt-error::t))
                _g50165018_)
               (let ((_exn5024_ _g50165018_)) (_help5015_ _exn5024_) (exit '1))
               (raise _g50165018_)))
         (lambda ()
           (let ((_opt5027_ (std/getopt#getopt-parse _gopt5014_ _args5012_)))
             (if (table-ref _opt5027_ 'help '#f)
                 (_help5015_ _gopt5014_)
                 (let ((_inputs5029_ (table-ref _opt5027_ 'input '#f)))
                   (if (null? _inputs5029_)
                       (begin (_help5015_ _gopt5014_) (exit '1))
                       (gerbil/tools/gxtags#run
                        (table-ref _opt5027_ 'input '#f)
                        (table-ref _opt5027_ 'output '#f)
                        (table-ref _opt5027_ 'append '#f)))))))))))
  (define gerbil/tools/gxtags#run
    (lambda (_inputs5008_ _tagfile5009_ _append?5010_)
      (_gx#load-expander!)
      (gerbil/tools/gxtags#make-tags__%
       _inputs5008_
       _tagfile5009_
       _append?5010_)))
  (define gerbil/tools/gxtags#current-tags-path (make-parameter '#f))
  (define gerbil/tools/gxtags#make-tags__%
    (lambda (_inputs4985_ _tagfile4986_ _append?4987_)
      (call-with-output-file
       (cons 'path:
             (cons _tagfile4986_ (cons 'append: (cons _append?4987_ '()))))
       (lambda (_output4989_)
         (call-with-parameters
          (lambda ()
            (for-each
             (lambda (_g49914993_)
               (gerbil/tools/gxtags#tag-input _g49914993_ _output4989_))
             _inputs4985_))
          gerbil/tools/gxtags#current-tags-path
          (path-normalize _tagfile4986_))))))
  (define gerbil/tools/gxtags#make-tags__0
    (lambda (_inputs4999_ _tagfile5000_)
      (let ((_append?5002_ '#f))
        (gerbil/tools/gxtags#make-tags__%
         _inputs4999_
         _tagfile5000_
         _append?5002_))))
  (define gerbil/tools/gxtags#make-tags
    (lambda _g5396_
      (let ((_g5395_ (length _g5396_)))
        (cond ((##fx= _g5395_ 2)
               (apply gerbil/tools/gxtags#make-tags__0 _g5396_))
              ((##fx= _g5395_ 3)
               (apply gerbil/tools/gxtags#make-tags__% _g5396_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxtags#make-tags
                _g5396_))))))
  (define gerbil/tools/gxtags#file-directory?
    (lambda (_path4982_) (eq? (file-type _path4982_) 'directory)))
  (define gerbil/tools/gxtags#tag-input
    (lambda (_input4979_ _output4980_)
      (if (file-exists? _input4979_)
          (if (gerbil/tools/gxtags#file-directory? _input4979_)
              (gerbil/tools/gxtags#tag-directory _input4979_ _output4980_)
              (gerbil/tools/gxtags#tag-source-file _input4979_ _output4980_))
          (error '"No such file or directory" _input4979_))))
  (define gerbil/tools/gxtags#tag-directory
    (lambda (_dirname4967_ _output4968_)
      (let ((_files4970_
             (std/sort#sort (directory-files _dirname4967_) string<?)))
        (for-each
         (lambda (_file4972_)
           (let ((_path4974_ (path-expand _file4972_ _dirname4967_)))
             (if (or (gerbil/tools/gxtags#file-directory? _path4974_)
                     (member (path-extension _path4974_) '(".ss" ".ssi")))
                 (gerbil/tools/gxtags#tag-input _path4974_ _output4968_)
                 '#!void)))
         _files4970_))))
  (define gerbil/tools/gxtags#tag-source-file
    (lambda (_filename4949_ _output4950_)
      (let ((_$e4952_ (gerbil/tools/gxtags#try-import-module _filename4949_)))
        (if _$e4952_
            ((lambda (_ctx4955_)
               (displayln '"TAG " _filename4949_)
               (let ((_xtab4957_ (make-table 'test: eq?)))
                 (for-each
                  (lambda (_xport4959_)
                    (let ((_bind4961_
                           (gx#core-resolve-module-export _xport4959_)))
                      (hash-update!
                       _xtab4957_
                       (##structure-ref _bind4961_ '1 gx#binding::t '#f)
                       (lambda (_g49624964_)
                         (cons (##direct-structure-ref
                                _xport4959_
                                '4
                                gx#module-export::t
                                '#f)
                               _g49624964_))
                       '())))
                  (##structure-ref _ctx4955_ '9 gx#module-context::t '#f))
                 (gerbil/tools/gxtags#write-tags
                  (gerbil/tools/gxtags#module-tags _ctx4955_ _xtab4957_)
                  _filename4949_
                  _output4950_)))
             _$e4952_)
            (displayln '"SKIP " _filename4949_)))))
  (define gerbil/tools/gxtags#module-tags
    (lambda (_ctx4202_ _xtab4203_)
      (letrec* ((_tags4205_ '())
                (_loc4206_ '#f)
                (_tag!4350_
                 (lambda (_eid4946_ _name4947_)
                   (set! _tags4205_
                         (cons (cons _eid4946_
                                     (cons _name4947_ (cons _loc4206_ '())))
                               _tags4205_))))
                (_tag-e4351_
                 (lambda (_stx4460_)
                   (let* ((_K4937_ (lambda ()
                                     (let* ((___stx52425243_ _stx4460_)
                                            (_g44694560_
                                             (lambda ()
                                               (gx#raise-syntax-error
                                                '#f
                                                '"Bad syntax"
                                                ___stx52425243_))))
                                       (let ((___kont52445245_
                                              (lambda (_L4914_)
                                                (for-each
                                                 _tag-e4351_
                                                 (foldr1 (lambda (_g49264929_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _g49274931_)
                   (cons _g49264929_ _g49274931_))
                 '()
                 _L4914_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (___kont52485249_
                                              (lambda (_L4856_)
                                                (call-with-parameters
                                                 (lambda ()
                                                   (for-each
                                                    _tag-e4351_
                                                    (foldr1 (lambda (_g48694872_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             _g48704874_)
                      (cons _g48694872_ _g48704874_))
                    '()
                    _L4856_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 gx#current-expander-phi
                                                 (fx+ (gx#current-expander-phi)
                                                      '1))))
                                             (___kont52525253_
                                              (lambda (_L4795_)
                                                (for-each
                                                 _tag-def4352_
                                                 (filter values
                                                         (foldr1 (lambda (_g48114814_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                  _g48124816_)
                           (cons _g48114814_ _g48124816_))
                         '()
                         _L4795_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (___kont52565257_
                                              (lambda (_L4729_)
                                                (_tag-def4352_ _L4729_)))
                                             (___kont52585259_
                                              (lambda (_L4680_)
                                                (for-each
                                                 _tag-decl4353_
                                                 (foldr1 (lambda (_g46924695_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _g46934697_)
                   (cons _g46924695_ _g46934697_))
                 '()
                 _L4680_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (___kont52625263_
                                              (lambda (_L4612_ _L4613_)
                                                (let ((_eid4632_
                                                       (##structure-ref
                                                        (gx#resolve-identifier__0
                                                         _L4613_)
                                                        '1
                                                        gx#binding::t
                                                        '#f))
                                                      (_ctx4633_
                                                       (gx#syntax-local-e__0
                                                        _L4613_)))
                                                  (call-with-parameters
                                                   (lambda ()
                                                     (_tag-name!4354_
                                                      _eid4632_)
                                                     (for-each
                                                      _tag-e4351_
                                                      (foldr1 (lambda (_g46354638_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                               _g46364640_)
                        (cons _g46354638_ _g46364640_))
                      '()
                      _L4612_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   gx#current-expander-context
                                                   _ctx4633_))))
                                             (___kont52665267_
                                              (lambda () '#!void)))
                                         (let* ((___match53935394_
                                                 (lambda (_e45414572_
                                                          _hd45424575_
                                                          _tl45434577_
                                                          _e45444580_
                                                          _hd45454583_
                                                          _tl45464585_
                                                          ___splice52645265_
                                                          _target45474588_
                                                          _tl45494590_)
                                                   (letrec ((_loop45504593_
                                                             (lambda (_hd45484596_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _expr45544598_)
                       (if (gx#stx-pair? _hd45484596_)
                           (let ((_e45514601_ (gx#stx-e _hd45484596_)))
                             (let ((_lp-tl45534606_ (##cdr _e45514601_))
                                   (_lp-hd45524604_ (##car _e45514601_)))
                               (_loop45504593_
                                _lp-tl45534606_
                                (cons _lp-hd45524604_ _expr45544598_))))
                           (let ((_expr45554609_ (reverse _expr45544598_)))
                             (___kont52625263_
                              _expr45554609_
                              _hd45454583_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop45504593_
                                                      _target45474588_
                                                      '()))))
                                                (___match53695370_
                                                 (lambda (_e45274648_
                                                          _hd45284651_
                                                          _tl45294653_
                                                          ___splice52605261_
                                                          _target45304656_
                                                          _tl45324658_)
                                                   (letrec ((_loop45334661_
                                                             (lambda (_hd45314664_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _decl45374666_)
                       (if (gx#stx-pair? _hd45314664_)
                           (let ((_e45344669_ (gx#stx-e _hd45314664_)))
                             (let ((_lp-tl45364674_ (##cdr _e45344669_))
                                   (_lp-hd45354672_ (##car _e45344669_)))
                               (_loop45334661_
                                _lp-tl45364674_
                                (cons _lp-hd45354672_ _decl45374666_))))
                           (let ((_decl45384677_ (reverse _decl45374666_)))
                             (___kont52585259_ _decl45384677_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop45334661_
                                                      _target45304656_
                                                      '()))))
                                                (___match53275328_
                                                 (lambda (_e44984747_
                                                          _hd44994750_
                                                          _tl45004752_
                                                          _e45014755_
                                                          _hd45024758_
                                                          _tl45034760_
                                                          ___splice52545255_
                                                          _target45044763_
                                                          _tl45064765_)
                                                   (letrec ((_loop45074768_
                                                             (lambda (_hd45054771_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _id45114773_)
                       (if (gx#stx-pair? _hd45054771_)
                           (let ((_e45084776_ (gx#stx-e _hd45054771_)))
                             (let ((_lp-tl45104781_ (##cdr _e45084776_))
                                   (_lp-hd45094779_ (##car _e45084776_)))
                               (_loop45074768_
                                _lp-tl45104781_
                                (cons _lp-hd45094779_ _id45114773_))))
                           (let ((_id45124784_ (reverse _id45114773_)))
                             (if (gx#stx-pair? _tl45034760_)
                                 (let ((_e45134787_ (gx#stx-e _tl45034760_)))
                                   (let ((_tl45154792_ (##cdr _e45134787_))
                                         (_hd45144790_ (##car _e45134787_)))
                                     (if (gx#stx-null? _tl45154792_)
                                         (___kont52525253_ _id45124784_)
                                         (___kont52665267_))))
                                 (___kont52665267_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop45074768_
                                                      _target45044763_
                                                      '()))))
                                                (___match53035304_
                                                 (lambda (_e44854824_
                                                          _hd44864827_
                                                          _tl44874829_
                                                          ___splice52505251_
                                                          _target44884832_
                                                          _tl44904834_)
                                                   (letrec ((_loop44914837_
                                                             (lambda (_hd44894840_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _expr44954842_)
                       (if (gx#stx-pair? _hd44894840_)
                           (let ((_e44924845_ (gx#stx-e _hd44894840_)))
                             (let ((_lp-tl44944850_ (##cdr _e44924845_))
                                   (_lp-hd44934848_ (##car _e44924845_)))
                               (_loop44914837_
                                _lp-tl44944850_
                                (cons _lp-hd44934848_ _expr44954842_))))
                           (let ((_expr44964853_ (reverse _expr44954842_)))
                             (___kont52485249_ _expr44964853_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop44914837_
                                                      _target44884832_
                                                      '()))))
                                                (___match52855286_
                                                 (lambda (_e44724882_
                                                          _hd44734885_
                                                          _tl44744887_
                                                          ___splice52465247_
                                                          _target44754890_
                                                          _tl44774892_)
                                                   (letrec ((_loop44784895_
                                                             (lambda (_hd44764898_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _expr44824900_)
                       (if (gx#stx-pair? _hd44764898_)
                           (let ((_e44794903_ (gx#stx-e _hd44764898_)))
                             (let ((_lp-tl44814908_ (##cdr _e44794903_))
                                   (_lp-hd44804906_ (##car _e44794903_)))
                               (_loop44784895_
                                _lp-tl44814908_
                                (cons _lp-hd44804906_ _expr44824900_))))
                           (let ((_expr44834911_ (reverse _expr44824900_)))
                             (___kont52445245_ _expr44834911_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop44784895_
                                                      _target44754890_
                                                      '())))))
                                           (if (gx#stx-pair? ___stx52425243_)
                                               (let ((_e44724882_
                                                      (gx#stx-e
                                                       ___stx52425243_)))
                                                 (let ((_tl44744887_
                                                        (##cdr _e44724882_))
                                                       (_hd44734885_
                                                        (##car _e44724882_)))
                                                   (if (gx#identifier?
                                                        _hd44734885_)
                                                       (if (gx#stx-eq?
                                                            '%#begin
                                                            _hd44734885_)
                                                           (if (gx#stx-pair/null?
                                                                _tl44744887_)
                                                               (let ((___splice52465247_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              (gx#syntax-split-splice _tl44744887_ '0)))
                         (let ((_tl44774892_
                                (##vector-ref ___splice52465247_ '1))
                               (_target44754890_
                                (##vector-ref ___splice52465247_ '0)))
                           (if (gx#stx-null? _tl44774892_)
                               (___match52855286_
                                _e44724882_
                                _hd44734885_
                                _tl44744887_
                                ___splice52465247_
                                _target44754890_
                                _tl44774892_)
                               (___kont52665267_))))
                       (___kont52665267_))
                   (if (gx#stx-eq? '%#begin-syntax _hd44734885_)
                       (if (gx#stx-pair/null? _tl44744887_)
                           (let ((___splice52505251_
                                  (gx#syntax-split-splice _tl44744887_ '0)))
                             (let ((_tl44904834_
                                    (##vector-ref ___splice52505251_ '1))
                                   (_target44884832_
                                    (##vector-ref ___splice52505251_ '0)))
                               (if (gx#stx-null? _tl44904834_)
                                   (___match53035304_
                                    _e44724882_
                                    _hd44734885_
                                    _tl44744887_
                                    ___splice52505251_
                                    _target44884832_
                                    _tl44904834_)
                                   (___kont52665267_))))
                           (___kont52665267_))
                       (if (gx#stx-eq? '%#define-values _hd44734885_)
                           (if (gx#stx-pair? _tl44744887_)
                               (let ((_e45014755_ (gx#stx-e _tl44744887_)))
                                 (let ((_tl45034760_ (##cdr _e45014755_))
                                       (_hd45024758_ (##car _e45014755_)))
                                   (if (gx#stx-pair/null? _hd45024758_)
                                       (let ((___splice52545255_
                                              (gx#syntax-split-splice
                                               _hd45024758_
                                               '0)))
                                         (let ((_tl45064765_
                                                (##vector-ref
                                                 ___splice52545255_
                                                 '1))
                                               (_target45044763_
                                                (##vector-ref
                                                 ___splice52545255_
                                                 '0)))
                                           (if (gx#stx-null? _tl45064765_)
                                               (___match53275328_
                                                _e44724882_
                                                _hd44734885_
                                                _tl44744887_
                                                _e45014755_
                                                _hd45024758_
                                                _tl45034760_
                                                ___splice52545255_
                                                _target45044763_
                                                _tl45064765_)
                                               (___kont52665267_))))
                                       (___kont52665267_))))
                               (___kont52665267_))
                           (if (gx#stx-eq? '%#define-syntax _hd44734885_)
                               (if (gx#stx-pair? _tl44744887_)
                                   (let ((_e45204713_ (gx#stx-e _tl44744887_)))
                                     (let ((_tl45224718_ (##cdr _e45204713_))
                                           (_hd45214716_ (##car _e45204713_)))
                                       (if (gx#stx-pair? _tl45224718_)
                                           (let ((_e45234721_
                                                  (gx#stx-e _tl45224718_)))
                                             (let ((_tl45254726_
                                                    (##cdr _e45234721_))
                                                   (_hd45244724_
                                                    (##car _e45234721_)))
                                               (if (gx#stx-null? _tl45254726_)
                                                   (___kont52565257_
                                                    _hd45214716_)
                                                   (___kont52665267_))))
                                           (___kont52665267_))))
                                   (___kont52665267_))
                               (if (gx#stx-eq? '%#extern _hd44734885_)
                                   (if (gx#stx-pair/null? _tl44744887_)
                                       (let ((___splice52605261_
                                              (gx#syntax-split-splice
                                               _tl44744887_
                                               '0)))
                                         (let ((_tl45324658_
                                                (##vector-ref
                                                 ___splice52605261_
                                                 '1))
                                               (_target45304656_
                                                (##vector-ref
                                                 ___splice52605261_
                                                 '0)))
                                           (if (gx#stx-null? _tl45324658_)
                                               (___match53695370_
                                                _e44724882_
                                                _hd44734885_
                                                _tl44744887_
                                                ___splice52605261_
                                                _target45304656_
                                                _tl45324658_)
                                               (___kont52665267_))))
                                       (___kont52665267_))
                                   (if (gx#stx-eq? '%#module _hd44734885_)
                                       (if (gx#stx-pair? _tl44744887_)
                                           (let ((_e45444580_
                                                  (gx#stx-e _tl44744887_)))
                                             (let ((_tl45464585_
                                                    (##cdr _e45444580_))
                                                   (_hd45454583_
                                                    (##car _e45444580_)))
                                               (if (gx#stx-pair/null?
                                                    _tl45464585_)
                                                   (let ((___splice52645265_
                                                          (gx#syntax-split-splice
                                                           _tl45464585_
                                                           '0)))
                                                     (let ((_tl45494590_
                                                            (##vector-ref
                                                             ___splice52645265_
                                                             '1))
                                                           (_target45474588_
                                                            (##vector-ref
                                                             ___splice52645265_
                                                             '0)))
                                                       (if (gx#stx-null?
                                                            _tl45494590_)
                                                           (___match53935394_
                                                            _e44724882_
                                                            _hd44734885_
                                                            _tl44744887_
                                                            _e45444580_
                                                            _hd45454583_
                                                            _tl45464585_
                                                            ___splice52645265_
                                                            _target45474588_
                                                            _tl45494590_)
                                                           (___kont52665267_))))
                                                   (___kont52665267_))))
                                           (___kont52665267_))
                                       (___kont52665267_)))))))
               (___kont52665267_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                               (___kont52665267_)))))))
                          (_new-loc4940_ (gx#stx-source _stx4460_)))
                     (if _new-loc4940_
                         (let ((_save-loc4943_ _loc4206_))
                           (set! _loc4206_ _new-loc4940_)
                           (_K4937_)
                           (set! _loc4206_ _save-loc4943_))
                         (_K4937_)))))
                (_tag-def4352_
                 (lambda (_id4448_)
                   (let* ((_K4451_ (lambda ()
                                     (_tag-name!4354_
                                      (##structure-ref
                                       (gx#resolve-identifier__0 _id4448_)
                                       '1
                                       gx#binding::t
                                       '#f))))
                          (_new-loc4454_ (gx#stx-source _id4448_)))
                     (if _new-loc4454_
                         (let ((_save-loc4457_ _loc4206_))
                           (set! _loc4206_ _new-loc4454_)
                           (_K4451_)
                           (set! _loc4206_ _save-loc4457_))
                         (_K4451_)))))
                (_tag-decl4353_
                 (lambda (_decl4384_)
                   (let* ((_g43864400_
                           (lambda (_g43874397_)
                             (gx#raise-syntax-error
                              '#f
                              '"Bad syntax"
                              _g43874397_)))
                          (_g43854445_
                           (lambda (_g43874403_)
                             (if (gx#stx-pair? _g43874403_)
                                 (let ((_e43904405_ (gx#stx-e _g43874403_)))
                                   (let ((_hd43914408_ (##car _e43904405_))
                                         (_tl43924410_ (##cdr _e43904405_)))
                                     (if (gx#stx-pair? _tl43924410_)
                                         (let ((_e43934413_
                                                (gx#stx-e _tl43924410_)))
                                           (let ((_hd43944416_
                                                  (##car _e43934413_))
                                                 (_tl43954418_
                                                  (##cdr _e43934413_)))
                                             (if (gx#stx-null? _tl43954418_)
                                                 ((lambda (_L4421_ _L4422_)
                                                    (let* ((_K4436_ (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              (_tag-name!4354_ (gx#stx-e _L4421_))))
                   (_new-loc4439_ (gx#stx-source _L4422_)))
              (if _new-loc4439_
                  (let ((_save-loc4442_ _loc4206_))
                    (set! _loc4206_ _new-loc4439_)
                    (_K4436_)
                    (set! _loc4206_ _save-loc4442_))
                  (_K4436_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  _hd43944416_
                                                  _hd43914408_)
                                                 (_g43864400_ _g43874403_))))
                                         (_g43864400_ _g43874403_))))
                                 (_g43864400_ _g43874403_)))))
                     (_g43854445_ _decl4384_))))
                (_tag-name!4354_
                 (lambda (_eid4374_)
                   (let ((_names43754377_
                          (table-ref _xtab4203_ _eid4374_ '#f)))
                     (if _names43754377_
                         (let ((_names4380_ _names43754377_))
                           (for-each
                            (lambda (_name4382_)
                              (_tag!4350_ _eid4374_ _name4382_))
                            (std/srfi/1#delete-duplicates _names4380_ eq?)))
                         '#f)))))
        (let ((_stx4356_
               (##structure-ref _ctx4202_ '11 gx#module-context::t '#f)))
          (let* ((_id4358_
                  (##structure-ref _ctx4202_ '1 gx#expander-context::t '#f))
                 (_gid4360_ (make-symbol '":" _id4358_)))
            (let* ((_K4364_ (lambda () (_tag!4350_ 'module _gid4360_)))
                   (_new-loc4367_ (gx#stx-source _stx4356_)))
              (if _new-loc4367_
                  (let ((_save-loc4370_ _loc4206_))
                    (set! _loc4206_ _new-loc4367_)
                    (_K4364_)
                    (set! _loc4206_ _save-loc4370_))
                  (_K4364_))))
          (call-with-parameters
           (lambda () (_tag-e4351_ _stx4356_))
           gx#current-expander-context
           _ctx4202_
           gx#current-expander-phi
           '0)
          (std/srfi/1#reverse! _tags4205_)))))
  (define gerbil/tools/gxtags#write-tags
    (lambda (_tags4117_ _filename4118_ _output4119_)
      (let* ((_lines4121_
              (std/misc/ports#read-file-lines__%
               '#f
               absent-value
               _filename4118_))
             (_lines4123_
              (if (null? _lines4121_) '#("") (list->vector _lines4121_)))
             (_offsets4125_
              (gerbil/tools/gxtags#file-line-offsets _filename4118_))
             (_tmp4127_ (open-output-string))
             (_filepath4129_ (path-normalize _filename4118_))
             (_rfilepath4131_
              (path-normalize
               _filepath4129_
               '#t
               (gerbil/tools/gxtags#current-tags-path)))
             (_out-of-file-tags4133_ '()))
        (for-each
         (lambda (_tag4136_)
           (let* ((_tag41374148_ _tag4136_)
                  (_E41394152_
                   (lambda () (error '"No clause matching" _tag41374148_)))
                  (_K41404170_
                   (lambda (_loc4155_ _name4156_)
                     (let ((_path4158_ (source-location-path _loc4155_)))
                       (if (or (equal? _path4158_ _filepath4129_)
                               (not _path4158_))
                           (let* ((_line4163_
                                   (gerbil/tools/gxtags#source-location-line
                                    _loc4155_))
                                  (_anchor4165_
                                   (vector-ref
                                    _lines4123_
                                    (fx- _line4163_ '1)))
                                  (_offset4167_
                                   (vector-ref
                                    _offsets4125_
                                    (fx- _line4163_ '1))))
                             (gerbil/gambit/ports#write-string__%
                              _anchor4165_
                              _tmp4127_)
                             (write-char '#\delete _tmp4127_)
                             (display _name4156_ _tmp4127_)
                             (write-char '#\x1 _tmp4127_)
                             (display _line4163_ _tmp4127_)
                             (write-char '#\, _tmp4127_)
                             (display _offset4167_ _tmp4127_)
                             (newline _tmp4127_))
                           (set! _out-of-file-tags4133_
                                 (cons _tag4136_ _out-of-file-tags4133_)))))))
             (if (##pair? _tag41374148_)
                 (let ((_tl41424173_ (##cdr _tag41374148_)))
                   (if (##pair? _tl41424173_)
                       (let ((_hd41434176_ (##car _tl41424173_))
                             (_tl41444178_ (##cdr _tl41424173_)))
                         (let ((_name4181_ _hd41434176_))
                           (if (##pair? _tl41444178_)
                               (let ((_hd41454183_ (##car _tl41444178_))
                                     (_tl41464185_ (##cdr _tl41444178_)))
                                 (let ((_loc4188_ _hd41454183_))
                                   (if (##null? _tl41464185_)
                                       (_K41404170_ _loc4188_ _name4181_)
                                       (_E41394152_))))
                               (_E41394152_))))
                       (_E41394152_)))
                 (_E41394152_))))
         _tags4117_)
        (let* ((_str4190_ (get-output-string _tmp4127_))
               (_len4192_ (std/text/utf8#string-utf8-length__0 _str4190_)))
          (write-char '#\page _output4119_)
          (newline _output4119_)
          (gerbil/gambit/ports#write-string__% _rfilepath4131_ _output4119_)
          (write-char '#\, _output4119_)
          (display _len4192_ _output4119_)
          (newline _output4119_)
          (gerbil/gambit/ports#write-string__% _str4190_ _output4119_)
          (if (null? _out-of-file-tags4133_)
              '#!void
              (let* ((_tags4195_ (std/srfi/1#reverse! _out-of-file-tags4133_))
                     (_path4197_ (source-location-path (caddar _tags4195_)))
                     (_filename4199_ (path-normalize _path4197_ '#t)))
                (gerbil/tools/gxtags#write-tags
                 _tags4195_
                 _filename4199_
                 _output4119_)))))))
  (define gerbil/tools/gxtags#+nl+ (char->integer '#\newline))
  (define gerbil/tools/gxtags#file-line-offsets
    (lambda (_filename4104_)
      (call-with-input-file
       _filename4104_
       (lambda (_inp4106_)
         (let _lp4108_ ((_i4110_ '0) (_offs4111_ (cons '0 '())))
           (let ((_next4113_ (read-u8 _inp4106_)))
             (if (eof-object? _next4113_)
                 (list->vector (std/srfi/1#reverse! _offs4111_))
                 (if (eq? _next4113_ gerbil/tools/gxtags#+nl+)
                     (let ((_i+14115_ (fx+ _i4110_ '1)))
                       (_lp4108_ _i+14115_ (cons _i+14115_ _offs4111_)))
                     (_lp4108_ (fx+ _i4110_ '1) _offs4111_)))))))))
  (define gerbil/tools/gxtags#source-location-line
    (lambda (_locat4100_)
      (let ((_filepos4102_
             (##position->filepos (##locat-position _locat4100_))))
        (fx+ (##filepos-line _filepos4102_) '1))))
  (define gerbil/tools/gxtags#try-import-module
    (lambda (_filename4091_)
      (with-exception-catcher
       (lambda (_g40924094_)
         (if '#t (let ((_e4097_ _g40924094_)) '#f) (raise _g40924094_)))
       (lambda () (gx#import-module__0 _filename4091_))))))
