# Grantlee CMake configuration file - http://www.grantlee.org/

# Any changes in this file will be overwritten by CMake.

get_filename_component(GrantleeRootDir ${CMAKE_CURRENT_LIST_DIR}/../../../ ABSOLUTE) # get the chosen install prefix

set(Grantlee_Qt5_TRANSITIONAL OFF)

if (Grantlee_FIND_COMPONENTS)
  foreach( component ${Grantlee_FIND_COMPONENTS})
    if (component STREQUAL "Textdocument")
      if (Grantlee_Qt5_TRANSITIONAL)
        set(RequiredQtComponents ${RequiredQtComponents} Gui)
      else()
        set(RequiredQtComponents ${RequiredQtComponents} QtCore QtGui)
      endif()
    endif()
    if (component STREQUAL "Templates")
      if (Grantlee_Qt5_TRANSITIONAL)
        set(RequiredQtComponents ${RequiredQtComponents} Core)
      else()
        set(RequiredQtComponents ${RequiredQtComponents} QtCore)
      endif()
    endif()
  endforeach()
  if (Grantlee_Qt5_TRANSITIONAL)
    find_package(Qt5 REQUIRED ${RequiredQtComponents})
  else()
    find_package(Qt4 REQUIRED ${RequiredQtComponents})
  endif()
else()
  if (Grantlee_Qt5_TRANSITIONAL)
    find_package(Qt5Gui REQUIRED)
  else()
    find_package(Qt4 REQUIRED)
  endif()
endif()

set(Grantlee_MIN_PLUGIN_VERSION "0.1")

set(Grantlee_INSTALL_PREFIX "${GrantleeRootDir}")
set(Grantlee_INCLUDE_DIRS   "${GrantleeRootDir}/include/grantlee4")

set(Grantlee_LIBRARY_DIR    "${GrantleeRootDir}/lib")
set(Grantlee_MODULE_DIR     "${Grantlee_LIBRARY_DIR}/cmake/grantlee")

set(Grantlee_PLUGIN_DIR     "${Grantlee_LIBRARY_DIR}")

set(Grantlee_TEMPLATES_LIBRARY grantlee_core)
set(Grantlee_TEXTDOCUMENT_LIBRARY grantlee_gui)

set(Grantlee_TEMPLATES_LIBRARIES ${Grantlee_TEMPLATES_LIBRARY} )
set(Grantlee_TEXTDOCUMENT_LIBRARIES ${Grantlee_TEXTDOCUMENT_LIBRARY} )

# For backwards compatibility
set(Grantlee_CORE_LIBRARY ${Grantlee_TEMPLATES_LIBRARY})
set(Grantlee_CORE_LIBRARIES ${Grantlee_TEMPLATES_LIBRARIES})
set(Grantlee_GUI_LIBRARY ${Grantlee_TEXTDOCUMENT_LIBRARY})
set(Grantlee_GUI_LIBRARIES ${Grantlee_TEXTDOCUMENT_LIBRARIES})
set(Grantlee_PLUGIN_PATH ${Grantlee_PLUGIN_DIR})

# Now for the use file, which contains useful functions, sets up the project
set(Grantlee_USE_FILE "${CMAKE_CURRENT_LIST_DIR}/GrantleeUse.cmake")

include(${CMAKE_CURRENT_LIST_DIR}/GrantleeTargets.cmake)
