
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1090
 * transforms:
 *    ('imul', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b@32') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('udiv', 'a', '#b@32(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b@32(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fabs', 'a')) => ('fabs', 'a')
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('usadd_4x8', 'a', 0) => a
 *    ('usadd_4x8', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8', 'a', 0) => 0
 *    ('umul_unorm_4x8', 'a', -1) => a
 *    ('fmul', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', ('fadd', 'a', 'b'), ('fadd', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('~fadd', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('ffma', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~fadd', ('fmul', 'a', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i32', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615L), ('iand', 'c', 18446744073709551615L)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615L), ('iand', 'c', 18446744073709551615L)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615L), ('iand', 'c', 18446744073709551615L)), 63))
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('~inot', ('flt', 'a', 'b')) => ('fge', 'a', 'b')
 *    ('~inot', ('fge', 'a', 'b')) => ('flt', 'a', 'b')
 *    ('inot', ('feq', 'a', 'b')) => ('fne', 'a', 'b')
 *    ('inot', ('fne', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fne', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fne', ('fneg', 'a'), ('fneg', 'b')) => ('fne', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fne', ('fneg', 'a'), -1.0) => ('fne', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('flt', 'a', 'b')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('fge', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('fge', 'b', 'a')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fne', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fne', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', ('fsat(is_used_once)', 'a'), 1.0) => ('flt', 'a', 1.0)
 *    ('fge', 0.0, ('fsat(is_used_once)', 'a')) => ('fge', 0.0, 'a')
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fne', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fne', ('fmax', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fne', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fne', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fne', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fne', ('fmin', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fne', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fne', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fne', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fne', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmax', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fmin', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fne', ('fadd', 'a', 'b'), 'a') => ('fne', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fne', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fne', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fne', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fne', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('fge', ('fmin', ('fneg', ('b2f', 'a@1')), 'b@1'), 0.0) => ('iand', ('inot', 'a'), ('fge', 'b', 0.0))
 *    ('feq', ('fmin', ('fneg', ('b2f', 'a@1')), 'b@1'), 0.0) => ('iand', ('inot', 'a'), ('fge', 'b', 0.0))
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fne', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fne', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fne', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fne', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fne', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('ior', ('flt', 'a', 0.0), ('flt', 1.0, 'a')) => ('fne', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('fmin', 'a', 'a') => a
 *    ('fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umax', 'a', 'a') => a
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('~fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b@32(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmin', ('fsat', 'a'), '#b@32(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('~ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmax', 'b', 'c'))
 *    ('~ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmin', 'a', 'b'), 'c')
 *    ('~ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmin', 'b', 'c'))
 *    ('~ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmax', 'a', 'b'), 'c')
 *    ('~ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('fmax', 'b', 'c'))
 *    ('~ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('fmin', 'a', 'b'), 'c')
 *    ('~ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('fmin', 'b', 'c'))
 *    ('~ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('~iand', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('~ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('ior', 1065353216, ('iand', 'a', 2147483648))
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i32', 'a@1')), ('ineg', ('b2i32', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i32', ('ine', 'a@1', 'b@1')) => ('b2i32', ('ixor', 'a', 'b'))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a@32', 'b@32'), 0)
 *    ('~flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('~flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('~flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('~flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fne', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fne', ('fneg', 'a'), 'a') => ('fne', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('flt', ('fsub', 0.0, ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('iand', 255, ('ushr@32', 'a', 24)) => ('ushr', 'a', 24)
 *    ('iand', 65535, ('ushr@32', 'a', 16)) => ('ushr', 'a', 16)
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('ige', ('f2u', 'a'), 'b') => ('ige', ('f2i', 'a'), 'b')
 *    ('ige', 'b', ('f2u', 'a')) => ('ige', 'b', ('f2i', 'a'))
 *    ('ilt', ('f2u', 'a'), 'b') => ('ilt', ('f2i', 'a'), 'b')
 *    ('ilt', 'b', ('f2u', 'a')) => ('ilt', 'b', ('f2i', 'a'))
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fne', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('~fge', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('fge', 'b(is_not_positive)', 'a(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('~fge', 'b(is_not_negative)', 'a(is_not_positive)') => True
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('~flt', 'b(is_not_positive)', 'a(is_gt_zero)') => True
 *    ('~flt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('flt', 'b(is_not_negative)', 'a(is_not_positive)') => False
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'b(is_not_positive)', 'a(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ige', 'b(is_not_negative)', 'a(is_not_positive)') => True
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'b(is_not_positive)', 'a(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ilt', 'b(is_not_negative)', 'a(is_not_positive)') => False
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320L)) => ('unpack_64_2x32_split_y', 'a')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('~fsub', 'a', ('fsub', 0.0, 'b')) => ('fadd', 'a', 'b')
 *    ('isub', 'a', ('isub', 0, 'b')) => ('iadd', 'a', 'b')
 *    ('ussub_4x8', 'a', 0) => a
 *    ('ussub_4x8', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('fneg', 'a') => ('fsub', 0.0, 'a')
 *    ('ineg', 'a') => ('isub', 0, 'a')
 *    ('~fadd', 'a', ('fsub', 0.0, 'b')) => ('fsub', 'a', 'b')
 *    ('iadd', 'a', ('isub', 0, 'b')) => ('isub', 'a', 'b')
 *    ('fabs', ('fsub', 0.0, 'a')) => ('fabs', 'a')
 *    ('iabs', ('isub', 0, 'a')) => ('iabs', 'a')
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('fmod@16', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('fmod@32', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry@32', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow@32', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('fsign', 'a') => ('fsub', ('b2f', ('flt', 0.0, 'a')), ('b2f', ('flt', 'a', 0.0)))
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807L, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808L, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807L, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808L, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fne', 'a', 'b'), ('fne', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fne', 'a', 'b'), ('fne', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fne', 'c', 'd'))) => ('iand', ('fne', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fne', 'c', 'd'))) => ('ior', ('fne', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fge', 'c', 'd'))) => ('iand', ('fne', 'a', 'b'), ('flt', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fge', 'c', 'd'))) => ('ior', ('fne', 'a', 'b'), ('flt', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('flt', 'c', 'd'))) => ('iand', ('fne', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('flt', 'c', 'd'))) => ('ior', ('fne', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fne', 'a', 'b'), ('fne', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fne', 'a', 'b'), ('fne', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fne', 'a', 'b'), ('fge', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('flt', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fne', 'a', 'b'), ('fge', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('flt', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fne', 'a', 'b'), ('flt', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fne', 'a', 'b'), ('flt', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fge', 'a', 'b'), ('fge', 'c', 'd'))) => ('iand', ('flt', 'a', 'b'), ('flt', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fge', 'a', 'b'), ('fge', 'c', 'd'))) => ('ior', ('flt', 'a', 'b'), ('flt', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fge', 'a', 'b'), ('flt', 'c', 'd'))) => ('iand', ('flt', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fge', 'a', 'b'), ('flt', 'c', 'd'))) => ('ior', ('flt', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('flt', 'a', 'b'), ('flt', 'c', 'd'))) => ('iand', ('fge', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('flt', 'a', 'b'), ('flt', 'c', 'd'))) => ('ior', ('fge', 'a', 'b'), ('fge', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fne', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fne', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fne', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fne', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fne', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fne', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fne', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fne', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -28), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -28), 30), ('ishr', ('imin', ('imax', 'exp', -28), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -252), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -252), 254), ('ishr', ('imin', ('imax', 'exp', -252), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2044), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2044), 2046), ('ishr', ('imin', ('imax', 'exp', -2044), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('feq', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c'))
 *    ('fne', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fne', 'b', 'd'), ('fne', 'c', 'd'))
 *    ('fne', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fne', 'd', 'b'), ('fne', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ieq', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('ine', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 */

#ifndef NIR_OPT_ALGEBRAIC_STRUCT_DEFS
#define NIR_OPT_ALGEBRAIC_STRUCT_DEFS

struct transform {
   const nir_search_expression *search;
   const nir_search_value *replace;
   unsigned condition_offset;
};

struct per_op_table {
   const uint16_t *filter;
   unsigned num_filtered_states;
   const uint16_t *table;
};

/* Note: these must match the start states created in
 * TreeAutomaton._build_table()
 */

/* WILDCARD_STATE = 0 is set by zeroing the state array */
static const uint16_t CONST_STATE = 1;

#endif


   static const nir_search_variable search0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_pos_power_of_two),
   {0, 1, 2, 3},
};
static const nir_search_expression search0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace0_0 -> search0_0 in the cache */

static const nir_search_variable replace0_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression replace0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search1_0 -> search0_0 in the cache */

static const nir_search_variable search1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_neg_power_of_two),
   {0, 1, 2, 3},
};
static const nir_search_expression search1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace1_0_0 -> search0_0 in the cache */

/* replace1_0_1_0_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace1_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &replace1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace1_0_1.value },
   NULL,
};
static const nir_search_expression replace1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace1_0.value },
   NULL,
};

   static const nir_search_variable search2_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search2_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search2_1.value },
   NULL,
};

   /* replace2_0 -> search2_0 in the cache */

static const nir_search_constant replace2_1_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x1 /* 1 */ },
};

/* replace2_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace2_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace2_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace2 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace2_1.value },
   NULL,
};

   /* search3_0_0 -> search0_0 in the cache */

/* search3_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search3_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search3_0.value },
   NULL,
};

   /* replace3_0 -> search0_0 in the cache */

/* replace3_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace3 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search4_0_0 -> search0_0 in the cache */

/* search4_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search4_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};
static const nir_search_expression search4 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search4_0.value },
   NULL,
};

   /* replace4_0 -> search0_0 in the cache */

/* replace4_1 -> replace0_1_0 in the cache */
/* replace4 -> replace3 in the cache */

   /* search5_0 -> search0_0 in the cache */

/* search5_1 -> replace0_1_0 in the cache */
static const nir_search_expression search5 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_imul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace5_0_0 -> search0_0 in the cache */

/* replace5_0_1 -> replace0_1_0 in the cache */
/* replace5_0 -> replace3 in the cache */

/* replace5_1_0 -> search0_0 in the cache */

/* replace5_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace5_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul_high,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace5 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace3.value, &replace5_1.value },
   NULL,
};

   /* search6_0 -> search0_0 in the cache */

/* search6_1 -> replace0_1_0 in the cache */
static const nir_search_expression search6 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_umul_2x32_64,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace6_0_0 -> search0_0 in the cache */

/* replace6_0_1 -> replace0_1_0 in the cache */
/* replace6_0 -> replace3 in the cache */

/* replace6_1_0 -> search0_0 in the cache */

/* replace6_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace6_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_umul_high,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace6 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_pack_64_2x32_split,
   { &replace3.value, &replace6_1.value },
   NULL,
};

   /* search7_0 -> search2_0 in the cache */

/* search7_1 -> replace2_1_0 in the cache */
static const nir_search_expression search7 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace7 -> search2_0 in the cache */

   /* search8_0 -> search2_0 in the cache */

/* search8_1 -> replace2_1_0 in the cache */
static const nir_search_expression search8 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace8 -> search2_0 in the cache */

   /* search9_0 -> search2_0 in the cache */

/* search9_1 -> replace2_1_0 in the cache */
static const nir_search_expression search9 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   static const nir_search_constant replace9 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x0 /* 0 */ },
};

   /* search10_0 -> search2_0 in the cache */

/* search10_1 -> replace2_1_0 in the cache */
static const nir_search_expression search10 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imod,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace10 -> replace9 in the cache */

   /* search11_0 -> search0_0 in the cache */

/* search11_1 -> search0_1 in the cache */
static const nir_search_expression search11 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_udiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace11_0 -> search0_0 in the cache */

/* replace11_1_0 -> replace0_1_0 in the cache */
/* replace11_1 -> replace0_1 in the cache */
static const nir_search_expression replace11 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace0_1.value },
   NULL,
};

   /* search12_0 -> search0_0 in the cache */

/* search12_1 -> search0_1 in the cache */
static const nir_search_expression search12 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search0_1.value },
   NULL,
};

   /* replace12_0_0 -> search0_0 in the cache */
static const nir_search_expression replace12_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isign,
   { &search0_0.value },
   NULL,
};

/* replace12_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace12_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search0_0.value },
   NULL,
};

/* replace12_1_1_0 -> replace0_1_0 in the cache */
/* replace12_1_1 -> replace0_1 in the cache */
static const nir_search_expression replace12_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace12_1_0.value, &replace0_1.value },
   NULL,
};
static const nir_search_expression replace12 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace12_0.value, &replace12_1.value },
   NULL,
};

   /* search13_0 -> search0_0 in the cache */

/* search13_1 -> search1_1 in the cache */
static const nir_search_expression search13 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_idiv,
   { &search0_0.value, &search1_1.value },
   NULL,
};

   /* replace13_0_0_0 -> search0_0 in the cache */
/* replace13_0_0 -> replace12_0 in the cache */

/* replace13_0_1_0_0 -> search0_0 in the cache */
/* replace13_0_1_0 -> replace12_1_0 in the cache */

/* replace13_0_1_1_0_0 -> replace0_1_0 in the cache */
/* replace13_0_1_1_0 -> replace1_0_1_0 in the cache */
/* replace13_0_1_1 -> replace1_0_1 in the cache */
static const nir_search_expression replace13_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &replace12_1_0.value, &replace1_0_1.value },
   NULL,
};
static const nir_search_expression replace13_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace12_0.value, &replace13_0_1.value },
   NULL,
};
static const nir_search_expression replace13 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace13_0.value },
   NULL,
};

   static const nir_search_variable search14_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search14_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_pos_power_of_two),
   {0, 1, 2, 3},
};
static const nir_search_expression search14 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_umod,
   { &search14_0.value, &search14_1.value },
   NULL,
};

   /* replace14_0 -> search14_0 in the cache */

static const nir_search_variable replace14_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_constant replace14_1_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace14_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace14_1_0.value, &replace14_1_1.value },
   NULL,
};
static const nir_search_expression replace14 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search14_0.value, &replace14_1.value },
   NULL,
};

   /* search15_0_0 -> search2_0 in the cache */
static const nir_search_expression search15_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search15 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search15_0.value },
   NULL,
};

   /* replace15 -> search2_0 in the cache */

   /* search16_0_0 -> search2_0 in the cache */
static const nir_search_expression search16_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search16 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search16_0.value },
   NULL,
};

   /* replace16 -> search2_0 in the cache */

   /* search17_0_0 -> search2_0 in the cache */
static const nir_search_expression search17_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search17 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search17_0.value },
   NULL,
};

   /* replace17_0 -> search2_0 in the cache */
/* replace17 -> search17_0 in the cache */

   /* search18_0_0 -> search2_0 in the cache */
/* search18_0 -> search15_0 in the cache */
static const nir_search_expression search18 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search15_0.value },
   NULL,
};

   /* replace18_0 -> search2_0 in the cache */
/* replace18 -> search17_0 in the cache */

   /* search19_0_0 -> search2_0 in the cache */
static const nir_search_expression search19_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search19 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search19_0.value },
   NULL,
};

   /* replace19_0 -> search2_0 in the cache */
/* replace19 -> search19_0 in the cache */

   /* search20_0_0 -> search2_0 in the cache */
static const nir_search_expression search20_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search20 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search20_0.value },
   NULL,
};

   /* replace20_0 -> search2_0 in the cache */
/* replace20 -> search20_0 in the cache */

   /* search21_0_0 -> search2_0 in the cache */
/* search21_0 -> search16_0 in the cache */
static const nir_search_expression search21 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search16_0.value },
   NULL,
};

   /* replace21_0 -> search2_0 in the cache */
/* replace21 -> search20_0 in the cache */

   /* search22_0_0 -> search2_0 in the cache */
/* search22_0 -> search15_0 in the cache */
static const nir_search_expression search22 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search15_0.value },
   NULL,
};

   /* replace22_0 -> search2_0 in the cache */
static const nir_search_expression replace22 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2b,
   { &search2_0.value },
   NULL,
};

   /* search23_0_0 -> search2_0 in the cache */
/* search23_0 -> search16_0 in the cache */
static const nir_search_expression search23 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search16_0.value },
   NULL,
};

   /* replace23_0 -> search2_0 in the cache */
static const nir_search_expression replace23 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search2_0.value },
   NULL,
};

   /* search24_0 -> search2_0 in the cache */

static const nir_search_constant search24_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search24 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* replace24 -> search2_0 in the cache */

   /* search25_0 -> search2_0 in the cache */

/* search25_1 -> replace9 in the cache */
static const nir_search_expression search25 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace25 -> search2_0 in the cache */

   /* search26_0 -> search0_0 in the cache */

static const nir_search_constant search26_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search26 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace26 -> search0_0 in the cache */

   /* search27_0 -> search0_0 in the cache */

static const nir_search_constant search27_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search27 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_usadd_4x8,
   { &search0_0.value, &search27_1.value },
   NULL,
};

   /* replace27 -> search27_1 in the cache */

   static const nir_search_variable search28_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search28_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search28_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search28_1_0 -> search28_0_0 in the cache */

static const nir_search_variable search28_1_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search28_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search28 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search28_0.value, &search28_1.value },
   NULL,
};

   /* replace28_0 -> search28_0_0 in the cache */

/* replace28_1_0 -> search28_0_1 in the cache */

/* replace28_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace28_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace28 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search28_0_0.value, &replace28_1.value },
   NULL,
};

   /* search29_0_0 -> search28_0_0 in the cache */

/* search29_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search29_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search29_1_0 -> search28_0_0 in the cache */

/* search29_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search29_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_imul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search29 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search29_0.value, &search29_1.value },
   NULL,
};

   /* replace29_0 -> search28_0_0 in the cache */

/* replace29_1_0 -> search28_0_1 in the cache */

/* replace29_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace29_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace29 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search28_0_0.value, &replace29_1.value },
   NULL,
};

   /* search30_0_0 -> search2_0 in the cache */
/* search30_0 -> search15_0 in the cache */

/* search30_1 -> search2_0 in the cache */
static const nir_search_expression search30 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search15_0.value, &search2_0.value },
   NULL,
};

   /* replace30 -> search24_1 in the cache */

   /* search31_0_0 -> search2_0 in the cache */
/* search31_0 -> search16_0 in the cache */

/* search31_1 -> search2_0 in the cache */
static const nir_search_expression search31 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search16_0.value, &search2_0.value },
   NULL,
};

   /* replace31 -> replace9 in the cache */

   /* search32_0_0 -> search14_0 in the cache */
static const nir_search_expression search32_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search14_0.value },
   NULL,
};

/* search32_1_0 -> search14_0 in the cache */

/* search32_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search32_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search32 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search32_0.value, &search32_1.value },
   NULL,
};

   /* replace32 -> replace14_1_0 in the cache */

   /* search33_0 -> search14_0 in the cache */

/* search33_1_0_0 -> search14_0 in the cache */
/* search33_1_0 -> search32_0 in the cache */

/* search33_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search33_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search32_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search33 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search14_0.value, &search33_1.value },
   NULL,
};

   /* replace33 -> replace14_1_0 in the cache */

   /* search34_0_0 -> search14_0 in the cache */
static const nir_search_expression search34_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search14_0.value },
   NULL,
};

/* search34_1_0 -> search14_0 in the cache */

/* search34_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search34_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search34 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search34_0.value, &search34_1.value },
   NULL,
};

   /* replace34 -> replace14_1_0 in the cache */

   /* search35_0 -> search14_0 in the cache */

/* search35_1_0_0 -> search14_0 in the cache */
/* search35_1_0 -> search34_0 in the cache */

/* search35_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search35_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search34_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search35 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search14_0.value, &search35_1.value },
   NULL,
};

   /* replace35 -> replace14_1_0 in the cache */

   /* search36_0_0 -> search2_0 in the cache */
static const nir_search_expression search36_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search2_0.value },
   NULL,
};

/* search36_1_0_0 -> search2_0 in the cache */
/* search36_1_0 -> search15_0 in the cache */
static const nir_search_expression search36_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search15_0.value },
   NULL,
};
static const nir_search_expression search36 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search36_0.value, &search36_1.value },
   NULL,
};

   /* replace36_0_0 -> search2_0 in the cache */
/* replace36_0 -> search17_0 in the cache */
static const nir_search_expression replace36 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search17_0.value },
   NULL,
};

   /* search37_0 -> search2_0 in the cache */

/* search37_1 -> search24_1 in the cache */
static const nir_search_expression search37 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* replace37 -> search24_1 in the cache */

   /* search38_0 -> search2_0 in the cache */

/* search38_1 -> replace9 in the cache */
static const nir_search_expression search38 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace38 -> replace9 in the cache */

   /* search39_0 -> search0_0 in the cache */

/* search39_1 -> search26_1 in the cache */
static const nir_search_expression search39 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace39 -> search26_1 in the cache */

   /* search40_0 -> search0_0 in the cache */

/* search40_1 -> search27_1 in the cache */
static const nir_search_expression search40 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_umul_unorm_4x8,
   { &search0_0.value, &search27_1.value },
   NULL,
};

   /* replace40 -> search0_0 in the cache */

   /* search41_0 -> search2_0 in the cache */

static const nir_search_constant search41_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search41 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* replace41 -> search2_0 in the cache */

   /* search42_0 -> search2_0 in the cache */

/* search42_1 -> replace2_1_0 in the cache */
static const nir_search_expression search42 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

   /* replace42 -> search2_0 in the cache */

   /* search43_0 -> search2_0 in the cache */

static const nir_search_constant search43_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbff0000000000000L /* -1.0 */ },
};
static const nir_search_expression search43 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search2_0.value, &search43_1.value },
   NULL,
};

   /* replace43_0 -> search2_0 in the cache */
/* replace43 -> search15_0 in the cache */

   /* search44_0 -> search2_0 in the cache */

static const nir_search_constant search44_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { -0x1 /* -1 */ },
};
static const nir_search_expression search44 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search2_0.value, &search44_1.value },
   NULL,
};

   /* replace44_0 -> search2_0 in the cache */
/* replace44 -> search16_0 in the cache */

   /* search45_0_0 -> search2_0 in the cache */
static const nir_search_expression search45_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsign,
   { &search2_0.value },
   NULL,
};

/* search45_1_0 -> search2_0 in the cache */

/* search45_1_1 -> search2_0 in the cache */
static const nir_search_expression search45_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search2_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search45 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search45_0.value, &search45_1.value },
   NULL,
};

   /* replace45_0_0 -> search2_0 in the cache */
/* replace45_0 -> search17_0 in the cache */

/* replace45_1 -> search2_0 in the cache */
static const nir_search_expression replace45 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search17_0.value, &search2_0.value },
   NULL,
};

   /* search46_0_0_0 -> search2_0 in the cache */
/* search46_0_0 -> search45_0 in the cache */

/* search46_0_1 -> search2_0 in the cache */
static const nir_search_expression search46_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search45_0.value, &search2_0.value },
   NULL,
};

/* search46_1 -> search2_0 in the cache */
static const nir_search_expression search46 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &search46_0.value, &search2_0.value },
   NULL,
};

   /* replace46_0_0 -> search2_0 in the cache */
/* replace46_0 -> search17_0 in the cache */

/* replace46_1 -> search2_0 in the cache */
/* replace46 -> replace45 in the cache */

   static const nir_search_constant search47_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search47_1 -> search14_0 in the cache */

/* search47_2 -> replace14_1_0 in the cache */
static const nir_search_expression search47 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search47_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace47 -> replace14_1_0 in the cache */

   /* search48_0 -> search14_0 in the cache */

/* search48_1 -> replace14_1_0 in the cache */

/* search48_2 -> search47_0 in the cache */
static const nir_search_expression search48 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_ffma,
   { &search14_0.value, &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* replace48_0 -> search14_0 in the cache */

/* replace48_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace48 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_constant search49_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search49_1 -> search14_0 in the cache */

/* search49_2 -> replace14_1_0 in the cache */
static const nir_search_expression search49 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search49_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace49_0 -> search14_0 in the cache */

/* replace49_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace49 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_constant search50_0 = {
   { nir_search_value_constant, -2 },
   nir_type_float, { 0xbff0000000000000L /* -1.0 */ },
};

/* search50_1 -> search14_0 in the cache */

/* search50_2 -> replace14_1_0 in the cache */
static const nir_search_expression search50 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search50_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace50_0_0 -> search14_0 in the cache */
/* replace50_0 -> search34_0 in the cache */

/* replace50_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace50 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search34_0.value, &replace14_1_0.value },
   NULL,
};

   /* search51_0 -> search14_0 in the cache */

/* search51_1 -> replace14_1_0 in the cache */

/* search51_2 -> search47_0 in the cache */
static const nir_search_expression search51 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* replace51 -> search14_0 in the cache */

   /* search52_0 -> search14_0 in the cache */

/* search52_1 -> replace14_1_0 in the cache */

/* search52_2 -> search49_0 in the cache */
static const nir_search_expression search52 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &replace14_1_0.value, &search49_0.value },
   NULL,
};

   /* replace52 -> replace14_1_0 in the cache */

   /* search53_0 -> search14_0 in the cache */

/* search53_1 -> search14_0 in the cache */

/* search53_2 -> replace14_1_0 in the cache */
static const nir_search_expression search53 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace53 -> search14_0 in the cache */

   /* search54_0 -> search47_0 in the cache */

/* search54_1 -> search14_0 in the cache */

/* search54_2 -> replace14_1_0 in the cache */
static const nir_search_expression search54 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search47_0.value, &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace54_0 -> search14_0 in the cache */

/* replace54_1 -> replace14_1_0 in the cache */
/* replace54 -> replace48 in the cache */

   /* search55_0 -> search28_0_0 in the cache */

/* search55_1_0 -> search28_0_0 in the cache */

/* search55_1_1 -> search28_0_1 in the cache */
static const nir_search_expression search55_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search55_2 -> search28_1_1 in the cache */
static const nir_search_expression search55 = {
   { nir_search_value_expression, -3 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search28_0_0.value, &search55_1.value, &search28_1_1.value },
   NULL,
};

   /* replace55_0_0 -> search28_0_1 in the cache */

/* replace55_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace55_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};

/* replace55_1 -> search28_0_0 in the cache */
static const nir_search_expression replace55 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace55_0.value, &search28_0_0.value },
   NULL,
};

   /* search56_0 -> search0_0 in the cache */

/* search56_1_0 -> search0_0 in the cache */

/* search56_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search56_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_variable search56_2 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search56 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search0_0.value, &search56_1.value, &search56_2.value },
   NULL,
};

   /* replace56_0_0 -> replace0_1_0 in the cache */

/* replace56_0_1 -> search56_2 in the cache */
static const nir_search_expression replace56_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};

/* replace56_1 -> search0_0 in the cache */
static const nir_search_expression replace56 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace56_0.value, &search0_0.value },
   NULL,
};

   static const nir_search_variable search57_0 = {
   { nir_search_value_variable, 64 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search57_1_0 -> search57_0 in the cache */

static const nir_search_variable search57_1_1 = {
   { nir_search_value_variable, 64 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search57_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_variable search57_2 = {
   { nir_search_value_variable, 64 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search57 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search57_0.value, &search57_1.value, &search57_2.value },
   NULL,
};

   /* replace57_0_0 -> search57_1_1 in the cache */

/* replace57_0_1 -> search57_2 in the cache */
static const nir_search_expression replace57_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search57_1_1.value, &search57_2.value },
   NULL,
};

/* replace57_1 -> search57_0 in the cache */
static const nir_search_expression replace57 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace57_0.value, &search57_0.value },
   NULL,
};

   /* search58_0_0 -> search0_0 in the cache */

/* search58_0_1 -> replace0_1_0 in the cache */
/* search58_0 -> search56_1 in the cache */

/* search58_1_0 -> search0_0 in the cache */

/* search58_1_1 -> search56_2 in the cache */
static const nir_search_expression search58_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search0_0.value, &search56_2.value },
   NULL,
};

static const nir_search_variable search58_2 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search58 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search56_1.value, &search58_1.value, &search58_2.value },
   NULL,
};

   /* replace58_0_0 -> replace0_1_0 in the cache */

/* replace58_0_1 -> search56_2 in the cache */

/* replace58_0_2 -> search58_2 in the cache */
static const nir_search_expression replace58_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace0_1_0.value, &search56_2.value, &search58_2.value },
   NULL,
};

/* replace58_1 -> search0_0 in the cache */
static const nir_search_expression replace58 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace58_0.value, &search0_0.value },
   NULL,
};

   /* search59_0_0 -> search57_0 in the cache */

/* search59_0_1 -> search57_1_1 in the cache */
/* search59_0 -> search57_1 in the cache */

/* search59_1_0 -> search57_0 in the cache */

/* search59_1_1 -> search57_2 in the cache */
static const nir_search_expression search59_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search57_0.value, &search57_2.value },
   NULL,
};

static const nir_search_variable search59_2 = {
   { nir_search_value_variable, 64 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search59 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search57_1.value, &search59_1.value, &search59_2.value },
   NULL,
};

   /* replace59_0_0 -> search57_1_1 in the cache */

/* replace59_0_1 -> search57_2 in the cache */

/* replace59_0_2 -> search59_2 in the cache */
static const nir_search_expression replace59_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search57_1_1.value, &search57_2.value, &search59_2.value },
   NULL,
};

/* replace59_1 -> search57_0 in the cache */
static const nir_search_expression replace59 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &replace59_0.value, &search57_0.value },
   NULL,
};

   /* search60_0 -> search0_0 in the cache */

/* search60_1_0 -> search0_0 in the cache */

/* search60_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search60_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search0_0.value, &replace0_1_0.value },
   (is_used_once),
};

/* search60_2 -> search56_2 in the cache */
static const nir_search_expression search60 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search0_0.value, &search60_1.value, &search56_2.value },
   NULL,
};

   static const nir_search_constant replace60_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace60_0_1 -> replace0_1_0 in the cache */

/* replace60_0_2 -> search56_2 in the cache */
static const nir_search_expression replace60_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace60_0_0.value, &replace0_1_0.value, &search56_2.value },
   NULL,
};

/* replace60_1 -> search0_0 in the cache */
static const nir_search_expression replace60 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace60_0.value, &search0_0.value },
   NULL,
};

   /* search61_0 -> search57_0 in the cache */

/* search61_1_0 -> search57_0 in the cache */

/* search61_1_1 -> search57_1_1 in the cache */
static const nir_search_expression search61_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search57_0.value, &search57_1_1.value },
   (is_used_once),
};

/* search61_2 -> search57_2 in the cache */
static const nir_search_expression search61 = {
   { nir_search_value_expression, 64 },
   true, false,
   -1, 1,
   nir_op_flrp,
   { &search57_0.value, &search61_1.value, &search57_2.value },
   NULL,
};

   static const nir_search_constant replace61_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* replace61_0_1 -> search57_1_1 in the cache */

/* replace61_0_2 -> search57_2 in the cache */
static const nir_search_expression replace61_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace61_0_0.value, &search57_1_1.value, &search57_2.value },
   NULL,
};

/* replace61_1 -> search57_0 in the cache */
static const nir_search_expression replace61 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace61_0.value, &search57_0.value },
   NULL,
};

   static const nir_search_variable search62_0_0 = {
   { nir_search_value_variable, -4 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search62_0_1 = {
   { nir_search_value_variable, -4 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search62_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search62_0_0.value, &search62_0_1.value },
   (is_used_once),
};

/* search62_1_0 -> search62_0_0 in the cache */

static const nir_search_variable search62_1_1 = {
   { nir_search_value_variable, -4 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search62_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search62_0_0.value, &search62_1_1.value },
   (is_used_once),
};

static const nir_search_variable search62_2 = {
   { nir_search_value_variable, -4 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search62 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 2,
   nir_op_flrp,
   { &search62_0.value, &search62_1.value, &search62_2.value },
   NULL,
};

   /* replace62_0_0 -> search62_0_1 in the cache */

/* replace62_0_1 -> search62_1_1 in the cache */

/* replace62_0_2 -> search62_2 in the cache */
static const nir_search_expression replace62_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search62_0_1.value, &search62_1_1.value, &search62_2.value },
   NULL,
};

/* replace62_1 -> search62_0_0 in the cache */
static const nir_search_expression replace62 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace62_0.value, &search62_0_0.value },
   NULL,
};

   /* search63_0 -> search14_0 in the cache */

/* search63_1 -> replace14_1_0 in the cache */

static const nir_search_variable search63_2_0 = {
   { nir_search_value_variable, 1 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search63_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search63_2_0.value },
   NULL,
};
static const nir_search_expression search63 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &replace14_1_0.value, &search63_2.value },
   NULL,
};

   /* replace63_0 -> search63_2_0 in the cache */

/* replace63_1 -> replace14_1_0 in the cache */

/* replace63_2 -> search14_0 in the cache */
static const nir_search_expression replace63 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search63_2_0.value, &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search64_0 -> search14_0 in the cache */

/* search64_1 -> search47_0 in the cache */

static const nir_search_variable search64_2 = {
   { nir_search_value_variable, -2 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search64 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flrp,
   { &search14_0.value, &search47_0.value, &search64_2.value },
   NULL,
};

   /* replace64_0_0_0 -> search14_0 in the cache */
/* replace64_0_0 -> search34_0 in the cache */

/* replace64_0_1 -> search64_2 in the cache */
static const nir_search_expression replace64_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search34_0.value, &search64_2.value },
   NULL,
};

/* replace64_1 -> search14_0 in the cache */
static const nir_search_expression replace64 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace64_0.value, &search14_0.value },
   NULL,
};

   /* search65_0 -> search2_0 in the cache */
static const nir_search_expression search65 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search2_0.value },
   NULL,
};

   /* replace65_0_0 -> search2_0 in the cache */

/* replace65_0_1 -> search24_1 in the cache */
static const nir_search_expression replace65_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search24_1.value },
   NULL,
};

/* replace65_1_0_0_0 -> search2_0 in the cache */
/* replace65_1_0_0 -> search17_0 in the cache */
static const nir_search_expression replace65_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search17_0.value },
   NULL,
};
static const nir_search_expression replace65_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace65_1_0.value },
   NULL,
};

/* replace65_2_0_0 -> search2_0 in the cache */
/* replace65_2_0 -> search17_0 in the cache */
/* replace65_2 -> replace65_1_0 in the cache */
static const nir_search_expression replace65 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace65_0.value, &replace65_1.value, &replace65_1_0.value },
   NULL,
};

   /* search66_0 -> search2_0 in the cache */
static const nir_search_expression search66 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search2_0.value },
   NULL,
};

   /* replace66_0 -> search2_0 in the cache */

/* replace66_1_0 -> search2_0 in the cache */
static const nir_search_expression replace66_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffract,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression replace66 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search2_0.value, &replace66_1.value },
   NULL,
};

   /* search67_0 -> search2_0 in the cache */

/* search67_1_0_0 -> search2_0 in the cache */
/* search67_1_0 -> replace66_1 in the cache */
static const nir_search_expression search67_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace66_1.value },
   NULL,
};
static const nir_search_expression search67 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search2_0.value, &search67_1.value },
   NULL,
};

   /* replace67_0 -> search2_0 in the cache */
/* replace67 -> search66 in the cache */

   /* search68_0 -> search2_0 in the cache */
/* search68 -> replace66_1 in the cache */

   /* replace68_0 -> search2_0 in the cache */

/* replace68_1_0 -> search2_0 in the cache */
/* replace68_1 -> search66 in the cache */
static const nir_search_expression replace68 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search2_0.value, &search66.value },
   NULL,
};

   /* search69_0 -> search2_0 in the cache */
static const nir_search_expression search69 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search2_0.value },
   NULL,
};

   /* replace69_0_0_0 -> search2_0 in the cache */
/* replace69_0_0 -> search15_0 in the cache */
static const nir_search_expression replace69_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search15_0.value },
   NULL,
};
static const nir_search_expression replace69 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace69_0.value },
   NULL,
};

   /* search70_0_0 -> search28_0_0 in the cache */

static const nir_search_constant search70_0_1_0 = {
   { nir_search_value_constant, -3 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

static const nir_search_variable search70_0_1_1_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search70_0_1_1_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search70_0_1_1_0_0.value },
   NULL,
};
static const nir_search_expression search70_0_1_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search70_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search70_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search70_0_1_0.value, &search70_0_1_1.value },
   NULL,
};
static const nir_search_expression search70_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search28_0_0.value, &search70_0_1.value },
   NULL,
};

static const nir_search_variable search70_1_0 = {
   { nir_search_value_variable, -3 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search70_1_1_0 -> search70_0_1_1_0_0 in the cache */
/* search70_1_1 -> search70_0_1_1_0 in the cache */
static const nir_search_expression search70_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search70_1_0.value, &search70_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search70 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search70_0.value, &search70_1.value },
   NULL,
};

   /* replace70_0 -> search70_0_1_1_0_0 in the cache */

/* replace70_1 -> search70_1_0 in the cache */

/* replace70_2 -> search28_0_0 in the cache */
static const nir_search_expression replace70 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search70_0_1_1_0_0.value, &search70_1_0.value, &search28_0_0.value },
   NULL,
};

   /* search71_0_0 -> search0_0 in the cache */

/* search71_0_1_0 -> replace60_0_0 in the cache */

static const nir_search_variable search71_0_1_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search71_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search71_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search71_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace60_0_0.value, &search71_0_1_1.value },
   NULL,
};
static const nir_search_expression search71_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search0_0.value, &search71_0_1.value },
   NULL,
};

static const nir_search_variable search71_1_0 = {
   { nir_search_value_variable, 32 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search71_1_1 -> search71_0_1_1_0 in the cache */
static const nir_search_expression search71_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search71_1_0.value, &search71_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search71 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search71_0.value, &search71_1.value },
   NULL,
};

   /* replace71_0 -> search0_0 in the cache */

/* replace71_1 -> search71_1_0 in the cache */

/* replace71_2 -> search71_0_1_1_0 in the cache */
static const nir_search_expression replace71 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search71_1_0.value, &search71_0_1_1_0.value },
   NULL,
};

   /* search72_0_0 -> search57_0 in the cache */

/* search72_0_1_0 -> replace61_0_0 in the cache */

static const nir_search_variable search72_0_1_1_0 = {
   { nir_search_value_variable, 64 },
   1, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search72_0_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search72_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search72_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace61_0_0.value, &search72_0_1_1.value },
   NULL,
};
static const nir_search_expression search72_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search57_0.value, &search72_0_1.value },
   NULL,
};

static const nir_search_variable search72_1_0 = {
   { nir_search_value_variable, 64 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search72_1_1 -> search72_0_1_1_0 in the cache */
static const nir_search_expression search72_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search72_1_0.value, &search72_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search72 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search72_0.value, &search72_1.value },
   NULL,
};

   /* replace72_0 -> search57_0 in the cache */

/* replace72_1 -> search72_1_0 in the cache */

/* replace72_2 -> search72_0_1_1_0 in the cache */
static const nir_search_expression replace72 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search57_0.value, &search72_1_0.value, &search72_0_1_1_0.value },
   NULL,
};

   /* search73_0_0 -> search0_0 in the cache */

/* search73_0_1_0_0 -> replace60_0_0 in the cache */

/* search73_0_1_0_1_0 -> search71_0_1_1_0 in the cache */
/* search73_0_1_0_1 -> search71_0_1_1 in the cache */
/* search73_0_1_0 -> search71_0_1 in the cache */
static const nir_search_expression search73_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search71_0_1.value },
   NULL,
};
static const nir_search_expression search73_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search0_0.value, &search73_0_1.value },
   NULL,
};

/* search73_1_0 -> search71_1_0 in the cache */

/* search73_1_1_0 -> search71_0_1_1_0 in the cache */
static const nir_search_expression search73_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search71_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search73_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search71_1_0.value, &search73_1_1.value },
   NULL,
};
static const nir_search_expression search73 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search73_0.value, &search73_1.value },
   NULL,
};

   /* replace73_0 -> search0_0 in the cache */

/* replace73_1 -> search71_1_0 in the cache */

/* replace73_2_0 -> search71_0_1_1_0 in the cache */
/* replace73_2 -> search73_1_1 in the cache */
static const nir_search_expression replace73 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search0_0.value, &search71_1_0.value, &search73_1_1.value },
   NULL,
};

   /* search74_0_0 -> search57_0 in the cache */

/* search74_0_1_0_0 -> replace61_0_0 in the cache */

/* search74_0_1_0_1_0 -> search72_0_1_1_0 in the cache */
/* search74_0_1_0_1 -> search72_0_1_1 in the cache */
/* search74_0_1_0 -> search72_0_1 in the cache */
static const nir_search_expression search74_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search72_0_1.value },
   NULL,
};
static const nir_search_expression search74_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search57_0.value, &search74_0_1.value },
   NULL,
};

/* search74_1_0 -> search72_1_0 in the cache */

/* search74_1_1_0 -> search72_0_1_1_0 in the cache */
static const nir_search_expression search74_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search72_0_1_1_0.value },
   NULL,
};
static const nir_search_expression search74_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search72_1_0.value, &search74_1_1.value },
   NULL,
};
static const nir_search_expression search74 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &search74_0.value, &search74_1.value },
   NULL,
};

   /* replace74_0 -> search57_0 in the cache */

/* replace74_1 -> search72_1_0 in the cache */

/* replace74_2_0 -> search72_0_1_1_0 in the cache */
/* replace74_2 -> search74_1_1 in the cache */
static const nir_search_expression replace74 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &search57_0.value, &search72_1_0.value, &search74_1_1.value },
   NULL,
};

   /* search75_0 -> search2_0 in the cache */

/* search75_1_0_0 -> search70_0_1_1_0_0 in the cache */
static const nir_search_expression search75_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search70_0_1_1_0_0.value },
   NULL,
};

static const nir_search_variable search75_1_1_0 = {
   { nir_search_value_variable, -1 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search75_1_1_1_0 -> search2_0 in the cache */
/* search75_1_1_1 -> search15_0 in the cache */
static const nir_search_expression search75_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search75_1_1_0.value, &search15_0.value },
   NULL,
};
static const nir_search_expression search75_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search75_1_0.value, &search75_1_1.value },
   NULL,
};
static const nir_search_expression search75 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search2_0.value, &search75_1.value },
   NULL,
};

   /* replace75_0 -> search70_0_1_1_0_0 in the cache */

/* replace75_1 -> search75_1_1_0 in the cache */

/* replace75_2 -> search2_0 in the cache */
static const nir_search_expression replace75 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search70_0_1_1_0_0.value, &search75_1_1_0.value, &search2_0.value },
   NULL,
};

   /* search76_0 -> search0_0 in the cache */

/* search76_1_0 -> search71_0_1_1_0 in the cache */

/* search76_1_1_0 -> search71_1_0 in the cache */

/* search76_1_1_1_0 -> search0_0 in the cache */
static const nir_search_expression search76_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search76_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search71_1_0.value, &search76_1_1_1.value },
   NULL,
};
static const nir_search_expression search76_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search71_0_1_1_0.value, &search76_1_1.value },
   NULL,
};
static const nir_search_expression search76 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search0_0.value, &search76_1.value },
   NULL,
};

   /* replace76_0 -> search0_0 in the cache */

/* replace76_1 -> search71_1_0 in the cache */

/* replace76_2 -> search71_0_1_1_0 in the cache */
/* replace76 -> replace71 in the cache */

   /* search77_0 -> search57_0 in the cache */

/* search77_1_0 -> search72_0_1_1_0 in the cache */

/* search77_1_1_0 -> search72_1_0 in the cache */

/* search77_1_1_1_0 -> search57_0 in the cache */
static const nir_search_expression search77_1_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search57_0.value },
   NULL,
};
static const nir_search_expression search77_1_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &search72_1_0.value, &search77_1_1_1.value },
   NULL,
};
static const nir_search_expression search77_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 2,
   nir_op_fmul,
   { &search72_0_1_1_0.value, &search77_1_1.value },
   NULL,
};
static const nir_search_expression search77 = {
   { nir_search_value_expression, 64 },
   true, false,
   0, 3,
   nir_op_fadd,
   { &search57_0.value, &search77_1.value },
   NULL,
};

   /* replace77_0 -> search57_0 in the cache */

/* replace77_1 -> search72_1_0 in the cache */

/* replace77_2 -> search72_0_1_1_0 in the cache */
/* replace77 -> replace72 in the cache */

   /* search78_0 -> search28_0_0 in the cache */

/* search78_1 -> search28_0_1 in the cache */

/* search78_2 -> search28_1_1 in the cache */
static const nir_search_expression search78 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_ffma,
   { &search28_0_0.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* replace78_0_0 -> search28_0_0 in the cache */

/* replace78_0_1 -> search28_0_1 in the cache */
/* replace78_0 -> search28_0 in the cache */

/* replace78_1 -> search28_1_1 in the cache */
static const nir_search_expression replace78 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search28_0.value, &search28_1_1.value },
   NULL,
};

   /* search79_0_0 -> search28_0_0 in the cache */

/* search79_0_1 -> search28_0_1 in the cache */
/* search79_0 -> search28_0 in the cache */

/* search79_1 -> search28_1_1 in the cache */
static const nir_search_expression search79 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search28_0.value, &search28_1_1.value },
   NULL,
};

   /* replace79_0 -> search28_0_0 in the cache */

/* replace79_1 -> search28_0_1 in the cache */

/* replace79_2 -> search28_1_1 in the cache */
/* replace79 -> search78 in the cache */

   static const nir_search_variable search80_0_0_0_0_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search80_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search80_0_0_0_0_0.value },
   NULL,
};
static const nir_search_expression search80_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search80_0_0_0_0.value },
   NULL,
};

/* search80_0_0_1_0 -> replace0_1_0 in the cache */

/* search80_0_0_1_1 -> search56_2 in the cache */
static const nir_search_expression search80_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression search80_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 2,
   nir_op_iand,
   { &search80_0_0_0.value, &search80_0_0_1.value },
   NULL,
};

static const nir_search_variable search80_0_1 = {
   { nir_search_value_variable, 32 },
   3, /* d */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search80_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_fadd,
   { &search80_0_0.value, &search80_0_1.value },
   NULL,
};

static const nir_search_variable search80_1 = {
   { nir_search_value_variable, 32 },
   4, /* e */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search80 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fmul,
   { &search80_0.value, &search80_1.value },
   NULL,
};

   static const nir_search_variable replace80_0 = {
   { nir_search_value_variable, 1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* replace80_1_0_0_0 -> replace0_1_0 in the cache */

/* replace80_1_0_0_1 -> search56_2 in the cache */
static const nir_search_expression replace80_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};

/* replace80_1_0_1 -> search58_2 in the cache */
static const nir_search_expression replace80_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 2,
   nir_op_fadd,
   { &replace80_1_0_0.value, &search58_2.value },
   NULL,
};

static const nir_search_variable replace80_1_1 = {
   { nir_search_value_variable, 32 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression replace80_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_fmul,
   { &replace80_1_0.value, &replace80_1_1.value },
   NULL,
};

/* replace80_2_0 -> search58_2 in the cache */

/* replace80_2_1 -> replace80_1_1 in the cache */
static const nir_search_expression replace80_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fmul,
   { &search58_2.value, &replace80_1_1.value },
   NULL,
};
static const nir_search_expression replace80 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace80_0.value, &replace80_1.value, &replace80_2.value },
   NULL,
};

   /* search81_0 -> search14_0 in the cache */

/* search81_1 -> replace14_1_0 in the cache */
static const nir_search_expression search81 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_variable replace81_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace81_0_1 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace81_0_2 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {2},
};

/* replace81_0_3 -> search49_0 in the cache */
static const nir_search_expression replace81_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace81_0_0.value, &replace81_0_1.value, &replace81_0_2.value, &search49_0.value },
   NULL,
};

/* replace81_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace81 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &replace81_0.value, &replace14_1_0.value },
   NULL,
};

   /* search82_0_0 -> search62_0_0 in the cache */

/* search82_0_1 -> search62_0_1 in the cache */

/* search82_0_2 -> search62_1_1 in the cache */

static const nir_search_constant search82_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};
static const nir_search_expression search82_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search62_0_0.value, &search62_0_1.value, &search62_1_1.value, &search82_0_3.value },
   NULL,
};

/* search82_1 -> search62_2 in the cache */
static const nir_search_expression search82 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search82_0.value, &search62_2.value },
   NULL,
};

   /* replace82_0_0 -> search62_0_0 in the cache */

/* replace82_0_1 -> search62_0_1 in the cache */

/* replace82_0_2 -> search62_1_1 in the cache */
static const nir_search_expression replace82_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search62_0_0.value, &search62_0_1.value, &search62_1_1.value },
   NULL,
};

/* replace82_1 -> search62_2 in the cache */
static const nir_search_expression replace82 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fdph,
   { &replace82_0.value, &search62_2.value },
   NULL,
};

   /* search83_0_0 -> search14_0 in the cache */

/* search83_0_1 -> search47_0 in the cache */

/* search83_0_2 -> search47_0 in the cache */

/* search83_0_3 -> search47_0 in the cache */
static const nir_search_expression search83_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search14_0.value, &search47_0.value, &search47_0.value, &search47_0.value },
   NULL,
};

/* search83_1 -> replace14_1_0 in the cache */
static const nir_search_expression search83 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search83_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace83_0 -> search14_0 in the cache */

/* replace83_1 -> replace14_1_0 in the cache */
/* replace83 -> replace48 in the cache */

   /* search84_0_0 -> search28_0_0 in the cache */

/* search84_0_1 -> search28_0_1 in the cache */

static const nir_search_constant search84_0_2 = {
   { nir_search_value_constant, -3 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search84_0_3 -> search84_0_2 in the cache */
static const nir_search_expression search84_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search28_0_0.value, &search28_0_1.value, &search84_0_2.value, &search84_0_2.value },
   NULL,
};

/* search84_1 -> search28_1_1 in the cache */
static const nir_search_expression search84 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search84_0.value, &search28_1_1.value },
   NULL,
};

   /* replace84_0_0 -> search28_0_0 in the cache */

/* replace84_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace84_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace84_1 -> search28_1_1 in the cache */
static const nir_search_expression replace84 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &replace84_0.value, &search28_1_1.value },
   NULL,
};

   /* search85_0_0 -> search62_0_0 in the cache */

/* search85_0_1 -> search62_0_1 in the cache */

/* search85_0_2 -> search62_1_1 in the cache */

static const nir_search_constant search85_0_3 = {
   { nir_search_value_constant, -4 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search85_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &search62_0_0.value, &search62_0_1.value, &search62_1_1.value, &search85_0_3.value },
   NULL,
};

/* search85_1 -> search62_2 in the cache */
static const nir_search_expression search85 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search85_0.value, &search62_2.value },
   NULL,
};

   /* replace85_0_0 -> search62_0_0 in the cache */

/* replace85_0_1 -> search62_0_1 in the cache */

/* replace85_0_2 -> search62_1_1 in the cache */
/* replace85_0 -> replace82_0 in the cache */

/* replace85_1 -> search62_2 in the cache */
static const nir_search_expression replace85 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &replace82_0.value, &search62_2.value },
   NULL,
};

   /* search86_0_0 -> search14_0 in the cache */

/* search86_0_1 -> search47_0 in the cache */

/* search86_0_2 -> search47_0 in the cache */
static const nir_search_expression search86_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search14_0.value, &search47_0.value, &search47_0.value },
   NULL,
};

/* search86_1 -> replace14_1_0 in the cache */
static const nir_search_expression search86 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search86_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace86_0 -> search14_0 in the cache */

/* replace86_1 -> replace14_1_0 in the cache */
/* replace86 -> replace48 in the cache */

   /* search87_0_0 -> search28_0_0 in the cache */

/* search87_0_1 -> search28_0_1 in the cache */

/* search87_0_2 -> search84_0_2 in the cache */
static const nir_search_expression search87_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_vec3,
   { &search28_0_0.value, &search28_0_1.value, &search84_0_2.value },
   NULL,
};

/* search87_1 -> search28_1_1 in the cache */
static const nir_search_expression search87 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search87_0.value, &search28_1_1.value },
   NULL,
};

   /* replace87_0_0 -> search28_0_0 in the cache */

/* replace87_0_1 -> search28_0_1 in the cache */
/* replace87_0 -> replace84_0 in the cache */

/* replace87_1 -> search28_1_1 in the cache */
/* replace87 -> replace84 in the cache */

   /* search88_0_0 -> search14_0 in the cache */

/* search88_0_1 -> search47_0 in the cache */
static const nir_search_expression search88_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &search14_0.value, &search47_0.value },
   NULL,
};

/* search88_1 -> replace14_1_0 in the cache */
static const nir_search_expression search88 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search88_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace88_0 -> search14_0 in the cache */

/* replace88_1 -> replace14_1_0 in the cache */
/* replace88 -> replace48 in the cache */

   /* search89_0 -> search2_0 in the cache */

/* search89_1 -> search41_1 in the cache */
static const nir_search_expression search89 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   static const nir_search_variable replace89_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace89_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace89 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fadd,
   { &replace89_0.value, &replace89_1.value },
   NULL,
};

   /* search90_0 -> search14_0 in the cache */

/* search90_1 -> replace14_1_0 in the cache */
static const nir_search_expression search90 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot2,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace90_0_0 -> search14_0 in the cache */

/* replace90_0_1 -> replace14_1_0 in the cache */
/* replace90_0 -> replace48 in the cache */
static const nir_search_expression replace90 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum2,
   { &replace48.value },
   NULL,
};

   /* search91_0 -> search14_0 in the cache */

/* search91_1 -> replace14_1_0 in the cache */
static const nir_search_expression search91 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot3,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace91_0_0 -> search14_0 in the cache */

/* replace91_0_1 -> replace14_1_0 in the cache */
/* replace91_0 -> replace48 in the cache */
static const nir_search_expression replace91 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum3,
   { &replace48.value },
   NULL,
};

   /* search92_0 -> search14_0 in the cache */

/* search92_1 -> replace14_1_0 in the cache */
static const nir_search_expression search92 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fdot4,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace92_0_0 -> search14_0 in the cache */

/* replace92_0_1 -> replace14_1_0 in the cache */
/* replace92_0 -> replace48 in the cache */
static const nir_search_expression replace92 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsum4,
   { &replace48.value },
   NULL,
};

   /* search93_0 -> search2_0 in the cache */
static const nir_search_expression search93 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsum2,
   { &search2_0.value },
   NULL,
};

   /* replace93_0 -> replace89_0 in the cache */

/* replace93_1 -> replace89_1 in the cache */
/* replace93 -> replace89 in the cache */

   static const nir_search_variable search94_0_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_fmul),
   {0, 1, 2, 3},
};
static const nir_search_expression search94_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search94_0_0_0.value },
   (is_used_once),
};
static const nir_search_expression search94_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search94_0_0.value },
   (is_used_once),
};

/* search94_1 -> search41_1 in the cache */
static const nir_search_expression search94 = {
   { nir_search_value_expression, -1 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search94_0.value, &search41_1.value },
   NULL,
};

   /* replace94_0_0 -> search41_1 in the cache */

/* replace94_0_1_0 -> search2_0 in the cache */
/* replace94_0_1 -> search15_0 in the cache */
static const nir_search_expression replace94_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search41_1.value, &search15_0.value },
   NULL,
};
static const nir_search_expression replace94 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace94_0.value },
   NULL,
};

   /* search95_0 -> replace60_0_0 in the cache */

/* search95_1_0_0_0 -> replace60_0_0 in the cache */

/* search95_1_0_0_1_0 -> search0_0 in the cache */
/* search95_1_0_0_1 -> search76_1_1_1 in the cache */
static const nir_search_expression search95_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_fadd,
   { &replace60_0_0.value, &search76_1_1_1.value },
   NULL,
};

/* search95_1_0_1_0 -> replace60_0_0 in the cache */

/* search95_1_0_1_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search95_1_0_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search95_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_fadd,
   { &replace60_0_0.value, &search95_1_0_1_1.value },
   NULL,
};
static const nir_search_expression search95_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_fmul,
   { &search95_1_0_0.value, &search95_1_0_1.value },
   NULL,
};
static const nir_search_expression search95_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_fneg,
   { &search95_1_0.value },
   NULL,
};
static const nir_search_expression search95 = {
   { nir_search_value_expression, 32 },
   true, false,
   0, 4,
   nir_op_fadd,
   { &replace60_0_0.value, &search95_1.value },
   NULL,
};

   /* replace95_0 -> replace0_1_0 in the cache */

/* replace95_1 -> replace60_0_0 in the cache */

/* replace95_2 -> search0_0 in the cache */
static const nir_search_expression replace95 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_flrp,
   { &replace0_1_0.value, &replace60_0_0.value, &search0_0.value },
   NULL,
};

   /* search96_0_0_0 -> search28_0_0 in the cache */

static const nir_search_variable search96_0_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search96_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &search96_0_0_1.value },
   NULL,
};

static const nir_search_variable search96_0_1 = {
   { nir_search_value_variable, -3 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search96_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search96_0_0.value, &search96_0_1.value },
   NULL,
};

/* search96_1 -> search80_0_1 in the cache */
static const nir_search_expression search96 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 2,
   nir_op_ishl,
   { &search96_0.value, &search80_0_1.value },
   NULL,
};

   /* replace96_0_0 -> search28_0_0 in the cache */

/* replace96_0_1_0 -> search28_0_1 in the cache */

/* replace96_0_1_1 -> search58_2 in the cache */
static const nir_search_expression replace96_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search28_0_1.value, &search58_2.value },
   NULL,
};
static const nir_search_expression replace96_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &replace96_0_1.value },
   NULL,
};

/* replace96_1_0 -> search28_1_1 in the cache */

/* replace96_1_1 -> search58_2 in the cache */
static const nir_search_expression replace96_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search28_1_1.value, &search58_2.value },
   NULL,
};
static const nir_search_expression replace96 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace96_0.value, &replace96_1.value },
   NULL,
};

   /* search97_0_0 -> search14_0 in the cache */

static const nir_search_variable search97_0_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search97_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &search97_0_1.value },
   NULL,
};

static const nir_search_variable search97_1 = {
   { nir_search_value_variable, 32 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search97 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search97_0.value, &search97_1.value },
   NULL,
};

   /* replace97_0 -> search14_0 in the cache */

/* replace97_1_0 -> replace14_1_0 in the cache */

/* replace97_1_1 -> search56_2 in the cache */
static const nir_search_expression replace97_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace14_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression replace97 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &replace97_1.value },
   NULL,
};

   static const nir_search_variable search98_0_0 = {
   { nir_search_value_variable, 8 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search98_0_1 -> search2_1 in the cache */
static const nir_search_expression search98_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search98_0_0.value, &search2_1.value },
   NULL,
};

/* search98_1 -> search97_1 in the cache */
static const nir_search_expression search98 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search98_0.value, &search97_1.value },
   NULL,
};

   /* replace98_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace98_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression replace98_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace98_0_0_1_0 -> search56_2 in the cache */

/* replace98_0_0_1_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace98_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace98_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace98_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace98_0_0_0.value, &replace98_0_0_1.value },
   NULL,
};

static const nir_search_constant replace98_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x8 /* 8 */ },
};
static const nir_search_expression replace98_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace98_0_0.value, &replace98_0_1.value },
   NULL,
};

/* replace98_1_0 -> search98_0_0 in the cache */

/* replace98_1_1_0 -> replace0_1_0 in the cache */

/* replace98_1_1_1 -> search56_2 in the cache */
static const nir_search_expression replace98_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &replace0_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression replace98_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search98_0_0.value, &replace98_1_1.value },
   NULL,
};

static const nir_search_constant replace98_2 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace98 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace98_0.value, &replace98_1.value, &replace98_2.value },
   NULL,
};

   /* search99_0_0 -> search98_0_0 in the cache */

/* search99_0_1 -> search2_1 in the cache */
static const nir_search_expression search99_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search98_0_0.value, &search2_1.value },
   NULL,
};

/* search99_1 -> search97_1 in the cache */
static const nir_search_expression search99 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search99_0.value, &search97_1.value },
   NULL,
};

   /* replace99_0_0_0_0 -> replace0_1_0 in the cache */

/* replace99_0_0_0_1 -> replace98_0_0_0_1 in the cache */
/* replace99_0_0_0 -> replace98_0_0_0 in the cache */

/* replace99_0_0_1_0 -> search56_2 in the cache */

/* replace99_0_0_1_1 -> replace98_0_0_0_1 in the cache */
/* replace99_0_0_1 -> replace98_0_0_1 in the cache */
/* replace99_0_0 -> replace98_0_0 in the cache */

/* replace99_0_1 -> replace98_0_1 in the cache */
/* replace99_0 -> replace98_0 in the cache */

/* replace99_1_0 -> search98_0_0 in the cache */

/* replace99_1_1_0 -> replace0_1_0 in the cache */

/* replace99_1_1_1 -> search56_2 in the cache */
/* replace99_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace99_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search98_0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace99_2 -> replace98_2 in the cache */
static const nir_search_expression replace99 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace98_0.value, &replace99_1.value, &replace98_2.value },
   NULL,
};

   /* search100_0_0 -> search98_0_0 in the cache */

/* search100_0_1 -> search2_1 in the cache */
static const nir_search_expression search100_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search98_0_0.value, &search2_1.value },
   NULL,
};

/* search100_1 -> search97_1 in the cache */
static const nir_search_expression search100 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search100_0.value, &search97_1.value },
   NULL,
};

   /* replace100_0 -> search98_0_0 in the cache */

/* replace100_1_0_0_0 -> replace0_1_0 in the cache */

/* replace100_1_0_0_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace100_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace100_1_0_1_0 -> search56_2 in the cache */

/* replace100_1_0_1_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace100_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace98_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace100_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace100_1_0_0.value, &replace100_1_0_1.value },
   NULL,
};

static const nir_search_constant replace100_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace100_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace100_1_0.value, &replace100_1_1.value },
   NULL,
};
static const nir_search_expression replace100 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search98_0_0.value, &replace100_1.value },
   NULL,
};

   static const nir_search_variable search101_0_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search101_0_1 -> search2_1 in the cache */
static const nir_search_expression search101_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &search2_1.value },
   NULL,
};

/* search101_1 -> search97_1 in the cache */
static const nir_search_expression search101 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0.value, &search97_1.value },
   NULL,
};

   /* replace101_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace101_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff /* 65535 */ },
};
static const nir_search_expression replace101_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace101_0_0_1_0 -> search56_2 in the cache */

/* replace101_0_0_1_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace101_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace101_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace101_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace101_0_0_0.value, &replace101_0_0_1.value },
   NULL,
};

static const nir_search_constant replace101_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x10 /* 16 */ },
};
static const nir_search_expression replace101_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace101_0_0.value, &replace101_0_1.value },
   NULL,
};

/* replace101_1_0 -> search101_0_0 in the cache */

/* replace101_1_1_0 -> replace0_1_0 in the cache */

/* replace101_1_1_1 -> search56_2 in the cache */
/* replace101_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace101_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search101_0_0.value, &replace98_1_1.value },
   NULL,
};

static const nir_search_constant replace101_2 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace101 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace101_0.value, &replace101_1.value, &replace101_2.value },
   NULL,
};

   /* search102_0_0 -> search101_0_0 in the cache */

/* search102_0_1 -> search2_1 in the cache */
static const nir_search_expression search102_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &search2_1.value },
   NULL,
};

/* search102_1 -> search97_1 in the cache */
static const nir_search_expression search102 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search102_0.value, &search97_1.value },
   NULL,
};

   /* replace102_0_0_0_0 -> replace0_1_0 in the cache */

/* replace102_0_0_0_1 -> replace101_0_0_0_1 in the cache */
/* replace102_0_0_0 -> replace101_0_0_0 in the cache */

/* replace102_0_0_1_0 -> search56_2 in the cache */

/* replace102_0_0_1_1 -> replace101_0_0_0_1 in the cache */
/* replace102_0_0_1 -> replace101_0_0_1 in the cache */
/* replace102_0_0 -> replace101_0_0 in the cache */

/* replace102_0_1 -> replace101_0_1 in the cache */
/* replace102_0 -> replace101_0 in the cache */

/* replace102_1_0 -> search101_0_0 in the cache */

/* replace102_1_1_0 -> replace0_1_0 in the cache */

/* replace102_1_1_1 -> search56_2 in the cache */
/* replace102_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace102_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search101_0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace102_2 -> replace101_2 in the cache */
static const nir_search_expression replace102 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace101_0.value, &replace102_1.value, &replace101_2.value },
   NULL,
};

   /* search103_0_0 -> search101_0_0 in the cache */

/* search103_0_1 -> search2_1 in the cache */
static const nir_search_expression search103_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search101_0_0.value, &search2_1.value },
   NULL,
};

/* search103_1 -> search97_1 in the cache */
static const nir_search_expression search103 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search103_0.value, &search97_1.value },
   NULL,
};

   /* replace103_0 -> search101_0_0 in the cache */

/* replace103_1_0_0_0 -> replace0_1_0 in the cache */

/* replace103_1_0_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace103_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace103_1_0_1_0 -> search56_2 in the cache */

/* replace103_1_0_1_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace103_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace101_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace103_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace103_1_0_0.value, &replace103_1_0_1.value },
   NULL,
};

static const nir_search_constant replace103_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xf /* 15 */ },
};
static const nir_search_expression replace103_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace103_1_0.value, &replace103_1_1.value },
   NULL,
};
static const nir_search_expression replace103 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search101_0_0.value, &replace103_1.value },
   NULL,
};

   /* search104_0_0 -> search0_0 in the cache */

/* search104_0_1 -> search2_1 in the cache */
static const nir_search_expression search104_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search2_1.value },
   NULL,
};

/* search104_1 -> search97_1 in the cache */
static const nir_search_expression search104 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search104_0.value, &search97_1.value },
   NULL,
};

   /* replace104_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace104_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression replace104_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace104_0_0_0_1.value },
   NULL,
};

/* replace104_0_0_1_0 -> search56_2 in the cache */

/* replace104_0_0_1_1 -> replace104_0_0_0_1 in the cache */
static const nir_search_expression replace104_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace104_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace104_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace104_0_0_0.value, &replace104_0_0_1.value },
   NULL,
};

static const nir_search_constant replace104_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x20 /* 32 */ },
};
static const nir_search_expression replace104_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace104_0_0.value, &replace104_0_1.value },
   NULL,
};

/* replace104_1_0 -> search0_0 in the cache */

/* replace104_1_1_0 -> replace0_1_0 in the cache */

/* replace104_1_1_1 -> search56_2 in the cache */
/* replace104_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace104_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace104_2 -> search26_1 in the cache */
static const nir_search_expression replace104 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace104_0.value, &replace104_1.value, &search26_1.value },
   NULL,
};

   /* search105_0_0 -> search0_0 in the cache */

/* search105_0_1 -> search2_1 in the cache */
static const nir_search_expression search105_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search2_1.value },
   NULL,
};

/* search105_1 -> search97_1 in the cache */
static const nir_search_expression search105 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search105_0.value, &search97_1.value },
   NULL,
};

   /* replace105_0_0_0_0 -> replace0_1_0 in the cache */

/* replace105_0_0_0_1 -> replace104_0_0_0_1 in the cache */
/* replace105_0_0_0 -> replace104_0_0_0 in the cache */

/* replace105_0_0_1_0 -> search56_2 in the cache */

/* replace105_0_0_1_1 -> replace104_0_0_0_1 in the cache */
/* replace105_0_0_1 -> replace104_0_0_1 in the cache */
/* replace105_0_0 -> replace104_0_0 in the cache */

/* replace105_0_1 -> replace104_0_1 in the cache */
/* replace105_0 -> replace104_0 in the cache */

/* replace105_1_0 -> search0_0 in the cache */

/* replace105_1_1_0 -> replace0_1_0 in the cache */

/* replace105_1_1_1 -> search56_2 in the cache */
/* replace105_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace105_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &replace98_1_1.value },
   NULL,
};

/* replace105_2 -> search26_1 in the cache */
static const nir_search_expression replace105 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace104_0.value, &replace105_1.value, &search26_1.value },
   NULL,
};

   /* search106_0_0 -> search0_0 in the cache */

/* search106_0_1 -> search2_1 in the cache */
static const nir_search_expression search106_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &search2_1.value },
   NULL,
};

/* search106_1 -> search97_1 in the cache */
static const nir_search_expression search106 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search106_0.value, &search97_1.value },
   NULL,
};

   /* replace106_0 -> search0_0 in the cache */

/* replace106_1_0_0_0 -> replace0_1_0 in the cache */

/* replace106_1_0_0_1 -> replace104_0_0_0_1 in the cache */
static const nir_search_expression replace106_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace104_0_0_0_1.value },
   NULL,
};

/* replace106_1_0_1_0 -> search56_2 in the cache */

/* replace106_1_0_1_1 -> replace104_0_0_0_1 in the cache */
static const nir_search_expression replace106_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace104_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace106_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace106_1_0_0.value, &replace106_1_0_1.value },
   NULL,
};

static const nir_search_constant replace106_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1f /* 31 */ },
};
static const nir_search_expression replace106_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace106_1_0.value, &replace106_1_1.value },
   NULL,
};
static const nir_search_expression replace106 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search0_0.value, &replace106_1.value },
   NULL,
};

   /* search107_0_0 -> search57_0 in the cache */

/* search107_0_1 -> search2_1 in the cache */
static const nir_search_expression search107_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search2_1.value },
   NULL,
};

/* search107_1 -> search97_1 in the cache */
static const nir_search_expression search107 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search107_0.value, &search97_1.value },
   NULL,
};

   /* replace107_0_0_0_0 -> replace0_1_0 in the cache */

static const nir_search_constant replace107_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffffffffffffffffL /* 18446744073709551615 */ },
};
static const nir_search_expression replace107_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace107_0_0_0_1.value },
   NULL,
};

/* replace107_0_0_1_0 -> search56_2 in the cache */

/* replace107_0_0_1_1 -> replace107_0_0_0_1 in the cache */
static const nir_search_expression replace107_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &search56_2.value, &replace107_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace107_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &replace107_0_0_0.value, &replace107_0_0_1.value },
   NULL,
};

static const nir_search_constant replace107_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x40 /* 64 */ },
};
static const nir_search_expression replace107_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_ult,
   { &replace107_0_0.value, &replace107_0_1.value },
   NULL,
};

/* replace107_1_0 -> search57_0 in the cache */

/* replace107_1_1_0 -> replace0_1_0 in the cache */

/* replace107_1_1_1 -> search56_2 in the cache */
/* replace107_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace107_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search57_0.value, &replace98_1_1.value },
   NULL,
};

static const nir_search_constant replace107_2 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace107 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace107_0.value, &replace107_1.value, &replace107_2.value },
   NULL,
};

   /* search108_0_0 -> search57_0 in the cache */

/* search108_0_1 -> search2_1 in the cache */
static const nir_search_expression search108_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search2_1.value },
   NULL,
};

/* search108_1 -> search97_1 in the cache */
static const nir_search_expression search108 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search108_0.value, &search97_1.value },
   NULL,
};

   /* replace108_0_0_0_0 -> replace0_1_0 in the cache */

/* replace108_0_0_0_1 -> replace107_0_0_0_1 in the cache */
/* replace108_0_0_0 -> replace107_0_0_0 in the cache */

/* replace108_0_0_1_0 -> search56_2 in the cache */

/* replace108_0_0_1_1 -> replace107_0_0_0_1 in the cache */
/* replace108_0_0_1 -> replace107_0_0_1 in the cache */
/* replace108_0_0 -> replace107_0_0 in the cache */

/* replace108_0_1 -> replace107_0_1 in the cache */
/* replace108_0 -> replace107_0 in the cache */

/* replace108_1_0 -> search57_0 in the cache */

/* replace108_1_1_0 -> replace0_1_0 in the cache */

/* replace108_1_1_1 -> search56_2 in the cache */
/* replace108_1_1 -> replace98_1_1 in the cache */
static const nir_search_expression replace108_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search57_0.value, &replace98_1_1.value },
   NULL,
};

/* replace108_2 -> replace107_2 in the cache */
static const nir_search_expression replace108 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace107_0.value, &replace108_1.value, &replace107_2.value },
   NULL,
};

   /* search109_0_0 -> search57_0 in the cache */

/* search109_0_1 -> search2_1 in the cache */
static const nir_search_expression search109_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search2_1.value },
   NULL,
};

/* search109_1 -> search97_1 in the cache */
static const nir_search_expression search109 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search109_0.value, &search97_1.value },
   NULL,
};

   /* replace109_0 -> search57_0 in the cache */

/* replace109_1_0_0_0 -> replace0_1_0 in the cache */

/* replace109_1_0_0_1 -> replace107_0_0_0_1 in the cache */
static const nir_search_expression replace109_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace0_1_0.value, &replace107_0_0_0_1.value },
   NULL,
};

/* replace109_1_0_1_0 -> search56_2 in the cache */

/* replace109_1_0_1_1 -> replace107_0_0_0_1 in the cache */
static const nir_search_expression replace109_1_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iand,
   { &search56_2.value, &replace107_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace109_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 3,
   nir_op_iadd,
   { &replace109_1_0_0.value, &replace109_1_0_1.value },
   NULL,
};

static const nir_search_constant replace109_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3f /* 63 */ },
};
static const nir_search_expression replace109_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 4,
   nir_op_imin,
   { &replace109_1_0.value, &replace109_1_1.value },
   NULL,
};
static const nir_search_expression replace109 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_ishr,
   { &search57_0.value, &replace109_1.value },
   NULL,
};

   /* search110_0_0 -> search14_0 in the cache */

/* search110_0_1 -> search97_0_1 in the cache */
static const nir_search_expression search110_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &search97_0_1.value },
   NULL,
};

/* search110_1 -> search97_1 in the cache */
static const nir_search_expression search110 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search110_0.value, &search97_1.value },
   NULL,
};

   /* replace110_0_0 -> search14_0 in the cache */

/* replace110_0_1 -> search56_2 in the cache */
static const nir_search_expression replace110_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search14_0.value, &search56_2.value },
   NULL,
};

/* replace110_1_0 -> replace14_1_0 in the cache */

/* replace110_1_1 -> search56_2 in the cache */
/* replace110_1 -> replace97_1 in the cache */
static const nir_search_expression replace110 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &replace110_0.value, &replace97_1.value },
   NULL,
};

   /* search111_0_0 -> search14_0 in the cache */

/* search111_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search111_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search111 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_inot,
   { &search111_0.value },
   NULL,
};

   /* replace111_0 -> search14_0 in the cache */

/* replace111_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace111 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search112_0_0 -> search14_0 in the cache */

/* search112_0_1 -> replace14_1_0 in the cache */
/* search112_0 -> replace111 in the cache */
static const nir_search_expression search112 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_inot,
   { &replace111.value },
   NULL,
};

   /* replace112_0 -> search14_0 in the cache */

/* replace112_1 -> replace14_1_0 in the cache */
/* replace112 -> search111_0 in the cache */

   /* search113_0_0 -> search14_0 in the cache */

/* search113_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search113_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search113 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search113_0.value },
   NULL,
};

   /* replace113_0 -> search14_0 in the cache */

/* replace113_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace113 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search114_0_0 -> search14_0 in the cache */

/* search114_0_1 -> replace14_1_0 in the cache */
/* search114_0 -> replace113 in the cache */
static const nir_search_expression search114 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace113.value },
   NULL,
};

   /* replace114_0 -> search14_0 in the cache */

/* replace114_1 -> replace14_1_0 in the cache */
/* replace114 -> search113_0 in the cache */

   /* search115_0_0 -> search14_0 in the cache */

/* search115_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search115_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search115 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search115_0.value },
   NULL,
};

   /* replace115_0 -> search14_0 in the cache */

/* replace115_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace115 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search116_0_0 -> search14_0 in the cache */

/* search116_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search116_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search116 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search116_0.value },
   NULL,
};

   /* replace116_0 -> search14_0 in the cache */

/* replace116_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace116 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search117_0_0 -> search14_0 in the cache */

/* search117_0_1 -> replace14_1_0 in the cache */
/* search117_0 -> replace115 in the cache */
static const nir_search_expression search117 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace115.value },
   NULL,
};

   /* replace117_0 -> search14_0 in the cache */

/* replace117_1 -> replace14_1_0 in the cache */
/* replace117 -> search115_0 in the cache */

   /* search118_0_0 -> search14_0 in the cache */

/* search118_0_1 -> replace14_1_0 in the cache */
/* search118_0 -> replace116 in the cache */
static const nir_search_expression search118 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace116.value },
   NULL,
};

   /* replace118_0 -> search14_0 in the cache */

/* replace118_1 -> replace14_1_0 in the cache */
/* replace118 -> search116_0 in the cache */

   /* search119_0_0 -> search14_0 in the cache */

/* search119_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search119_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search119 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search119_0.value },
   NULL,
};

   /* replace119_0 -> search14_0 in the cache */

/* replace119_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace119 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search120_0_0 -> search14_0 in the cache */

/* search120_0_1 -> replace14_1_0 in the cache */
/* search120_0 -> replace119 in the cache */
static const nir_search_expression search120 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace119.value },
   NULL,
};

   /* replace120_0 -> search14_0 in the cache */

/* replace120_1 -> replace14_1_0 in the cache */
/* replace120 -> search119_0 in the cache */

   /* search121_0_0 -> search14_0 in the cache */

/* search121_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search121_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_feq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search121_1_0 -> search14_0 in the cache */

/* search121_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search121_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fne,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search121 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search121_0.value, &search121_1.value },
   NULL,
};

   static const nir_search_constant replace121 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_FALSE /* False */ },
};

   /* search122_0_0 -> search14_0 in the cache */

/* search122_0_1 -> replace14_1_0 in the cache */
/* search122_0 -> search111_0 in the cache */

/* search122_1_0 -> replace14_1_0 in the cache */

/* search122_1_1 -> search14_0 in the cache */
static const nir_search_expression search122_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};
static const nir_search_expression search122 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search111_0.value, &search122_1.value },
   NULL,
};

   /* replace122 -> replace121 in the cache */

   /* search123_0_0 -> search14_0 in the cache */

/* search123_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search123_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search123_1_0 -> search14_0 in the cache */

/* search123_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search123_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search123 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search123_0.value, &search123_1.value },
   NULL,
};

   /* replace123 -> replace121 in the cache */

   /* search124_0_0 -> search14_0 in the cache */

/* search124_0_1 -> replace14_1_0 in the cache */
/* search124_0 -> search115_0 in the cache */

/* search124_1_0 -> replace14_1_0 in the cache */

/* search124_1_1 -> search14_0 in the cache */
static const nir_search_expression search124_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};
static const nir_search_expression search124 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search115_0.value, &search124_1.value },
   NULL,
};

   /* replace124 -> replace121 in the cache */

   /* search125_0_0 -> search14_0 in the cache */

/* search125_0_1 -> replace14_1_0 in the cache */
/* search125_0 -> search116_0 in the cache */

/* search125_1_0 -> replace14_1_0 in the cache */

/* search125_1_1 -> search14_0 in the cache */
static const nir_search_expression search125_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};
static const nir_search_expression search125 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search116_0.value, &search125_1.value },
   NULL,
};

   /* replace125 -> replace121 in the cache */

   /* search126_0_0 -> search14_0 in the cache */
/* search126_0 -> search34_0 in the cache */

/* search126_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression search126_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search126 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search34_0.value, &search126_1.value },
   NULL,
};

   /* replace126_0 -> replace14_1_0 in the cache */

/* replace126_1 -> search14_0 in the cache */
/* replace126 -> search122_1 in the cache */

   /* search127_0_0 -> search14_0 in the cache */
/* search127_0 -> search34_0 in the cache */

/* search127_1_0 -> replace14_1_0 in the cache */
/* search127_1 -> search126_1 in the cache */
static const nir_search_expression search127 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search34_0.value, &search126_1.value },
   NULL,
};

   /* replace127_0 -> replace14_1_0 in the cache */

/* replace127_1 -> search14_0 in the cache */
static const nir_search_expression replace127 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search128_0_0 -> search14_0 in the cache */
/* search128_0 -> search34_0 in the cache */

/* search128_1_0 -> replace14_1_0 in the cache */
/* search128_1 -> search126_1 in the cache */
static const nir_search_expression search128 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search34_0.value, &search126_1.value },
   NULL,
};

   /* replace128_0 -> replace14_1_0 in the cache */

/* replace128_1 -> search14_0 in the cache */
static const nir_search_expression replace128 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search129_0_0 -> search14_0 in the cache */
/* search129_0 -> search34_0 in the cache */

/* search129_1_0 -> replace14_1_0 in the cache */
/* search129_1 -> search126_1 in the cache */
static const nir_search_expression search129 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search34_0.value, &search126_1.value },
   NULL,
};

   /* replace129_0 -> replace14_1_0 in the cache */

/* replace129_1 -> search14_0 in the cache */
static const nir_search_expression replace129 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search130_0_0 -> search2_0 in the cache */
/* search130_0 -> search15_0 in the cache */

/* search130_1 -> search43_1 in the cache */
static const nir_search_expression search130 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search15_0.value, &search43_1.value },
   NULL,
};

   /* replace130_0 -> search41_1 in the cache */

/* replace130_1 -> search2_0 in the cache */
static const nir_search_expression replace130 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* search131_0 -> search43_1 in the cache */

/* search131_1_0 -> search2_0 in the cache */
/* search131_1 -> search15_0 in the cache */
static const nir_search_expression search131 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search43_1.value, &search15_0.value },
   NULL,
};

   /* replace131_0 -> search2_0 in the cache */

/* replace131_1 -> search41_1 in the cache */
static const nir_search_expression replace131 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* search132_0_0 -> search2_0 in the cache */
/* search132_0 -> search15_0 in the cache */

/* search132_1 -> search43_1 in the cache */
static const nir_search_expression search132 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search15_0.value, &search43_1.value },
   NULL,
};

   /* replace132_0 -> search41_1 in the cache */

/* replace132_1 -> search2_0 in the cache */
static const nir_search_expression replace132 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* search133_0 -> search43_1 in the cache */

/* search133_1_0 -> search2_0 in the cache */
/* search133_1 -> search15_0 in the cache */
static const nir_search_expression search133 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search43_1.value, &search15_0.value },
   NULL,
};

   /* replace133_0 -> search2_0 in the cache */

/* replace133_1 -> search41_1 in the cache */
static const nir_search_expression replace133 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* search134_0_0 -> search2_0 in the cache */
/* search134_0 -> search15_0 in the cache */

/* search134_1 -> search43_1 in the cache */
static const nir_search_expression search134 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search15_0.value, &search43_1.value },
   NULL,
};

   /* replace134_0 -> search41_1 in the cache */

/* replace134_1 -> search2_0 in the cache */
static const nir_search_expression replace134 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* search135_0 -> search43_1 in the cache */

/* search135_1_0 -> search2_0 in the cache */
/* search135_1 -> search15_0 in the cache */
static const nir_search_expression search135 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search43_1.value, &search15_0.value },
   NULL,
};

   /* replace135_0 -> search2_0 in the cache */

/* replace135_1 -> search41_1 in the cache */
static const nir_search_expression replace135 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* search136_0_0 -> search14_0 in the cache */
static const nir_search_expression search136_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search14_0.value },
   (is_used_once),
};

static const nir_search_variable search136_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3},
};
static const nir_search_expression search136 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search136_0.value, &search136_1.value },
   NULL,
};

   /* replace136_0 -> search14_0 in the cache */

/* replace136_1 -> replace14_1_0 in the cache */
/* replace136 -> search111_0 in the cache */

   static const nir_search_variable search137_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   true,
   nir_type_invalid,
   (is_gt_0_and_lt_1),
   {0, 1, 2, 3},
};

static const nir_search_variable search137_1_0 = {
   { nir_search_value_variable, -2 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search137_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search137_1_0.value },
   (is_used_once),
};
static const nir_search_expression search137 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search137_0.value, &search137_1.value },
   NULL,
};

   static const nir_search_variable replace137_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* replace137_1 -> search137_1_0 in the cache */
static const nir_search_expression replace137 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace137_0.value, &search137_1_0.value },
   NULL,
};

   /* search138_0_0 -> search14_0 in the cache */
/* search138_0 -> search136_0 in the cache */

/* search138_1 -> search136_1 in the cache */
static const nir_search_expression search138 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search136_0.value, &search136_1.value },
   NULL,
};

   /* replace138_0 -> search14_0 in the cache */

/* replace138_1 -> replace14_1_0 in the cache */
/* replace138 -> replace111 in the cache */

   /* search139_0 -> search137_0 in the cache */

/* search139_1_0 -> search137_1_0 in the cache */
/* search139_1 -> search137_1 in the cache */
static const nir_search_expression search139 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search137_0.value, &search137_1.value },
   NULL,
};

   /* replace139_0 -> replace137_0 in the cache */

/* replace139_1 -> search137_1_0 in the cache */
static const nir_search_expression replace139 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace137_0.value, &search137_1_0.value },
   NULL,
};

   /* search140_0_0 -> search14_0 in the cache */
/* search140_0 -> search136_0 in the cache */

/* search140_1 -> search136_1 in the cache */
static const nir_search_expression search140 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search136_0.value, &search136_1.value },
   NULL,
};

   /* replace140_0 -> search14_0 in the cache */

/* replace140_1 -> replace14_1_0 in the cache */
/* replace140 -> search113_0 in the cache */

   /* search141_0_0 -> search14_0 in the cache */
/* search141_0 -> search136_0 in the cache */

/* search141_1 -> search136_1 in the cache */
static const nir_search_expression search141 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search136_0.value, &search136_1.value },
   NULL,
};

   /* replace141_0 -> search14_0 in the cache */

/* replace141_1 -> replace14_1_0 in the cache */
/* replace141 -> replace113 in the cache */

   /* search142_0_0 -> search2_0 in the cache */
static const nir_search_expression search142_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search2_0.value },
   (is_used_once),
};

/* search142_1 -> search41_1 in the cache */
static const nir_search_expression search142 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search142_0.value, &search41_1.value },
   NULL,
};

   /* replace142_0 -> search2_0 in the cache */

/* replace142_1 -> search41_1 in the cache */
/* replace142 -> replace133 in the cache */

   /* search143_0_0 -> search2_0 in the cache */
/* search143_0 -> search142_0 in the cache */

/* search143_1 -> search41_1 in the cache */
static const nir_search_expression search143 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search142_0.value, &search41_1.value },
   NULL,
};

   /* replace143_0 -> search2_0 in the cache */

/* replace143_1 -> search41_1 in the cache */
/* replace143 -> replace131 in the cache */

   /* search144_0 -> search24_1 in the cache */

/* search144_1_0 -> search2_0 in the cache */
/* search144_1 -> search142_0 in the cache */
static const nir_search_expression search144 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search24_1.value, &search142_0.value },
   NULL,
};

   /* replace144_0 -> search24_1 in the cache */

/* replace144_1 -> search2_0 in the cache */
static const nir_search_expression replace144 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search24_1.value, &search2_0.value },
   NULL,
};

   /* search145_0 -> search24_1 in the cache */

/* search145_1_0 -> search2_0 in the cache */
/* search145_1 -> search142_0 in the cache */
static const nir_search_expression search145 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search24_1.value, &search142_0.value },
   NULL,
};

   /* replace145_0 -> search24_1 in the cache */

/* replace145_1 -> search2_0 in the cache */
static const nir_search_expression replace145 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search24_1.value, &search2_0.value },
   NULL,
};

   static const nir_search_constant search146_0 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search146_1_0 -> replace80_0 in the cache */
static const nir_search_expression search146_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};
static const nir_search_expression search146 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search146_0.value, &search146_1.value },
   NULL,
};

   /* replace146_0 -> replace80_0 in the cache */
static const nir_search_expression replace146 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace80_0.value },
   NULL,
};

   /* search147_0_0_0 -> replace80_0 in the cache */
/* search147_0_0 -> search146_1 in the cache */
static const nir_search_expression search147_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search146_1.value },
   NULL,
};

/* search147_1 -> search146_0 in the cache */
static const nir_search_expression search147 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search147_0.value, &search146_0.value },
   NULL,
};

   /* replace147_0 -> replace80_0 in the cache */
/* replace147 -> replace146 in the cache */

   /* search148_0_0_0 -> replace80_0 in the cache */
/* search148_0_0 -> search146_1 in the cache */

static const nir_search_variable search148_0_1_0 = {
   { nir_search_value_variable, 1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search148_0_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search148_0_1_0.value },
   NULL,
};
static const nir_search_expression search148_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

/* search148_1 -> search146_0 in the cache */
static const nir_search_expression search148 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search148_0.value, &search146_0.value },
   NULL,
};

   /* replace148_0 -> replace80_0 in the cache */

/* replace148_1 -> search148_0_1_0 in the cache */
static const nir_search_expression replace148 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace80_0.value, &search148_0_1_0.value },
   NULL,
};

   /* search149_0_0_0 -> replace80_0 in the cache */
/* search149_0_0 -> search146_1 in the cache */

/* search149_0_1_0 -> search148_0_1_0 in the cache */
/* search149_0_1 -> search148_0_1 in the cache */
static const nir_search_expression search149_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

/* search149_1 -> search146_0 in the cache */
static const nir_search_expression search149 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search149_0.value, &search146_0.value },
   NULL,
};

   /* replace149_0 -> replace80_0 in the cache */

/* replace149_1 -> search148_0_1_0 in the cache */
/* replace149 -> replace148 in the cache */

   /* search150_0_0 -> replace80_0 in the cache */

static const nir_search_constant search150_0_1 = {
   { nir_search_value_constant, 0 },
   nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
};

/* search150_0_2_0 -> search148_0_1_0 in the cache */
/* search150_0_2 -> search148_0_1 in the cache */
static const nir_search_expression search150_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search150_0_1.value, &search148_0_1.value },
   NULL,
};

/* search150_1 -> search146_0 in the cache */
static const nir_search_expression search150 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search150_0.value, &search146_0.value },
   NULL,
};

   /* replace150_0 -> replace80_0 in the cache */

/* replace150_1 -> search148_0_1_0 in the cache */
/* replace150 -> replace148 in the cache */

   /* search151_0_0 -> replace80_0 in the cache */
/* search151_0 -> search146_1 in the cache */

/* search151_1_0_0 -> search148_0_1_0 in the cache */
/* search151_1_0 -> search148_0_1 in the cache */
static const nir_search_expression search151_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search148_0_1.value },
   NULL,
};
static const nir_search_expression search151 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search146_1.value, &search151_1.value },
   NULL,
};

   /* replace151_0 -> replace80_0 in the cache */

/* replace151_1 -> search148_0_1_0 in the cache */
/* replace151 -> replace148 in the cache */

   /* search152_0_0_0 -> replace80_0 in the cache */
/* search152_0_0 -> search146_1 in the cache */

/* search152_0_1_0 -> search148_0_1_0 in the cache */
/* search152_0_1 -> search148_0_1 in the cache */
static const nir_search_expression search152_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

/* search152_1 -> search146_0 in the cache */
static const nir_search_expression search152 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search152_0.value, &search146_0.value },
   NULL,
};

   /* replace152_0 -> replace80_0 in the cache */

/* replace152_1 -> search148_0_1_0 in the cache */
static const nir_search_expression replace152 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace80_0.value, &search148_0_1_0.value },
   NULL,
};

   /* search153_0_0_0 -> replace80_0 in the cache */
/* search153_0_0 -> search146_1 in the cache */

/* search153_0_1_0 -> search148_0_1_0 in the cache */
/* search153_0_1 -> search148_0_1 in the cache */
static const nir_search_expression search153_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

/* search153_1 -> search146_0 in the cache */
static const nir_search_expression search153 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search153_0.value, &search146_0.value },
   NULL,
};

   /* replace153_0 -> replace80_0 in the cache */

/* replace153_1 -> search148_0_1_0 in the cache */
/* replace153 -> replace152 in the cache */

   /* search154_0_0 -> replace80_0 in the cache */

/* search154_0_1_0 -> search148_0_1_0 in the cache */
/* search154_0_1 -> search148_0_1 in the cache */

/* search154_0_2 -> search146_0 in the cache */
static const nir_search_expression search154_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search148_0_1.value, &search146_0.value },
   NULL,
};

/* search154_1 -> search146_0 in the cache */
static const nir_search_expression search154 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search154_0.value, &search146_0.value },
   NULL,
};

   /* replace154_0 -> replace80_0 in the cache */

/* replace154_1 -> search148_0_1_0 in the cache */
/* replace154 -> replace152 in the cache */

   /* search155_0_0_0 -> replace80_0 in the cache */
/* search155_0_0 -> search146_1 in the cache */

/* search155_0_1_0_0 -> search148_0_1_0 in the cache */
/* search155_0_1_0 -> search148_0_1 in the cache */
/* search155_0_1 -> search151_1 in the cache */
static const nir_search_expression search155_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search146_1.value, &search151_1.value },
   NULL,
};

/* search155_1 -> search146_0 in the cache */
static const nir_search_expression search155 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search155_0.value, &search146_0.value },
   NULL,
};

   /* replace155_0 -> replace80_0 in the cache */

/* replace155_1 -> search148_0_1_0 in the cache */
static const nir_search_expression replace155 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &replace80_0.value, &search148_0_1_0.value },
   NULL,
};

   /* search156_0_0 -> replace80_0 in the cache */
/* search156_0 -> search146_1 in the cache */

/* search156_1_0 -> search148_0_1_0 in the cache */
/* search156_1 -> search148_0_1 in the cache */
static const nir_search_expression search156 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

   /* replace156_0 -> replace80_0 in the cache */

/* replace156_1 -> search148_0_1_0 in the cache */
/* replace156 -> replace155 in the cache */

   /* search157_0_0_0 -> replace80_0 in the cache */
/* search157_0_0 -> search146_1 in the cache */
/* search157_0 -> search147_0 in the cache */

/* search157_1_0_0 -> search148_0_1_0 in the cache */
/* search157_1_0 -> search148_0_1 in the cache */
/* search157_1 -> search151_1 in the cache */
static const nir_search_expression search157 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search147_0.value, &search151_1.value },
   NULL,
};

   /* replace157_0 -> replace80_0 in the cache */

/* replace157_1 -> search148_0_1_0 in the cache */
/* replace157 -> replace155 in the cache */

   /* search158_0_0_0 -> replace80_0 in the cache */
/* search158_0_0 -> search146_1 in the cache */

/* search158_0_1_0 -> search148_0_1_0 in the cache */
/* search158_0_1 -> search148_0_1 in the cache */
/* search158_0 -> search148_0 in the cache */

/* search158_1 -> search146_0 in the cache */
static const nir_search_expression search158 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search148_0.value, &search146_0.value },
   NULL,
};

   /* replace158_0_0 -> replace80_0 in the cache */

/* replace158_0_1 -> search148_0_1_0 in the cache */
/* replace158_0 -> replace148 in the cache */
static const nir_search_expression replace158 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace148.value },
   NULL,
};

   /* search159_0_0_0 -> replace80_0 in the cache */
/* search159_0_0 -> search146_1 in the cache */

/* search159_0_1_0 -> search148_0_1_0 in the cache */
/* search159_0_1 -> search148_0_1 in the cache */
/* search159_0 -> search149_0 in the cache */

/* search159_1 -> search146_0 in the cache */
static const nir_search_expression search159 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search149_0.value, &search146_0.value },
   NULL,
};

   /* replace159_0_0 -> replace80_0 in the cache */

/* replace159_0_1 -> search148_0_1_0 in the cache */
/* replace159_0 -> replace148 in the cache */
/* replace159 -> replace158 in the cache */

   /* search160_0_0 -> replace80_0 in the cache */

/* search160_0_1 -> search150_0_1 in the cache */

/* search160_0_2_0 -> search148_0_1_0 in the cache */
/* search160_0_2 -> search148_0_1 in the cache */
/* search160_0 -> search150_0 in the cache */

/* search160_1 -> search146_0 in the cache */
static const nir_search_expression search160 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search150_0.value, &search146_0.value },
   NULL,
};

   /* replace160_0_0 -> replace80_0 in the cache */

/* replace160_0_1 -> search148_0_1_0 in the cache */
/* replace160_0 -> replace148 in the cache */
/* replace160 -> replace158 in the cache */

   /* search161_0_0 -> replace80_0 in the cache */
/* search161_0 -> search146_1 in the cache */

/* search161_1_0_0 -> search148_0_1_0 in the cache */
/* search161_1_0 -> search148_0_1 in the cache */
/* search161_1 -> search151_1 in the cache */
static const nir_search_expression search161 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search146_1.value, &search151_1.value },
   NULL,
};

   /* replace161_0_0 -> replace80_0 in the cache */

/* replace161_0_1 -> search148_0_1_0 in the cache */
/* replace161_0 -> replace148 in the cache */
/* replace161 -> replace158 in the cache */

   /* search162_0_0_0 -> replace80_0 in the cache */
/* search162_0_0 -> search146_1 in the cache */

/* search162_0_1_0 -> search148_0_1_0 in the cache */
/* search162_0_1 -> search148_0_1 in the cache */
/* search162_0 -> search152_0 in the cache */

/* search162_1 -> search146_0 in the cache */
static const nir_search_expression search162 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search152_0.value, &search146_0.value },
   NULL,
};

   /* replace162_0_0 -> replace80_0 in the cache */

/* replace162_0_1 -> search148_0_1_0 in the cache */
/* replace162_0 -> replace152 in the cache */
static const nir_search_expression replace162 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace152.value },
   NULL,
};

   /* search163_0_0_0 -> replace80_0 in the cache */
/* search163_0_0 -> search146_1 in the cache */

/* search163_0_1_0 -> search148_0_1_0 in the cache */
/* search163_0_1 -> search148_0_1 in the cache */
/* search163_0 -> search153_0 in the cache */

/* search163_1 -> search146_0 in the cache */
static const nir_search_expression search163 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search153_0.value, &search146_0.value },
   NULL,
};

   /* replace163_0_0 -> replace80_0 in the cache */

/* replace163_0_1 -> search148_0_1_0 in the cache */
/* replace163_0 -> replace152 in the cache */
/* replace163 -> replace162 in the cache */

   /* search164_0_0 -> replace80_0 in the cache */

/* search164_0_1_0 -> search148_0_1_0 in the cache */
/* search164_0_1 -> search148_0_1 in the cache */

/* search164_0_2 -> search146_0 in the cache */
/* search164_0 -> search154_0 in the cache */

/* search164_1 -> search146_0 in the cache */
static const nir_search_expression search164 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search154_0.value, &search146_0.value },
   NULL,
};

   /* replace164_0_0 -> replace80_0 in the cache */

/* replace164_0_1 -> search148_0_1_0 in the cache */
/* replace164_0 -> replace152 in the cache */
/* replace164 -> replace162 in the cache */

   /* search165_0_0_0 -> replace80_0 in the cache */
/* search165_0_0 -> search146_1 in the cache */

/* search165_0_1_0_0 -> search148_0_1_0 in the cache */
/* search165_0_1_0 -> search148_0_1 in the cache */
/* search165_0_1 -> search151_1 in the cache */
/* search165_0 -> search155_0 in the cache */

/* search165_1 -> search146_0 in the cache */
static const nir_search_expression search165 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search155_0.value, &search146_0.value },
   NULL,
};

   /* replace165_0 -> replace80_0 in the cache */

/* replace165_1 -> search148_0_1_0 in the cache */
static const nir_search_expression replace165 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace80_0.value, &search148_0_1_0.value },
   NULL,
};

   /* search166_0_0 -> replace80_0 in the cache */
/* search166_0 -> search146_1 in the cache */

/* search166_1_0 -> search148_0_1_0 in the cache */
/* search166_1 -> search148_0_1 in the cache */
static const nir_search_expression search166 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

   /* replace166_0 -> replace80_0 in the cache */

/* replace166_1 -> search148_0_1_0 in the cache */
/* replace166 -> replace165 in the cache */

   /* search167_0_0_0 -> replace80_0 in the cache */
/* search167_0_0 -> search146_1 in the cache */
/* search167_0 -> search147_0 in the cache */

/* search167_1_0_0 -> search148_0_1_0 in the cache */
/* search167_1_0 -> search148_0_1 in the cache */
/* search167_1 -> search151_1 in the cache */
static const nir_search_expression search167 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search147_0.value, &search151_1.value },
   NULL,
};

   /* replace167_0 -> replace80_0 in the cache */

/* replace167_1 -> search148_0_1_0 in the cache */
/* replace167 -> replace165 in the cache */

   /* search168_0_0_0_0 -> replace80_0 in the cache */
/* search168_0_0_0 -> search146_1 in the cache */

/* search168_0_0_1_0 -> search148_0_1_0 in the cache */
/* search168_0_0_1 -> search148_0_1 in the cache */
static const nir_search_expression search168_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};
static const nir_search_expression search168_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search168_0_0.value },
   NULL,
};

/* search168_1 -> search146_0 in the cache */
static const nir_search_expression search168 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search168_0.value, &search146_0.value },
   NULL,
};

   /* replace168_0 -> replace80_0 in the cache */

/* replace168_1 -> search148_0_1_0 in the cache */
/* replace168 -> replace148 in the cache */

   /* search169_0 -> search146_0 in the cache */

/* search169_1_0_0 -> replace80_0 in the cache */
/* search169_1_0 -> search146_1 in the cache */

/* search169_1_1_0 -> search148_0_1_0 in the cache */
/* search169_1_1 -> search148_0_1 in the cache */
/* search169_1 -> search168_0_0 in the cache */
static const nir_search_expression search169 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search146_0.value, &search168_0_0.value },
   NULL,
};

   /* replace169_0 -> replace80_0 in the cache */

/* replace169_1 -> search148_0_1_0 in the cache */
/* replace169 -> replace148 in the cache */

   /* search170_0_0_0_0 -> replace80_0 in the cache */
/* search170_0_0_0 -> search146_1 in the cache */

/* search170_0_0_1_0 -> search148_0_1_0 in the cache */
/* search170_0_0_1 -> search148_0_1 in the cache */
/* search170_0_0 -> search168_0_0 in the cache */
/* search170_0 -> search168_0 in the cache */

/* search170_1 -> search146_0 in the cache */
static const nir_search_expression search170 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search168_0.value, &search146_0.value },
   NULL,
};

   /* replace170_0_0 -> replace80_0 in the cache */

/* replace170_0_1 -> search148_0_1_0 in the cache */
/* replace170_0 -> replace148 in the cache */
/* replace170 -> replace158 in the cache */

   /* search171_0 -> search146_0 in the cache */

/* search171_1_0_0 -> replace80_0 in the cache */
/* search171_1_0 -> search146_1 in the cache */

/* search171_1_1_0 -> search148_0_1_0 in the cache */
/* search171_1_1 -> search148_0_1 in the cache */
/* search171_1 -> search168_0_0 in the cache */
static const nir_search_expression search171 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search146_0.value, &search168_0_0.value },
   NULL,
};

   /* replace171_0_0 -> replace80_0 in the cache */

/* replace171_0_1 -> search148_0_1_0 in the cache */
/* replace171_0 -> replace148 in the cache */
/* replace171 -> replace158 in the cache */

   /* search172_0 -> search2_0 in the cache */

/* search172_1_0 -> search2_0 in the cache */
/* search172_1 -> search15_0 in the cache */
static const nir_search_expression search172 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace172_0 -> search2_0 in the cache */

/* replace172_1 -> search24_1 in the cache */
/* replace172 -> replace65_0 in the cache */

   /* search173_0 -> search2_0 in the cache */

/* search173_1_0 -> search2_0 in the cache */
/* search173_1 -> search15_0 in the cache */
static const nir_search_expression search173 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace173_0 -> search2_0 in the cache */

/* replace173_1 -> search24_1 in the cache */
static const nir_search_expression replace173 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   static const nir_search_variable search174_0_0 = {
   { nir_search_value_variable, -1 },
   0, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search174_0_1_0_0_0 = {
   { nir_search_value_variable, 1 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search174_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search174_0_1_0_0_0.value },
   NULL,
};

static const nir_search_variable search174_0_1_0_1_0 = {
   { nir_search_value_variable, 1 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search174_0_1_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search174_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression search174_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search174_0_1_0_0.value, &search174_0_1_0_1.value },
   NULL,
};
static const nir_search_expression search174_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search174_0_1_0.value },
   NULL,
};
static const nir_search_expression search174_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fmin,
   { &search174_0_0.value, &search174_0_1.value },
   NULL,
};

/* search174_1 -> search24_1 in the cache */
static const nir_search_expression search174 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search174_0.value, &search24_1.value },
   NULL,
};

   /* replace174_0_0 -> search174_0_0 in the cache */

/* replace174_0_1 -> search24_1 in the cache */
static const nir_search_expression replace174_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search174_0_0.value, &search24_1.value },
   NULL,
};

/* replace174_1_0 -> search174_0_1_0_0_0 in the cache */

/* replace174_1_1 -> search174_0_1_0_1_0 in the cache */
static const nir_search_expression replace174_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search174_0_1_0_0_0.value, &search174_0_1_0_1_0.value },
   NULL,
};
static const nir_search_expression replace174 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace174_0.value, &replace174_1.value },
   NULL,
};

   /* search175_0_0 -> search14_0 in the cache */

/* search175_0_1 -> replace14_1_0 in the cache */
/* search175_0 -> replace49 in the cache */

/* search175_1 -> search14_0 in the cache */
static const nir_search_expression search175 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &replace49.value, &search14_0.value },
   NULL,
};

   /* replace175_0 -> replace14_1_0 in the cache */

/* replace175_1 -> search47_0 in the cache */
static const nir_search_expression replace175 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search176_0_0 -> search14_0 in the cache */

/* search176_0_1 -> replace14_1_0 in the cache */
/* search176_0 -> replace49 in the cache */

/* search176_1 -> search14_0 in the cache */
static const nir_search_expression search176 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &replace49.value, &search14_0.value },
   NULL,
};

   /* replace176_0 -> replace14_1_0 in the cache */

/* replace176_1 -> search47_0 in the cache */
static const nir_search_expression replace176 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search177_0_0 -> search14_0 in the cache */

/* search177_0_1 -> replace14_1_0 in the cache */
/* search177_0 -> search34_1 in the cache */

/* search177_1 -> search14_0 in the cache */
static const nir_search_expression search177 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search34_1.value, &search14_0.value },
   NULL,
};

   /* replace177_0 -> replace14_1_0 in the cache */

/* replace177_1 -> search47_0 in the cache */
static const nir_search_expression replace177 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search178_0_0 -> search14_0 in the cache */

/* search178_0_1 -> replace14_1_0 in the cache */
/* search178_0 -> search34_1 in the cache */

/* search178_1 -> search14_0 in the cache */
static const nir_search_expression search178 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fne,
   { &search34_1.value, &search14_0.value },
   NULL,
};

   /* replace178_0 -> replace14_1_0 in the cache */

/* replace178_1 -> search47_0 in the cache */
static const nir_search_expression replace178 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};

   /* search179_0_0 -> search28_0_0 in the cache */

/* search179_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search179_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search96_0_0_1.value },
   (is_used_once),
};

/* search179_1 -> search96_0_1 in the cache */
static const nir_search_expression search179 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search179_0.value, &search96_0_1.value },
   NULL,
};

   /* replace179_0 -> search28_0_0 in the cache */

/* replace179_1_0 -> search28_1_1 in the cache */

/* replace179_1_1_0 -> search28_0_1 in the cache */
static const nir_search_expression replace179_1_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search28_0_1.value },
   NULL,
};
static const nir_search_expression replace179_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_1_1.value, &replace179_1_1.value },
   NULL,
};
static const nir_search_expression replace179 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search28_0_0.value, &replace179_1.value },
   NULL,
};

   /* search180_0_0_0 -> search28_0_0 in the cache */

/* search180_0_0_1 -> search96_0_0_1 in the cache */
/* search180_0_0 -> search179_0 in the cache */
static const nir_search_expression search180_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search179_0.value },
   (is_used_once),
};

/* search180_1 -> search96_0_1 in the cache */
static const nir_search_expression search180 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_flt,
   { &search180_0.value, &search96_0_1.value },
   NULL,
};

   /* replace180_0_0_0 -> search28_1_1 in the cache */

/* replace180_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace180_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search28_1_1.value, &search28_0_1.value },
   NULL,
};
static const nir_search_expression replace180_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace180_0_0.value },
   NULL,
};

/* replace180_1 -> search28_0_0 in the cache */
static const nir_search_expression replace180 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &replace180_0.value, &search28_0_0.value },
   NULL,
};

   /* search181_0_0 -> search28_0_0 in the cache */

/* search181_0_1 -> search96_0_0_1 in the cache */
/* search181_0 -> search179_0 in the cache */

/* search181_1 -> search96_0_1 in the cache */
static const nir_search_expression search181 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search179_0.value, &search96_0_1.value },
   NULL,
};

   /* replace181_0 -> search28_0_0 in the cache */

/* replace181_1_0 -> search28_1_1 in the cache */

/* replace181_1_1_0 -> search28_0_1 in the cache */
/* replace181_1_1 -> replace179_1_1 in the cache */
/* replace181_1 -> replace179_1 in the cache */
static const nir_search_expression replace181 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &search28_0_0.value, &replace179_1.value },
   NULL,
};

   /* search182_0_0_0 -> search28_0_0 in the cache */

/* search182_0_0_1 -> search96_0_0_1 in the cache */
/* search182_0_0 -> search179_0 in the cache */
/* search182_0 -> search180_0 in the cache */

/* search182_1 -> search96_0_1 in the cache */
static const nir_search_expression search182 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 1,
   nir_op_fge,
   { &search180_0.value, &search96_0_1.value },
   NULL,
};

   /* replace182_0_0_0 -> search28_1_1 in the cache */

/* replace182_0_0_1 -> search28_0_1 in the cache */
/* replace182_0_0 -> replace180_0_0 in the cache */
/* replace182_0 -> replace180_0 in the cache */

/* replace182_1 -> search28_0_0 in the cache */
static const nir_search_expression replace182 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_fge,
   { &replace180_0.value, &search28_0_0.value },
   NULL,
};

   /* search183_0_0 -> search28_0_0 in the cache */

/* search183_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search183_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search96_0_0_1.value },
   (is_used_once),
};

/* search183_1 -> search96_0_1 in the cache */
static const nir_search_expression search183 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search183_0.value, &search96_0_1.value },
   NULL,
};

   /* replace183_0 -> search28_0_0 in the cache */

/* replace183_1_0 -> search28_1_1 in the cache */

/* replace183_1_1_0 -> search28_0_1 in the cache */
/* replace183_1_1 -> replace179_1_1 in the cache */
static const nir_search_expression replace183_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_1_1.value, &replace179_1_1.value },
   NULL,
};
static const nir_search_expression replace183 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &search28_0_0.value, &replace183_1.value },
   NULL,
};

   /* search184_0_0_0 -> search28_0_0 in the cache */

/* search184_0_0_1 -> search96_0_0_1 in the cache */
/* search184_0_0 -> search183_0 in the cache */
static const nir_search_expression search184_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search183_0.value },
   (is_used_once),
};

/* search184_1 -> search96_0_1 in the cache */
static const nir_search_expression search184 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_feq,
   { &search184_0.value, &search96_0_1.value },
   NULL,
};

   /* replace184_0_0_0 -> search28_1_1 in the cache */

/* replace184_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace184_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_1_1.value, &search28_0_1.value },
   NULL,
};
static const nir_search_expression replace184_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace184_0_0.value },
   NULL,
};

/* replace184_1 -> search28_0_0 in the cache */
static const nir_search_expression replace184 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_feq,
   { &replace184_0.value, &search28_0_0.value },
   NULL,
};

   /* search185_0_0 -> search28_0_0 in the cache */

/* search185_0_1 -> search96_0_0_1 in the cache */
/* search185_0 -> search183_0 in the cache */

/* search185_1 -> search96_0_1 in the cache */
static const nir_search_expression search185 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fne,
   { &search183_0.value, &search96_0_1.value },
   NULL,
};

   /* replace185_0 -> search28_0_0 in the cache */

/* replace185_1_0 -> search28_1_1 in the cache */

/* replace185_1_1_0 -> search28_0_1 in the cache */
/* replace185_1_1 -> replace179_1_1 in the cache */
/* replace185_1 -> replace183_1 in the cache */
static const nir_search_expression replace185 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &search28_0_0.value, &replace183_1.value },
   NULL,
};

   /* search186_0_0_0 -> search28_0_0 in the cache */

/* search186_0_0_1 -> search96_0_0_1 in the cache */
/* search186_0_0 -> search183_0 in the cache */
/* search186_0 -> search184_0 in the cache */

/* search186_1 -> search96_0_1 in the cache */
static const nir_search_expression search186 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 2,
   nir_op_fne,
   { &search184_0.value, &search96_0_1.value },
   NULL,
};

   /* replace186_0_0_0 -> search28_1_1 in the cache */

/* replace186_0_0_1 -> search28_0_1 in the cache */
/* replace186_0_0 -> replace184_0_0 in the cache */
/* replace186_0 -> replace184_0 in the cache */

/* replace186_1 -> search28_0_0 in the cache */
static const nir_search_expression replace186 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_fne,
   { &replace184_0.value, &search28_0_0.value },
   NULL,
};

   /* search187_0_0 -> search14_0 in the cache */

/* search187_0_1 -> replace14_1_0 in the cache */
/* search187_0 -> search32_1 in the cache */

/* search187_1 -> search14_0 in the cache */
static const nir_search_expression search187 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &search32_1.value, &search14_0.value },
   NULL,
};

   /* replace187_0 -> replace14_1_0 in the cache */

static const nir_search_constant replace187_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression replace187 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace14_1_0.value, &replace187_1.value },
   NULL,
};

   /* search188_0_0 -> search14_0 in the cache */

/* search188_0_1 -> replace14_1_0 in the cache */
/* search188_0 -> search32_1 in the cache */

/* search188_1 -> search14_0 in the cache */
static const nir_search_expression search188 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ine,
   { &search32_1.value, &search14_0.value },
   NULL,
};

   /* replace188_0 -> replace14_1_0 in the cache */

/* replace188_1 -> replace187_1 in the cache */
static const nir_search_expression replace188 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace14_1_0.value, &replace187_1.value },
   NULL,
};

   /* search189_0_0_0_0 -> replace80_0 in the cache */
static const nir_search_expression search189_0_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};
static const nir_search_expression search189_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search189_0_0_0.value },
   NULL,
};

/* search189_0_1 -> search148_0_1_0 in the cache */
static const nir_search_expression search189_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search189_0_0.value, &search148_0_1_0.value },
   NULL,
};

static const nir_search_constant search189_1 = {
   { nir_search_value_constant, 1 },
   nir_type_float, { 0x0 /* 0.0 */ },
};
static const nir_search_expression search189 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search189_0.value, &search189_1.value },
   NULL,
};

   /* replace189_0_0 -> replace80_0 in the cache */
/* replace189_0 -> replace146 in the cache */

/* replace189_1_0 -> search148_0_1_0 in the cache */

/* replace189_1_1 -> search189_1 in the cache */
static const nir_search_expression replace189_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search148_0_1_0.value, &search189_1.value },
   NULL,
};
static const nir_search_expression replace189 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace146.value, &replace189_1.value },
   NULL,
};

   /* search190_0_0_0_0 -> replace80_0 in the cache */
/* search190_0_0_0 -> search189_0_0_0 in the cache */
/* search190_0_0 -> search189_0_0 in the cache */

/* search190_0_1 -> search148_0_1_0 in the cache */
/* search190_0 -> search189_0 in the cache */

/* search190_1 -> search189_1 in the cache */
static const nir_search_expression search190 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search189_0.value, &search189_1.value },
   NULL,
};

   /* replace190_0_0 -> replace80_0 in the cache */
/* replace190_0 -> replace146 in the cache */

/* replace190_1_0 -> search148_0_1_0 in the cache */

/* replace190_1_1 -> search189_1 in the cache */
/* replace190_1 -> replace189_1 in the cache */
/* replace190 -> replace189 in the cache */

   /* search191_0_0 -> replace80_0 in the cache */
/* search191_0 -> search146_1 in the cache */

/* search191_1 -> search146_0 in the cache */
static const nir_search_expression search191 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search146_1.value, &search146_0.value },
   NULL,
};

   /* replace191_0 -> replace80_0 in the cache */
/* replace191 -> replace146 in the cache */

   /* search192_0_0 -> replace80_0 in the cache */
/* search192_0 -> search146_1 in the cache */

/* search192_1 -> search146_0 in the cache */
static const nir_search_expression search192 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search146_1.value, &search146_0.value },
   NULL,
};

   /* replace192 -> replace80_0 in the cache */

   /* search193_0_0 -> replace80_0 in the cache */
static const nir_search_expression search193_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace80_0.value },
   NULL,
};

static const nir_search_constant search193_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { 0x0 /* 0 */ },
};
static const nir_search_expression search193 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search193_0.value, &search193_1.value },
   NULL,
};

   /* replace193_0 -> replace80_0 in the cache */
/* replace193 -> replace146 in the cache */

   /* search194_0_0 -> replace80_0 in the cache */
/* search194_0 -> search193_0 in the cache */

/* search194_1 -> search193_1 in the cache */
static const nir_search_expression search194 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search193_0.value, &search193_1.value },
   NULL,
};

   /* replace194 -> replace80_0 in the cache */

   /* search195_0_0 -> search2_0 in the cache */
/* search195_0 -> search19_0 in the cache */

/* search195_1 -> search146_0 in the cache */
static const nir_search_expression search195 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search19_0.value, &search146_0.value },
   NULL,
};

   /* replace195_0 -> search2_0 in the cache */

/* replace195_1 -> replace9 in the cache */
static const nir_search_expression replace195 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search196_0_0 -> search2_0 in the cache */
/* search196_0 -> search19_0 in the cache */

/* search196_1 -> search146_0 in the cache */
static const nir_search_expression search196 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search19_0.value, &search146_0.value },
   NULL,
};

   /* replace196_0 -> search2_0 in the cache */

/* replace196_1 -> replace9 in the cache */
static const nir_search_expression replace196 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search197_0_0 -> search2_0 in the cache */
/* search197_0 -> search19_0 in the cache */

/* search197_1 -> search146_0 in the cache */
static const nir_search_expression search197 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search19_0.value, &search146_0.value },
   NULL,
};

   static const nir_search_constant replace197 = {
   { nir_search_value_constant, 1 },
   nir_type_bool, { NIR_TRUE /* True */ },
};

   /* search198_0 -> search146_0 in the cache */

/* search198_1_0 -> search2_0 in the cache */
/* search198_1 -> search19_0 in the cache */
static const nir_search_expression search198 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search146_0.value, &search19_0.value },
   NULL,
};

   /* replace198_0 -> replace9 in the cache */

/* replace198_1 -> search2_0 in the cache */
static const nir_search_expression replace198 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search199_0_0 -> search2_0 in the cache */
/* search199_0 -> search19_0 in the cache */

/* search199_1 -> search146_0 in the cache */
static const nir_search_expression search199 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search19_0.value, &search146_0.value },
   NULL,
};

   /* replace199 -> replace121 in the cache */

   /* search200_0 -> search146_0 in the cache */

/* search200_1_0 -> search2_0 in the cache */
/* search200_1 -> search19_0 in the cache */
static const nir_search_expression search200 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search146_0.value, &search19_0.value },
   NULL,
};

   /* replace200_0 -> replace9 in the cache */

/* replace200_1 -> search2_0 in the cache */
static const nir_search_expression replace200 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search201_0_0 -> search2_0 in the cache */
static const nir_search_expression search201_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search2_0.value },
   NULL,
};

/* search201_1 -> search146_0 in the cache */
static const nir_search_expression search201 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search201_0.value, &search146_0.value },
   NULL,
};

   /* replace201_0 -> search2_0 in the cache */

/* replace201_1 -> replace9 in the cache */
/* replace201 -> replace195 in the cache */

   /* search202_0_0 -> search2_0 in the cache */
/* search202_0 -> search201_0 in the cache */

/* search202_1 -> search146_0 in the cache */
static const nir_search_expression search202 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search201_0.value, &search146_0.value },
   NULL,
};

   /* replace202_0 -> search2_0 in the cache */

/* replace202_1 -> replace9 in the cache */
/* replace202 -> replace196 in the cache */

   /* search203_0_0 -> search2_0 in the cache */
/* search203_0 -> search201_0 in the cache */

/* search203_1 -> search146_0 in the cache */
static const nir_search_expression search203 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search201_0.value, &search146_0.value },
   NULL,
};

   /* replace203_0 -> search2_0 in the cache */

/* replace203_1 -> replace9 in the cache */
static const nir_search_expression replace203 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search204_0 -> search146_0 in the cache */

/* search204_1_0 -> search2_0 in the cache */
/* search204_1 -> search201_0 in the cache */
static const nir_search_expression search204 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search146_0.value, &search201_0.value },
   NULL,
};

   /* replace204_0 -> replace9 in the cache */

/* replace204_1 -> search2_0 in the cache */
static const nir_search_expression replace204 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search205_0_0 -> search2_0 in the cache */
/* search205_0 -> search201_0 in the cache */

/* search205_1 -> search146_0 in the cache */
static const nir_search_expression search205 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search201_0.value, &search146_0.value },
   NULL,
};

   /* replace205_0 -> search2_0 in the cache */

/* replace205_1 -> replace9 in the cache */
static const nir_search_expression replace205 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search206_0 -> search146_0 in the cache */

/* search206_1_0 -> search2_0 in the cache */
/* search206_1 -> search201_0 in the cache */
static const nir_search_expression search206 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search146_0.value, &search201_0.value },
   NULL,
};

   /* replace206_0 -> replace9 in the cache */

/* replace206_1 -> search2_0 in the cache */
static const nir_search_expression replace206 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search207_0 -> search24_1 in the cache */

/* search207_1_0 -> search2_0 in the cache */
/* search207_1 -> search17_0 in the cache */
static const nir_search_expression search207 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search24_1.value, &search17_0.value },
   NULL,
};

   /* replace207_0 -> search2_0 in the cache */

/* replace207_1 -> search24_1 in the cache */
static const nir_search_expression replace207 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* search208_0_0_0 -> search2_0 in the cache */
/* search208_0_0 -> search17_0 in the cache */
static const nir_search_expression search208_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search17_0.value },
   NULL,
};

/* search208_1 -> search24_1 in the cache */
static const nir_search_expression search208 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search208_0.value, &search24_1.value },
   NULL,
};

   /* replace208_0 -> search2_0 in the cache */

/* replace208_1 -> search24_1 in the cache */
/* replace208 -> replace207 in the cache */

   /* search209_0 -> search24_1 in the cache */

/* search209_1_0 -> search2_0 in the cache */
/* search209_1 -> search17_0 in the cache */
static const nir_search_expression search209 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search24_1.value, &search17_0.value },
   NULL,
};

   /* replace209_0 -> search2_0 in the cache */

/* replace209_1 -> search24_1 in the cache */
static const nir_search_expression replace209 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search24_1.value },
   NULL,
};

   /* search210_0_0_0 -> search2_0 in the cache */
/* search210_0_0 -> search17_0 in the cache */
/* search210_0 -> search208_0 in the cache */

/* search210_1 -> search24_1 in the cache */
static const nir_search_expression search210 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search208_0.value, &search24_1.value },
   NULL,
};

   /* replace210_0 -> search2_0 in the cache */

/* replace210_1 -> search24_1 in the cache */
/* replace210 -> replace209 in the cache */

   /* search211_0_0 -> search2_0 in the cache */

/* search211_0_1 -> search24_1 in the cache */
/* search211_0 -> replace173 in the cache */

/* search211_1_0 -> search41_1 in the cache */

/* search211_1_1 -> search2_0 in the cache */
/* search211_1 -> replace132 in the cache */
static const nir_search_expression search211 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace173.value, &replace132.value },
   NULL,
};

   /* replace211_0 -> search2_0 in the cache */

/* replace211_1_0 -> search2_0 in the cache */
/* replace211_1 -> search36_0 in the cache */
static const nir_search_expression replace211 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search2_0.value, &search36_0.value },
   NULL,
};

   /* search212_0_0 -> search2_0 in the cache */

/* search212_0_1 -> search24_1 in the cache */
/* search212_0 -> replace65_0 in the cache */

/* search212_1_0 -> search41_1 in the cache */

/* search212_1_1 -> search2_0 in the cache */
/* search212_1 -> replace130 in the cache */
static const nir_search_expression search212 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace65_0.value, &replace130.value },
   NULL,
};

   /* replace212_0 -> search2_0 in the cache */

/* replace212_1_0 -> search2_0 in the cache */
/* replace212_1 -> search36_0 in the cache */
static const nir_search_expression replace212 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search2_0.value, &search36_0.value },
   NULL,
};

   /* search213_0_0 -> replace80_0 in the cache */
static const nir_search_expression search213_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   (is_used_once),
};

/* search213_1_0 -> search148_0_1_0 in the cache */
/* search213_1 -> search148_0_1 in the cache */
static const nir_search_expression search213 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search213_0.value, &search148_0_1.value },
   NULL,
};

   /* replace213_0_0 -> replace80_0 in the cache */

/* replace213_0_1 -> search148_0_1_0 in the cache */
/* replace213_0 -> replace148 in the cache */
static const nir_search_expression replace213 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace148.value },
   NULL,
};

   /* search214_0_0_0 -> replace80_0 in the cache */
/* search214_0_0 -> search213_0 in the cache */
static const nir_search_expression search214_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search213_0.value },
   (is_used_once),
};

/* search214_1_0_0 -> search148_0_1_0 in the cache */
/* search214_1_0 -> search148_0_1 in the cache */
/* search214_1 -> search151_1 in the cache */
static const nir_search_expression search214 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search214_0.value, &search151_1.value },
   NULL,
};

   /* replace214_0_0_0 -> replace80_0 in the cache */

/* replace214_0_0_1 -> search148_0_1_0 in the cache */
/* replace214_0_0 -> replace148 in the cache */
/* replace214_0 -> replace213 in the cache */
static const nir_search_expression replace214 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace213.value },
   NULL,
};

   /* search215_0_0 -> replace80_0 in the cache */
/* search215_0 -> search213_0 in the cache */

/* search215_1_0 -> search148_0_1_0 in the cache */
/* search215_1 -> search148_0_1 in the cache */
static const nir_search_expression search215 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search213_0.value, &search148_0_1.value },
   NULL,
};

   /* replace215_0_0 -> replace80_0 in the cache */

/* replace215_0_1 -> search148_0_1_0 in the cache */
/* replace215_0 -> replace152 in the cache */
static const nir_search_expression replace215 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace152.value },
   NULL,
};

   /* search216_0_0_0 -> replace80_0 in the cache */
/* search216_0_0 -> search213_0 in the cache */
/* search216_0 -> search214_0 in the cache */

/* search216_1_0_0 -> search148_0_1_0 in the cache */
/* search216_1_0 -> search148_0_1 in the cache */
/* search216_1 -> search151_1 in the cache */
static const nir_search_expression search216 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search214_0.value, &search151_1.value },
   NULL,
};

   /* replace216_0_0_0 -> replace80_0 in the cache */

/* replace216_0_0_1 -> search148_0_1_0 in the cache */
/* replace216_0_0 -> replace152 in the cache */
/* replace216_0 -> replace215 in the cache */
static const nir_search_expression replace216 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace215.value },
   NULL,
};

   /* search217_0_0 -> replace80_0 in the cache */
static const nir_search_expression search217_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};

/* search217_1 -> search97_0_1 in the cache */
static const nir_search_expression search217 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search217_0.value, &search97_0_1.value },
   NULL,
};

   /* replace217_0 -> replace80_0 in the cache */

/* replace217_1_0 -> replace14_1_0 in the cache */

/* replace217_1_1 -> search49_0 in the cache */
static const nir_search_expression replace217_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace14_1_0.value, &search49_0.value },
   NULL,
};

/* replace217_2_0 -> replace14_1_0 in the cache */

/* replace217_2_1 -> search47_0 in the cache */
static const nir_search_expression replace217_2 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace14_1_0.value, &search47_0.value },
   NULL,
};
static const nir_search_expression replace217 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace217_1.value, &replace217_2.value },
   NULL,
};

   /* search218_0_0 -> search14_0 in the cache */

/* search218_0_1_0 -> replace14_1_0 in the cache */
/* search218_0_1 -> search126_1 in the cache */
static const nir_search_expression search218_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &search126_1.value },
   (is_used_once),
};

/* search218_1 -> search47_0 in the cache */
static const nir_search_expression search218 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search218_0.value, &search47_0.value },
   NULL,
};

   /* replace218_0 -> search14_0 in the cache */

/* replace218_1 -> replace14_1_0 in the cache */
/* replace218 -> search111_0 in the cache */

   /* search219_0_0_0 -> search2_0 in the cache */
/* search219_0_0 -> search17_0 in the cache */
/* search219_0 -> search208_0 in the cache */

/* search219_1 -> search24_1 in the cache */
/* search219 -> search210 in the cache */

   /* replace219_0 -> search2_0 in the cache */

/* replace219_1 -> search24_1 in the cache */
/* replace219 -> replace209 in the cache */

   /* search220_0_0 -> replace137_0 in the cache */

/* search220_0_1 -> search137_1_0 in the cache */
/* search220_0 -> replace137 in the cache */

/* search220_1 -> replace137_0 in the cache */

/* search220_2 -> search137_1_0 in the cache */
static const nir_search_expression search220 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace137.value, &replace137_0.value, &search137_1_0.value },
   NULL,
};

   /* replace220_0 -> search137_1_0 in the cache */

/* replace220_1 -> replace137_0 in the cache */
static const nir_search_expression replace220 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search137_1_0.value, &replace137_0.value },
   NULL,
};

   /* search221_0_0 -> search14_0 in the cache */

/* search221_0_1 -> replace14_1_0 in the cache */
/* search221_0 -> search111_0 in the cache */

/* search221_1 -> replace14_1_0 in the cache */

/* search221_2 -> search14_0 in the cache */
static const nir_search_expression search221 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &search111_0.value, &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* replace221_0 -> search14_0 in the cache */

/* replace221_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace221 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search222_0_0 -> search14_0 in the cache */

/* search222_0_1 -> replace14_1_0 in the cache */
/* search222_0 -> replace111 in the cache */

/* search222_1 -> replace14_1_0 in the cache */

/* search222_2 -> search14_0 in the cache */
static const nir_search_expression search222 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace111.value, &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* replace222_0 -> search14_0 in the cache */

/* replace222_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace222 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search223_0_0 -> replace137_0 in the cache */

/* search223_0_1 -> search137_1_0 in the cache */
/* search223_0 -> replace139 in the cache */

/* search223_1 -> replace137_0 in the cache */

/* search223_2 -> search137_1_0 in the cache */
static const nir_search_expression search223 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_bcsel,
   { &replace139.value, &replace137_0.value, &search137_1_0.value },
   NULL,
};

   /* replace223_0 -> search137_1_0 in the cache */

/* replace223_1 -> replace137_0 in the cache */
static const nir_search_expression replace223 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search137_1_0.value, &replace137_0.value },
   NULL,
};

   /* search224_0_0 -> search2_0 in the cache */
static const nir_search_expression search224_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search2_0.value },
   NULL,
};

/* search224_1 -> search28_0_1 in the cache */

/* search224_2 -> search28_1_1 in the cache */
static const nir_search_expression search224 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search224_0.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* replace224_0_0 -> search2_0 in the cache */

/* replace224_0_1 -> replace9 in the cache */
/* replace224_0 -> replace195 in the cache */

/* replace224_1 -> search28_0_1 in the cache */

/* replace224_2 -> search28_1_1 in the cache */
static const nir_search_expression replace224 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace195.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* search225_0_0 -> replace80_0 in the cache */
/* search225_0 -> replace146 in the cache */

/* search225_1 -> search28_0_1 in the cache */

/* search225_2 -> search28_1_1 in the cache */
static const nir_search_expression search225 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace146.value, &search28_0_1.value, &search28_1_1.value },
   NULL,
};

   /* replace225_0 -> replace80_0 in the cache */

/* replace225_1 -> search28_1_1 in the cache */

/* replace225_2 -> search28_0_1 in the cache */
static const nir_search_expression replace225 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search28_1_1.value, &search28_0_1.value },
   NULL,
};

   /* search226_0 -> replace80_0 in the cache */

/* search226_1_0 -> replace80_0 in the cache */

/* search226_1_1 -> search62_0_1 in the cache */

/* search226_1_2 -> search62_1_1 in the cache */
static const nir_search_expression search226_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_0_1.value, &search62_1_1.value },
   NULL,
};

/* search226_2 -> search62_2 in the cache */
static const nir_search_expression search226 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search226_1.value, &search62_2.value },
   NULL,
};

   /* replace226_0 -> replace80_0 in the cache */

/* replace226_1 -> search62_0_1 in the cache */

/* replace226_2 -> search62_2 in the cache */
static const nir_search_expression replace226 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_0_1.value, &search62_2.value },
   NULL,
};

   /* search227_0 -> replace80_0 in the cache */

/* search227_1 -> search62_0_1 in the cache */

/* search227_2_0 -> replace80_0 in the cache */

/* search227_2_1 -> search62_1_1 in the cache */

/* search227_2_2 -> search62_2 in the cache */
static const nir_search_expression search227_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search227 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_0_1.value, &search227_2.value },
   NULL,
};

   /* replace227_0 -> replace80_0 in the cache */

/* replace227_1 -> search62_0_1 in the cache */

/* replace227_2 -> search62_2 in the cache */
/* replace227 -> replace226 in the cache */

   /* search228_0 -> replace80_0 in the cache */

/* search228_1_0 -> search148_0_1_0 in the cache */

static const nir_search_variable search228_1_1 = {
   { nir_search_value_variable, -5 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search228_1_2 = {
   { nir_search_value_variable, -5 },
   3, /* d */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search228_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search228_1_1.value, &search228_1_2.value },
   NULL,
};

/* search228_2_0 -> search148_0_1_0 in the cache */

/* search228_2_1 -> search228_1_1 in the cache */

static const nir_search_variable search228_2_2 = {
   { nir_search_value_variable, -5 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search228_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search228_1_1.value, &search228_2_2.value },
   (is_used_once),
};
static const nir_search_expression search228 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search228_1.value, &search228_2.value },
   NULL,
};

   /* replace228_0 -> search148_0_1_0 in the cache */

/* replace228_1 -> search228_1_1 in the cache */

/* replace228_2_0 -> replace80_0 in the cache */

/* replace228_2_1 -> search228_1_2 in the cache */

/* replace228_2_2 -> search228_2_2 in the cache */
static const nir_search_expression replace228_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search228_1_2.value, &search228_2_2.value },
   NULL,
};
static const nir_search_expression replace228 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search228_1_1.value, &replace228_2.value },
   NULL,
};

   /* search229_0 -> replace80_0 in the cache */

/* search229_1_0 -> search148_0_1_0 in the cache */

/* search229_1_1 -> search228_1_1 in the cache */

/* search229_1_2 -> search228_1_2 in the cache */
static const nir_search_expression search229_1 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search228_1_1.value, &search228_1_2.value },
   (is_used_once),
};

/* search229_2_0 -> search148_0_1_0 in the cache */

/* search229_2_1 -> search228_1_1 in the cache */

/* search229_2_2 -> search228_2_2 in the cache */
static const nir_search_expression search229_2 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search228_1_1.value, &search228_2_2.value },
   NULL,
};
static const nir_search_expression search229 = {
   { nir_search_value_expression, -5 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search229_1.value, &search229_2.value },
   NULL,
};

   /* replace229_0 -> search148_0_1_0 in the cache */

/* replace229_1 -> search228_1_1 in the cache */

/* replace229_2_0 -> replace80_0 in the cache */

/* replace229_2_1 -> search228_1_2 in the cache */

/* replace229_2_2 -> search228_2_2 in the cache */
/* replace229_2 -> replace228_2 in the cache */
/* replace229 -> replace228 in the cache */

   /* search230_0 -> replace80_0 in the cache */

/* search230_1_0 -> search148_0_1_0 in the cache */

/* search230_1_1 -> search62_1_1 in the cache */

/* search230_1_2 -> search62_2 in the cache */
static const nir_search_expression search230_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search62_1_1.value, &search62_2.value },
   NULL,
};

/* search230_2_0 -> search148_0_1_0 in the cache */

static const nir_search_variable search230_2_1 = {
   { nir_search_value_variable, -4 },
   4, /* e */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search230_2_2 -> search62_2 in the cache */
static const nir_search_expression search230_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search230_2_1.value, &search62_2.value },
   (is_used_once),
};
static const nir_search_expression search230 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search230_1.value, &search230_2.value },
   NULL,
};

   /* replace230_0 -> search148_0_1_0 in the cache */

/* replace230_1_0 -> replace80_0 in the cache */

/* replace230_1_1 -> search62_1_1 in the cache */

/* replace230_1_2 -> search230_2_1 in the cache */
static const nir_search_expression replace230_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search62_1_1.value, &search230_2_1.value },
   NULL,
};

/* replace230_2 -> search62_2 in the cache */
static const nir_search_expression replace230 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &replace230_1.value, &search62_2.value },
   NULL,
};

   /* search231_0 -> replace80_0 in the cache */

/* search231_1_0 -> search148_0_1_0 in the cache */

/* search231_1_1 -> search62_1_1 in the cache */

/* search231_1_2 -> search62_2 in the cache */
static const nir_search_expression search231_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search62_1_1.value, &search62_2.value },
   (is_used_once),
};

/* search231_2_0 -> search148_0_1_0 in the cache */

/* search231_2_1 -> search230_2_1 in the cache */

/* search231_2_2 -> search62_2 in the cache */
static const nir_search_expression search231_2 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search148_0_1_0.value, &search230_2_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search231 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search231_1.value, &search231_2.value },
   NULL,
};

   /* replace231_0 -> search148_0_1_0 in the cache */

/* replace231_1_0 -> replace80_0 in the cache */

/* replace231_1_1 -> search62_1_1 in the cache */

/* replace231_1_2 -> search230_2_1 in the cache */
/* replace231_1 -> replace230_1 in the cache */

/* replace231_2 -> search62_2 in the cache */
/* replace231 -> replace230 in the cache */

   /* search232_0 -> replace80_0 in the cache */

/* search232_1 -> replace197 in the cache */

/* search232_2 -> search148_0_1_0 in the cache */
static const nir_search_expression search232 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace197.value, &search148_0_1_0.value },
   NULL,
};

   /* replace232_0 -> replace80_0 in the cache */

/* replace232_1 -> search148_0_1_0 in the cache */
/* replace232 -> replace148 in the cache */

   /* search233_0 -> replace80_0 in the cache */

/* search233_1 -> replace80_0 in the cache */

/* search233_2 -> search148_0_1_0 in the cache */
static const nir_search_expression search233 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace80_0.value, &search148_0_1_0.value },
   NULL,
};

   /* replace233_0 -> replace80_0 in the cache */

/* replace233_1 -> search148_0_1_0 in the cache */
/* replace233 -> replace148 in the cache */

   /* search234_0 -> replace80_0 in the cache */

/* search234_1 -> search148_0_1_0 in the cache */

/* search234_2 -> replace121 in the cache */
static const nir_search_expression search234 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search148_0_1_0.value, &replace121.value },
   NULL,
};

   /* replace234_0 -> replace80_0 in the cache */

/* replace234_1 -> search148_0_1_0 in the cache */
/* replace234 -> replace152 in the cache */

   /* search235_0 -> replace80_0 in the cache */

/* search235_1 -> search148_0_1_0 in the cache */

/* search235_2 -> replace80_0 in the cache */
static const nir_search_expression search235 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search148_0_1_0.value, &replace80_0.value },
   NULL,
};

   /* replace235_0 -> replace80_0 in the cache */

/* replace235_1 -> search148_0_1_0 in the cache */
/* replace235 -> replace152 in the cache */

   /* search236_0 -> search2_0 in the cache */

/* search236_1 -> search2_0 in the cache */
static const nir_search_expression search236 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace236 -> search2_0 in the cache */

   /* search237_0 -> search2_0 in the cache */

/* search237_1 -> search2_0 in the cache */
static const nir_search_expression search237 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace237 -> search2_0 in the cache */

   /* search238_0 -> search2_0 in the cache */

/* search238_1 -> search2_0 in the cache */
static const nir_search_expression search238 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace238 -> search2_0 in the cache */

   /* search239_0 -> search2_0 in the cache */

/* search239_1 -> search2_0 in the cache */
static const nir_search_expression search239 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_imax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace239 -> search2_0 in the cache */

   /* search240_0 -> search2_0 in the cache */

/* search240_1 -> search2_0 in the cache */
static const nir_search_expression search240 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umin,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace240 -> search2_0 in the cache */

   /* search241_0 -> search2_0 in the cache */

/* search241_1 -> search2_0 in the cache */
static const nir_search_expression search241 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_umax,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace241 -> search2_0 in the cache */

   /* search242_0_0 -> search14_0 in the cache */

/* search242_0_1 -> replace14_1_0 in the cache */
/* search242_0 -> replace221 in the cache */

/* search242_1 -> replace14_1_0 in the cache */
static const nir_search_expression search242 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &replace221.value, &replace14_1_0.value },
   NULL,
};

   /* replace242_0 -> search14_0 in the cache */

/* replace242_1 -> replace14_1_0 in the cache */
/* replace242 -> replace221 in the cache */

   /* search243_0_0 -> search14_0 in the cache */

/* search243_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search243_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search243_1 -> replace14_1_0 in the cache */
static const nir_search_expression search243 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umax,
   { &search243_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace243_0 -> search14_0 in the cache */

/* replace243_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace243 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search244_0_0 -> search14_0 in the cache */

/* search244_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search244_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search244_1 -> replace14_1_0 in the cache */
static const nir_search_expression search244 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imax,
   { &search244_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace244_0 -> search14_0 in the cache */

/* replace244_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace244 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search245_0_0 -> search14_0 in the cache */

/* search245_0_1 -> replace14_1_0 in the cache */
/* search245_0 -> replace222 in the cache */

/* search245_1 -> replace14_1_0 in the cache */
static const nir_search_expression search245 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace222.value, &replace14_1_0.value },
   NULL,
};

   /* replace245_0 -> search14_0 in the cache */

/* replace245_1 -> replace14_1_0 in the cache */
/* replace245 -> replace222 in the cache */

   /* search246_0_0 -> search14_0 in the cache */

/* search246_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search246_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_umin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search246_1 -> replace14_1_0 in the cache */
static const nir_search_expression search246 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_umin,
   { &search246_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace246_0 -> search14_0 in the cache */

/* replace246_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace246 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search247_0_0 -> search14_0 in the cache */

/* search247_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search247_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_imin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search247_1 -> replace14_1_0 in the cache */
static const nir_search_expression search247 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search247_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace247_0 -> search14_0 in the cache */

/* replace247_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace247 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search248_0 -> search2_0 in the cache */

/* search248_1_0 -> search2_0 in the cache */
/* search248_1 -> search15_0 in the cache */
static const nir_search_expression search248 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace248_0 -> search2_0 in the cache */
/* replace248 -> search17_0 in the cache */

   /* search249_0 -> search2_0 in the cache */

/* search249_1_0 -> search2_0 in the cache */
/* search249_1 -> search16_0 in the cache */
static const nir_search_expression search249 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &search16_0.value },
   NULL,
};

   /* replace249_0 -> search2_0 in the cache */
/* replace249 -> search20_0 in the cache */

   /* search250_0 -> search2_0 in the cache */

/* search250_1_0 -> search2_0 in the cache */
/* search250_1 -> search15_0 in the cache */
static const nir_search_expression search250 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search15_0.value },
   NULL,
};

   /* replace250_0_0 -> search2_0 in the cache */
/* replace250_0 -> search17_0 in the cache */
/* replace250 -> search208_0 in the cache */

   /* search251_0 -> search2_0 in the cache */

/* search251_1_0 -> search2_0 in the cache */
/* search251_1 -> search16_0 in the cache */
static const nir_search_expression search251 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &search16_0.value },
   NULL,
};

   /* replace251_0_0 -> search2_0 in the cache */
/* replace251_0 -> search20_0 in the cache */
static const nir_search_expression replace251 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search20_0.value },
   NULL,
};

   /* search252_0 -> search2_0 in the cache */

/* search252_1_0_0 -> search2_0 in the cache */
/* search252_1_0 -> search17_0 in the cache */
/* search252_1 -> search208_0 in the cache */
static const nir_search_expression search252 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search208_0.value },
   NULL,
};

   /* replace252_0_0 -> search2_0 in the cache */
/* replace252_0 -> search17_0 in the cache */
/* replace252 -> search208_0 in the cache */

   /* search253_0 -> search2_0 in the cache */

/* search253_1_0_0 -> search2_0 in the cache */
/* search253_1_0 -> search20_0 in the cache */
/* search253_1 -> replace251 in the cache */
static const nir_search_expression search253 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &replace251.value },
   NULL,
};

   /* replace253_0_0 -> search2_0 in the cache */
/* replace253_0 -> search20_0 in the cache */
/* replace253 -> replace251 in the cache */

   /* search254_0 -> search2_0 in the cache */

/* search254_1_0 -> search2_0 in the cache */
/* search254_1 -> search17_0 in the cache */
static const nir_search_expression search254 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search17_0.value },
   NULL,
};

   /* replace254 -> search2_0 in the cache */

   /* search255_0 -> search2_0 in the cache */

/* search255_1_0 -> search2_0 in the cache */
/* search255_1 -> search20_0 in the cache */
static const nir_search_expression search255 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search2_0.value, &search20_0.value },
   NULL,
};

   /* replace255 -> search2_0 in the cache */

   /* search256_0 -> search2_0 in the cache */

/* search256_1_0_0 -> search2_0 in the cache */
/* search256_1_0 -> search17_0 in the cache */
/* search256_1 -> search208_0 in the cache */
static const nir_search_expression search256 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search208_0.value },
   NULL,
};

   /* replace256 -> search2_0 in the cache */

   /* search257_0 -> search2_0 in the cache */

/* search257_1_0_0 -> search2_0 in the cache */
/* search257_1_0 -> search20_0 in the cache */
/* search257_1 -> replace251 in the cache */
static const nir_search_expression search257 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &replace251.value },
   NULL,
};

   /* replace257 -> search2_0 in the cache */

   /* search258_0 -> search2_0 in the cache */

/* search258_1_0 -> search2_0 in the cache */
/* search258_1 -> search17_0 in the cache */
static const nir_search_expression search258 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search17_0.value },
   NULL,
};

   /* replace258_0 -> search2_0 in the cache */
/* replace258 -> search17_0 in the cache */

   /* search259_0 -> search2_0 in the cache */

/* search259_1_0 -> search2_0 in the cache */
/* search259_1 -> search20_0 in the cache */
static const nir_search_expression search259 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search2_0.value, &search20_0.value },
   NULL,
};

   /* replace259_0 -> search2_0 in the cache */
/* replace259 -> search20_0 in the cache */

   /* search260_0 -> search2_0 in the cache */

/* search260_1_0 -> search2_0 in the cache */
/* search260_1 -> search15_0 in the cache */
/* search260 -> search248 in the cache */

   /* replace260_0 -> search2_0 in the cache */
/* replace260 -> search17_0 in the cache */

   /* search261_0 -> search2_0 in the cache */

/* search261_1_0 -> search2_0 in the cache */
/* search261_1 -> search16_0 in the cache */
/* search261 -> search249 in the cache */

   /* replace261_0 -> search2_0 in the cache */
/* replace261 -> search20_0 in the cache */

   /* search262_0_0 -> search2_0 in the cache */
/* search262_0 -> search17_0 in the cache */

/* search262_1 -> search24_1 in the cache */
static const nir_search_expression search262 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search17_0.value, &search24_1.value },
   NULL,
};

   /* replace262_0 -> search2_0 in the cache */
/* replace262 -> search17_0 in the cache */

   /* search263_0_0 -> search2_0 in the cache */

/* search263_0_1 -> search24_1 in the cache */
static const nir_search_expression search263_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search24_1.value },
   NULL,
};

/* search263_1 -> search41_1 in the cache */
static const nir_search_expression search263 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search263_0.value, &search41_1.value },
   NULL,
};

   /* replace263_0 -> search2_0 in the cache */
/* replace263 -> search36_0 in the cache */

   /* search264_0_0 -> search2_0 in the cache */

/* search264_0_1 -> search41_1 in the cache */
static const nir_search_expression search264_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search41_1.value },
   NULL,
};

/* search264_1 -> search24_1 in the cache */
static const nir_search_expression search264 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search264_0.value, &search24_1.value },
   NULL,
};

   /* replace264_0 -> search2_0 in the cache */
/* replace264 -> search36_0 in the cache */

   /* search265_0_0 -> search2_0 in the cache */

/* search265_0_1 -> search43_1 in the cache */
static const nir_search_expression search265_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search2_0.value, &search43_1.value },
   NULL,
};

/* search265_1 -> search24_1 in the cache */
static const nir_search_expression search265 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search265_0.value, &search24_1.value },
   NULL,
};

   /* replace265_0_0_0 -> search2_0 in the cache */
/* replace265_0_0 -> search15_0 in the cache */
/* replace265_0 -> search36_1 in the cache */
static const nir_search_expression replace265 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search36_1.value },
   NULL,
};

   /* search266_0_0 -> search2_0 in the cache */

/* search266_0_1 -> search24_1 in the cache */
static const nir_search_expression search266_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search2_0.value, &search24_1.value },
   NULL,
};

/* search266_1 -> search43_1 in the cache */
static const nir_search_expression search266 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmax,
   { &search266_0.value, &search43_1.value },
   NULL,
};

   /* replace266_0_0_0 -> search2_0 in the cache */
/* replace266_0_0 -> search15_0 in the cache */
/* replace266_0 -> search36_1 in the cache */
/* replace266 -> replace265 in the cache */

   /* search267_0_0 -> search2_0 in the cache */
/* search267_0 -> search45_0 in the cache */
static const nir_search_expression search267 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search45_0.value },
   NULL,
};

   /* replace267_0_0 -> search24_1 in the cache */

/* replace267_0_1 -> search2_0 in the cache */
/* replace267_0 -> replace145 in the cache */
static const nir_search_expression replace267 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace145.value },
   NULL,
};

   /* search268_0_0 -> search2_0 in the cache */
static const nir_search_expression search268_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search268 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search268_0.value },
   NULL,
};

   /* replace268_0 -> search2_0 in the cache */
/* replace268 -> search268_0 in the cache */

   /* search269_0 -> search2_0 in the cache */
/* search269 -> search36_0 in the cache */

   /* replace269_0_0 -> search2_0 in the cache */

/* replace269_0_1 -> search24_1 in the cache */
/* replace269_0 -> search263_0 in the cache */

/* replace269_1 -> search41_1 in the cache */
static const nir_search_expression replace269 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search263_0.value, &search41_1.value },
   NULL,
};

   /* search270_0_0 -> search2_0 in the cache */
/* search270_0 -> search36_0 in the cache */
static const nir_search_expression search270 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search36_0.value },
   NULL,
};

   /* replace270_0 -> search2_0 in the cache */
/* replace270 -> search36_0 in the cache */

   /* search271_0_0_0 -> search14_0 in the cache */

/* search271_0_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search271_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &replace14_1_0.value },
   (is_used_once),
};
static const nir_search_expression search271_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search271_0_0.value },
   (is_used_once),
};
static const nir_search_expression search271 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search271_0.value },
   NULL,
};

   /* replace271_0_0_0 -> search14_0 in the cache */
/* replace271_0_0 -> search34_0 in the cache */

/* replace271_0_1_0 -> replace14_1_0 in the cache */
/* replace271_0_1 -> search126_1 in the cache */
static const nir_search_expression replace271_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search34_0.value, &search126_1.value },
   NULL,
};
static const nir_search_expression replace271 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace271_0.value },
   NULL,
};

   /* search272_0_0_0 -> search14_0 in the cache */

/* search272_0_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search272_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search14_0.value, &replace14_1_0.value },
   (is_used_once),
};
static const nir_search_expression search272_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search272_0_0.value },
   (is_used_once),
};
static const nir_search_expression search272 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search272_0.value },
   NULL,
};

   /* replace272_0_0_0 -> search14_0 in the cache */
/* replace272_0_0 -> search34_0 in the cache */

/* replace272_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace272_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search34_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace272 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace272_0.value },
   NULL,
};

   /* search273_0_0_0 -> search14_0 in the cache */

/* search273_0_0_1 -> replace14_1_0 in the cache */
/* search273_0_0 -> search272_0_0 in the cache */
static const nir_search_expression search273_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search272_0_0.value },
   (is_used_once),
};
static const nir_search_expression search273 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search273_0.value },
   NULL,
};

   /* replace273_0_0_0 -> search14_0 in the cache */
static const nir_search_expression replace273_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search14_0.value },
   NULL,
};

/* replace273_0_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression replace273_0_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace273_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace273_0_0.value, &replace273_0_1.value },
   NULL,
};
static const nir_search_expression replace273 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &replace273_0.value },
   NULL,
};

   /* search274_0_0_0_0 -> search28_0_0 in the cache */

/* search274_0_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search274_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search274_0_0_1 -> search28_1_1 in the cache */
static const nir_search_expression search274_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search274_0_0_0.value, &search28_1_1.value },
   NULL,
};

/* search274_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search274_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search274_0_0.value, &search28_0_1.value },
   NULL,
};

/* search274_1 -> search28_1_1 in the cache */
static const nir_search_expression search274 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search274_0.value, &search28_1_1.value },
   NULL,
};

   /* replace274_0_0 -> search28_0_0 in the cache */

/* replace274_0_1 -> search28_0_1 in the cache */
/* replace274_0 -> search274_0_0_0 in the cache */

/* replace274_1 -> search28_1_1 in the cache */
/* replace274 -> search274_0_0 in the cache */

   /* search275_0_0_0_0 -> search28_0_0 in the cache */

/* search275_0_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search275_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_imax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search275_0_0_1 -> search28_1_1 in the cache */
static const nir_search_expression search275_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_imin,
   { &search275_0_0_0.value, &search28_1_1.value },
   NULL,
};

/* search275_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search275_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_imax,
   { &search275_0_0.value, &search28_0_1.value },
   NULL,
};

/* search275_1 -> search28_1_1 in the cache */
static const nir_search_expression search275 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_imin,
   { &search275_0.value, &search28_1_1.value },
   NULL,
};

   /* replace275_0_0 -> search28_0_0 in the cache */

/* replace275_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace275_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace275_1 -> search28_1_1 in the cache */
static const nir_search_expression replace275 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace275_0.value, &search28_1_1.value },
   NULL,
};

   /* search276_0_0_0_0 -> search28_0_0 in the cache */

/* search276_0_0_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search276_0_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   3, 1,
   nir_op_umax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* search276_0_0_1 -> search28_1_1 in the cache */
static const nir_search_expression search276_0_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   2, 2,
   nir_op_umin,
   { &search276_0_0_0.value, &search28_1_1.value },
   NULL,
};

/* search276_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search276_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 3,
   nir_op_umax,
   { &search276_0_0.value, &search28_0_1.value },
   NULL,
};

/* search276_1 -> search28_1_1 in the cache */
static const nir_search_expression search276 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 4,
   nir_op_umin,
   { &search276_0.value, &search28_1_1.value },
   NULL,
};

   /* replace276_0_0 -> search28_0_0 in the cache */

/* replace276_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace276_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_umax,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace276_1 -> search28_1_1 in the cache */
static const nir_search_expression replace276 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_umin,
   { &replace276_0.value, &search28_1_1.value },
   NULL,
};

   /* search277_0_0 -> search0_0 in the cache */
static const nir_search_expression search277_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search277_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   true,
   nir_type_invalid,
   (is_zero_to_one),
   {0, 1, 2, 3},
};
static const nir_search_expression search277 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search277_0.value, &search277_1.value },
   NULL,
};

   /* replace277_0_0 -> search0_0 in the cache */

/* replace277_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace277_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace277 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &replace277_0.value },
   NULL,
};

   /* search278_0_0 -> search0_0 in the cache */
/* search278_0 -> search277_0 in the cache */

/* search278_1 -> search277_1 in the cache */
static const nir_search_expression search278 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search277_0.value, &search277_1.value },
   NULL,
};

   /* replace278_0_0 -> search0_0 in the cache */

/* replace278_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace278_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace278 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &replace278_0.value },
   NULL,
};

   /* search279_0_0_0 -> search2_0 in the cache */

/* search279_0_0_1 -> replace9 in the cache */
static const nir_search_expression search279_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search2_0.value, &replace9.value },
   NULL,
};

static const nir_search_constant search279_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xff /* 255 */ },
};
static const nir_search_expression search279_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_imin,
   { &search279_0_0.value, &search279_0_1.value },
   NULL,
};

/* search279_1 -> replace9 in the cache */
static const nir_search_expression search279 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_extract_u8,
   { &search279_0.value, &replace9.value },
   NULL,
};

   /* replace279_0_0 -> search2_0 in the cache */

/* replace279_0_1 -> replace9 in the cache */
/* replace279_0 -> search279_0_0 in the cache */

/* replace279_1 -> search279_0_1 in the cache */
/* replace279 -> search279_0 in the cache */

   /* search280_0_0 -> search28_0_0 in the cache */

/* search280_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search280_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search280_1_0 -> search28_0_0 in the cache */

/* search280_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search280_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search280 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search280_0.value, &search280_1.value },
   NULL,
};

   /* replace280_0 -> search28_0_0 in the cache */

/* replace280_1_0 -> search28_0_1 in the cache */

/* replace280_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace280_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace280 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &replace280_1.value },
   NULL,
};

   /* search281_0_0 -> search14_0 in the cache */

/* search281_0_1 -> search64_2 in the cache */
static const nir_search_expression search281_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

static const nir_search_variable search281_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search281_1_1 -> search64_2 in the cache */
static const nir_search_expression search281_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search281_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search281 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search281_0.value, &search281_1.value },
   NULL,
};

   /* replace281_0_0 -> search14_0 in the cache */

/* replace281_0_1 -> search281_1_0 in the cache */
static const nir_search_expression replace281_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search14_0.value, &search281_1_0.value },
   NULL,
};

/* replace281_1 -> search64_2 in the cache */
static const nir_search_expression replace281 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace281_0.value, &search64_2.value },
   NULL,
};

   /* search282_0_0 -> search28_0_0 in the cache */

/* search282_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search282_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search282_1_0 -> search28_0_0 in the cache */

/* search282_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search282_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search282 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search282_0.value, &search282_1.value },
   NULL,
};

   /* replace282_0 -> search28_0_0 in the cache */

/* replace282_1_0 -> search28_0_1 in the cache */

/* replace282_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace282_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace282 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &replace282_1.value },
   NULL,
};

   /* search283_0_0 -> search14_0 in the cache */

/* search283_0_1 -> search64_2 in the cache */
static const nir_search_expression search283_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search283_1_0 -> search281_1_0 in the cache */

/* search283_1_1 -> search64_2 in the cache */
static const nir_search_expression search283_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search281_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search283 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search283_0.value, &search283_1.value },
   NULL,
};

   /* replace283_0_0 -> search14_0 in the cache */

/* replace283_0_1 -> search281_1_0 in the cache */
static const nir_search_expression replace283_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search14_0.value, &search281_1_0.value },
   NULL,
};

/* replace283_1 -> search64_2 in the cache */
static const nir_search_expression replace283 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace283_0.value, &search64_2.value },
   NULL,
};

   /* search284_0_0 -> search28_0_0 in the cache */

/* search284_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search284_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search96_0_0_1.value },
   NULL,
};

/* search284_1_0 -> search28_0_0 in the cache */

/* search284_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search284_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search284 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search284_0.value, &search284_1.value },
   NULL,
};

   /* replace284_0 -> search28_0_0 in the cache */

/* replace284_1_0 -> search28_0_1 in the cache */

/* replace284_1_1 -> search28_1_1 in the cache */
/* replace284_1 -> replace280_1 in the cache */
/* replace284 -> replace280 in the cache */

   static const nir_search_variable search285_0_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search285_0_1 -> search64_2 in the cache */
static const nir_search_expression search285_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search285_0_0.value, &search64_2.value },
   NULL,
};

static const nir_search_variable search285_1_0 = {
   { nir_search_value_variable, -2 },
   2, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search285_1_1 -> search64_2 in the cache */
static const nir_search_expression search285_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search285_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search285 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search285_0.value, &search285_1.value },
   NULL,
};

   /* replace285_0_0 -> search14_0 in the cache */

/* replace285_0_1 -> search281_1_0 in the cache */
/* replace285_0 -> replace281_0 in the cache */

/* replace285_1 -> search64_2 in the cache */
/* replace285 -> replace281 in the cache */

   /* search286_0_0 -> search28_0_0 in the cache */

/* search286_0_1 -> search96_0_0_1 in the cache */
static const nir_search_expression search286_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search96_0_0_1.value },
   NULL,
};

/* search286_1_0 -> search28_0_0 in the cache */

/* search286_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search286_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search286 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search286_0.value, &search286_1.value },
   NULL,
};

   /* replace286_0 -> search28_0_0 in the cache */

/* replace286_1_0 -> search28_0_1 in the cache */

/* replace286_1_1 -> search28_1_1 in the cache */
/* replace286_1 -> replace282_1 in the cache */
/* replace286 -> replace282 in the cache */

   /* search287_0_0 -> search285_0_0 in the cache */

/* search287_0_1 -> search64_2 in the cache */
static const nir_search_expression search287_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search285_0_0.value, &search64_2.value },
   NULL,
};

/* search287_1_0 -> search285_1_0 in the cache */

/* search287_1_1 -> search64_2 in the cache */
static const nir_search_expression search287_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search285_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search287 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search287_0.value, &search287_1.value },
   NULL,
};

   /* replace287_0_0 -> search14_0 in the cache */

/* replace287_0_1 -> search281_1_0 in the cache */
/* replace287_0 -> replace283_0 in the cache */

/* replace287_1 -> search64_2 in the cache */
/* replace287 -> replace283 in the cache */

   /* search288_0_0 -> search28_0_0 in the cache */

/* search288_0_1 -> search28_0_1 in the cache */
/* search288_0 -> search280_0 in the cache */

/* search288_1_0 -> search28_0_0 in the cache */

/* search288_1_1 -> search28_1_1 in the cache */
/* search288_1 -> search280_1 in the cache */
static const nir_search_expression search288 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search280_0.value, &search280_1.value },
   NULL,
};

   /* replace288_0 -> search28_0_0 in the cache */

/* replace288_1_0 -> search28_0_1 in the cache */

/* replace288_1_1 -> search28_1_1 in the cache */
/* replace288_1 -> replace282_1 in the cache */
static const nir_search_expression replace288 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search28_0_0.value, &replace282_1.value },
   NULL,
};

   /* search289_0_0 -> search14_0 in the cache */

/* search289_0_1 -> search64_2 in the cache */
/* search289_0 -> search281_0 in the cache */

/* search289_1_0 -> search281_1_0 in the cache */

/* search289_1_1 -> search64_2 in the cache */
/* search289_1 -> search281_1 in the cache */
static const nir_search_expression search289 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search281_0.value, &search281_1.value },
   NULL,
};

   /* replace289_0_0 -> search14_0 in the cache */

/* replace289_0_1 -> search281_1_0 in the cache */
/* replace289_0 -> replace283_0 in the cache */

/* replace289_1 -> search64_2 in the cache */
static const nir_search_expression replace289 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace283_0.value, &search64_2.value },
   NULL,
};

   /* search290_0_0 -> search28_0_0 in the cache */

/* search290_0_1 -> search28_0_1 in the cache */
/* search290_0 -> search282_0 in the cache */

/* search290_1_0 -> search28_0_0 in the cache */

/* search290_1_1 -> search28_1_1 in the cache */
/* search290_1 -> search282_1 in the cache */
static const nir_search_expression search290 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search282_0.value, &search282_1.value },
   NULL,
};

   /* replace290_0 -> search28_0_0 in the cache */

/* replace290_1_0 -> search28_0_1 in the cache */

/* replace290_1_1 -> search28_1_1 in the cache */
/* replace290_1 -> replace280_1 in the cache */
static const nir_search_expression replace290 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search28_0_0.value, &replace280_1.value },
   NULL,
};

   /* search291_0_0 -> search14_0 in the cache */

/* search291_0_1 -> search64_2 in the cache */
/* search291_0 -> search283_0 in the cache */

/* search291_1_0 -> search281_1_0 in the cache */

/* search291_1_1 -> search64_2 in the cache */
/* search291_1 -> search283_1 in the cache */
static const nir_search_expression search291 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search283_0.value, &search283_1.value },
   NULL,
};

   /* replace291_0_0 -> search14_0 in the cache */

/* replace291_0_1 -> search281_1_0 in the cache */
/* replace291_0 -> replace281_0 in the cache */

/* replace291_1 -> search64_2 in the cache */
static const nir_search_expression replace291 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace281_0.value, &search64_2.value },
   NULL,
};

   /* search292_0_0 -> search28_0_0 in the cache */

/* search292_0_1 -> search96_0_0_1 in the cache */
/* search292_0 -> search284_0 in the cache */

/* search292_1_0 -> search28_0_0 in the cache */

/* search292_1_1 -> search96_0_1 in the cache */
/* search292_1 -> search284_1 in the cache */
static const nir_search_expression search292 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search284_0.value, &search284_1.value },
   NULL,
};

   /* replace292_0 -> search28_0_0 in the cache */

/* replace292_1_0 -> search28_0_1 in the cache */

/* replace292_1_1 -> search28_1_1 in the cache */
/* replace292_1 -> replace282_1 in the cache */
/* replace292 -> replace288 in the cache */

   /* search293_0_0 -> search285_0_0 in the cache */

/* search293_0_1 -> search64_2 in the cache */
/* search293_0 -> search285_0 in the cache */

/* search293_1_0 -> search285_1_0 in the cache */

/* search293_1_1 -> search64_2 in the cache */
/* search293_1 -> search285_1 in the cache */
static const nir_search_expression search293 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search285_0.value, &search285_1.value },
   NULL,
};

   /* replace293_0_0 -> search14_0 in the cache */

/* replace293_0_1 -> search281_1_0 in the cache */
/* replace293_0 -> replace283_0 in the cache */

/* replace293_1 -> search64_2 in the cache */
/* replace293 -> replace289 in the cache */

   /* search294_0_0 -> search28_0_0 in the cache */

/* search294_0_1 -> search96_0_0_1 in the cache */
/* search294_0 -> search286_0 in the cache */

/* search294_1_0 -> search28_0_0 in the cache */

/* search294_1_1 -> search96_0_1 in the cache */
/* search294_1 -> search286_1 in the cache */
static const nir_search_expression search294 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search286_0.value, &search286_1.value },
   NULL,
};

   /* replace294_0 -> search28_0_0 in the cache */

/* replace294_1_0 -> search28_0_1 in the cache */

/* replace294_1_1 -> search28_1_1 in the cache */
/* replace294_1 -> replace280_1 in the cache */
/* replace294 -> replace290 in the cache */

   /* search295_0_0 -> search285_0_0 in the cache */

/* search295_0_1 -> search64_2 in the cache */
/* search295_0 -> search287_0 in the cache */

/* search295_1_0 -> search285_1_0 in the cache */

/* search295_1_1 -> search64_2 in the cache */
/* search295_1 -> search287_1 in the cache */
static const nir_search_expression search295 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search287_0.value, &search287_1.value },
   NULL,
};

   /* replace295_0_0 -> search14_0 in the cache */

/* replace295_0_1 -> search281_1_0 in the cache */
/* replace295_0 -> replace281_0 in the cache */

/* replace295_1 -> search64_2 in the cache */
/* replace295 -> replace291 in the cache */

   /* search296_0_0 -> search28_0_0 in the cache */

/* search296_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search296_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search296_1_0 -> search28_0_0 in the cache */

/* search296_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search296_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search296 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search296_0.value, &search296_1.value },
   NULL,
};

   /* replace296_0 -> search28_0_0 in the cache */

/* replace296_1_0 -> search28_0_1 in the cache */

/* replace296_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace296_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace296 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search28_0_0.value, &replace296_1.value },
   NULL,
};

   /* search297_0_0 -> search14_0 in the cache */

/* search297_0_1 -> search64_2 in the cache */
static const nir_search_expression search297_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search297_1_0 -> search281_1_0 in the cache */

/* search297_1_1 -> search64_2 in the cache */
static const nir_search_expression search297_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search281_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search297 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search297_0.value, &search297_1.value },
   NULL,
};

   /* replace297_0_0 -> search14_0 in the cache */

/* replace297_0_1 -> search281_1_0 in the cache */
static const nir_search_expression replace297_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search14_0.value, &search281_1_0.value },
   NULL,
};

/* replace297_1 -> search64_2 in the cache */
static const nir_search_expression replace297 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace297_0.value, &search64_2.value },
   NULL,
};

   /* search298_0_0 -> search28_0_0 in the cache */

/* search298_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search298_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search298_1_0 -> search28_0_0 in the cache */

/* search298_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search298_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search298 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search298_0.value, &search298_1.value },
   NULL,
};

   /* replace298_0 -> search28_0_0 in the cache */

/* replace298_1_0 -> search28_0_1 in the cache */

/* replace298_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace298_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace298 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search28_0_0.value, &replace298_1.value },
   NULL,
};

   /* search299_0_0 -> search14_0 in the cache */

/* search299_0_1 -> search64_2 in the cache */
static const nir_search_expression search299_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search299_1_0 -> search281_1_0 in the cache */

/* search299_1_1 -> search64_2 in the cache */
static const nir_search_expression search299_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search281_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search299 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search299_0.value, &search299_1.value },
   NULL,
};

   /* replace299_0_0 -> search14_0 in the cache */

/* replace299_0_1 -> search281_1_0 in the cache */
static const nir_search_expression replace299_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search14_0.value, &search281_1_0.value },
   NULL,
};

/* replace299_1 -> search64_2 in the cache */
static const nir_search_expression replace299 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace299_0.value, &search64_2.value },
   NULL,
};

   /* search300_0_0 -> search28_0_0 in the cache */

/* search300_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search300_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search300_1_0 -> search28_0_0 in the cache */

/* search300_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search300_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search300 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search300_0.value, &search300_1.value },
   NULL,
};

   /* replace300_0 -> search28_0_0 in the cache */

/* replace300_1_0 -> search28_0_1 in the cache */

/* replace300_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace300_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace300 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search28_0_0.value, &replace300_1.value },
   NULL,
};

   /* search301_0_0 -> search14_0 in the cache */

/* search301_0_1 -> search64_2 in the cache */
static const nir_search_expression search301_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search301_1_0 -> search281_1_0 in the cache */

/* search301_1_1 -> search64_2 in the cache */
static const nir_search_expression search301_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search281_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search301 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search301_0.value, &search301_1.value },
   NULL,
};

   /* replace301_0_0 -> search14_0 in the cache */

/* replace301_0_1 -> search281_1_0 in the cache */
static const nir_search_expression replace301_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search14_0.value, &search281_1_0.value },
   NULL,
};

/* replace301_1 -> search64_2 in the cache */
static const nir_search_expression replace301 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace301_0.value, &search64_2.value },
   NULL,
};

   /* search302_0_0 -> search28_0_0 in the cache */

/* search302_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search302_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_0.value, &search28_0_1.value },
   (is_used_once),
};

/* search302_1_0 -> search28_0_0 in the cache */

/* search302_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search302_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search302 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search302_0.value, &search302_1.value },
   NULL,
};

   /* replace302_0 -> search28_0_0 in the cache */

/* replace302_1_0 -> search28_0_1 in the cache */

/* replace302_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace302_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace302 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search28_0_0.value, &replace302_1.value },
   NULL,
};

   /* search303_0_0 -> search14_0 in the cache */

/* search303_0_1 -> search64_2 in the cache */
static const nir_search_expression search303_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search14_0.value, &search64_2.value },
   (is_used_once),
};

/* search303_1_0 -> search281_1_0 in the cache */

/* search303_1_1 -> search64_2 in the cache */
static const nir_search_expression search303_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search281_1_0.value, &search64_2.value },
   NULL,
};
static const nir_search_expression search303 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search303_0.value, &search303_1.value },
   NULL,
};

   /* replace303_0_0 -> search14_0 in the cache */

/* replace303_0_1 -> search281_1_0 in the cache */
static const nir_search_expression replace303_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search14_0.value, &search281_1_0.value },
   NULL,
};

/* replace303_1 -> search64_2 in the cache */
static const nir_search_expression replace303 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace303_0.value, &search64_2.value },
   NULL,
};

   /* search304_0_0 -> search28_0_0 in the cache */

/* search304_0_1 -> search28_0_1 in the cache */
/* search304_0 -> search296_0 in the cache */

/* search304_1_0 -> search28_0_0 in the cache */

/* search304_1_1 -> search28_1_1 in the cache */
/* search304_1 -> search296_1 in the cache */
static const nir_search_expression search304 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search296_0.value, &search296_1.value },
   NULL,
};

   /* replace304_0 -> search28_0_0 in the cache */

/* replace304_1_0 -> search28_0_1 in the cache */

/* replace304_1_1 -> search28_1_1 in the cache */
/* replace304_1 -> replace298_1 in the cache */
static const nir_search_expression replace304 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search28_0_0.value, &replace298_1.value },
   NULL,
};

   /* search305_0_0 -> search14_0 in the cache */

/* search305_0_1 -> search64_2 in the cache */
/* search305_0 -> search297_0 in the cache */

/* search305_1_0 -> search281_1_0 in the cache */

/* search305_1_1 -> search64_2 in the cache */
/* search305_1 -> search297_1 in the cache */
static const nir_search_expression search305 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search297_0.value, &search297_1.value },
   NULL,
};

   /* replace305_0_0 -> search14_0 in the cache */

/* replace305_0_1 -> search281_1_0 in the cache */
/* replace305_0 -> replace299_0 in the cache */

/* replace305_1 -> search64_2 in the cache */
static const nir_search_expression replace305 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace299_0.value, &search64_2.value },
   NULL,
};

   /* search306_0_0 -> search28_0_0 in the cache */

/* search306_0_1 -> search28_0_1 in the cache */
/* search306_0 -> search298_0 in the cache */

/* search306_1_0 -> search28_0_0 in the cache */

/* search306_1_1 -> search28_1_1 in the cache */
/* search306_1 -> search298_1 in the cache */
static const nir_search_expression search306 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search298_0.value, &search298_1.value },
   NULL,
};

   /* replace306_0 -> search28_0_0 in the cache */

/* replace306_1_0 -> search28_0_1 in the cache */

/* replace306_1_1 -> search28_1_1 in the cache */
/* replace306_1 -> replace296_1 in the cache */
static const nir_search_expression replace306 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search28_0_0.value, &replace296_1.value },
   NULL,
};

   /* search307_0_0 -> search14_0 in the cache */

/* search307_0_1 -> search64_2 in the cache */
/* search307_0 -> search299_0 in the cache */

/* search307_1_0 -> search281_1_0 in the cache */

/* search307_1_1 -> search64_2 in the cache */
/* search307_1 -> search299_1 in the cache */
static const nir_search_expression search307 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search299_0.value, &search299_1.value },
   NULL,
};

   /* replace307_0_0 -> search14_0 in the cache */

/* replace307_0_1 -> search281_1_0 in the cache */
/* replace307_0 -> replace297_0 in the cache */

/* replace307_1 -> search64_2 in the cache */
static const nir_search_expression replace307 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace297_0.value, &search64_2.value },
   NULL,
};

   /* search308_0_0 -> search28_0_0 in the cache */

/* search308_0_1 -> search28_0_1 in the cache */
/* search308_0 -> search300_0 in the cache */

/* search308_1_0 -> search28_0_0 in the cache */

/* search308_1_1 -> search28_1_1 in the cache */
/* search308_1 -> search300_1 in the cache */
static const nir_search_expression search308 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search300_0.value, &search300_1.value },
   NULL,
};

   /* replace308_0 -> search28_0_0 in the cache */

/* replace308_1_0 -> search28_0_1 in the cache */

/* replace308_1_1 -> search28_1_1 in the cache */
/* replace308_1 -> replace302_1 in the cache */
static const nir_search_expression replace308 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search28_0_0.value, &replace302_1.value },
   NULL,
};

   /* search309_0_0 -> search14_0 in the cache */

/* search309_0_1 -> search64_2 in the cache */
/* search309_0 -> search301_0 in the cache */

/* search309_1_0 -> search281_1_0 in the cache */

/* search309_1_1 -> search64_2 in the cache */
/* search309_1 -> search301_1 in the cache */
static const nir_search_expression search309 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search301_0.value, &search301_1.value },
   NULL,
};

   /* replace309_0_0 -> search14_0 in the cache */

/* replace309_0_1 -> search281_1_0 in the cache */
/* replace309_0 -> replace303_0 in the cache */

/* replace309_1 -> search64_2 in the cache */
static const nir_search_expression replace309 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace303_0.value, &search64_2.value },
   NULL,
};

   /* search310_0_0 -> search28_0_0 in the cache */

/* search310_0_1 -> search28_0_1 in the cache */
/* search310_0 -> search302_0 in the cache */

/* search310_1_0 -> search28_0_0 in the cache */

/* search310_1_1 -> search28_1_1 in the cache */
/* search310_1 -> search302_1 in the cache */
static const nir_search_expression search310 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search302_0.value, &search302_1.value },
   NULL,
};

   /* replace310_0 -> search28_0_0 in the cache */

/* replace310_1_0 -> search28_0_1 in the cache */

/* replace310_1_1 -> search28_1_1 in the cache */
/* replace310_1 -> replace300_1 in the cache */
static const nir_search_expression replace310 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search28_0_0.value, &replace300_1.value },
   NULL,
};

   /* search311_0_0 -> search14_0 in the cache */

/* search311_0_1 -> search64_2 in the cache */
/* search311_0 -> search303_0 in the cache */

/* search311_1_0 -> search281_1_0 in the cache */

/* search311_1_1 -> search64_2 in the cache */
/* search311_1 -> search303_1 in the cache */
static const nir_search_expression search311 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search303_0.value, &search303_1.value },
   NULL,
};

   /* replace311_0_0 -> search14_0 in the cache */

/* replace311_0_1 -> search281_1_0 in the cache */
/* replace311_0 -> replace301_0 in the cache */

/* replace311_1 -> search64_2 in the cache */
static const nir_search_expression replace311 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace301_0.value, &search64_2.value },
   NULL,
};

   static const nir_search_constant search312_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x0 /* 0.0 */ },
};

/* search312_0_1 -> search0_0 in the cache */
static const nir_search_expression search312_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search312_0_0.value, &search0_0.value },
   (is_used_once),
};

/* search312_1_0 -> replace0_1_0 in the cache */

/* search312_1_1 -> search312_0_0 in the cache */
static const nir_search_expression search312_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search312_0_0.value },
   NULL,
};
static const nir_search_expression search312 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search312_0.value, &search312_1.value },
   NULL,
};

   /* replace312_0 -> search312_0_0 in the cache */

/* replace312_1_0 -> search0_0 in the cache */

/* replace312_1_1_0 -> replace0_1_0 in the cache */
/* replace312_1_1 -> search95_1_0_1_1 in the cache */
static const nir_search_expression replace312_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search0_0.value, &search95_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace312 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search312_0_0.value, &replace312_1.value },
   NULL,
};

   /* search313_0_0 -> search312_0_0 in the cache */

/* search313_0_1 -> search0_0 in the cache */
static const nir_search_expression search313_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search312_0_0.value, &search0_0.value },
   NULL,
};

/* search313_1_0 -> replace0_1_0 in the cache */

/* search313_1_1 -> search312_0_0 in the cache */
static const nir_search_expression search313_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace0_1_0.value, &search312_0_0.value },
   (is_used_once),
};
static const nir_search_expression search313 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search313_0.value, &search313_1.value },
   NULL,
};

   /* replace313_0 -> search312_0_0 in the cache */

/* replace313_1_0 -> search0_0 in the cache */

/* replace313_1_1_0 -> replace0_1_0 in the cache */
/* replace313_1_1 -> search95_1_0_1_1 in the cache */
/* replace313_1 -> replace312_1 in the cache */
/* replace313 -> replace312 in the cache */

   /* search314_0_0 -> search312_0_0 in the cache */

/* search314_0_1 -> search0_0 in the cache */
static const nir_search_expression search314_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search312_0_0.value, &search0_0.value },
   (is_used_once),
};

/* search314_1_0 -> replace0_1_0 in the cache */

/* search314_1_1 -> search312_0_0 in the cache */
static const nir_search_expression search314_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search312_0_0.value },
   NULL,
};
static const nir_search_expression search314 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search314_0.value, &search314_1.value },
   NULL,
};

   /* replace314_0 -> search312_0_0 in the cache */

/* replace314_1_0 -> search0_0 in the cache */

/* replace314_1_1_0 -> replace0_1_0 in the cache */
/* replace314_1_1 -> search95_1_0_1_1 in the cache */
static const nir_search_expression replace314_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search0_0.value, &search95_1_0_1_1.value },
   NULL,
};
static const nir_search_expression replace314 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search312_0_0.value, &replace314_1.value },
   NULL,
};

   /* search315_0_0 -> search312_0_0 in the cache */

/* search315_0_1 -> search0_0 in the cache */
static const nir_search_expression search315_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search312_0_0.value, &search0_0.value },
   NULL,
};

/* search315_1_0 -> replace0_1_0 in the cache */

/* search315_1_1 -> search312_0_0 in the cache */
static const nir_search_expression search315_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace0_1_0.value, &search312_0_0.value },
   (is_used_once),
};
static const nir_search_expression search315 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_ior,
   { &search315_0.value, &search315_1.value },
   NULL,
};

   /* replace315_0 -> search312_0_0 in the cache */

/* replace315_1_0 -> search0_0 in the cache */

/* replace315_1_1_0 -> replace0_1_0 in the cache */
/* replace315_1_1 -> search95_1_0_1_1 in the cache */
/* replace315_1 -> replace314_1 in the cache */
/* replace315 -> replace314 in the cache */

   /* search316_0_0 -> search312_0_0 in the cache */

/* search316_0_1 -> search0_0 in the cache */
/* search316_0 -> search312_0 in the cache */

/* search316_1_0 -> replace0_1_0 in the cache */

/* search316_1_1 -> search312_0_0 in the cache */
/* search316_1 -> search312_1 in the cache */
static const nir_search_expression search316 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search312_0.value, &search312_1.value },
   NULL,
};

   /* replace316_0 -> search312_0_0 in the cache */

/* replace316_1_0 -> search0_0 in the cache */

/* replace316_1_1_0 -> replace0_1_0 in the cache */
/* replace316_1_1 -> search95_1_0_1_1 in the cache */
/* replace316_1 -> replace314_1 in the cache */
static const nir_search_expression replace316 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search312_0_0.value, &replace314_1.value },
   NULL,
};

   /* search317_0_0 -> search312_0_0 in the cache */

/* search317_0_1 -> search0_0 in the cache */
/* search317_0 -> search313_0 in the cache */

/* search317_1_0 -> replace0_1_0 in the cache */

/* search317_1_1 -> search312_0_0 in the cache */
/* search317_1 -> search313_1 in the cache */
static const nir_search_expression search317 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search313_0.value, &search313_1.value },
   NULL,
};

   /* replace317_0 -> search312_0_0 in the cache */

/* replace317_1_0 -> search0_0 in the cache */

/* replace317_1_1_0 -> replace0_1_0 in the cache */
/* replace317_1_1 -> search95_1_0_1_1 in the cache */
/* replace317_1 -> replace314_1 in the cache */
/* replace317 -> replace316 in the cache */

   /* search318_0_0 -> search312_0_0 in the cache */

/* search318_0_1 -> search0_0 in the cache */
/* search318_0 -> search314_0 in the cache */

/* search318_1_0 -> replace0_1_0 in the cache */

/* search318_1_1 -> search312_0_0 in the cache */
/* search318_1 -> search314_1 in the cache */
static const nir_search_expression search318 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search314_0.value, &search314_1.value },
   NULL,
};

   /* replace318_0 -> search312_0_0 in the cache */

/* replace318_1_0 -> search0_0 in the cache */

/* replace318_1_1_0 -> replace0_1_0 in the cache */
/* replace318_1_1 -> search95_1_0_1_1 in the cache */
/* replace318_1 -> replace312_1 in the cache */
static const nir_search_expression replace318 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search312_0_0.value, &replace312_1.value },
   NULL,
};

   /* search319_0_0 -> search312_0_0 in the cache */

/* search319_0_1 -> search0_0 in the cache */
/* search319_0 -> search315_0 in the cache */

/* search319_1_0 -> replace0_1_0 in the cache */

/* search319_1_1 -> search312_0_0 in the cache */
/* search319_1 -> search315_1 in the cache */
static const nir_search_expression search319 = {
   { nir_search_value_expression, 1 },
   true, false,
   0, 1,
   nir_op_iand,
   { &search315_0.value, &search315_1.value },
   NULL,
};

   /* replace319_0 -> search312_0_0 in the cache */

/* replace319_1_0 -> search0_0 in the cache */

/* replace319_1_1_0 -> replace0_1_0 in the cache */
/* replace319_1_1 -> search95_1_0_1_1 in the cache */
/* replace319_1 -> replace312_1 in the cache */
/* replace319 -> replace318 in the cache */

   /* search320_0_0 -> search2_0 in the cache */

/* search320_0_1 -> replace9 in the cache */
static const nir_search_expression search320_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &replace9.value },
   NULL,
};

/* search320_1_0 -> search2_0 in the cache */

/* search320_1_1 -> replace2_1_0 in the cache */
static const nir_search_expression search320_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};
static const nir_search_expression search320 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search320_0.value, &search320_1.value },
   NULL,
};

   /* replace320_0 -> replace2_1_0 in the cache */

/* replace320_1 -> search2_0 in the cache */
static const nir_search_expression replace320 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace2_1_0.value, &search2_0.value },
   NULL,
};

   /* search321_0_0 -> replace2_1_0 in the cache */

/* search321_0_1 -> search2_0 in the cache */
/* search321_0 -> replace320 in the cache */

/* search321_1_0 -> search2_0 in the cache */

static const nir_search_constant search321_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression search321_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &search321_1_1.value },
   NULL,
};
static const nir_search_expression search321 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace320.value, &search321_1.value },
   NULL,
};

   /* replace321_0 -> search321_1_1 in the cache */

/* replace321_1 -> search2_0 in the cache */
static const nir_search_expression replace321 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search321_1_1.value, &search2_0.value },
   NULL,
};

   /* search322_0_0 -> search321_1_1 in the cache */

/* search322_0_1 -> search2_0 in the cache */
/* search322_0 -> replace321 in the cache */

/* search322_1_0 -> search2_0 in the cache */

static const nir_search_constant search322_1_1 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression search322_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search2_0.value, &search322_1_1.value },
   NULL,
};
static const nir_search_expression search322 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace321.value, &search322_1.value },
   NULL,
};

   /* replace322_0 -> search322_1_1 in the cache */

/* replace322_1 -> search2_0 in the cache */
static const nir_search_expression replace322 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search322_1_1.value, &search2_0.value },
   NULL,
};

   /* search323_0_0 -> search0_0 in the cache */

/* search323_0_1 -> search312_0_0 in the cache */
static const nir_search_expression search323_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &search312_0_0.value },
   NULL,
};

/* search323_1 -> replace60_0_0 in the cache */

/* search323_2_0_0_0_0 -> search312_0_0 in the cache */

/* search323_2_0_0_0_1 -> search0_0 in the cache */
/* search323_2_0_0_0 -> search313_0 in the cache */
static const nir_search_expression search323_2_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search313_0.value },
   NULL,
};

/* search323_2_0_1_0_0_0 -> search0_0 in the cache */

/* search323_2_0_1_0_0_1 -> search312_0_0 in the cache */
static const nir_search_expression search323_2_0_1_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search312_0_0.value },
   NULL,
};
static const nir_search_expression search323_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search323_2_0_1_0_0.value },
   NULL,
};
static const nir_search_expression search323_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search323_2_0_1_0.value },
   NULL,
};
static const nir_search_expression search323_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search323_2_0_0.value, &search323_2_0_1.value },
   NULL,
};
static const nir_search_expression search323_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_i2f32,
   { &search323_2_0.value },
   NULL,
};
static const nir_search_expression search323 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &search323_0.value, &replace60_0_0.value, &search323_2.value },
   NULL,
};

   static const nir_search_constant replace323_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3f800000 /* 1065353216 */ },
};

/* replace323_1_0 -> search0_0 in the cache */

static const nir_search_constant replace323_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x80000000 /* 2147483648 */ },
};
static const nir_search_expression replace323_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search0_0.value, &replace323_1_1.value },
   NULL,
};
static const nir_search_expression replace323 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace323_0.value, &replace323_1.value },
   NULL,
};

   /* search324_0 -> replace80_0 in the cache */

/* search324_1_0 -> replace80_0 in the cache */

/* search324_1_1 -> replace121 in the cache */
static const nir_search_expression search324_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &replace80_0.value, &replace121.value },
   NULL,
};
static const nir_search_expression search324 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace80_0.value, &search324_1.value },
   NULL,
};

   /* replace324 -> replace197 in the cache */

   /* search325_0 -> search2_0 in the cache */

/* search325_1_0 -> search2_0 in the cache */
static const nir_search_expression search325_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search325 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &search325_1.value },
   NULL,
};

   /* replace325 -> search44_1 in the cache */

   /* search326_0_0_0 -> replace80_0 in the cache */
static const nir_search_expression search326_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &replace80_0.value },
   NULL,
};
static const nir_search_expression search326_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search326_0_0.value },
   NULL,
};

/* search326_1_0_0 -> search148_0_1_0 in the cache */
static const nir_search_expression search326_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search148_0_1_0.value },
   NULL,
};
static const nir_search_expression search326_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search326_1_0.value },
   NULL,
};
static const nir_search_expression search326 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search326_0.value, &search326_1.value },
   NULL,
};

   /* replace326_0 -> replace80_0 in the cache */

/* replace326_1 -> search148_0_1_0 in the cache */
static const nir_search_expression replace326 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace80_0.value, &search148_0_1_0.value },
   NULL,
};

   /* search327_0_0 -> replace80_0 in the cache */

/* search327_0_1 -> search148_0_1_0 in the cache */
/* search327_0 -> replace326 in the cache */
static const nir_search_expression search327 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_b2i32,
   { &replace326.value },
   NULL,
};

   /* replace327_0_0 -> replace80_0 in the cache */

/* replace327_0_1 -> search148_0_1_0 in the cache */
/* replace327_0 -> replace155 in the cache */
static const nir_search_expression replace327 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_b2i32,
   { &replace155.value },
   NULL,
};

   /* search328_0_0 -> search0_0 in the cache */

/* search328_0_1 -> search26_1 in the cache */
static const nir_search_expression search328_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* search328_1_0 -> replace0_1_0 in the cache */

/* search328_1_1 -> search26_1 in the cache */
static const nir_search_expression search328_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace0_1_0.value, &search26_1.value },
   NULL,
};
static const nir_search_expression search328 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search328_0.value, &search328_1.value },
   NULL,
};

   /* replace328_0_0 -> search0_0 in the cache */

/* replace328_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace328_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace328_1 -> search26_1 in the cache */
static const nir_search_expression replace328 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ieq,
   { &replace328_0.value, &search26_1.value },
   NULL,
};

   /* search329_0 -> search2_0 in the cache */

static const nir_search_variable search329_1_0 = {
   { nir_search_value_variable, -1 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search329_1_1 -> search2_0 in the cache */
static const nir_search_expression search329_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search329 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search329_1.value },
   NULL,
};

   /* replace329_0 -> search2_0 in the cache */

/* replace329_1 -> search329_1_0 in the cache */
static const nir_search_expression replace329 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search329_1_0.value },
   NULL,
};

   /* search330_0_0 -> search14_0 in the cache */

/* search330_0_1 -> replace14_1_0 in the cache */
/* search330_0 -> replace222 in the cache */

/* search330_1 -> search14_0 in the cache */
static const nir_search_expression search330 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &replace222.value, &search14_0.value },
   NULL,
};

   /* replace330_0 -> replace14_1_0 in the cache */

/* replace330_1 -> search14_0 in the cache */
/* replace330 -> search122_1 in the cache */

   /* search331_0 -> search2_0 in the cache */

/* search331_1_0 -> search329_1_0 in the cache */

/* search331_1_1 -> search2_0 in the cache */
static const nir_search_expression search331_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search331 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search331_1.value },
   NULL,
};

   /* replace331 -> replace197 in the cache */

   /* search332_0_0 -> search14_0 in the cache */

/* search332_0_1 -> replace14_1_0 in the cache */
/* search332_0 -> replace221 in the cache */

/* search332_1 -> search14_0 in the cache */
static const nir_search_expression search332 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &replace221.value, &search14_0.value },
   NULL,
};

   /* replace332 -> replace197 in the cache */

   /* search333_0 -> search2_0 in the cache */

/* search333_1_0 -> search329_1_0 in the cache */

/* search333_1_1 -> search2_0 in the cache */
/* search333_1 -> search331_1 in the cache */
static const nir_search_expression search333 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search2_0.value, &search331_1.value },
   NULL,
};

   /* replace333 -> replace121 in the cache */

   /* search334_0_0 -> search14_0 in the cache */

/* search334_0_1 -> replace14_1_0 in the cache */
/* search334_0 -> replace221 in the cache */

/* search334_1 -> search14_0 in the cache */
static const nir_search_expression search334 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &replace221.value, &search14_0.value },
   NULL,
};

   /* replace334 -> replace121 in the cache */

   /* search335_0 -> search2_0 in the cache */

/* search335_1_0 -> search329_1_0 in the cache */

/* search335_1_1 -> search2_0 in the cache */
/* search335_1 -> search329_1 in the cache */
static const nir_search_expression search335 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search329_1.value },
   NULL,
};

   /* replace335_0 -> search2_0 in the cache */

/* replace335_1 -> search329_1_0 in the cache */
static const nir_search_expression replace335 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search2_0.value, &search329_1_0.value },
   NULL,
};

   /* search336_0_0 -> search14_0 in the cache */

/* search336_0_1 -> replace14_1_0 in the cache */
/* search336_0 -> replace222 in the cache */

/* search336_1 -> search14_0 in the cache */
static const nir_search_expression search336 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &replace222.value, &search14_0.value },
   NULL,
};

   /* replace336_0 -> replace14_1_0 in the cache */

/* replace336_1 -> search14_0 in the cache */
/* replace336 -> replace127 in the cache */

   /* search337_0 -> search2_0 in the cache */

/* search337_1_0 -> search329_1_0 in the cache */

/* search337_1_1 -> search2_0 in the cache */
static const nir_search_expression search337_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search337 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search2_0.value, &search337_1.value },
   NULL,
};

   /* replace337_0 -> search2_0 in the cache */

/* replace337_1 -> search329_1_0 in the cache */
static const nir_search_expression replace337 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &search329_1_0.value },
   NULL,
};

   /* search338_0_0 -> search14_0 in the cache */

/* search338_0_1 -> replace14_1_0 in the cache */
/* search338_0 -> replace247 in the cache */

/* search338_1 -> search14_0 in the cache */
static const nir_search_expression search338 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace247.value, &search14_0.value },
   NULL,
};

   /* replace338_0 -> replace14_1_0 in the cache */

/* replace338_1 -> search14_0 in the cache */
/* replace338 -> search124_1 in the cache */

   /* search339_0 -> search2_0 in the cache */

/* search339_1_0 -> search329_1_0 in the cache */

/* search339_1_1 -> search2_0 in the cache */
static const nir_search_expression search339_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search339 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search2_0.value, &search339_1.value },
   NULL,
};

   /* replace339 -> replace197 in the cache */

   /* search340_0_0 -> search14_0 in the cache */

/* search340_0_1 -> replace14_1_0 in the cache */
/* search340_0 -> replace244 in the cache */

/* search340_1 -> search14_0 in the cache */
static const nir_search_expression search340 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace244.value, &search14_0.value },
   NULL,
};

   /* replace340 -> replace197 in the cache */

   /* search341_0 -> search2_0 in the cache */

/* search341_1_0 -> search329_1_0 in the cache */

/* search341_1_1 -> search2_0 in the cache */
static const nir_search_expression search341_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search341 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search341_1.value },
   NULL,
};

   /* replace341_0 -> search2_0 in the cache */

/* replace341_1 -> search329_1_0 in the cache */
static const nir_search_expression replace341 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &search329_1_0.value },
   NULL,
};

   /* search342_0_0 -> search14_0 in the cache */

/* search342_0_1 -> replace14_1_0 in the cache */
/* search342_0 -> replace246 in the cache */

/* search342_1 -> search14_0 in the cache */
static const nir_search_expression search342 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace246.value, &search14_0.value },
   NULL,
};

   /* replace342_0 -> replace14_1_0 in the cache */

/* replace342_1 -> search14_0 in the cache */
/* replace342 -> search125_1 in the cache */

   /* search343_0 -> search2_0 in the cache */

/* search343_1_0 -> search329_1_0 in the cache */

/* search343_1_1 -> search2_0 in the cache */
static const nir_search_expression search343_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search343 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search343_1.value },
   NULL,
};

   /* replace343 -> replace197 in the cache */

   /* search344_0_0 -> search14_0 in the cache */

/* search344_0_1 -> replace14_1_0 in the cache */
/* search344_0 -> replace243 in the cache */

/* search344_1 -> search14_0 in the cache */
static const nir_search_expression search344 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace243.value, &search14_0.value },
   NULL,
};

   /* replace344 -> replace197 in the cache */

   /* search345_0 -> search2_0 in the cache */

/* search345_1_0 -> search329_1_0 in the cache */

/* search345_1_1 -> search2_0 in the cache */
/* search345_1 -> search339_1 in the cache */
static const nir_search_expression search345 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search2_0.value, &search339_1.value },
   NULL,
};

   /* replace345 -> replace121 in the cache */

   /* search346_0_0 -> search14_0 in the cache */

/* search346_0_1 -> replace14_1_0 in the cache */
/* search346_0 -> replace244 in the cache */

/* search346_1 -> search14_0 in the cache */
static const nir_search_expression search346 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace244.value, &search14_0.value },
   NULL,
};

   /* replace346 -> replace121 in the cache */

   /* search347_0 -> search2_0 in the cache */

/* search347_1_0 -> search329_1_0 in the cache */

/* search347_1_1 -> search2_0 in the cache */
/* search347_1 -> search337_1 in the cache */
static const nir_search_expression search347 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search2_0.value, &search337_1.value },
   NULL,
};

   /* replace347_0 -> search2_0 in the cache */

/* replace347_1 -> search329_1_0 in the cache */
static const nir_search_expression replace347 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &search329_1_0.value },
   NULL,
};

   /* search348_0_0 -> search14_0 in the cache */

/* search348_0_1 -> replace14_1_0 in the cache */
/* search348_0 -> replace247 in the cache */

/* search348_1 -> search14_0 in the cache */
static const nir_search_expression search348 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &replace247.value, &search14_0.value },
   NULL,
};

   /* replace348_0 -> replace14_1_0 in the cache */

/* replace348_1 -> search14_0 in the cache */
static const nir_search_expression replace348 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search349_0 -> search2_0 in the cache */

/* search349_1_0 -> search329_1_0 in the cache */

/* search349_1_1 -> search2_0 in the cache */
/* search349_1 -> search343_1 in the cache */
static const nir_search_expression search349 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search343_1.value },
   NULL,
};

   /* replace349 -> replace121 in the cache */

   /* search350_0_0 -> search14_0 in the cache */

/* search350_0_1 -> replace14_1_0 in the cache */
/* search350_0 -> replace243 in the cache */

/* search350_1 -> search14_0 in the cache */
static const nir_search_expression search350 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace243.value, &search14_0.value },
   NULL,
};

   /* replace350 -> replace121 in the cache */

   /* search351_0 -> search2_0 in the cache */

/* search351_1_0 -> search329_1_0 in the cache */

/* search351_1_1 -> search2_0 in the cache */
/* search351_1 -> search341_1 in the cache */
static const nir_search_expression search351 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search341_1.value },
   NULL,
};

   /* replace351_0 -> search2_0 in the cache */

/* replace351_1 -> search329_1_0 in the cache */
static const nir_search_expression replace351 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search2_0.value, &search329_1_0.value },
   NULL,
};

   /* search352_0_0 -> search14_0 in the cache */

/* search352_0_1 -> replace14_1_0 in the cache */
/* search352_0 -> replace246 in the cache */

/* search352_1 -> search14_0 in the cache */
static const nir_search_expression search352 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &replace246.value, &search14_0.value },
   NULL,
};

   /* replace352_0 -> replace14_1_0 in the cache */

/* replace352_1 -> search14_0 in the cache */
static const nir_search_expression replace352 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace14_1_0.value, &search14_0.value },
   NULL,
};

   /* search353_0 -> search2_0 in the cache */

/* search353_1_0 -> search329_1_0 in the cache */

/* search353_1_1 -> search2_0 in the cache */
static const nir_search_expression search353_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search329_1_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression search353 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search2_0.value, &search353_1.value },
   NULL,
};

   /* replace353 -> replace121 in the cache */

   /* search354_0_0 -> search14_0 in the cache */

/* search354_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search354_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search354_1 -> search14_0 in the cache */
static const nir_search_expression search354 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search354_0.value, &search14_0.value },
   NULL,
};

   /* replace354 -> replace121 in the cache */

   /* search355_0 -> search2_0 in the cache */

/* search355_1_0 -> search329_1_0 in the cache */

/* search355_1_1 -> search2_0 in the cache */
/* search355_1 -> search353_1 in the cache */
static const nir_search_expression search355 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search2_0.value, &search353_1.value },
   NULL,
};

   /* replace355 -> replace197 in the cache */

   /* search356_0_0 -> search14_0 in the cache */

/* search356_0_1 -> replace14_1_0 in the cache */
/* search356_0 -> search354_0 in the cache */

/* search356_1 -> search14_0 in the cache */
static const nir_search_expression search356 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search354_0.value, &search14_0.value },
   NULL,
};

   /* replace356 -> replace197 in the cache */

   static const nir_search_variable search357_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search357_1_0 -> search96_0_0_1 in the cache */

/* search357_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search357_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search357 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search357_0.value, &search357_1.value },
   NULL,
};

   /* replace357_0_0 -> search28_0_0 in the cache */

/* replace357_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace357_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace357_1_0 -> search28_0_0 in the cache */

/* replace357_1_1 -> search28_1_1 in the cache */
/* replace357_1 -> search296_1 in the cache */
static const nir_search_expression replace357 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace357_0.value, &search296_1.value },
   NULL,
};

   /* search358_0_0 -> search357_0 in the cache */

/* search358_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search358_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search357_0.value, &search28_0_1.value },
   NULL,
};

/* search358_1 -> search96_0_1 in the cache */
static const nir_search_expression search358 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search358_0.value, &search96_0_1.value },
   NULL,
};

   /* replace358_0_0 -> search28_0_0 in the cache */

/* replace358_0_1 -> search28_1_1 in the cache */
/* replace358_0 -> search296_1 in the cache */

/* replace358_1_0 -> search28_0_1 in the cache */

/* replace358_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace358_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace358 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search296_1.value, &replace358_1.value },
   NULL,
};

   /* search359_0 -> search357_0 in the cache */

/* search359_1_0 -> search96_0_0_1 in the cache */

/* search359_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search359_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imin,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search359 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search357_0.value, &search359_1.value },
   NULL,
};

   /* replace359_0_0 -> search28_0_0 in the cache */

/* replace359_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace359_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace359_1_0 -> search28_0_0 in the cache */

/* replace359_1_1 -> search28_1_1 in the cache */
/* replace359_1 -> search298_1 in the cache */
static const nir_search_expression replace359 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace359_0.value, &search298_1.value },
   NULL,
};

   /* search360_0_0 -> search357_0 in the cache */

/* search360_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search360_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_imax,
   { &search357_0.value, &search28_0_1.value },
   NULL,
};

/* search360_1 -> search96_0_1 in the cache */
static const nir_search_expression search360 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search360_0.value, &search96_0_1.value },
   NULL,
};

   /* replace360_0_0 -> search28_0_0 in the cache */

/* replace360_0_1 -> search28_1_1 in the cache */
/* replace360_0 -> search298_1 in the cache */

/* replace360_1_0 -> search28_0_1 in the cache */

/* replace360_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace360_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace360 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search298_1.value, &replace360_1.value },
   NULL,
};

   /* search361_0 -> search357_0 in the cache */

/* search361_1_0 -> search96_0_0_1 in the cache */

/* search361_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search361_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search361 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search357_0.value, &search361_1.value },
   NULL,
};

   /* replace361_0_0 -> search28_0_0 in the cache */

/* replace361_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace361_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace361_1_0 -> search28_0_0 in the cache */

/* replace361_1_1 -> search28_1_1 in the cache */
/* replace361_1 -> search300_1 in the cache */
static const nir_search_expression replace361 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace361_0.value, &search300_1.value },
   NULL,
};

   /* search362_0_0 -> search357_0 in the cache */

/* search362_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search362_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search357_0.value, &search28_0_1.value },
   NULL,
};

/* search362_1 -> search96_0_1 in the cache */
static const nir_search_expression search362 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search362_0.value, &search96_0_1.value },
   NULL,
};

   /* replace362_0_0 -> search28_0_0 in the cache */

/* replace362_0_1 -> search28_1_1 in the cache */
/* replace362_0 -> search300_1 in the cache */

/* replace362_1_0 -> search28_0_1 in the cache */

/* replace362_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace362_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace362 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search300_1.value, &replace362_1.value },
   NULL,
};

   /* search363_0 -> search357_0 in the cache */

/* search363_1_0 -> search96_0_0_1 in the cache */

/* search363_1_1 -> search28_1_1 in the cache */
static const nir_search_expression search363_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umin,
   { &search96_0_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression search363 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search357_0.value, &search363_1.value },
   NULL,
};

   /* replace363_0_0 -> search28_0_0 in the cache */

/* replace363_0_1 -> search28_0_1 in the cache */
static const nir_search_expression replace363_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_0.value, &search28_0_1.value },
   NULL,
};

/* replace363_1_0 -> search28_0_0 in the cache */

/* replace363_1_1 -> search28_1_1 in the cache */
/* replace363_1 -> search302_1 in the cache */
static const nir_search_expression replace363 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace363_0.value, &search302_1.value },
   NULL,
};

   /* search364_0_0 -> search357_0 in the cache */

/* search364_0_1 -> search28_0_1 in the cache */
static const nir_search_expression search364_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 1,
   nir_op_umax,
   { &search357_0.value, &search28_0_1.value },
   NULL,
};

/* search364_1 -> search96_0_1 in the cache */
static const nir_search_expression search364 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search364_0.value, &search96_0_1.value },
   NULL,
};

   /* replace364_0_0 -> search28_0_0 in the cache */

/* replace364_0_1 -> search28_1_1 in the cache */
/* replace364_0 -> search302_1 in the cache */

/* replace364_1_0 -> search28_0_1 in the cache */

/* replace364_1_1 -> search28_1_1 in the cache */
static const nir_search_expression replace364_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search28_0_1.value, &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace364 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search302_1.value, &replace364_1.value },
   NULL,
};

   /* search365_0 -> search357_0 in the cache */

/* search365_1_0 -> search96_0_0_1 in the cache */

/* search365_1_1 -> search28_1_1 in the cache */
/* search365_1 -> search359_1 in the cache */
static const nir_search_expression search365 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search357_0.value, &search359_1.value },
   NULL,
};

   /* replace365_0_0 -> search28_0_0 in the cache */

/* replace365_0_1 -> search28_0_1 in the cache */
/* replace365_0 -> replace357_0 in the cache */

/* replace365_1_0 -> search28_0_0 in the cache */

/* replace365_1_1 -> search28_1_1 in the cache */
/* replace365_1 -> search296_1 in the cache */
static const nir_search_expression replace365 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace357_0.value, &search296_1.value },
   NULL,
};

   /* search366_0_0 -> search357_0 in the cache */

/* search366_0_1 -> search28_0_1 in the cache */
/* search366_0 -> search360_0 in the cache */

/* search366_1 -> search96_0_1 in the cache */
static const nir_search_expression search366 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search360_0.value, &search96_0_1.value },
   NULL,
};

   /* replace366_0_0 -> search28_0_0 in the cache */

/* replace366_0_1 -> search28_1_1 in the cache */
/* replace366_0 -> search296_1 in the cache */

/* replace366_1_0 -> search28_0_1 in the cache */

/* replace366_1_1 -> search28_1_1 in the cache */
/* replace366_1 -> replace358_1 in the cache */
static const nir_search_expression replace366 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search296_1.value, &replace358_1.value },
   NULL,
};

   /* search367_0 -> search357_0 in the cache */

/* search367_1_0 -> search96_0_0_1 in the cache */

/* search367_1_1 -> search28_1_1 in the cache */
/* search367_1 -> search357_1 in the cache */
static const nir_search_expression search367 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search357_0.value, &search357_1.value },
   NULL,
};

   /* replace367_0_0 -> search28_0_0 in the cache */

/* replace367_0_1 -> search28_0_1 in the cache */
/* replace367_0 -> replace359_0 in the cache */

/* replace367_1_0 -> search28_0_0 in the cache */

/* replace367_1_1 -> search28_1_1 in the cache */
/* replace367_1 -> search298_1 in the cache */
static const nir_search_expression replace367 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace359_0.value, &search298_1.value },
   NULL,
};

   /* search368_0_0 -> search357_0 in the cache */

/* search368_0_1 -> search28_0_1 in the cache */
/* search368_0 -> search358_0 in the cache */

/* search368_1 -> search96_0_1 in the cache */
static const nir_search_expression search368 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ige,
   { &search358_0.value, &search96_0_1.value },
   NULL,
};

   /* replace368_0_0 -> search28_0_0 in the cache */

/* replace368_0_1 -> search28_1_1 in the cache */
/* replace368_0 -> search298_1 in the cache */

/* replace368_1_0 -> search28_0_1 in the cache */

/* replace368_1_1 -> search28_1_1 in the cache */
/* replace368_1 -> replace360_1 in the cache */
static const nir_search_expression replace368 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search298_1.value, &replace360_1.value },
   NULL,
};

   /* search369_0 -> search357_0 in the cache */

/* search369_1_0 -> search96_0_0_1 in the cache */

/* search369_1_1 -> search28_1_1 in the cache */
/* search369_1 -> search363_1 in the cache */
static const nir_search_expression search369 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search357_0.value, &search363_1.value },
   NULL,
};

   /* replace369_0_0 -> search28_0_0 in the cache */

/* replace369_0_1 -> search28_0_1 in the cache */
/* replace369_0 -> replace361_0 in the cache */

/* replace369_1_0 -> search28_0_0 in the cache */

/* replace369_1_1 -> search28_1_1 in the cache */
/* replace369_1 -> search300_1 in the cache */
static const nir_search_expression replace369 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace361_0.value, &search300_1.value },
   NULL,
};

   /* search370_0_0 -> search357_0 in the cache */

/* search370_0_1 -> search28_0_1 in the cache */
/* search370_0 -> search364_0 in the cache */

/* search370_1 -> search96_0_1 in the cache */
static const nir_search_expression search370 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &search364_0.value, &search96_0_1.value },
   NULL,
};

   /* replace370_0_0 -> search28_0_0 in the cache */

/* replace370_0_1 -> search28_1_1 in the cache */
/* replace370_0 -> search300_1 in the cache */

/* replace370_1_0 -> search28_0_1 in the cache */

/* replace370_1_1 -> search28_1_1 in the cache */
/* replace370_1 -> replace362_1 in the cache */
static const nir_search_expression replace370 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search300_1.value, &replace362_1.value },
   NULL,
};

   /* search371_0 -> search357_0 in the cache */

/* search371_1_0 -> search96_0_0_1 in the cache */

/* search371_1_1 -> search28_1_1 in the cache */
/* search371_1 -> search361_1 in the cache */
static const nir_search_expression search371 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search357_0.value, &search361_1.value },
   NULL,
};

   /* replace371_0_0 -> search28_0_0 in the cache */

/* replace371_0_1 -> search28_0_1 in the cache */
/* replace371_0 -> replace363_0 in the cache */

/* replace371_1_0 -> search28_0_0 in the cache */

/* replace371_1_1 -> search28_1_1 in the cache */
/* replace371_1 -> search302_1 in the cache */
static const nir_search_expression replace371 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace363_0.value, &search302_1.value },
   NULL,
};

   /* search372_0_0 -> search357_0 in the cache */

/* search372_0_1 -> search28_0_1 in the cache */
/* search372_0 -> search362_0 in the cache */

/* search372_1 -> search96_0_1 in the cache */
static const nir_search_expression search372 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_uge,
   { &search362_0.value, &search96_0_1.value },
   NULL,
};

   /* replace372_0_0 -> search28_0_0 in the cache */

/* replace372_0_1 -> search28_1_1 in the cache */
/* replace372_0 -> search302_1 in the cache */

/* replace372_1_0 -> search28_0_1 in the cache */

/* replace372_1_1 -> search28_1_1 in the cache */
/* replace372_1 -> replace364_1 in the cache */
static const nir_search_expression replace372 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search302_1.value, &replace364_1.value },
   NULL,
};

   /* search373_0_0 -> search2_0 in the cache */

/* search373_0_1 -> replace9 in the cache */
/* search373_0 -> replace205 in the cache */

/* search373_1_0_0 -> search2_0 in the cache */

/* search373_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search373_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search373_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search373_1_0.value },
   NULL,
};

/* search373_2_0 -> search2_0 in the cache */

/* search373_2_1 -> replace0_1_0 in the cache */
/* search373_2 -> search373_1_0 in the cache */
static const nir_search_expression search373 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace205.value, &search373_1.value, &search373_1_0.value },
   NULL,
};

   /* replace373_0_0 -> search2_0 in the cache */

/* replace373_0_1 -> replace0_1_0 in the cache */
/* replace373_0 -> search373_1_0 in the cache */
static const nir_search_expression replace373 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search373_1_0.value },
   NULL,
};

   /* search374_0_0_0 -> search2_0 in the cache */
/* search374_0_0 -> search20_0 in the cache */

/* search374_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search374_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search20_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search374 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search374_0.value },
   NULL,
};

   /* replace374_0_0 -> search2_0 in the cache */
/* replace374_0 -> search20_0 in the cache */

/* replace374_1 -> replace0_1_0 in the cache */
/* replace374 -> search374_0 in the cache */

   /* search375_0_0 -> search0_0 in the cache */

/* search375_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search375_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_slt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search375 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search375_0.value },
   NULL,
};

   /* replace375_0 -> search0_0 in the cache */

/* replace375_1 -> replace0_1_0 in the cache */
/* replace375 -> search375_0 in the cache */

   /* search376_0_0 -> search14_0 in the cache */

/* search376_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search376_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search376 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search376_0.value },
   NULL,
};

   /* replace376_0 -> search14_0 in the cache */

/* replace376_1 -> replace14_1_0 in the cache */
/* replace376 -> search376_0 in the cache */

   /* search377_0_0 -> search0_0 in the cache */

/* search377_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search377_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search377 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search377_0.value },
   NULL,
};

   /* replace377_0 -> search0_0 in the cache */

/* replace377_1 -> replace0_1_0 in the cache */
/* replace377 -> search377_0 in the cache */

   /* search378_0_0 -> search0_0 in the cache */

/* search378_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search378_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search378 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fabs,
   { &search378_0.value },
   NULL,
};

   /* replace378_0 -> search0_0 in the cache */

/* replace378_1 -> replace0_1_0 in the cache */
/* replace378 -> search378_0 in the cache */

   /* search379_0 -> search0_0 in the cache */

/* search379_1 -> replace0_1_0 in the cache */
/* search379 -> search375_0 in the cache */

   /* replace379_0_0 -> search0_0 in the cache */

/* replace379_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace379_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace379 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace379_0.value },
   NULL,
};

   /* search380_0 -> search14_0 in the cache */

/* search380_1 -> replace14_1_0 in the cache */
/* search380 -> search376_0 in the cache */

   /* replace380_0_0 -> search14_0 in the cache */

/* replace380_0_1 -> replace14_1_0 in the cache */
/* replace380_0 -> replace111 in the cache */
static const nir_search_expression replace380 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace111.value },
   NULL,
};

   /* search381_0 -> search0_0 in the cache */

/* search381_1 -> replace0_1_0 in the cache */
/* search381 -> search377_0 in the cache */

   /* replace381_0_0 -> search0_0 in the cache */

/* replace381_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace381_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace381 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace381_0.value },
   NULL,
};

   /* search382_0 -> search0_0 in the cache */

/* search382_1 -> replace0_1_0 in the cache */
/* search382 -> search378_0 in the cache */

   /* replace382_0_0 -> search0_0 in the cache */

/* replace382_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace382_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace382 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2f,
   { &replace382_0.value },
   NULL,
};

   /* search383_0_0 -> search0_0 in the cache */

/* search383_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search383_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search383_1 -> replace60_0_0 in the cache */
static const nir_search_expression search383 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search383_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace383_0 -> search0_0 in the cache */

/* replace383_1 -> replace0_1_0 in the cache */
/* replace383 -> search377_0 in the cache */

   /* search384_0_0 -> search0_0 in the cache */

/* search384_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search384_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search384_1 -> replace60_0_0 in the cache */
static const nir_search_expression search384 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search384_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace384_0 -> search0_0 in the cache */

/* replace384_1 -> replace0_1_0 in the cache */
/* replace384 -> search378_0 in the cache */

   /* search385_0_0 -> search0_0 in the cache */

/* search385_0_1 -> replace0_1_0 in the cache */
/* search385_0 -> search375_0 in the cache */

/* search385_1 -> replace60_0_0 in the cache */
static const nir_search_expression search385 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search375_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace385_0 -> search0_0 in the cache */

/* replace385_1 -> replace0_1_0 in the cache */
/* replace385 -> search375_0 in the cache */

   /* search386_0_0 -> search0_0 in the cache */

/* search386_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search386_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_sge,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search386_1 -> replace60_0_0 in the cache */
static const nir_search_expression search386 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search386_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace386_0 -> search0_0 in the cache */

/* replace386_1 -> replace0_1_0 in the cache */
/* replace386 -> search386_0 in the cache */

   /* search387_0_0 -> search0_0 in the cache */

/* search387_0_1 -> replace0_1_0 in the cache */
/* search387_0 -> search383_0 in the cache */

/* search387_1 -> search312_0_0 in the cache */
static const nir_search_expression search387 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search383_0.value, &search312_0_0.value },
   NULL,
};

   /* replace387_0 -> search0_0 in the cache */

/* replace387_1 -> replace0_1_0 in the cache */
/* replace387 -> search377_0 in the cache */

   /* search388_0_0 -> search0_0 in the cache */

/* search388_0_1 -> replace0_1_0 in the cache */
/* search388_0 -> search384_0 in the cache */

/* search388_1 -> search312_0_0 in the cache */
static const nir_search_expression search388 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search384_0.value, &search312_0_0.value },
   NULL,
};

   /* replace388_0 -> search0_0 in the cache */

/* replace388_1 -> replace0_1_0 in the cache */
/* replace388 -> search378_0 in the cache */

   /* search389_0_0 -> search0_0 in the cache */

/* search389_0_1 -> replace0_1_0 in the cache */
/* search389_0 -> search375_0 in the cache */

/* search389_1 -> search312_0_0 in the cache */
static const nir_search_expression search389 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search375_0.value, &search312_0_0.value },
   NULL,
};

   /* replace389_0 -> search0_0 in the cache */

/* replace389_1 -> replace0_1_0 in the cache */
/* replace389 -> search375_0 in the cache */

   /* search390_0_0 -> search0_0 in the cache */

/* search390_0_1 -> replace0_1_0 in the cache */
/* search390_0 -> search386_0 in the cache */

/* search390_1 -> search312_0_0 in the cache */
static const nir_search_expression search390 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search386_0.value, &search312_0_0.value },
   NULL,
};

   /* replace390_0 -> search0_0 in the cache */

/* replace390_1 -> replace0_1_0 in the cache */
/* replace390 -> search386_0 in the cache */

   /* search391_0_0 -> search0_0 in the cache */

/* search391_0_1 -> replace0_1_0 in the cache */
/* search391_0 -> search383_0 in the cache */

/* search391_1 -> search312_0_0 in the cache */
static const nir_search_expression search391 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search383_0.value, &search312_0_0.value },
   NULL,
};

   /* replace391_0 -> search0_0 in the cache */

/* replace391_1 -> replace0_1_0 in the cache */
/* replace391 -> search378_0 in the cache */

   /* search392_0_0 -> search0_0 in the cache */

/* search392_0_1 -> replace0_1_0 in the cache */
/* search392_0 -> search384_0 in the cache */

/* search392_1 -> search312_0_0 in the cache */
static const nir_search_expression search392 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &search384_0.value, &search312_0_0.value },
   NULL,
};

   /* replace392_0 -> search0_0 in the cache */

/* replace392_1 -> replace0_1_0 in the cache */
/* replace392 -> search377_0 in the cache */

   /* search393_0_0 -> search0_0 in the cache */

/* search393_0_1 -> replace0_1_0 in the cache */
/* search393_0 -> search375_0 in the cache */

/* search393_1 -> search312_0_0 in the cache */
static const nir_search_expression search393 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search375_0.value, &search312_0_0.value },
   NULL,
};

   /* replace393_0 -> search0_0 in the cache */

/* replace393_1 -> replace0_1_0 in the cache */
/* replace393 -> search386_0 in the cache */

   /* search394_0_0 -> search0_0 in the cache */

/* search394_0_1 -> replace0_1_0 in the cache */
/* search394_0 -> search386_0 in the cache */

/* search394_1 -> search312_0_0 in the cache */
static const nir_search_expression search394 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &search386_0.value, &search312_0_0.value },
   NULL,
};

   /* replace394_0 -> search0_0 in the cache */

/* replace394_1 -> replace0_1_0 in the cache */
/* replace394 -> search375_0 in the cache */

   /* search395_0_0 -> search0_0 in the cache */

/* search395_0_1 -> replace0_1_0 in the cache */
/* search395_0 -> search383_0 in the cache */

/* search395_1 -> replace60_0_0 in the cache */
static const nir_search_expression search395 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search383_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace395_0 -> search0_0 in the cache */

/* replace395_1 -> replace0_1_0 in the cache */
/* replace395 -> search378_0 in the cache */

   /* search396_0_0 -> search0_0 in the cache */

/* search396_0_1 -> replace0_1_0 in the cache */
/* search396_0 -> search384_0 in the cache */

/* search396_1 -> replace60_0_0 in the cache */
static const nir_search_expression search396 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_sne,
   { &search384_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace396_0 -> search0_0 in the cache */

/* replace396_1 -> replace0_1_0 in the cache */
/* replace396 -> search377_0 in the cache */

   /* search397_0_0 -> search0_0 in the cache */

/* search397_0_1 -> replace0_1_0 in the cache */
/* search397_0 -> search375_0 in the cache */

/* search397_1 -> replace60_0_0 in the cache */
static const nir_search_expression search397 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search375_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace397_0 -> search0_0 in the cache */

/* replace397_1 -> replace0_1_0 in the cache */
/* replace397 -> search386_0 in the cache */

   /* search398_0_0 -> search0_0 in the cache */

/* search398_0_1 -> replace0_1_0 in the cache */
/* search398_0 -> search386_0 in the cache */

/* search398_1 -> replace60_0_0 in the cache */
static const nir_search_expression search398 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &search386_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace398_0 -> search0_0 in the cache */

/* replace398_1 -> replace0_1_0 in the cache */
/* replace398 -> search375_0 in the cache */

   /* search399_0 -> search0_0 in the cache */

/* search399_1 -> replace0_1_0 in the cache */
static const nir_search_expression search399 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   static const nir_search_variable replace399_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0},
};

static const nir_search_variable replace399_0_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0},
};
static const nir_search_expression replace399_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_seq,
   { &replace399_0_0.value, &replace399_0_1.value },
   NULL,
};

static const nir_search_variable replace399_1_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_invalid,
   NULL,
   {1},
};

static const nir_search_variable replace399_1_1 = {
   { nir_search_value_variable, 32 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {1},
};
static const nir_search_expression replace399_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_seq,
   { &replace399_1_0.value, &replace399_1_1.value },
   NULL,
};
static const nir_search_expression replace399 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmin,
   { &replace399_0.value, &replace399_1.value },
   NULL,
};

   /* search400_0 -> search0_0 in the cache */

/* search400_1 -> replace0_1_0 in the cache */
static const nir_search_expression search400 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace400_0_0 -> search0_0 in the cache */

/* replace400_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace400_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace400_1 -> search312_0_0 in the cache */
static const nir_search_expression replace400 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace400_0.value, &search312_0_0.value },
   NULL,
};

   /* search401_0 -> search0_0 in the cache */

/* search401_1 -> replace0_1_0 in the cache */
static const nir_search_expression search401 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fall_equal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace401_0_0 -> search0_0 in the cache */

/* replace401_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace401_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_fany_nequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace401_1 -> search312_0_0 in the cache */
static const nir_search_expression replace401 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_seq,
   { &replace401_0.value, &search312_0_0.value },
   NULL,
};

   /* search402_0 -> search0_0 in the cache */

/* search402_1 -> replace0_1_0 in the cache */
static const nir_search_expression search402 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal2,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace402_0_0 -> replace399_0_0 in the cache */

/* replace402_0_1 -> replace399_0_1 in the cache */
static const nir_search_expression replace402_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_sne,
   { &replace399_0_0.value, &replace399_0_1.value },
   NULL,
};

/* replace402_1_0 -> replace399_1_0 in the cache */

/* replace402_1_1 -> replace399_1_1 in the cache */
static const nir_search_expression replace402_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_sne,
   { &replace399_1_0.value, &replace399_1_1.value },
   NULL,
};
static const nir_search_expression replace402 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fmax,
   { &replace402_0.value, &replace402_1.value },
   NULL,
};

   /* search403_0 -> search0_0 in the cache */

/* search403_1 -> replace0_1_0 in the cache */
static const nir_search_expression search403 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal3,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace403_0_0_0 -> search0_0 in the cache */

/* replace403_0_0_1 -> replace0_1_0 in the cache */
/* replace403_0_0 -> search378_0 in the cache */

/* replace403_0_1_0 -> search0_0 in the cache */

/* replace403_0_1_1 -> replace0_1_0 in the cache */
/* replace403_0_1 -> search384_0 in the cache */
static const nir_search_expression replace403_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot3,
   { &search378_0.value, &search384_0.value },
   NULL,
};
static const nir_search_expression replace403 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace403_0.value },
   NULL,
};

   /* search404_0 -> search0_0 in the cache */

/* search404_1 -> replace0_1_0 in the cache */
static const nir_search_expression search404 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fany_nequal4,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace404_0_0_0 -> search0_0 in the cache */

/* replace404_0_0_1 -> replace0_1_0 in the cache */
/* replace404_0_0 -> search378_0 in the cache */

/* replace404_0_1_0 -> search0_0 in the cache */

/* replace404_0_1_1 -> replace0_1_0 in the cache */
/* replace404_0_1 -> search384_0 in the cache */
static const nir_search_expression replace404_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fdot4,
   { &search378_0.value, &search384_0.value },
   NULL,
};
static const nir_search_expression replace404 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_fsat,
   { &replace404_0.value },
   NULL,
};

   /* search405_0_0 -> search2_0 in the cache */
/* search405_0 -> search15_0 in the cache */

/* search405_1 -> search2_0 in the cache */
static const nir_search_expression search405 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search15_0.value, &search2_0.value },
   NULL,
};

   /* replace405_0 -> search2_0 in the cache */

/* replace405_1 -> search24_1 in the cache */
/* replace405 -> replace207 in the cache */

   /* search406_0_0 -> search2_0 in the cache */
/* search406_0 -> search15_0 in the cache */

/* search406_1 -> search2_0 in the cache */
static const nir_search_expression search406 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search15_0.value, &search2_0.value },
   NULL,
};

   /* replace406_0 -> search2_0 in the cache */

/* replace406_1 -> search24_1 in the cache */
/* replace406 -> replace209 in the cache */

   /* search407_0_0 -> replace80_0 in the cache */
/* search407_0 -> search193_0 in the cache */

/* search407_1_0 -> search148_0_1_0 in the cache */
static const nir_search_expression search407_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search148_0_1_0.value },
   NULL,
};
static const nir_search_expression search407 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search193_0.value, &search407_1.value },
   NULL,
};

   /* replace407_0_0 -> replace80_0 in the cache */

/* replace407_0_1 -> search148_0_1_0 in the cache */
/* replace407_0 -> replace152 in the cache */
static const nir_search_expression replace407 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace152.value },
   NULL,
};

   /* search408_0_0 -> replace80_0 in the cache */
/* search408_0 -> search146_1 in the cache */

/* search408_1_0 -> search148_0_1_0 in the cache */
/* search408_1 -> search148_0_1 in the cache */
static const nir_search_expression search408 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search146_1.value, &search148_0_1.value },
   NULL,
};

   /* replace408_0_0 -> replace80_0 in the cache */

/* replace408_0_1 -> search148_0_1_0 in the cache */
/* replace408_0 -> replace152 in the cache */
/* replace408 -> replace215 in the cache */

   /* search409_0_0_0 -> replace80_0 in the cache */
/* search409_0_0 -> search146_1 in the cache */

/* search409_0_1_0 -> search148_0_1_0 in the cache */
/* search409_0_1 -> search148_0_1 in the cache */
/* search409_0 -> search168_0_0 in the cache */
static const nir_search_expression search409 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_fsat,
   { &search168_0_0.value },
   NULL,
};

   /* replace409_0_0 -> replace80_0 in the cache */

/* replace409_0_1 -> search148_0_1_0 in the cache */
/* replace409_0 -> replace148 in the cache */
/* replace409 -> replace213 in the cache */

   static const nir_search_variable search410_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   false,
   nir_type_bool,
   NULL,
   {0, 1, 2, 3},
};

/* search410_1 -> replace60_0_0 in the cache */
static const nir_search_expression search410 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search410_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace410_0 -> search0_0 in the cache */
static const nir_search_expression replace410 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search0_0.value },
   NULL,
};

   /* search411_0_0 -> search0_0 in the cache */
static const nir_search_expression search411_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_b2i32,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search411 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search411_0.value },
   NULL,
};

   /* replace411 -> search0_0 in the cache */

   /* search412_0_0_0 -> replace80_0 in the cache */
/* search412_0_0 -> search146_1 in the cache */
/* search412_0 -> search147_0 in the cache */

/* search412_1 -> search193_1 in the cache */
static const nir_search_expression search412 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search147_0.value, &search193_1.value },
   NULL,
};

   /* replace412 -> replace80_0 in the cache */

   /* search413_0_0 -> search146_0 in the cache */

/* search413_0_1_0 -> replace80_0 in the cache */
/* search413_0_1 -> search146_1 in the cache */
static const nir_search_expression search413_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search146_0.value, &search146_1.value },
   NULL,
};

/* search413_1 -> search193_1 in the cache */
static const nir_search_expression search413 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search413_0.value, &search193_1.value },
   NULL,
};

   /* replace413 -> replace80_0 in the cache */

   /* search414_0 -> search2_0 in the cache */

/* search414_1 -> search2_0 in the cache */
static const nir_search_expression search414 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace414 -> replace121 in the cache */

   /* search415_0 -> search2_0 in the cache */

/* search415_1 -> search2_0 in the cache */
static const nir_search_expression search415 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace415 -> replace197 in the cache */

   /* search416_0 -> search2_0 in the cache */

/* search416_1 -> search2_0 in the cache */
static const nir_search_expression search416 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ieq,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace416 -> replace197 in the cache */

   /* search417_0 -> search2_0 in the cache */

/* search417_1 -> search2_0 in the cache */
static const nir_search_expression search417 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ine,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace417 -> replace121 in the cache */

   /* search418_0 -> search2_0 in the cache */

/* search418_1 -> search2_0 in the cache */
static const nir_search_expression search418 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace418 -> replace121 in the cache */

   /* search419_0 -> search2_0 in the cache */

/* search419_1 -> search2_0 in the cache */
static const nir_search_expression search419 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace419 -> replace197 in the cache */

   /* search420_0 -> search2_0 in the cache */

/* search420_1 -> search2_0 in the cache */
static const nir_search_expression search420 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iand,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace420 -> search2_0 in the cache */

   /* search421_0 -> search2_0 in the cache */

/* search421_1 -> search44_1 in the cache */
static const nir_search_expression search421 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &search44_1.value },
   NULL,
};

   /* replace421 -> search2_0 in the cache */

   /* search422_0 -> search2_0 in the cache */

/* search422_1 -> replace9 in the cache */
static const nir_search_expression search422 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace422 -> replace9 in the cache */

   /* search423_0 -> search2_0 in the cache */

/* search423_1 -> search2_0 in the cache */
static const nir_search_expression search423 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ior,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace423 -> search2_0 in the cache */

   /* search424_0 -> search2_0 in the cache */

/* search424_1 -> replace9 in the cache */
static const nir_search_expression search424 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace424 -> search2_0 in the cache */

   /* search425_0 -> replace80_0 in the cache */

/* search425_1 -> replace197 in the cache */
static const nir_search_expression search425 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace80_0.value, &replace197.value },
   NULL,
};

   /* replace425 -> replace197 in the cache */

   /* search426_0 -> search2_0 in the cache */

/* search426_1 -> search2_0 in the cache */
static const nir_search_expression search426 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ixor,
   { &search2_0.value, &search2_0.value },
   NULL,
};

   /* replace426 -> replace9 in the cache */

   /* search427_0 -> search2_0 in the cache */

/* search427_1 -> replace9 in the cache */
static const nir_search_expression search427 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_ixor,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* replace427 -> search2_0 in the cache */

   /* search428_0_0 -> search2_0 in the cache */
/* search428_0 -> search325_1 in the cache */
static const nir_search_expression search428 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search325_1.value },
   NULL,
};

   /* replace428 -> search2_0 in the cache */

   /* search429_0_0 -> search14_0 in the cache */

/* search429_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search429_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search429_1 -> replace14_1_0 in the cache */
static const nir_search_expression search429 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search429_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace429 -> replace14_1_0 in the cache */

   /* search430_0_0 -> search14_0 in the cache */

/* search430_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search430_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ior,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* search430_1 -> replace14_1_0 in the cache */
static const nir_search_expression search430 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search430_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace430_0 -> search14_0 in the cache */

/* replace430_1 -> replace14_1_0 in the cache */
/* replace430 -> search354_0 in the cache */

   /* search431_0_0 -> search14_0 in the cache */

/* search431_0_1 -> replace14_1_0 in the cache */
/* search431_0 -> search430_0 in the cache */

/* search431_1 -> replace14_1_0 in the cache */
static const nir_search_expression search431 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search430_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace431 -> replace14_1_0 in the cache */

   /* search432_0_0 -> search14_0 in the cache */

/* search432_0_1 -> replace14_1_0 in the cache */
/* search432_0 -> search429_0 in the cache */

/* search432_1 -> replace14_1_0 in the cache */
static const nir_search_expression search432 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search429_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace432_0 -> search14_0 in the cache */

/* replace432_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace432 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search433_0_0 -> search14_0 in the cache */
static const nir_search_expression search433_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search14_0.value },
   NULL,
};

/* search433_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression search433_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search433 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search433_0.value, &search433_1.value },
   NULL,
};

   /* replace433_0_0 -> search14_0 in the cache */

/* replace433_0_1 -> replace14_1_0 in the cache */
/* replace433_0 -> search354_0 in the cache */
static const nir_search_expression replace433 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search354_0.value },
   NULL,
};

   /* search434_0_0 -> search14_0 in the cache */
/* search434_0 -> search433_0 in the cache */

/* search434_1_0 -> replace14_1_0 in the cache */
/* search434_1 -> search433_1 in the cache */
static const nir_search_expression search434 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search433_0.value, &search433_1.value },
   NULL,
};

   /* replace434_0_0 -> search14_0 in the cache */

/* replace434_0_1 -> replace14_1_0 in the cache */
/* replace434_0 -> replace432 in the cache */
static const nir_search_expression replace434 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &replace432.value },
   NULL,
};

   /* search435_0 -> search193_1 in the cache */

/* search435_1 -> search0_0 in the cache */
static const nir_search_expression search435 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search193_1.value, &search0_0.value },
   NULL,
};

   /* replace435 -> search193_1 in the cache */

   /* search436_0 -> search2_0 in the cache */

/* search436_1 -> search26_1 in the cache */
static const nir_search_expression search436 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search2_0.value, &search26_1.value },
   NULL,
};

   /* replace436 -> search2_0 in the cache */

   /* search437_0 -> search193_1 in the cache */

/* search437_1 -> search0_0 in the cache */
static const nir_search_expression search437 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search193_1.value, &search0_0.value },
   NULL,
};

   /* replace437 -> search193_1 in the cache */

   /* search438_0 -> search2_0 in the cache */

/* search438_1 -> search26_1 in the cache */
static const nir_search_expression search438 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search2_0.value, &search26_1.value },
   NULL,
};

   /* replace438 -> search2_0 in the cache */

   /* search439_0 -> search193_1 in the cache */

/* search439_1 -> search0_0 in the cache */
static const nir_search_expression search439 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search193_1.value, &search0_0.value },
   NULL,
};

   /* replace439 -> search193_1 in the cache */

   /* search440_0 -> search2_0 in the cache */

/* search440_1 -> search26_1 in the cache */
static const nir_search_expression search440 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search2_0.value, &search26_1.value },
   NULL,
};

   /* replace440 -> search2_0 in the cache */

   /* search441_0 -> replace98_0_0_0_1 in the cache */

/* search441_1_0 -> search0_0 in the cache */

static const nir_search_constant search441_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x18 /* 24 */ },
};
static const nir_search_expression search441_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search441_1_1.value },
   NULL,
};
static const nir_search_expression search441 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace98_0_0_0_1.value, &search441_1.value },
   NULL,
};

   /* replace441_0 -> search0_0 in the cache */

/* replace441_1 -> search441_1_1 in the cache */
/* replace441 -> search441_1 in the cache */

   /* search442_0 -> replace101_0_0_0_1 in the cache */

/* search442_1_0 -> search0_0 in the cache */

/* search442_1_1 -> replace101_0_1 in the cache */
static const nir_search_expression search442_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace101_0_1.value },
   NULL,
};
static const nir_search_expression search442 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace101_0_0_0_1.value, &search442_1.value },
   NULL,
};

   /* replace442_0 -> search0_0 in the cache */

/* replace442_1 -> replace101_0_1 in the cache */
/* replace442 -> search442_1 in the cache */

   /* search443_0_0 -> search101_0_0 in the cache */

/* search443_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search443_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

/* search443_1_0 -> search101_0_0 in the cache */

/* search443_1_1_0 -> replace101_0_1 in the cache */

/* search443_1_1_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search443_1_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search443_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace101_0_1.value, &search443_1_1_1.value },
   NULL,
};
static const nir_search_expression search443_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search101_0_0.value, &search443_1_1.value },
   NULL,
};
static const nir_search_expression search443 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search443_0.value, &search443_1.value },
   NULL,
};

   /* replace443_0 -> search101_0_0 in the cache */

/* replace443_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace443 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search444_0_0 -> search101_0_0 in the cache */

/* search444_0_1 -> replace0_1_0 in the cache */
/* search444_0 -> search443_0 in the cache */

/* search444_1_0 -> search101_0_0 in the cache */

/* search444_1_1_0 -> replace101_0_1 in the cache */

/* search444_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search444_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace101_0_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search444_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &search444_1_1.value },
   NULL,
};
static const nir_search_expression search444 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search443_0.value, &search444_1.value },
   NULL,
};

   /* replace444_0 -> search101_0_0 in the cache */

/* replace444_1 -> replace0_1_0 in the cache */
/* replace444 -> replace443 in the cache */

   /* search445_0_0 -> search0_0 in the cache */

/* search445_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search445_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search445_1_0 -> search0_0 in the cache */

/* search445_1_1_0 -> replace104_0_1 in the cache */

/* search445_1_1_1_0 -> replace0_1_0 in the cache */
/* search445_1_1_1 -> search443_1_1_1 in the cache */
static const nir_search_expression search445_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &replace104_0_1.value, &search443_1_1_1.value },
   NULL,
};
static const nir_search_expression search445_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &search445_1_1.value },
   NULL,
};
static const nir_search_expression search445 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search445_0.value, &search445_1.value },
   NULL,
};

   /* replace445_0 -> search0_0 in the cache */

/* replace445_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace445 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_urol,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search446_0_0 -> search0_0 in the cache */

/* search446_0_1 -> replace0_1_0 in the cache */
/* search446_0 -> search445_0 in the cache */

/* search446_1_0 -> search0_0 in the cache */

/* search446_1_1_0 -> replace104_0_1 in the cache */

/* search446_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search446_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace104_0_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search446_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &search446_1_1.value },
   NULL,
};
static const nir_search_expression search446 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search445_0.value, &search446_1.value },
   NULL,
};

   /* replace446_0 -> search0_0 in the cache */

/* replace446_1 -> replace0_1_0 in the cache */
/* replace446 -> replace445 in the cache */

   /* search447_0_0 -> search101_0_0 in the cache */

/* search447_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search447_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

/* search447_1_0 -> search101_0_0 in the cache */

/* search447_1_1_0 -> replace101_0_1 in the cache */

/* search447_1_1_1_0 -> replace0_1_0 in the cache */
/* search447_1_1_1 -> search443_1_1_1 in the cache */
/* search447_1_1 -> search443_1_1 in the cache */
static const nir_search_expression search447_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search101_0_0.value, &search443_1_1.value },
   NULL,
};
static const nir_search_expression search447 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search447_0.value, &search447_1.value },
   NULL,
};

   /* replace447_0 -> search101_0_0 in the cache */

/* replace447_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace447 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search101_0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search448_0_0 -> search101_0_0 in the cache */

/* search448_0_1 -> replace0_1_0 in the cache */
/* search448_0 -> search447_0 in the cache */

/* search448_1_0 -> search101_0_0 in the cache */

/* search448_1_1_0 -> replace101_0_1 in the cache */

/* search448_1_1_1 -> replace0_1_0 in the cache */
/* search448_1_1 -> search444_1_1 in the cache */
static const nir_search_expression search448_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &search444_1_1.value },
   NULL,
};
static const nir_search_expression search448 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search447_0.value, &search448_1.value },
   NULL,
};

   /* replace448_0 -> search101_0_0 in the cache */

/* replace448_1 -> replace0_1_0 in the cache */
/* replace448 -> replace447 in the cache */

   /* search449_0_0 -> search0_0 in the cache */

/* search449_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search449_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* search449_1_0 -> search0_0 in the cache */

/* search449_1_1_0 -> replace104_0_1 in the cache */

/* search449_1_1_1_0 -> replace0_1_0 in the cache */
/* search449_1_1_1 -> search443_1_1_1 in the cache */
/* search449_1_1 -> search445_1_1 in the cache */
static const nir_search_expression search449_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &search445_1_1.value },
   NULL,
};
static const nir_search_expression search449 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search449_0.value, &search449_1.value },
   NULL,
};

   /* replace449_0 -> search0_0 in the cache */

/* replace449_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace449 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_uror,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search450_0_0 -> search0_0 in the cache */

/* search450_0_1 -> replace0_1_0 in the cache */
/* search450_0 -> search449_0 in the cache */

/* search450_1_0 -> search0_0 in the cache */

/* search450_1_1_0 -> replace104_0_1 in the cache */

/* search450_1_1_1 -> replace0_1_0 in the cache */
/* search450_1_1 -> search446_1_1 in the cache */
static const nir_search_expression search450_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search446_1_1.value },
   NULL,
};
static const nir_search_expression search450 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search449_0.value, &search450_1.value },
   NULL,
};

   /* replace450_0 -> search0_0 in the cache */

/* replace450_1 -> replace0_1_0 in the cache */
/* replace450 -> replace449 in the cache */

   /* search451_0 -> search101_0_0 in the cache */

/* search451_1 -> replace0_1_0 in the cache */
/* search451 -> replace443 in the cache */

   /* replace451_0_0 -> search101_0_0 in the cache */

/* replace451_0_1 -> replace0_1_0 in the cache */
/* replace451_0 -> search443_0 in the cache */

/* replace451_1_0 -> search101_0_0 in the cache */

/* replace451_1_1_0 -> replace101_0_1 in the cache */

/* replace451_1_1_1 -> replace0_1_0 in the cache */
/* replace451_1_1 -> search444_1_1 in the cache */
/* replace451_1 -> search444_1 in the cache */
/* replace451 -> search444 in the cache */

   /* search452_0 -> search0_0 in the cache */

/* search452_1 -> replace0_1_0 in the cache */
/* search452 -> replace445 in the cache */

   /* replace452_0_0 -> search0_0 in the cache */

/* replace452_0_1 -> replace0_1_0 in the cache */
/* replace452_0 -> search445_0 in the cache */

/* replace452_1_0 -> search0_0 in the cache */

/* replace452_1_1_0 -> replace104_0_1 in the cache */

/* replace452_1_1_1 -> replace0_1_0 in the cache */
/* replace452_1_1 -> search446_1_1 in the cache */
/* replace452_1 -> search446_1 in the cache */
/* replace452 -> search446 in the cache */

   /* search453_0 -> search101_0_0 in the cache */

/* search453_1 -> replace0_1_0 in the cache */
/* search453 -> replace447 in the cache */

   /* replace453_0_0 -> search101_0_0 in the cache */

/* replace453_0_1 -> replace0_1_0 in the cache */
/* replace453_0 -> search447_0 in the cache */

/* replace453_1_0 -> search101_0_0 in the cache */

/* replace453_1_1_0 -> replace101_0_1 in the cache */

/* replace453_1_1_1 -> replace0_1_0 in the cache */
/* replace453_1_1 -> search444_1_1 in the cache */
/* replace453_1 -> search448_1 in the cache */
/* replace453 -> search448 in the cache */

   /* search454_0 -> search0_0 in the cache */

/* search454_1 -> replace0_1_0 in the cache */
/* search454 -> replace449 in the cache */

   /* replace454_0_0 -> search0_0 in the cache */

/* replace454_0_1 -> replace0_1_0 in the cache */
/* replace454_0 -> search449_0 in the cache */

/* replace454_1_0 -> search0_0 in the cache */

/* replace454_1_1_0 -> replace104_0_1 in the cache */

/* replace454_1_1_1 -> replace0_1_0 in the cache */
/* replace454_1_1 -> search446_1_1 in the cache */
/* replace454_1 -> search450_1 in the cache */
/* replace454 -> search450 in the cache */

   /* search455_0_0 -> search2_0 in the cache */
static const nir_search_expression search455_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search455 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fexp2,
   { &search455_0.value },
   NULL,
};

   /* replace455 -> search2_0 in the cache */

   /* search456_0_0 -> search2_0 in the cache */
static const nir_search_expression search456_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search456 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search456_0.value },
   NULL,
};

   /* replace456 -> search2_0 in the cache */

   /* search457_0 -> search14_0 in the cache */

/* search457_1 -> replace14_1_0 in the cache */
static const nir_search_expression search457 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace457_0_0_0 -> search14_0 in the cache */
static const nir_search_expression replace457_0_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search14_0.value },
   NULL,
};

/* replace457_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace457_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace457_0_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace457 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace457_0.value },
   NULL,
};

   /* search458_0_0_0 -> search14_0 in the cache */
/* search458_0_0 -> replace457_0_0 in the cache */

/* search458_0_1 -> replace14_1_0 in the cache */
/* search458_0 -> replace457_0 in the cache */
static const nir_search_expression search458 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &replace457_0.value },
   NULL,
};

   /* replace458_0 -> search14_0 in the cache */

/* replace458_1 -> replace14_1_0 in the cache */
/* replace458 -> search457 in the cache */

   /* search459_0_0_0_0 -> search62_0_0 in the cache */
static const nir_search_expression search459_0_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search62_0_0.value },
   NULL,
};

/* search459_0_0_1 -> search62_0_1 in the cache */
static const nir_search_expression search459_0_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search459_0_0_0.value, &search62_0_1.value },
   NULL,
};

/* search459_0_1_0_0 -> search62_1_1 in the cache */
static const nir_search_expression search459_0_1_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_flog2,
   { &search62_1_1.value },
   NULL,
};

/* search459_0_1_1 -> search62_2 in the cache */
static const nir_search_expression search459_0_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   2, 1,
   nir_op_fmul,
   { &search459_0_1_0.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search459_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   0, 3,
   nir_op_fadd,
   { &search459_0_0.value, &search459_0_1.value },
   NULL,
};
static const nir_search_expression search459 = {
   { nir_search_value_expression, -4 },
   true, false,
   -1, 3,
   nir_op_fexp2,
   { &search459_0.value },
   NULL,
};

   /* replace459_0_0 -> search62_0_0 in the cache */

/* replace459_0_1 -> search62_0_1 in the cache */
static const nir_search_expression replace459_0 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search62_0_0.value, &search62_0_1.value },
   NULL,
};

/* replace459_1_0 -> search62_1_1 in the cache */

/* replace459_1_1 -> search62_2 in the cache */
static const nir_search_expression replace459_1 = {
   { nir_search_value_expression, -4 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression replace459 = {
   { nir_search_value_expression, -4 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &replace459_0.value, &replace459_1.value },
   NULL,
};

   /* search460_0_0_0 -> search2_0 in the cache */
/* search460_0_0 -> search455_0 in the cache */

static const nir_search_constant search460_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4000000000000000 /* 2.0 */ },
};
static const nir_search_expression search460_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search455_0.value, &search460_0_1.value },
   NULL,
};
static const nir_search_expression search460 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search460_0.value },
   NULL,
};

   /* replace460_0 -> search2_0 in the cache */

/* replace460_1 -> search2_0 in the cache */
/* replace460 -> search45_1 in the cache */

   /* search461_0_0_0 -> search2_0 in the cache */
/* search461_0_0 -> search455_0 in the cache */

static const nir_search_constant search461_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x4010000000000000 /* 4.0 */ },
};
static const nir_search_expression search461_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search455_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression search461 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 1,
   nir_op_fexp2,
   { &search461_0.value },
   NULL,
};

   /* replace461_0_0 -> search2_0 in the cache */

/* replace461_0_1 -> search2_0 in the cache */
/* replace461_0 -> search45_1 in the cache */

/* replace461_1_0 -> search2_0 in the cache */

/* replace461_1_1 -> search2_0 in the cache */
/* replace461_1 -> search45_1 in the cache */
static const nir_search_expression replace461 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search45_1.value, &search45_1.value },
   NULL,
};

   /* search462_0 -> search2_0 in the cache */

/* search462_1 -> search41_1 in the cache */
static const nir_search_expression search462 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search41_1.value },
   NULL,
};

   /* replace462 -> search2_0 in the cache */

   /* search463_0 -> search2_0 in the cache */

/* search463_1 -> search460_0_1 in the cache */
static const nir_search_expression search463 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search460_0_1.value },
   NULL,
};

   /* replace463_0 -> search2_0 in the cache */

/* replace463_1 -> search2_0 in the cache */
/* replace463 -> search45_1 in the cache */

   /* search464_0 -> search2_0 in the cache */

/* search464_1 -> search461_0_1 in the cache */
static const nir_search_expression search464 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search461_0_1.value },
   NULL,
};

   /* replace464_0_0 -> search2_0 in the cache */

/* replace464_0_1 -> search2_0 in the cache */
/* replace464_0 -> search45_1 in the cache */

/* replace464_1_0 -> search2_0 in the cache */

/* replace464_1_1 -> search2_0 in the cache */
/* replace464_1 -> search45_1 in the cache */
/* replace464 -> replace461 in the cache */

   /* search465_0 -> search460_0_1 in the cache */

/* search465_1 -> search2_0 in the cache */
static const nir_search_expression search465 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search460_0_1.value, &search2_0.value },
   NULL,
};

   /* replace465_0 -> search2_0 in the cache */
/* replace465 -> search456_0 in the cache */

   /* search466_0_0 -> search2_0 in the cache */

static const nir_search_constant search466_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x400199999999999a /* 2.2 */ },
};
static const nir_search_expression search466_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fpow,
   { &search2_0.value, &search466_0_1.value },
   NULL,
};

static const nir_search_constant search466_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
};
static const nir_search_expression search466 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search466_0.value, &search466_1.value },
   NULL,
};

   /* replace466 -> search2_0 in the cache */

   /* search467_0_0_0 -> search2_0 in the cache */

/* search467_0_0_1 -> search466_0_1 in the cache */
/* search467_0_0 -> search466_0 in the cache */
static const nir_search_expression search467_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search466_0.value },
   NULL,
};

/* search467_1 -> search466_1 in the cache */
static const nir_search_expression search467 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fpow,
   { &search467_0.value, &search466_1.value },
   NULL,
};

   /* replace467_0 -> search2_0 in the cache */
/* replace467 -> search17_0 in the cache */

   /* search468_0_0 -> search2_0 in the cache */
/* search468_0 -> search456_0 in the cache */
static const nir_search_expression search468 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fsqrt,
   { &search456_0.value },
   NULL,
};

   static const nir_search_constant replace468_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
};

/* replace468_0_1 -> search2_0 in the cache */
static const nir_search_expression replace468_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace468_0_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace468 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace468_0.value },
   NULL,
};

   /* search469_0_0 -> search2_0 in the cache */
/* search469_0 -> search456_0 in the cache */
static const nir_search_expression search469 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search456_0.value },
   NULL,
};

   /* replace469_0_0 -> search2_0 in the cache */
/* replace469_0 -> search15_0 in the cache */
static const nir_search_expression replace469 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search15_0.value },
   NULL,
};

   /* search470_0_0 -> search2_0 in the cache */
/* search470_0 -> search456_0 in the cache */
static const nir_search_expression search470 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frsq,
   { &search456_0.value },
   NULL,
};

   static const nir_search_constant replace470_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0xbfe0000000000000L /* -0.5 */ },
};

/* replace470_0_1 -> search2_0 in the cache */
static const nir_search_expression replace470_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace470_0_0.value, &search2_0.value },
   NULL,
};
static const nir_search_expression replace470 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace470_0.value },
   NULL,
};

   /* search471_0_0 -> search2_0 in the cache */
static const nir_search_expression search471_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsqrt,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search471 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search471_0.value },
   NULL,
};

   /* replace471_0 -> replace468_0_0 in the cache */

/* replace471_1_0 -> search2_0 in the cache */
/* replace471_1 -> search455_0 in the cache */
static const nir_search_expression replace471 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace468_0_0.value, &search455_0.value },
   NULL,
};

   /* search472_0_0 -> search2_0 in the cache */
static const nir_search_expression search472_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search472 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search472_0.value },
   NULL,
};

   /* replace472_0_0 -> search2_0 in the cache */
/* replace472_0 -> search455_0 in the cache */
static const nir_search_expression replace472 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search455_0.value },
   NULL,
};

   /* search473_0_0 -> search2_0 in the cache */
static const nir_search_expression search473_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frsq,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search473 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search473_0.value },
   NULL,
};

   /* replace473_0 -> replace470_0_0 in the cache */

/* replace473_1_0 -> search2_0 in the cache */
/* replace473_1 -> search455_0 in the cache */
static const nir_search_expression replace473 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace470_0_0.value, &search455_0.value },
   NULL,
};

   /* search474_0_0 -> search14_0 in the cache */

/* search474_0_1 -> replace14_1_0 in the cache */
/* search474_0 -> search457 in the cache */
static const nir_search_expression search474 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_flog2,
   { &search457.value },
   NULL,
};

   /* replace474_0 -> replace14_1_0 in the cache */

/* replace474_1_0 -> search14_0 in the cache */
/* replace474_1 -> replace457_0_0 in the cache */
static const nir_search_expression replace474 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace14_1_0.value, &replace457_0_0.value },
   NULL,
};

   /* search475_0_0 -> search14_0 in the cache */
static const nir_search_expression search475_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &search14_0.value },
   (is_used_once),
};

/* search475_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression search475_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fexp2,
   { &replace14_1_0.value },
   (is_used_once),
};
static const nir_search_expression search475 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fmul,
   { &search475_0.value, &search475_1.value },
   NULL,
};

   /* replace475_0_0 -> search14_0 in the cache */

/* replace475_0_1 -> replace14_1_0 in the cache */
/* replace475_0 -> replace49 in the cache */
static const nir_search_expression replace475 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fexp2,
   { &replace49.value },
   NULL,
};

   /* search476_0_0 -> search2_0 in the cache */

/* search476_0_1 -> search24_1 in the cache */
/* search476_0 -> replace65_0 in the cache */

/* search476_1 -> search24_1 in the cache */

/* search476_2_0 -> search2_0 in the cache */
/* search476_2 -> search471_0 in the cache */
static const nir_search_expression search476 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace65_0.value, &search24_1.value, &search471_0.value },
   NULL,
};

   /* replace476_0_0 -> search2_0 in the cache */

/* replace476_0_1 -> search24_1 in the cache */
/* replace476_0 -> search263_0 in the cache */
static const nir_search_expression replace476 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsqrt,
   { &search263_0.value },
   NULL,
};

   /* search477_0 -> search41_1 in the cache */

/* search477_1 -> search2_0 in the cache */
static const nir_search_expression search477 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fdiv,
   { &search41_1.value, &search2_0.value },
   NULL,
};

   /* replace477_0 -> search2_0 in the cache */
/* replace477 -> search472_0 in the cache */

   /* search478_0 -> search14_0 in the cache */

/* search478_1 -> replace14_1_0 in the cache */
static const nir_search_expression search478 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace478_0 -> search14_0 in the cache */

/* replace478_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression replace478_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace478 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search14_0.value, &replace478_1.value },
   NULL,
};

   /* search479_0_0 -> search2_0 in the cache */
/* search479_0 -> search472_0 in the cache */
static const nir_search_expression search479 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search472_0.value },
   NULL,
};

   /* replace479 -> search2_0 in the cache */

   /* search480_0_0 -> search2_0 in the cache */
/* search480_0 -> search471_0 in the cache */
static const nir_search_expression search480 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search471_0.value },
   NULL,
};

   /* replace480_0 -> search2_0 in the cache */
/* replace480 -> search473_0 in the cache */

   /* search481_0 -> search2_0 in the cache */
/* search481 -> search471_0 in the cache */

   /* replace481_0_0 -> search2_0 in the cache */
/* replace481_0 -> search473_0 in the cache */
static const nir_search_expression replace481 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_frcp,
   { &search473_0.value },
   NULL,
};

   /* search482_0_0 -> search2_0 in the cache */
/* search482_0 -> search473_0 in the cache */
static const nir_search_expression search482 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_frcp,
   { &search473_0.value },
   NULL,
};

   /* replace482_0 -> search2_0 in the cache */
/* replace482 -> search471_0 in the cache */

   /* search483_0 -> search2_0 in the cache */
static const nir_search_expression search483 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsin,
   { &search2_0.value },
   NULL,
};

   /* replace483_0_0_0_0_0_0 -> search460_0_1 in the cache */

static const nir_search_constant replace483_0_0_0_0_0_1_0_0_0 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fc45f306dc9c883 /* 0.159154943092 */ },
};

/* replace483_0_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   5, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_0_0_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace483_0_0_0_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_0_0_0_0_1.value },
   NULL,
};

/* replace483_0_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_0_0_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_0_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   9, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_0_0_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace483_0_0_0_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace483_0_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_0_0_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_0_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   12, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_0_0_1_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace483_0_0_0_1_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace483_0_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace483_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace483_0_0_0_1_0.value, &replace483_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace483_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace483_0_0_0_0.value, &replace483_0_0_0_1.value },
   NULL,
};

/* replace483_0_0_1 -> search461_0_1 in the cache */
static const nir_search_expression replace483_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace483_0_0_0.value, &search461_0_1.value },
   NULL,
};

/* replace483_0_1_0_0_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_1_0_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_1_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_1_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   16, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_1_0_0_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace483_0_1_0_0_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace483_0_1_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_1_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_0_1_0_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_1_0_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_1_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_1_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   20, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_1_0_0_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace483_0_1_0_0_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace483_0_1_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_1_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_0_1_0_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_1_0_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_1_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_1_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   23, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_1_0_0_1_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace483_0_1_0_0_1_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace483_0_1_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_1_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace483_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace483_0_1_0_0_1_0.value, &replace483_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace483_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace483_0_1_0_0_0.value, &replace483_0_1_0_0_1.value },
   NULL,
};

/* replace483_0_1_0_1 -> search461_0_1 in the cache */
static const nir_search_expression replace483_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace483_0_1_0_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression replace483_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace483_0_1_0.value },
   NULL,
};

/* replace483_0_2_0_0_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_2_0_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_2_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_2_0_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   27, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_2_0_0_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace483_0_2_0_0_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace483_0_2_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_2_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_0_2_0_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_2_0_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_2_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_2_0_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   31, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_2_0_0_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace483_0_2_0_0_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace483_0_2_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_2_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_0_2_0_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_0_2_0_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_0_2_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_0_2_0_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   34, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_0_2_0_0_1_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace483_0_2_0_0_1_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace483_0_2_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_0_2_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace483_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace483_0_2_0_0_1_0.value, &replace483_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace483_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace483_0_2_0_0_0.value, &replace483_0_2_0_0_1.value },
   NULL,
};

/* replace483_0_2_0_1 -> search461_0_1 in the cache */
static const nir_search_expression replace483_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace483_0_2_0_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression replace483_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace483_0_2_0.value },
   NULL,
};
static const nir_search_expression replace483_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace483_0_0.value, &replace483_0_1.value, &replace483_0_2.value },
   NULL,
};

static const nir_search_constant replace483_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
};

/* replace483_2_0_0_0_0 -> search460_0_1 in the cache */

/* replace483_2_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_2_0_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_2_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   38, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_2_0_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace483_2_0_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_2_0_0_0_1.value },
   NULL,
};

/* replace483_2_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_2_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_2_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_2_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_2_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_2_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   42, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_2_0_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace483_2_0_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_2_0_1_0_0_1.value },
   NULL,
};

/* replace483_2_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_2_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace483_2_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace483_2_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace483_2_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
static const nir_search_expression replace483_2_0_1_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   45, 1,
   nir_op_fmul,
   { &replace483_0_0_0_0_0_1_0_0_0.value, &search2_0.value },
   NULL,
};

/* replace483_2_0_1_1_0_0_1_0_1 -> replace468_0_0 in the cache */
static const nir_search_expression replace483_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace483_2_0_1_1_0_0_1_0_0.value, &replace468_0_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace483_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace483_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace483_2_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace483_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace483_2_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace483_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace483_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace483_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace483_2_0_1_0.value, &replace483_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace483_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace483_2_0_0.value, &replace483_2_0_1.value },
   NULL,
};

/* replace483_2_1 -> search461_0_1 in the cache */
static const nir_search_expression replace483_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace483_2_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression replace483 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace483_0.value, &replace483_1.value, &replace483_2.value },
   NULL,
};

   /* search484_0 -> search2_0 in the cache */
static const nir_search_expression search484 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fcos,
   { &search2_0.value },
   NULL,
};

   /* replace484_0_0_0_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_0_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_0_0_0_0_1_0_0 -> replace483_0_0_0_0_0_1_0_0 in the cache */

static const nir_search_constant replace484_0_0_0_0_0_1_0_1 = {
   { nir_search_value_constant, -1 },
   nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
};
static const nir_search_expression replace484_0_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   4, 2,
   nir_op_fadd,
   { &replace483_0_0_0_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   3, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_0_0_0_0_1.value },
   NULL,
};

/* replace484_0_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_0_0_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_0_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_0_0_1_0_0_1_0_0 -> replace483_0_0_0_1_0_0_1_0_0 in the cache */

/* replace484_0_0_0_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   8, 2,
   nir_op_fadd,
   { &replace483_0_0_0_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   7, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_0_0_1_0_0_1.value },
   NULL,
};

/* replace484_0_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_0_0_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_0_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_0_0_1_1_0_0_1_0_0 -> replace483_0_0_0_1_1_0_0_1_0_0 in the cache */

/* replace484_0_0_0_1_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   11, 2,
   nir_op_fadd,
   { &replace483_0_0_0_1_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   10, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace484_0_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace484_0_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   6, 7,
   nir_op_fmul,
   { &replace484_0_0_0_1_0.value, &replace484_0_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace484_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace484_0_0_0_0.value, &replace484_0_0_0_1.value },
   NULL,
};

/* replace484_0_0_1 -> search461_0_1 in the cache */
static const nir_search_expression replace484_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   2, 11,
   nir_op_fmul,
   { &replace484_0_0_0.value, &search461_0_1.value },
   NULL,
};

/* replace484_0_1_0_0_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_1_0_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_1_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_1_0_0_0_0_1_0_0 -> replace483_0_1_0_0_0_0_1_0_0 in the cache */

/* replace484_0_1_0_0_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_1_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   15, 2,
   nir_op_fadd,
   { &replace483_0_1_0_0_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_1_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   14, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace484_0_1_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_1_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_1_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_0_1_0_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_1_0_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_1_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_1_0_0_1_0_0_1_0_0 -> replace483_0_1_0_0_1_0_0_1_0_0 in the cache */

/* replace484_0_1_0_0_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_1_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   19, 2,
   nir_op_fadd,
   { &replace483_0_1_0_0_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_1_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   18, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_1_0_0_1_0_0_1.value },
   NULL,
};

/* replace484_0_1_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_1_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_0_1_0_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_1_0_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_1_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_1_0_0_1_1_0_0_1_0_0 -> replace483_0_1_0_0_1_1_0_0_1_0_0 in the cache */

/* replace484_0_1_0_0_1_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_1_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   22, 2,
   nir_op_fadd,
   { &replace483_0_1_0_0_1_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_1_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   21, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_1_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace484_0_1_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_1_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_1_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace484_0_1_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   17, 7,
   nir_op_fmul,
   { &replace484_0_1_0_0_1_0.value, &replace484_0_1_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace484_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace484_0_1_0_0_0.value, &replace484_0_1_0_0_1.value },
   NULL,
};

/* replace484_0_1_0_1 -> search461_0_1 in the cache */
static const nir_search_expression replace484_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   13, 11,
   nir_op_fmul,
   { &replace484_0_1_0_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fabs,
   { &replace484_0_1_0.value },
   NULL,
};

/* replace484_0_2_0_0_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_2_0_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_2_0_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_2_0_0_0_0_1_0_0 -> replace483_0_2_0_0_0_0_1_0_0 in the cache */

/* replace484_0_2_0_0_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_2_0_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   26, 2,
   nir_op_fadd,
   { &replace483_0_2_0_0_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_2_0_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   25, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_2_0_0_0_0_1.value },
   NULL,
};

/* replace484_0_2_0_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_2_0_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_0_2_0_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_2_0_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_2_0_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_2_0_0_1_0_0_1_0_0 -> replace483_0_2_0_0_1_0_0_1_0_0 in the cache */

/* replace484_0_2_0_0_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_2_0_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   30, 2,
   nir_op_fadd,
   { &replace483_0_2_0_0_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_2_0_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   29, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_2_0_0_1_0_0_1.value },
   NULL,
};

/* replace484_0_2_0_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_2_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_2_0_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_0_2_0_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_0_2_0_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_0_2_0_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_0_2_0_0_1_1_0_0_1_0_0 -> replace483_0_2_0_0_1_1_0_0_1_0_0 in the cache */

/* replace484_0_2_0_0_1_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_0_2_0_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   33, 2,
   nir_op_fadd,
   { &replace483_0_2_0_0_1_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_0_2_0_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   32, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_0_2_0_0_1_1_0_0_1.value },
   NULL,
};

/* replace484_0_2_0_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_0_2_0_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_0_2_0_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace484_0_2_0_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   28, 7,
   nir_op_fmul,
   { &replace484_0_2_0_0_1_0.value, &replace484_0_2_0_0_1_1.value },
   NULL,
};
static const nir_search_expression replace484_0_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace484_0_2_0_0_0.value, &replace484_0_2_0_0_1.value },
   NULL,
};

/* replace484_0_2_0_1 -> search461_0_1 in the cache */
static const nir_search_expression replace484_0_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   24, 11,
   nir_op_fmul,
   { &replace484_0_2_0_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression replace484_0_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 11,
   nir_op_fneg,
   { &replace484_0_2_0.value },
   NULL,
};
static const nir_search_expression replace484_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 34,
   nir_op_ffma,
   { &replace484_0_0.value, &replace484_0_1.value, &replace484_0_2.value },
   NULL,
};

/* replace484_1 -> replace483_1 in the cache */

/* replace484_2_0_0_0_0 -> search460_0_1 in the cache */

/* replace484_2_0_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_2_0_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_2_0_0_0_1_0_0 -> replace483_2_0_0_0_1_0_0 in the cache */

/* replace484_2_0_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_2_0_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   37, 2,
   nir_op_fadd,
   { &replace483_2_0_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_2_0_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_2_0_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_2_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   36, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_2_0_0_0_1.value },
   NULL,
};

/* replace484_2_0_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_2_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_2_0_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_2_0_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_2_0_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_2_0_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_2_0_1_0_0_1_0_0 -> replace483_2_0_1_0_0_1_0_0 in the cache */

/* replace484_2_0_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_2_0_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   41, 2,
   nir_op_fadd,
   { &replace483_2_0_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_2_0_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_2_0_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_2_0_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   40, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_2_0_1_0_0_1.value },
   NULL,
};

/* replace484_2_0_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_2_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_2_0_1_0_0.value, &search41_1.value },
   NULL,
};

/* replace484_2_0_1_1_0_0_0 -> search460_0_1 in the cache */

/* replace484_2_0_1_1_0_0_1_0_0_0 -> replace483_0_0_0_0_0_1_0_0_0 in the cache */

/* replace484_2_0_1_1_0_0_1_0_0_1 -> search2_0 in the cache */
/* replace484_2_0_1_1_0_0_1_0_0 -> replace483_2_0_1_1_0_0_1_0_0 in the cache */

/* replace484_2_0_1_1_0_0_1_0_1 -> replace484_0_0_0_0_0_1_0_1 in the cache */
static const nir_search_expression replace484_2_0_1_1_0_0_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   44, 2,
   nir_op_fadd,
   { &replace483_2_0_1_1_0_0_1_0_0.value, &replace484_0_0_0_0_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace484_2_0_1_1_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_ffract,
   { &replace484_2_0_1_1_0_0_1_0.value },
   NULL,
};
static const nir_search_expression replace484_2_0_1_1_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   43, 3,
   nir_op_fmul,
   { &search460_0_1.value, &replace484_2_0_1_1_0_0_1.value },
   NULL,
};

/* replace484_2_0_1_1_0_1 -> search41_1 in the cache */
static const nir_search_expression replace484_2_0_1_1_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fsub,
   { &replace484_2_0_1_1_0_0.value, &search41_1.value },
   NULL,
};
static const nir_search_expression replace484_2_0_1_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 3,
   nir_op_fabs,
   { &replace484_2_0_1_1_0.value },
   NULL,
};
static const nir_search_expression replace484_2_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   39, 7,
   nir_op_fmul,
   { &replace484_2_0_1_0.value, &replace484_2_0_1_1.value },
   NULL,
};
static const nir_search_expression replace484_2_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 10,
   nir_op_fsub,
   { &replace484_2_0_0.value, &replace484_2_0_1.value },
   NULL,
};

/* replace484_2_1 -> search461_0_1 in the cache */
static const nir_search_expression replace484_2 = {
   { nir_search_value_expression, -1 },
   false, false,
   35, 11,
   nir_op_fmul,
   { &replace484_2_0.value, &search461_0_1.value },
   NULL,
};
static const nir_search_expression replace484 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 46,
   nir_op_ffma,
   { &replace484_0.value, &replace483_1.value, &replace484_2.value },
   NULL,
};

   /* search485_0 -> search2_0 in the cache */
static const nir_search_expression search485 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace485_0 -> search2_0 in the cache */

/* replace485_1 -> replace9 in the cache */
static const nir_search_expression replace485 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_ine32,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search486_0 -> search2_0 in the cache */
static const nir_search_expression search486 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2b1,
   { &search2_0.value },
   (is_used_by_if),
};

   /* replace486_0 -> search2_0 in the cache */

/* replace486_1 -> replace9 in the cache */
/* replace486 -> replace195 in the cache */

   /* search487_0 -> replace80_0 in the cache */

/* search487_1 -> replace197 in the cache */
static const nir_search_expression search487 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace80_0.value, &replace197.value },
   NULL,
};

   /* replace487 -> replace80_0 in the cache */

   /* search488_0 -> replace80_0 in the cache */

/* search488_1 -> replace197 in the cache */
static const nir_search_expression search488 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace80_0.value, &replace197.value },
   (is_not_used_by_if),
};

   /* replace488_0 -> replace80_0 in the cache */
/* replace488 -> replace146 in the cache */

   /* search489_0 -> replace80_0 in the cache */

/* search489_1 -> replace121 in the cache */
static const nir_search_expression search489 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace80_0.value, &replace121.value },
   NULL,
};

   /* replace489 -> replace80_0 in the cache */

   /* search490_0 -> replace80_0 in the cache */

/* search490_1 -> replace121 in the cache */
static const nir_search_expression search490 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace80_0.value, &replace121.value },
   (is_not_used_by_if),
};

   /* replace490_0 -> replace80_0 in the cache */
/* replace490 -> replace146 in the cache */

   /* search491_0 -> replace80_0 in the cache */

/* search491_1 -> replace197 in the cache */

/* search491_2 -> replace121 in the cache */
static const nir_search_expression search491 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace197.value, &replace121.value },
   NULL,
};

   /* replace491 -> replace80_0 in the cache */

   /* search492_0 -> replace80_0 in the cache */

/* search492_1 -> replace121 in the cache */

/* search492_2 -> replace197 in the cache */
static const nir_search_expression search492 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace121.value, &replace197.value },
   NULL,
};

   /* replace492_0 -> replace80_0 in the cache */
/* replace492 -> replace146 in the cache */

   /* search493_0 -> replace80_0 in the cache */

/* search493_1 -> replace60_0_0 in the cache */

/* search493_2 -> search312_0_0 in the cache */
static const nir_search_expression search493 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace60_0_0.value, &search312_0_0.value },
   NULL,
};

   /* replace493_0 -> replace80_0 in the cache */
static const nir_search_expression replace493 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace80_0.value },
   NULL,
};

   /* search494_0 -> replace80_0 in the cache */

/* search494_1 -> search312_0_0 in the cache */

/* search494_2 -> replace60_0_0 in the cache */
static const nir_search_expression search494 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search312_0_0.value, &replace60_0_0.value },
   NULL,
};

   /* replace494_0_0 -> replace80_0 in the cache */
/* replace494_0 -> replace146 in the cache */
static const nir_search_expression replace494 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace146.value },
   NULL,
};

   /* search495_0 -> replace80_0 in the cache */

static const nir_search_constant search495_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0xbff0000000000000L /* -1.0 */ },
};

static const nir_search_constant search495_2 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x8000000000000000L /* -0.0 */ },
};
static const nir_search_expression search495 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search495_1.value, &search495_2.value },
   NULL,
};

   /* replace495_0_0 -> replace80_0 in the cache */
/* replace495_0 -> replace493 in the cache */
static const nir_search_expression replace495 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace493.value },
   NULL,
};

   /* search496_0 -> replace80_0 in the cache */

/* search496_1 -> search495_2 in the cache */

/* search496_2 -> search495_1 in the cache */
static const nir_search_expression search496 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search495_2.value, &search495_1.value },
   NULL,
};

   /* replace496_0_0_0 -> replace80_0 in the cache */
/* replace496_0_0 -> replace146 in the cache */
/* replace496_0 -> replace494 in the cache */
static const nir_search_expression replace496 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &replace494.value },
   NULL,
};

   /* search497_0 -> replace197 in the cache */

/* search497_1 -> replace137_0 in the cache */

/* search497_2 -> search64_2 in the cache */
static const nir_search_expression search497 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace197.value, &replace137_0.value, &search64_2.value },
   NULL,
};

   /* replace497 -> replace137_0 in the cache */

   /* search498_0 -> replace121 in the cache */

/* search498_1 -> replace137_0 in the cache */

/* search498_2 -> search64_2 in the cache */
static const nir_search_expression search498 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace121.value, &replace137_0.value, &search64_2.value },
   NULL,
};

   /* replace498 -> search64_2 in the cache */

   /* search499_0 -> replace80_0 in the cache */

/* search499_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search499_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace0_1_0.value },
   (is_used_once),
};

/* search499_2_0 -> search56_2 in the cache */
static const nir_search_expression search499_2 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search56_2.value },
   NULL,
};
static const nir_search_expression search499 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search499_1.value, &search499_2.value },
   NULL,
};

   /* replace499_0_0 -> replace80_0 in the cache */

/* replace499_0_1 -> replace0_1_0 in the cache */

/* replace499_0_2 -> search56_2 in the cache */
static const nir_search_expression replace499_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace0_1_0.value, &search56_2.value },
   NULL,
};
static const nir_search_expression replace499 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace499_0.value },
   NULL,
};

   /* search500_0 -> replace80_0 in the cache */

/* search500_1 -> replace14_1_0 in the cache */

/* search500_2 -> replace14_1_0 in the cache */
static const nir_search_expression search500 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &replace14_1_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace500 -> replace14_1_0 in the cache */

   /* search501_0 -> search0_0 in the cache */

/* search501_1 -> replace0_1_0 in the cache */

/* search501_2 -> replace0_1_0 in the cache */
static const nir_search_expression search501 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fcsel,
   { &search0_0.value, &replace0_1_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace501 -> replace0_1_0 in the cache */

   /* search502_0 -> replace80_0 in the cache */

static const nir_search_constant search502_1 = {
   { nir_search_value_constant, 0 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* search502_2 -> search193_1 in the cache */
static const nir_search_expression search502 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search502_1.value, &search193_1.value },
   NULL,
};

   /* replace502_0_0 -> replace80_0 in the cache */
/* replace502_0 -> search193_0 in the cache */
static const nir_search_expression replace502 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search193_0.value },
   NULL,
};

   /* search503_0 -> replace80_0 in the cache */

/* search503_1 -> search193_1 in the cache */

/* search503_2 -> search502_1 in the cache */
static const nir_search_expression search503 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace80_0.value, &search193_1.value, &search502_1.value },
   NULL,
};

   /* replace503_0_0_0 -> replace80_0 in the cache */
/* replace503_0_0 -> replace146 in the cache */
static const nir_search_expression replace503_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace146.value },
   NULL,
};
static const nir_search_expression replace503 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace503_0.value },
   NULL,
};

   /* search504_0_0_0 -> replace80_0 in the cache */
/* search504_0_0 -> search193_0 in the cache */
/* search504_0 -> replace502 in the cache */

/* search504_1_0_0 -> search148_0_1_0 in the cache */
/* search504_1_0 -> search407_1 in the cache */
static const nir_search_expression search504_1 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search407_1.value },
   NULL,
};
static const nir_search_expression search504 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace502.value, &search504_1.value },
   NULL,
};

   /* replace504_0_0_0 -> replace80_0 in the cache */

/* replace504_0_0_1 -> search148_0_1_0 in the cache */
/* replace504_0_0 -> replace152 in the cache */
/* replace504_0 -> replace407 in the cache */
static const nir_search_expression replace504 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace407.value },
   NULL,
};

   /* search505_0_0_0 -> replace80_0 in the cache */
/* search505_0_0 -> search193_0 in the cache */
/* search505_0 -> replace502 in the cache */

/* search505_1_0_0 -> search148_0_1_0 in the cache */
/* search505_1_0 -> search407_1 in the cache */
/* search505_1 -> search504_1 in the cache */
static const nir_search_expression search505 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace502.value, &search504_1.value },
   NULL,
};

   /* replace505_0_0_0 -> replace80_0 in the cache */

/* replace505_0_0_1 -> search148_0_1_0 in the cache */
/* replace505_0_0 -> replace148 in the cache */
static const nir_search_expression replace505_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace148.value },
   NULL,
};
static const nir_search_expression replace505 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace505_0.value },
   NULL,
};

   /* search506_0_0_0 -> replace80_0 in the cache */
/* search506_0_0 -> search193_0 in the cache */
/* search506_0 -> replace502 in the cache */

/* search506_1 -> search193_1 in the cache */
static const nir_search_expression search506 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace502.value, &search193_1.value },
   NULL,
};

   /* replace506_0 -> replace80_0 in the cache */
/* replace506 -> replace146 in the cache */

   /* search507_0_0_0 -> replace80_0 in the cache */
/* search507_0_0 -> search193_0 in the cache */
/* search507_0 -> replace502 in the cache */

/* search507_1 -> search502_1 in the cache */
static const nir_search_expression search507 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace502.value, &search502_1.value },
   NULL,
};

   /* replace507 -> replace80_0 in the cache */

   /* search508_0_0_0 -> replace80_0 in the cache */
/* search508_0_0 -> search193_0 in the cache */
/* search508_0 -> replace502 in the cache */

/* search508_1 -> search193_1 in the cache */
static const nir_search_expression search508 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace502.value, &search193_1.value },
   NULL,
};

   /* replace508 -> replace80_0 in the cache */

   /* search509_0_0_0 -> replace80_0 in the cache */
/* search509_0_0 -> search193_0 in the cache */
/* search509_0 -> replace502 in the cache */

/* search509_1 -> search502_1 in the cache */
static const nir_search_expression search509 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace502.value, &search502_1.value },
   NULL,
};

   /* replace509_0 -> replace80_0 in the cache */
/* replace509 -> replace146 in the cache */

   /* search510_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search510_0_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search510_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search510_0_0.value },
   NULL,
};

/* search510_1 -> search150_0_1 in the cache */
static const nir_search_expression search510 = {
   { nir_search_value_expression, 0 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search510_0.value, &search150_0_1.value },
   NULL,
};

   /* replace510_0 -> search2_0 in the cache */
/* replace510 -> search268_0 in the cache */

   /* search511_0 -> search0_0 in the cache */

/* search511_1_0 -> replace106_1_1 in the cache */

/* search511_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression search511_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search511 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &search511_1.value },
   NULL,
};

   /* replace511_0 -> search0_0 in the cache */

/* replace511_1 -> replace0_1_0 in the cache */
/* replace511 -> search445_0 in the cache */

   /* search512_0 -> search0_0 in the cache */

/* search512_1_0 -> replace106_1_1 in the cache */

/* search512_1_1 -> replace0_1_0 in the cache */
/* search512_1 -> search511_1 in the cache */
static const nir_search_expression search512 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &search0_0.value, &search511_1.value },
   NULL,
};

   /* replace512_0 -> search0_0 in the cache */

/* replace512_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace512 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* search513_0 -> search0_0 in the cache */

/* search513_1_0 -> replace106_1_1 in the cache */

/* search513_1_1 -> replace0_1_0 in the cache */
/* search513_1 -> search511_1 in the cache */
static const nir_search_expression search513 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &search511_1.value },
   NULL,
};

   /* replace513_0 -> search0_0 in the cache */

/* replace513_1 -> replace0_1_0 in the cache */
/* replace513 -> search449_0 in the cache */

   /* search514_0_0 -> search0_0 in the cache */
static const nir_search_expression search514_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search514 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2b32,
   { &search514_0.value },
   NULL,
};

   /* replace514 -> search0_0 in the cache */

   /* search515_0_0 -> search2_0 in the cache */
/* search515_0 -> search65 in the cache */
static const nir_search_expression search515 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search65.value },
   NULL,
};

   /* replace515_0 -> search2_0 in the cache */
static const nir_search_expression replace515 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search2_0.value },
   NULL,
};

   /* search516_0_0 -> search2_0 in the cache */
/* search516_0 -> search65 in the cache */
static const nir_search_expression search516 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search65.value },
   NULL,
};

   /* replace516_0 -> search2_0 in the cache */
static const nir_search_expression replace516 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search2_0.value },
   NULL,
};

   /* search517_0_0 -> search2_0 in the cache */
/* search517_0 -> search16_0 in the cache */
/* search517 -> search23 in the cache */

   /* replace517_0 -> search2_0 in the cache */
/* replace517 -> replace23 in the cache */

   /* search518_0_0 -> search2_0 in the cache */
/* search518_0 -> search20_0 in the cache */
static const nir_search_expression search518 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2b,
   { &search20_0.value },
   NULL,
};

   /* replace518_0 -> search2_0 in the cache */
/* replace518 -> replace23 in the cache */

   /* search519_0_0 -> search2_0 in the cache */
static const nir_search_expression search519_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_f2b1,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search519 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search519_0.value },
   NULL,
};

   /* replace519_0 -> search2_0 in the cache */

/* replace519_1 -> search24_1 in the cache */
/* replace519 -> replace209 in the cache */

   /* search520_0_0 -> search0_0 in the cache */
static const nir_search_expression search520_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search520 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search520_0.value },
   NULL,
};

   /* replace520 -> search0_0 in the cache */

   /* search521_0_0 -> search0_0 in the cache */
static const nir_search_expression search521_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search521 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2i32,
   { &search521_0.value },
   NULL,
};

   /* replace521 -> search0_0 in the cache */

   /* search522_0_0 -> search0_0 in the cache */
/* search522_0 -> search520_0 in the cache */
static const nir_search_expression search522 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search520_0.value },
   NULL,
};

   /* replace522 -> search0_0 in the cache */

   /* search523_0_0 -> search0_0 in the cache */
/* search523_0 -> search521_0 in the cache */
static const nir_search_expression search523 = {
   { nir_search_value_expression, 32 },
   true, false,
   -1, 0,
   nir_op_f2u32,
   { &search521_0.value },
   NULL,
};

   /* replace523 -> search0_0 in the cache */

   static const nir_search_variable search524_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_integral),
   {0, 1, 2, 3},
};
static const nir_search_expression search524 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &search524_0.value },
   NULL,
};

   /* replace524 -> search2_0 in the cache */

   /* search525_0 -> search524_0 in the cache */
static const nir_search_expression search525 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fceil,
   { &search524_0.value },
   NULL,
};

   /* replace525 -> search2_0 in the cache */

   /* search526_0 -> search524_0 in the cache */
static const nir_search_expression search526 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search524_0.value },
   NULL,
};

   /* replace526 -> search2_0 in the cache */

   /* search527_0 -> search524_0 in the cache */
static const nir_search_expression search527 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_ffract,
   { &search524_0.value },
   NULL,
};

   /* replace527 -> search24_1 in the cache */

   static const nir_search_variable search528_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};
static const nir_search_expression search528 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &search528_0.value },
   NULL,
};

   /* replace528 -> search2_0 in the cache */

   /* search529_0 -> search528_0 in the cache */
static const nir_search_expression search529 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &search528_0.value },
   NULL,
};

   /* replace529 -> search2_0 in the cache */

   static const nir_search_variable search530_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};
static const nir_search_expression search530 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search530_0.value },
   NULL,
};

   /* replace530 -> search24_1 in the cache */

   /* search531_0_0 -> search2_0 in the cache */
static const nir_search_expression search531_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search2_0.value },
   NULL,
};

/* search531_1 -> replace14_1_0 in the cache */
static const nir_search_expression search531 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search531_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace531_0_0 -> search2_0 in the cache */
static const nir_search_expression replace531_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search2_0.value },
   NULL,
};

/* replace531_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace531 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace531_0.value, &replace14_1_0.value },
   NULL,
};

   static const nir_search_variable search532_0 = {
   { nir_search_value_variable, -1 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search532_1_0 -> search137_1_0 in the cache */
static const nir_search_expression search532_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search137_1_0.value },
   NULL,
};
static const nir_search_expression search532 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search532_0.value, &search532_1.value },
   NULL,
};

   /* replace532_0 -> search532_0 in the cache */

/* replace532_1_0 -> search137_1_0 in the cache */
static const nir_search_expression replace532_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search137_1_0.value },
   NULL,
};
static const nir_search_expression replace532 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search532_0.value, &replace532_1.value },
   NULL,
};

   /* search533_0_0 -> search2_0 in the cache */
/* search533_0 -> search531_0 in the cache */

/* search533_1 -> replace14_1_0 in the cache */
static const nir_search_expression search533 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search531_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace533_0_0 -> search2_0 in the cache */
/* replace533_0 -> replace531_0 in the cache */

/* replace533_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace533 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace531_0.value, &replace14_1_0.value },
   NULL,
};

   /* search534_0 -> search532_0 in the cache */

/* search534_1_0 -> search137_1_0 in the cache */
/* search534_1 -> search532_1 in the cache */
static const nir_search_expression search534 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search532_0.value, &search532_1.value },
   NULL,
};

   /* replace534_0 -> search532_0 in the cache */

/* replace534_1_0 -> search137_1_0 in the cache */
/* replace534_1 -> replace532_1 in the cache */
static const nir_search_expression replace534 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search532_0.value, &replace532_1.value },
   NULL,
};

   /* search535_0 -> search528_0 in the cache */

/* search535_1 -> search41_1 in the cache */
static const nir_search_expression search535 = {
   { nir_search_value_expression, -1 },
   true, false,
   -1, 0,
   nir_op_fmin,
   { &search528_0.value, &search41_1.value },
   NULL,
};

   /* replace535_0 -> search2_0 in the cache */
/* replace535 -> search36_0 in the cache */

   /* search536_0_0_0_0 -> search2_0 in the cache */
/* search536_0_0_0 -> search36_0 in the cache */

/* search536_0_0_1_0_0 -> search2_0 in the cache */
/* search536_0_0_1_0 -> search36_0 in the cache */
static const nir_search_expression search536_0_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search36_0.value },
   NULL,
};
static const nir_search_expression search536_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search36_0.value, &search536_0_0_1.value },
   NULL,
};

/* search536_0_1 -> search41_1 in the cache */
static const nir_search_expression search536_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &search536_0_0.value, &search41_1.value },
   NULL,
};

/* search536_1 -> search24_1 in the cache */
static const nir_search_expression search536 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_flt,
   { &search536_0.value, &search24_1.value },
   NULL,
};

   /* replace536 -> replace121 in the cache */

   /* search537_0_0_0_0_0 -> search2_0 in the cache */
/* search537_0_0_0_0 -> search36_0 in the cache */

/* search537_0_0_0_1_0 -> search2_0 in the cache */
/* search537_0_0_0_1 -> search36_0 in the cache */
static const nir_search_expression search537_0_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fmul,
   { &search36_0.value, &search36_0.value },
   NULL,
};
static const nir_search_expression search537_0_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search537_0_0_0.value },
   NULL,
};

/* search537_0_1 -> search41_1 in the cache */
static const nir_search_expression search537_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search537_0_0.value, &search41_1.value },
   NULL,
};

/* search537_1 -> search24_1 in the cache */
static const nir_search_expression search537 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_flt,
   { &search537_0.value, &search24_1.value },
   NULL,
};

   /* replace537 -> replace121 in the cache */

   /* search538_0_0_0_0 -> search2_0 in the cache */
/* search538_0_0_0 -> search36_0 in the cache */

/* search538_0_0_1_0_0 -> search2_0 in the cache */
/* search538_0_0_1_0 -> search36_0 in the cache */
/* search538_0_0_1 -> search536_0_0_1 in the cache */
/* search538_0_0 -> search536_0_0 in the cache */

/* search538_0_1 -> search41_1 in the cache */
/* search538_0 -> search536_0 in the cache */

/* search538_1 -> search24_1 in the cache */
static const nir_search_expression search538 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 2,
   nir_op_fmax,
   { &search536_0.value, &search24_1.value },
   NULL,
};

   /* replace538_0_0_0 -> search2_0 in the cache */
/* replace538_0_0 -> search36_0 in the cache */

/* replace538_0_1_0_0 -> search2_0 in the cache */
/* replace538_0_1_0 -> search36_0 in the cache */
/* replace538_0_1 -> search536_0_0_1 in the cache */
/* replace538_0 -> search536_0_0 in the cache */

/* replace538_1 -> search41_1 in the cache */
/* replace538 -> search536_0 in the cache */

   /* search539_0_0_0_0_0 -> search2_0 in the cache */
/* search539_0_0_0_0 -> search36_0 in the cache */

/* search539_0_0_0_1_0 -> search2_0 in the cache */
/* search539_0_0_0_1 -> search36_0 in the cache */
/* search539_0_0_0 -> search537_0_0_0 in the cache */
/* search539_0_0 -> search537_0_0 in the cache */

/* search539_0_1 -> search41_1 in the cache */
/* search539_0 -> search537_0 in the cache */

/* search539_1 -> search24_1 in the cache */
static const nir_search_expression search539 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 1,
   nir_op_fmax,
   { &search537_0.value, &search24_1.value },
   NULL,
};

   /* replace539_0_0_0_0 -> search2_0 in the cache */
/* replace539_0_0_0 -> search36_0 in the cache */

/* replace539_0_0_1_0 -> search2_0 in the cache */
/* replace539_0_0_1 -> search36_0 in the cache */
/* replace539_0_0 -> search537_0_0_0 in the cache */
/* replace539_0 -> search537_0_0 in the cache */

/* replace539_1 -> search41_1 in the cache */
/* replace539 -> search537_0 in the cache */

   static const nir_search_variable search540_0 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_zero),
   {0, 1, 2, 3},
};

/* search540_1 -> search24_1 in the cache */
static const nir_search_expression search540 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search540_0.value, &search24_1.value },
   NULL,
};

   /* replace540 -> replace197 in the cache */

   /* search541_0 -> search540_0 in the cache */

/* search541_1 -> search24_1 in the cache */
static const nir_search_expression search541 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search540_0.value, &search24_1.value },
   NULL,
};

   /* replace541 -> replace121 in the cache */

   static const nir_search_variable search542_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};

static const nir_search_variable search542_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};
static const nir_search_expression search542 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search542_0.value, &search542_1.value },
   NULL,
};

   /* replace542 -> replace197 in the cache */

   static const nir_search_variable search543_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};

static const nir_search_variable search543_1 = {
   { nir_search_value_variable, -2 },
   1, /* a */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3},
};
static const nir_search_expression search543 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search543_0.value, &search543_1.value },
   NULL,
};

   /* replace543 -> replace121 in the cache */

   static const nir_search_variable search544_0 = {
   { nir_search_value_variable, -2 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_lt_zero),
   {0, 1, 2, 3},
};

static const nir_search_variable search544_1 = {
   { nir_search_value_variable, -2 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};
static const nir_search_expression search544 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search544_0.value, &search544_1.value },
   NULL,
};

   /* replace544 -> replace121 in the cache */

   static const nir_search_variable search545_0 = {
   { nir_search_value_variable, -2 },
   0, /* b */
   false,
   nir_type_invalid,
   (is_not_negative),
   {0, 1, 2, 3},
};

static const nir_search_variable search545_1 = {
   { nir_search_value_variable, -2 },
   1, /* a */
   false,
   nir_type_invalid,
   (is_not_positive),
   {0, 1, 2, 3},
};
static const nir_search_expression search545 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_fge,
   { &search545_0.value, &search545_1.value },
   NULL,
};

   /* replace545 -> replace197 in the cache */

   /* search546_0 -> search542_0 in the cache */

/* search546_1 -> search542_1 in the cache */
static const nir_search_expression search546 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search542_0.value, &search542_1.value },
   NULL,
};

   /* replace546 -> replace121 in the cache */

   /* search547_0 -> search543_0 in the cache */

/* search547_1 -> search543_1 in the cache */
static const nir_search_expression search547 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search543_0.value, &search543_1.value },
   NULL,
};

   /* replace547 -> replace197 in the cache */

   /* search548_0 -> search544_0 in the cache */

/* search548_1 -> search544_1 in the cache */
static const nir_search_expression search548 = {
   { nir_search_value_expression, 1 },
   true, false,
   -1, 0,
   nir_op_flt,
   { &search544_0.value, &search544_1.value },
   NULL,
};

   /* replace548 -> replace197 in the cache */

   /* search549_0 -> search545_0 in the cache */

/* search549_1 -> search545_1 in the cache */
static const nir_search_expression search549 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search545_0.value, &search545_1.value },
   NULL,
};

   /* replace549 -> replace121 in the cache */

   /* search550_0 -> search540_0 in the cache */

/* search550_1 -> replace9 in the cache */
static const nir_search_expression search550 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search540_0.value, &replace9.value },
   NULL,
};

   /* replace550 -> replace197 in the cache */

   /* search551_0 -> search540_0 in the cache */

/* search551_1 -> replace9 in the cache */
static const nir_search_expression search551 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search540_0.value, &replace9.value },
   NULL,
};

   /* replace551 -> replace121 in the cache */

   /* search552_0 -> search542_0 in the cache */

/* search552_1 -> search542_1 in the cache */
static const nir_search_expression search552 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search542_0.value, &search542_1.value },
   NULL,
};

   /* replace552 -> replace197 in the cache */

   /* search553_0 -> search543_0 in the cache */

/* search553_1 -> search543_1 in the cache */
static const nir_search_expression search553 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search543_0.value, &search543_1.value },
   NULL,
};

   /* replace553 -> replace121 in the cache */

   /* search554_0 -> search544_0 in the cache */

/* search554_1 -> search544_1 in the cache */
static const nir_search_expression search554 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search544_0.value, &search544_1.value },
   NULL,
};

   /* replace554 -> replace121 in the cache */

   /* search555_0 -> search545_0 in the cache */

/* search555_1 -> search545_1 in the cache */
static const nir_search_expression search555 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search545_0.value, &search545_1.value },
   NULL,
};

   /* replace555 -> replace197 in the cache */

   /* search556_0 -> search542_0 in the cache */

/* search556_1 -> search542_1 in the cache */
static const nir_search_expression search556 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search542_0.value, &search542_1.value },
   NULL,
};

   /* replace556 -> replace121 in the cache */

   /* search557_0 -> search543_0 in the cache */

/* search557_1 -> search543_1 in the cache */
static const nir_search_expression search557 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search543_0.value, &search543_1.value },
   NULL,
};

   /* replace557 -> replace197 in the cache */

   /* search558_0 -> search544_0 in the cache */

/* search558_1 -> search544_1 in the cache */
static const nir_search_expression search558 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search544_0.value, &search544_1.value },
   NULL,
};

   /* replace558 -> replace197 in the cache */

   /* search559_0 -> search545_0 in the cache */

/* search559_1 -> search545_1 in the cache */
static const nir_search_expression search559 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search545_0.value, &search545_1.value },
   NULL,
};

   /* replace559 -> replace121 in the cache */

   /* search560_0 -> replace9 in the cache */

static const nir_search_variable search560_1 = {
   { nir_search_value_variable, -1 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_gt_zero),
   {0, 1, 2, 3},
};
static const nir_search_expression search560 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace9.value, &search560_1.value },
   NULL,
};

   /* replace560 -> replace197 in the cache */

   /* search561_0_0 -> search0_0 in the cache */

/* search561_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression search561_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32_split,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search561 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_x,
   { &search561_0.value },
   NULL,
};

   /* replace561 -> search0_0 in the cache */

   /* search562_0_0 -> search0_0 in the cache */

/* search562_0_1 -> replace0_1_0 in the cache */
/* search562_0 -> search561_0 in the cache */
static const nir_search_expression search562 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search561_0.value },
   NULL,
};

   /* replace562 -> replace0_1_0 in the cache */

   /* search563_0_0 -> search57_0 in the cache */
static const nir_search_expression search563_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_x,
   { &search57_0.value },
   NULL,
};

/* search563_1_0 -> search57_0 in the cache */
static const nir_search_expression search563_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_64_2x32_split_y,
   { &search57_0.value },
   NULL,
};
static const nir_search_expression search563 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_pack_64_2x32_split,
   { &search563_0.value, &search563_1.value },
   NULL,
};

   /* replace563 -> search57_0 in the cache */

   /* search564_0_0_0 -> search0_0 in the cache */
static const nir_search_expression search564_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_x,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search564_0_1 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search564_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search564_0_0.value, &search564_0_1.value },
   NULL,
};

/* search564_1_0_0 -> search0_0 in the cache */
static const nir_search_expression search564_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_unpack_32_2x16_split_y,
   { &search0_0.value },
   NULL,
};

static const nir_search_variable search564_1_1 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search564_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &search564_1_0.value, &search564_1_1.value },
   NULL,
};
static const nir_search_expression search564 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search564_0.value, &search564_1.value },
   NULL,
};

   /* replace564_0 -> search0_0 in the cache */

static const nir_search_variable replace564_1_0 = {
   { nir_search_value_variable, 16 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable replace564_1_1 = {
   { nir_search_value_variable, 16 },
   2, /* c */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression replace564_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_32_2x16_split,
   { &replace564_1_0.value, &replace564_1_1.value },
   NULL,
};
static const nir_search_expression replace564 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace564_1.value },
   NULL,
};

   /* search565_0 -> search101_0_0 in the cache */

/* search565_1 -> replace98_0_1 in the cache */
static const nir_search_expression search565 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search101_0_0.value, &replace98_0_1.value },
   NULL,
};

   /* replace565_0 -> search101_0_0 in the cache */

static const nir_search_constant replace565_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace565 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search101_0_0.value, &replace565_1.value },
   NULL,
};

   /* search566_0 -> search0_0 in the cache */

/* search566_1 -> search441_1_1 in the cache */
/* search566 -> search441_1 in the cache */

   /* replace566_0 -> search0_0 in the cache */

static const nir_search_constant replace566_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression replace566 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &replace566_1.value },
   NULL,
};

   /* search567_0 -> search57_0 in the cache */

static const nir_search_constant search567_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x38 /* 56 */ },
};
static const nir_search_expression search567 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search567_1.value },
   NULL,
};

   /* replace567_0 -> search57_0 in the cache */

static const nir_search_constant replace567_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7 /* 7 */ },
};
static const nir_search_expression replace567 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace567_1.value },
   NULL,
};

   /* search568_0 -> search101_0_0 in the cache */

/* search568_1 -> replace98_0_1 in the cache */
static const nir_search_expression search568 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search101_0_0.value, &replace98_0_1.value },
   NULL,
};

   /* replace568_0 -> search101_0_0 in the cache */

/* replace568_1 -> replace565_1 in the cache */
static const nir_search_expression replace568 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search101_0_0.value, &replace565_1.value },
   NULL,
};

   /* search569_0 -> search0_0 in the cache */

/* search569_1 -> search441_1_1 in the cache */
static const nir_search_expression search569 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &search441_1_1.value },
   NULL,
};

   /* replace569_0 -> search0_0 in the cache */

/* replace569_1 -> replace566_1 in the cache */
static const nir_search_expression replace569 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &replace566_1.value },
   NULL,
};

   /* search570_0 -> search57_0 in the cache */

/* search570_1 -> search567_1 in the cache */
static const nir_search_expression search570 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search567_1.value },
   NULL,
};

   /* replace570_0 -> search57_0 in the cache */

/* replace570_1 -> replace567_1 in the cache */
static const nir_search_expression replace570 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace567_1.value },
   NULL,
};

   /* search571_0 -> search279_0_1 in the cache */

/* search571_1 -> search2_0 in the cache */
static const nir_search_expression search571 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search279_0_1.value, &search2_0.value },
   NULL,
};

   /* replace571_0 -> search2_0 in the cache */

/* replace571_1 -> replace9 in the cache */
static const nir_search_expression replace571 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search572_0_0 -> search0_0 in the cache */

/* search572_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression search572_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &replace101_0_0_0_1.value },
   NULL,
};
static const nir_search_expression search572 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_half_2x16_split_x,
   { &search572_0.value },
   NULL,
};

   /* replace572_0 -> search0_0 in the cache */
static const nir_search_expression replace572 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_x,
   { &search0_0.value },
   NULL,
};

   /* search573_0_0 -> search0_0 in the cache */

/* search573_0_1 -> replace101_0_0_0_1 in the cache */
/* search573_0 -> search572_0 in the cache */
static const nir_search_expression search573 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_unpack_32_2x16_split_x,
   { &search572_0.value },
   NULL,
};

   /* replace573_0 -> search0_0 in the cache */
/* replace573 -> search564_0_0 in the cache */

   /* search574_0_0 -> search57_0 in the cache */

static const nir_search_constant search574_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffff /* 4294967295 */ },
};
static const nir_search_expression search574_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search57_0.value, &search574_0_1.value },
   NULL,
};
static const nir_search_expression search574 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_x,
   { &search574_0.value },
   NULL,
};

   /* replace574_0 -> search57_0 in the cache */
/* replace574 -> search563_0 in the cache */

   /* search575_0_0 -> search0_0 in the cache */

static const nir_search_constant search575_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xffff0000 /* 4294901760 */ },
};
static const nir_search_expression search575_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search0_0.value, &search575_0_1.value },
   NULL,
};
static const nir_search_expression search575 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_half_2x16_split_y,
   { &search575_0.value },
   NULL,
};

   /* replace575_0 -> search0_0 in the cache */
static const nir_search_expression replace575 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_half_2x16_split_y,
   { &search0_0.value },
   NULL,
};

   /* search576_0_0 -> search0_0 in the cache */

/* search576_0_1 -> search575_0_1 in the cache */
/* search576_0 -> search575_0 in the cache */
static const nir_search_expression search576 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_unpack_32_2x16_split_y,
   { &search575_0.value },
   NULL,
};

   /* replace576_0 -> search0_0 in the cache */
/* replace576 -> search564_1_0 in the cache */

   /* search577_0_0 -> search57_0 in the cache */

static const nir_search_constant search577_0_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffffffff00000000L /* 18446744069414584320 */ },
};
static const nir_search_expression search577_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search57_0.value, &search577_0_1.value },
   NULL,
};
static const nir_search_expression search577 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_unpack_64_2x32_split_y,
   { &search577_0.value },
   NULL,
};

   /* replace577_0 -> search57_0 in the cache */
/* replace577 -> search563_1 in the cache */

   /* search578_0_0 -> search101_0_0 in the cache */

/* search578_0_1 -> replace98_0_1 in the cache */
/* search578_0 -> search565 in the cache */

/* search578_1 -> replace101_2 in the cache */
static const nir_search_expression search578 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search565.value, &replace101_2.value },
   NULL,
};

   /* replace578_0 -> search101_0_0 in the cache */

/* replace578_1 -> replace565_1 in the cache */
/* replace578 -> replace565 in the cache */

   /* search579_0_0 -> search0_0 in the cache */

/* search579_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search579_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search0_0.value, &replace98_0_1.value },
   NULL,
};

/* search579_1 -> search26_1 in the cache */
static const nir_search_expression search579 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search579_0.value, &search26_1.value },
   NULL,
};

   /* replace579_0 -> search0_0 in the cache */

static const nir_search_constant replace579_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace579 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &replace579_1.value },
   NULL,
};

   /* search580_0_0 -> search0_0 in the cache */

/* search580_0_1 -> replace101_0_1 in the cache */
/* search580_0 -> search442_1 in the cache */

/* search580_1 -> search26_1 in the cache */
static const nir_search_expression search580 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search442_1.value, &search26_1.value },
   NULL,
};

   /* replace580_0 -> search0_0 in the cache */

static const nir_search_constant replace580_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression replace580 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &replace580_1.value },
   NULL,
};

   /* search581_0_0 -> search0_0 in the cache */

/* search581_0_1 -> search441_1_1 in the cache */
/* search581_0 -> search441_1 in the cache */

/* search581_1 -> search26_1 in the cache */
static const nir_search_expression search581 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search441_1.value, &search26_1.value },
   NULL,
};

   /* replace581_0 -> search0_0 in the cache */

/* replace581_1 -> replace566_1 in the cache */
/* replace581 -> replace566 in the cache */

   /* search582_0_0 -> search57_0 in the cache */

/* search582_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search582_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &replace98_0_1.value },
   NULL,
};

/* search582_1 -> replace107_2 in the cache */
static const nir_search_expression search582 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search582_0.value, &replace107_2.value },
   NULL,
};

   /* replace582_0 -> search57_0 in the cache */

static const nir_search_constant replace582_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace582 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace582_1.value },
   NULL,
};

   /* search583_0_0 -> search57_0 in the cache */

/* search583_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search583_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &replace101_0_1.value },
   NULL,
};

/* search583_1 -> replace107_2 in the cache */
static const nir_search_expression search583 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search583_0.value, &replace107_2.value },
   NULL,
};

   /* replace583_0 -> search57_0 in the cache */

static const nir_search_constant replace583_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x2 /* 2 */ },
};
static const nir_search_expression replace583 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace583_1.value },
   NULL,
};

   /* search584_0_0 -> search57_0 in the cache */

/* search584_0_1 -> search441_1_1 in the cache */
static const nir_search_expression search584_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search441_1_1.value },
   NULL,
};

/* search584_1 -> replace107_2 in the cache */
static const nir_search_expression search584 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search584_0.value, &replace107_2.value },
   NULL,
};

   /* replace584_0 -> search57_0 in the cache */

static const nir_search_constant replace584_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x3 /* 3 */ },
};
static const nir_search_expression replace584 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace584_1.value },
   NULL,
};

   /* search585_0_0 -> search57_0 in the cache */

/* search585_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression search585_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &replace104_0_1.value },
   NULL,
};

/* search585_1 -> replace107_2 in the cache */
static const nir_search_expression search585 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search585_0.value, &replace107_2.value },
   NULL,
};

   /* replace585_0 -> search57_0 in the cache */

static const nir_search_constant replace585_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x4 /* 4 */ },
};
static const nir_search_expression replace585 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace585_1.value },
   NULL,
};

   /* search586_0_0 -> search57_0 in the cache */

static const nir_search_constant search586_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x28 /* 40 */ },
};
static const nir_search_expression search586_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search586_0_1.value },
   NULL,
};

/* search586_1 -> replace107_2 in the cache */
static const nir_search_expression search586 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search586_0.value, &replace107_2.value },
   NULL,
};

   /* replace586_0 -> search57_0 in the cache */

static const nir_search_constant replace586_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x5 /* 5 */ },
};
static const nir_search_expression replace586 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace586_1.value },
   NULL,
};

   /* search587_0_0 -> search57_0 in the cache */

static const nir_search_constant search587_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x30 /* 48 */ },
};
static const nir_search_expression search587_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search57_0.value, &search587_0_1.value },
   NULL,
};

/* search587_1 -> replace107_2 in the cache */
static const nir_search_expression search587 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search587_0.value, &replace107_2.value },
   NULL,
};

   /* replace587_0 -> search57_0 in the cache */

static const nir_search_constant replace587_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x6 /* 6 */ },
};
static const nir_search_expression replace587 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace587_1.value },
   NULL,
};

   /* search588_0_0 -> search57_0 in the cache */

/* search588_0_1 -> search567_1 in the cache */
/* search588_0 -> search567 in the cache */

/* search588_1 -> replace107_2 in the cache */
static const nir_search_expression search588 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search567.value, &replace107_2.value },
   NULL,
};

   /* replace588_0 -> search57_0 in the cache */

/* replace588_1 -> replace567_1 in the cache */
/* replace588 -> replace567 in the cache */

   /* search589_0_0 -> search101_0_0 in the cache */

/* search589_0_1 -> replace98_0_1 in the cache */
/* search589_0 -> search568 in the cache */

/* search589_1 -> replace101_2 in the cache */
static const nir_search_expression search589 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search568.value, &replace101_2.value },
   NULL,
};

   /* replace589_0 -> search101_0_0 in the cache */

/* replace589_1 -> replace565_1 in the cache */
/* replace589 -> replace565 in the cache */

   /* search590_0_0 -> search0_0 in the cache */

/* search590_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search590_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace98_0_1.value },
   NULL,
};

/* search590_1 -> search26_1 in the cache */
static const nir_search_expression search590 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search590_0.value, &search26_1.value },
   NULL,
};

   /* replace590_0 -> search0_0 in the cache */

/* replace590_1 -> replace579_1 in the cache */
/* replace590 -> replace579 in the cache */

   /* search591_0_0 -> search0_0 in the cache */

/* search591_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search591_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search0_0.value, &replace101_0_1.value },
   NULL,
};

/* search591_1 -> search26_1 in the cache */
static const nir_search_expression search591 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search591_0.value, &search26_1.value },
   NULL,
};

   /* replace591_0 -> search0_0 in the cache */

/* replace591_1 -> replace580_1 in the cache */
/* replace591 -> replace580 in the cache */

   /* search592_0_0 -> search0_0 in the cache */

/* search592_0_1 -> search441_1_1 in the cache */
/* search592_0 -> search569 in the cache */

/* search592_1 -> search26_1 in the cache */
static const nir_search_expression search592 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search569.value, &search26_1.value },
   NULL,
};

   /* replace592_0 -> search0_0 in the cache */

/* replace592_1 -> replace566_1 in the cache */
/* replace592 -> replace566 in the cache */

   /* search593_0_0 -> search57_0 in the cache */

/* search593_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search593_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &replace98_0_1.value },
   NULL,
};

/* search593_1 -> replace107_2 in the cache */
static const nir_search_expression search593 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search593_0.value, &replace107_2.value },
   NULL,
};

   /* replace593_0 -> search57_0 in the cache */

/* replace593_1 -> replace582_1 in the cache */
/* replace593 -> replace582 in the cache */

   /* search594_0_0 -> search57_0 in the cache */

/* search594_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search594_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &replace101_0_1.value },
   NULL,
};

/* search594_1 -> replace107_2 in the cache */
static const nir_search_expression search594 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search594_0.value, &replace107_2.value },
   NULL,
};

   /* replace594_0 -> search57_0 in the cache */

/* replace594_1 -> replace583_1 in the cache */
/* replace594 -> replace583 in the cache */

   /* search595_0_0 -> search57_0 in the cache */

/* search595_0_1 -> search441_1_1 in the cache */
static const nir_search_expression search595_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search441_1_1.value },
   NULL,
};

/* search595_1 -> replace107_2 in the cache */
static const nir_search_expression search595 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search595_0.value, &replace107_2.value },
   NULL,
};

   /* replace595_0 -> search57_0 in the cache */

/* replace595_1 -> replace584_1 in the cache */
/* replace595 -> replace584 in the cache */

   /* search596_0_0 -> search57_0 in the cache */

/* search596_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression search596_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &replace104_0_1.value },
   NULL,
};

/* search596_1 -> replace107_2 in the cache */
static const nir_search_expression search596 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search596_0.value, &replace107_2.value },
   NULL,
};

   /* replace596_0 -> search57_0 in the cache */

/* replace596_1 -> replace585_1 in the cache */
/* replace596 -> replace585 in the cache */

   /* search597_0_0 -> search57_0 in the cache */

/* search597_0_1 -> search586_0_1 in the cache */
static const nir_search_expression search597_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search586_0_1.value },
   NULL,
};

/* search597_1 -> replace107_2 in the cache */
static const nir_search_expression search597 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search597_0.value, &replace107_2.value },
   NULL,
};

   /* replace597_0 -> search57_0 in the cache */

/* replace597_1 -> replace586_1 in the cache */
/* replace597 -> replace586 in the cache */

   /* search598_0_0 -> search57_0 in the cache */

/* search598_0_1 -> search587_0_1 in the cache */
static const nir_search_expression search598_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search57_0.value, &search587_0_1.value },
   NULL,
};

/* search598_1 -> replace107_2 in the cache */
static const nir_search_expression search598 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search598_0.value, &replace107_2.value },
   NULL,
};

   /* replace598_0 -> search57_0 in the cache */

/* replace598_1 -> replace587_1 in the cache */
/* replace598 -> replace587 in the cache */

   /* search599_0_0 -> search57_0 in the cache */

/* search599_0_1 -> search567_1 in the cache */
/* search599_0 -> search570 in the cache */

/* search599_1 -> replace107_2 in the cache */
static const nir_search_expression search599 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search570.value, &replace107_2.value },
   NULL,
};

   /* replace599_0 -> search57_0 in the cache */

/* replace599_1 -> replace567_1 in the cache */
/* replace599 -> replace567 in the cache */

   /* search600_0_0 -> search2_0 in the cache */

/* search600_0_1 -> replace2_1_0 in the cache */
static const nir_search_expression search600_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search2_0.value, &replace2_1_0.value },
   NULL,
};

/* search600_1 -> replace9 in the cache */
static const nir_search_expression search600 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search600_0.value, &replace9.value },
   NULL,
};

   /* replace600_0 -> search2_0 in the cache */

/* replace600_1 -> search321_1_1 in the cache */
static const nir_search_expression replace600 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search2_0.value, &search321_1_1.value },
   NULL,
};

   /* search601_0_0 -> search101_0_0 in the cache */

/* search601_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search601_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search101_0_0.value, &replace98_0_1.value },
   NULL,
};

/* search601_1 -> replace565_1 in the cache */
static const nir_search_expression search601 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search601_0.value, &replace565_1.value },
   NULL,
};

   /* replace601_0 -> search101_0_0 in the cache */

/* replace601_1 -> replace101_2 in the cache */
static const nir_search_expression replace601 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

   /* search602_0_0 -> search0_0 in the cache */

/* search602_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search602_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace98_0_1.value },
   NULL,
};

/* search602_1 -> replace566_1 in the cache */
static const nir_search_expression search602 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search602_0.value, &replace566_1.value },
   NULL,
};

   /* replace602_0 -> search0_0 in the cache */

/* replace602_1 -> replace580_1 in the cache */
/* replace602 -> replace580 in the cache */

   /* search603_0_0 -> search0_0 in the cache */

/* search603_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search603_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &replace101_0_1.value },
   NULL,
};

/* search603_1 -> replace566_1 in the cache */
static const nir_search_expression search603 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search603_0.value, &replace566_1.value },
   NULL,
};

   /* replace603_0 -> search0_0 in the cache */

/* replace603_1 -> replace579_1 in the cache */
/* replace603 -> replace579 in the cache */

   /* search604_0_0 -> search0_0 in the cache */

/* search604_0_1 -> search441_1_1 in the cache */
static const nir_search_expression search604_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search0_0.value, &search441_1_1.value },
   NULL,
};

/* search604_1 -> replace566_1 in the cache */
static const nir_search_expression search604 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search604_0.value, &replace566_1.value },
   NULL,
};

   /* replace604_0 -> search0_0 in the cache */

/* replace604_1 -> search26_1 in the cache */
static const nir_search_expression replace604 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search605_0_0 -> search57_0 in the cache */

/* search605_0_1 -> replace98_0_1 in the cache */
static const nir_search_expression search605_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &replace98_0_1.value },
   NULL,
};

/* search605_1 -> replace567_1 in the cache */
static const nir_search_expression search605 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search605_0.value, &replace567_1.value },
   NULL,
};

   /* replace605_0 -> search57_0 in the cache */

/* replace605_1 -> replace587_1 in the cache */
/* replace605 -> replace587 in the cache */

   /* search606_0_0 -> search57_0 in the cache */

/* search606_0_1 -> replace101_0_1 in the cache */
static const nir_search_expression search606_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &replace101_0_1.value },
   NULL,
};

/* search606_1 -> replace567_1 in the cache */
static const nir_search_expression search606 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search606_0.value, &replace567_1.value },
   NULL,
};

   /* replace606_0 -> search57_0 in the cache */

/* replace606_1 -> replace586_1 in the cache */
/* replace606 -> replace586 in the cache */

   /* search607_0_0 -> search57_0 in the cache */

/* search607_0_1 -> search441_1_1 in the cache */
static const nir_search_expression search607_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search441_1_1.value },
   NULL,
};

/* search607_1 -> replace567_1 in the cache */
static const nir_search_expression search607 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search607_0.value, &replace567_1.value },
   NULL,
};

   /* replace607_0 -> search57_0 in the cache */

/* replace607_1 -> replace585_1 in the cache */
/* replace607 -> replace585 in the cache */

   /* search608_0_0 -> search57_0 in the cache */

/* search608_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression search608_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &replace104_0_1.value },
   NULL,
};

/* search608_1 -> replace567_1 in the cache */
static const nir_search_expression search608 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search608_0.value, &replace567_1.value },
   NULL,
};

   /* replace608_0 -> search57_0 in the cache */

/* replace608_1 -> replace584_1 in the cache */
/* replace608 -> replace584 in the cache */

   /* search609_0_0 -> search57_0 in the cache */

/* search609_0_1 -> search586_0_1 in the cache */
static const nir_search_expression search609_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search586_0_1.value },
   NULL,
};

/* search609_1 -> replace567_1 in the cache */
static const nir_search_expression search609 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search609_0.value, &replace567_1.value },
   NULL,
};

   /* replace609_0 -> search57_0 in the cache */

/* replace609_1 -> replace583_1 in the cache */
/* replace609 -> replace583 in the cache */

   /* search610_0_0 -> search57_0 in the cache */

/* search610_0_1 -> search587_0_1 in the cache */
static const nir_search_expression search610_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search587_0_1.value },
   NULL,
};

/* search610_1 -> replace567_1 in the cache */
static const nir_search_expression search610 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search610_0.value, &replace567_1.value },
   NULL,
};

   /* replace610_0 -> search57_0 in the cache */

/* replace610_1 -> replace582_1 in the cache */
/* replace610 -> replace582 in the cache */

   /* search611_0_0 -> search57_0 in the cache */

/* search611_0_1 -> search567_1 in the cache */
static const nir_search_expression search611_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search57_0.value, &search567_1.value },
   NULL,
};

/* search611_1 -> replace567_1 in the cache */
static const nir_search_expression search611 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search611_0.value, &replace567_1.value },
   NULL,
};

   /* replace611_0 -> search57_0 in the cache */

/* replace611_1 -> replace107_2 in the cache */
static const nir_search_expression replace611 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* search612_0_0 -> search101_0_0 in the cache */

/* search612_0_1 -> replace98_0_1 in the cache */
/* search612_0 -> search601_0 in the cache */

/* search612_1 -> replace565_1 in the cache */
static const nir_search_expression search612 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search601_0.value, &replace565_1.value },
   NULL,
};

   /* replace612_0 -> search101_0_0 in the cache */

/* replace612_1 -> replace101_2 in the cache */
static const nir_search_expression replace612 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

   /* search613_0_0 -> search0_0 in the cache */

/* search613_0_1 -> replace98_0_1 in the cache */
/* search613_0 -> search602_0 in the cache */

/* search613_1 -> replace566_1 in the cache */
static const nir_search_expression search613 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search602_0.value, &replace566_1.value },
   NULL,
};

   /* replace613_0 -> search0_0 in the cache */

/* replace613_1 -> replace580_1 in the cache */
static const nir_search_expression replace613 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &replace580_1.value },
   NULL,
};

   /* search614_0_0 -> search0_0 in the cache */

/* search614_0_1 -> replace101_0_1 in the cache */
/* search614_0 -> search603_0 in the cache */

/* search614_1 -> replace566_1 in the cache */
static const nir_search_expression search614 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search603_0.value, &replace566_1.value },
   NULL,
};

   /* replace614_0 -> search0_0 in the cache */

/* replace614_1 -> replace579_1 in the cache */
static const nir_search_expression replace614 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &replace579_1.value },
   NULL,
};

   /* search615_0_0 -> search0_0 in the cache */

/* search615_0_1 -> search441_1_1 in the cache */
/* search615_0 -> search604_0 in the cache */

/* search615_1 -> replace566_1 in the cache */
static const nir_search_expression search615 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search604_0.value, &replace566_1.value },
   NULL,
};

   /* replace615_0 -> search0_0 in the cache */

/* replace615_1 -> search26_1 in the cache */
static const nir_search_expression replace615 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search616_0_0 -> search57_0 in the cache */

/* search616_0_1 -> replace98_0_1 in the cache */
/* search616_0 -> search605_0 in the cache */

/* search616_1 -> replace567_1 in the cache */
static const nir_search_expression search616 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search605_0.value, &replace567_1.value },
   NULL,
};

   /* replace616_0 -> search57_0 in the cache */

/* replace616_1 -> replace587_1 in the cache */
static const nir_search_expression replace616 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace587_1.value },
   NULL,
};

   /* search617_0_0 -> search57_0 in the cache */

/* search617_0_1 -> replace101_0_1 in the cache */
/* search617_0 -> search606_0 in the cache */

/* search617_1 -> replace567_1 in the cache */
static const nir_search_expression search617 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search606_0.value, &replace567_1.value },
   NULL,
};

   /* replace617_0 -> search57_0 in the cache */

/* replace617_1 -> replace586_1 in the cache */
static const nir_search_expression replace617 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace586_1.value },
   NULL,
};

   /* search618_0_0 -> search57_0 in the cache */

/* search618_0_1 -> search441_1_1 in the cache */
/* search618_0 -> search607_0 in the cache */

/* search618_1 -> replace567_1 in the cache */
static const nir_search_expression search618 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search607_0.value, &replace567_1.value },
   NULL,
};

   /* replace618_0 -> search57_0 in the cache */

/* replace618_1 -> replace585_1 in the cache */
static const nir_search_expression replace618 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace585_1.value },
   NULL,
};

   /* search619_0_0 -> search57_0 in the cache */

/* search619_0_1 -> replace104_0_1 in the cache */
/* search619_0 -> search608_0 in the cache */

/* search619_1 -> replace567_1 in the cache */
static const nir_search_expression search619 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search608_0.value, &replace567_1.value },
   NULL,
};

   /* replace619_0 -> search57_0 in the cache */

/* replace619_1 -> replace584_1 in the cache */
static const nir_search_expression replace619 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace584_1.value },
   NULL,
};

   /* search620_0_0 -> search57_0 in the cache */

/* search620_0_1 -> search586_0_1 in the cache */
/* search620_0 -> search609_0 in the cache */

/* search620_1 -> replace567_1 in the cache */
static const nir_search_expression search620 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search609_0.value, &replace567_1.value },
   NULL,
};

   /* replace620_0 -> search57_0 in the cache */

/* replace620_1 -> replace583_1 in the cache */
static const nir_search_expression replace620 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace583_1.value },
   NULL,
};

   /* search621_0_0 -> search57_0 in the cache */

/* search621_0_1 -> search587_0_1 in the cache */
/* search621_0 -> search610_0 in the cache */

/* search621_1 -> replace567_1 in the cache */
static const nir_search_expression search621 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search610_0.value, &replace567_1.value },
   NULL,
};

   /* replace621_0 -> search57_0 in the cache */

/* replace621_1 -> replace582_1 in the cache */
static const nir_search_expression replace621 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace582_1.value },
   NULL,
};

   /* search622_0_0 -> search57_0 in the cache */

/* search622_0_1 -> search567_1 in the cache */
/* search622_0 -> search611_0 in the cache */

/* search622_1 -> replace567_1 in the cache */
static const nir_search_expression search622 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search611_0.value, &replace567_1.value },
   NULL,
};

   /* replace622_0 -> search57_0 in the cache */

/* replace622_1 -> replace107_2 in the cache */
static const nir_search_expression replace622 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

   /* search623_0_0 -> search0_0 in the cache */

/* search623_0_1 -> replace101_0_1 in the cache */
/* search623_0 -> search603_0 in the cache */

/* search623_1 -> replace101_0_1 in the cache */
static const nir_search_expression search623 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search603_0.value, &replace101_0_1.value },
   NULL,
};

   /* replace623_0 -> search0_0 in the cache */

/* replace623_1 -> search26_1 in the cache */
static const nir_search_expression replace623 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search624_0 -> search0_0 in the cache */

/* search624_1 -> replace101_0_1 in the cache */
/* search624 -> search442_1 in the cache */

   /* replace624_0 -> search0_0 in the cache */

/* replace624_1 -> replace579_1 in the cache */
static const nir_search_expression replace624 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &replace579_1.value },
   NULL,
};

   /* search625_0_0 -> search0_0 in the cache */

/* search625_0_1 -> replace101_0_1 in the cache */
/* search625_0 -> search603_0 in the cache */

/* search625_1 -> replace101_0_1 in the cache */
static const nir_search_expression search625 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &search603_0.value, &replace101_0_1.value },
   NULL,
};

   /* replace625_0 -> search0_0 in the cache */

/* replace625_1 -> search26_1 in the cache */
static const nir_search_expression replace625 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* search626_0 -> search0_0 in the cache */

/* search626_1 -> replace101_0_1 in the cache */
/* search626 -> search591_0 in the cache */

   /* replace626_0 -> search0_0 in the cache */

/* replace626_1 -> replace579_1 in the cache */
static const nir_search_expression replace626 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &replace579_1.value },
   NULL,
};

   static const nir_search_constant search627_0 = {
   { nir_search_value_constant, -1 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* search627_1 -> search2_0 in the cache */
static const nir_search_expression search627 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search627_0.value, &search2_0.value },
   NULL,
};

   /* replace627_0 -> search2_0 in the cache */

/* replace627_1 -> replace9 in the cache */
static const nir_search_expression replace627 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search2_0.value, &replace9.value },
   NULL,
};

   /* search628_0 -> search14_0 in the cache */

/* search628_1_0 -> search47_0 in the cache */

/* search628_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search628_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search47_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search628 = {
   { nir_search_value_expression, -2 },
   true, false,
   -1, 0,
   nir_op_fsub,
   { &search14_0.value, &search628_1.value },
   NULL,
};

   /* replace628_0 -> search14_0 in the cache */

/* replace628_1 -> replace14_1_0 in the cache */
/* replace628 -> replace49 in the cache */

   /* search629_0 -> search14_0 in the cache */

/* search629_1_0 -> replace187_1 in the cache */

/* search629_1_1 -> replace14_1_0 in the cache */
static const nir_search_expression search629_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace187_1.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression search629 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search14_0.value, &search629_1.value },
   NULL,
};

   /* replace629_0 -> search14_0 in the cache */

/* replace629_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace629 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* search630_0 -> search0_0 in the cache */

/* search630_1 -> search26_1 in the cache */
static const nir_search_expression search630 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ussub_4x8,
   { &search0_0.value, &search26_1.value },
   NULL,
};

   /* replace630 -> search0_0 in the cache */

   /* search631_0 -> search0_0 in the cache */

/* search631_1 -> search27_1 in the cache */
static const nir_search_expression search631 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ussub_4x8,
   { &search0_0.value, &search27_1.value },
   NULL,
};

   /* replace631 -> search26_1 in the cache */

   /* search632_0 -> search14_0 in the cache */

/* search632_1 -> replace14_1_0 in the cache */
static const nir_search_expression search632 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace632_0 -> search14_0 in the cache */

/* replace632_1_0 -> replace14_1_0 in the cache */
/* replace632_1 -> search126_1 in the cache */
static const nir_search_expression replace632 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &search126_1.value },
   NULL,
};

   /* search633_0 -> search14_0 in the cache */

/* search633_1 -> replace14_1_0 in the cache */
static const nir_search_expression search633 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace633_0 -> search14_0 in the cache */

/* replace633_1_0 -> replace14_1_0 in the cache */
static const nir_search_expression replace633_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace633 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &replace633_1.value },
   NULL,
};

   /* search634_0 -> search2_0 in the cache */
/* search634 -> search15_0 in the cache */

   /* replace634_0 -> search24_1 in the cache */

/* replace634_1 -> search2_0 in the cache */
static const nir_search_expression replace634 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &search24_1.value, &search2_0.value },
   NULL,
};

   /* search635_0 -> search2_0 in the cache */
/* search635 -> search16_0 in the cache */

   /* replace635_0 -> replace9 in the cache */

/* replace635_1 -> search2_0 in the cache */
static const nir_search_expression replace635 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace9.value, &search2_0.value },
   NULL,
};

   /* search636_0 -> search14_0 in the cache */

/* search636_1_0 -> search47_0 in the cache */

/* search636_1_1 -> replace14_1_0 in the cache */
/* search636_1 -> search628_1 in the cache */
static const nir_search_expression search636 = {
   { nir_search_value_expression, -2 },
   true, false,
   0, 1,
   nir_op_fadd,
   { &search14_0.value, &search628_1.value },
   NULL,
};

   /* replace636_0 -> search14_0 in the cache */

/* replace636_1 -> replace14_1_0 in the cache */
/* replace636 -> search632 in the cache */

   /* search637_0 -> search14_0 in the cache */

/* search637_1_0 -> replace187_1 in the cache */

/* search637_1_1 -> replace14_1_0 in the cache */
/* search637_1 -> search629_1 in the cache */
static const nir_search_expression search637 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search14_0.value, &search629_1.value },
   NULL,
};

   /* replace637_0 -> search14_0 in the cache */

/* replace637_1 -> replace14_1_0 in the cache */
/* replace637 -> search633 in the cache */

   /* search638_0_0 -> search24_1 in the cache */

/* search638_0_1 -> search2_0 in the cache */
/* search638_0 -> replace634 in the cache */
static const nir_search_expression search638 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fabs,
   { &replace634.value },
   NULL,
};

   /* replace638_0 -> search2_0 in the cache */
/* replace638 -> search17_0 in the cache */

   /* search639_0_0 -> replace9 in the cache */

/* search639_0_1 -> search2_0 in the cache */
/* search639_0 -> replace635 in the cache */
static const nir_search_expression search639 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_iabs,
   { &replace635.value },
   NULL,
};

   /* replace639_0 -> search2_0 in the cache */
/* replace639 -> search20_0 in the cache */

   /* search640_0_0 -> search14_0 in the cache */
/* search640_0 -> search34_0 in the cache */

/* search640_1 -> replace14_1_0 in the cache */
static const nir_search_expression search640 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &search34_0.value, &replace14_1_0.value },
   (is_used_by_non_fsat),
};

   /* replace640_0_0 -> search14_0 in the cache */

/* replace640_0_1 -> replace14_1_0 in the cache */
/* replace640_0 -> replace48 in the cache */
static const nir_search_expression replace640 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &replace48.value },
   NULL,
};

   /* search641_0_0 -> search14_0 in the cache */
/* search641_0 -> search32_0 in the cache */

/* search641_1 -> replace14_1_0 in the cache */
static const nir_search_expression search641 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search32_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace641_0_0 -> search14_0 in the cache */

/* replace641_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace641_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};
static const nir_search_expression replace641 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ineg,
   { &replace641_0.value },
   NULL,
};

   static const nir_search_variable search642_0_0 = {
   { nir_search_value_variable, -3 },
   0, /* a */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3},
};

static const nir_search_variable search642_0_1 = {
   { nir_search_value_variable, -3 },
   1, /* b */
   false,
   nir_type_invalid,
   (is_not_const),
   {0, 1, 2, 3},
};
static const nir_search_expression search642_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search642_0_0.value, &search642_0_1.value },
   (is_used_once),
};

/* search642_1 -> search96_0_1 in the cache */
static const nir_search_expression search642 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fmul,
   { &search642_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace642_0_0 -> search28_0_0 in the cache */

/* replace642_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace642_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace642_1 -> search28_0_1 in the cache */
static const nir_search_expression replace642 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fmul,
   { &replace642_0.value, &search28_0_1.value },
   NULL,
};

   /* search643_0_0 -> search642_0_0 in the cache */

/* search643_0_1 -> search642_0_1 in the cache */
static const nir_search_expression search643_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search642_0_0.value, &search642_0_1.value },
   (is_used_once),
};

/* search643_1 -> search96_0_1 in the cache */
static const nir_search_expression search643 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search643_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace643_0_0 -> search28_0_0 in the cache */

/* replace643_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace643_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace643_1 -> search28_0_1 in the cache */
static const nir_search_expression replace643 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &replace643_0.value, &search28_0_1.value },
   NULL,
};

   /* search644_0_0 -> search642_0_0 in the cache */

/* search644_0_1 -> search642_0_1 in the cache */
static const nir_search_expression search644_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search642_0_0.value, &search642_0_1.value },
   (is_used_once),
};

/* search644_1 -> search96_0_1 in the cache */
static const nir_search_expression search644 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search644_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace644_0_0 -> search28_0_0 in the cache */

/* replace644_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace644_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace644_1 -> search28_0_1 in the cache */
static const nir_search_expression replace644 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace644_0.value, &search28_0_1.value },
   NULL,
};

   /* search645_0_0 -> search642_0_0 in the cache */

/* search645_0_1 -> search642_0_1 in the cache */
static const nir_search_expression search645_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search642_0_0.value, &search642_0_1.value },
   (is_used_once),
};

/* search645_1 -> search96_0_1 in the cache */
static const nir_search_expression search645 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search645_0.value, &search96_0_1.value },
   (is_used_once),
};

   /* replace645_0_0 -> search28_0_0 in the cache */

/* replace645_0_1 -> search28_1_1 in the cache */
static const nir_search_expression replace645_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search28_0_0.value, &search28_1_1.value },
   NULL,
};

/* replace645_1 -> search28_0_1 in the cache */
static const nir_search_expression replace645 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &replace645_0.value, &search28_0_1.value },
   NULL,
};

   /* search646_0 -> search357_0 in the cache */

/* search646_1_0 -> search642_0_1 in the cache */

/* search646_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search646_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fmul,
   { &search642_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search646 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fmul,
   { &search357_0.value, &search646_1.value },
   NULL,
};

   /* replace646_0_0 -> search28_0_0 in the cache */

/* replace646_0_1 -> search28_1_1 in the cache */
/* replace646_0 -> replace642_0 in the cache */

/* replace646_1 -> search28_0_1 in the cache */
/* replace646 -> replace642 in the cache */

   /* search647_0 -> search357_0 in the cache */

/* search647_1_0 -> search642_0_1 in the cache */

/* search647_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search647_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_imul,
   { &search642_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search647 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_imul,
   { &search357_0.value, &search647_1.value },
   NULL,
};

   /* replace647_0_0 -> search28_0_0 in the cache */

/* replace647_0_1 -> search28_1_1 in the cache */
/* replace647_0 -> replace643_0 in the cache */

/* replace647_1 -> search28_0_1 in the cache */
/* replace647 -> replace643 in the cache */

   /* search648_0 -> search357_0 in the cache */

/* search648_1_0 -> search642_0_1 in the cache */

/* search648_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search648_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search642_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search648 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search357_0.value, &search648_1.value },
   NULL,
};

   /* replace648_0_0 -> search28_0_0 in the cache */

/* replace648_0_1 -> search28_1_1 in the cache */
/* replace648_0 -> replace644_0 in the cache */

/* replace648_1 -> search28_0_1 in the cache */
/* replace648 -> replace644 in the cache */

   /* search649_0 -> search357_0 in the cache */

/* search649_1_0_0 -> search642_0_1 in the cache */

/* search649_1_0_1 -> search96_0_1 in the cache */
/* search649_1_0 -> search648_1 in the cache */
static const nir_search_expression search649_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 1,
   nir_op_fneg,
   { &search648_1.value },
   NULL,
};
static const nir_search_expression search649 = {
   { nir_search_value_expression, -3 },
   true, false,
   0, 2,
   nir_op_fadd,
   { &search357_0.value, &search649_1.value },
   NULL,
};

   /* replace649_0_0 -> search28_0_0 in the cache */

/* replace649_0_1_0 -> search28_1_1 in the cache */
static const nir_search_expression replace649_0_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   -1, 0,
   nir_op_fneg,
   { &search28_1_1.value },
   NULL,
};
static const nir_search_expression replace649_0 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_fadd,
   { &search28_0_0.value, &replace649_0_1.value },
   NULL,
};

/* replace649_1_0 -> search28_0_1 in the cache */
/* replace649_1 -> replace179_1_1 in the cache */
static const nir_search_expression replace649 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_fadd,
   { &replace649_0.value, &replace179_1_1.value },
   NULL,
};

   /* search650_0 -> search357_0 in the cache */

/* search650_1_0 -> search642_0_1 in the cache */

/* search650_1_1 -> search96_0_1 in the cache */
static const nir_search_expression search650_1 = {
   { nir_search_value_expression, -3 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search642_0_1.value, &search96_0_1.value },
   NULL,
};
static const nir_search_expression search650 = {
   { nir_search_value_expression, -3 },
   false, false,
   0, 2,
   nir_op_iadd,
   { &search357_0.value, &search650_1.value },
   NULL,
};

   /* replace650_0_0 -> search28_0_0 in the cache */

/* replace650_0_1 -> search28_1_1 in the cache */
/* replace650_0 -> replace645_0 in the cache */

/* replace650_1 -> search28_0_1 in the cache */
/* replace650 -> replace645 in the cache */

   /* search651_0_0 -> search14_0 in the cache */

/* search651_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression search651_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_imul,
   { &search14_0.value, &replace14_1_0.value },
   (no_signed_wrap),
};

/* search651_1 -> replace14_1_0 in the cache */
static const nir_search_expression search651 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_idiv,
   { &search651_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace651 -> search14_0 in the cache */

   /* search652_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search652_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &search2_0.value },
   NULL,
};

/* search652_0_1 -> search26_1 in the cache */
static const nir_search_expression search652_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search652_0_0.value, &search26_1.value },
   NULL,
};

/* search652_1_0 -> search2_0 in the cache */
/* search652_1 -> search652_0_0 in the cache */

/* search652_2 -> search27_1 in the cache */
static const nir_search_expression search652 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search652_0.value, &search652_0_0.value, &search27_1.value },
   NULL,
};

   /* replace652_0 -> search2_0 in the cache */
/* replace652 -> search652_0_0 in the cache */

   /* search653_0_0_0 -> search0_0 in the cache */
static const nir_search_expression search653_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ifind_msb,
   { &search0_0.value },
   NULL,
};

/* search653_0_1 -> search26_1 in the cache */
static const nir_search_expression search653_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search653_0_0.value, &search26_1.value },
   NULL,
};

/* search653_1_0 -> search0_0 in the cache */
/* search653_1 -> search653_0_0 in the cache */

/* search653_2 -> search27_1 in the cache */
static const nir_search_expression search653 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search653_0.value, &search653_0_0.value, &search27_1.value },
   NULL,
};

   /* replace653_0 -> search0_0 in the cache */
/* replace653 -> search653_0_0 in the cache */

   /* search654_0_0_0 -> search2_0 in the cache */
static const nir_search_expression search654_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ufind_msb,
   { &search2_0.value },
   NULL,
};

/* search654_0_1 -> search26_1 in the cache */
static const nir_search_expression search654_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search654_0_0.value, &search26_1.value },
   NULL,
};

/* search654_1_0 -> search2_0 in the cache */
/* search654_1 -> search654_0_0 in the cache */

/* search654_2 -> search27_1 in the cache */
static const nir_search_expression search654 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search654_0.value, &search654_0_0.value, &search27_1.value },
   NULL,
};

   /* replace654_0 -> search2_0 in the cache */
/* replace654 -> search654_0_0 in the cache */

   /* search655_0_0 -> search2_0 in the cache */

/* search655_0_1 -> replace9 in the cache */
/* search655_0 -> replace195 in the cache */

/* search655_1_0 -> search2_0 in the cache */
/* search655_1 -> search652_0_0 in the cache */

/* search655_2 -> search27_1 in the cache */
static const nir_search_expression search655 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace195.value, &search652_0_0.value, &search27_1.value },
   NULL,
};

   /* replace655_0 -> search2_0 in the cache */
/* replace655 -> search652_0_0 in the cache */

   /* search656_0_0 -> search0_0 in the cache */

/* search656_0_1 -> search26_1 in the cache */
static const nir_search_expression search656_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* search656_1_0 -> search0_0 in the cache */
/* search656_1 -> search653_0_0 in the cache */

/* search656_2 -> search27_1 in the cache */
static const nir_search_expression search656 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search656_0.value, &search653_0_0.value, &search27_1.value },
   NULL,
};

   /* replace656_0 -> search0_0 in the cache */
/* replace656 -> search653_0_0 in the cache */

   /* search657_0_0 -> search2_0 in the cache */

/* search657_0_1 -> replace9 in the cache */
/* search657_0 -> replace195 in the cache */

/* search657_1_0 -> search2_0 in the cache */
/* search657_1 -> search654_0_0 in the cache */

/* search657_2 -> search27_1 in the cache */
static const nir_search_expression search657 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace195.value, &search654_0_0.value, &search27_1.value },
   NULL,
};

   /* replace657_0 -> search2_0 in the cache */
/* replace657 -> search654_0_0 in the cache */

   /* search658_0_0 -> search0_0 in the cache */

/* search658_0_1 -> search27_1 in the cache */
static const nir_search_expression search658_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search27_1.value },
   NULL,
};

/* search658_1_0 -> search0_0 in the cache */
/* search658_1 -> search653_0_0 in the cache */

/* search658_2 -> search27_1 in the cache */
static const nir_search_expression search658 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &search658_0.value, &search653_0_0.value, &search27_1.value },
   NULL,
};

   /* replace658_0 -> search0_0 in the cache */
/* replace658 -> search653_0_0 in the cache */

   /* search659_0 -> search101_0_0 in the cache */

/* search659_1 -> replace564_1_0 in the cache */
static const nir_search_expression search659 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fmod,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};

   /* replace659_0 -> search101_0_0 in the cache */

/* replace659_1_0 -> replace564_1_0 in the cache */

/* replace659_1_1_0_0 -> search101_0_0 in the cache */

/* replace659_1_1_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace659_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace659_1_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &replace659_1_1_0.value },
   NULL,
};
static const nir_search_expression replace659_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace564_1_0.value, &replace659_1_1.value },
   NULL,
};
static const nir_search_expression replace659 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search101_0_0.value, &replace659_1.value },
   NULL,
};

   /* search660_0 -> search0_0 in the cache */

/* search660_1 -> replace0_1_0 in the cache */
static const nir_search_expression search660 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmod,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace660_0 -> search0_0 in the cache */

/* replace660_1_0 -> replace0_1_0 in the cache */

/* replace660_1_1_0_0 -> search0_0 in the cache */

/* replace660_1_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace660_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace660_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ffloor,
   { &replace660_1_1_0.value },
   NULL,
};
static const nir_search_expression replace660_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace0_1_0.value, &replace660_1_1.value },
   NULL,
};
static const nir_search_expression replace660 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search0_0.value, &replace660_1.value },
   NULL,
};

   /* search661_0 -> search14_0 in the cache */

/* search661_1 -> replace14_1_0 in the cache */
static const nir_search_expression search661 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_frem,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace661_0 -> search14_0 in the cache */

/* replace661_1_0 -> replace14_1_0 in the cache */

/* replace661_1_1_0_0 -> search14_0 in the cache */

/* replace661_1_1_0_1 -> replace14_1_0 in the cache */
/* replace661_1_1_0 -> search478 in the cache */
static const nir_search_expression replace661_1_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_ftrunc,
   { &search478.value },
   NULL,
};
static const nir_search_expression replace661_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace14_1_0.value, &replace661_1_1.value },
   NULL,
};
static const nir_search_expression replace661 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_fsub,
   { &search14_0.value, &replace661_1.value },
   NULL,
};

   /* search662_0 -> search0_0 in the cache */

/* search662_1 -> replace0_1_0 in the cache */
static const nir_search_expression search662 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_uadd_carry,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace662_0_0_0 -> search0_0 in the cache */

/* replace662_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace662_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace662_0_1 -> search0_0 in the cache */
static const nir_search_expression replace662_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace662_0_0.value, &search0_0.value },
   NULL,
};
static const nir_search_expression replace662 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_search_op_b2i,
   { &replace662_0.value },
   NULL,
};

   /* search663_0 -> search0_0 in the cache */

/* search663_1 -> replace0_1_0 in the cache */
static const nir_search_expression search663 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_usub_borrow,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace663_0_0 -> search0_0 in the cache */

/* replace663_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace663_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace663 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_b2i,
   { &replace663_0.value },
   NULL,
};

   static const nir_search_variable search664_0 = {
   { nir_search_value_variable, 32 },
   0, /* base */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search664_1 = {
   { nir_search_value_variable, 32 },
   1, /* insert */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search664_2 = {
   { nir_search_value_variable, 32 },
   2, /* offset */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search664_3 = {
   { nir_search_value_variable, 32 },
   3, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search664 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bitfield_insert,
   { &search664_0.value, &search664_1.value, &search664_2.value, &search664_3.value },
   NULL,
};

   /* replace664_0_0 -> replace106_1_1 in the cache */

/* replace664_0_1 -> search664_3 in the cache */
static const nir_search_expression replace664_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace106_1_1.value, &search664_3.value },
   NULL,
};

/* replace664_1 -> search664_1 in the cache */

/* replace664_2_0_0 -> search664_3 in the cache */

/* replace664_2_0_1 -> search664_2 in the cache */
static const nir_search_expression replace664_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfm,
   { &search664_3.value, &search664_2.value },
   NULL,
};

/* replace664_2_1 -> search664_1 in the cache */

/* replace664_2_2 -> search664_0 in the cache */
static const nir_search_expression replace664_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfi,
   { &replace664_2_0.value, &search664_1.value, &search664_0.value },
   NULL,
};
static const nir_search_expression replace664 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace664_0.value, &search664_1.value, &replace664_2.value },
   NULL,
};

   /* search665_0 -> search14_0 in the cache */

/* search665_1 -> replace14_1_0 in the cache */
static const nir_search_expression search665 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_ihadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace665_0_0 -> search14_0 in the cache */

/* replace665_0_1 -> replace14_1_0 in the cache */
/* replace665_0 -> search429_0 in the cache */

/* replace665_1_0_0 -> search14_0 in the cache */

/* replace665_1_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace665_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   2, 1,
   nir_op_ixor,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace665_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace665_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace665_1_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace665 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search429_0.value, &replace665_1.value },
   NULL,
};

   /* search666_0 -> search14_0 in the cache */

/* search666_1 -> replace14_1_0 in the cache */
static const nir_search_expression search666 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uhadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace666_0_0 -> search14_0 in the cache */

/* replace666_0_1 -> replace14_1_0 in the cache */
/* replace666_0 -> search429_0 in the cache */

/* replace666_1_0_0 -> search14_0 in the cache */

/* replace666_1_0_1 -> replace14_1_0 in the cache */
/* replace666_1_0 -> replace665_1_0 in the cache */

/* replace666_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace666_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace665_1_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace666 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 3,
   nir_op_iadd,
   { &search429_0.value, &replace666_1.value },
   NULL,
};

   /* search667_0 -> search14_0 in the cache */

/* search667_1 -> replace14_1_0 in the cache */
static const nir_search_expression search667 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_irhadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace667_0_0 -> search14_0 in the cache */

/* replace667_0_1 -> replace14_1_0 in the cache */
/* replace667_0 -> search354_0 in the cache */

/* replace667_1_0_0 -> search14_0 in the cache */

/* replace667_1_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace667_1_0 = {
   { nir_search_value_expression, -2 },
   false, false,
   1, 1,
   nir_op_ixor,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace667_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace667_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace667_1_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace667 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search354_0.value, &replace667_1.value },
   NULL,
};

   /* search668_0 -> search14_0 in the cache */

/* search668_1 -> replace14_1_0 in the cache */
static const nir_search_expression search668 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_urhadd,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace668_0_0 -> search14_0 in the cache */

/* replace668_0_1 -> replace14_1_0 in the cache */
/* replace668_0 -> search354_0 in the cache */

/* replace668_1_0_0 -> search14_0 in the cache */

/* replace668_1_0_1 -> replace14_1_0 in the cache */
/* replace668_1_0 -> replace667_1_0 in the cache */

/* replace668_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace668_1 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &replace667_1_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace668 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_isub,
   { &search354_0.value, &replace668_1.value },
   NULL,
};

   /* search669_0 -> search14_0 in the cache */

/* search669_1 -> replace14_1_0 in the cache */
static const nir_search_expression search669 = {
   { nir_search_value_expression, -2 },
   false, false,
   0, 1,
   nir_op_uadd_sat,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace669_0_0_0 -> search14_0 in the cache */

/* replace669_0_0_1 -> replace14_1_0 in the cache */
/* replace669_0_0 -> replace629 in the cache */

/* replace669_0_1 -> search14_0 in the cache */
static const nir_search_expression replace669_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ult,
   { &replace629.value, &search14_0.value },
   NULL,
};

static const nir_search_constant replace669_1 = {
   { nir_search_value_constant, -2 },
   nir_type_int, { -0x1 /* -1 */ },
};

/* replace669_2_0 -> search14_0 in the cache */

/* replace669_2_1 -> replace14_1_0 in the cache */
/* replace669_2 -> search32_1 in the cache */
static const nir_search_expression replace669 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace669_0.value, &replace669_1.value, &search32_1.value },
   NULL,
};

   /* search670_0 -> search14_0 in the cache */

/* search670_1 -> replace14_1_0 in the cache */
static const nir_search_expression search670 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_usub_sat,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

   /* replace670_0_0 -> search14_0 in the cache */

/* replace670_0_1 -> replace14_1_0 in the cache */
/* replace670_0 -> search116_0 in the cache */

/* replace670_1 -> replace187_1 in the cache */

/* replace670_2_0 -> search14_0 in the cache */

/* replace670_2_1 -> replace14_1_0 in the cache */
/* replace670_2 -> search633 in the cache */
static const nir_search_expression replace670 = {
   { nir_search_value_expression, -2 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &search116_0.value, &replace187_1.value, &search633.value },
   NULL,
};

   /* search671_0 -> search664_0 in the cache */

/* search671_1 -> search664_1 in the cache */

/* search671_2 -> search664_2 in the cache */

/* search671_3 -> search664_3 in the cache */
/* search671 -> search664 in the cache */

   /* replace671_0_0 -> replace106_1_1 in the cache */

/* replace671_0_1 -> search664_3 in the cache */
/* replace671_0 -> replace664_0 in the cache */

/* replace671_1 -> search664_1 in the cache */

/* replace671_2_0_0 -> search664_0 in the cache */

/* replace671_2_0_1_0_0_0_0 -> replace579_1 in the cache */

/* replace671_2_0_1_0_0_0_1 -> search664_3 in the cache */
static const nir_search_expression replace671_2_0_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace579_1.value, &search664_3.value },
   NULL,
};

/* replace671_2_0_1_0_0_1 -> replace579_1 in the cache */
static const nir_search_expression replace671_2_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace671_2_0_1_0_0_0.value, &replace579_1.value },
   NULL,
};

/* replace671_2_0_1_0_1 -> search664_2 in the cache */
static const nir_search_expression replace671_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace671_2_0_1_0_0.value, &search664_2.value },
   NULL,
};
static const nir_search_expression replace671_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &replace671_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace671_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iand,
   { &search664_0.value, &replace671_2_0_1.value },
   NULL,
};

/* replace671_2_1_0_0 -> search664_1 in the cache */

/* replace671_2_1_0_1 -> search664_2 in the cache */
static const nir_search_expression replace671_2_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search664_1.value, &search664_2.value },
   NULL,
};

/* replace671_2_1_1_0_0_0 -> replace579_1 in the cache */

/* replace671_2_1_1_0_0_1 -> search664_3 in the cache */
/* replace671_2_1_1_0_0 -> replace671_2_0_1_0_0_0 in the cache */

/* replace671_2_1_1_0_1 -> replace579_1 in the cache */
/* replace671_2_1_1_0 -> replace671_2_0_1_0_0 in the cache */

/* replace671_2_1_1_1 -> search664_2 in the cache */
/* replace671_2_1_1 -> replace671_2_0_1_0 in the cache */
static const nir_search_expression replace671_2_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iand,
   { &replace671_2_1_0.value, &replace671_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace671_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace671_2_0.value, &replace671_2_1.value },
   NULL,
};
static const nir_search_expression replace671 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_bcsel,
   { &replace664_0.value, &search664_1.value, &replace671_2.value },
   NULL,
};

   /* search672_0 -> search664_0 in the cache */

/* search672_1 -> search664_1 in the cache */

/* search672_2 -> search664_2 in the cache */

/* search672_3 -> search664_3 in the cache */
/* search672 -> search664 in the cache */

   /* replace672_0_0 -> replace106_1_1 in the cache */

/* replace672_0_1 -> search664_3 in the cache */
/* replace672_0 -> replace664_0 in the cache */

/* replace672_1 -> search664_1 in the cache */

/* replace672_2_0_0 -> search664_3 in the cache */

/* replace672_2_0_1 -> search664_2 in the cache */
/* replace672_2_0 -> replace664_2_0 in the cache */

/* replace672_2_1_0 -> search664_1 in the cache */

/* replace672_2_1_1 -> search664_2 in the cache */
/* replace672_2_1 -> replace671_2_1_0 in the cache */

/* replace672_2_2 -> search664_0 in the cache */
static const nir_search_expression replace672_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bitfield_select,
   { &replace664_2_0.value, &replace671_2_1_0.value, &search664_0.value },
   NULL,
};
static const nir_search_expression replace672 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace664_0.value, &search664_1.value, &replace672_2.value },
   NULL,
};

   static const nir_search_variable search673_0 = {
   { nir_search_value_variable, 32 },
   0, /* value */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search673_1 = {
   { nir_search_value_variable, 32 },
   1, /* offset */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search673_2 = {
   { nir_search_value_variable, 32 },
   2, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search673 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibitfield_extract,
   { &search673_0.value, &search673_1.value, &search673_2.value },
   NULL,
};

   /* replace673_0_0 -> replace106_1_1 in the cache */

/* replace673_0_1 -> search673_2 in the cache */
static const nir_search_expression replace673_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace106_1_1.value, &search673_2.value },
   NULL,
};

/* replace673_1 -> search673_0 in the cache */

/* replace673_2_0 -> search673_0 in the cache */

/* replace673_2_1 -> search673_1 in the cache */

/* replace673_2_2 -> search673_2 in the cache */
static const nir_search_expression replace673_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ibfe,
   { &search673_0.value, &search673_1.value, &search673_2.value },
   NULL,
};
static const nir_search_expression replace673 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace673_0.value, &search673_0.value, &replace673_2.value },
   NULL,
};

   /* search674_0 -> search673_0 in the cache */

/* search674_1 -> search673_1 in the cache */

/* search674_2 -> search673_2 in the cache */
static const nir_search_expression search674 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubitfield_extract,
   { &search673_0.value, &search673_1.value, &search673_2.value },
   NULL,
};

   /* replace674_0_0 -> replace106_1_1 in the cache */

/* replace674_0_1 -> search673_2 in the cache */
/* replace674_0 -> replace673_0 in the cache */

/* replace674_1 -> search673_0 in the cache */

/* replace674_2_0 -> search673_0 in the cache */

/* replace674_2_1 -> search673_1 in the cache */

/* replace674_2_2 -> search673_2 in the cache */
static const nir_search_expression replace674_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ubfe,
   { &search673_0.value, &search673_1.value, &search673_2.value },
   NULL,
};
static const nir_search_expression replace674 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace673_0.value, &search673_0.value, &replace674_2.value },
   NULL,
};

   /* search675_0 -> search673_0 in the cache */

/* search675_1 -> search673_1 in the cache */

/* search675_2_0 -> replace106_1_1 in the cache */

/* search675_2_1 -> search673_2 in the cache */
static const nir_search_expression search675_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &search673_2.value },
   NULL,
};
static const nir_search_expression search675 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ubfe,
   { &search673_0.value, &search673_1.value, &search675_2.value },
   NULL,
};

   /* replace675_0 -> search673_0 in the cache */

/* replace675_1 -> search673_1 in the cache */

/* replace675_2 -> search673_2 in the cache */
/* replace675 -> replace674_2 in the cache */

   /* search676_0 -> search673_0 in the cache */

/* search676_1_0 -> replace106_1_1 in the cache */

/* search676_1_1 -> search673_1 in the cache */
static const nir_search_expression search676_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &search673_1.value },
   NULL,
};

/* search676_2 -> search673_2 in the cache */
static const nir_search_expression search676 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ubfe,
   { &search673_0.value, &search676_1.value, &search673_2.value },
   NULL,
};

   /* replace676_0 -> search673_0 in the cache */

/* replace676_1 -> search673_1 in the cache */

/* replace676_2 -> search673_2 in the cache */
/* replace676 -> replace674_2 in the cache */

   /* search677_0 -> search673_0 in the cache */

/* search677_1 -> search673_1 in the cache */

/* search677_2_0 -> replace106_1_1 in the cache */

/* search677_2_1 -> search673_2 in the cache */
/* search677_2 -> search675_2 in the cache */
static const nir_search_expression search677 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ibfe,
   { &search673_0.value, &search673_1.value, &search675_2.value },
   NULL,
};

   /* replace677_0 -> search673_0 in the cache */

/* replace677_1 -> search673_1 in the cache */

/* replace677_2 -> search673_2 in the cache */
/* replace677 -> replace673_2 in the cache */

   /* search678_0 -> search673_0 in the cache */

/* search678_1_0 -> replace106_1_1 in the cache */

/* search678_1_1 -> search673_1 in the cache */
/* search678_1 -> search676_1 in the cache */

/* search678_2 -> search673_2 in the cache */
static const nir_search_expression search678 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ibfe,
   { &search673_0.value, &search676_1.value, &search673_2.value },
   NULL,
};

   /* replace678_0 -> search673_0 in the cache */

/* replace678_1 -> search673_1 in the cache */

/* replace678_2 -> search673_2 in the cache */
/* replace678 -> replace673_2 in the cache */

   static const nir_search_variable search679_0 = {
   { nir_search_value_variable, 32 },
   0, /* bits */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search679_1_0 -> replace106_1_1 in the cache */

/* search679_1_1 -> search673_1 in the cache */
/* search679_1 -> search676_1 in the cache */
static const nir_search_expression search679 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bfm,
   { &search679_0.value, &search676_1.value },
   NULL,
};

   /* replace679_0 -> search679_0 in the cache */

/* replace679_1 -> search673_1 in the cache */
static const nir_search_expression replace679 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bfm,
   { &search679_0.value, &search673_1.value },
   NULL,
};

   /* search680_0_0 -> replace106_1_1 in the cache */

/* search680_0_1 -> search679_0 in the cache */
static const nir_search_expression search680_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace106_1_1.value, &search679_0.value },
   NULL,
};

/* search680_1 -> search673_1 in the cache */
static const nir_search_expression search680 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bfm,
   { &search680_0.value, &search673_1.value },
   NULL,
};

   /* replace680_0 -> search679_0 in the cache */

/* replace680_1 -> search673_1 in the cache */
/* replace680 -> replace679 in the cache */

   /* search681_0 -> search673_0 in the cache */

/* search681_1 -> search673_1 in the cache */

/* search681_2 -> search673_2 in the cache */
/* search681 -> search673 in the cache */

   /* replace681_0_0 -> search26_1 in the cache */

/* replace681_0_1 -> search673_2 in the cache */
static const nir_search_expression replace681_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search26_1.value, &search673_2.value },
   NULL,
};

/* replace681_1 -> search26_1 in the cache */

/* replace681_2_0_0 -> search673_0 in the cache */

/* replace681_2_0_1_0_0 -> replace104_0_1 in the cache */

/* replace681_2_0_1_0_1 -> search673_2 in the cache */
static const nir_search_expression replace681_2_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace104_0_1.value, &search673_2.value },
   NULL,
};

/* replace681_2_0_1_1 -> search673_1 in the cache */
static const nir_search_expression replace681_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace681_2_0_1_0.value, &search673_1.value },
   NULL,
};
static const nir_search_expression replace681_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &search673_0.value, &replace681_2_0_1.value },
   NULL,
};

/* replace681_2_1_0 -> replace104_0_1 in the cache */

/* replace681_2_1_1 -> search673_2 in the cache */
/* replace681_2_1 -> replace681_2_0_1_0 in the cache */
static const nir_search_expression replace681_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishr,
   { &replace681_2_0.value, &replace681_2_0_1_0.value },
   NULL,
};
static const nir_search_expression replace681 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace681_0.value, &search26_1.value, &replace681_2.value },
   NULL,
};

   /* search682_0 -> search673_0 in the cache */

/* search682_1 -> search673_1 in the cache */

/* search682_2 -> search673_2 in the cache */
/* search682 -> search674 in the cache */

   /* replace682_0_0 -> search673_0 in the cache */

/* replace682_0_1 -> search673_1 in the cache */
static const nir_search_expression replace682_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ushr,
   { &search673_0.value, &search673_1.value },
   NULL,
};

/* replace682_1_0_0 -> search673_2 in the cache */

/* replace682_1_0_1 -> replace104_0_1 in the cache */
static const nir_search_expression replace682_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search673_2.value, &replace104_0_1.value },
   NULL,
};

/* replace682_1_1 -> replace104_0_0_0_1 in the cache */

/* replace682_1_2_0_0 -> replace579_1 in the cache */

/* replace682_1_2_0_1 -> search673_2 in the cache */
static const nir_search_expression replace682_1_2_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ishl,
   { &replace579_1.value, &search673_2.value },
   NULL,
};

/* replace682_1_2_1 -> replace579_1 in the cache */
static const nir_search_expression replace682_1_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace682_1_2_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace682_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_bcsel,
   { &replace682_1_0.value, &replace104_0_0_0_1.value, &replace682_1_2.value },
   NULL,
};
static const nir_search_expression replace682 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace682_0.value, &replace682_1.value },
   NULL,
};

   /* search683_0 -> search673_0 in the cache */
static const nir_search_expression search683 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ifind_msb,
   { &search673_0.value },
   NULL,
};

   /* replace683_0_0_0 -> search673_0 in the cache */

/* replace683_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace683_0_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search673_0.value, &search26_1.value },
   NULL,
};

/* replace683_0_1_0 -> search673_0 in the cache */
static const nir_search_expression replace683_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_inot,
   { &search673_0.value },
   NULL,
};

/* replace683_0_2 -> search673_0 in the cache */
static const nir_search_expression replace683_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace683_0_0.value, &replace683_0_1.value, &search673_0.value },
   NULL,
};
static const nir_search_expression replace683 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_ufind_msb,
   { &replace683_0.value },
   NULL,
};

   static const nir_search_variable search684_0 = {
   { nir_search_value_variable, -1 },
   0, /* value */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search684 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_find_lsb,
   { &search684_0.value },
   NULL,
};

   /* replace684_0_0 -> search684_0 in the cache */

/* replace684_0_1_0 -> search684_0 in the cache */
static const nir_search_expression replace684_0_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_ineg,
   { &search684_0.value },
   NULL,
};
static const nir_search_expression replace684_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search684_0.value, &replace684_0_1.value },
   NULL,
};
static const nir_search_expression replace684 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ufind_msb,
   { &replace684_0.value },
   NULL,
};

   /* search685_0 -> search0_0 in the cache */

/* search685_1 -> replace0_1_0 in the cache */
static const nir_search_expression search685 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace685_0_0 -> search0_0 in the cache */

/* replace685_0_1_0_0 -> replace566_1 in the cache */

/* replace685_0_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace685_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace566_1.value, &replace0_1_0.value },
   NULL,
};

/* replace685_0_1_1 -> replace98_0_1 in the cache */
static const nir_search_expression replace685_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace685_0_1_0.value, &replace98_0_1.value },
   NULL,
};
static const nir_search_expression replace685_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &replace685_0_1.value },
   NULL,
};

/* replace685_1 -> search441_1_1 in the cache */
static const nir_search_expression replace685 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace685_0.value, &search441_1_1.value },
   NULL,
};

   /* search686_0 -> search0_0 in the cache */

/* search686_1 -> replace0_1_0 in the cache */
static const nir_search_expression search686 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace686_0_0 -> search0_0 in the cache */

/* replace686_0_1_0 -> replace0_1_0 in the cache */

/* replace686_0_1_1 -> replace98_0_1 in the cache */
static const nir_search_expression replace686_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul,
   { &replace0_1_0.value, &replace98_0_1.value },
   NULL,
};
static const nir_search_expression replace686_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &replace686_0_1.value },
   NULL,
};

/* replace686_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace686 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace686_0.value, &replace98_0_0_0_1.value },
   NULL,
};

   /* search687_0 -> search0_0 in the cache */

/* search687_1 -> replace0_1_0 in the cache */
static const nir_search_expression search687 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace687_0_0 -> search0_0 in the cache */

/* replace687_0_1_0_0 -> replace579_1 in the cache */

/* replace687_0_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace687_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &replace579_1.value, &replace0_1_0.value },
   NULL,
};

/* replace687_0_1_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace687_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_imul,
   { &replace687_0_1_0.value, &replace101_0_1.value },
   NULL,
};
static const nir_search_expression replace687_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishl,
   { &search0_0.value, &replace687_0_1.value },
   NULL,
};

/* replace687_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace687 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ishr,
   { &replace687_0.value, &replace101_0_1.value },
   NULL,
};

   /* search688_0 -> search0_0 in the cache */

/* search688_1 -> replace0_1_0 in the cache */
static const nir_search_expression search688 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace688_0_0 -> search0_0 in the cache */

/* replace688_0_1_0 -> replace0_1_0 in the cache */

/* replace688_0_1_1 -> replace101_0_1 in the cache */
static const nir_search_expression replace688_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_imul,
   { &replace0_1_0.value, &replace101_0_1.value },
   NULL,
};
static const nir_search_expression replace688_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_ushr,
   { &search0_0.value, &replace688_0_1.value },
   NULL,
};

/* replace688_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace688 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace688_0.value, &replace101_0_0_0_1.value },
   NULL,
};

   static const nir_search_variable search689_0 = {
   { nir_search_value_variable, 32 },
   0, /* v */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search689 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_unorm_2x16,
   { &search689_0.value },
   NULL,
};

   /* replace689_0_0_0_0_0 -> search689_0 in the cache */
static const nir_search_expression replace689_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fsat,
   { &search689_0.value },
   NULL,
};

static const nir_search_constant replace689_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x40efffe000000000 /* 65535.0 */ },
};
static const nir_search_expression replace689_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace689_0_0_0_0.value, &replace689_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace689_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace689_0_0_0.value },
   NULL,
};
static const nir_search_expression replace689_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2u32,
   { &replace689_0_0.value },
   NULL,
};
static const nir_search_expression replace689 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec2_to_uint,
   { &replace689_0.value },
   NULL,
};

   /* search690_0 -> search689_0 in the cache */
static const nir_search_expression search690 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_unorm_4x8,
   { &search689_0.value },
   NULL,
};

   /* replace690_0_0_0_0_0 -> search689_0 in the cache */
/* replace690_0_0_0_0 -> replace689_0_0_0_0 in the cache */

static const nir_search_constant replace690_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x406fe00000000000 /* 255.0 */ },
};
static const nir_search_expression replace690_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace689_0_0_0_0.value, &replace690_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace690_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace690_0_0_0.value },
   NULL,
};
static const nir_search_expression replace690_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2u32,
   { &replace690_0_0.value },
   NULL,
};
static const nir_search_expression replace690 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec4_to_uint,
   { &replace690_0.value },
   NULL,
};

   /* search691_0 -> search689_0 in the cache */
static const nir_search_expression search691 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_snorm_2x16,
   { &search689_0.value },
   NULL,
};

   /* replace691_0_0_0_0_0 -> replace60_0_0 in the cache */

/* replace691_0_0_0_0_1_0 -> search495_1 in the cache */

/* replace691_0_0_0_0_1_1 -> search689_0 in the cache */
static const nir_search_expression replace691_0_0_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search495_1.value, &search689_0.value },
   NULL,
};
static const nir_search_expression replace691_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace60_0_0.value, &replace691_0_0_0_0_1.value },
   NULL,
};

static const nir_search_constant replace691_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x40dfffc000000000 /* 32767.0 */ },
};
static const nir_search_expression replace691_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace691_0_0_0_0.value, &replace691_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace691_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace691_0_0_0.value },
   NULL,
};
static const nir_search_expression replace691_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2i32,
   { &replace691_0_0.value },
   NULL,
};
static const nir_search_expression replace691 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec2_to_uint,
   { &replace691_0.value },
   NULL,
};

   /* search692_0 -> search689_0 in the cache */
static const nir_search_expression search692 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_pack_snorm_4x8,
   { &search689_0.value },
   NULL,
};

   /* replace692_0_0_0_0_0 -> replace60_0_0 in the cache */

/* replace692_0_0_0_0_1_0 -> search495_1 in the cache */

/* replace692_0_0_0_0_1_1 -> search689_0 in the cache */
/* replace692_0_0_0_0_1 -> replace691_0_0_0_0_1 in the cache */
/* replace692_0_0_0_0 -> replace691_0_0_0_0 in the cache */

static const nir_search_constant replace692_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_float, { 0x405fc00000000000 /* 127.0 */ },
};
static const nir_search_expression replace692_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_fmul,
   { &replace691_0_0_0_0.value, &replace692_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace692_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_fround_even,
   { &replace692_0_0_0.value },
   NULL,
};
static const nir_search_expression replace692_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_f2i32,
   { &replace692_0_0.value },
   NULL,
};
static const nir_search_expression replace692 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 1,
   nir_op_pack_uvec4_to_uint,
   { &replace692_0.value },
   NULL,
};

   /* search693_0 -> search689_0 in the cache */
static const nir_search_expression search693 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_unorm_2x16,
   { &search689_0.value },
   NULL,
};

   /* replace693_0_0_0_0 -> search689_0 in the cache */

/* replace693_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace693_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search689_0.value, &search26_1.value },
   NULL,
};

/* replace693_0_0_1_0 -> search689_0 in the cache */

/* replace693_0_0_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace693_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u16,
   { &search689_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace693_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &replace693_0_0_0.value, &replace693_0_0_1.value },
   NULL,
};
static const nir_search_expression replace693_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &replace693_0_0.value },
   NULL,
};

/* replace693_1 -> replace689_0_0_0_1 in the cache */
static const nir_search_expression replace693 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace693_0.value, &replace689_0_0_0_1.value },
   NULL,
};

   /* search694_0 -> search689_0 in the cache */
static const nir_search_expression search694 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_unorm_4x8,
   { &search689_0.value },
   NULL,
};

   /* replace694_0_0_0_0 -> search689_0 in the cache */

/* replace694_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace694_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search689_0.value, &search26_1.value },
   NULL,
};

/* replace694_0_0_1_0 -> search689_0 in the cache */

/* replace694_0_0_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace694_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search689_0.value, &replace579_1.value },
   NULL,
};

/* replace694_0_0_2_0 -> search689_0 in the cache */

/* replace694_0_0_2_1 -> replace580_1 in the cache */
static const nir_search_expression replace694_0_0_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search689_0.value, &replace580_1.value },
   NULL,
};

/* replace694_0_0_3_0 -> search689_0 in the cache */

/* replace694_0_0_3_1 -> replace566_1 in the cache */
static const nir_search_expression replace694_0_0_3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_u8,
   { &search689_0.value, &replace566_1.value },
   NULL,
};
static const nir_search_expression replace694_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace694_0_0_0.value, &replace694_0_0_1.value, &replace694_0_0_2.value, &replace694_0_0_3.value },
   NULL,
};
static const nir_search_expression replace694_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2f32,
   { &replace694_0_0.value },
   NULL,
};

/* replace694_1 -> replace690_0_0_0_1 in the cache */
static const nir_search_expression replace694 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace694_0.value, &replace690_0_0_0_1.value },
   NULL,
};

   /* search695_0 -> search689_0 in the cache */
static const nir_search_expression search695 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_snorm_2x16,
   { &search689_0.value },
   NULL,
};

   /* replace695_0 -> replace60_0_0 in the cache */

/* replace695_1_0 -> search495_1 in the cache */

/* replace695_1_1_0_0_0_0 -> search689_0 in the cache */

/* replace695_1_1_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace695_1_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search689_0.value, &search26_1.value },
   NULL,
};

/* replace695_1_1_0_0_1_0 -> search689_0 in the cache */

/* replace695_1_1_0_0_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace695_1_1_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i16,
   { &search689_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace695_1_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec2,
   { &replace695_1_1_0_0_0.value, &replace695_1_1_0_0_1.value },
   NULL,
};
static const nir_search_expression replace695_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &replace695_1_1_0_0.value },
   NULL,
};

/* replace695_1_1_1 -> replace691_0_0_0_1 in the cache */
static const nir_search_expression replace695_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace695_1_1_0.value, &replace691_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace695_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search495_1.value, &replace695_1_1.value },
   NULL,
};
static const nir_search_expression replace695 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace60_0_0.value, &replace695_1.value },
   NULL,
};

   /* search696_0 -> search689_0 in the cache */
static const nir_search_expression search696 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_unpack_snorm_4x8,
   { &search689_0.value },
   NULL,
};

   /* replace696_0 -> replace60_0_0 in the cache */

/* replace696_1_0 -> search495_1 in the cache */

/* replace696_1_1_0_0_0_0 -> search689_0 in the cache */

/* replace696_1_1_0_0_0_1 -> search26_1 in the cache */
static const nir_search_expression replace696_1_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search689_0.value, &search26_1.value },
   NULL,
};

/* replace696_1_1_0_0_1_0 -> search689_0 in the cache */

/* replace696_1_1_0_0_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace696_1_1_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search689_0.value, &replace579_1.value },
   NULL,
};

/* replace696_1_1_0_0_2_0 -> search689_0 in the cache */

/* replace696_1_1_0_0_2_1 -> replace580_1 in the cache */
static const nir_search_expression replace696_1_1_0_0_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search689_0.value, &replace580_1.value },
   NULL,
};

/* replace696_1_1_0_0_3_0 -> search689_0 in the cache */

/* replace696_1_1_0_0_3_1 -> replace566_1 in the cache */
static const nir_search_expression replace696_1_1_0_0_3 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_extract_i8,
   { &search689_0.value, &replace566_1.value },
   NULL,
};
static const nir_search_expression replace696_1_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_vec4,
   { &replace696_1_1_0_0_0.value, &replace696_1_1_0_0_1.value, &replace696_1_1_0_0_2.value, &replace696_1_1_0_0_3.value },
   NULL,
};
static const nir_search_expression replace696_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &replace696_1_1_0_0.value },
   NULL,
};

/* replace696_1_1_1 -> replace692_0_0_0_1 in the cache */
static const nir_search_expression replace696_1_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fdiv,
   { &replace696_1_1_0.value, &replace692_0_0_0_1.value },
   NULL,
};
static const nir_search_expression replace696_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmax,
   { &search495_1.value, &replace696_1_1.value },
   NULL,
};
static const nir_search_expression replace696 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_fmin,
   { &replace60_0_0.value, &replace696_1.value },
   NULL,
};

   /* search697_0 -> search2_0 in the cache */
static const nir_search_expression search697 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_isign,
   { &search2_0.value },
   NULL,
};

   /* replace697_0_0 -> search2_0 in the cache */

/* replace697_0_1 -> search44_1 in the cache */
static const nir_search_expression replace697_0 = {
   { nir_search_value_expression, -1 },
   false, false,
   1, 1,
   nir_op_imax,
   { &search2_0.value, &search44_1.value },
   NULL,
};

/* replace697_1 -> replace2_1_0 in the cache */
static const nir_search_expression replace697 = {
   { nir_search_value_expression, -1 },
   false, false,
   0, 2,
   nir_op_imin,
   { &replace697_0.value, &replace2_1_0.value },
   NULL,
};

   /* search698_0 -> search2_0 in the cache */
/* search698 -> search45_0 in the cache */

   /* replace698_0_0_0 -> search24_1 in the cache */

/* replace698_0_0_1 -> search2_0 in the cache */
/* replace698_0_0 -> replace145 in the cache */
/* replace698_0 -> replace267 in the cache */

/* replace698_1_0_0 -> search2_0 in the cache */

/* replace698_1_0_1 -> search24_1 in the cache */
/* replace698_1_0 -> replace65_0 in the cache */
static const nir_search_expression replace698_1 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &replace65_0.value },
   NULL,
};
static const nir_search_expression replace698 = {
   { nir_search_value_expression, -1 },
   false, false,
   -1, 0,
   nir_op_fsub,
   { &replace267.value, &replace698_1.value },
   NULL,
};

   /* search699_0 -> search98_0_0 in the cache */

static const nir_search_variable search699_1 = {
   { nir_search_value_variable, 8 },
   1, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search699 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};

   /* replace699_0_0 -> search699_1 in the cache */

static const nir_search_constant replace699_0_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x1 /* 1 */ },
};
static const nir_search_expression replace699_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search699_1.value, &replace699_0_1.value },
   NULL,
};

/* replace699_1_0_0_0 -> search98_0_0 in the cache */

/* replace699_1_0_0_1 -> search699_1 in the cache */
static const nir_search_expression replace699_1_0_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};

/* replace699_1_0_1 -> search98_0_0 in the cache */
static const nir_search_expression replace699_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace699_1_0_0.value, &search98_0_0.value },
   NULL,
};

static const nir_search_constant replace699_1_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace699_1_2_0 -> search98_0_0 in the cache */

/* replace699_1_2_1 -> search699_1 in the cache */
static const nir_search_expression replace699_1_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace699_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace699_1_0.value, &replace699_1_1.value, &replace699_1_2.value },
   NULL,
};

/* replace699_2_0_0 -> search98_0_0 in the cache */

/* replace699_2_0_1_0 -> search98_0_0 in the cache */

/* replace699_2_0_1_1 -> search699_1 in the cache */
static const nir_search_expression replace699_2_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace699_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search98_0_0.value, &replace699_2_0_1.value },
   NULL,
};

static const nir_search_constant replace699_2_1 = {
   { nir_search_value_constant, 8 },
   nir_type_int, { 0x80 /* 128 */ },
};

/* replace699_2_2_0 -> search98_0_0 in the cache */

/* replace699_2_2_1 -> search699_1 in the cache */
static const nir_search_expression replace699_2_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace699_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace699_2_0.value, &replace699_2_1.value, &replace699_2_2.value },
   NULL,
};
static const nir_search_expression replace699 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace699_0.value, &replace699_1.value, &replace699_2.value },
   NULL,
};

   /* search700_0 -> search98_0_0 in the cache */

/* search700_1 -> search699_1 in the cache */
static const nir_search_expression search700 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};

   /* replace700_0_0 -> search699_1 in the cache */

/* replace700_0_1 -> replace98_2 in the cache */
static const nir_search_expression replace700_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search699_1.value, &replace98_2.value },
   NULL,
};

/* replace700_1_0_0_0 -> search98_0_0 in the cache */

/* replace700_1_0_0_1 -> search699_1 in the cache */
static const nir_search_expression replace700_1_0_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search98_0_0.value, &search699_1.value },
   NULL,
};

/* replace700_1_0_1 -> search98_0_0 in the cache */
static const nir_search_expression replace700_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace700_1_0_0.value, &search98_0_0.value },
   NULL,
};

/* replace700_1_1 -> replace699_1_1 in the cache */

/* replace700_1_2_0 -> search98_0_0 in the cache */

/* replace700_1_2_1 -> search699_1 in the cache */
/* replace700_1_2 -> replace700_1_0_0 in the cache */
static const nir_search_expression replace700_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace700_1_0.value, &replace699_1_1.value, &replace700_1_0_0.value },
   NULL,
};

/* replace700_2_0_0 -> search98_0_0 in the cache */

/* replace700_2_0_1_0 -> search98_0_0 in the cache */

/* replace700_2_0_1_1 -> search699_1 in the cache */
/* replace700_2_0_1 -> replace700_1_0_0 in the cache */
static const nir_search_expression replace700_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace700_1_0_0.value },
   NULL,
};

/* replace700_2_1 -> replace699_2_1 in the cache */

/* replace700_2_2_0 -> search98_0_0 in the cache */

/* replace700_2_2_1 -> search699_1 in the cache */
/* replace700_2_2 -> replace700_1_0_0 in the cache */
static const nir_search_expression replace700_2 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace700_2_0.value, &replace699_2_1.value, &replace700_1_0_0.value },
   NULL,
};
static const nir_search_expression replace700 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace700_0.value, &replace700_1.value, &replace700_2.value },
   NULL,
};

   /* search701_0 -> search101_0_0 in the cache */

/* search701_1 -> replace564_1_0 in the cache */
static const nir_search_expression search701 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};

   /* replace701_0_0 -> replace564_1_0 in the cache */

/* replace701_0_1 -> replace565_1 in the cache */
static const nir_search_expression replace701_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace564_1_0.value, &replace565_1.value },
   NULL,
};

/* replace701_1_0_0_0 -> search101_0_0 in the cache */

/* replace701_1_0_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace701_1_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace701_1_0_1 -> search101_0_0 in the cache */
static const nir_search_expression replace701_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace701_1_0_0.value, &search101_0_0.value },
   NULL,
};

static const nir_search_constant replace701_1_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x7fff /* 32767 */ },
};

/* replace701_1_2_0 -> search101_0_0 in the cache */

/* replace701_1_2_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace701_1_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace701_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace701_1_0.value, &replace701_1_1.value, &replace701_1_2.value },
   NULL,
};

/* replace701_2_0_0 -> search101_0_0 in the cache */

/* replace701_2_0_1_0 -> search101_0_0 in the cache */

/* replace701_2_0_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace701_2_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace701_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search101_0_0.value, &replace701_2_0_1.value },
   NULL,
};

static const nir_search_constant replace701_2_1 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x8000 /* 32768 */ },
};

/* replace701_2_2_0 -> search101_0_0 in the cache */

/* replace701_2_2_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace701_2_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace701_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace701_2_0.value, &replace701_2_1.value, &replace701_2_2.value },
   NULL,
};
static const nir_search_expression replace701 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace701_0.value, &replace701_1.value, &replace701_2.value },
   NULL,
};

   /* search702_0 -> search101_0_0 in the cache */

/* search702_1 -> replace564_1_0 in the cache */
static const nir_search_expression search702 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};

   /* replace702_0_0 -> replace564_1_0 in the cache */

/* replace702_0_1 -> replace101_2 in the cache */
static const nir_search_expression replace702_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace564_1_0.value, &replace101_2.value },
   NULL,
};

/* replace702_1_0_0_0 -> search101_0_0 in the cache */

/* replace702_1_0_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace702_1_0_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search101_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace702_1_0_1 -> search101_0_0 in the cache */
static const nir_search_expression replace702_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace702_1_0_0.value, &search101_0_0.value },
   NULL,
};

/* replace702_1_1 -> replace701_1_1 in the cache */

/* replace702_1_2_0 -> search101_0_0 in the cache */

/* replace702_1_2_1 -> replace564_1_0 in the cache */
/* replace702_1_2 -> replace702_1_0_0 in the cache */
static const nir_search_expression replace702_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace702_1_0.value, &replace701_1_1.value, &replace702_1_0_0.value },
   NULL,
};

/* replace702_2_0_0 -> search101_0_0 in the cache */

/* replace702_2_0_1_0 -> search101_0_0 in the cache */

/* replace702_2_0_1_1 -> replace564_1_0 in the cache */
/* replace702_2_0_1 -> replace702_1_0_0 in the cache */
static const nir_search_expression replace702_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace702_1_0_0.value },
   NULL,
};

/* replace702_2_1 -> replace701_2_1 in the cache */

/* replace702_2_2_0 -> search101_0_0 in the cache */

/* replace702_2_2_1 -> replace564_1_0 in the cache */
/* replace702_2_2 -> replace702_1_0_0 in the cache */
static const nir_search_expression replace702_2 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace702_2_0.value, &replace701_2_1.value, &replace702_1_0_0.value },
   NULL,
};
static const nir_search_expression replace702 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace702_0.value, &replace702_1.value, &replace702_2.value },
   NULL,
};

   /* search703_0 -> search0_0 in the cache */

/* search703_1 -> replace0_1_0 in the cache */
static const nir_search_expression search703 = {
   { nir_search_value_expression, 32 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace703_0_0 -> replace0_1_0 in the cache */

/* replace703_0_1 -> replace579_1 in the cache */
static const nir_search_expression replace703_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace0_1_0.value, &replace579_1.value },
   NULL,
};

/* replace703_1_0_0_0 -> search0_0 in the cache */

/* replace703_1_0_0_1 -> replace0_1_0 in the cache */
/* replace703_1_0_0 -> replace662_0_0 in the cache */

/* replace703_1_0_1 -> search0_0 in the cache */
static const nir_search_expression replace703_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace662_0_0.value, &search0_0.value },
   NULL,
};

static const nir_search_constant replace703_1_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7fffffff /* 2147483647 */ },
};

/* replace703_1_2_0 -> search0_0 in the cache */

/* replace703_1_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace703_1_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace703_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace703_1_0.value, &replace703_1_1.value, &replace703_1_2.value },
   NULL,
};

/* replace703_2_0_0 -> search0_0 in the cache */

/* replace703_2_0_1_0 -> search0_0 in the cache */

/* replace703_2_0_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace703_2_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace703_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search0_0.value, &replace703_2_0_1.value },
   NULL,
};

/* replace703_2_1 -> replace323_1_1 in the cache */

/* replace703_2_2_0 -> search0_0 in the cache */

/* replace703_2_2_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace703_2_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace703_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace703_2_0.value, &replace323_1_1.value, &replace703_2_2.value },
   NULL,
};
static const nir_search_expression replace703 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace703_0.value, &replace703_1.value, &replace703_2.value },
   NULL,
};

   /* search704_0 -> search0_0 in the cache */

/* search704_1 -> replace0_1_0 in the cache */
static const nir_search_expression search704 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

   /* replace704_0_0 -> replace0_1_0 in the cache */

/* replace704_0_1 -> search26_1 in the cache */
static const nir_search_expression replace704_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace0_1_0.value, &search26_1.value },
   NULL,
};

/* replace704_1_0_0_0 -> search0_0 in the cache */

/* replace704_1_0_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace704_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace704_1_0_1 -> search0_0 in the cache */
static const nir_search_expression replace704_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace704_1_0_0.value, &search0_0.value },
   NULL,
};

/* replace704_1_1 -> replace703_1_1 in the cache */

/* replace704_1_2_0 -> search0_0 in the cache */

/* replace704_1_2_1 -> replace0_1_0 in the cache */
/* replace704_1_2 -> replace704_1_0_0 in the cache */
static const nir_search_expression replace704_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace704_1_0.value, &replace703_1_1.value, &replace704_1_0_0.value },
   NULL,
};

/* replace704_2_0_0 -> search0_0 in the cache */

/* replace704_2_0_1_0 -> search0_0 in the cache */

/* replace704_2_0_1_1 -> replace0_1_0 in the cache */
/* replace704_2_0_1 -> replace704_1_0_0 in the cache */
static const nir_search_expression replace704_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace704_1_0_0.value },
   NULL,
};

/* replace704_2_1 -> replace323_1_1 in the cache */

/* replace704_2_2_0 -> search0_0 in the cache */

/* replace704_2_2_1 -> replace0_1_0 in the cache */
/* replace704_2_2 -> replace704_1_0_0 in the cache */
static const nir_search_expression replace704_2 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace704_2_0.value, &replace323_1_1.value, &replace704_1_0_0.value },
   NULL,
};
static const nir_search_expression replace704 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace704_0.value, &replace704_1.value, &replace704_2.value },
   NULL,
};

   /* search705_0 -> search57_0 in the cache */

/* search705_1 -> search57_1_1 in the cache */
static const nir_search_expression search705 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd_sat,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace705_0_0 -> search57_1_1 in the cache */

/* replace705_0_1 -> replace582_1 in the cache */
static const nir_search_expression replace705_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_1_1.value, &replace582_1.value },
   NULL,
};

/* replace705_1_0_0_0 -> search57_0 in the cache */

/* replace705_1_0_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace705_1_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   0, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace705_1_0_1 -> search57_0 in the cache */
static const nir_search_expression replace705_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &replace705_1_0_0.value, &search57_0.value },
   NULL,
};

static const nir_search_constant replace705_1_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fffffffffffffffL /* 9223372036854775807 */ },
};

/* replace705_1_2_0 -> search57_0 in the cache */

/* replace705_1_2_1 -> search57_1_1 in the cache */
static const nir_search_expression replace705_1_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   1, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace705_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace705_1_0.value, &replace705_1_1.value, &replace705_1_2.value },
   NULL,
};

/* replace705_2_0_0 -> search57_0 in the cache */

/* replace705_2_0_1_0 -> search57_0 in the cache */

/* replace705_2_0_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace705_2_0_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   2, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace705_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_ilt,
   { &search57_0.value, &replace705_2_0_1.value },
   NULL,
};

static const nir_search_constant replace705_2_1 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x8000000000000000L /* 9223372036854775808 */ },
};

/* replace705_2_2_0 -> search57_0 in the cache */

/* replace705_2_2_1 -> search57_1_1 in the cache */
static const nir_search_expression replace705_2_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   3, 1,
   nir_op_iadd,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace705_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 2,
   nir_op_bcsel,
   { &replace705_2_0.value, &replace705_2_1.value, &replace705_2_2.value },
   NULL,
};
static const nir_search_expression replace705 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 4,
   nir_op_bcsel,
   { &replace705_0.value, &replace705_1.value, &replace705_2.value },
   NULL,
};

   /* search706_0 -> search57_0 in the cache */

/* search706_1 -> search57_1_1 in the cache */
static const nir_search_expression search706 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_isub_sat,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

   /* replace706_0_0 -> search57_1_1 in the cache */

/* replace706_0_1 -> replace107_2 in the cache */
static const nir_search_expression replace706_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_1_1.value, &replace107_2.value },
   NULL,
};

/* replace706_1_0_0_0 -> search57_0 in the cache */

/* replace706_1_0_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace706_1_0_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_isub,
   { &search57_0.value, &search57_1_1.value },
   NULL,
};

/* replace706_1_0_1 -> search57_0 in the cache */
static const nir_search_expression replace706_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace706_1_0_0.value, &search57_0.value },
   NULL,
};

/* replace706_1_1 -> replace705_1_1 in the cache */

/* replace706_1_2_0 -> search57_0 in the cache */

/* replace706_1_2_1 -> search57_1_1 in the cache */
/* replace706_1_2 -> replace706_1_0_0 in the cache */
static const nir_search_expression replace706_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace706_1_0.value, &replace705_1_1.value, &replace706_1_0_0.value },
   NULL,
};

/* replace706_2_0_0 -> search57_0 in the cache */

/* replace706_2_0_1_0 -> search57_0 in the cache */

/* replace706_2_0_1_1 -> search57_1_1 in the cache */
/* replace706_2_0_1 -> replace706_1_0_0 in the cache */
static const nir_search_expression replace706_2_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace706_1_0_0.value },
   NULL,
};

/* replace706_2_1 -> replace705_2_1 in the cache */

/* replace706_2_2_0 -> search57_0 in the cache */

/* replace706_2_2_1 -> search57_1_1 in the cache */
/* replace706_2_2 -> replace706_1_0_0 in the cache */
static const nir_search_expression replace706_2 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace706_2_0.value, &replace705_2_1.value, &replace706_1_0_0.value },
   NULL,
};
static const nir_search_expression replace706 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_bcsel,
   { &replace706_0.value, &replace706_1.value, &replace706_2.value },
   NULL,
};

   /* search707_0_0_0 -> search14_0 in the cache */

/* search707_0_0_1 -> replace14_1_0 in the cache */
/* search707_0_0 -> search121_0 in the cache */

/* search707_0_1_0 -> search62_1_1 in the cache */

/* search707_0_1_1 -> search62_2 in the cache */
static const nir_search_expression search707_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_feq,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search707_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search121_0.value, &search707_0_1.value },
   (is_used_once),
};
static const nir_search_expression search707 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search707_0.value },
   NULL,
};

   /* replace707_0_0 -> search14_0 in the cache */

/* replace707_0_1 -> replace14_1_0 in the cache */
static const nir_search_expression replace707_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_fne,
   { &search14_0.value, &replace14_1_0.value },
   NULL,
};

/* replace707_1_0 -> search62_1_1 in the cache */

/* replace707_1_1 -> search62_2 in the cache */
static const nir_search_expression replace707_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_fne,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression replace707 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace707_0.value, &replace707_1.value },
   NULL,
};

   /* search708_0_0_0 -> search14_0 in the cache */

/* search708_0_0_1 -> replace14_1_0 in the cache */
/* search708_0_0 -> search121_0 in the cache */

/* search708_0_1_0 -> search62_1_1 in the cache */

/* search708_0_1_1 -> search62_2 in the cache */
/* search708_0_1 -> search707_0_1 in the cache */
static const nir_search_expression search708_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search121_0.value, &search707_0_1.value },
   (is_used_once),
};
static const nir_search_expression search708 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search708_0.value },
   NULL,
};

   /* replace708_0_0 -> search14_0 in the cache */

/* replace708_0_1 -> replace14_1_0 in the cache */
/* replace708_0 -> replace707_0 in the cache */

/* replace708_1_0 -> search62_1_1 in the cache */

/* replace708_1_1 -> search62_2 in the cache */
/* replace708_1 -> replace707_1 in the cache */
static const nir_search_expression replace708 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace707_0.value, &replace707_1.value },
   NULL,
};

   /* search709_0_0_0 -> search14_0 in the cache */

/* search709_0_0_1 -> replace14_1_0 in the cache */
/* search709_0_0 -> search121_0 in the cache */

/* search709_0_1_0 -> search62_1_1 in the cache */

/* search709_0_1_1 -> search62_2 in the cache */
/* search709_0_1 -> replace707_1 in the cache */
static const nir_search_expression search709_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search121_0.value, &replace707_1.value },
   (is_used_once),
};
static const nir_search_expression search709 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search709_0.value },
   NULL,
};

   /* replace709_0_0 -> search14_0 in the cache */

/* replace709_0_1 -> replace14_1_0 in the cache */
/* replace709_0 -> replace707_0 in the cache */

/* replace709_1_0 -> search62_1_1 in the cache */

/* replace709_1_1 -> search62_2 in the cache */
/* replace709_1 -> search707_0_1 in the cache */
static const nir_search_expression replace709 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace707_0.value, &search707_0_1.value },
   NULL,
};

   /* search710_0_0_0 -> search14_0 in the cache */

/* search710_0_0_1 -> replace14_1_0 in the cache */
/* search710_0_0 -> search121_0 in the cache */

/* search710_0_1_0 -> search62_1_1 in the cache */

/* search710_0_1_1 -> search62_2 in the cache */
/* search710_0_1 -> replace707_1 in the cache */
static const nir_search_expression search710_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search121_0.value, &replace707_1.value },
   (is_used_once),
};
static const nir_search_expression search710 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search710_0.value },
   NULL,
};

   /* replace710_0_0 -> search14_0 in the cache */

/* replace710_0_1 -> replace14_1_0 in the cache */
/* replace710_0 -> replace707_0 in the cache */

/* replace710_1_0 -> search62_1_1 in the cache */

/* replace710_1_1 -> search62_2 in the cache */
/* replace710_1 -> search707_0_1 in the cache */
static const nir_search_expression replace710 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace707_0.value, &search707_0_1.value },
   NULL,
};

   /* search711_0_0_0 -> search14_0 in the cache */

/* search711_0_0_1 -> replace14_1_0 in the cache */
/* search711_0_0 -> search121_0 in the cache */

/* search711_0_1_0 -> search62_1_1 in the cache */

/* search711_0_1_1 -> search62_2 in the cache */
static const nir_search_expression search711_0_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression search711_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search121_0.value, &search711_0_1.value },
   (is_used_once),
};
static const nir_search_expression search711 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search711_0.value },
   NULL,
};

   /* replace711_0_0 -> search14_0 in the cache */

/* replace711_0_1 -> replace14_1_0 in the cache */
/* replace711_0 -> replace707_0 in the cache */

/* replace711_1_0 -> search62_1_1 in the cache */

/* replace711_1_1 -> search62_2 in the cache */
static const nir_search_expression replace711_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search62_1_1.value, &search62_2.value },
   NULL,
};
static const nir_search_expression replace711 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace707_0.value, &replace711_1.value },
   NULL,
};

   /* search712_0_0_0 -> search14_0 in the cache */

/* search712_0_0_1 -> replace14_1_0 in the cache */
/* search712_0_0 -> search121_0 in the cache */

/* search712_0_1_0 -> search62_1_1 in the cache */

/* search712_0_1_1 -> search62_2 in the cache */
/* search712_0_1 -> search711_0_1 in the cache */
static const nir_search_expression search712_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search121_0.value, &search711_0_1.value },
   (is_used_once),
};
static const nir_search_expression search712 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search712_0.value },
   NULL,
};

   /* replace712_0_0 -> search14_0 in the cache */

/* replace712_0_1 -> replace14_1_0 in the cache */
/* replace712_0 -> replace707_0 in the cache */

/* replace712_1_0 -> search62_1_1 in the cache */

/* replace712_1_1 -> search62_2 in the cache */
/* replace712_1 -> replace711_1 in the cache */
static const nir_search_expression replace712 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace707_0.value, &replace711_1.value },
   NULL,
};

   /* search713_0_0_0 -> search14_0 in the cache */

/* search713_0_0_1 -> replace14_1_0 in the cache */
/* search713_0_0 -> search121_0 in the cache */

/* search713_0_1_0 -> search62_1_1 in the cache */

/* search713_0_1_1 -> search62_2 in the cache */
/* search713_0_1 -> replace711_1 in the cache */
static const nir_search_expression search713_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search121_0.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search713 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search713_0.value },
   NULL,
};

   /* replace713_0_0 -> search14_0 in the cache */

/* replace713_0_1 -> replace14_1_0 in the cache */
/* replace713_0 -> replace707_0 in the cache */

/* replace713_1_0 -> search62_1_1 in the cache */

/* replace713_1_1 -> search62_2 in the cache */
/* replace713_1 -> search711_0_1 in the cache */
static const nir_search_expression replace713 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace707_0.value, &search711_0_1.value },
   NULL,
};

   /* search714_0_0_0 -> search14_0 in the cache */

/* search714_0_0_1 -> replace14_1_0 in the cache */
/* search714_0_0 -> search121_0 in the cache */

/* search714_0_1_0 -> search62_1_1 in the cache */

/* search714_0_1_1 -> search62_2 in the cache */
/* search714_0_1 -> replace711_1 in the cache */
static const nir_search_expression search714_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search121_0.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search714 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search714_0.value },
   NULL,
};

   /* replace714_0_0 -> search14_0 in the cache */

/* replace714_0_1 -> replace14_1_0 in the cache */
/* replace714_0 -> replace707_0 in the cache */

/* replace714_1_0 -> search62_1_1 in the cache */

/* replace714_1_1 -> search62_2 in the cache */
/* replace714_1 -> search711_0_1 in the cache */
static const nir_search_expression replace714 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace707_0.value, &search711_0_1.value },
   NULL,
};

   /* search715_0_0_0 -> search14_0 in the cache */

/* search715_0_0_1 -> replace14_1_0 in the cache */
/* search715_0_0 -> replace707_0 in the cache */

/* search715_0_1_0 -> search62_1_1 in the cache */

/* search715_0_1_1 -> search62_2 in the cache */
/* search715_0_1 -> replace707_1 in the cache */
static const nir_search_expression search715_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace707_0.value, &replace707_1.value },
   (is_used_once),
};
static const nir_search_expression search715 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search715_0.value },
   NULL,
};

   /* replace715_0_0 -> search14_0 in the cache */

/* replace715_0_1 -> replace14_1_0 in the cache */
/* replace715_0 -> search121_0 in the cache */

/* replace715_1_0 -> search62_1_1 in the cache */

/* replace715_1_1 -> search62_2 in the cache */
/* replace715_1 -> search707_0_1 in the cache */
static const nir_search_expression replace715 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &search121_0.value, &search707_0_1.value },
   NULL,
};

   /* search716_0_0_0 -> search14_0 in the cache */

/* search716_0_0_1 -> replace14_1_0 in the cache */
/* search716_0_0 -> replace707_0 in the cache */

/* search716_0_1_0 -> search62_1_1 in the cache */

/* search716_0_1_1 -> search62_2 in the cache */
/* search716_0_1 -> replace707_1 in the cache */
static const nir_search_expression search716_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace707_0.value, &replace707_1.value },
   (is_used_once),
};
static const nir_search_expression search716 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 3,
   nir_op_inot,
   { &search716_0.value },
   NULL,
};

   /* replace716_0_0 -> search14_0 in the cache */

/* replace716_0_1 -> replace14_1_0 in the cache */
/* replace716_0 -> search121_0 in the cache */

/* replace716_1_0 -> search62_1_1 in the cache */

/* replace716_1_1 -> search62_2 in the cache */
/* replace716_1 -> search707_0_1 in the cache */
static const nir_search_expression replace716 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &search121_0.value, &search707_0_1.value },
   NULL,
};

   /* search717_0_0_0 -> search14_0 in the cache */

/* search717_0_0_1 -> replace14_1_0 in the cache */
/* search717_0_0 -> replace707_0 in the cache */

/* search717_0_1_0 -> search62_1_1 in the cache */

/* search717_0_1_1 -> search62_2 in the cache */
/* search717_0_1 -> search711_0_1 in the cache */
static const nir_search_expression search717_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace707_0.value, &search711_0_1.value },
   (is_used_once),
};
static const nir_search_expression search717 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search717_0.value },
   NULL,
};

   /* replace717_0_0 -> search14_0 in the cache */

/* replace717_0_1 -> replace14_1_0 in the cache */
/* replace717_0 -> search121_0 in the cache */

/* replace717_1_0 -> search62_1_1 in the cache */

/* replace717_1_1 -> search62_2 in the cache */
/* replace717_1 -> replace711_1 in the cache */
static const nir_search_expression replace717 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search121_0.value, &replace711_1.value },
   NULL,
};

   /* search718_0_0_0 -> search14_0 in the cache */

/* search718_0_0_1 -> replace14_1_0 in the cache */
/* search718_0_0 -> replace707_0 in the cache */

/* search718_0_1_0 -> search62_1_1 in the cache */

/* search718_0_1_1 -> search62_2 in the cache */
/* search718_0_1 -> search711_0_1 in the cache */
static const nir_search_expression search718_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace707_0.value, &search711_0_1.value },
   (is_used_once),
};
static const nir_search_expression search718 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search718_0.value },
   NULL,
};

   /* replace718_0_0 -> search14_0 in the cache */

/* replace718_0_1 -> replace14_1_0 in the cache */
/* replace718_0 -> search121_0 in the cache */

/* replace718_1_0 -> search62_1_1 in the cache */

/* replace718_1_1 -> search62_2 in the cache */
/* replace718_1 -> replace711_1 in the cache */
static const nir_search_expression replace718 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search121_0.value, &replace711_1.value },
   NULL,
};

   /* search719_0_0_0 -> search14_0 in the cache */

/* search719_0_0_1 -> replace14_1_0 in the cache */
/* search719_0_0 -> replace707_0 in the cache */

/* search719_0_1_0 -> search62_1_1 in the cache */

/* search719_0_1_1 -> search62_2 in the cache */
/* search719_0_1 -> replace711_1 in the cache */
static const nir_search_expression search719_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &replace707_0.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search719 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search719_0.value },
   NULL,
};

   /* replace719_0_0 -> search14_0 in the cache */

/* replace719_0_1 -> replace14_1_0 in the cache */
/* replace719_0 -> search121_0 in the cache */

/* replace719_1_0 -> search62_1_1 in the cache */

/* replace719_1_1 -> search62_2 in the cache */
/* replace719_1 -> search711_0_1 in the cache */
static const nir_search_expression replace719 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &search121_0.value, &search711_0_1.value },
   NULL,
};

   /* search720_0_0_0 -> search14_0 in the cache */

/* search720_0_0_1 -> replace14_1_0 in the cache */
/* search720_0_0 -> replace707_0 in the cache */

/* search720_0_1_0 -> search62_1_1 in the cache */

/* search720_0_1_1 -> search62_2 in the cache */
/* search720_0_1 -> replace711_1 in the cache */
static const nir_search_expression search720_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace707_0.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search720 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 2,
   nir_op_inot,
   { &search720_0.value },
   NULL,
};

   /* replace720_0_0 -> search14_0 in the cache */

/* replace720_0_1 -> replace14_1_0 in the cache */
/* replace720_0 -> search121_0 in the cache */

/* replace720_1_0 -> search62_1_1 in the cache */

/* replace720_1_1 -> search62_2 in the cache */
/* replace720_1 -> search711_0_1 in the cache */
static const nir_search_expression replace720 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_ior,
   { &search121_0.value, &search711_0_1.value },
   NULL,
};

   /* search721_0_0_0 -> search14_0 in the cache */

/* search721_0_0_1 -> replace14_1_0 in the cache */
/* search721_0_0 -> replace111 in the cache */

/* search721_0_1_0 -> search62_1_1 in the cache */

/* search721_0_1_1 -> search62_2 in the cache */
/* search721_0_1 -> search711_0_1 in the cache */
static const nir_search_expression search721_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace111.value, &search711_0_1.value },
   (is_used_once),
};
static const nir_search_expression search721 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search721_0.value },
   NULL,
};

   /* replace721_0_0 -> search14_0 in the cache */

/* replace721_0_1 -> replace14_1_0 in the cache */
/* replace721_0 -> search111_0 in the cache */

/* replace721_1_0 -> search62_1_1 in the cache */

/* replace721_1_1 -> search62_2 in the cache */
/* replace721_1 -> replace711_1 in the cache */
static const nir_search_expression replace721 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search111_0.value, &replace711_1.value },
   NULL,
};

   /* search722_0_0_0 -> search14_0 in the cache */

/* search722_0_0_1 -> replace14_1_0 in the cache */
/* search722_0_0 -> replace111 in the cache */

/* search722_0_1_0 -> search62_1_1 in the cache */

/* search722_0_1_1 -> search62_2 in the cache */
/* search722_0_1 -> search711_0_1 in the cache */
static const nir_search_expression search722_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace111.value, &search711_0_1.value },
   (is_used_once),
};
static const nir_search_expression search722 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search722_0.value },
   NULL,
};

   /* replace722_0_0 -> search14_0 in the cache */

/* replace722_0_1 -> replace14_1_0 in the cache */
/* replace722_0 -> search111_0 in the cache */

/* replace722_1_0 -> search62_1_1 in the cache */

/* replace722_1_1 -> search62_2 in the cache */
/* replace722_1 -> replace711_1 in the cache */
static const nir_search_expression replace722 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search111_0.value, &replace711_1.value },
   NULL,
};

   /* search723_0_0_0 -> search14_0 in the cache */

/* search723_0_0_1 -> replace14_1_0 in the cache */
/* search723_0_0 -> replace111 in the cache */

/* search723_0_1_0 -> search62_1_1 in the cache */

/* search723_0_1_1 -> search62_2 in the cache */
/* search723_0_1 -> replace711_1 in the cache */
static const nir_search_expression search723_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace111.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search723 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search723_0.value },
   NULL,
};

   /* replace723_0_0 -> search14_0 in the cache */

/* replace723_0_1 -> replace14_1_0 in the cache */
/* replace723_0 -> search111_0 in the cache */

/* replace723_1_0 -> search62_1_1 in the cache */

/* replace723_1_1 -> search62_2 in the cache */
/* replace723_1 -> search711_0_1 in the cache */
static const nir_search_expression replace723 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search111_0.value, &search711_0_1.value },
   NULL,
};

   /* search724_0_0_0 -> search14_0 in the cache */

/* search724_0_0_1 -> replace14_1_0 in the cache */
/* search724_0_0 -> replace111 in the cache */

/* search724_0_1_0 -> search62_1_1 in the cache */

/* search724_0_1_1 -> search62_2 in the cache */
/* search724_0_1 -> replace711_1 in the cache */
static const nir_search_expression search724_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace111.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search724 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search724_0.value },
   NULL,
};

   /* replace724_0_0 -> search14_0 in the cache */

/* replace724_0_1 -> replace14_1_0 in the cache */
/* replace724_0 -> search111_0 in the cache */

/* replace724_1_0 -> search62_1_1 in the cache */

/* replace724_1_1 -> search62_2 in the cache */
/* replace724_1 -> search711_0_1 in the cache */
static const nir_search_expression replace724 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search111_0.value, &search711_0_1.value },
   NULL,
};

   /* search725_0_0_0 -> search14_0 in the cache */

/* search725_0_0_1 -> replace14_1_0 in the cache */
/* search725_0_0 -> search111_0 in the cache */

/* search725_0_1_0 -> search62_1_1 in the cache */

/* search725_0_1_1 -> search62_2 in the cache */
/* search725_0_1 -> replace711_1 in the cache */
static const nir_search_expression search725_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &search111_0.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search725 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search725_0.value },
   NULL,
};

   /* replace725_0_0 -> search14_0 in the cache */

/* replace725_0_1 -> replace14_1_0 in the cache */
/* replace725_0 -> replace111 in the cache */

/* replace725_1_0 -> search62_1_1 in the cache */

/* replace725_1_1 -> search62_2 in the cache */
/* replace725_1 -> search711_0_1 in the cache */
static const nir_search_expression replace725 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &replace111.value, &search711_0_1.value },
   NULL,
};

   /* search726_0_0_0 -> search14_0 in the cache */

/* search726_0_0_1 -> replace14_1_0 in the cache */
/* search726_0_0 -> search111_0 in the cache */

/* search726_0_1_0 -> search62_1_1 in the cache */

/* search726_0_1_1 -> search62_2 in the cache */
/* search726_0_1 -> replace711_1 in the cache */
static const nir_search_expression search726_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_iand,
   { &search111_0.value, &replace711_1.value },
   (is_used_once),
};
static const nir_search_expression search726 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 1,
   nir_op_inot,
   { &search726_0.value },
   NULL,
};

   /* replace726_0_0 -> search14_0 in the cache */

/* replace726_0_1 -> replace14_1_0 in the cache */
/* replace726_0 -> replace111 in the cache */

/* replace726_1_0 -> search62_1_1 in the cache */

/* replace726_1_1 -> search62_2 in the cache */
/* replace726_1 -> search711_0_1 in the cache */
static const nir_search_expression replace726 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ior,
   { &replace111.value, &search711_0_1.value },
   NULL,
};

   /* search727_0_0 -> replace80_0 in the cache */
/* search727_0 -> search146_1 in the cache */
static const nir_search_expression search727 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_f2b1,
   { &search146_1.value },
   NULL,
};

   /* replace727 -> replace80_0 in the cache */

   /* search728_0_0 -> replace80_0 in the cache */
/* search728_0 -> search193_0 in the cache */
static const nir_search_expression search728 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2b1,
   { &search193_0.value },
   NULL,
};

   /* replace728 -> replace80_0 in the cache */

   /* search729_0_0 -> search0_0 in the cache */
static const nir_search_expression search729_0 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_b2f,
   { &search0_0.value },
   NULL,
};
static const nir_search_expression search729 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2b32,
   { &search729_0.value },
   NULL,
};

   /* replace729 -> search0_0 in the cache */

   /* search730_0_0 -> search0_0 in the cache */
/* search730_0 -> search514_0 in the cache */
/* search730 -> search514 in the cache */

   /* replace730 -> search0_0 in the cache */

   /* search731_0_0 -> search2_0 in the cache */
/* search731_0 -> search268_0 in the cache */
static const nir_search_expression search731 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2f,
   { &search268_0.value },
   NULL,
};

   /* replace731_0 -> search2_0 in the cache */
/* replace731 -> search268_0 in the cache */

   /* search732_0_0 -> search2_0 in the cache */
/* search732_0 -> search268_0 in the cache */
static const nir_search_expression search732 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2u,
   { &search268_0.value },
   NULL,
};

   /* replace732_0 -> search2_0 in the cache */
/* replace732 -> search510_0_0 in the cache */

   /* search733_0_0 -> search2_0 in the cache */
/* search733_0 -> search268_0 in the cache */
static const nir_search_expression search733 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_f2i,
   { &search268_0.value },
   NULL,
};

   /* replace733_0 -> search2_0 in the cache */
/* replace733 -> search510_0_0 in the cache */

   /* search734_0_0 -> search2_0 in the cache */
/* search734_0 -> search510_0_0 in the cache */
static const nir_search_expression search734 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2f,
   { &search510_0_0.value },
   NULL,
};

   /* replace734_0 -> search2_0 in the cache */
/* replace734 -> search268_0 in the cache */

   /* search735_0_0 -> search2_0 in the cache */
/* search735_0 -> search510_0_0 in the cache */
static const nir_search_expression search735 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_u2u,
   { &search510_0_0.value },
   NULL,
};

   /* replace735_0 -> search2_0 in the cache */
/* replace735 -> search510_0_0 in the cache */

   /* search736_0_0 -> search2_0 in the cache */
/* search736_0 -> search510_0_0 in the cache */
static const nir_search_expression search736 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2f,
   { &search510_0_0.value },
   NULL,
};

   /* replace736_0 -> search2_0 in the cache */
/* replace736 -> search268_0 in the cache */

   /* search737_0_0 -> search2_0 in the cache */
/* search737_0 -> search510_0_0 in the cache */
static const nir_search_expression search737 = {
   { nir_search_value_expression, 0 },
   false, false,
   -1, 0,
   nir_search_op_i2i,
   { &search510_0_0.value },
   NULL,
};

   /* replace737_0 -> search2_0 in the cache */
/* replace737 -> search510_0_0 in the cache */

   /* search738_0 -> replace80_0 in the cache */
static const nir_search_expression search738 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &replace80_0.value },
   NULL,
};

   /* replace738 -> replace80_0 in the cache */

   /* search739_0 -> search98_0_0 in the cache */
static const nir_search_expression search739 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search98_0_0.value },
   NULL,
};

   /* replace739 -> search98_0_0 in the cache */

   /* search740_0 -> search101_0_0 in the cache */
static const nir_search_expression search740 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search101_0_0.value },
   NULL,
};

   /* replace740 -> search101_0_0 in the cache */

   /* search741_0 -> search0_0 in the cache */
static const nir_search_expression search741 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search0_0.value },
   NULL,
};

   /* replace741 -> search0_0 in the cache */

   /* search742_0 -> search57_0 in the cache */
static const nir_search_expression search742 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search57_0.value },
   NULL,
};

   /* replace742 -> search57_0 in the cache */

   /* search743_0 -> replace80_0 in the cache */
static const nir_search_expression search743 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &replace80_0.value },
   NULL,
};

   /* replace743 -> replace80_0 in the cache */

   /* search744_0 -> search98_0_0 in the cache */
static const nir_search_expression search744 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search98_0_0.value },
   NULL,
};

   /* replace744 -> search98_0_0 in the cache */

   /* search745_0 -> search101_0_0 in the cache */
static const nir_search_expression search745 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search101_0_0.value },
   NULL,
};

   /* replace745 -> search101_0_0 in the cache */

   /* search746_0 -> search0_0 in the cache */
static const nir_search_expression search746 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search0_0.value },
   NULL,
};

   /* replace746 -> search0_0 in the cache */

   /* search747_0 -> search57_0 in the cache */
static const nir_search_expression search747 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search57_0.value },
   NULL,
};

   /* replace747 -> search57_0 in the cache */

   /* search748_0 -> search101_0_0 in the cache */
static const nir_search_expression search748 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search101_0_0.value },
   NULL,
};

   /* replace748 -> search101_0_0 in the cache */

   /* search749_0 -> search0_0 in the cache */
static const nir_search_expression search749 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search0_0.value },
   NULL,
};

   /* replace749 -> search0_0 in the cache */

   /* search750_0 -> search57_0 in the cache */
static const nir_search_expression search750 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search57_0.value },
   NULL,
};

   /* replace750 -> search57_0 in the cache */

   /* search751_0_0 -> search2_0 in the cache */
static const nir_search_expression search751_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search751 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search751_0.value },
   NULL,
};

   /* replace751_0 -> search2_0 in the cache */
static const nir_search_expression replace751 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search2_0.value },
   NULL,
};

   /* search752_0_0 -> search2_0 in the cache */
static const nir_search_expression search752_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search752 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search752_0.value },
   NULL,
};

   /* replace752_0 -> search2_0 in the cache */
static const nir_search_expression replace752 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search2_0.value },
   NULL,
};

   /* search753_0_0 -> search2_0 in the cache */
/* search753_0 -> search751_0 in the cache */
static const nir_search_expression search753 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search751_0.value },
   NULL,
};

   /* replace753_0 -> search2_0 in the cache */
/* replace753 -> replace751 in the cache */

   /* search754_0_0 -> search2_0 in the cache */
/* search754_0 -> search752_0 in the cache */
static const nir_search_expression search754 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search752_0.value },
   NULL,
};

   /* replace754_0 -> search2_0 in the cache */
/* replace754 -> replace752 in the cache */

   /* search755_0_0 -> search2_0 in the cache */
static const nir_search_expression search755_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search755 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search755_0.value },
   NULL,
};

   /* replace755_0 -> search2_0 in the cache */
/* replace755 -> replace751 in the cache */

   /* search756_0_0 -> search2_0 in the cache */
static const nir_search_expression search756_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search756 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search756_0.value },
   NULL,
};

   /* replace756_0 -> search2_0 in the cache */
/* replace756 -> replace752 in the cache */

   /* search757_0_0 -> search2_0 in the cache */
/* search757_0 -> search755_0 in the cache */
static const nir_search_expression search757 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search755_0.value },
   NULL,
};

   /* replace757_0 -> search2_0 in the cache */
/* replace757 -> replace751 in the cache */

   /* search758_0_0 -> search2_0 in the cache */
/* search758_0 -> search756_0 in the cache */
static const nir_search_expression search758 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search756_0.value },
   NULL,
};

   /* replace758_0 -> search2_0 in the cache */
/* replace758 -> replace752 in the cache */

   /* search759_0_0 -> search2_0 in the cache */
static const nir_search_expression search759_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search759 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search759_0.value },
   NULL,
};

   /* replace759_0 -> search2_0 in the cache */
/* replace759 -> replace751 in the cache */

   /* search760_0_0 -> search2_0 in the cache */
static const nir_search_expression search760_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search760 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search760_0.value },
   NULL,
};

   /* replace760_0 -> search2_0 in the cache */
/* replace760 -> replace752 in the cache */

   /* search761_0_0 -> search2_0 in the cache */
/* search761_0 -> search759_0 in the cache */
static const nir_search_expression search761 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search759_0.value },
   NULL,
};

   /* replace761_0 -> search2_0 in the cache */
/* replace761 -> replace751 in the cache */

   /* search762_0_0 -> search2_0 in the cache */
/* search762_0 -> search760_0 in the cache */
static const nir_search_expression search762 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search760_0.value },
   NULL,
};

   /* replace762_0 -> search2_0 in the cache */
/* replace762 -> replace752 in the cache */

   /* search763_0_0 -> search2_0 in the cache */
static const nir_search_expression search763_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search763 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search763_0.value },
   NULL,
};

   /* replace763_0 -> search2_0 in the cache */
/* replace763 -> replace751 in the cache */

   /* search764_0_0 -> search2_0 in the cache */
static const nir_search_expression search764_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search2_0.value },
   NULL,
};
static const nir_search_expression search764 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_i2i1,
   { &search764_0.value },
   NULL,
};

   /* replace764_0 -> search2_0 in the cache */
/* replace764 -> replace752 in the cache */

   /* search765_0_0 -> search2_0 in the cache */
/* search765_0 -> search763_0 in the cache */
static const nir_search_expression search765 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search763_0.value },
   NULL,
};

   /* replace765_0 -> search2_0 in the cache */
/* replace765 -> replace751 in the cache */

   /* search766_0_0 -> search2_0 in the cache */
/* search766_0 -> search764_0 in the cache */
static const nir_search_expression search766 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_u2u1,
   { &search764_0.value },
   NULL,
};

   /* replace766_0 -> search2_0 in the cache */
/* replace766 -> replace752 in the cache */

   /* search767_0_0 -> replace80_0 in the cache */
/* search767_0 -> search738 in the cache */
static const nir_search_expression search767 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search738.value },
   NULL,
};

   /* replace767_0 -> replace80_0 in the cache */
static const nir_search_expression replace767 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &replace80_0.value },
   NULL,
};

   /* search768_0_0 -> replace80_0 in the cache */
/* search768_0 -> search743 in the cache */
static const nir_search_expression search768 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search743.value },
   NULL,
};

   /* replace768_0 -> replace80_0 in the cache */
static const nir_search_expression replace768 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace80_0.value },
   NULL,
};

   /* search769_0_0 -> search2_0 in the cache */
/* search769_0 -> search755_0 in the cache */
static const nir_search_expression search769 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search755_0.value },
   NULL,
};

   /* replace769_0 -> search2_0 in the cache */
/* replace769 -> search751_0 in the cache */

   /* search770_0_0 -> search2_0 in the cache */
/* search770_0 -> search756_0 in the cache */
static const nir_search_expression search770 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search756_0.value },
   NULL,
};

   /* replace770_0 -> search2_0 in the cache */
/* replace770 -> search752_0 in the cache */

   /* search771_0_0 -> search2_0 in the cache */
/* search771_0 -> search755_0 in the cache */
static const nir_search_expression search771 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search755_0.value },
   NULL,
};

   /* replace771_0 -> search2_0 in the cache */
/* replace771 -> search751_0 in the cache */

   /* search772_0_0 -> search2_0 in the cache */
/* search772_0 -> search756_0 in the cache */
static const nir_search_expression search772 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search756_0.value },
   NULL,
};

   /* replace772_0 -> search2_0 in the cache */
/* replace772 -> search752_0 in the cache */

   /* search773_0_0 -> search2_0 in the cache */
/* search773_0 -> search759_0 in the cache */
static const nir_search_expression search773 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search759_0.value },
   NULL,
};

   /* replace773_0 -> search2_0 in the cache */
/* replace773 -> search751_0 in the cache */

   /* search774_0_0 -> search2_0 in the cache */
/* search774_0 -> search760_0 in the cache */
static const nir_search_expression search774 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search760_0.value },
   NULL,
};

   /* replace774_0 -> search2_0 in the cache */
/* replace774 -> search752_0 in the cache */

   /* search775_0_0 -> search2_0 in the cache */
/* search775_0 -> search759_0 in the cache */
static const nir_search_expression search775 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search759_0.value },
   NULL,
};

   /* replace775_0 -> search2_0 in the cache */
/* replace775 -> search751_0 in the cache */

   /* search776_0_0 -> search2_0 in the cache */
/* search776_0 -> search760_0 in the cache */
static const nir_search_expression search776 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search760_0.value },
   NULL,
};

   /* replace776_0 -> search2_0 in the cache */
/* replace776 -> search752_0 in the cache */

   /* search777_0_0 -> search2_0 in the cache */
/* search777_0 -> search763_0 in the cache */
static const nir_search_expression search777 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search763_0.value },
   NULL,
};

   /* replace777_0 -> search2_0 in the cache */
/* replace777 -> search751_0 in the cache */

   /* search778_0_0 -> search2_0 in the cache */
/* search778_0 -> search764_0 in the cache */
static const nir_search_expression search778 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search764_0.value },
   NULL,
};

   /* replace778_0 -> search2_0 in the cache */
/* replace778 -> search752_0 in the cache */

   /* search779_0_0 -> search2_0 in the cache */
/* search779_0 -> search763_0 in the cache */
static const nir_search_expression search779 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search763_0.value },
   NULL,
};

   /* replace779_0 -> search2_0 in the cache */
/* replace779 -> search751_0 in the cache */

   /* search780_0_0 -> search2_0 in the cache */
/* search780_0 -> search764_0 in the cache */
static const nir_search_expression search780 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search764_0.value },
   NULL,
};

   /* replace780_0 -> search2_0 in the cache */
/* replace780 -> search752_0 in the cache */

   /* search781_0_0 -> replace80_0 in the cache */
/* search781_0 -> search738 in the cache */
static const nir_search_expression search781 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search738.value },
   NULL,
};

   /* replace781_0 -> replace80_0 in the cache */
static const nir_search_expression replace781 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace80_0.value },
   NULL,
};

   /* search782_0_0 -> replace80_0 in the cache */
/* search782_0 -> search743 in the cache */
static const nir_search_expression search782 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search743.value },
   NULL,
};

   /* replace782_0 -> replace80_0 in the cache */
static const nir_search_expression replace782 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace80_0.value },
   NULL,
};

   /* search783_0_0 -> replace80_0 in the cache */
/* search783_0 -> replace767 in the cache */
static const nir_search_expression search783 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace767.value },
   NULL,
};

   /* replace783_0 -> replace80_0 in the cache */
/* replace783 -> replace781 in the cache */

   /* search784_0_0 -> replace80_0 in the cache */
/* search784_0 -> replace768 in the cache */
static const nir_search_expression search784 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace768.value },
   NULL,
};

   /* replace784_0 -> replace80_0 in the cache */
/* replace784 -> replace782 in the cache */

   /* search785_0_0 -> search98_0_0 in the cache */
/* search785_0 -> search739 in the cache */
static const nir_search_expression search785 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search739.value },
   NULL,
};

   /* replace785_0 -> search98_0_0 in the cache */
static const nir_search_expression replace785 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search98_0_0.value },
   NULL,
};

   /* search786_0_0 -> search98_0_0 in the cache */
/* search786_0 -> search744 in the cache */
static const nir_search_expression search786 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search744.value },
   NULL,
};

   /* replace786_0 -> search98_0_0 in the cache */
static const nir_search_expression replace786 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search98_0_0.value },
   NULL,
};

   /* search787_0_0 -> search2_0 in the cache */
/* search787_0 -> search759_0 in the cache */
static const nir_search_expression search787 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search759_0.value },
   NULL,
};

   /* replace787_0 -> search2_0 in the cache */
/* replace787 -> search755_0 in the cache */

   /* search788_0_0 -> search2_0 in the cache */
/* search788_0 -> search760_0 in the cache */
static const nir_search_expression search788 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search760_0.value },
   NULL,
};

   /* replace788_0 -> search2_0 in the cache */
/* replace788 -> search756_0 in the cache */

   /* search789_0_0 -> search2_0 in the cache */
/* search789_0 -> search759_0 in the cache */
static const nir_search_expression search789 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search759_0.value },
   NULL,
};

   /* replace789_0 -> search2_0 in the cache */
/* replace789 -> search755_0 in the cache */

   /* search790_0_0 -> search2_0 in the cache */
/* search790_0 -> search760_0 in the cache */
static const nir_search_expression search790 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search760_0.value },
   NULL,
};

   /* replace790_0 -> search2_0 in the cache */
/* replace790 -> search756_0 in the cache */

   /* search791_0_0 -> search2_0 in the cache */
/* search791_0 -> search763_0 in the cache */
static const nir_search_expression search791 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search763_0.value },
   NULL,
};

   /* replace791_0 -> search2_0 in the cache */
/* replace791 -> search755_0 in the cache */

   /* search792_0_0 -> search2_0 in the cache */
/* search792_0 -> search764_0 in the cache */
static const nir_search_expression search792 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search764_0.value },
   NULL,
};

   /* replace792_0 -> search2_0 in the cache */
/* replace792 -> search756_0 in the cache */

   /* search793_0_0 -> search2_0 in the cache */
/* search793_0 -> search763_0 in the cache */
static const nir_search_expression search793 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search763_0.value },
   NULL,
};

   /* replace793_0 -> search2_0 in the cache */
/* replace793 -> search755_0 in the cache */

   /* search794_0_0 -> search2_0 in the cache */
/* search794_0 -> search764_0 in the cache */
static const nir_search_expression search794 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search764_0.value },
   NULL,
};

   /* replace794_0 -> search2_0 in the cache */
/* replace794 -> search756_0 in the cache */

   /* search795_0_0 -> replace80_0 in the cache */
/* search795_0 -> search738 in the cache */
static const nir_search_expression search795 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search738.value },
   NULL,
};

   /* replace795_0 -> replace80_0 in the cache */
static const nir_search_expression replace795 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace80_0.value },
   NULL,
};

   /* search796_0_0 -> replace80_0 in the cache */
/* search796_0 -> search743 in the cache */
static const nir_search_expression search796 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search743.value },
   NULL,
};

   /* replace796_0 -> replace80_0 in the cache */
static const nir_search_expression replace796 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace80_0.value },
   NULL,
};

   /* search797_0_0 -> replace80_0 in the cache */
/* search797_0 -> replace767 in the cache */
static const nir_search_expression search797 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace767.value },
   NULL,
};

   /* replace797_0 -> replace80_0 in the cache */
/* replace797 -> replace795 in the cache */

   /* search798_0_0 -> replace80_0 in the cache */
/* search798_0 -> replace768 in the cache */
static const nir_search_expression search798 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace768.value },
   NULL,
};

   /* replace798_0 -> replace80_0 in the cache */
/* replace798 -> replace796 in the cache */

   /* search799_0_0 -> search98_0_0 in the cache */
/* search799_0 -> search739 in the cache */
static const nir_search_expression search799 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search739.value },
   NULL,
};

   /* replace799_0 -> search98_0_0 in the cache */
static const nir_search_expression replace799 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search98_0_0.value },
   NULL,
};

   /* search800_0_0 -> search98_0_0 in the cache */
/* search800_0 -> search744 in the cache */
static const nir_search_expression search800 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search744.value },
   NULL,
};

   /* replace800_0 -> search98_0_0 in the cache */
static const nir_search_expression replace800 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search98_0_0.value },
   NULL,
};

   /* search801_0_0 -> replace80_0 in the cache */
/* search801_0 -> replace781 in the cache */
static const nir_search_expression search801 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace781.value },
   NULL,
};

   /* replace801_0 -> replace80_0 in the cache */
/* replace801 -> replace795 in the cache */

   /* search802_0_0 -> replace80_0 in the cache */
/* search802_0 -> replace782 in the cache */
static const nir_search_expression search802 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace782.value },
   NULL,
};

   /* replace802_0 -> replace80_0 in the cache */
/* replace802 -> replace796 in the cache */

   /* search803_0_0 -> search98_0_0 in the cache */
/* search803_0 -> replace785 in the cache */
static const nir_search_expression search803 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace785.value },
   NULL,
};

   /* replace803_0 -> search98_0_0 in the cache */
/* replace803 -> replace799 in the cache */

   /* search804_0_0 -> search98_0_0 in the cache */
/* search804_0 -> replace786 in the cache */
static const nir_search_expression search804 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace786.value },
   NULL,
};

   /* replace804_0 -> search98_0_0 in the cache */
/* replace804 -> replace800 in the cache */

   /* search805_0_0 -> search101_0_0 in the cache */
/* search805_0 -> search740 in the cache */
static const nir_search_expression search805 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search740.value },
   NULL,
};

   /* replace805_0 -> search101_0_0 in the cache */
static const nir_search_expression replace805 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search101_0_0.value },
   NULL,
};

   /* search806_0_0 -> search101_0_0 in the cache */
/* search806_0 -> search745 in the cache */
static const nir_search_expression search806 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search745.value },
   NULL,
};

   /* replace806_0 -> search101_0_0 in the cache */
static const nir_search_expression replace806 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search101_0_0.value },
   NULL,
};

   /* search807_0_0 -> search2_0 in the cache */
/* search807_0 -> search763_0 in the cache */
static const nir_search_expression search807 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search763_0.value },
   NULL,
};

   /* replace807_0 -> search2_0 in the cache */
/* replace807 -> search759_0 in the cache */

   /* search808_0_0 -> search2_0 in the cache */
/* search808_0 -> search764_0 in the cache */
static const nir_search_expression search808 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search764_0.value },
   NULL,
};

   /* replace808_0 -> search2_0 in the cache */
/* replace808 -> search760_0 in the cache */

   /* search809_0_0 -> search2_0 in the cache */
/* search809_0 -> search763_0 in the cache */
static const nir_search_expression search809 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search763_0.value },
   NULL,
};

   /* replace809_0 -> search2_0 in the cache */
/* replace809 -> search759_0 in the cache */

   /* search810_0_0 -> search2_0 in the cache */
/* search810_0 -> search764_0 in the cache */
static const nir_search_expression search810 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search764_0.value },
   NULL,
};

   /* replace810_0 -> search2_0 in the cache */
/* replace810 -> search760_0 in the cache */

   /* search811_0_0 -> replace80_0 in the cache */
/* search811_0 -> search738 in the cache */
static const nir_search_expression search811 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search738.value },
   NULL,
};

   /* replace811_0 -> replace80_0 in the cache */
static const nir_search_expression replace811 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace80_0.value },
   NULL,
};

   /* search812_0_0 -> replace80_0 in the cache */
/* search812_0 -> search743 in the cache */
static const nir_search_expression search812 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search743.value },
   NULL,
};

   /* replace812_0 -> replace80_0 in the cache */
static const nir_search_expression replace812 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace80_0.value },
   NULL,
};

   /* search813_0_0 -> replace80_0 in the cache */
/* search813_0 -> replace767 in the cache */
static const nir_search_expression search813 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace767.value },
   NULL,
};

   /* replace813_0 -> replace80_0 in the cache */
/* replace813 -> replace811 in the cache */

   /* search814_0_0 -> replace80_0 in the cache */
/* search814_0 -> replace768 in the cache */
static const nir_search_expression search814 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace768.value },
   NULL,
};

   /* replace814_0 -> replace80_0 in the cache */
/* replace814 -> replace812 in the cache */

   /* search815_0_0 -> search98_0_0 in the cache */
/* search815_0 -> search739 in the cache */
static const nir_search_expression search815 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search739.value },
   NULL,
};

   /* replace815_0 -> search98_0_0 in the cache */
static const nir_search_expression replace815 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search98_0_0.value },
   NULL,
};

   /* search816_0_0 -> search98_0_0 in the cache */
/* search816_0 -> search744 in the cache */
static const nir_search_expression search816 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search744.value },
   NULL,
};

   /* replace816_0 -> search98_0_0 in the cache */
static const nir_search_expression replace816 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search98_0_0.value },
   NULL,
};

   /* search817_0_0 -> replace80_0 in the cache */
/* search817_0 -> replace781 in the cache */
static const nir_search_expression search817 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace781.value },
   NULL,
};

   /* replace817_0 -> replace80_0 in the cache */
/* replace817 -> replace811 in the cache */

   /* search818_0_0 -> replace80_0 in the cache */
/* search818_0 -> replace782 in the cache */
static const nir_search_expression search818 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace782.value },
   NULL,
};

   /* replace818_0 -> replace80_0 in the cache */
/* replace818 -> replace812 in the cache */

   /* search819_0_0 -> search98_0_0 in the cache */
/* search819_0 -> replace785 in the cache */
static const nir_search_expression search819 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace785.value },
   NULL,
};

   /* replace819_0 -> search98_0_0 in the cache */
/* replace819 -> replace815 in the cache */

   /* search820_0_0 -> search98_0_0 in the cache */
/* search820_0 -> replace786 in the cache */
static const nir_search_expression search820 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace786.value },
   NULL,
};

   /* replace820_0 -> search98_0_0 in the cache */
/* replace820 -> replace816 in the cache */

   /* search821_0_0 -> search101_0_0 in the cache */
/* search821_0 -> search740 in the cache */
static const nir_search_expression search821 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search740.value },
   NULL,
};

   /* replace821_0 -> search101_0_0 in the cache */
static const nir_search_expression replace821 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search101_0_0.value },
   NULL,
};

   /* search822_0_0 -> search101_0_0 in the cache */
/* search822_0 -> search745 in the cache */
static const nir_search_expression search822 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search745.value },
   NULL,
};

   /* replace822_0 -> search101_0_0 in the cache */
static const nir_search_expression replace822 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search101_0_0.value },
   NULL,
};

   /* search823_0_0 -> replace80_0 in the cache */
/* search823_0 -> replace795 in the cache */
static const nir_search_expression search823 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace795.value },
   NULL,
};

   /* replace823_0 -> replace80_0 in the cache */
/* replace823 -> replace811 in the cache */

   /* search824_0_0 -> replace80_0 in the cache */
/* search824_0 -> replace796 in the cache */
static const nir_search_expression search824 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace796.value },
   NULL,
};

   /* replace824_0 -> replace80_0 in the cache */
/* replace824 -> replace812 in the cache */

   /* search825_0_0 -> search98_0_0 in the cache */
/* search825_0 -> replace799 in the cache */
static const nir_search_expression search825 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace799.value },
   NULL,
};

   /* replace825_0 -> search98_0_0 in the cache */
/* replace825 -> replace815 in the cache */

   /* search826_0_0 -> search98_0_0 in the cache */
/* search826_0 -> replace800 in the cache */
static const nir_search_expression search826 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace800.value },
   NULL,
};

   /* replace826_0 -> search98_0_0 in the cache */
/* replace826 -> replace816 in the cache */

   /* search827_0_0 -> search101_0_0 in the cache */
/* search827_0 -> replace805 in the cache */
static const nir_search_expression search827 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace805.value },
   NULL,
};

   /* replace827_0 -> search101_0_0 in the cache */
/* replace827 -> replace821 in the cache */

   /* search828_0_0 -> search101_0_0 in the cache */
/* search828_0 -> replace806 in the cache */
static const nir_search_expression search828 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace806.value },
   NULL,
};

   /* replace828_0 -> search101_0_0 in the cache */
/* replace828 -> replace822 in the cache */

   /* search829_0_0 -> search0_0 in the cache */
/* search829_0 -> search741 in the cache */
static const nir_search_expression search829 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search741.value },
   NULL,
};

   /* replace829_0 -> search0_0 in the cache */
static const nir_search_expression replace829 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search0_0.value },
   NULL,
};

   /* search830_0_0 -> search0_0 in the cache */
/* search830_0 -> search746 in the cache */
static const nir_search_expression search830 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search746.value },
   NULL,
};

   /* replace830_0 -> search0_0 in the cache */
static const nir_search_expression replace830 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search0_0.value },
   NULL,
};

   /* search831_0_0 -> search98_0_0 in the cache */
/* search831_0 -> replace785 in the cache */

/* search831_1_0 -> search699_1 in the cache */
static const nir_search_expression search831_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression search831 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace785.value, &search831_1.value },
   NULL,
};

   /* replace831_0 -> search98_0_0 in the cache */

/* replace831_1_0 -> search699_1 in the cache */
static const nir_search_expression replace831_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression replace831 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace831_1.value },
   NULL,
};

   /* search832_0_0 -> search98_0_0 in the cache */
/* search832_0 -> replace785 in the cache */

/* search832_1_0 -> search699_1 in the cache */
/* search832_1 -> search831_1 in the cache */
static const nir_search_expression search832 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace785.value, &search831_1.value },
   NULL,
};

   /* replace832_0 -> search98_0_0 in the cache */

/* replace832_1_0 -> search699_1 in the cache */
/* replace832_1 -> replace831_1 in the cache */
static const nir_search_expression replace832 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace831_1.value },
   NULL,
};

   /* search833_0_0 -> search98_0_0 in the cache */
/* search833_0 -> replace785 in the cache */

/* search833_1_0 -> search699_1 in the cache */
/* search833_1 -> search831_1 in the cache */
static const nir_search_expression search833 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace785.value, &search831_1.value },
   NULL,
};

   /* replace833_0 -> search98_0_0 in the cache */

/* replace833_1_0 -> search699_1 in the cache */
/* replace833_1 -> replace831_1 in the cache */
static const nir_search_expression replace833 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace831_1.value },
   NULL,
};

   /* search834_0_0 -> search98_0_0 in the cache */
/* search834_0 -> replace785 in the cache */

/* search834_1_0 -> search699_1 in the cache */
/* search834_1 -> search831_1 in the cache */
static const nir_search_expression search834 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace785.value, &search831_1.value },
   NULL,
};

   /* replace834_0 -> search98_0_0 in the cache */

/* replace834_1_0 -> search699_1 in the cache */
/* replace834_1 -> replace831_1 in the cache */
static const nir_search_expression replace834 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace831_1.value },
   NULL,
};

   static const nir_search_variable search835_0_0 = {
   { nir_search_value_variable, 8 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search835_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search835_0_0.value },
   NULL,
};

static const nir_search_variable search835_1_0 = {
   { nir_search_value_variable, 8 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search835_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search835_1_0.value },
   NULL,
};
static const nir_search_expression search835 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search835_0.value, &search835_1.value },
   NULL,
};

   /* replace835_0_0 -> search835_0_0 in the cache */
static const nir_search_expression replace835_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search835_0_0.value },
   NULL,
};

/* replace835_1 -> search835_1_0 in the cache */
static const nir_search_expression replace835 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace835_0.value, &search835_1_0.value },
   NULL,
};

   /* search836_0_0 -> search835_0_0 in the cache */
/* search836_0 -> search835_0 in the cache */

/* search836_1_0 -> search835_1_0 in the cache */
/* search836_1 -> search835_1 in the cache */
static const nir_search_expression search836 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search835_0.value, &search835_1.value },
   NULL,
};

   /* replace836_0_0 -> search835_0_0 in the cache */
/* replace836_0 -> replace835_0 in the cache */

/* replace836_1 -> search835_1_0 in the cache */
static const nir_search_expression replace836 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace835_0.value, &search835_1_0.value },
   NULL,
};

   /* search837_0_0 -> search98_0_0 in the cache */
/* search837_0 -> replace785 in the cache */

/* search837_1 -> search564_0_1 in the cache */
static const nir_search_expression search837 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace785.value, &search564_0_1.value },
   NULL,
};

   /* replace837_0_0 -> search98_0_0 in the cache */

/* replace837_0_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression replace837_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace837_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace837_0_1.value },
   NULL,
};

/* replace837_1_0_0_0 -> replace564_1_0 in the cache */
/* replace837_1_0_0 -> replace837_0_1 in the cache */
static const nir_search_expression replace837_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace837_0_1.value },
   NULL,
};

/* replace837_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace837_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace837_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace837 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace837_0.value, &replace837_1.value },
   NULL,
};

   /* search838_0_0 -> search98_0_0 in the cache */
/* search838_0 -> replace785 in the cache */

/* search838_1 -> search564_0_1 in the cache */
static const nir_search_expression search838 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace785.value, &search564_0_1.value },
   NULL,
};

   /* replace838_0_0 -> search98_0_0 in the cache */

/* replace838_0_1_0 -> replace564_1_0 in the cache */
/* replace838_0_1 -> replace837_0_1 in the cache */
static const nir_search_expression replace838_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace837_0_1.value },
   NULL,
};

/* replace838_1_0_0_0 -> replace564_1_0 in the cache */
/* replace838_1_0_0 -> replace837_0_1 in the cache */
/* replace838_1_0 -> replace837_1_0 in the cache */

/* replace838_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace838_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace837_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace838 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace838_0.value, &replace838_1.value },
   NULL,
};

   /* search839_0_0 -> search98_0_0 in the cache */
/* search839_0 -> replace785 in the cache */

/* search839_1 -> search564_0_1 in the cache */
static const nir_search_expression search839 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace785.value, &search564_0_1.value },
   NULL,
};

   static const nir_search_constant replace839_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { -0x80 /* -128 */ },
};

/* replace839_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace839_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace839_0_0.value, &replace564_1_0.value },
   NULL,
};

static const nir_search_constant replace839_1_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace839_1_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace839_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace839_1_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace839_1_1_0 -> search98_0_0 in the cache */

/* replace839_1_1_1_0 -> replace564_1_0 in the cache */
/* replace839_1_1_1 -> replace837_0_1 in the cache */
static const nir_search_expression replace839_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace837_0_1.value },
   NULL,
};
static const nir_search_expression replace839_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace839_1_0.value, &replace839_1_1.value },
   NULL,
};
static const nir_search_expression replace839 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace839_0.value, &replace839_1.value },
   NULL,
};

   static const nir_search_variable search840_0 = {
   { nir_search_value_variable, 16 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search840_1_0 -> search699_1 in the cache */
/* search840_1 -> search831_1 in the cache */
static const nir_search_expression search840 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search840_0.value, &search831_1.value },
   NULL,
};

   /* replace840_0_0 -> search101_0_0 in the cache */

/* replace840_0_1 -> replace839_1_0_0 in the cache */
static const nir_search_expression replace840_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace839_1_0_0.value },
   NULL,
};

/* replace840_1_0_0 -> search101_0_0 in the cache */

/* replace840_1_0_1 -> replace839_0_0 in the cache */
static const nir_search_expression replace840_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace839_0_0.value },
   NULL,
};

/* replace840_1_1_0_0 -> search101_0_0 in the cache */
static const nir_search_expression replace840_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search101_0_0.value },
   NULL,
};

/* replace840_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace840_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace840_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace840_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace840_1_0.value, &replace840_1_1.value },
   NULL,
};
static const nir_search_expression replace840 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace840_0.value, &replace840_1.value },
   NULL,
};

   /* search841_0_0 -> search98_0_0 in the cache */
/* search841_0 -> replace785 in the cache */

/* search841_1 -> search564_0_1 in the cache */
static const nir_search_expression search841 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace785.value, &search564_0_1.value },
   NULL,
};

   /* replace841_0_0 -> replace839_1_0_0 in the cache */

/* replace841_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace841_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace839_1_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace841_1_0_0 -> replace839_0_0 in the cache */

/* replace841_1_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace841_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace839_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace841_1_1_0 -> search98_0_0 in the cache */

/* replace841_1_1_1_0 -> replace564_1_0 in the cache */
/* replace841_1_1_1 -> replace837_0_1 in the cache */
static const nir_search_expression replace841_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace837_0_1.value },
   NULL,
};
static const nir_search_expression replace841_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace841_1_0.value, &replace841_1_1.value },
   NULL,
};
static const nir_search_expression replace841 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace841_0.value, &replace841_1.value },
   NULL,
};

   /* search842_0 -> search840_0 in the cache */

/* search842_1_0 -> search699_1 in the cache */
/* search842_1 -> search831_1 in the cache */
static const nir_search_expression search842 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search840_0.value, &search831_1.value },
   NULL,
};

   /* replace842_0_0 -> search101_0_0 in the cache */

/* replace842_0_1 -> replace839_0_0 in the cache */
static const nir_search_expression replace842_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace839_0_0.value },
   NULL,
};

/* replace842_1_0_0 -> search101_0_0 in the cache */

/* replace842_1_0_1 -> replace839_1_0_0 in the cache */
static const nir_search_expression replace842_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace839_1_0_0.value },
   NULL,
};

/* replace842_1_1_0_0 -> search101_0_0 in the cache */
/* replace842_1_1_0 -> replace840_1_1_0 in the cache */

/* replace842_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace842_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace840_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace842_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace842_1_0.value, &replace842_1_1.value },
   NULL,
};
static const nir_search_expression replace842 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace842_0.value, &replace842_1.value },
   NULL,
};

   /* search843_0_0 -> search98_0_0 in the cache */
/* search843_0 -> replace799 in the cache */

/* search843_1_0 -> search699_1 in the cache */
static const nir_search_expression search843_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression search843 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace799.value, &search843_1.value },
   NULL,
};

   /* replace843_0 -> search98_0_0 in the cache */

/* replace843_1_0 -> search699_1 in the cache */
/* replace843_1 -> replace831_1 in the cache */
/* replace843 -> replace831 in the cache */

   /* search844_0_0 -> search98_0_0 in the cache */
/* search844_0 -> replace799 in the cache */

/* search844_1_0 -> search699_1 in the cache */
/* search844_1 -> search843_1 in the cache */
static const nir_search_expression search844 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace799.value, &search843_1.value },
   NULL,
};

   /* replace844_0 -> search98_0_0 in the cache */

/* replace844_1_0 -> search699_1 in the cache */
/* replace844_1 -> replace831_1 in the cache */
/* replace844 -> replace832 in the cache */

   /* search845_0_0 -> search98_0_0 in the cache */
/* search845_0 -> replace799 in the cache */

/* search845_1_0 -> search699_1 in the cache */
/* search845_1 -> search843_1 in the cache */
static const nir_search_expression search845 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace799.value, &search843_1.value },
   NULL,
};

   /* replace845_0 -> search98_0_0 in the cache */

/* replace845_1_0 -> search699_1 in the cache */
/* replace845_1 -> replace831_1 in the cache */
/* replace845 -> replace833 in the cache */

   /* search846_0_0 -> search98_0_0 in the cache */
/* search846_0 -> replace799 in the cache */

/* search846_1_0 -> search699_1 in the cache */
/* search846_1 -> search843_1 in the cache */
static const nir_search_expression search846 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace799.value, &search843_1.value },
   NULL,
};

   /* replace846_0 -> search98_0_0 in the cache */

/* replace846_1_0 -> search699_1 in the cache */
/* replace846_1 -> replace831_1 in the cache */
/* replace846 -> replace834 in the cache */

   /* search847_0_0 -> search835_0_0 in the cache */
static const nir_search_expression search847_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search835_0_0.value },
   NULL,
};

/* search847_1_0 -> search835_1_0 in the cache */
static const nir_search_expression search847_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search835_1_0.value },
   NULL,
};
static const nir_search_expression search847 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search847_0.value, &search847_1.value },
   NULL,
};

   /* replace847_0_0 -> search835_0_0 in the cache */
/* replace847_0 -> replace835_0 in the cache */

/* replace847_1 -> search835_1_0 in the cache */
/* replace847 -> replace835 in the cache */

   /* search848_0_0 -> search835_0_0 in the cache */
/* search848_0 -> search847_0 in the cache */

/* search848_1_0 -> search835_1_0 in the cache */
/* search848_1 -> search847_1 in the cache */
static const nir_search_expression search848 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search847_0.value, &search847_1.value },
   NULL,
};

   /* replace848_0_0 -> search835_0_0 in the cache */
/* replace848_0 -> replace835_0 in the cache */

/* replace848_1 -> search835_1_0 in the cache */
/* replace848 -> replace836 in the cache */

   /* search849_0_0 -> search98_0_0 in the cache */
/* search849_0 -> replace799 in the cache */

/* search849_1 -> search2_1 in the cache */
static const nir_search_expression search849 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace799.value, &search2_1.value },
   NULL,
};

   /* replace849_0_0 -> search98_0_0 in the cache */

/* replace849_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace849_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace849_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace849_0_1.value },
   NULL,
};

/* replace849_1_0_0_0 -> replace0_1_0 in the cache */
/* replace849_1_0_0 -> replace849_0_1 in the cache */
static const nir_search_expression replace849_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace849_0_1.value },
   NULL,
};

/* replace849_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace849_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace849_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace849 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace849_0.value, &replace849_1.value },
   NULL,
};

   /* search850_0_0 -> search98_0_0 in the cache */
/* search850_0 -> replace799 in the cache */

/* search850_1 -> search2_1 in the cache */
static const nir_search_expression search850 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace799.value, &search2_1.value },
   NULL,
};

   /* replace850_0_0 -> search98_0_0 in the cache */

/* replace850_0_1_0 -> replace0_1_0 in the cache */
/* replace850_0_1 -> replace849_0_1 in the cache */
static const nir_search_expression replace850_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace849_0_1.value },
   NULL,
};

/* replace850_1_0_0_0 -> replace0_1_0 in the cache */
/* replace850_1_0_0 -> replace849_0_1 in the cache */
/* replace850_1_0 -> replace849_1_0 in the cache */

/* replace850_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace850_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace849_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace850 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace850_0.value, &replace850_1.value },
   NULL,
};

   /* search851_0_0 -> search98_0_0 in the cache */
/* search851_0 -> replace799 in the cache */

/* search851_1 -> search2_1 in the cache */
static const nir_search_expression search851 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace799.value, &search2_1.value },
   NULL,
};

   static const nir_search_constant replace851_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x80 /* -128 */ },
};

/* replace851_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace851_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace851_0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_constant replace851_1_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace851_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace851_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace851_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace851_1_1_0 -> search98_0_0 in the cache */

/* replace851_1_1_1_0 -> replace0_1_0 in the cache */
/* replace851_1_1_1 -> replace849_0_1 in the cache */
static const nir_search_expression replace851_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace849_0_1.value },
   NULL,
};
static const nir_search_expression replace851_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace851_1_0.value, &replace851_1_1.value },
   NULL,
};
static const nir_search_expression replace851 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace851_0.value, &replace851_1.value },
   NULL,
};

   static const nir_search_variable search852_0 = {
   { nir_search_value_variable, 32 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search852_1_0 -> search699_1 in the cache */
/* search852_1 -> search843_1 in the cache */
static const nir_search_expression search852 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search852_0.value, &search843_1.value },
   NULL,
};

   /* replace852_0_0 -> search0_0 in the cache */

/* replace852_0_1 -> replace851_1_0_0 in the cache */
static const nir_search_expression replace852_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace851_1_0_0.value },
   NULL,
};

/* replace852_1_0_0 -> search0_0 in the cache */

/* replace852_1_0_1 -> replace851_0_0 in the cache */
static const nir_search_expression replace852_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace851_0_0.value },
   NULL,
};

/* replace852_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace852_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search0_0.value },
   NULL,
};

/* replace852_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace852_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace852_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace852_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace852_1_0.value, &replace852_1_1.value },
   NULL,
};
static const nir_search_expression replace852 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace852_0.value, &replace852_1.value },
   NULL,
};

   /* search853_0_0 -> search98_0_0 in the cache */
/* search853_0 -> replace799 in the cache */

/* search853_1 -> search2_1 in the cache */
static const nir_search_expression search853 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace799.value, &search2_1.value },
   NULL,
};

   /* replace853_0_0 -> replace851_1_0_0 in the cache */

/* replace853_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace853_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace851_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace853_1_0_0 -> replace851_0_0 in the cache */

/* replace853_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace853_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace851_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace853_1_1_0 -> search98_0_0 in the cache */

/* replace853_1_1_1_0 -> replace0_1_0 in the cache */
/* replace853_1_1_1 -> replace849_0_1 in the cache */
static const nir_search_expression replace853_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace849_0_1.value },
   NULL,
};
static const nir_search_expression replace853_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace853_1_0.value, &replace853_1_1.value },
   NULL,
};
static const nir_search_expression replace853 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace853_0.value, &replace853_1.value },
   NULL,
};

   /* search854_0 -> search852_0 in the cache */

/* search854_1_0 -> search699_1 in the cache */
/* search854_1 -> search843_1 in the cache */
static const nir_search_expression search854 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search852_0.value, &search843_1.value },
   NULL,
};

   /* replace854_0_0 -> search0_0 in the cache */

/* replace854_0_1 -> replace851_0_0 in the cache */
static const nir_search_expression replace854_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace851_0_0.value },
   NULL,
};

/* replace854_1_0_0 -> search0_0 in the cache */

/* replace854_1_0_1 -> replace851_1_0_0 in the cache */
static const nir_search_expression replace854_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace851_1_0_0.value },
   NULL,
};

/* replace854_1_1_0_0 -> search0_0 in the cache */
/* replace854_1_1_0 -> replace852_1_1_0 in the cache */

/* replace854_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace854_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace852_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace854_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace854_1_0.value, &replace854_1_1.value },
   NULL,
};
static const nir_search_expression replace854 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace854_0.value, &replace854_1.value },
   NULL,
};

   /* search855_0_0 -> search98_0_0 in the cache */
/* search855_0 -> replace815 in the cache */

/* search855_1_0 -> search699_1 in the cache */
static const nir_search_expression search855_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression search855 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace815.value, &search855_1.value },
   NULL,
};

   /* replace855_0 -> search98_0_0 in the cache */

/* replace855_1_0 -> search699_1 in the cache */
/* replace855_1 -> replace831_1 in the cache */
/* replace855 -> replace831 in the cache */

   /* search856_0_0 -> search98_0_0 in the cache */
/* search856_0 -> replace815 in the cache */

/* search856_1_0 -> search699_1 in the cache */
/* search856_1 -> search855_1 in the cache */
static const nir_search_expression search856 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace815.value, &search855_1.value },
   NULL,
};

   /* replace856_0 -> search98_0_0 in the cache */

/* replace856_1_0 -> search699_1 in the cache */
/* replace856_1 -> replace831_1 in the cache */
/* replace856 -> replace832 in the cache */

   /* search857_0_0 -> search98_0_0 in the cache */
/* search857_0 -> replace815 in the cache */

/* search857_1_0 -> search699_1 in the cache */
/* search857_1 -> search855_1 in the cache */
static const nir_search_expression search857 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace815.value, &search855_1.value },
   NULL,
};

   /* replace857_0 -> search98_0_0 in the cache */

/* replace857_1_0 -> search699_1 in the cache */
/* replace857_1 -> replace831_1 in the cache */
/* replace857 -> replace833 in the cache */

   /* search858_0_0 -> search98_0_0 in the cache */
/* search858_0 -> replace815 in the cache */

/* search858_1_0 -> search699_1 in the cache */
/* search858_1 -> search855_1 in the cache */
static const nir_search_expression search858 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace815.value, &search855_1.value },
   NULL,
};

   /* replace858_0 -> search98_0_0 in the cache */

/* replace858_1_0 -> search699_1 in the cache */
/* replace858_1 -> replace831_1 in the cache */
/* replace858 -> replace834 in the cache */

   /* search859_0_0 -> search835_0_0 in the cache */
static const nir_search_expression search859_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search835_0_0.value },
   NULL,
};

/* search859_1_0 -> search835_1_0 in the cache */
static const nir_search_expression search859_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search835_1_0.value },
   NULL,
};
static const nir_search_expression search859 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search859_0.value, &search859_1.value },
   NULL,
};

   /* replace859_0_0 -> search835_0_0 in the cache */
/* replace859_0 -> replace835_0 in the cache */

/* replace859_1 -> search835_1_0 in the cache */
/* replace859 -> replace835 in the cache */

   /* search860_0_0 -> search835_0_0 in the cache */
/* search860_0 -> search859_0 in the cache */

/* search860_1_0 -> search835_1_0 in the cache */
/* search860_1 -> search859_1 in the cache */
static const nir_search_expression search860 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search859_0.value, &search859_1.value },
   NULL,
};

   /* replace860_0_0 -> search835_0_0 in the cache */
/* replace860_0 -> replace835_0 in the cache */

/* replace860_1 -> search835_1_0 in the cache */
/* replace860 -> replace836 in the cache */

   /* search861_0_0 -> search98_0_0 in the cache */
/* search861_0 -> replace815 in the cache */

static const nir_search_variable search861_1 = {
   { nir_search_value_variable, 64 },
   1, /* b */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search861 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace815.value, &search861_1.value },
   NULL,
};

   /* replace861_0_0 -> search98_0_0 in the cache */

/* replace861_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace861_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace861_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace861_0_1.value },
   NULL,
};

/* replace861_1_0_0_0 -> search57_1_1 in the cache */
/* replace861_1_0_0 -> replace861_0_1 in the cache */
static const nir_search_expression replace861_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace861_0_1.value },
   NULL,
};

/* replace861_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace861_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace861_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace861 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace861_0.value, &replace861_1.value },
   NULL,
};

   /* search862_0_0 -> search98_0_0 in the cache */
/* search862_0 -> replace815 in the cache */

/* search862_1 -> search861_1 in the cache */
static const nir_search_expression search862 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace815.value, &search861_1.value },
   NULL,
};

   /* replace862_0_0 -> search98_0_0 in the cache */

/* replace862_0_1_0 -> search57_1_1 in the cache */
/* replace862_0_1 -> replace861_0_1 in the cache */
static const nir_search_expression replace862_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace861_0_1.value },
   NULL,
};

/* replace862_1_0_0_0 -> search57_1_1 in the cache */
/* replace862_1_0_0 -> replace861_0_1 in the cache */
/* replace862_1_0 -> replace861_1_0 in the cache */

/* replace862_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace862_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace861_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace862 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace862_0.value, &replace862_1.value },
   NULL,
};

   /* search863_0_0 -> search98_0_0 in the cache */
/* search863_0 -> replace815 in the cache */

/* search863_1 -> search861_1 in the cache */
static const nir_search_expression search863 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace815.value, &search861_1.value },
   NULL,
};

   static const nir_search_constant replace863_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x80 /* -128 */ },
};

/* replace863_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace863_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace863_0_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace863_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7f /* 127 */ },
};

/* replace863_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace863_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace863_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace863_1_1_0 -> search98_0_0 in the cache */

/* replace863_1_1_1_0 -> search57_1_1 in the cache */
/* replace863_1_1_1 -> replace861_0_1 in the cache */
static const nir_search_expression replace863_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search98_0_0.value, &replace861_0_1.value },
   NULL,
};
static const nir_search_expression replace863_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace863_1_0.value, &replace863_1_1.value },
   NULL,
};
static const nir_search_expression replace863 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace863_0.value, &replace863_1.value },
   NULL,
};

   static const nir_search_variable search864_0 = {
   { nir_search_value_variable, 64 },
   0, /* a */
   true,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

/* search864_1_0 -> search699_1 in the cache */
/* search864_1 -> search855_1 in the cache */
static const nir_search_expression search864 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search864_0.value, &search855_1.value },
   NULL,
};

   /* replace864_0_0 -> search57_0 in the cache */

/* replace864_0_1 -> replace863_1_0_0 in the cache */
static const nir_search_expression replace864_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace863_1_0_0.value },
   NULL,
};

/* replace864_1_0_0 -> search57_0 in the cache */

/* replace864_1_0_1 -> replace863_0_0 in the cache */
static const nir_search_expression replace864_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace863_0_0.value },
   NULL,
};

/* replace864_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace864_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_i2i8,
   { &search57_0.value },
   NULL,
};

/* replace864_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace864_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace864_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace864_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace864_1_0.value, &replace864_1_1.value },
   NULL,
};
static const nir_search_expression replace864 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace864_0.value, &replace864_1.value },
   NULL,
};

   /* search865_0_0 -> search98_0_0 in the cache */
/* search865_0 -> replace815 in the cache */

/* search865_1 -> search861_1 in the cache */
static const nir_search_expression search865 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace815.value, &search861_1.value },
   NULL,
};

   /* replace865_0_0 -> replace863_1_0_0 in the cache */

/* replace865_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace865_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace863_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace865_1_0_0 -> replace863_0_0 in the cache */

/* replace865_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace865_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace863_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace865_1_1_0 -> search98_0_0 in the cache */

/* replace865_1_1_1_0 -> search57_1_1 in the cache */
/* replace865_1_1_1 -> replace861_0_1 in the cache */
static const nir_search_expression replace865_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search98_0_0.value, &replace861_0_1.value },
   NULL,
};
static const nir_search_expression replace865_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace865_1_0.value, &replace865_1_1.value },
   NULL,
};
static const nir_search_expression replace865 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace865_0.value, &replace865_1.value },
   NULL,
};

   /* search866_0 -> search864_0 in the cache */

/* search866_1_0 -> search699_1 in the cache */
/* search866_1 -> search855_1 in the cache */
static const nir_search_expression search866 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search864_0.value, &search855_1.value },
   NULL,
};

   /* replace866_0_0 -> search57_0 in the cache */

/* replace866_0_1 -> replace863_0_0 in the cache */
static const nir_search_expression replace866_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace863_0_0.value },
   NULL,
};

/* replace866_1_0_0 -> search57_0 in the cache */

/* replace866_1_0_1 -> replace863_1_0_0 in the cache */
static const nir_search_expression replace866_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace863_1_0_0.value },
   NULL,
};

/* replace866_1_1_0_0 -> search57_0 in the cache */
/* replace866_1_1_0 -> replace864_1_1_0 in the cache */

/* replace866_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace866_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace864_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace866_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace866_1_0.value, &replace866_1_1.value },
   NULL,
};
static const nir_search_expression replace866 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace866_0.value, &replace866_1.value },
   NULL,
};

   /* search867_0_0 -> search101_0_0 in the cache */
/* search867_0 -> replace805 in the cache */

/* search867_1_0 -> search699_1 in the cache */
/* search867_1 -> search843_1 in the cache */
static const nir_search_expression search867 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace805.value, &search843_1.value },
   NULL,
};

   /* replace867_0 -> search101_0_0 in the cache */

/* replace867_1_0 -> search699_1 in the cache */
/* replace867_1 -> search831_1 in the cache */
static const nir_search_expression replace867 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &search831_1.value },
   NULL,
};

   /* search868_0_0 -> search101_0_0 in the cache */
/* search868_0 -> replace805 in the cache */

/* search868_1_0 -> search699_1 in the cache */
/* search868_1 -> search843_1 in the cache */
static const nir_search_expression search868 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace805.value, &search843_1.value },
   NULL,
};

   /* replace868_0 -> search101_0_0 in the cache */

/* replace868_1_0 -> search699_1 in the cache */
/* replace868_1 -> search831_1 in the cache */
static const nir_search_expression replace868 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &search831_1.value },
   NULL,
};

   /* search869_0_0 -> search101_0_0 in the cache */
/* search869_0 -> replace805 in the cache */

/* search869_1_0 -> search699_1 in the cache */
/* search869_1 -> search843_1 in the cache */
static const nir_search_expression search869 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace805.value, &search843_1.value },
   NULL,
};

   /* replace869_0 -> search101_0_0 in the cache */

/* replace869_1_0 -> search699_1 in the cache */
/* replace869_1 -> search831_1 in the cache */
static const nir_search_expression replace869 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &search831_1.value },
   NULL,
};

   /* search870_0_0 -> search101_0_0 in the cache */
/* search870_0 -> replace805 in the cache */

/* search870_1_0 -> search699_1 in the cache */
/* search870_1 -> search843_1 in the cache */
static const nir_search_expression search870 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace805.value, &search843_1.value },
   NULL,
};

   /* replace870_0 -> search101_0_0 in the cache */

/* replace870_1_0 -> search699_1 in the cache */
/* replace870_1 -> search831_1 in the cache */
static const nir_search_expression replace870 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &search831_1.value },
   NULL,
};

   /* search871_0_0 -> search835_0_0 in the cache */
/* search871_0 -> search847_0 in the cache */

static const nir_search_variable search871_1_0 = {
   { nir_search_value_variable, 16 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search871_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search871_1_0.value },
   NULL,
};
static const nir_search_expression search871 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search847_0.value, &search871_1.value },
   NULL,
};

   /* replace871_0_0 -> search835_0_0 in the cache */
/* replace871_0 -> search835_0 in the cache */

/* replace871_1 -> search871_1_0 in the cache */
static const nir_search_expression replace871 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search835_0.value, &search871_1_0.value },
   NULL,
};

   /* search872_0_0 -> search835_0_0 in the cache */
/* search872_0 -> search847_0 in the cache */

/* search872_1_0 -> search871_1_0 in the cache */
/* search872_1 -> search871_1 in the cache */
static const nir_search_expression search872 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search847_0.value, &search871_1.value },
   NULL,
};

   /* replace872_0_0 -> search835_0_0 in the cache */
/* replace872_0 -> search835_0 in the cache */

/* replace872_1 -> search871_1_0 in the cache */
static const nir_search_expression replace872 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search835_0.value, &search871_1_0.value },
   NULL,
};

   /* search873_0_0 -> search101_0_0 in the cache */
/* search873_0 -> replace805 in the cache */

/* search873_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression search873_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression search873 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace805.value, &search873_1.value },
   NULL,
};

   /* replace873_0 -> search101_0_0 in the cache */

/* replace873_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression replace873_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace873 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace873_1.value },
   NULL,
};

   /* search874_0_0 -> search101_0_0 in the cache */
/* search874_0 -> replace805 in the cache */

/* search874_1_0 -> replace564_1_0 in the cache */
/* search874_1 -> search873_1 in the cache */
static const nir_search_expression search874 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace805.value, &search873_1.value },
   NULL,
};

   /* replace874_0 -> search101_0_0 in the cache */

/* replace874_1_0 -> replace564_1_0 in the cache */
/* replace874_1 -> replace873_1 in the cache */
static const nir_search_expression replace874 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace873_1.value },
   NULL,
};

   /* search875_0_0 -> search101_0_0 in the cache */
/* search875_0 -> replace805 in the cache */

/* search875_1_0 -> replace564_1_0 in the cache */
/* search875_1 -> search873_1 in the cache */
static const nir_search_expression search875 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace805.value, &search873_1.value },
   NULL,
};

   /* replace875_0 -> search101_0_0 in the cache */

/* replace875_1_0 -> replace564_1_0 in the cache */
/* replace875_1 -> replace873_1 in the cache */
static const nir_search_expression replace875 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace873_1.value },
   NULL,
};

   /* search876_0_0 -> search101_0_0 in the cache */
/* search876_0 -> replace805 in the cache */

/* search876_1_0 -> replace564_1_0 in the cache */
/* search876_1 -> search873_1 in the cache */
static const nir_search_expression search876 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace805.value, &search873_1.value },
   NULL,
};

   /* replace876_0 -> search101_0_0 in the cache */

/* replace876_1_0 -> replace564_1_0 in the cache */
/* replace876_1 -> replace873_1 in the cache */
static const nir_search_expression replace876 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace873_1.value },
   NULL,
};

   static const nir_search_variable search877_0_0 = {
   { nir_search_value_variable, 16 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search877_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search877_0_0.value },
   NULL,
};

/* search877_1_0 -> search871_1_0 in the cache */
/* search877_1 -> search871_1 in the cache */
static const nir_search_expression search877 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search877_0.value, &search871_1.value },
   NULL,
};

   /* replace877_0_0 -> search877_0_0 in the cache */
static const nir_search_expression replace877_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search877_0_0.value },
   NULL,
};

/* replace877_1 -> search871_1_0 in the cache */
static const nir_search_expression replace877 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace877_0.value, &search871_1_0.value },
   NULL,
};

   /* search878_0_0 -> search877_0_0 in the cache */
/* search878_0 -> search877_0 in the cache */

/* search878_1_0 -> search871_1_0 in the cache */
/* search878_1 -> search871_1 in the cache */
static const nir_search_expression search878 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search877_0.value, &search871_1.value },
   NULL,
};

   /* replace878_0_0 -> search877_0_0 in the cache */
/* replace878_0 -> replace877_0 in the cache */

/* replace878_1 -> search871_1_0 in the cache */
static const nir_search_expression replace878 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace877_0.value, &search871_1_0.value },
   NULL,
};

   /* search879_0_0 -> search101_0_0 in the cache */
/* search879_0 -> replace805 in the cache */

/* search879_1 -> search2_1 in the cache */
static const nir_search_expression search879 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace805.value, &search2_1.value },
   NULL,
};

   /* replace879_0_0 -> search101_0_0 in the cache */

/* replace879_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace879_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace879_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace879_0_1.value },
   NULL,
};

/* replace879_1_0_0_0 -> replace0_1_0 in the cache */
/* replace879_1_0_0 -> replace879_0_1 in the cache */
static const nir_search_expression replace879_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace879_0_1.value },
   NULL,
};

/* replace879_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace879_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace879_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace879 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace879_0.value, &replace879_1.value },
   NULL,
};

   /* search880_0_0 -> search101_0_0 in the cache */
/* search880_0 -> replace805 in the cache */

/* search880_1 -> search2_1 in the cache */
static const nir_search_expression search880 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace805.value, &search2_1.value },
   NULL,
};

   /* replace880_0_0 -> search101_0_0 in the cache */

/* replace880_0_1_0 -> replace0_1_0 in the cache */
/* replace880_0_1 -> replace879_0_1 in the cache */
static const nir_search_expression replace880_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace879_0_1.value },
   NULL,
};

/* replace880_1_0_0_0 -> replace0_1_0 in the cache */
/* replace880_1_0_0 -> replace879_0_1 in the cache */
/* replace880_1_0 -> replace879_1_0 in the cache */

/* replace880_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace880_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace879_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace880 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace880_0.value, &replace880_1.value },
   NULL,
};

   /* search881_0_0 -> search101_0_0 in the cache */
/* search881_0 -> replace805 in the cache */

/* search881_1 -> search2_1 in the cache */
static const nir_search_expression search881 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace805.value, &search2_1.value },
   NULL,
};

   static const nir_search_constant replace881_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x8000 /* -32768 */ },
};

/* replace881_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace881_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace881_0_0.value, &replace0_1_0.value },
   NULL,
};

static const nir_search_constant replace881_1_0_0 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x7fff /* 32767 */ },
};

/* replace881_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace881_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace881_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace881_1_1_0 -> search101_0_0 in the cache */

/* replace881_1_1_1_0 -> replace0_1_0 in the cache */
/* replace881_1_1_1 -> replace879_0_1 in the cache */
static const nir_search_expression replace881_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace879_0_1.value },
   NULL,
};
static const nir_search_expression replace881_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace881_1_0.value, &replace881_1_1.value },
   NULL,
};
static const nir_search_expression replace881 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace881_0.value, &replace881_1.value },
   NULL,
};

   /* search882_0 -> search852_0 in the cache */

/* search882_1_0 -> replace564_1_0 in the cache */
/* search882_1 -> search873_1 in the cache */
static const nir_search_expression search882 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search852_0.value, &search873_1.value },
   NULL,
};

   /* replace882_0_0 -> search0_0 in the cache */

/* replace882_0_1 -> replace881_1_0_0 in the cache */
static const nir_search_expression replace882_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace881_1_0_0.value },
   NULL,
};

/* replace882_1_0_0 -> search0_0 in the cache */

/* replace882_1_0_1 -> replace881_0_0 in the cache */
static const nir_search_expression replace882_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace881_0_0.value },
   NULL,
};

/* replace882_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace882_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search0_0.value },
   NULL,
};

/* replace882_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace882_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace882_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace882_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace882_1_0.value, &replace882_1_1.value },
   NULL,
};
static const nir_search_expression replace882 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace882_0.value, &replace882_1.value },
   NULL,
};

   /* search883_0_0 -> search101_0_0 in the cache */
/* search883_0 -> replace805 in the cache */

/* search883_1 -> search2_1 in the cache */
static const nir_search_expression search883 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace805.value, &search2_1.value },
   NULL,
};

   /* replace883_0_0 -> replace881_1_0_0 in the cache */

/* replace883_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace883_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace881_1_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace883_1_0_0 -> replace881_0_0 in the cache */

/* replace883_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace883_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace881_0_0.value, &replace0_1_0.value },
   NULL,
};

/* replace883_1_1_0 -> search101_0_0 in the cache */

/* replace883_1_1_1_0 -> replace0_1_0 in the cache */
/* replace883_1_1_1 -> replace879_0_1 in the cache */
static const nir_search_expression replace883_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace879_0_1.value },
   NULL,
};
static const nir_search_expression replace883_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace883_1_0.value, &replace883_1_1.value },
   NULL,
};
static const nir_search_expression replace883 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace883_0.value, &replace883_1.value },
   NULL,
};

   /* search884_0 -> search852_0 in the cache */

/* search884_1_0 -> replace564_1_0 in the cache */
/* search884_1 -> search873_1 in the cache */
static const nir_search_expression search884 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search852_0.value, &search873_1.value },
   NULL,
};

   /* replace884_0_0 -> search0_0 in the cache */

/* replace884_0_1 -> replace881_0_0 in the cache */
static const nir_search_expression replace884_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace881_0_0.value },
   NULL,
};

/* replace884_1_0_0 -> search0_0 in the cache */

/* replace884_1_0_1 -> replace881_1_0_0 in the cache */
static const nir_search_expression replace884_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace881_1_0_0.value },
   NULL,
};

/* replace884_1_1_0_0 -> search0_0 in the cache */
/* replace884_1_1_0 -> replace882_1_1_0 in the cache */

/* replace884_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace884_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace882_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace884_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace884_1_0.value, &replace884_1_1.value },
   NULL,
};
static const nir_search_expression replace884 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace884_0.value, &replace884_1.value },
   NULL,
};

   /* search885_0_0 -> search101_0_0 in the cache */
/* search885_0 -> replace821 in the cache */

/* search885_1_0 -> search699_1 in the cache */
/* search885_1 -> search855_1 in the cache */
static const nir_search_expression search885 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace821.value, &search855_1.value },
   NULL,
};

   /* replace885_0 -> search101_0_0 in the cache */

/* replace885_1_0 -> search699_1 in the cache */
/* replace885_1 -> search831_1 in the cache */
/* replace885 -> replace867 in the cache */

   /* search886_0_0 -> search101_0_0 in the cache */
/* search886_0 -> replace821 in the cache */

/* search886_1_0 -> search699_1 in the cache */
/* search886_1 -> search855_1 in the cache */
static const nir_search_expression search886 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace821.value, &search855_1.value },
   NULL,
};

   /* replace886_0 -> search101_0_0 in the cache */

/* replace886_1_0 -> search699_1 in the cache */
/* replace886_1 -> search831_1 in the cache */
/* replace886 -> replace868 in the cache */

   /* search887_0_0 -> search101_0_0 in the cache */
/* search887_0 -> replace821 in the cache */

/* search887_1_0 -> search699_1 in the cache */
/* search887_1 -> search855_1 in the cache */
static const nir_search_expression search887 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace821.value, &search855_1.value },
   NULL,
};

   /* replace887_0 -> search101_0_0 in the cache */

/* replace887_1_0 -> search699_1 in the cache */
/* replace887_1 -> search831_1 in the cache */
/* replace887 -> replace869 in the cache */

   /* search888_0_0 -> search101_0_0 in the cache */
/* search888_0 -> replace821 in the cache */

/* search888_1_0 -> search699_1 in the cache */
/* search888_1 -> search855_1 in the cache */
static const nir_search_expression search888 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace821.value, &search855_1.value },
   NULL,
};

   /* replace888_0 -> search101_0_0 in the cache */

/* replace888_1_0 -> search699_1 in the cache */
/* replace888_1 -> search831_1 in the cache */
/* replace888 -> replace870 in the cache */

   /* search889_0_0 -> search835_0_0 in the cache */
/* search889_0 -> search859_0 in the cache */

/* search889_1_0 -> search871_1_0 in the cache */
static const nir_search_expression search889_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search871_1_0.value },
   NULL,
};
static const nir_search_expression search889 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search859_0.value, &search889_1.value },
   NULL,
};

   /* replace889_0_0 -> search835_0_0 in the cache */
/* replace889_0 -> search835_0 in the cache */

/* replace889_1 -> search871_1_0 in the cache */
/* replace889 -> replace871 in the cache */

   /* search890_0_0 -> search835_0_0 in the cache */
/* search890_0 -> search859_0 in the cache */

/* search890_1_0 -> search871_1_0 in the cache */
/* search890_1 -> search889_1 in the cache */
static const nir_search_expression search890 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search859_0.value, &search889_1.value },
   NULL,
};

   /* replace890_0_0 -> search835_0_0 in the cache */
/* replace890_0 -> search835_0 in the cache */

/* replace890_1 -> search871_1_0 in the cache */
/* replace890 -> replace872 in the cache */

   /* search891_0_0 -> search101_0_0 in the cache */
/* search891_0 -> replace821 in the cache */

/* search891_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression search891_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression search891 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace821.value, &search891_1.value },
   NULL,
};

   /* replace891_0 -> search101_0_0 in the cache */

/* replace891_1_0 -> replace564_1_0 in the cache */
/* replace891_1 -> replace873_1 in the cache */
/* replace891 -> replace873 in the cache */

   /* search892_0_0 -> search101_0_0 in the cache */
/* search892_0 -> replace821 in the cache */

/* search892_1_0 -> replace564_1_0 in the cache */
/* search892_1 -> search891_1 in the cache */
static const nir_search_expression search892 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace821.value, &search891_1.value },
   NULL,
};

   /* replace892_0 -> search101_0_0 in the cache */

/* replace892_1_0 -> replace564_1_0 in the cache */
/* replace892_1 -> replace873_1 in the cache */
/* replace892 -> replace874 in the cache */

   /* search893_0_0 -> search101_0_0 in the cache */
/* search893_0 -> replace821 in the cache */

/* search893_1_0 -> replace564_1_0 in the cache */
/* search893_1 -> search891_1 in the cache */
static const nir_search_expression search893 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace821.value, &search891_1.value },
   NULL,
};

   /* replace893_0 -> search101_0_0 in the cache */

/* replace893_1_0 -> replace564_1_0 in the cache */
/* replace893_1 -> replace873_1 in the cache */
/* replace893 -> replace875 in the cache */

   /* search894_0_0 -> search101_0_0 in the cache */
/* search894_0 -> replace821 in the cache */

/* search894_1_0 -> replace564_1_0 in the cache */
/* search894_1 -> search891_1 in the cache */
static const nir_search_expression search894 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace821.value, &search891_1.value },
   NULL,
};

   /* replace894_0 -> search101_0_0 in the cache */

/* replace894_1_0 -> replace564_1_0 in the cache */
/* replace894_1 -> replace873_1 in the cache */
/* replace894 -> replace876 in the cache */

   /* search895_0_0 -> search877_0_0 in the cache */
static const nir_search_expression search895_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search877_0_0.value },
   NULL,
};

/* search895_1_0 -> search871_1_0 in the cache */
/* search895_1 -> search889_1 in the cache */
static const nir_search_expression search895 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search895_0.value, &search889_1.value },
   NULL,
};

   /* replace895_0_0 -> search877_0_0 in the cache */
/* replace895_0 -> replace877_0 in the cache */

/* replace895_1 -> search871_1_0 in the cache */
/* replace895 -> replace877 in the cache */

   /* search896_0_0 -> search877_0_0 in the cache */
/* search896_0 -> search895_0 in the cache */

/* search896_1_0 -> search871_1_0 in the cache */
/* search896_1 -> search889_1 in the cache */
static const nir_search_expression search896 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search895_0.value, &search889_1.value },
   NULL,
};

   /* replace896_0_0 -> search877_0_0 in the cache */
/* replace896_0 -> replace877_0 in the cache */

/* replace896_1 -> search871_1_0 in the cache */
/* replace896 -> replace878 in the cache */

   /* search897_0_0 -> search101_0_0 in the cache */
/* search897_0 -> replace821 in the cache */

/* search897_1 -> search861_1 in the cache */
static const nir_search_expression search897 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace821.value, &search861_1.value },
   NULL,
};

   /* replace897_0_0 -> search101_0_0 in the cache */

/* replace897_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace897_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace897_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace897_0_1.value },
   NULL,
};

/* replace897_1_0_0_0 -> search57_1_1 in the cache */
/* replace897_1_0_0 -> replace897_0_1 in the cache */
static const nir_search_expression replace897_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace897_0_1.value },
   NULL,
};

/* replace897_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace897_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace897_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace897 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace897_0.value, &replace897_1.value },
   NULL,
};

   /* search898_0_0 -> search101_0_0 in the cache */
/* search898_0 -> replace821 in the cache */

/* search898_1 -> search861_1 in the cache */
static const nir_search_expression search898 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace821.value, &search861_1.value },
   NULL,
};

   /* replace898_0_0 -> search101_0_0 in the cache */

/* replace898_0_1_0 -> search57_1_1 in the cache */
/* replace898_0_1 -> replace897_0_1 in the cache */
static const nir_search_expression replace898_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace897_0_1.value },
   NULL,
};

/* replace898_1_0_0_0 -> search57_1_1 in the cache */
/* replace898_1_0_0 -> replace897_0_1 in the cache */
/* replace898_1_0 -> replace897_1_0 in the cache */

/* replace898_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace898_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace897_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace898 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace898_0.value, &replace898_1.value },
   NULL,
};

   /* search899_0_0 -> search101_0_0 in the cache */
/* search899_0 -> replace821 in the cache */

/* search899_1 -> search861_1 in the cache */
static const nir_search_expression search899 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace821.value, &search861_1.value },
   NULL,
};

   static const nir_search_constant replace899_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x8000 /* -32768 */ },
};

/* replace899_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace899_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace899_0_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace899_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fff /* 32767 */ },
};

/* replace899_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace899_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace899_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace899_1_1_0 -> search101_0_0 in the cache */

/* replace899_1_1_1_0 -> search57_1_1 in the cache */
/* replace899_1_1_1 -> replace897_0_1 in the cache */
static const nir_search_expression replace899_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search101_0_0.value, &replace897_0_1.value },
   NULL,
};
static const nir_search_expression replace899_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace899_1_0.value, &replace899_1_1.value },
   NULL,
};
static const nir_search_expression replace899 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace899_0.value, &replace899_1.value },
   NULL,
};

   /* search900_0 -> search864_0 in the cache */

/* search900_1_0 -> replace564_1_0 in the cache */
/* search900_1 -> search891_1 in the cache */
static const nir_search_expression search900 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search864_0.value, &search891_1.value },
   NULL,
};

   /* replace900_0_0 -> search57_0 in the cache */

/* replace900_0_1 -> replace899_1_0_0 in the cache */
static const nir_search_expression replace900_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace899_1_0_0.value },
   NULL,
};

/* replace900_1_0_0 -> search57_0 in the cache */

/* replace900_1_0_1 -> replace899_0_0 in the cache */
static const nir_search_expression replace900_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace899_0_0.value },
   NULL,
};

/* replace900_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace900_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_i2i16,
   { &search57_0.value },
   NULL,
};

/* replace900_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace900_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace900_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace900_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace900_1_0.value, &replace900_1_1.value },
   NULL,
};
static const nir_search_expression replace900 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace900_0.value, &replace900_1.value },
   NULL,
};

   /* search901_0_0 -> search101_0_0 in the cache */
/* search901_0 -> replace821 in the cache */

/* search901_1 -> search861_1 in the cache */
static const nir_search_expression search901 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace821.value, &search861_1.value },
   NULL,
};

   /* replace901_0_0 -> replace899_1_0_0 in the cache */

/* replace901_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace901_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace899_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace901_1_0_0 -> replace899_0_0 in the cache */

/* replace901_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace901_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace899_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace901_1_1_0 -> search101_0_0 in the cache */

/* replace901_1_1_1_0 -> search57_1_1 in the cache */
/* replace901_1_1_1 -> replace897_0_1 in the cache */
static const nir_search_expression replace901_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search101_0_0.value, &replace897_0_1.value },
   NULL,
};
static const nir_search_expression replace901_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace901_1_0.value, &replace901_1_1.value },
   NULL,
};
static const nir_search_expression replace901 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace901_0.value, &replace901_1.value },
   NULL,
};

   /* search902_0 -> search864_0 in the cache */

/* search902_1_0 -> replace564_1_0 in the cache */
/* search902_1 -> search891_1 in the cache */
static const nir_search_expression search902 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search864_0.value, &search891_1.value },
   NULL,
};

   /* replace902_0_0 -> search57_0 in the cache */

/* replace902_0_1 -> replace899_0_0 in the cache */
static const nir_search_expression replace902_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace899_0_0.value },
   NULL,
};

/* replace902_1_0_0 -> search57_0 in the cache */

/* replace902_1_0_1 -> replace899_1_0_0 in the cache */
static const nir_search_expression replace902_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace899_1_0_0.value },
   NULL,
};

/* replace902_1_1_0_0 -> search57_0 in the cache */
/* replace902_1_1_0 -> replace900_1_1_0 in the cache */

/* replace902_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace902_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace900_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace902_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace902_1_0.value, &replace902_1_1.value },
   NULL,
};
static const nir_search_expression replace902 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace902_0.value, &replace902_1.value },
   NULL,
};

   /* search903_0_0 -> search0_0 in the cache */
/* search903_0 -> replace829 in the cache */

/* search903_1_0 -> search699_1 in the cache */
/* search903_1 -> search855_1 in the cache */
static const nir_search_expression search903 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace829.value, &search855_1.value },
   NULL,
};

   /* replace903_0 -> search0_0 in the cache */

/* replace903_1_0 -> search699_1 in the cache */
/* replace903_1 -> search843_1 in the cache */
static const nir_search_expression replace903 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search843_1.value },
   NULL,
};

   /* search904_0_0 -> search0_0 in the cache */
/* search904_0 -> replace829 in the cache */

/* search904_1_0 -> search699_1 in the cache */
/* search904_1 -> search855_1 in the cache */
static const nir_search_expression search904 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace829.value, &search855_1.value },
   NULL,
};

   /* replace904_0 -> search0_0 in the cache */

/* replace904_1_0 -> search699_1 in the cache */
/* replace904_1 -> search843_1 in the cache */
static const nir_search_expression replace904 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search843_1.value },
   NULL,
};

   /* search905_0_0 -> search0_0 in the cache */
/* search905_0 -> replace829 in the cache */

/* search905_1_0 -> search699_1 in the cache */
/* search905_1 -> search855_1 in the cache */
static const nir_search_expression search905 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace829.value, &search855_1.value },
   NULL,
};

   /* replace905_0 -> search0_0 in the cache */

/* replace905_1_0 -> search699_1 in the cache */
/* replace905_1 -> search843_1 in the cache */
static const nir_search_expression replace905 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &search843_1.value },
   NULL,
};

   /* search906_0_0 -> search0_0 in the cache */
/* search906_0 -> replace829 in the cache */

/* search906_1_0 -> search699_1 in the cache */
/* search906_1 -> search855_1 in the cache */
static const nir_search_expression search906 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace829.value, &search855_1.value },
   NULL,
};

   /* replace906_0 -> search0_0 in the cache */

/* replace906_1_0 -> search699_1 in the cache */
/* replace906_1 -> search843_1 in the cache */
static const nir_search_expression replace906 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &search843_1.value },
   NULL,
};

   /* search907_0_0 -> search835_0_0 in the cache */
/* search907_0 -> search859_0 in the cache */

static const nir_search_variable search907_1_0 = {
   { nir_search_value_variable, 32 },
   1, /* a */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search907_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search907_1_0.value },
   NULL,
};
static const nir_search_expression search907 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search859_0.value, &search907_1.value },
   NULL,
};

   /* replace907_0_0 -> search835_0_0 in the cache */
/* replace907_0 -> search847_0 in the cache */

/* replace907_1 -> search907_1_0 in the cache */
static const nir_search_expression replace907 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search847_0.value, &search907_1_0.value },
   NULL,
};

   /* search908_0_0 -> search835_0_0 in the cache */
/* search908_0 -> search859_0 in the cache */

/* search908_1_0 -> search907_1_0 in the cache */
/* search908_1 -> search907_1 in the cache */
static const nir_search_expression search908 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search859_0.value, &search907_1.value },
   NULL,
};

   /* replace908_0_0 -> search835_0_0 in the cache */
/* replace908_0 -> search847_0 in the cache */

/* replace908_1 -> search907_1_0 in the cache */
static const nir_search_expression replace908 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search847_0.value, &search907_1_0.value },
   NULL,
};

   /* search909_0_0 -> search0_0 in the cache */
/* search909_0 -> replace829 in the cache */

/* search909_1_0 -> replace564_1_0 in the cache */
/* search909_1 -> search891_1 in the cache */
static const nir_search_expression search909 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace829.value, &search891_1.value },
   NULL,
};

   /* replace909_0 -> search0_0 in the cache */

/* replace909_1_0 -> replace564_1_0 in the cache */
/* replace909_1 -> search873_1 in the cache */
static const nir_search_expression replace909 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search873_1.value },
   NULL,
};

   /* search910_0_0 -> search0_0 in the cache */
/* search910_0 -> replace829 in the cache */

/* search910_1_0 -> replace564_1_0 in the cache */
/* search910_1 -> search891_1 in the cache */
static const nir_search_expression search910 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace829.value, &search891_1.value },
   NULL,
};

   /* replace910_0 -> search0_0 in the cache */

/* replace910_1_0 -> replace564_1_0 in the cache */
/* replace910_1 -> search873_1 in the cache */
static const nir_search_expression replace910 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search873_1.value },
   NULL,
};

   /* search911_0_0 -> search0_0 in the cache */
/* search911_0 -> replace829 in the cache */

/* search911_1_0 -> replace564_1_0 in the cache */
/* search911_1 -> search891_1 in the cache */
static const nir_search_expression search911 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace829.value, &search891_1.value },
   NULL,
};

   /* replace911_0 -> search0_0 in the cache */

/* replace911_1_0 -> replace564_1_0 in the cache */
/* replace911_1 -> search873_1 in the cache */
static const nir_search_expression replace911 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &search873_1.value },
   NULL,
};

   /* search912_0_0 -> search0_0 in the cache */
/* search912_0 -> replace829 in the cache */

/* search912_1_0 -> replace564_1_0 in the cache */
/* search912_1 -> search891_1 in the cache */
static const nir_search_expression search912 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace829.value, &search891_1.value },
   NULL,
};

   /* replace912_0 -> search0_0 in the cache */

/* replace912_1_0 -> replace564_1_0 in the cache */
/* replace912_1 -> search873_1 in the cache */
static const nir_search_expression replace912 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &search873_1.value },
   NULL,
};

   /* search913_0_0 -> search877_0_0 in the cache */
/* search913_0 -> search895_0 in the cache */

/* search913_1_0 -> search907_1_0 in the cache */
/* search913_1 -> search907_1 in the cache */
static const nir_search_expression search913 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search895_0.value, &search907_1.value },
   NULL,
};

   /* replace913_0_0 -> search877_0_0 in the cache */
/* replace913_0 -> search877_0 in the cache */

/* replace913_1 -> search907_1_0 in the cache */
static const nir_search_expression replace913 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search877_0.value, &search907_1_0.value },
   NULL,
};

   /* search914_0_0 -> search877_0_0 in the cache */
/* search914_0 -> search895_0 in the cache */

/* search914_1_0 -> search907_1_0 in the cache */
/* search914_1 -> search907_1 in the cache */
static const nir_search_expression search914 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search895_0.value, &search907_1.value },
   NULL,
};

   /* replace914_0_0 -> search877_0_0 in the cache */
/* replace914_0 -> search877_0 in the cache */

/* replace914_1 -> search907_1_0 in the cache */
static const nir_search_expression replace914 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search877_0.value, &search907_1_0.value },
   NULL,
};

   /* search915_0_0 -> search0_0 in the cache */
/* search915_0 -> replace829 in the cache */

/* search915_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search915_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search915 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace829.value, &search915_1.value },
   NULL,
};

   /* replace915_0 -> search0_0 in the cache */

/* replace915_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace915_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace915 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace915_1.value },
   NULL,
};

   /* search916_0_0 -> search0_0 in the cache */
/* search916_0 -> replace829 in the cache */

/* search916_1_0 -> replace0_1_0 in the cache */
/* search916_1 -> search915_1 in the cache */
static const nir_search_expression search916 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace829.value, &search915_1.value },
   NULL,
};

   /* replace916_0 -> search0_0 in the cache */

/* replace916_1_0 -> replace0_1_0 in the cache */
/* replace916_1 -> replace915_1 in the cache */
static const nir_search_expression replace916 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace915_1.value },
   NULL,
};

   /* search917_0_0 -> search0_0 in the cache */
/* search917_0 -> replace829 in the cache */

/* search917_1_0 -> replace0_1_0 in the cache */
/* search917_1 -> search915_1 in the cache */
static const nir_search_expression search917 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace829.value, &search915_1.value },
   NULL,
};

   /* replace917_0 -> search0_0 in the cache */

/* replace917_1_0 -> replace0_1_0 in the cache */
/* replace917_1 -> replace915_1 in the cache */
static const nir_search_expression replace917 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace915_1.value },
   NULL,
};

   /* search918_0_0 -> search0_0 in the cache */
/* search918_0 -> replace829 in the cache */

/* search918_1_0 -> replace0_1_0 in the cache */
/* search918_1 -> search915_1 in the cache */
static const nir_search_expression search918 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace829.value, &search915_1.value },
   NULL,
};

   /* replace918_0 -> search0_0 in the cache */

/* replace918_1_0 -> replace0_1_0 in the cache */
/* replace918_1 -> replace915_1 in the cache */
static const nir_search_expression replace918 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace915_1.value },
   NULL,
};

   static const nir_search_variable search919_0_0 = {
   { nir_search_value_variable, 32 },
   0, /* b */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search919_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &search919_0_0.value },
   NULL,
};

/* search919_1_0 -> search907_1_0 in the cache */
/* search919_1 -> search907_1 in the cache */
static const nir_search_expression search919 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search919_0.value, &search907_1.value },
   NULL,
};

   /* replace919_0_0 -> search919_0_0 in the cache */
static const nir_search_expression replace919_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search919_0_0.value },
   NULL,
};

/* replace919_1 -> search907_1_0 in the cache */
static const nir_search_expression replace919 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace919_0.value, &search907_1_0.value },
   NULL,
};

   /* search920_0_0 -> search919_0_0 in the cache */
/* search920_0 -> search919_0 in the cache */

/* search920_1_0 -> search907_1_0 in the cache */
/* search920_1 -> search907_1 in the cache */
static const nir_search_expression search920 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search919_0.value, &search907_1.value },
   NULL,
};

   /* replace920_0_0 -> search919_0_0 in the cache */
/* replace920_0 -> replace919_0 in the cache */

/* replace920_1 -> search907_1_0 in the cache */
static const nir_search_expression replace920 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace919_0.value, &search907_1_0.value },
   NULL,
};

   /* search921_0_0 -> search0_0 in the cache */
/* search921_0 -> replace829 in the cache */

/* search921_1 -> search861_1 in the cache */
static const nir_search_expression search921 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace829.value, &search861_1.value },
   NULL,
};

   /* replace921_0_0 -> search0_0 in the cache */

/* replace921_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace921_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace921_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &replace921_0_1.value },
   NULL,
};

/* replace921_1_0_0_0 -> search57_1_1 in the cache */
/* replace921_1_0_0 -> replace921_0_1 in the cache */
static const nir_search_expression replace921_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_i2i64,
   { &replace921_0_1.value },
   NULL,
};

/* replace921_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace921_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace921_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace921 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace921_0.value, &replace921_1.value },
   NULL,
};

   /* search922_0_0 -> search0_0 in the cache */
/* search922_0 -> replace829 in the cache */

/* search922_1 -> search861_1 in the cache */
static const nir_search_expression search922 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace829.value, &search861_1.value },
   NULL,
};

   /* replace922_0_0 -> search0_0 in the cache */

/* replace922_0_1_0 -> search57_1_1 in the cache */
/* replace922_0_1 -> replace921_0_1 in the cache */
static const nir_search_expression replace922_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search0_0.value, &replace921_0_1.value },
   NULL,
};

/* replace922_1_0_0_0 -> search57_1_1 in the cache */
/* replace922_1_0_0 -> replace921_0_1 in the cache */
/* replace922_1_0 -> replace921_1_0 in the cache */

/* replace922_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace922_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace921_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace922 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace922_0.value, &replace922_1.value },
   NULL,
};

   /* search923_0_0 -> search0_0 in the cache */
/* search923_0 -> replace829 in the cache */

/* search923_1 -> search861_1 in the cache */
static const nir_search_expression search923 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace829.value, &search861_1.value },
   NULL,
};

   static const nir_search_constant replace923_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { -0x80000000 /* -2147483648 */ },
};

/* replace923_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace923_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace923_0_0.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace923_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0x7fffffff /* 2147483647 */ },
};

/* replace923_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace923_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace923_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace923_1_1_0 -> search0_0 in the cache */

/* replace923_1_1_1_0 -> search57_1_1 in the cache */
/* replace923_1_1_1 -> replace921_0_1 in the cache */
static const nir_search_expression replace923_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search0_0.value, &replace921_0_1.value },
   NULL,
};
static const nir_search_expression replace923_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace923_1_0.value, &replace923_1_1.value },
   NULL,
};
static const nir_search_expression replace923 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace923_0.value, &replace923_1.value },
   NULL,
};

   /* search924_0 -> search864_0 in the cache */

/* search924_1_0 -> replace0_1_0 in the cache */
/* search924_1 -> search915_1 in the cache */
static const nir_search_expression search924 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search864_0.value, &search915_1.value },
   NULL,
};

   /* replace924_0_0 -> search57_0 in the cache */

/* replace924_0_1 -> replace923_1_0_0 in the cache */
static const nir_search_expression replace924_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace923_1_0_0.value },
   NULL,
};

/* replace924_1_0_0 -> search57_0 in the cache */

/* replace924_1_0_1 -> replace923_0_0 in the cache */
static const nir_search_expression replace924_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &search57_0.value, &replace923_0_0.value },
   NULL,
};

/* replace924_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace924_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_i2i32,
   { &search57_0.value },
   NULL,
};

/* replace924_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace924_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ilt,
   { &replace924_1_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace924_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace924_1_0.value, &replace924_1_1.value },
   NULL,
};
static const nir_search_expression replace924 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace924_0.value, &replace924_1.value },
   NULL,
};

   /* search925_0_0 -> search0_0 in the cache */
/* search925_0 -> replace829 in the cache */

/* search925_1 -> search861_1 in the cache */
static const nir_search_expression search925 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace829.value, &search861_1.value },
   NULL,
};

   /* replace925_0_0 -> replace923_1_0_0 in the cache */

/* replace925_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace925_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace923_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace925_1_0_0 -> replace923_0_0 in the cache */

/* replace925_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace925_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace923_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace925_1_1_0 -> search0_0 in the cache */

/* replace925_1_1_1_0 -> search57_1_1 in the cache */
/* replace925_1_1_1 -> replace921_0_1 in the cache */
static const nir_search_expression replace925_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search0_0.value, &replace921_0_1.value },
   NULL,
};
static const nir_search_expression replace925_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace925_1_0.value, &replace925_1_1.value },
   NULL,
};
static const nir_search_expression replace925 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace925_0.value, &replace925_1.value },
   NULL,
};

   /* search926_0 -> search864_0 in the cache */

/* search926_1_0 -> replace0_1_0 in the cache */
/* search926_1 -> search915_1 in the cache */
static const nir_search_expression search926 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search864_0.value, &search915_1.value },
   NULL,
};

   /* replace926_0_0 -> search57_0 in the cache */

/* replace926_0_1 -> replace923_0_0 in the cache */
static const nir_search_expression replace926_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace923_0_0.value },
   NULL,
};

/* replace926_1_0_0 -> search57_0 in the cache */

/* replace926_1_0_1 -> replace923_1_0_0 in the cache */
static const nir_search_expression replace926_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &search57_0.value, &replace923_1_0_0.value },
   NULL,
};

/* replace926_1_1_0_0 -> search57_0 in the cache */
/* replace926_1_1_0 -> replace924_1_1_0 in the cache */

/* replace926_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace926_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ige,
   { &replace924_1_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace926_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace926_1_0.value, &replace926_1_1.value },
   NULL,
};
static const nir_search_expression replace926 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace926_0.value, &replace926_1.value },
   NULL,
};

   /* search927_0_0 -> search98_0_0 in the cache */
/* search927_0 -> replace786 in the cache */

/* search927_1_0 -> search699_1 in the cache */
static const nir_search_expression search927_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression search927 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace786.value, &search927_1.value },
   NULL,
};

   /* replace927_0 -> search98_0_0 in the cache */

/* replace927_1_0 -> search699_1 in the cache */
static const nir_search_expression replace927_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression replace927 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace927_1.value },
   NULL,
};

   /* search928_0_0 -> search98_0_0 in the cache */
/* search928_0 -> replace786 in the cache */

/* search928_1_0 -> search699_1 in the cache */
/* search928_1 -> search927_1 in the cache */
static const nir_search_expression search928 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace786.value, &search927_1.value },
   NULL,
};

   /* replace928_0 -> search98_0_0 in the cache */

/* replace928_1_0 -> search699_1 in the cache */
/* replace928_1 -> replace927_1 in the cache */
static const nir_search_expression replace928 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace927_1.value },
   NULL,
};

   /* search929_0_0 -> search98_0_0 in the cache */
/* search929_0 -> replace786 in the cache */

/* search929_1_0 -> search699_1 in the cache */
/* search929_1 -> search927_1 in the cache */
static const nir_search_expression search929 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace786.value, &search927_1.value },
   NULL,
};

   /* replace929_0 -> search98_0_0 in the cache */

/* replace929_1_0 -> search699_1 in the cache */
/* replace929_1 -> replace927_1 in the cache */
static const nir_search_expression replace929 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace927_1.value },
   NULL,
};

   /* search930_0_0 -> search98_0_0 in the cache */
/* search930_0 -> replace786 in the cache */

/* search930_1_0 -> search699_1 in the cache */
/* search930_1 -> search927_1 in the cache */
static const nir_search_expression search930 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace786.value, &search927_1.value },
   NULL,
};

   /* replace930_0 -> search98_0_0 in the cache */

/* replace930_1_0 -> search699_1 in the cache */
/* replace930_1 -> replace927_1 in the cache */
static const nir_search_expression replace930 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace927_1.value },
   NULL,
};

   /* search931_0_0 -> search835_0_0 in the cache */
static const nir_search_expression search931_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search835_0_0.value },
   NULL,
};

/* search931_1_0 -> search835_1_0 in the cache */
static const nir_search_expression search931_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search835_1_0.value },
   NULL,
};
static const nir_search_expression search931 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search931_0.value, &search931_1.value },
   NULL,
};

   /* replace931_0_0 -> search835_0_0 in the cache */
static const nir_search_expression replace931_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search835_0_0.value },
   NULL,
};

/* replace931_1 -> search835_1_0 in the cache */
static const nir_search_expression replace931 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace931_0.value, &search835_1_0.value },
   NULL,
};

   /* search932_0_0 -> search835_0_0 in the cache */
/* search932_0 -> search931_0 in the cache */

/* search932_1_0 -> search835_1_0 in the cache */
/* search932_1 -> search931_1 in the cache */
static const nir_search_expression search932 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search931_0.value, &search931_1.value },
   NULL,
};

   /* replace932_0_0 -> search835_0_0 in the cache */
/* replace932_0 -> replace931_0 in the cache */

/* replace932_1 -> search835_1_0 in the cache */
static const nir_search_expression replace932 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace931_0.value, &search835_1_0.value },
   NULL,
};

   /* search933_0_0 -> search98_0_0 in the cache */
/* search933_0 -> replace786 in the cache */

/* search933_1 -> search564_0_1 in the cache */
static const nir_search_expression search933 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace786.value, &search564_0_1.value },
   NULL,
};

   /* replace933_0_0 -> search98_0_0 in the cache */

/* replace933_0_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression replace933_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace933_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace933_0_1.value },
   NULL,
};

/* replace933_1_0_0_0 -> replace564_1_0 in the cache */
/* replace933_1_0_0 -> replace933_0_1 in the cache */
static const nir_search_expression replace933_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace933_0_1.value },
   NULL,
};

/* replace933_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace933_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace933_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace933 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace933_0.value, &replace933_1.value },
   NULL,
};

   /* search934_0_0 -> search98_0_0 in the cache */
/* search934_0 -> replace786 in the cache */

/* search934_1 -> search564_0_1 in the cache */
static const nir_search_expression search934 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace786.value, &search564_0_1.value },
   NULL,
};

   /* replace934_0_0 -> search98_0_0 in the cache */

/* replace934_0_1_0 -> replace564_1_0 in the cache */
/* replace934_0_1 -> replace933_0_1 in the cache */
static const nir_search_expression replace934_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace933_0_1.value },
   NULL,
};

/* replace934_1_0_0_0 -> replace564_1_0 in the cache */
/* replace934_1_0_0 -> replace933_0_1 in the cache */
/* replace934_1_0 -> replace933_1_0 in the cache */

/* replace934_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace934_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace933_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace934 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace934_0.value, &replace934_1.value },
   NULL,
};

   /* search935_0_0 -> search98_0_0 in the cache */
/* search935_0 -> replace786 in the cache */

/* search935_1 -> search564_0_1 in the cache */
static const nir_search_expression search935 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace786.value, &search564_0_1.value },
   NULL,
};

   /* replace935_0_0 -> replace101_2 in the cache */

/* replace935_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace935_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace101_2.value, &replace564_1_0.value },
   NULL,
};

static const nir_search_constant replace935_1_0_0 = {
   { nir_search_value_constant, 16 },
   nir_type_int, { 0xff /* 255 */ },
};

/* replace935_1_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace935_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace935_1_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace935_1_1_0 -> search98_0_0 in the cache */

/* replace935_1_1_1_0 -> replace564_1_0 in the cache */
/* replace935_1_1_1 -> replace933_0_1 in the cache */
static const nir_search_expression replace935_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace933_0_1.value },
   NULL,
};
static const nir_search_expression replace935_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace935_1_0.value, &replace935_1_1.value },
   NULL,
};
static const nir_search_expression replace935 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace935_0.value, &replace935_1.value },
   NULL,
};

   /* search936_0 -> search840_0 in the cache */

/* search936_1_0 -> search699_1 in the cache */
/* search936_1 -> search927_1 in the cache */
static const nir_search_expression search936 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search840_0.value, &search927_1.value },
   NULL,
};

   /* replace936_0_0 -> search101_0_0 in the cache */

/* replace936_0_1 -> replace935_1_0_0 in the cache */
static const nir_search_expression replace936_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace935_1_0_0.value },
   NULL,
};

/* replace936_1_0_0 -> search101_0_0 in the cache */

/* replace936_1_0_1 -> replace101_2 in the cache */
static const nir_search_expression replace936_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

/* replace936_1_1_0_0 -> search101_0_0 in the cache */
static const nir_search_expression replace936_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search101_0_0.value },
   NULL,
};

/* replace936_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace936_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace936_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace936_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace936_1_0.value, &replace936_1_1.value },
   NULL,
};
static const nir_search_expression replace936 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace936_0.value, &replace936_1.value },
   NULL,
};

   /* search937_0_0 -> search98_0_0 in the cache */
/* search937_0 -> replace786 in the cache */

/* search937_1 -> search564_0_1 in the cache */
static const nir_search_expression search937 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace786.value, &search564_0_1.value },
   NULL,
};

   /* replace937_0_0 -> replace935_1_0_0 in the cache */

/* replace937_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace937_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace935_1_0_0.value, &replace564_1_0.value },
   NULL,
};

/* replace937_1_0_0 -> replace101_2 in the cache */

/* replace937_1_0_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace937_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace101_2.value, &replace564_1_0.value },
   NULL,
};

/* replace937_1_1_0 -> search98_0_0 in the cache */

/* replace937_1_1_1_0 -> replace564_1_0 in the cache */
/* replace937_1_1_1 -> replace933_0_1 in the cache */
static const nir_search_expression replace937_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace933_0_1.value },
   NULL,
};
static const nir_search_expression replace937_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace937_1_0.value, &replace937_1_1.value },
   NULL,
};
static const nir_search_expression replace937 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace937_0.value, &replace937_1.value },
   NULL,
};

   /* search938_0 -> search840_0 in the cache */

/* search938_1_0 -> search699_1 in the cache */
/* search938_1 -> search927_1 in the cache */
static const nir_search_expression search938 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search840_0.value, &search927_1.value },
   NULL,
};

   /* replace938_0_0 -> search101_0_0 in the cache */

/* replace938_0_1 -> replace101_2 in the cache */
static const nir_search_expression replace938_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace101_2.value },
   NULL,
};

/* replace938_1_0_0 -> search101_0_0 in the cache */

/* replace938_1_0_1 -> replace935_1_0_0 in the cache */
static const nir_search_expression replace938_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace935_1_0_0.value },
   NULL,
};

/* replace938_1_1_0_0 -> search101_0_0 in the cache */
/* replace938_1_1_0 -> replace936_1_1_0 in the cache */

/* replace938_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace938_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace936_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace938_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace938_1_0.value, &replace938_1_1.value },
   NULL,
};
static const nir_search_expression replace938 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace938_0.value, &replace938_1.value },
   NULL,
};

   /* search939_0_0 -> search98_0_0 in the cache */
/* search939_0 -> replace800 in the cache */

/* search939_1_0 -> search699_1 in the cache */
static const nir_search_expression search939_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression search939 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace800.value, &search939_1.value },
   NULL,
};

   /* replace939_0 -> search98_0_0 in the cache */

/* replace939_1_0 -> search699_1 in the cache */
/* replace939_1 -> replace927_1 in the cache */
/* replace939 -> replace927 in the cache */

   /* search940_0_0 -> search98_0_0 in the cache */
/* search940_0 -> replace800 in the cache */

/* search940_1_0 -> search699_1 in the cache */
/* search940_1 -> search939_1 in the cache */
static const nir_search_expression search940 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace800.value, &search939_1.value },
   NULL,
};

   /* replace940_0 -> search98_0_0 in the cache */

/* replace940_1_0 -> search699_1 in the cache */
/* replace940_1 -> replace927_1 in the cache */
/* replace940 -> replace928 in the cache */

   /* search941_0_0 -> search98_0_0 in the cache */
/* search941_0 -> replace800 in the cache */

/* search941_1_0 -> search699_1 in the cache */
/* search941_1 -> search939_1 in the cache */
static const nir_search_expression search941 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace800.value, &search939_1.value },
   NULL,
};

   /* replace941_0 -> search98_0_0 in the cache */

/* replace941_1_0 -> search699_1 in the cache */
/* replace941_1 -> replace927_1 in the cache */
/* replace941 -> replace929 in the cache */

   /* search942_0_0 -> search98_0_0 in the cache */
/* search942_0 -> replace800 in the cache */

/* search942_1_0 -> search699_1 in the cache */
/* search942_1 -> search939_1 in the cache */
static const nir_search_expression search942 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace800.value, &search939_1.value },
   NULL,
};

   /* replace942_0 -> search98_0_0 in the cache */

/* replace942_1_0 -> search699_1 in the cache */
/* replace942_1 -> replace927_1 in the cache */
/* replace942 -> replace930 in the cache */

   /* search943_0_0 -> search835_0_0 in the cache */
static const nir_search_expression search943_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search835_0_0.value },
   NULL,
};

/* search943_1_0 -> search835_1_0 in the cache */
static const nir_search_expression search943_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search835_1_0.value },
   NULL,
};
static const nir_search_expression search943 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search943_0.value, &search943_1.value },
   NULL,
};

   /* replace943_0_0 -> search835_0_0 in the cache */
/* replace943_0 -> replace931_0 in the cache */

/* replace943_1 -> search835_1_0 in the cache */
/* replace943 -> replace931 in the cache */

   /* search944_0_0 -> search835_0_0 in the cache */
/* search944_0 -> search943_0 in the cache */

/* search944_1_0 -> search835_1_0 in the cache */
/* search944_1 -> search943_1 in the cache */
static const nir_search_expression search944 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search943_0.value, &search943_1.value },
   NULL,
};

   /* replace944_0_0 -> search835_0_0 in the cache */
/* replace944_0 -> replace931_0 in the cache */

/* replace944_1 -> search835_1_0 in the cache */
/* replace944 -> replace932 in the cache */

   /* search945_0_0 -> search98_0_0 in the cache */
/* search945_0 -> replace800 in the cache */

/* search945_1 -> search2_1 in the cache */
static const nir_search_expression search945 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace800.value, &search2_1.value },
   NULL,
};

   /* replace945_0_0 -> search98_0_0 in the cache */

/* replace945_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace945_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace945_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace945_0_1.value },
   NULL,
};

/* replace945_1_0_0_0 -> replace0_1_0 in the cache */
/* replace945_1_0_0 -> replace945_0_1 in the cache */
static const nir_search_expression replace945_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace945_0_1.value },
   NULL,
};

/* replace945_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace945_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace945_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace945 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace945_0.value, &replace945_1.value },
   NULL,
};

   /* search946_0_0 -> search98_0_0 in the cache */
/* search946_0 -> replace800 in the cache */

/* search946_1 -> search2_1 in the cache */
static const nir_search_expression search946 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace800.value, &search2_1.value },
   NULL,
};

   /* replace946_0_0 -> search98_0_0 in the cache */

/* replace946_0_1_0 -> replace0_1_0 in the cache */
/* replace946_0_1 -> replace945_0_1 in the cache */
static const nir_search_expression replace946_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace945_0_1.value },
   NULL,
};

/* replace946_1_0_0_0 -> replace0_1_0 in the cache */
/* replace946_1_0_0 -> replace945_0_1 in the cache */
/* replace946_1_0 -> replace945_1_0 in the cache */

/* replace946_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace946_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace945_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace946 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace946_0.value, &replace946_1.value },
   NULL,
};

   /* search947_0_0 -> search98_0_0 in the cache */
/* search947_0 -> replace800 in the cache */

/* search947_1 -> search2_1 in the cache */
static const nir_search_expression search947 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace800.value, &search2_1.value },
   NULL,
};

   /* replace947_0_0 -> search26_1 in the cache */

/* replace947_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace947_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search26_1.value, &replace0_1_0.value },
   NULL,
};

/* replace947_1_0_0 -> replace98_0_0_0_1 in the cache */

/* replace947_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace947_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace98_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace947_1_1_0 -> search98_0_0 in the cache */

/* replace947_1_1_1_0 -> replace0_1_0 in the cache */
/* replace947_1_1_1 -> replace945_0_1 in the cache */
static const nir_search_expression replace947_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace945_0_1.value },
   NULL,
};
static const nir_search_expression replace947_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace947_1_0.value, &replace947_1_1.value },
   NULL,
};
static const nir_search_expression replace947 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace947_0.value, &replace947_1.value },
   NULL,
};

   /* search948_0 -> search852_0 in the cache */

/* search948_1_0 -> search699_1 in the cache */
/* search948_1 -> search939_1 in the cache */
static const nir_search_expression search948 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search852_0.value, &search939_1.value },
   NULL,
};

   /* replace948_0_0 -> search0_0 in the cache */

/* replace948_0_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace948_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace948_1_0_0 -> search0_0 in the cache */

/* replace948_1_0_1 -> search26_1 in the cache */
static const nir_search_expression replace948_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* replace948_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace948_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search0_0.value },
   NULL,
};

/* replace948_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace948_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace948_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace948_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace948_1_0.value, &replace948_1_1.value },
   NULL,
};
static const nir_search_expression replace948 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace948_0.value, &replace948_1.value },
   NULL,
};

   /* search949_0_0 -> search98_0_0 in the cache */
/* search949_0 -> replace800 in the cache */

/* search949_1 -> search2_1 in the cache */
static const nir_search_expression search949 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace800.value, &search2_1.value },
   NULL,
};

   /* replace949_0_0 -> replace98_0_0_0_1 in the cache */

/* replace949_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace949_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace98_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace949_1_0_0 -> search26_1 in the cache */

/* replace949_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace949_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search26_1.value, &replace0_1_0.value },
   NULL,
};

/* replace949_1_1_0 -> search98_0_0 in the cache */

/* replace949_1_1_1_0 -> replace0_1_0 in the cache */
/* replace949_1_1_1 -> replace945_0_1 in the cache */
static const nir_search_expression replace949_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace945_0_1.value },
   NULL,
};
static const nir_search_expression replace949_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace949_1_0.value, &replace949_1_1.value },
   NULL,
};
static const nir_search_expression replace949 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace949_0.value, &replace949_1.value },
   NULL,
};

   /* search950_0 -> search852_0 in the cache */

/* search950_1_0 -> search699_1 in the cache */
/* search950_1 -> search939_1 in the cache */
static const nir_search_expression search950 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search852_0.value, &search939_1.value },
   NULL,
};

   /* replace950_0_0 -> search0_0 in the cache */

/* replace950_0_1 -> search26_1 in the cache */
static const nir_search_expression replace950_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search26_1.value },
   NULL,
};

/* replace950_1_0_0 -> search0_0 in the cache */

/* replace950_1_0_1 -> replace98_0_0_0_1 in the cache */
static const nir_search_expression replace950_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace98_0_0_0_1.value },
   NULL,
};

/* replace950_1_1_0_0 -> search0_0 in the cache */
/* replace950_1_1_0 -> replace948_1_1_0 in the cache */

/* replace950_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace950_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace948_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace950_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace950_1_0.value, &replace950_1_1.value },
   NULL,
};
static const nir_search_expression replace950 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace950_0.value, &replace950_1.value },
   NULL,
};

   /* search951_0_0 -> search98_0_0 in the cache */
/* search951_0 -> replace816 in the cache */

/* search951_1_0 -> search699_1 in the cache */
static const nir_search_expression search951_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search699_1.value },
   NULL,
};
static const nir_search_expression search951 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace816.value, &search951_1.value },
   NULL,
};

   /* replace951_0 -> search98_0_0 in the cache */

/* replace951_1_0 -> search699_1 in the cache */
/* replace951_1 -> replace927_1 in the cache */
/* replace951 -> replace927 in the cache */

   /* search952_0_0 -> search98_0_0 in the cache */
/* search952_0 -> replace816 in the cache */

/* search952_1_0 -> search699_1 in the cache */
/* search952_1 -> search951_1 in the cache */
static const nir_search_expression search952 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace816.value, &search951_1.value },
   NULL,
};

   /* replace952_0 -> search98_0_0 in the cache */

/* replace952_1_0 -> search699_1 in the cache */
/* replace952_1 -> replace927_1 in the cache */
/* replace952 -> replace928 in the cache */

   /* search953_0_0 -> search98_0_0 in the cache */
/* search953_0 -> replace816 in the cache */

/* search953_1_0 -> search699_1 in the cache */
/* search953_1 -> search951_1 in the cache */
static const nir_search_expression search953 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace816.value, &search951_1.value },
   NULL,
};

   /* replace953_0 -> search98_0_0 in the cache */

/* replace953_1_0 -> search699_1 in the cache */
/* replace953_1 -> replace927_1 in the cache */
/* replace953 -> replace929 in the cache */

   /* search954_0_0 -> search98_0_0 in the cache */
/* search954_0 -> replace816 in the cache */

/* search954_1_0 -> search699_1 in the cache */
/* search954_1 -> search951_1 in the cache */
static const nir_search_expression search954 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace816.value, &search951_1.value },
   NULL,
};

   /* replace954_0 -> search98_0_0 in the cache */

/* replace954_1_0 -> search699_1 in the cache */
/* replace954_1 -> replace927_1 in the cache */
/* replace954 -> replace930 in the cache */

   /* search955_0_0 -> search835_0_0 in the cache */
static const nir_search_expression search955_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search835_0_0.value },
   NULL,
};

/* search955_1_0 -> search835_1_0 in the cache */
static const nir_search_expression search955_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search835_1_0.value },
   NULL,
};
static const nir_search_expression search955 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search955_0.value, &search955_1.value },
   NULL,
};

   /* replace955_0_0 -> search835_0_0 in the cache */
/* replace955_0 -> replace931_0 in the cache */

/* replace955_1 -> search835_1_0 in the cache */
/* replace955 -> replace931 in the cache */

   /* search956_0_0 -> search835_0_0 in the cache */
/* search956_0 -> search955_0 in the cache */

/* search956_1_0 -> search835_1_0 in the cache */
/* search956_1 -> search955_1 in the cache */
static const nir_search_expression search956 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search955_0.value, &search955_1.value },
   NULL,
};

   /* replace956_0_0 -> search835_0_0 in the cache */
/* replace956_0 -> replace931_0 in the cache */

/* replace956_1 -> search835_1_0 in the cache */
/* replace956 -> replace932 in the cache */

   /* search957_0_0 -> search98_0_0 in the cache */
/* search957_0 -> replace816 in the cache */

/* search957_1 -> search861_1 in the cache */
static const nir_search_expression search957 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace816.value, &search861_1.value },
   NULL,
};

   /* replace957_0_0 -> search98_0_0 in the cache */

/* replace957_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace957_0_1 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace957_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search98_0_0.value, &replace957_0_1.value },
   NULL,
};

/* replace957_1_0_0_0 -> search57_1_1 in the cache */
/* replace957_1_0_0 -> replace957_0_1 in the cache */
static const nir_search_expression replace957_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace957_0_1.value },
   NULL,
};

/* replace957_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace957_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace957_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace957 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace957_0.value, &replace957_1.value },
   NULL,
};

   /* search958_0_0 -> search98_0_0 in the cache */
/* search958_0 -> replace816 in the cache */

/* search958_1 -> search861_1 in the cache */
static const nir_search_expression search958 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace816.value, &search861_1.value },
   NULL,
};

   /* replace958_0_0 -> search98_0_0 in the cache */

/* replace958_0_1_0 -> search57_1_1 in the cache */
/* replace958_0_1 -> replace957_0_1 in the cache */
static const nir_search_expression replace958_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search98_0_0.value, &replace957_0_1.value },
   NULL,
};

/* replace958_1_0_0_0 -> search57_1_1 in the cache */
/* replace958_1_0_0 -> replace957_0_1 in the cache */
/* replace958_1_0 -> replace957_1_0 in the cache */

/* replace958_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace958_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace957_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace958 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace958_0.value, &replace958_1.value },
   NULL,
};

   /* search959_0_0 -> search98_0_0 in the cache */
/* search959_0 -> replace816 in the cache */

/* search959_1 -> search861_1 in the cache */
static const nir_search_expression search959 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace816.value, &search861_1.value },
   NULL,
};

   /* replace959_0_0 -> replace107_2 in the cache */

/* replace959_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace959_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace107_2.value, &search57_1_1.value },
   NULL,
};

static const nir_search_constant replace959_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xff /* 255 */ },
};

/* replace959_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace959_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace959_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace959_1_1_0 -> search98_0_0 in the cache */

/* replace959_1_1_1_0 -> search57_1_1 in the cache */
/* replace959_1_1_1 -> replace957_0_1 in the cache */
static const nir_search_expression replace959_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search98_0_0.value, &replace957_0_1.value },
   NULL,
};
static const nir_search_expression replace959_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace959_1_0.value, &replace959_1_1.value },
   NULL,
};
static const nir_search_expression replace959 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace959_0.value, &replace959_1.value },
   NULL,
};

   /* search960_0 -> search864_0 in the cache */

/* search960_1_0 -> search699_1 in the cache */
/* search960_1 -> search951_1 in the cache */
static const nir_search_expression search960 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search864_0.value, &search951_1.value },
   NULL,
};

   /* replace960_0_0 -> search57_0 in the cache */

/* replace960_0_1 -> replace959_1_0_0 in the cache */
static const nir_search_expression replace960_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &replace959_1_0_0.value },
   NULL,
};

/* replace960_1_0_0 -> search57_0 in the cache */

/* replace960_1_0_1 -> replace107_2 in the cache */
static const nir_search_expression replace960_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

/* replace960_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace960_1_1_0 = {
   { nir_search_value_expression, 8 },
   false, false,
   -1, 0,
   nir_op_u2u8,
   { &search57_0.value },
   NULL,
};

/* replace960_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace960_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace960_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace960_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace960_1_0.value, &replace960_1_1.value },
   NULL,
};
static const nir_search_expression replace960 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace960_0.value, &replace960_1.value },
   NULL,
};

   /* search961_0_0 -> search98_0_0 in the cache */
/* search961_0 -> replace816 in the cache */

/* search961_1 -> search861_1 in the cache */
static const nir_search_expression search961 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace816.value, &search861_1.value },
   NULL,
};

   /* replace961_0_0 -> replace959_1_0_0 in the cache */

/* replace961_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace961_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace959_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace961_1_0_0 -> replace107_2 in the cache */

/* replace961_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace961_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace107_2.value, &search57_1_1.value },
   NULL,
};

/* replace961_1_1_0 -> search98_0_0 in the cache */

/* replace961_1_1_1_0 -> search57_1_1 in the cache */
/* replace961_1_1_1 -> replace957_0_1 in the cache */
static const nir_search_expression replace961_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search98_0_0.value, &replace957_0_1.value },
   NULL,
};
static const nir_search_expression replace961_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace961_1_0.value, &replace961_1_1.value },
   NULL,
};
static const nir_search_expression replace961 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace961_0.value, &replace961_1.value },
   NULL,
};

   /* search962_0 -> search864_0 in the cache */

/* search962_1_0 -> search699_1 in the cache */
/* search962_1 -> search951_1 in the cache */
static const nir_search_expression search962 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search864_0.value, &search951_1.value },
   NULL,
};

   /* replace962_0_0 -> search57_0 in the cache */

/* replace962_0_1 -> replace107_2 in the cache */
static const nir_search_expression replace962_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &replace107_2.value },
   NULL,
};

/* replace962_1_0_0 -> search57_0 in the cache */

/* replace962_1_0_1 -> replace959_1_0_0 in the cache */
static const nir_search_expression replace962_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &replace959_1_0_0.value },
   NULL,
};

/* replace962_1_1_0_0 -> search57_0 in the cache */
/* replace962_1_1_0 -> replace960_1_1_0 in the cache */

/* replace962_1_1_1 -> search699_1 in the cache */
static const nir_search_expression replace962_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace960_1_1_0.value, &search699_1.value },
   NULL,
};
static const nir_search_expression replace962_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace962_1_0.value, &replace962_1_1.value },
   NULL,
};
static const nir_search_expression replace962 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace962_0.value, &replace962_1.value },
   NULL,
};

   /* search963_0_0 -> search101_0_0 in the cache */
/* search963_0 -> replace806 in the cache */

/* search963_1_0 -> search699_1 in the cache */
/* search963_1 -> search939_1 in the cache */
static const nir_search_expression search963 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace806.value, &search939_1.value },
   NULL,
};

   /* replace963_0 -> search101_0_0 in the cache */

/* replace963_1_0 -> search699_1 in the cache */
/* replace963_1 -> search927_1 in the cache */
static const nir_search_expression replace963 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &search927_1.value },
   NULL,
};

   /* search964_0_0 -> search101_0_0 in the cache */
/* search964_0 -> replace806 in the cache */

/* search964_1_0 -> search699_1 in the cache */
/* search964_1 -> search939_1 in the cache */
static const nir_search_expression search964 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace806.value, &search939_1.value },
   NULL,
};

   /* replace964_0 -> search101_0_0 in the cache */

/* replace964_1_0 -> search699_1 in the cache */
/* replace964_1 -> search927_1 in the cache */
static const nir_search_expression replace964 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &search927_1.value },
   NULL,
};

   /* search965_0_0 -> search101_0_0 in the cache */
/* search965_0 -> replace806 in the cache */

/* search965_1_0 -> search699_1 in the cache */
/* search965_1 -> search939_1 in the cache */
static const nir_search_expression search965 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace806.value, &search939_1.value },
   NULL,
};

   /* replace965_0 -> search101_0_0 in the cache */

/* replace965_1_0 -> search699_1 in the cache */
/* replace965_1 -> search927_1 in the cache */
static const nir_search_expression replace965 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &search927_1.value },
   NULL,
};

   /* search966_0_0 -> search101_0_0 in the cache */
/* search966_0 -> replace806 in the cache */

/* search966_1_0 -> search699_1 in the cache */
/* search966_1 -> search939_1 in the cache */
static const nir_search_expression search966 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace806.value, &search939_1.value },
   NULL,
};

   /* replace966_0 -> search101_0_0 in the cache */

/* replace966_1_0 -> search699_1 in the cache */
/* replace966_1 -> search927_1 in the cache */
static const nir_search_expression replace966 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &search927_1.value },
   NULL,
};

   /* search967_0_0 -> search835_0_0 in the cache */
/* search967_0 -> search943_0 in the cache */

/* search967_1_0 -> search871_1_0 in the cache */
static const nir_search_expression search967_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search871_1_0.value },
   NULL,
};
static const nir_search_expression search967 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search943_0.value, &search967_1.value },
   NULL,
};

   /* replace967_0_0 -> search835_0_0 in the cache */
/* replace967_0 -> search931_0 in the cache */

/* replace967_1 -> search871_1_0 in the cache */
static const nir_search_expression replace967 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search931_0.value, &search871_1_0.value },
   NULL,
};

   /* search968_0_0 -> search835_0_0 in the cache */
/* search968_0 -> search943_0 in the cache */

/* search968_1_0 -> search871_1_0 in the cache */
/* search968_1 -> search967_1 in the cache */
static const nir_search_expression search968 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search943_0.value, &search967_1.value },
   NULL,
};

   /* replace968_0_0 -> search835_0_0 in the cache */
/* replace968_0 -> search931_0 in the cache */

/* replace968_1 -> search871_1_0 in the cache */
static const nir_search_expression replace968 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search931_0.value, &search871_1_0.value },
   NULL,
};

   /* search969_0_0 -> search101_0_0 in the cache */
/* search969_0 -> replace806 in the cache */

/* search969_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression search969_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression search969 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace806.value, &search969_1.value },
   NULL,
};

   /* replace969_0 -> search101_0_0 in the cache */

/* replace969_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression replace969_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace969 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace969_1.value },
   NULL,
};

   /* search970_0_0 -> search101_0_0 in the cache */
/* search970_0 -> replace806 in the cache */

/* search970_1_0 -> replace564_1_0 in the cache */
/* search970_1 -> search969_1 in the cache */
static const nir_search_expression search970 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace806.value, &search969_1.value },
   NULL,
};

   /* replace970_0 -> search101_0_0 in the cache */

/* replace970_1_0 -> replace564_1_0 in the cache */
/* replace970_1 -> replace969_1 in the cache */
static const nir_search_expression replace970 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace969_1.value },
   NULL,
};

   /* search971_0_0 -> search101_0_0 in the cache */
/* search971_0 -> replace806 in the cache */

/* search971_1_0 -> replace564_1_0 in the cache */
/* search971_1 -> search969_1 in the cache */
static const nir_search_expression search971 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace806.value, &search969_1.value },
   NULL,
};

   /* replace971_0 -> search101_0_0 in the cache */

/* replace971_1_0 -> replace564_1_0 in the cache */
/* replace971_1 -> replace969_1 in the cache */
static const nir_search_expression replace971 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace969_1.value },
   NULL,
};

   /* search972_0_0 -> search101_0_0 in the cache */
/* search972_0 -> replace806 in the cache */

/* search972_1_0 -> replace564_1_0 in the cache */
/* search972_1 -> search969_1 in the cache */
static const nir_search_expression search972 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace806.value, &search969_1.value },
   NULL,
};

   /* replace972_0 -> search101_0_0 in the cache */

/* replace972_1_0 -> replace564_1_0 in the cache */
/* replace972_1 -> replace969_1 in the cache */
static const nir_search_expression replace972 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace969_1.value },
   NULL,
};

   /* search973_0_0 -> search877_0_0 in the cache */
static const nir_search_expression search973_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search877_0_0.value },
   NULL,
};

/* search973_1_0 -> search871_1_0 in the cache */
/* search973_1 -> search967_1 in the cache */
static const nir_search_expression search973 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search973_0.value, &search967_1.value },
   NULL,
};

   /* replace973_0_0 -> search877_0_0 in the cache */
static const nir_search_expression replace973_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search877_0_0.value },
   NULL,
};

/* replace973_1 -> search871_1_0 in the cache */
static const nir_search_expression replace973 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace973_0.value, &search871_1_0.value },
   NULL,
};

   /* search974_0_0 -> search877_0_0 in the cache */
/* search974_0 -> search973_0 in the cache */

/* search974_1_0 -> search871_1_0 in the cache */
/* search974_1 -> search967_1 in the cache */
static const nir_search_expression search974 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search973_0.value, &search967_1.value },
   NULL,
};

   /* replace974_0_0 -> search877_0_0 in the cache */
/* replace974_0 -> replace973_0 in the cache */

/* replace974_1 -> search871_1_0 in the cache */
static const nir_search_expression replace974 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace973_0.value, &search871_1_0.value },
   NULL,
};

   /* search975_0_0 -> search101_0_0 in the cache */
/* search975_0 -> replace806 in the cache */

/* search975_1 -> search2_1 in the cache */
static const nir_search_expression search975 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace806.value, &search2_1.value },
   NULL,
};

   /* replace975_0_0 -> search101_0_0 in the cache */

/* replace975_0_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace975_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace975_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace975_0_1.value },
   NULL,
};

/* replace975_1_0_0_0 -> replace0_1_0 in the cache */
/* replace975_1_0_0 -> replace975_0_1 in the cache */
static const nir_search_expression replace975_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace975_0_1.value },
   NULL,
};

/* replace975_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace975_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace975_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace975 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace975_0.value, &replace975_1.value },
   NULL,
};

   /* search976_0_0 -> search101_0_0 in the cache */
/* search976_0 -> replace806 in the cache */

/* search976_1 -> search2_1 in the cache */
static const nir_search_expression search976 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace806.value, &search2_1.value },
   NULL,
};

   /* replace976_0_0 -> search101_0_0 in the cache */

/* replace976_0_1_0 -> replace0_1_0 in the cache */
/* replace976_0_1 -> replace975_0_1 in the cache */
static const nir_search_expression replace976_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace975_0_1.value },
   NULL,
};

/* replace976_1_0_0_0 -> replace0_1_0 in the cache */
/* replace976_1_0_0 -> replace975_0_1 in the cache */
/* replace976_1_0 -> replace975_1_0 in the cache */

/* replace976_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace976_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace975_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace976 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace976_0.value, &replace976_1.value },
   NULL,
};

   /* search977_0_0 -> search101_0_0 in the cache */
/* search977_0 -> replace806 in the cache */

/* search977_1 -> search2_1 in the cache */
static const nir_search_expression search977 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace806.value, &search2_1.value },
   NULL,
};

   /* replace977_0_0 -> search26_1 in the cache */

/* replace977_0_1 -> replace0_1_0 in the cache */
/* replace977_0 -> replace947_0 in the cache */

/* replace977_1_0_0 -> replace101_0_0_0_1 in the cache */

/* replace977_1_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace977_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace101_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace977_1_1_0 -> search101_0_0 in the cache */

/* replace977_1_1_1_0 -> replace0_1_0 in the cache */
/* replace977_1_1_1 -> replace975_0_1 in the cache */
static const nir_search_expression replace977_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace975_0_1.value },
   NULL,
};
static const nir_search_expression replace977_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace977_1_0.value, &replace977_1_1.value },
   NULL,
};
static const nir_search_expression replace977 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace947_0.value, &replace977_1.value },
   NULL,
};

   /* search978_0 -> search852_0 in the cache */

/* search978_1_0 -> replace564_1_0 in the cache */
/* search978_1 -> search969_1 in the cache */
static const nir_search_expression search978 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search852_0.value, &search969_1.value },
   NULL,
};

   /* replace978_0_0 -> search0_0 in the cache */

/* replace978_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace978_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace978_1_0_0 -> search0_0 in the cache */

/* replace978_1_0_1 -> search26_1 in the cache */
/* replace978_1_0 -> replace948_1_0 in the cache */

/* replace978_1_1_0_0 -> search0_0 in the cache */
static const nir_search_expression replace978_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search0_0.value },
   NULL,
};

/* replace978_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace978_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace978_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace978_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace948_1_0.value, &replace978_1_1.value },
   NULL,
};
static const nir_search_expression replace978 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace978_0.value, &replace978_1.value },
   NULL,
};

   /* search979_0_0 -> search101_0_0 in the cache */
/* search979_0 -> replace806 in the cache */

/* search979_1 -> search2_1 in the cache */
static const nir_search_expression search979 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace806.value, &search2_1.value },
   NULL,
};

   /* replace979_0_0 -> replace101_0_0_0_1 in the cache */

/* replace979_0_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace979_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace101_0_0_0_1.value, &replace0_1_0.value },
   NULL,
};

/* replace979_1_0_0 -> search26_1 in the cache */

/* replace979_1_0_1 -> replace0_1_0 in the cache */
/* replace979_1_0 -> replace949_1_0 in the cache */

/* replace979_1_1_0 -> search101_0_0 in the cache */

/* replace979_1_1_1_0 -> replace0_1_0 in the cache */
/* replace979_1_1_1 -> replace975_0_1 in the cache */
static const nir_search_expression replace979_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace975_0_1.value },
   NULL,
};
static const nir_search_expression replace979_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace949_1_0.value, &replace979_1_1.value },
   NULL,
};
static const nir_search_expression replace979 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace979_0.value, &replace979_1.value },
   NULL,
};

   /* search980_0 -> search852_0 in the cache */

/* search980_1_0 -> replace564_1_0 in the cache */
/* search980_1 -> search969_1 in the cache */
static const nir_search_expression search980 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search852_0.value, &search969_1.value },
   NULL,
};

   /* replace980_0_0 -> search0_0 in the cache */

/* replace980_0_1 -> search26_1 in the cache */
/* replace980_0 -> replace950_0 in the cache */

/* replace980_1_0_0 -> search0_0 in the cache */

/* replace980_1_0_1 -> replace101_0_0_0_1 in the cache */
static const nir_search_expression replace980_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace101_0_0_0_1.value },
   NULL,
};

/* replace980_1_1_0_0 -> search0_0 in the cache */
/* replace980_1_1_0 -> replace978_1_1_0 in the cache */

/* replace980_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace980_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace978_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace980_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace980_1_0.value, &replace980_1_1.value },
   NULL,
};
static const nir_search_expression replace980 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace950_0.value, &replace980_1.value },
   NULL,
};

   /* search981_0_0 -> search101_0_0 in the cache */
/* search981_0 -> replace822 in the cache */

/* search981_1_0 -> search699_1 in the cache */
/* search981_1 -> search951_1 in the cache */
static const nir_search_expression search981 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace822.value, &search951_1.value },
   NULL,
};

   /* replace981_0 -> search101_0_0 in the cache */

/* replace981_1_0 -> search699_1 in the cache */
/* replace981_1 -> search927_1 in the cache */
/* replace981 -> replace963 in the cache */

   /* search982_0_0 -> search101_0_0 in the cache */
/* search982_0 -> replace822 in the cache */

/* search982_1_0 -> search699_1 in the cache */
/* search982_1 -> search951_1 in the cache */
static const nir_search_expression search982 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace822.value, &search951_1.value },
   NULL,
};

   /* replace982_0 -> search101_0_0 in the cache */

/* replace982_1_0 -> search699_1 in the cache */
/* replace982_1 -> search927_1 in the cache */
/* replace982 -> replace964 in the cache */

   /* search983_0_0 -> search101_0_0 in the cache */
/* search983_0 -> replace822 in the cache */

/* search983_1_0 -> search699_1 in the cache */
/* search983_1 -> search951_1 in the cache */
static const nir_search_expression search983 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace822.value, &search951_1.value },
   NULL,
};

   /* replace983_0 -> search101_0_0 in the cache */

/* replace983_1_0 -> search699_1 in the cache */
/* replace983_1 -> search927_1 in the cache */
/* replace983 -> replace965 in the cache */

   /* search984_0_0 -> search101_0_0 in the cache */
/* search984_0 -> replace822 in the cache */

/* search984_1_0 -> search699_1 in the cache */
/* search984_1 -> search951_1 in the cache */
static const nir_search_expression search984 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace822.value, &search951_1.value },
   NULL,
};

   /* replace984_0 -> search101_0_0 in the cache */

/* replace984_1_0 -> search699_1 in the cache */
/* replace984_1 -> search927_1 in the cache */
/* replace984 -> replace966 in the cache */

   /* search985_0_0 -> search835_0_0 in the cache */
/* search985_0 -> search955_0 in the cache */

/* search985_1_0 -> search871_1_0 in the cache */
static const nir_search_expression search985_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search871_1_0.value },
   NULL,
};
static const nir_search_expression search985 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search955_0.value, &search985_1.value },
   NULL,
};

   /* replace985_0_0 -> search835_0_0 in the cache */
/* replace985_0 -> search931_0 in the cache */

/* replace985_1 -> search871_1_0 in the cache */
/* replace985 -> replace967 in the cache */

   /* search986_0_0 -> search835_0_0 in the cache */
/* search986_0 -> search955_0 in the cache */

/* search986_1_0 -> search871_1_0 in the cache */
/* search986_1 -> search985_1 in the cache */
static const nir_search_expression search986 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search955_0.value, &search985_1.value },
   NULL,
};

   /* replace986_0_0 -> search835_0_0 in the cache */
/* replace986_0 -> search931_0 in the cache */

/* replace986_1 -> search871_1_0 in the cache */
/* replace986 -> replace968 in the cache */

   /* search987_0_0 -> search101_0_0 in the cache */
/* search987_0 -> replace822 in the cache */

/* search987_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression search987_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression search987 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace822.value, &search987_1.value },
   NULL,
};

   /* replace987_0 -> search101_0_0 in the cache */

/* replace987_1_0 -> replace564_1_0 in the cache */
/* replace987_1 -> replace969_1 in the cache */
/* replace987 -> replace969 in the cache */

   /* search988_0_0 -> search101_0_0 in the cache */
/* search988_0 -> replace822 in the cache */

/* search988_1_0 -> replace564_1_0 in the cache */
/* search988_1 -> search987_1 in the cache */
static const nir_search_expression search988 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace822.value, &search987_1.value },
   NULL,
};

   /* replace988_0 -> search101_0_0 in the cache */

/* replace988_1_0 -> replace564_1_0 in the cache */
/* replace988_1 -> replace969_1 in the cache */
/* replace988 -> replace970 in the cache */

   /* search989_0_0 -> search101_0_0 in the cache */
/* search989_0 -> replace822 in the cache */

/* search989_1_0 -> replace564_1_0 in the cache */
/* search989_1 -> search987_1 in the cache */
static const nir_search_expression search989 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace822.value, &search987_1.value },
   NULL,
};

   /* replace989_0 -> search101_0_0 in the cache */

/* replace989_1_0 -> replace564_1_0 in the cache */
/* replace989_1 -> replace969_1 in the cache */
/* replace989 -> replace971 in the cache */

   /* search990_0_0 -> search101_0_0 in the cache */
/* search990_0 -> replace822 in the cache */

/* search990_1_0 -> replace564_1_0 in the cache */
/* search990_1 -> search987_1 in the cache */
static const nir_search_expression search990 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace822.value, &search987_1.value },
   NULL,
};

   /* replace990_0 -> search101_0_0 in the cache */

/* replace990_1_0 -> replace564_1_0 in the cache */
/* replace990_1 -> replace969_1 in the cache */
/* replace990 -> replace972 in the cache */

   /* search991_0_0 -> search877_0_0 in the cache */
static const nir_search_expression search991_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search877_0_0.value },
   NULL,
};

/* search991_1_0 -> search871_1_0 in the cache */
/* search991_1 -> search985_1 in the cache */
static const nir_search_expression search991 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search991_0.value, &search985_1.value },
   NULL,
};

   /* replace991_0_0 -> search877_0_0 in the cache */
/* replace991_0 -> replace973_0 in the cache */

/* replace991_1 -> search871_1_0 in the cache */
/* replace991 -> replace973 in the cache */

   /* search992_0_0 -> search877_0_0 in the cache */
/* search992_0 -> search991_0 in the cache */

/* search992_1_0 -> search871_1_0 in the cache */
/* search992_1 -> search985_1 in the cache */
static const nir_search_expression search992 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search991_0.value, &search985_1.value },
   NULL,
};

   /* replace992_0_0 -> search877_0_0 in the cache */
/* replace992_0 -> replace973_0 in the cache */

/* replace992_1 -> search871_1_0 in the cache */
/* replace992 -> replace974 in the cache */

   /* search993_0_0 -> search101_0_0 in the cache */
/* search993_0 -> replace822 in the cache */

/* search993_1 -> search861_1 in the cache */
static const nir_search_expression search993 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace822.value, &search861_1.value },
   NULL,
};

   /* replace993_0_0 -> search101_0_0 in the cache */

/* replace993_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace993_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace993_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search101_0_0.value, &replace993_0_1.value },
   NULL,
};

/* replace993_1_0_0_0 -> search57_1_1 in the cache */
/* replace993_1_0_0 -> replace993_0_1 in the cache */
static const nir_search_expression replace993_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace993_0_1.value },
   NULL,
};

/* replace993_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace993_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace993_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace993 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace993_0.value, &replace993_1.value },
   NULL,
};

   /* search994_0_0 -> search101_0_0 in the cache */
/* search994_0 -> replace822 in the cache */

/* search994_1 -> search861_1 in the cache */
static const nir_search_expression search994 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace822.value, &search861_1.value },
   NULL,
};

   /* replace994_0_0 -> search101_0_0 in the cache */

/* replace994_0_1_0 -> search57_1_1 in the cache */
/* replace994_0_1 -> replace993_0_1 in the cache */
static const nir_search_expression replace994_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search101_0_0.value, &replace993_0_1.value },
   NULL,
};

/* replace994_1_0_0_0 -> search57_1_1 in the cache */
/* replace994_1_0_0 -> replace993_0_1 in the cache */
/* replace994_1_0 -> replace993_1_0 in the cache */

/* replace994_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace994_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace993_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace994 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace994_0.value, &replace994_1.value },
   NULL,
};

   /* search995_0_0 -> search101_0_0 in the cache */
/* search995_0 -> replace822 in the cache */

/* search995_1 -> search861_1 in the cache */
static const nir_search_expression search995 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace822.value, &search861_1.value },
   NULL,
};

   /* replace995_0_0 -> replace107_2 in the cache */

/* replace995_0_1 -> search57_1_1 in the cache */
/* replace995_0 -> replace959_0 in the cache */

static const nir_search_constant replace995_1_0_0 = {
   { nir_search_value_constant, 64 },
   nir_type_int, { 0xffff /* 65535 */ },
};

/* replace995_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace995_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace995_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace995_1_1_0 -> search101_0_0 in the cache */

/* replace995_1_1_1_0 -> search57_1_1 in the cache */
/* replace995_1_1_1 -> replace993_0_1 in the cache */
static const nir_search_expression replace995_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search101_0_0.value, &replace993_0_1.value },
   NULL,
};
static const nir_search_expression replace995_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace995_1_0.value, &replace995_1_1.value },
   NULL,
};
static const nir_search_expression replace995 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace959_0.value, &replace995_1.value },
   NULL,
};

   /* search996_0 -> search864_0 in the cache */

/* search996_1_0 -> replace564_1_0 in the cache */
/* search996_1 -> search987_1 in the cache */
static const nir_search_expression search996 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search864_0.value, &search987_1.value },
   NULL,
};

   /* replace996_0_0 -> search57_0 in the cache */

/* replace996_0_1 -> replace995_1_0_0 in the cache */
static const nir_search_expression replace996_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &replace995_1_0_0.value },
   NULL,
};

/* replace996_1_0_0 -> search57_0 in the cache */

/* replace996_1_0_1 -> replace107_2 in the cache */
/* replace996_1_0 -> replace960_1_0 in the cache */

/* replace996_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace996_1_1_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_u2u16,
   { &search57_0.value },
   NULL,
};

/* replace996_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace996_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace996_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace996_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace960_1_0.value, &replace996_1_1.value },
   NULL,
};
static const nir_search_expression replace996 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace996_0.value, &replace996_1.value },
   NULL,
};

   /* search997_0_0 -> search101_0_0 in the cache */
/* search997_0 -> replace822 in the cache */

/* search997_1 -> search861_1 in the cache */
static const nir_search_expression search997 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace822.value, &search861_1.value },
   NULL,
};

   /* replace997_0_0 -> replace995_1_0_0 in the cache */

/* replace997_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace997_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace995_1_0_0.value, &search57_1_1.value },
   NULL,
};

/* replace997_1_0_0 -> replace107_2 in the cache */

/* replace997_1_0_1 -> search57_1_1 in the cache */
/* replace997_1_0 -> replace961_1_0 in the cache */

/* replace997_1_1_0 -> search101_0_0 in the cache */

/* replace997_1_1_1_0 -> search57_1_1 in the cache */
/* replace997_1_1_1 -> replace993_0_1 in the cache */
static const nir_search_expression replace997_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search101_0_0.value, &replace993_0_1.value },
   NULL,
};
static const nir_search_expression replace997_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace961_1_0.value, &replace997_1_1.value },
   NULL,
};
static const nir_search_expression replace997 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace997_0.value, &replace997_1.value },
   NULL,
};

   /* search998_0 -> search864_0 in the cache */

/* search998_1_0 -> replace564_1_0 in the cache */
/* search998_1 -> search987_1 in the cache */
static const nir_search_expression search998 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search864_0.value, &search987_1.value },
   NULL,
};

   /* replace998_0_0 -> search57_0 in the cache */

/* replace998_0_1 -> replace107_2 in the cache */
/* replace998_0 -> replace962_0 in the cache */

/* replace998_1_0_0 -> search57_0 in the cache */

/* replace998_1_0_1 -> replace995_1_0_0 in the cache */
static const nir_search_expression replace998_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &replace995_1_0_0.value },
   NULL,
};

/* replace998_1_1_0_0 -> search57_0 in the cache */
/* replace998_1_1_0 -> replace996_1_1_0 in the cache */

/* replace998_1_1_1 -> replace564_1_0 in the cache */
static const nir_search_expression replace998_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace996_1_1_0.value, &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace998_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace998_1_0.value, &replace998_1_1.value },
   NULL,
};
static const nir_search_expression replace998 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace962_0.value, &replace998_1.value },
   NULL,
};

   /* search999_0_0 -> search0_0 in the cache */
/* search999_0 -> replace830 in the cache */

/* search999_1_0 -> search699_1 in the cache */
/* search999_1 -> search951_1 in the cache */
static const nir_search_expression search999 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search951_1.value },
   NULL,
};

   /* replace999_0 -> search0_0 in the cache */

/* replace999_1_0 -> search699_1 in the cache */
/* replace999_1 -> search939_1 in the cache */
static const nir_search_expression replace999 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search939_1.value },
   NULL,
};

   /* search1000_0_0 -> search0_0 in the cache */
/* search1000_0 -> replace830 in the cache */

/* search1000_1_0 -> search699_1 in the cache */
/* search1000_1 -> search951_1 in the cache */
static const nir_search_expression search1000 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search951_1.value },
   NULL,
};

   /* replace1000_0 -> search0_0 in the cache */

/* replace1000_1_0 -> search699_1 in the cache */
/* replace1000_1 -> search939_1 in the cache */
static const nir_search_expression replace1000 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search939_1.value },
   NULL,
};

   /* search1001_0_0 -> search0_0 in the cache */
/* search1001_0 -> replace830 in the cache */

/* search1001_1_0 -> search699_1 in the cache */
/* search1001_1 -> search951_1 in the cache */
static const nir_search_expression search1001 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace830.value, &search951_1.value },
   NULL,
};

   /* replace1001_0 -> search0_0 in the cache */

/* replace1001_1_0 -> search699_1 in the cache */
/* replace1001_1 -> search939_1 in the cache */
static const nir_search_expression replace1001 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search939_1.value },
   NULL,
};

   /* search1002_0_0 -> search0_0 in the cache */
/* search1002_0 -> replace830 in the cache */

/* search1002_1_0 -> search699_1 in the cache */
/* search1002_1 -> search951_1 in the cache */
static const nir_search_expression search1002 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace830.value, &search951_1.value },
   NULL,
};

   /* replace1002_0 -> search0_0 in the cache */

/* replace1002_1_0 -> search699_1 in the cache */
/* replace1002_1 -> search939_1 in the cache */
static const nir_search_expression replace1002 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search939_1.value },
   NULL,
};

   /* search1003_0_0 -> search835_0_0 in the cache */
/* search1003_0 -> search955_0 in the cache */

/* search1003_1_0 -> search907_1_0 in the cache */
static const nir_search_expression search1003_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search907_1_0.value },
   NULL,
};
static const nir_search_expression search1003 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search955_0.value, &search1003_1.value },
   NULL,
};

   /* replace1003_0_0 -> search835_0_0 in the cache */
/* replace1003_0 -> search943_0 in the cache */

/* replace1003_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1003 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search943_0.value, &search907_1_0.value },
   NULL,
};

   /* search1004_0_0 -> search835_0_0 in the cache */
/* search1004_0 -> search955_0 in the cache */

/* search1004_1_0 -> search907_1_0 in the cache */
/* search1004_1 -> search1003_1 in the cache */
static const nir_search_expression search1004 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search955_0.value, &search1003_1.value },
   NULL,
};

   /* replace1004_0_0 -> search835_0_0 in the cache */
/* replace1004_0 -> search943_0 in the cache */

/* replace1004_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1004 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search943_0.value, &search907_1_0.value },
   NULL,
};

   /* search1005_0_0 -> search0_0 in the cache */
/* search1005_0 -> replace830 in the cache */

/* search1005_1_0 -> replace564_1_0 in the cache */
/* search1005_1 -> search987_1 in the cache */
static const nir_search_expression search1005 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search987_1.value },
   NULL,
};

   /* replace1005_0 -> search0_0 in the cache */

/* replace1005_1_0 -> replace564_1_0 in the cache */
/* replace1005_1 -> search969_1 in the cache */
static const nir_search_expression replace1005 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &search969_1.value },
   NULL,
};

   /* search1006_0_0 -> search0_0 in the cache */
/* search1006_0 -> replace830 in the cache */

/* search1006_1_0 -> replace564_1_0 in the cache */
/* search1006_1 -> search987_1 in the cache */
static const nir_search_expression search1006 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search987_1.value },
   NULL,
};

   /* replace1006_0 -> search0_0 in the cache */

/* replace1006_1_0 -> replace564_1_0 in the cache */
/* replace1006_1 -> search969_1 in the cache */
static const nir_search_expression replace1006 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &search969_1.value },
   NULL,
};

   /* search1007_0_0 -> search0_0 in the cache */
/* search1007_0 -> replace830 in the cache */

/* search1007_1_0 -> replace564_1_0 in the cache */
/* search1007_1 -> search987_1 in the cache */
static const nir_search_expression search1007 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace830.value, &search987_1.value },
   NULL,
};

   /* replace1007_0 -> search0_0 in the cache */

/* replace1007_1_0 -> replace564_1_0 in the cache */
/* replace1007_1 -> search969_1 in the cache */
static const nir_search_expression replace1007 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &search969_1.value },
   NULL,
};

   /* search1008_0_0 -> search0_0 in the cache */
/* search1008_0 -> replace830 in the cache */

/* search1008_1_0 -> replace564_1_0 in the cache */
/* search1008_1 -> search987_1 in the cache */
static const nir_search_expression search1008 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace830.value, &search987_1.value },
   NULL,
};

   /* replace1008_0 -> search0_0 in the cache */

/* replace1008_1_0 -> replace564_1_0 in the cache */
/* replace1008_1 -> search969_1 in the cache */
static const nir_search_expression replace1008 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &search969_1.value },
   NULL,
};

   /* search1009_0_0 -> search877_0_0 in the cache */
/* search1009_0 -> search991_0 in the cache */

/* search1009_1_0 -> search907_1_0 in the cache */
/* search1009_1 -> search1003_1 in the cache */
static const nir_search_expression search1009 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search991_0.value, &search1003_1.value },
   NULL,
};

   /* replace1009_0_0 -> search877_0_0 in the cache */
/* replace1009_0 -> search973_0 in the cache */

/* replace1009_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1009 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search973_0.value, &search907_1_0.value },
   NULL,
};

   /* search1010_0_0 -> search877_0_0 in the cache */
/* search1010_0 -> search991_0 in the cache */

/* search1010_1_0 -> search907_1_0 in the cache */
/* search1010_1 -> search1003_1 in the cache */
static const nir_search_expression search1010 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search991_0.value, &search1003_1.value },
   NULL,
};

   /* replace1010_0_0 -> search877_0_0 in the cache */
/* replace1010_0 -> search973_0 in the cache */

/* replace1010_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1010 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search973_0.value, &search907_1_0.value },
   NULL,
};

   /* search1011_0_0 -> search0_0 in the cache */
/* search1011_0 -> replace830 in the cache */

/* search1011_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search1011_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search1011 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search1011_1.value },
   NULL,
};

   /* replace1011_0 -> search0_0 in the cache */

/* replace1011_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace1011_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1011 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &search0_0.value, &replace1011_1.value },
   NULL,
};

   /* search1012_0_0 -> search0_0 in the cache */
/* search1012_0 -> replace830 in the cache */

/* search1012_1_0 -> replace0_1_0 in the cache */
/* search1012_1 -> search1011_1 in the cache */
static const nir_search_expression search1012 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search1011_1.value },
   NULL,
};

   /* replace1012_0 -> search0_0 in the cache */

/* replace1012_1_0 -> replace0_1_0 in the cache */
/* replace1012_1 -> replace1011_1 in the cache */
static const nir_search_expression replace1012 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &search0_0.value, &replace1011_1.value },
   NULL,
};

   /* search1013_0_0 -> search0_0 in the cache */
/* search1013_0 -> replace830 in the cache */

/* search1013_1_0 -> replace0_1_0 in the cache */
/* search1013_1 -> search1011_1 in the cache */
static const nir_search_expression search1013 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace830.value, &search1011_1.value },
   NULL,
};

   /* replace1013_0 -> search0_0 in the cache */

/* replace1013_1_0 -> replace0_1_0 in the cache */
/* replace1013_1 -> replace1011_1 in the cache */
static const nir_search_expression replace1013 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace1011_1.value },
   NULL,
};

   /* search1014_0_0 -> search0_0 in the cache */
/* search1014_0 -> replace830 in the cache */

/* search1014_1_0 -> replace0_1_0 in the cache */
/* search1014_1 -> search1011_1 in the cache */
static const nir_search_expression search1014 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace830.value, &search1011_1.value },
   NULL,
};

   /* replace1014_0 -> search0_0 in the cache */

/* replace1014_1_0 -> replace0_1_0 in the cache */
/* replace1014_1 -> replace1011_1 in the cache */
static const nir_search_expression replace1014 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace1011_1.value },
   NULL,
};

   /* search1015_0_0 -> search919_0_0 in the cache */
static const nir_search_expression search1015_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &search919_0_0.value },
   NULL,
};

/* search1015_1_0 -> search907_1_0 in the cache */
/* search1015_1 -> search1003_1 in the cache */
static const nir_search_expression search1015 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search1015_0.value, &search1003_1.value },
   NULL,
};

   /* replace1015_0_0 -> search919_0_0 in the cache */
static const nir_search_expression replace1015_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search919_0_0.value },
   NULL,
};

/* replace1015_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1015 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace1015_0.value, &search907_1_0.value },
   NULL,
};

   /* search1016_0_0 -> search919_0_0 in the cache */
/* search1016_0 -> search1015_0 in the cache */

/* search1016_1_0 -> search907_1_0 in the cache */
/* search1016_1 -> search1003_1 in the cache */
static const nir_search_expression search1016 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search1015_0.value, &search1003_1.value },
   NULL,
};

   /* replace1016_0_0 -> search919_0_0 in the cache */
/* replace1016_0 -> replace1015_0 in the cache */

/* replace1016_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1016 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace1015_0.value, &search907_1_0.value },
   NULL,
};

   /* search1017_0_0 -> search0_0 in the cache */
/* search1017_0 -> replace830 in the cache */

/* search1017_1 -> search861_1 in the cache */
static const nir_search_expression search1017 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ieq,
   { &replace830.value, &search861_1.value },
   NULL,
};

   /* replace1017_0_0 -> search0_0 in the cache */

/* replace1017_0_1_0 -> search57_1_1 in the cache */
static const nir_search_expression replace1017_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace1017_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ieq,
   { &search0_0.value, &replace1017_0_1.value },
   NULL,
};

/* replace1017_1_0_0_0 -> search57_1_1 in the cache */
/* replace1017_1_0_0 -> replace1017_0_1 in the cache */
static const nir_search_expression replace1017_1_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_u2u64,
   { &replace1017_0_1.value },
   NULL,
};

/* replace1017_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1017_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ieq,
   { &replace1017_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace1017 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_iand,
   { &replace1017_0.value, &replace1017_1.value },
   NULL,
};

   /* search1018_0_0 -> search0_0 in the cache */
/* search1018_0 -> replace830 in the cache */

/* search1018_1 -> search861_1 in the cache */
static const nir_search_expression search1018 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_ine,
   { &replace830.value, &search861_1.value },
   NULL,
};

   /* replace1018_0_0 -> search0_0 in the cache */

/* replace1018_0_1_0 -> search57_1_1 in the cache */
/* replace1018_0_1 -> replace1017_0_1 in the cache */
static const nir_search_expression replace1018_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ine,
   { &search0_0.value, &replace1017_0_1.value },
   NULL,
};

/* replace1018_1_0_0_0 -> search57_1_1 in the cache */
/* replace1018_1_0_0 -> replace1017_0_1 in the cache */
/* replace1018_1_0 -> replace1017_1_0 in the cache */

/* replace1018_1_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1018_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   2, 1,
   nir_op_ine,
   { &replace1017_1_0.value, &search57_1_1.value },
   NULL,
};
static const nir_search_expression replace1018 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 3,
   nir_op_ior,
   { &replace1018_0.value, &replace1018_1.value },
   NULL,
};

   /* search1019_0_0 -> search0_0 in the cache */
/* search1019_0 -> replace830 in the cache */

/* search1019_1 -> search861_1 in the cache */
static const nir_search_expression search1019 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace830.value, &search861_1.value },
   NULL,
};

   /* replace1019_0_0 -> replace107_2 in the cache */

/* replace1019_0_1 -> search57_1_1 in the cache */
/* replace1019_0 -> replace959_0 in the cache */

/* replace1019_1_0_0 -> search574_0_1 in the cache */

/* replace1019_1_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1019_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search574_0_1.value, &search57_1_1.value },
   NULL,
};

/* replace1019_1_1_0 -> search0_0 in the cache */

/* replace1019_1_1_1_0 -> search57_1_1 in the cache */
/* replace1019_1_1_1 -> replace1017_0_1 in the cache */
static const nir_search_expression replace1019_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search0_0.value, &replace1017_0_1.value },
   NULL,
};
static const nir_search_expression replace1019_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace1019_1_0.value, &replace1019_1_1.value },
   NULL,
};
static const nir_search_expression replace1019 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace959_0.value, &replace1019_1.value },
   NULL,
};

   /* search1020_0 -> search864_0 in the cache */

/* search1020_1_0 -> replace0_1_0 in the cache */
/* search1020_1 -> search1011_1 in the cache */
static const nir_search_expression search1020 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search864_0.value, &search1011_1.value },
   NULL,
};

   /* replace1020_0_0 -> search57_0 in the cache */

/* replace1020_0_1 -> search574_0_1 in the cache */
static const nir_search_expression replace1020_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &search57_0.value, &search574_0_1.value },
   NULL,
};

/* replace1020_1_0_0 -> search57_0 in the cache */

/* replace1020_1_0_1 -> replace107_2 in the cache */
/* replace1020_1_0 -> replace960_1_0 in the cache */

/* replace1020_1_1_0_0 -> search57_0 in the cache */
static const nir_search_expression replace1020_1_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_u2u32,
   { &search57_0.value },
   NULL,
};

/* replace1020_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace1020_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_ult,
   { &replace1020_1_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1020_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace960_1_0.value, &replace1020_1_1.value },
   NULL,
};
static const nir_search_expression replace1020 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1020_0.value, &replace1020_1.value },
   NULL,
};

   /* search1021_0_0 -> search0_0 in the cache */
/* search1021_0 -> replace830 in the cache */

/* search1021_1 -> search861_1 in the cache */
static const nir_search_expression search1021 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace830.value, &search861_1.value },
   NULL,
};

   /* replace1021_0_0 -> search574_0_1 in the cache */

/* replace1021_0_1 -> search57_1_1 in the cache */
static const nir_search_expression replace1021_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search574_0_1.value, &search57_1_1.value },
   NULL,
};

/* replace1021_1_0_0 -> replace107_2 in the cache */

/* replace1021_1_0_1 -> search57_1_1 in the cache */
/* replace1021_1_0 -> replace961_1_0 in the cache */

/* replace1021_1_1_0 -> search0_0 in the cache */

/* replace1021_1_1_1_0 -> search57_1_1 in the cache */
/* replace1021_1_1_1 -> replace1017_0_1 in the cache */
static const nir_search_expression replace1021_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search0_0.value, &replace1017_0_1.value },
   NULL,
};
static const nir_search_expression replace1021_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace961_1_0.value, &replace1021_1_1.value },
   NULL,
};
static const nir_search_expression replace1021 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace1021_0.value, &replace1021_1.value },
   NULL,
};

   /* search1022_0 -> search864_0 in the cache */

/* search1022_1_0 -> replace0_1_0 in the cache */
/* search1022_1 -> search1011_1 in the cache */
static const nir_search_expression search1022 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search864_0.value, &search1011_1.value },
   NULL,
};

   /* replace1022_0_0 -> search57_0 in the cache */

/* replace1022_0_1 -> replace107_2 in the cache */
/* replace1022_0 -> replace962_0 in the cache */

/* replace1022_1_0_0 -> search57_0 in the cache */

/* replace1022_1_0_1 -> search574_0_1 in the cache */
static const nir_search_expression replace1022_1_0 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &search57_0.value, &search574_0_1.value },
   NULL,
};

/* replace1022_1_1_0_0 -> search57_0 in the cache */
/* replace1022_1_1_0 -> replace1020_1_1_0 in the cache */

/* replace1022_1_1_1 -> replace0_1_0 in the cache */
static const nir_search_expression replace1022_1_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_uge,
   { &replace1020_1_1_0.value, &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1022_1 = {
   { nir_search_value_expression, 1 },
   false, false,
   1, 1,
   nir_op_ior,
   { &replace1022_1_0.value, &replace1022_1_1.value },
   NULL,
};
static const nir_search_expression replace1022 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 2,
   nir_op_iand,
   { &replace962_0.value, &replace1022_1.value },
   NULL,
};

   /* search1023_0_0 -> search101_0_0 in the cache */
static const nir_search_expression search1023_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search101_0_0.value },
   NULL,
};

/* search1023_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression search1023_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression search1023 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search1023_0.value, &search1023_1.value },
   NULL,
};

   /* replace1023_0 -> search101_0_0 in the cache */

/* replace1023_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression replace1023_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression replace1023 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search101_0_0.value, &replace1023_1.value },
   NULL,
};

   /* search1024_0_0 -> search101_0_0 in the cache */
/* search1024_0 -> search1023_0 in the cache */

/* search1024_1_0 -> replace564_1_0 in the cache */
/* search1024_1 -> search1023_1 in the cache */
static const nir_search_expression search1024 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search1023_0.value, &search1023_1.value },
   NULL,
};

   /* replace1024_0 -> search101_0_0 in the cache */

/* replace1024_1_0 -> replace564_1_0 in the cache */
/* replace1024_1 -> replace1023_1 in the cache */
static const nir_search_expression replace1024 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search101_0_0.value, &replace1023_1.value },
   NULL,
};

   /* search1025_0_0 -> search101_0_0 in the cache */
/* search1025_0 -> search1023_0 in the cache */

/* search1025_1_0 -> replace564_1_0 in the cache */
/* search1025_1 -> search1023_1 in the cache */
static const nir_search_expression search1025 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1023_0.value, &search1023_1.value },
   NULL,
};

   /* replace1025_0 -> search101_0_0 in the cache */

/* replace1025_1_0 -> replace564_1_0 in the cache */
/* replace1025_1 -> replace1023_1 in the cache */
static const nir_search_expression replace1025 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search101_0_0.value, &replace1023_1.value },
   NULL,
};

   /* search1026_0_0 -> search101_0_0 in the cache */
/* search1026_0 -> search1023_0 in the cache */

/* search1026_1_0 -> replace564_1_0 in the cache */
/* search1026_1 -> search1023_1 in the cache */
static const nir_search_expression search1026 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1023_0.value, &search1023_1.value },
   NULL,
};

   /* replace1026_0 -> search101_0_0 in the cache */

/* replace1026_1_0 -> replace564_1_0 in the cache */
/* replace1026_1 -> replace1023_1 in the cache */
static const nir_search_expression replace1026 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search101_0_0.value, &replace1023_1.value },
   NULL,
};

   /* search1027_0_0 -> search877_0_0 in the cache */
static const nir_search_expression search1027_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search877_0_0.value },
   NULL,
};

/* search1027_1_0 -> search871_1_0 in the cache */
static const nir_search_expression search1027_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search871_1_0.value },
   NULL,
};
static const nir_search_expression search1027 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1027_0.value, &search1027_1.value },
   NULL,
};

   /* replace1027_0_0 -> search877_0_0 in the cache */
static const nir_search_expression replace1027_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_f2f16,
   { &search877_0_0.value },
   NULL,
};

/* replace1027_1 -> search871_1_0 in the cache */
static const nir_search_expression replace1027 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace1027_0.value, &search871_1_0.value },
   NULL,
};

   /* search1028_0_0 -> search877_0_0 in the cache */
/* search1028_0 -> search1027_0 in the cache */

/* search1028_1_0 -> search871_1_0 in the cache */
/* search1028_1 -> search1027_1 in the cache */
static const nir_search_expression search1028 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1027_0.value, &search1027_1.value },
   NULL,
};

   /* replace1028_0_0 -> search877_0_0 in the cache */
/* replace1028_0 -> replace1027_0 in the cache */

/* replace1028_1 -> search871_1_0 in the cache */
static const nir_search_expression replace1028 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace1027_0.value, &search871_1_0.value },
   NULL,
};

   /* search1029_0_0 -> search101_0_0 in the cache */
static const nir_search_expression search1029_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search101_0_0.value },
   NULL,
};

/* search1029_1_0 -> replace564_1_0 in the cache */
static const nir_search_expression search1029_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &replace564_1_0.value },
   NULL,
};
static const nir_search_expression search1029 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search1029_0.value, &search1029_1.value },
   NULL,
};

   /* replace1029_0 -> search101_0_0 in the cache */

/* replace1029_1_0 -> replace564_1_0 in the cache */
/* replace1029_1 -> replace1023_1 in the cache */
/* replace1029 -> replace1023 in the cache */

   /* search1030_0_0 -> search101_0_0 in the cache */
/* search1030_0 -> search1029_0 in the cache */

/* search1030_1_0 -> replace564_1_0 in the cache */
/* search1030_1 -> search1029_1 in the cache */
static const nir_search_expression search1030 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search1029_0.value, &search1029_1.value },
   NULL,
};

   /* replace1030_0 -> search101_0_0 in the cache */

/* replace1030_1_0 -> replace564_1_0 in the cache */
/* replace1030_1 -> replace1023_1 in the cache */
/* replace1030 -> replace1024 in the cache */

   /* search1031_0_0 -> search101_0_0 in the cache */
/* search1031_0 -> search1029_0 in the cache */

/* search1031_1_0 -> replace564_1_0 in the cache */
/* search1031_1 -> search1029_1 in the cache */
static const nir_search_expression search1031 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1029_0.value, &search1029_1.value },
   NULL,
};

   /* replace1031_0 -> search101_0_0 in the cache */

/* replace1031_1_0 -> replace564_1_0 in the cache */
/* replace1031_1 -> replace1023_1 in the cache */
/* replace1031 -> replace1025 in the cache */

   /* search1032_0_0 -> search101_0_0 in the cache */
/* search1032_0 -> search1029_0 in the cache */

/* search1032_1_0 -> replace564_1_0 in the cache */
/* search1032_1 -> search1029_1 in the cache */
static const nir_search_expression search1032 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1029_0.value, &search1029_1.value },
   NULL,
};

   /* replace1032_0 -> search101_0_0 in the cache */

/* replace1032_1_0 -> replace564_1_0 in the cache */
/* replace1032_1 -> replace1023_1 in the cache */
/* replace1032 -> replace1026 in the cache */

   /* search1033_0_0 -> search877_0_0 in the cache */
static const nir_search_expression search1033_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search877_0_0.value },
   NULL,
};

/* search1033_1_0 -> search871_1_0 in the cache */
static const nir_search_expression search1033_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search871_1_0.value },
   NULL,
};
static const nir_search_expression search1033 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1033_0.value, &search1033_1.value },
   NULL,
};

   /* replace1033_0_0 -> search877_0_0 in the cache */
/* replace1033_0 -> replace1027_0 in the cache */

/* replace1033_1 -> search871_1_0 in the cache */
/* replace1033 -> replace1027 in the cache */

   /* search1034_0_0 -> search877_0_0 in the cache */
/* search1034_0 -> search1033_0 in the cache */

/* search1034_1_0 -> search871_1_0 in the cache */
/* search1034_1 -> search1033_1 in the cache */
static const nir_search_expression search1034 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1033_0.value, &search1033_1.value },
   NULL,
};

   /* replace1034_0_0 -> search877_0_0 in the cache */
/* replace1034_0 -> replace1027_0 in the cache */

/* replace1034_1 -> search871_1_0 in the cache */
/* replace1034 -> replace1028 in the cache */

   /* search1035_0_0 -> search0_0 in the cache */
static const nir_search_expression search1035_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search0_0.value },
   NULL,
};

/* search1035_1_0 -> replace564_1_0 in the cache */
/* search1035_1 -> search1029_1 in the cache */
static const nir_search_expression search1035 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search1035_0.value, &search1029_1.value },
   NULL,
};

   /* replace1035_0 -> search0_0 in the cache */

/* replace1035_1_0 -> replace564_1_0 in the cache */
/* replace1035_1 -> search1023_1 in the cache */
static const nir_search_expression replace1035 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &search1023_1.value },
   NULL,
};

   /* search1036_0_0 -> search0_0 in the cache */
/* search1036_0 -> search1035_0 in the cache */

/* search1036_1_0 -> replace564_1_0 in the cache */
/* search1036_1 -> search1029_1 in the cache */
static const nir_search_expression search1036 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search1035_0.value, &search1029_1.value },
   NULL,
};

   /* replace1036_0 -> search0_0 in the cache */

/* replace1036_1_0 -> replace564_1_0 in the cache */
/* replace1036_1 -> search1023_1 in the cache */
static const nir_search_expression replace1036 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search0_0.value, &search1023_1.value },
   NULL,
};

   /* search1037_0_0 -> search0_0 in the cache */
/* search1037_0 -> search1035_0 in the cache */

/* search1037_1_0 -> replace564_1_0 in the cache */
/* search1037_1 -> search1029_1 in the cache */
static const nir_search_expression search1037 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1035_0.value, &search1029_1.value },
   NULL,
};

   /* replace1037_0 -> search0_0 in the cache */

/* replace1037_1_0 -> replace564_1_0 in the cache */
/* replace1037_1 -> search1023_1 in the cache */
static const nir_search_expression replace1037 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search0_0.value, &search1023_1.value },
   NULL,
};

   /* search1038_0_0 -> search0_0 in the cache */
/* search1038_0 -> search1035_0 in the cache */

/* search1038_1_0 -> replace564_1_0 in the cache */
/* search1038_1 -> search1029_1 in the cache */
static const nir_search_expression search1038 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1035_0.value, &search1029_1.value },
   NULL,
};

   /* replace1038_0 -> search0_0 in the cache */

/* replace1038_1_0 -> replace564_1_0 in the cache */
/* replace1038_1 -> search1023_1 in the cache */
static const nir_search_expression replace1038 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &search1023_1.value },
   NULL,
};

   /* search1039_0_0 -> search877_0_0 in the cache */
/* search1039_0 -> search1033_0 in the cache */

/* search1039_1_0 -> search907_1_0 in the cache */
static const nir_search_expression search1039_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search907_1_0.value },
   NULL,
};
static const nir_search_expression search1039 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1033_0.value, &search1039_1.value },
   NULL,
};

   /* replace1039_0_0 -> search877_0_0 in the cache */
/* replace1039_0 -> search1027_0 in the cache */

/* replace1039_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1039 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1027_0.value, &search907_1_0.value },
   NULL,
};

   /* search1040_0_0 -> search877_0_0 in the cache */
/* search1040_0 -> search1033_0 in the cache */

/* search1040_1_0 -> search907_1_0 in the cache */
/* search1040_1 -> search1039_1 in the cache */
static const nir_search_expression search1040 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1033_0.value, &search1039_1.value },
   NULL,
};

   /* replace1040_0_0 -> search877_0_0 in the cache */
/* replace1040_0 -> search1027_0 in the cache */

/* replace1040_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1040 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1027_0.value, &search907_1_0.value },
   NULL,
};

   /* search1041_0_0 -> search0_0 in the cache */
/* search1041_0 -> search1035_0 in the cache */

/* search1041_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression search1041_1 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression search1041 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search1035_0.value, &search1041_1.value },
   NULL,
};

   /* replace1041_0 -> search0_0 in the cache */

/* replace1041_1_0 -> replace0_1_0 in the cache */
static const nir_search_expression replace1041_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &replace0_1_0.value },
   NULL,
};
static const nir_search_expression replace1041 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_feq,
   { &search0_0.value, &replace1041_1.value },
   NULL,
};

   /* search1042_0_0 -> search0_0 in the cache */
/* search1042_0 -> search1035_0 in the cache */

/* search1042_1_0 -> replace0_1_0 in the cache */
/* search1042_1 -> search1041_1 in the cache */
static const nir_search_expression search1042 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search1035_0.value, &search1041_1.value },
   NULL,
};

   /* replace1042_0 -> search0_0 in the cache */

/* replace1042_1_0 -> replace0_1_0 in the cache */
/* replace1042_1 -> replace1041_1 in the cache */
static const nir_search_expression replace1042 = {
   { nir_search_value_expression, 1 },
   false, false,
   0, 1,
   nir_op_fne,
   { &search0_0.value, &replace1041_1.value },
   NULL,
};

   /* search1043_0_0 -> search0_0 in the cache */
/* search1043_0 -> search1035_0 in the cache */

/* search1043_1_0 -> replace0_1_0 in the cache */
/* search1043_1 -> search1041_1 in the cache */
static const nir_search_expression search1043 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1035_0.value, &search1041_1.value },
   NULL,
};

   /* replace1043_0 -> search0_0 in the cache */

/* replace1043_1_0 -> replace0_1_0 in the cache */
/* replace1043_1 -> replace1041_1 in the cache */
static const nir_search_expression replace1043 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search0_0.value, &replace1041_1.value },
   NULL,
};

   /* search1044_0_0 -> search0_0 in the cache */
/* search1044_0 -> search1035_0 in the cache */

/* search1044_1_0 -> replace0_1_0 in the cache */
/* search1044_1 -> search1041_1 in the cache */
static const nir_search_expression search1044 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1035_0.value, &search1041_1.value },
   NULL,
};

   /* replace1044_0 -> search0_0 in the cache */

/* replace1044_1_0 -> replace0_1_0 in the cache */
/* replace1044_1 -> replace1041_1 in the cache */
static const nir_search_expression replace1044 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search0_0.value, &replace1041_1.value },
   NULL,
};

   /* search1045_0_0 -> search919_0_0 in the cache */
static const nir_search_expression search1045_0 = {
   { nir_search_value_expression, 64 },
   false, false,
   -1, 0,
   nir_op_f2f64,
   { &search919_0_0.value },
   NULL,
};

/* search1045_1_0 -> search907_1_0 in the cache */
/* search1045_1 -> search1039_1 in the cache */
static const nir_search_expression search1045 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &search1045_0.value, &search1039_1.value },
   NULL,
};

   /* replace1045_0_0 -> search919_0_0 in the cache */
static const nir_search_expression replace1045_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 0,
   nir_op_f2f32,
   { &search919_0_0.value },
   NULL,
};

/* replace1045_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1045 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_fge,
   { &replace1045_0.value, &search907_1_0.value },
   NULL,
};

   /* search1046_0_0 -> search919_0_0 in the cache */
/* search1046_0 -> search1045_0 in the cache */

/* search1046_1_0 -> search907_1_0 in the cache */
/* search1046_1 -> search1039_1 in the cache */
static const nir_search_expression search1046 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &search1045_0.value, &search1039_1.value },
   NULL,
};

   /* replace1046_0_0 -> search919_0_0 in the cache */
/* replace1046_0 -> replace1045_0 in the cache */

/* replace1046_1 -> search907_1_0 in the cache */
static const nir_search_expression replace1046 = {
   { nir_search_value_expression, 1 },
   false, false,
   -1, 0,
   nir_op_flt,
   { &replace1045_0.value, &search907_1_0.value },
   NULL,
};

   static const nir_search_variable search1047_0 = {
   { nir_search_value_variable, 16 },
   0, /* x */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};

static const nir_search_variable search1047_1 = {
   { nir_search_value_variable, 32 },
   1, /* exp */
   false,
   nir_type_invalid,
   NULL,
   {0, 1, 2, 3},
};
static const nir_search_expression search1047 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 0,
   nir_op_ldexp,
   { &search1047_0.value, &search1047_1.value },
   NULL,
};

   /* replace1047_0_0 -> search1047_0 in the cache */

/* replace1047_0_1_0_0_0_0_0_0 -> search1047_1 in the cache */

static const nir_search_constant replace1047_0_1_0_0_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { -0x1c /* -28 */ },
};
static const nir_search_expression replace1047_0_1_0_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   4, 1,
   nir_op_imax,
   { &search1047_1.value, &replace1047_0_1_0_0_0_0_0_1.value },
   NULL,
};

static const nir_search_constant replace1047_0_1_0_0_0_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0x1e /* 30 */ },
};
static const nir_search_expression replace1047_0_1_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   3, 2,
   nir_op_imin,
   { &replace1047_0_1_0_0_0_0_0.value, &replace1047_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace1047_0_1_0_0_0_1 -> replace579_1 in the cache */
static const nir_search_expression replace1047_0_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_ishr,
   { &replace1047_0_1_0_0_0_0.value, &replace579_1.value },
   NULL,
};

/* replace1047_0_1_0_0_1 -> replace103_1_1 in the cache */
static const nir_search_expression replace1047_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   2, 3,
   nir_op_iadd,
   { &replace1047_0_1_0_0_0.value, &replace103_1_1.value },
   NULL,
};

static const nir_search_constant replace1047_0_1_0_1 = {
   { nir_search_value_constant, 32 },
   nir_type_int, { 0xa /* 10 */ },
};
static const nir_search_expression replace1047_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 3,
   nir_op_ishl,
   { &replace1047_0_1_0_0.value, &replace1047_0_1_0_1.value },
   NULL,
};
static const nir_search_expression replace1047_0_1 = {
   { nir_search_value_expression, 16 },
   false, false,
   -1, 3,
   nir_op_i2i16,
   { &replace1047_0_1_0.value },
   NULL,
};
static const nir_search_expression replace1047_0 = {
   { nir_search_value_expression, 16 },
   false, false,
   1, 4,
   nir_op_fmul,
   { &search1047_0.value, &replace1047_0_1.value },
   NULL,
};

/* replace1047_1_0_0_0_0_0_0 -> search1047_1 in the cache */

/* replace1047_1_0_0_0_0_0_1 -> replace1047_0_1_0_0_0_0_0_1 in the cache */
static const nir_search_expression replace1047_1_0_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   7, 1,
   nir_op_imax,
   { &search1047_1.value, &replace1047_0_1_0_0_0_0_0_1.value },
   NULL,
};

/* replace1047_1_0_0_0_0_1 -> replace1047_0_1_0_0_0_0_1 in the cache */
static const nir_search_expression replace1047_1_0_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   6, 2,
   nir_op_imin,
   { &replace1047_1_0_0_0_0_0.value, &replace1047_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace1047_1_0_0_0_1_0_0_0 -> search1047_1 in the cache */

/* replace1047_1_0_0_0_1_0_0_1 -> replace1047_0_1_0_0_0_0_0_1 in the cache */
static const nir_search_expression replace1047_1_0_0_0_1_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   9, 1,
   nir_op_imax,
   { &search1047_1.value, &replace1047_0_1_0_0_0_0_0_1.value },
   NULL,
};

/* replace1047_1_0_0_0_1_0_1 -> replace1047_0_1_0_0_0_0_1 in the cache */
static const nir_search_expression replace1047_1_0_0_0_1_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   8, 2,
   nir_op_imin,
   { &replace1047_1_0_0_0_1_0_0.value, &replace1047_0_1_0_0_0_0_1.value },
   NULL,
};

/* replace1047_1_0_0_0_1_1 -> replace579_1 in the cache */
static const nir_search_expression replace1047_1_0_0_0_1 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 2,
   nir_op_ishr,
   { &replace1047_1_0_0_0_1_0.value, &replace579_1.value },
   NULL,
};
static const nir_search_expression replace1047_1_0_0_0 = {
   { nir_search_value_expression, 32 },
   false, false,
   -1, 4,
   nir_op_isub,
   { &replace1047_1_0_0_0_0.value, &replace1047_1_0_0_0_