// Locale support -*- C++ -*-

// Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003
// Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 22.1  Locales
//

/** @file localefwd.h
 *  This is an internal header file, included by other library headers.
 *  You should not attempt to use it directly.
 */

#ifndef _CPP_BITS_LOCALE_FWD_H
#define _CPP_BITS_LOCALE_FWD_H	1

#pragma GCC system_header

#include <bits/c++config.h>
#include <bits/c++locale.h>     // Defines __c_locale, config-specific includes
#include <iosfwd> 		// For ostreambuf_iterator, istreambuf_iterator
#include <bits/functexcept.h>

namespace std
{
  // 22.1.1 Locale
  class locale;

  // 22.1.3 Convenience interfaces
  template<typename _CharT> 
    inline bool 
    isspace(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isprint(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    iscntrl(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isupper(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    islower(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isalpha(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isdigit(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    ispunct(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isxdigit(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isalnum(_CharT, const locale&);

  template<typename _CharT> 
    inline bool 
    isgraph(_CharT, const locale&);

  template<typename _CharT> 
    inline _CharT 
    toupper(_CharT, const locale&);

  template<typename _CharT> 
    inline _CharT 
    tolower(_CharT, const locale&);

  // 22.2.1 and 22.2.1.3 ctype
  class ctype_base;
  template<typename _CharT> 
    class ctype;
  template<> class ctype<char>;
#if defined(_GLIBCPP_USE_WCHAR_T) || defined(_GLIBCPP_USE_TYPE_WCHAR_T)
  template<> class ctype<wchar_t>;
#endif
  template<typename _CharT> 
    class ctype_byname;
  // NB: Specialized for char and wchar_t in locale_facets.h.

  class codecvt_base;
  class __enc_traits;
  template<typename _InternT, typename _ExternT, typename _StateT>
    class codecvt;
  template<> class codecvt<char, char, mbstate_t>;
#if defined(_GLIBCPP_USE_WCHAR_T) || defined(_GLIBCPP_USE_TYPE_WCHAR_T)
  template<> class codecvt<wchar_t, char, mbstate_t>;
#endif
  template<typename _InternT, typename _ExternT, typename _StateT>
    class codecvt_byname;

  // 22.2.2 and 22.2.3 numeric
  template<typename _CharT, typename _InIter = istreambuf_iterator<_CharT> >
    class num_get;
  template<typename _CharT, typename _OutIter = ostreambuf_iterator<_CharT> >
    class num_put;
  template<typename _CharT> class numpunct;
  template<typename _CharT> class numpunct_byname;

  // 22.2.4 collation
  template<typename _CharT> 
    class collate;
  template<typename _CharT> class 
    collate_byname;

  // 22.2.5 date and time
  class time_base;
  template<typename _CharT, typename _InIter =  istreambuf_iterator<_CharT> >
    class time_get;
  template<typename _CharT, typename _InIter =  istreambuf_iterator<_CharT> >
    class time_get_byname;
  template<typename _CharT, typename _OutIter = ostreambuf_iterator<_CharT> >
    class time_put;
  template<typename _CharT, typename _OutIter = ostreambuf_iterator<_CharT> >
    class time_put_byname;

  // 22.2.6 money
  class money_base;
  template<typename _CharT, typename _InIter =  istreambuf_iterator<_CharT> >
    class money_get;
  template<typename _CharT, typename _OutIter = ostreambuf_iterator<_CharT> >
    class money_put;
  template<typename _CharT, bool _Intl = false> 
    class moneypunct;
  template<typename _CharT, bool _Intl = false> 
    class moneypunct_byname;

  // 22.2.7 message retrieval
  class messages_base;
  template<typename _CharT> 
    class messages;
  template<typename _CharT> 
    class messages_byname;

  template<typename _Facet>
    const _Facet&
    use_facet(const locale& __loc);

  template<typename _Facet>
    bool
    has_facet(const locale& __loc) throw();
} // namespace std

#endif
