/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_TIMEOUT = 90;

    public static void checkSharedFSFailoverReplaced(CoreContainer cc, CoreDescriptor desc) {
        if (!cc.isSharedFs(desc)) {
            return;
        }
        ZkController zkController = cc.getZkController();
        String thisCnn = zkController.getCoreNodeName(desc);
        String thisBaseUrl = zkController.getBaseUrl();
        log.debug("checkSharedFSFailoverReplaced running for coreNodeName={} baseUrl={}", (Object)thisCnn, (Object)thisBaseUrl);
        DocCollection docCollection = zkController.getClusterState().getCollectionOrNull(desc.getCloudDescriptor().getCollectionName());
        if (docCollection != null && docCollection.getSlicesMap() != null) {
            Map slicesMap = docCollection.getSlicesMap();
            for (Slice slice : slicesMap.values()) {
                for (Replica replica : slice.getReplicas()) {
                    String cnn = replica.getName();
                    String baseUrl = replica.getStr("base_url");
                    log.debug("compare against coreNodeName={} baseUrl={}", (Object)cnn, (Object)baseUrl);
                    if (thisCnn == null || !thisCnn.equals(cnn) || thisBaseUrl.equals(baseUrl)) continue;
                    if (cc.getLoadedCoreNames().contains(desc.getName())) {
                        cc.unload(desc.getName());
                    }
                    try {
                        FileUtils.deleteDirectory((File)desc.getInstanceDir().toFile());
                    }
                    catch (IOException e) {
                        SolrException.log((Logger)log, (String)("Failed to delete instance dir for core:" + desc.getName() + " dir:" + desc.getInstanceDir()));
                    }
                    log.error("{}", (Throwable)new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Will not load SolrCore " + desc.getName() + " because it has been replaced due to failover."));
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Will not load SolrCore " + desc.getName() + " because it has been replaced due to failover.");
                }
            }
        }
    }

    public static boolean replicaExists(ClusterState clusterState, String collection, String shard, String coreNodeName) {
        Slice slice;
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection != null && (slice = docCollection.getSlice(shard)) != null) {
            return slice.getReplica(coreNodeName) != null;
        }
        return false;
    }

    public static String unifiedResourcePath(SolrResourceLoader loader) {
        return loader instanceof ZkSolrResourceLoader ? ((ZkSolrResourceLoader)loader).getConfigSetZkPath() + "/" : loader.getConfigDir() + File.separator;
    }

    public static Map<String, byte[]> getTrustedKeys(SolrZkClient zk, String dir) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try {
            List children = zk.getChildren("/keys/" + dir, null, true);
            for (String key : children) {
                if (!key.endsWith(".der")) continue;
                result.put(key, zk.getData("/keys/" + dir + "/" + key, null, null, true));
            }
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Error fetching key names");
            return Collections.EMPTY_MAP;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read crypto keys", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read crypto keys", (Throwable)e);
        }
        return result;
    }

    public static long waitForState(SolrCloudManager cloudManager, String message, String collection, CollectionStatePredicate predicate) {
        AtomicReference state = new AtomicReference();
        AtomicReference liveNodesLastSeen = new AtomicReference();
        try {
            return CloudUtil.waitForState(cloudManager, collection, 90L, TimeUnit.SECONDS, (n, c) -> {
                state.set(c);
                liveNodesLastSeen.set(n);
                return predicate.matches(n, c);
            });
        }
        catch (Exception e) {
            throw new AssertionError(message + "\nLive Nodes: " + liveNodesLastSeen.get() + "\nLast available state: " + state.get(), e);
        }
    }

    public static long waitForState(SolrCloudManager cloudManager, String collection, long wait, TimeUnit unit, CollectionStatePredicate predicate) throws InterruptedException, TimeoutException, IOException {
        TimeOut timeout = new TimeOut(wait, unit, cloudManager.getTimeSource());
        long timeWarn = timeout.timeLeft(TimeUnit.MILLISECONDS) / 4L;
        ClusterState state = null;
        DocCollection coll = null;
        while (!timeout.hasTimedOut()) {
            state = cloudManager.getClusterStateProvider().getClusterState();
            coll = state.getCollectionOrNull(collection);
            if (coll == null) {
                timeout.sleep(100L);
                continue;
            }
            if (predicate.matches(state.getLiveNodes(), coll)) {
                log.trace("-- predicate matched with state {}", (Object)state);
                return timeout.timeElapsed(TimeUnit.MILLISECONDS);
            }
            timeout.sleep(100L);
            if (timeout.timeLeft(TimeUnit.MILLISECONDS) >= timeWarn) continue;
            log.trace("-- still not matching predicate: {}", (Object)state);
        }
        throw new TimeoutException("last ClusterState: " + state + ", last coll state: " + coll);
    }

    public static CollectionStatePredicate clusterShape(int expectedShards, int expectedReplicas) {
        return CloudUtil.clusterShape(expectedShards, expectedReplicas, false, false);
    }

    public static CollectionStatePredicate clusterShape(int expectedShards, int expectedReplicas, boolean withInactive, boolean requireLeaders) {
        return (liveNodes, collectionState) -> {
            Collection slices;
            if (collectionState == null) {
                log.debug("-- null collection");
                return false;
            }
            Collection collection = slices = withInactive ? collectionState.getSlices() : collectionState.getActiveSlices();
            if (slices.size() != expectedShards) {
                if (log.isDebugEnabled()) {
                    log.debug("-- wrong number of slices for collection {}, expected={}, found={}: {}", new Object[]{collectionState.getName(), expectedShards, collectionState.getSlices().size(), collectionState.getSlices()});
                }
                return false;
            }
            HashSet<String> leaderless = new HashSet<String>();
            for (Slice slice : slices) {
                int activeReplicas = 0;
                if (requireLeaders && slice.getState() != Slice.State.INACTIVE && slice.getLeader() == null) {
                    leaderless.add(slice.getName());
                    continue;
                }
                if (!leaderless.isEmpty()) continue;
                for (Replica replica : slice) {
                    if (!replica.isActive(liveNodes)) continue;
                    ++activeReplicas;
                }
                if (activeReplicas == expectedReplicas) continue;
                if (log.isDebugEnabled()) {
                    log.debug("-- wrong number of active replicas for collection {} in slice {}, expected={}, found={}", new Object[]{collectionState.getName(), slice.getName(), expectedReplicas, activeReplicas});
                }
                return false;
            }
            if (leaderless.isEmpty()) {
                return true;
            }
            log.info("-- shards without leaders: {}", leaderless);
            return false;
        };
    }
}

