/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.BooleanRemoveFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.DateRemoveFunction;
import org.apache.solr.analytics.function.mapping.DateStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.DoubleRemoveFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.FloatRemoveFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.IntRemoveFunction;
import org.apache.solr.analytics.function.mapping.IntStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.LongRemoveFunction;
import org.apache.solr.analytics.function.mapping.LongStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.StreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.StringRemoveFunction;
import org.apache.solr.analytics.function.mapping.StringStreamRemoveFunction;
import org.apache.solr.analytics.function.mapping.ValueRemoveFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class RemoveFunction {
    public static final String name = "remove";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The remove function requires 2 paramaters, " + params.length + " found.");
        }
        if (!(params[1] instanceof AnalyticsValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The remove function requires the remove (2nd) paramater to be single-valued.");
        }
        AnalyticsValueStream baseExpr = params[0];
        AnalyticsValue removeExpr = (AnalyticsValue)params[1];
        if (baseExpr instanceof DateValue && removeExpr instanceof DateValue) {
            return new DateRemoveFunction((DateValue)baseExpr, (DateValue)removeExpr);
        }
        if (baseExpr instanceof DateValueStream && removeExpr instanceof DateValue) {
            return new DateStreamRemoveFunction((DateValueStream)baseExpr, (DateValue)removeExpr);
        }
        if (baseExpr instanceof BooleanValue && removeExpr instanceof BooleanValue) {
            return new BooleanRemoveFunction((BooleanValue)baseExpr, (BooleanValue)removeExpr);
        }
        if (baseExpr instanceof BooleanValueStream && removeExpr instanceof BooleanValue) {
            return new BooleanStreamRemoveFunction((BooleanValueStream)baseExpr, (BooleanValue)removeExpr);
        }
        if (baseExpr instanceof IntValue && removeExpr instanceof IntValue) {
            return new IntRemoveFunction((IntValue)baseExpr, (IntValue)removeExpr);
        }
        if (baseExpr instanceof IntValueStream && removeExpr instanceof IntValue) {
            return new IntStreamRemoveFunction((IntValueStream)baseExpr, (IntValue)removeExpr);
        }
        if (baseExpr instanceof LongValue && removeExpr instanceof LongValue) {
            return new LongRemoveFunction((LongValue)baseExpr, (LongValue)removeExpr);
        }
        if (baseExpr instanceof LongValueStream && removeExpr instanceof LongValue) {
            return new LongStreamRemoveFunction((LongValueStream)baseExpr, (LongValue)removeExpr);
        }
        if (baseExpr instanceof FloatValue && removeExpr instanceof FloatValue) {
            return new FloatRemoveFunction((FloatValue)baseExpr, (FloatValue)removeExpr);
        }
        if (baseExpr instanceof FloatValueStream && removeExpr instanceof FloatValue) {
            return new FloatStreamRemoveFunction((FloatValueStream)baseExpr, (FloatValue)removeExpr);
        }
        if (baseExpr instanceof DoubleValue && removeExpr instanceof DoubleValue) {
            return new DoubleRemoveFunction((DoubleValue)baseExpr, (DoubleValue)removeExpr);
        }
        if (baseExpr instanceof DoubleValueStream && removeExpr instanceof DoubleValue) {
            return new DoubleStreamRemoveFunction((DoubleValueStream)baseExpr, (DoubleValue)removeExpr);
        }
        if (baseExpr instanceof StringValue && removeExpr instanceof StringValue) {
            return new StringRemoveFunction((StringValue)baseExpr, (StringValue)removeExpr);
        }
        if (baseExpr instanceof StringValueStream && removeExpr instanceof StringValue) {
            return new StringStreamRemoveFunction((StringValueStream)baseExpr, (StringValue)removeExpr);
        }
        if (baseExpr instanceof AnalyticsValue) {
            return new ValueRemoveFunction((AnalyticsValue)baseExpr, removeExpr);
        }
        return new StreamRemoveFunction(baseExpr, removeExpr);
    };
}

