/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReplaceWindowFuncCallsWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubstituteExpressionVisitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;

public class WindowResultSetNode
extends SingleChildResultSetNode {
    FromTable parent;
    Vector windowFuncCalls;
    WindowDefinitionNode wdn;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object, null);
        this.wdn = (WindowDefinitionNode)object2;
        this.windowFuncCalls = (Vector)object3;
        this.setLevel((Integer)object4);
        this.parent = this;
        ResultColumnList resultColumnList = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(resultColumnList);
        this.addNewPRNode();
        this.addNewColumns();
    }

    private void addNewPRNode() throws StandardException {
        Object object;
        QueryTreeNode queryTreeNode;
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            queryTreeNode = (ResultColumn)this.resultColumns.elementAt(i);
            if (queryTreeNode.isGenerated()) continue;
            resultColumnList.addElement(queryTreeNode);
        }
        resultColumnList.copyOrderBySelect(this.resultColumns);
        this.parent = (FromTable)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, null, this.getContextManager());
        this.childResult.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
        this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(ColumnReference.class);
        queryTreeNode = this.parent.getResultColumns();
        this.parent.getResultColumns().accept(collectNodesVisitor);
        Vector vector = collectNodesVisitor.getList();
        Vector<ColumnReference> vector2 = new Vector<ColumnReference>();
        for (int i = 0; i < vector.size(); ++i) {
            object = (ColumnReference)vector.elementAt(i);
            if (this.colRefAlreadySeen(vector2, (ColumnReference)object)) continue;
            vector2.add((ColumnReference)object);
        }
        CollectNodesVisitor collectNodesVisitor2 = new CollectNodesVisitor(VirtualColumnNode.class);
        this.parent.getResultColumns().accept(collectNodesVisitor2);
        object = collectNodesVisitor2.getList();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            vector2.add((ColumnReference)((Vector)object).elementAt(i));
        }
        ResultColumnList resultColumnList2 = this.childResult.getResultColumns();
        ResultColumnList resultColumnList3 = this.resultColumns;
        for (int i = 0; i < vector2.size(); ++i) {
            ValueNode valueNode = (ValueNode)vector2.elementAt(i);
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "##UnWindowingColumn", valueNode, this.getContextManager());
            resultColumnList2.addElement(resultColumn);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumn.setVirtualColumnId(resultColumnList2.size());
            ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, "##UnWindowingColumn", valueNode, this.getContextManager());
            resultColumnList3.addElement(resultColumn2);
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumn2.setVirtualColumnId(resultColumnList3.size());
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this.getNodeFactory().getNode(107, this, resultColumn2, new Integer(resultColumnList3.size()), this.getContextManager());
            SubstituteExpressionVisitor substituteExpressionVisitor = new SubstituteExpressionVisitor(valueNode, virtualColumnNode, null);
            this.parent.getResultColumns().accept(substituteExpressionVisitor);
        }
    }

    private boolean colRefAlreadySeen(Vector vector, ColumnReference columnReference) throws StandardException {
        for (int i = 0; i < vector.size(); ++i) {
            ColumnReference columnReference2 = (ColumnReference)vector.elementAt(i);
            if (!columnReference2.isEquivalent(columnReference)) continue;
            return true;
        }
        return false;
    }

    private void addNewColumns() throws StandardException {
        LanguageFactory languageFactory = this.getLanguageConnectionContext().getLanguageFactory();
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.resultColumns;
        ReplaceWindowFuncCallsWithCRVisitor replaceWindowFuncCallsWithCRVisitor = new ReplaceWindowFuncCallsWithCRVisitor((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceWindowFuncCallsWithCRVisitor);
        for (int i = 0; i < this.windowFuncCalls.size(); ++i) {
            WindowFunctionNode windowFunctionNode = (WindowFunctionNode)this.windowFuncCalls.elementAt(i);
            WindowDefinitionNode windowDefinitionNode = (WindowDefinitionNode)windowFunctionNode.getWindow();
            if (windowDefinitionNode != this.wdn) continue;
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "##winFuncResult", windowFunctionNode.getNewNullResultExpression(), this.getContextManager());
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            int n = resultColumn.getVirtualColumnId();
            ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), null, this.getContextManager());
            columnReference.setSource(resultColumn);
            columnReference.setNestingLevel(this.getLevel());
            columnReference.setSourceLevel(this.getLevel());
            columnReference.markGeneratedToReplaceWindowFunctionCall();
            ResultColumn resultColumn2 = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn.getColumnName(), columnReference, this.getContextManager());
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            columnReference = windowFunctionNode.getGeneratedRef();
            if (columnReference == null) continue;
            columnReference.setSource(resultColumn2);
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.resultColumns.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
        for (n = n2 - 1; n >= 0; --n) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(n);
            ValueNode valueNode = resultColumn.getExpression();
            if (resultColumn.isGenerated() && valueNode instanceof ColumnReference && ((ColumnReference)valueNode).getGeneratedToReplaceWindowFunctionCall()) continue;
            formatableBitSet.set(n);
        }
        n = activationClassBuilder.addItem(formatableBitSet);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        this.resultColumns.generateHolder(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(n);
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getWindowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 8);
    }

    public FromTable getParent() {
        return this.parent;
    }

    public void printSubNodes(int n) {
    }
}

