/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.AssertingScorable;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;

class AssertingLeafCollector
extends FilterLeafCollector {
    private final int min;
    private final int max;
    private Scorable scorer;
    private int lastCollected = -1;

    AssertingLeafCollector(LeafCollector collector, int min, int max) {
        super(collector);
        this.min = min;
        this.max = max;
    }

    public void setScorer(Scorable scorer) throws IOException {
        this.scorer = scorer;
        super.setScorer(AssertingScorable.wrap(scorer));
    }

    public void collect(int doc) throws IOException {
        assert (doc > this.lastCollected) : "Out of order : " + this.lastCollected + " " + doc;
        assert (doc >= this.min) : "Out of range: " + doc + " < " + this.min;
        assert (doc < this.max) : "Out of range: " + doc + " >= " + this.max;
        assert (this.scorer.docID() == doc) : "Collected: " + doc + " but scorer: " + this.scorer.docID();
        this.in.collect(doc);
        this.lastCollected = doc;
    }
}

