/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.controller.operations.PackOperationDetails;
import org.gradle.caching.internal.controller.operations.PackOperationResult;
import org.gradle.caching.internal.controller.operations.UnpackOperationDetails;
import org.gradle.caching.internal.controller.operations.UnpackOperationResult;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.DefaultLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.OpFiringBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class DefaultBuildCacheController
implements BuildCacheController {
    @VisibleForTesting
    final BuildCacheServiceHandle remote;
    @VisibleForTesting
    final LocalBuildCacheServiceHandle local;
    private final BuildCacheTempFileStore tmp;
    private final BuildOperationExecutor buildOperationExecutor;
    private final boolean emitDebugLogging;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration config, BuildOperationExecutor buildOperationExecutor, File gradleUserHomeDir, boolean logStackTraces, boolean emitDebugLogging) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.emitDebugLogging = emitDebugLogging;
        this.local = DefaultBuildCacheController.toLocalHandle(config.getLocal(), config.isLocalPush());
        this.remote = DefaultBuildCacheController.toRemoteHandle(config.getRemote(), config.isRemotePush(), buildOperationExecutor, logStackTraces);
        this.tmp = DefaultBuildCacheController.toTempFileStore(config.getLocal(), gradleUserHomeDir);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isEmitDebugLogging() {
        return this.emitDebugLogging;
    }

    @Override
    public <T> Optional<T> load(BuildCacheLoadCommand<T> command) {
        BuildCacheLoadCommand.Result result;
        Unpack unpack = new Unpack(command);
        if (this.local.canLoad()) {
            try {
                this.local.load(command.getKey(), unpack);
            }
            catch (Exception e) {
                throw new GradleException("Build cache entry " + command.getKey().getHashCode() + " from local build cache is invalid", (Throwable)e);
            }
            if (unpack.result != null) {
                return Optional.of(unpack.result.getMetadata());
            }
        }
        if (this.remote.canLoad()) {
            this.tmp.withTempFile(command.getKey(), (Action<? super File>)((Action)file -> {
                LoadTarget loadTarget = new LoadTarget((File)file);
                this.remote.load(command.getKey(), loadTarget);
                if (loadTarget.isLoaded()) {
                    try {
                        unpack.execute((File)file);
                    }
                    catch (Exception e) {
                        throw new GradleException("Build cache entry " + command.getKey().getHashCode() + " from remote build cache is invalid", (Throwable)e);
                    }
                    if (this.local.canStore()) {
                        this.local.store(command.getKey(), (File)file);
                    }
                }
            }));
        }
        return (result = unpack.result) == null ? Optional.empty() : Optional.of(result.getMetadata());
    }

    @Override
    public void store(BuildCacheStoreCommand command) {
        if (!this.local.canStore() && !this.remote.canStore()) {
            return;
        }
        BuildCacheKey key = command.getKey();
        Pack pack = new Pack(command);
        this.tmp.withTempFile(command.getKey(), (Action<? super File>)((Action)file -> {
            pack.execute((File)file);
            if (this.remote.canStore()) {
                this.remote.store(key, new StoreTarget((File)file));
            }
            if (this.local.canStore()) {
                this.local.store(key, (File)file);
            }
        }));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Closer closer = Closer.create();
            closer.register((Closeable)this.local);
            closer.register((Closeable)this.remote);
            closer.close();
        }
    }

    private static BuildCacheServiceHandle toRemoteHandle(@Nullable BuildCacheService service, boolean push, BuildOperationExecutor buildOperationExecutor, boolean logStackTraces) {
        return service == null ? NullBuildCacheServiceHandle.INSTANCE : new OpFiringBuildCacheServiceHandle(service, push, BuildCacheServiceRole.REMOTE, buildOperationExecutor, logStackTraces);
    }

    private static LocalBuildCacheServiceHandle toLocalHandle(@Nullable LocalBuildCacheService local, boolean localPush) {
        return local == null ? NullLocalBuildCacheServiceHandle.INSTANCE : new DefaultLocalBuildCacheServiceHandle(local, localPush);
    }

    private static BuildCacheTempFileStore toTempFileStore(@Nullable LocalBuildCacheService local, File gradleUserHomeDir) {
        return local != null ? local : new DefaultBuildCacheTempFileStore(new File(gradleUserHomeDir, "build-cache-tmp"));
    }

    private class Pack
    implements Action<File> {
        private final BuildCacheStoreCommand command;

        private Pack(BuildCacheStoreCommand command) {
            this.command = command;
        }

        public void execute(final File file) {
            DefaultBuildCacheController.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        BuildCacheStoreCommand.Result result = Pack.this.command.store(fileOutputStream);
                        context.setResult((Object)new PackOperationResult(result.getArtifactEntryCount(), file.length()));
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Pack build cache entry " + Pack.this.command.getKey())).details((Object)new PackOperationDetails(Pack.this.command.getKey())).progressDisplayName("Packing build cache entry");
                }
            });
        }
    }

    private class Unpack<T>
    implements Action<File> {
        private final BuildCacheLoadCommand<T> command;
        private BuildCacheLoadCommand.Result<T> result;

        private Unpack(BuildCacheLoadCommand<T> command) {
            this.command = command;
        }

        public void execute(final File file) {
            DefaultBuildCacheController.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    try (FileInputStream input = new FileInputStream(file);){
                        Unpack.this.result = Unpack.this.command.load(input);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    context.setResult((Object)new UnpackOperationResult(Unpack.this.result.getArtifactEntryCount()));
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Unpack build cache entry " + Unpack.this.command.getKey().getHashCode())).details((Object)new UnpackOperationDetails(Unpack.this.command.getKey(), file.length())).progressDisplayName("Unpacking build cache entry");
                }
            });
        }
    }
}

