/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Interner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;

public class DefaultBuildCacheCommandFactory
implements BuildCacheCommandFactory {
    private final BuildCacheEntryPacker packer;
    private final OriginMetadataFactory originMetadataFactory;
    private final VirtualFileSystem virtualFileSystem;
    private final Interner<String> stringInterner;

    public DefaultBuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, VirtualFileSystem virtualFileSystem, Interner<String> stringInterner) {
        this.packer = packer;
        this.originMetadataFactory = originMetadataFactory;
        this.virtualFileSystem = virtualFileSystem;
        this.stringInterner = stringInterner;
    }

    public BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> createLoad(BuildCacheKey cacheKey, CacheableEntity entity) {
        return new LoadCommand(cacheKey, entity);
    }

    public BuildCacheStoreCommand createStore(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, ? extends FileSystemSnapshot> snapshots, long executionTime) {
        return new StoreCommand(cacheKey, entity, snapshots, executionTime);
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Map<String, ? extends FileSystemSnapshot> fingerprints;
        private final long executionTime;

        private StoreCommand(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, ? extends FileSystemSnapshot> fingerprints, long executionTime) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.fingerprints = fingerprints;
            this.executionTime = executionTime;
        }

        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            BuildCacheEntryPacker.PackResult packResult = DefaultBuildCacheCommandFactory.this.packer.pack(this.entity, this.fingerprints, output, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.entity, this.executionTime));
            return () -> ((BuildCacheEntryPacker.PackResult)packResult).getEntries();
        }
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;

        private LoadCommand(BuildCacheKey cacheKey, CacheableEntity entity) {
            this.cacheKey = cacheKey;
            this.entity = entity;
        }

        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        public BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> load(InputStream input) throws IOException {
            ImmutableList.Builder roots = ImmutableList.builder();
            this.entity.visitOutputTrees((name, type, root) -> roots.add((Object)root.getAbsolutePath()));
            DefaultBuildCacheCommandFactory.this.virtualFileSystem.update((Iterable)roots.build(), () -> {});
            final BuildCacheEntryPacker.UnpackResult unpackResult = DefaultBuildCacheCommandFactory.this.packer.unpack(this.entity, input, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createReader(this.entity));
            final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshots = this.snapshotUnpackedData(unpackResult.getSnapshots());
            return new BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata>(){

                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                public BuildCacheCommandFactory.LoadMetadata getMetadata() {
                    return new BuildCacheCommandFactory.LoadMetadata(){

                        public OriginMetadata getOriginMetadata() {
                            return unpackResult.getOriginMetadata();
                        }

                        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getResultingSnapshots() {
                            return snapshots;
                        }
                    };
                }
            };
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotUnpackedData(Map<String, ? extends CompleteFileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            FingerprintingStrategy fingerprintingStrategy = AbsolutePathFingerprintingStrategy.IGNORE_MISSING;
            this.entity.visitOutputTrees((treeName, type, root) -> {
                CompleteFileSystemLocationSnapshot treeSnapshot = (CompleteFileSystemLocationSnapshot)treeSnapshots.get(treeName);
                String internedAbsolutePath = (String)DefaultBuildCacheCommandFactory.this.stringInterner.intern((Object)root.getAbsolutePath());
                ArrayList<CompleteFileSystemLocationSnapshot> roots = new ArrayList<CompleteFileSystemLocationSnapshot>();
                if (treeSnapshot == null) {
                    MissingFileSnapshot missingFileSnapshot = new MissingFileSnapshot(internedAbsolutePath, FileMetadata.AccessType.DIRECT);
                    DefaultBuildCacheCommandFactory.this.virtualFileSystem.updateWithKnownSnapshot((CompleteFileSystemLocationSnapshot)missingFileSnapshot);
                    builder.put((Object)treeName, (Object)fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                switch (type) {
                    case FILE: {
                        if (treeSnapshot.getType() != FileType.RegularFile) {
                            throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", treeName, treeSnapshot.getType()));
                        }
                        roots.add(treeSnapshot);
                        DefaultBuildCacheCommandFactory.this.virtualFileSystem.updateWithKnownSnapshot(treeSnapshot);
                        break;
                    }
                    case DIRECTORY: {
                        roots.add(treeSnapshot);
                        DefaultBuildCacheCommandFactory.this.virtualFileSystem.updateWithKnownSnapshot(treeSnapshot);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                builder.put((Object)treeName, (Object)DefaultCurrentFileCollectionFingerprint.from(roots, (FingerprintingStrategy)fingerprintingStrategy));
            });
            return builder.build();
        }
    }
}

