/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.health.DaemonHealthCheck;
import org.gradle.launcher.daemon.server.health.DaemonHealthStats;
import org.gradle.launcher.daemon.server.health.HealthLogger;

public class LogAndCheckHealth
implements DaemonCommandAction {
    private static final Logger LOG = Logging.getLogger(LogAndCheckHealth.class);
    private final DaemonHealthStats stats;
    private final DaemonHealthCheck healthCheck;
    private final HealthLogger logger;

    public LogAndCheckHealth(DaemonHealthStats stats, DaemonHealthCheck healthCheck) {
        this(stats, healthCheck, new HealthLogger());
    }

    @VisibleForTesting
    LogAndCheckHealth(DaemonHealthStats stats, DaemonHealthCheck healthCheck, HealthLogger logger) {
        this.stats = stats;
        this.healthCheck = healthCheck;
        this.logger = logger;
    }

    @Override
    public void execute(DaemonCommandExecution execution) {
        if (execution.isSingleUseDaemon()) {
            execution.proceed();
            return;
        }
        this.logger.logHealth(this.stats, LOG);
        execution.proceed();
        this.healthCheck.executeHealthCheck();
    }
}

