/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationMapper;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassConstructorDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J2\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "reportDeprecatedJavaAnnotation", "reportErrorsOnPositionedArguments", "reportOnValueArgument", "arguments", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "frontend.java"})
public final class JavaAnnotationCallChecker
implements CallChecker {
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Object obj = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
                CallableDescriptor callableDescriptor = obj.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"resolvedCall.resultingDescriptor.original");
                CallableDescriptor resultingDescriptor = callableDescriptor;
                if (!(resultingDescriptor instanceof JavaClassConstructorDescriptor)) break block2;
                ClassDescriptor classDescriptor2 = ((JavaClassConstructorDescriptor)resultingDescriptor).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"resultingDescriptor.containingDeclaration");
                if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS) break block3;
            }
            return;
        }
        this.reportErrorsOnPositionedArguments(resolvedCall2, context2);
        this.reportDeprecatedJavaAnnotation(resolvedCall2, context2);
    }

    private final void reportDeprecatedJavaAnnotation(ResolvedCall<?> resolvedCall2, CallCheckerContext context2) {
        block5: {
            FqName fqName2;
            boolean bl;
            ClassifierDescriptor classifierDescriptor;
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            KtElement ktElement = call2.getCallElement();
            if (!(ktElement instanceof KtAnnotationEntry)) {
                ktElement = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            KotlinType kotlinType = (KotlinType)context2.getTrace().get(BindingContext.TYPE, annotationEntry.getTypeReference());
            if (kotlinType == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context.trace.get(Bindin\u2026.typeReference) ?: return");
            KotlinType type2 = kotlinType;
            Object object = JavaAnnotationMapper.INSTANCE.getJavaToKotlinNameMap();
            ClassifierDescriptor classifierDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor2 != null) {
                classifierDescriptor = classifierDescriptor2;
                bl = false;
                boolean bl2 = false;
                ClassifierDescriptor it = classifierDescriptor;
                boolean bl3 = false;
                fqName2 = DescriptorUtils.getFqNameSafe(it);
            } else {
                fqName2 = null;
            }
            classifierDescriptor = fqName2;
            bl = false;
            FqName fqName3 = object.get(classifierDescriptor);
            if (fqName3 == null) break block5;
            object = fqName3;
            boolean bl4 = false;
            bl = false;
            Object it = object;
            boolean bl5 = false;
            context2.getTrace().report(ErrorsJvm.DEPRECATED_JAVA_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry), (FqName)it));
        }
    }

    private final void reportErrorsOnPositionedArguments(ResolvedCall<?> resolvedCall2, CallCheckerContext context2) {
        Map<ValueParameterDescriptor, ResolvedValueArgument> $this$forEach$iv = Companion.getJavaAnnotationCallValueArgumentsThatShouldBeNamed(resolvedCall2);
        boolean $i$f$forEach = false;
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> element$iv;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> it = element$iv = iterator2.next();
            boolean bl2 = false;
            DiagnosticFactory0<KtExpression> diagnosticFactory0 = ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"ErrorsJvm.POSITIONED_VAL\u2026UMENT_FOR_JAVA_ANNOTATION");
            this.reportOnValueArgument(context2, it, diagnosticFactory0);
        }
    }

    private final void reportOnValueArgument(CallCheckerContext context2, Map.Entry<? extends ValueParameterDescriptor, ? extends ResolvedValueArgument> arguments2, DiagnosticFactory0<KtExpression> diagnostic) {
        for (ValueArgument valueArgument : arguments2.getValue().getArguments()) {
            KtExpression argumentExpression;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            context2.getTrace().report(diagnostic.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaAnnotationCallChecker$Companion;", "", "()V", "getJavaAnnotationCallValueArgumentsThatShouldBeNamed", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "frontend.java"})
    public static final class Companion {
        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedValueArgument> getJavaAnnotationCallValueArgumentsThatShouldBeNamed(@NotNull ResolvedCall<?> resolvedCall) {
            Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
            v0 = resolvedCall.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(v0, (String)"resolvedCall.valueArguments");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var4_4 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            var7_7 = $this$filterTo$iv$iv;
            var8_8 = false;
            var9_9 = var7_7.entrySet().iterator();
            while (var9_9.hasNext()) {
                p = element$iv$iv = var9_9.next();
                $i$a$-filter-JavaAnnotationCallChecker$Companion$getJavaAnnotationCallValueArgumentsThatShouldBeNamed$1 = false;
                if (!(Intrinsics.areEqual((Object)((ValueParameterDescriptor)p.getKey()).getName(), (Object)JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ^ true) || !(p.getValue() instanceof ExpressionValueArgument)) ** GOTO lbl-1000
                v1 = p.getValue();
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
                }
                v2 = ((ExpressionValueArgument)v1).getValueArgument();
                if (!(v2 != null ? v2.isNamed() : true)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            return destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

